(function(window){'use strict';function SelectorSet(){if(!(this instanceof SelectorSet)){return new SelectorSet();}
this.size=0;this.uid=0;this.selectors=[];this.indexes=Object.create(this.indexes);this.activeIndexes=[];}
var docElem=window.document.documentElement;var matches=(docElem.webkitMatchesSelector||docElem.mozMatchesSelector||docElem.oMatchesSelector||docElem.msMatchesSelector);SelectorSet.prototype.matchesSelector=function(el,selector){return matches.call(el,selector);};SelectorSet.prototype.querySelectorAll=function(selectors,context){return context.querySelectorAll(selectors);};SelectorSet.prototype.indexes=[];var idRe=/^#((?:[\w\u00c0-\uFFFF\-]|\\.)+)/g;SelectorSet.prototype.indexes.push({name:'ID',selector:function matchIdSelector(sel){var m;if(m=sel.match(idRe)){return m[0].slice(1);}},element:function getElementId(el){if(el.id){return[el.id];}}});var classRe=/^\.((?:[\w\u00c0-\uFFFF\-]|\\.)+)/g;SelectorSet.prototype.indexes.push({name:'CLASS',selector:function matchClassSelector(sel){var m;if(m=sel.match(classRe)){return m[0].slice(1);}},element:function getElementClassNames(el){var className=el.className;if(className){if(typeof className==='string'){return className.split(/\s/);}else if(className instanceof SVGAnimatedString){return className.baseVal.split(/\s/);}}}});var tagRe=/^((?:[\w\u00c0-\uFFFF\-]|\\.)+)/g;SelectorSet.prototype.indexes.push({name:'TAG',selector:function matchTagSelector(sel){var m;if(m=sel.match(tagRe)){return m[0].toUpperCase();}},element:function getElementTagName(el){return[el.nodeName.toUpperCase()];}});SelectorSet.prototype.indexes['default']={name:'UNIVERSAL',selector:function(){return true;},element:function(){return[true];}};var Map;if(typeof window.Map==='function'){Map=window.Map;}else{Map=(function(){function Map(){this.map={};}
Map.prototype.get=function(key){return this.map[key+' '];};Map.prototype.set=function(key,value){this.map[key+' ']=value;};return Map;})();}
var chunker=/((?:\((?:\([^()]+\)|[^()]+)+\)|\[(?:\[[^\[\]]*\]|['"][^'"]*['"]|[^\[\]'"]+)+\]|\\.|[^ >+~,(\[\\]+)+|[>+~])(\s*,\s*)?((?:.|\r|\n)*)/g;function parseSelectorIndexes(allIndexes,selector){allIndexes=allIndexes.slice(0).concat(allIndexes['default']);var allIndexesLen=allIndexes.length,i,j,m,dup,rest=selector,key,index,indexes=[];do{chunker.exec('');if(m=chunker.exec(rest)){rest=m[3];if(m[2]||!rest){for(i=0;i<allIndexesLen;i++){index=allIndexes[i];if(key=index.selector(m[1])){j=indexes.length;dup=false;while(j--){if(indexes[j].index===index&&indexes[j].key===key){dup=true;break;}}
if(!dup){indexes.push({index:index,key:key});}
break;}}}}}while(m);return indexes;}
function findByPrototype(ary,proto){var i,len,item;for(i=0,len=ary.length;i<len;i++){item=ary[i];if(proto.isPrototypeOf(item)){return item;}}}
SelectorSet.prototype.logDefaultIndexUsed=function(){};SelectorSet.prototype.add=function(selector,data){var obj,i,indexProto,key,index,objs,selectorIndexes,selectorIndex,indexes=this.activeIndexes,selectors=this.selectors;if(typeof selector!=='string'){return;}
obj={id:this.uid++,selector:selector,data:data};selectorIndexes=parseSelectorIndexes(this.indexes,selector);for(i=0;i<selectorIndexes.length;i++){selectorIndex=selectorIndexes[i];key=selectorIndex.key;indexProto=selectorIndex.index;index=findByPrototype(indexes,indexProto);if(!index){index=Object.create(indexProto);index.map=new Map();indexes.push(index);}
if(indexProto===this.indexes['default']){this.logDefaultIndexUsed(obj);}
objs=index.map.get(key);if(!objs){objs=[];index.map.set(key,objs);}
objs.push(obj);}
this.size++;selectors.push(selector);};SelectorSet.prototype.remove=function(selector,data){if(typeof selector!=='string'){return;}
var selectorIndexes,selectorIndex,i,j,k,selIndex,objs,obj;var indexes=this.activeIndexes;var removedIds={};var removeAll=arguments.length===1;selectorIndexes=parseSelectorIndexes(this.indexes,selector);for(i=0;i<selectorIndexes.length;i++){selectorIndex=selectorIndexes[i];j=indexes.length;while(j--){selIndex=indexes[j];if(selectorIndex.index.isPrototypeOf(selIndex)){objs=selIndex.map.get(selectorIndex.key);if(objs){k=objs.length;while(k--){obj=objs[k];if(obj.selector===selector&&(removeAll||obj.data===data)){objs.splice(k,1);removedIds[obj.id]=true;}}}
break;}}}
this.size-=Object.keys(removedIds).length;};function sortById(a,b){return a.id-b.id;}
SelectorSet.prototype.queryAll=function(context){if(!this.selectors.length){return[];}
var matches={},results=[];var els=this.querySelectorAll(this.selectors.join(', '),context);var i,j,len,len2,el,m,match,obj;for(i=0,len=els.length;i<len;i++){el=els[i];m=this.matches(el);for(j=0,len2=m.length;j<len2;j++){obj=m[j];if(!matches[obj.id]){match={id:obj.id,selector:obj.selector,data:obj.data,elements:[]};matches[obj.id]=match;results.push(match);}else{match=matches[obj.id];}
match.elements.push(el);}}
return results.sort(sortById);};SelectorSet.prototype.matches=function(el){if(!el){return[];}
var i,j,k,len,len2,len3,index,keys,objs,obj,id;var indexes=this.activeIndexes,matchedIds={},matches=[];for(i=0,len=indexes.length;i<len;i++){index=indexes[i];keys=index.element(el);if(keys){for(j=0,len2=keys.length;j<len2;j++){if(objs=index.map.get(keys[j])){for(k=0,len3=objs.length;k<len3;k++){obj=objs[k];id=obj.id;if(!matchedIds[id]&&this.matchesSelector(el,obj.selector)){matchedIds[id]=true;matches.push(obj);}}}}}}
return matches.sort(sortById);};window.SelectorSet=SelectorSet;})(window);