var ConferencesproC = UCPMC.extend({
	init: function() {
		this.socket = null;
		this.subscribed = 0;
		this.wasTalking = {};
	},
	startRoom: function(locked) {
		var Conferencespro = this;
		if (!$(".conference-data").is(":visible")) {
			$(".conference .message").show();
			$(".conference-no-data").fadeOut("slow", function() {
				$(".conference-data").show();
				if (locked) {
					$("#Locked").text(_("Yes"));
					$("#lock i").removeClass("fa-unlock");
					$("#lock i").addClass("fa-lock");
				} else {
					$("#Locked").text(_("No"));
					$("#lock i").removeClass("fa-lock");
					$("#lock i").addClass("fa-unlock");
				}
			});
			this.bind();
		}
	},
	endRoom: function() {
		var Conferencespro = this;
		if ($(".conference-data").is(":visible")) {
			$(".conference-data").fadeOut("slow", function() {
				$(".conference-no-data").show();
				$(".conference .message").show();
			});
		}
	},
	updateTalk: function(channel, talking) {
		var Conferencespro = this,
				id = channel.replace(/[^a-z0-9\-]/ig, "");
		if (talking) {
			$("#" + id + " .user .fa-volume-up").removeClass("hidden");
		} else {
			$("#" + id + " .user .fa-volume-up").addClass("hidden");
		}
	},
	updateUser: function(channel, type) {
		var Conferencespro = this,
				id = channel.replace(/[^a-z0-9\-]/ig, "");
		switch (type) {
			case "waiting":
				$("#" + id + " .muter").addClass("hidden");
				$("#" + id + " .muter .mute").addClass("muted");
				$("#" + id + " .user .fa-user").prop("class", "fa fa-user muted");
				$("#" + id + " .user .fa-volume-up").addClass("hidden");
			break;
			case "muted":
				$("#" + id + " .muter").removeClass("hidden");
				$("#" + id + " .muter .mute").addClass("muted");
				$("#" + id + " .user .fa-user").prop("class", "fa fa-user muted");

				//track the talking state when muted as Asterisk keeps the state
				//"true" until the channel is unlocked, meaning no talk monitoring
				//is done unitl after the user is unmuted, therefore the states stay
				//the same
				if(!$("#" + id + " .user .fa-volume-up").hasClass("hidden")) {
					$("#" + id + " .user .fa-volume-up").addClass("hidden");
					this.wasTalking[id] = true;
				}
			break;
			case "admin":
				$("#" + id).data("admin", "yes");
				$("#" + id + " .muter").removeClass("hidden");
				$("#" + id + " .muter .mute").removeClass("muted");
				$("#" + id + " .user .fa-user").prop("class", "fa fa-user admin");
			break;
			default:
				$("#" + id + " .muter").removeClass("hidden");
				$("#" + id + " .muter .mute").removeClass("muted");
				if ($("#" + id).data("admin") == "yes") {
					$("#" + id + " .user .fa-user").prop("class", "fa fa-user admin");
				} else {
					$("#" + id + " .user .fa-user").prop("class", "fa fa-user");
				}

				//Part of talking tracking
				if(typeof this.wasTalking[id] !== "undefined" && $("#" + id + " .user .fa-volume-up").hasClass("hidden")) {
					$("#" + id + " .user .fa-volume-up").removeClass("hidden");
					delete(this.wasTalking[id]);
				}
			break;

		}
	},
	addUser: function(channel, cnam, cnum, type) {
		var Conferencespro = this,
				kick = (appType == "app_confbridge") ? "<td><i class=\"fa fa-times kick\"></i></td>" : "",
				id = channel.replace(/[^a-z0-9\-]/ig, ""),
				count = $("#Parties").text(),
				displayName = (cnam != cnum) ? cnam + " &lt;" + cnum + "&gt;" : cnum;
		$(".conference .message").hide();
		$(".conference table").append(
			"<tr id=\"" + id +
			"\" data-admin=\"" + ((type == "admin") ? "yes" : "no") + "\"" +
			"\" data-channel=\"" + encodeURIComponent(channel) + "\">" +
			"<td class=\"user\"><i class=\"fa fa-user " + ((type == "waiting") ? "muted" : type) +
			"\"></i><i class=\"fa fa-volume-up hidden\"></i> " + displayName +
			"</td><td><span class=\"fa-stack muter " + ((type == "waiting") ? "hidden" : "") + "\">" +
			"<i class=\"fa fa-volume-off fa-stack-1x\"></i>" +
			"<i class=\"fa fa-ban fa-stack-1x mute " +
			((type == "muted") ? "muted" : "") + "\"></i></span></td>" + kick +
			"</tr>").hide().fadeIn("slow");
			count = parseInt(count) + 1;
			$("#Parties").text(count);
		this.bind();
	},
	removeUser: function(channel) {
		var Conferencespro = this;
		var id = channel.replace(/[^a-z0-9\-]/ig, ""),
				count = $("#Parties").text();
		$("#" + id).fadeOut("slow", function() {
			$(this).remove();
		});
		count = parseInt(count) - 1;
		$("#Parties").text(count);
	},
	prepoll: function(data) {
		var Conferencespro = this;
		return { websocket: (this.socket !== null && this.socket.connected) };
	},
	poll: function(data, url) {
		var Conferencespro = this;
		if (this.socket === null || !this.socket.connected) {
			if (data.status && data.conference !== false) {
				$(".conference-room #Locked").text(data.conference.Locked);
				$(".conference-room #Marked").text(data.conference.Marked);
				var channels = [];
				if (data.status && data.conference !== false && !$(".conference-data").is(":visible")) {
					Conferencespro.startRoom();
				}
				$.each(data.conference.users, function(index, value) {
					channels.push(value.ChannelClean);
					if ($("#" + value.ChannelClean).length) {
						Conferencespro.updateUser(value.Channel, value.type);
					} else {
						Conferencespro.addUser(value.Channel, value.CallerIDName, value.CallerIDNum, value.type);
					}
				});
				$.each($(".conference table tr"), function() {
					if (jQuery.inArray( $(this).prop("id"), channels ) < 0) {
						var id  = $(this).prop("id");
						Conferencespro.removeUser(id);
					}
				});
			} else if (data.status && data.conference === false && $(".conference-data").is(":visible")){
				$.each($(".conference table tr"), function() {
					var id  = $(this).prop("id");
					Conferencespro.removeUser(id);
				});
				Conferencespro.endRoom();
			}
		}
	},
	sendEvent: function(key, value) {
		var Conferencespro = this;
		if (this.socket !== null && this.socket.connected) {
			Conferencespro.socket.emit(key, value);
		}
	},
	display: function(event) {
		var Conferencespro = this,
				data = {},
				subscribed = (typeof $.url().param("sub") !== "undefined") ? $.url().param("sub") : 0,
				page = (typeof $.url().param("view") !== "undefined") ? $.url().param("view") : "room";

		if ($.support.pjax) {
			$(document).on("click", "[vm-pjax] a, a[vm-pjax]", function(event) {
				var container = $("#dashboard-content");
				$.pjax.click(event, { container: container });
			});
		}

		$(".conferencesettings input[type!=\"checkbox\"], .conferencesettings select").change(function() {
			Conferencespro.saveSettings({ key: $(this).prop("name"), value: $(this).val() });
		});
		$(".conferencesettings input[type=\"checkbox\"]").change(function() {
			var val = "";
			if ($(this).is(":checked")) {
				val = $(this).val();
			}
			Conferencespro.saveSettings({ key: $(this).prop("name"), value: val });
		});
		$("#module-page-conferencespro .inviteAction button").click(function() {
			UCP.showDialog(_("Invite to Conference"),
				"<label for=\"type\">User Type</label><select id=\"type\" class=\"form-control\"><option value=\"user\">User</option><option value=\"admin\">Admin</option></select><label for=\"invite\">" + _("Number") + ":</label><select class=\"form-control Tokenize Fill\" id=\"invite\" multiple></select><button class=\"btn btn-default\" id=\"inviteConference\" style=\"margin-left: 72px;\">" + _("Invite") + "</button>",
				200,
				250,
				function() {
					$("#invite").tokenize({
						maxElements: 1,
						datas: "index.php?quietmode=1&module=conferencespro&command=contacts&conference=" + conference
					});
					var to = "";
					$("#inviteConference").click(function() {
						setTimeout(function() {
							to = ($("#invite").val() !== null) ? $("#invite").val()[0] : "",
							type = $("#type").val();
							Conferencespro.invite(to, type);
							UCP.closeDialog();
						}, 50);
					});
					$("#invite").keypress(function(event) {
						if (event.keyCode == 13) {
							setTimeout(function() {
								to = ($("#invite").val() !== null) ? $("#invite").val()[0] : "",
								type = $("#type").val();
								Conferencespro.invite(to, type);
								UCP.closeDialog();
							}, 50);
						}
					});
				}
			);
		});
		this.bind();
		if (this.subscribed != "0") {
			this.sendEvent("unsubscribe", this.subscribed);
		}
		if (page == "room") {
			this.sendEvent("subscribe", subscribed);
			this.subscribed = subscribed;
			Conferencespro.sendEvent("list", subscribed);
		}
	},
	hide: function(event) {
		var Conferencespro = this;
		$(document).off("click", "[vm-pjax] a, a[vm-pjax]");
		if (this.subscribed != "0") {
			this.sendEvent("unsubscribe", this.subscribed);
			this.subscribed = 0;
		}
	},
	bind: function() {
		var Conferencespro = this;
		$("#lock").off("click");
		$(".conference table .mute").off("click");
		$(".conference table .kick").off("click");
		$(".conference table .mute").click(function() {
			var item = $(this).parents("tr"),
					channel = item.data("channel"),
					user = $(this);
			if ($(this).hasClass("muted")) {
				if (Conferencespro.socket !== null && Conferencespro.socket.connected) {
					Conferencespro.sendEvent("mute", {
						conference: conference,
						channel: decodeURIComponent(channel),
						enable: false
					});
				} else {
					user.removeClass("muted");
					user.parents("tr").find(".user .fa-user").removeClass("muted");
					$.post( "index.php?quietmode=1&module=conferencespro&command=unmute", { channel: channel, conference: conference }, function( data ) {
						if (!data.status) {
							user.addClass("muted");
							user.parents("tr").find(".user .fa-user").addClass("muted");
							alert(data.message);
						}
					});
				}
			} else {
				if (Conferencespro.socket !== null && Conferencespro.socket.connected) {
					Conferencespro.sendEvent("mute", {
						conference: conference,
						channel: decodeURIComponent(channel),
						enable: true
					});
				} else {
					user.addClass("muted");
					user.parents("tr").find(".user .fa-user").addClass("muted");
					$.post( "index.php?quietmode=1&module=conferencespro&command=mute", { channel: channel, conference: conference }, function( data ) {
						if (!data.status) {
							user.removeClass("muted");
							user.parents("tr").find(".user .fa-user").removeClass("muted");
							alert(data.message);
						}
					});
				}
			}
		});
		$(".conference table .kick").click(function() {
			var item = $(this).parents("tr"),
					channel = item.data("channel");
			if (Conferencespro.socket !== null && Conferencespro.socket.connected) {
				Conferencespro.sendEvent("kick", {
					conference: conference,
					channel: decodeURIComponent(channel)
				});
			} else {
				$.post( "index.php?quietmode=1&module=conferencespro&command=kick", { channel: channel, conference: conference }, function( data ) {
					if (data.status) {
						item.fadeOut("slow", function() {
							item.remove();
						});
					} else {
						alert(data.message);
					}
				});
			}
		});
		$("#lock").click(function() {
			var item = $(this).find("i");
			if (item.hasClass("fa-unlock")) {
				if (Conferencespro.socket !== null && Conferencespro.socket.connected) {
					Conferencespro.sendEvent("lock", {
						conference: conference,
						enable: true
					});
				} else {
					$("#lock i").removeClass("fa-unlock");
					$("#lock i").addClass("fa-lock");
					$("#Locked").text(_("Yes"));
					$.post( "index.php?quietmode=1&module=conferencespro&command=lock", { conference: conference }, function( data ) {
						if (!data.status) {
							$("#lock i").addClass("fa-unlock");
							$("#lock i").removeClass("fa-lock");
							$("#Locked").text(_("No"));
							alert(data.message);
						}
					});
				}
			} else {
				if (Conferencespro.socket !== null && Conferencespro.socket.connected) {
					Conferencespro.sendEvent("lock", {
						conference: conference,
						enable: false
					});
				} else {
					$.post( "index.php?quietmode=1&module=conferencespro&command=unlock", { conference: conference }, function( data ) {
						$("#lock i").addClass("fa-unlock");
						$("#lock i").removeClass("fa-lock");
						$("#Locked").text(_("No"));
						if (!data.status) {
							$("#lock i").removeClass("fa-unlock");
							$("#lock i").addClass("fa-lock");
							$("#Locked").text(_("Yes"));
							alert(data.message);
						}
					});
				}
			}
		});
	},
	windowState: function(state) {
		//console.log(state);
	},
	saveSettings: function(data) {
		var Conferencespro = this;
		data.conference = conference;
		$.post( "index.php?quietmode=1&module=conferencespro&command=settings", data, function( data ) {
			$(".conferencesettings #message").text(data.message).addClass("alert-" + data.alert).fadeIn("fast", function() {
				$(this).delay(5000).fadeOut("fast");
			});
		});
	},
	invite: function(invite, type) {
		var Conferencespro = this,
				c = (typeof conference !== "undefined") ? conference : 0;
		$.post( "index.php?quietmode=1&module=conferencespro&command=invite", { channel: invite, conference: c, type: type }, function( data ) {

		});
	},
	disconnect: function() {
		var Conferencespro = this,
				listeners = [ "disconnect",
													"connect",
													"lock",
													"mute",
													"join",
													"leave",
													"starting",
													"ending",
													"talking" ];
		if (this.socket !== null) {
			$.each(listeners, function(i, v) {
				Conferencespro.socket.removeAllListeners(v);
			});
		}
	},
	connect: function() {
		var Conferencespro = this;
		try {
			UCP.wsconnect("conferences", function(socket) {
				if (socket === false) {
					Conferencespro.socket = null;
					return false;
				} else {
					Conferencespro.socket = socket;
					if (Conferencespro.subscribed > 0) {
						Conferencespro.sendEvent("subscribe", Conferencespro.subscribed);
					}
					Conferencespro.socket.on("list", function(data) {
						if (data !== null) {
							var conf = data;
							Conferencespro.startRoom(conf.locked);
							$.each(conf.users, function(i, u) {
								var type = "user";
								if (u.admin) {
									type = "admin";
								} else if (u.waiting) {
									type = "waiting";
								}
								if (u.muted) {
									type = "muted";
								}
								Conferencespro.updateUser(u.channel, type);
								Conferencespro.updateTalk(u.channel, u.talking);
							});
						}
					});
					Conferencespro.socket.on("mute", function(data) {
						Conferencespro.updateUser(data.channel, (data.enabled ? "muted" : ""));
					});
					Conferencespro.socket.on("lock", function(data) {
						if (data.enabled) {
							$("#lock i").removeClass("fa-unlock");
							$("#lock i").addClass("fa-lock");
							$("#Locked").text(_("Yes"));
						} else {
							$("#lock i").addClass("fa-unlock");
							$("#lock i").removeClass("fa-lock");
							$("#Locked").text(_("No"));
						}
					});
					Conferencespro.socket.on("join", function(data) {
						Conferencespro.addUser(data.channel, data.calleridname, data.calleridnum, "user");
						//have to ask for the list because we don't get user state on join
						Conferencespro.sendEvent("list", data.conference);
					});
					Conferencespro.socket.on("leave", function(data) {
						Conferencespro.removeUser(data.channel);
					});
					Conferencespro.socket.on("starting", function(data) {
						Conferencespro.sendEvent("list", data.conference);
					});
					Conferencespro.socket.on("ending", function(data) {
						Conferencespro.endRoom();
					});
					Conferencespro.socket.on("talking", function(data) {
						Conferencespro.updateTalk(data.channel, data.enabled);
					});

					//page has been refreshed right onto this page so list the conference now
					if($.url().param("mod") == "conferencespro" && $.url().param("view") == "room") {
						Conferencespro.sendEvent("list", $.url().param("sub"));
					}
				}
			});
		}catch (err) {}
	}
}), Conferencespro = new ConferencesproC();
