var EndpointC = UCPMC.extend({
	init: function() {

	},
	poll: function(data) {

	},
	display: function(event) {
		$(".saveTemplate").click(function(event) {
			event.preventDefault();
			event.stopPropagation();
			
			var e = document.getElementById("task");
			var task = e.options[e.selectedIndex].value;

                        var data = $("#module-page-endpoint form");

			var formData = {};
			data.serializeArray().forEach(function(x) { 
				//For blf keys, the ucp gui is saving the state key name with [] at the end.  
				//This ends up causing problems, and will be stripped:
				//ex. S700_linekeys_2_state[] = 'Audio '
				//Also, the state value comes in as a string, but is expected to be an array 
				//in the POST, which can have up to 2 items, ex. ['Audio ', 'Visual ']  
				if (x.name.match(/_linekeys_/) && x.name.match(/_state\[\]$/)) { 
					x.name = x.name.replace(/\[\]$/, '');
					if (formData[x.name]) { 
						formData[x.name].push(x.value);
					} else {
						formData[x.name] = new Array(x.value);
					}
				} else {
					formData[x.name] = x.value; 
				}
			});

			//save not needed, because we always save, option is just for looks
			if (task == 'rebuild') {
			        formData['rebuild'] = "1";
			}
			if (task == 'restart') {
				formData['rebuild'] = "1";
				formData['restart'] = "1";
			}
			if (task == 'reset') {
				formData['reset'] = "1";
			}
			$.post("index.php?quietmode=1&module=endpoint&command=savesettings", { data : JSON.stringify(formData) } , function( data ) {
				if (data.status) {
					$.pjax.reload('#dashboard-content');
					return true;
				} else {
					return false;
				}
			});
		});
	},
	hide: function(event) {
		$(".saveTemplate").off("click");
		$(".saveAdmin").off("click");
	}
});

$(document).ready(function() {
	//display key types
	$(document).on('change', '.keyType', function() {
		var name = $(this).prop('name');
		var length = name.length;
		name = name.substr(8, length);
		$(".hideKeys").hide();
		$("#" + name).show();
	});

		$(document).on('change', '.type', function() {
		var name = $(this).prop('name');
		var length = name.length;
		name = name.substr(0, length - 4);
		
		if($("#" + name + 'acct').val() == ''){
			$("#" + name + 'acct').val('account1')
		} else {
			if($(this).find("option:selected").text() == 'Blank'){
				$("#" + name + 'acct').val('');
				$("#" + name + 'label').val('');
				$("#" + name + 'value').val('');
			}
		}
		
		
		switch($(this).find("option:selected").text()){
			//line keys first
			case 'Line':
				$("." + name + 'value').hide();
				$("." + name + 'valueFill').show();
				$("." + name + 'label').hide();
				$("." + name + 'labelFill').show();
				$("#" + name + 'xml').hide();
				$("." + name + 'state').hide();
				break;
			
			//now xml-api
			case 'XML-API':
				$("#" + name + 'xml').show();
				$("." + name + 'value').show();
				$("#" + name + 'value').hide();
				$("." + name + 'valueFill').hide();
				$("." + name + 'label').show();
				$("." + name + 'labelFill').hide();
				$("." + name + 'state').hide();
				break;

			//now park
			case 'Call Park':
				$("#" + name + 'park').show();
				$("#" + name + 'xml').hide();
				$("." + name + 'value').hide();
				$("#" + name + 'value').hide();
				$("." + name + 'valueFill').hide();
				$("." + name + 'label').show();
				$("." + name + 'labelFill').hide();
				$("." + name + 'state').hide();
				break;

			case 'Voicemail':
			case 'Intercom':
			case 'DND':
			case 'Record':
			case 'LDAP':
				$("#" + name + 'park').hide();
				$("#" + name + 'xml').hide();
				$("." + name + 'value').hide();
				$("#" + name + 'value').hide();
				$("." + name + 'valueFill').show();
				$("#" + name + 'label').val($(this).find("option:selected").text());
				$("." + name + 'labelFill').hide();
				$("." + name + 'state').hide();
				break;

			case 'BLF':
				$("." + name + 'state').show();
				break;

			default:
				$("#" + name + 'xml').hide();
				$("#" + name + 'value').show();
				$("." + name + 'value').show();
				$("." + name + 'valueFill').hide();
				$("." + name + 'label').show();
				$("." + name + 'labelFill').hide();
				$("#" + name + 'park').hide();
				$("." + name + 'state').hide();
				break;
		}
	});

	$(document).on('click', '.blfAlert, .none', function(e){
		var clickedInput = $(this);
		var parent = $(this).parent();
		if (clickedInput.hasClass('none')) {
			var allChildInputs = parent.children('input.blfAlert'); 
		} else {
			var allChildInputs = parent.children('input.none'); 
		}
		allChildInputs.each(function(k,v) {
			$(this).prop('checked', false);
		}); 
		
		clickedInput.prop('checked', true);
	});
});
