//$("#fax-grid").bootstrapTable('showRow', {index: 1444166808988, isIdField: true})
var FaxproC = UCPMC.extend({
	init: function() {
		this.presend = false;
		this.forwardID = null;
		this.initalized = false;
		this.faxData = { files: [] };
		this.noFaxes = "<tr class=\"fax-message\"><td colspan=\"8\">No Faxes</td></tr>";
	},
	contactClickOptions: function(type) {
		if (type != "number" || false) {
			return false;
		}
		return [ { text: _("Send Fax"), function: "contactClickInitiate", type: "fax" } ];
	},
	contactClickInitiate: function(did) {
		$.pjax({ url: "?display=dashboard&mod=faxpro&view=send&destination=" + did, container: "#dashboard-content" });
	},
	poll: function(data) {
		if (data.status) {
			$("#usage").text(data.usage + "%");
			if ($("#faxpro-badge").text() < data.new) {
				var notify = 0, plural = notify > 1 ? "es" : "", faxproNotification;
				notify = data.new - $("#faxpro-badge").text();
				if (notify > 0) {
					if (UCP.notify) {
						faxproNotification = new Notify("Fax", {
							body: sprintf(_("You Have %s New Fax"), notify),
							icon: "modules/Faxpro/assets/images/fax.png"
						});
						faxproNotification.show();
					}
					if ($("#no-messages").length) {
						$("#no-messages").fadeOut("slow");
					}

				}
			}
			$("#faxpro-badge").text(data.new);

			if ($.url().param("view") == "send" && this.presend) {
				$("#message").html(_("Sending") + "<br>" + _("Check Outgoing for more information"));
				this.presend = false;
			}
			$.each(data.folderCounts, function( index, value ) {
				if ($(".folder[data-folder=\"" + value.folder + "\"] .badge").text() < value.count) {
					$(".folder[data-folder=\"" + value.folder + "\"]").effect("highlight", {}, 1500);
				}
				if ($.url().param("folder") != "out" && $.url().param("folder") == value.folder && $(".folder[data-folder=\"" + value.folder + "\"] .badge").text() != value.count) {
					if(typeof $.cookie('vm-refresh') === "undefined" || $.cookie('vm-refresh') == 1) {
						$('#fax-grid').bootstrapTable('refresh', {silent: true});
					}
				}
				$(".folder[data-folder=\"" + value.folder + "\"] .badge").text(value.count);
			});
			if($.url().param("folder") == "out") {
				$("#fax-grid").bootstrapTable('refresh', {silent: true});
			}
		}
	},
	display: function(event) {
		var $this = this, initalDropMessage = $(".faxsend .filedrop .message").html();
		$("#destination").tokenize({
			maxElements: 1,
			datas: "index.php?quietmode=1&module=faxpro&command=contacts"
		});
		$(document).on("click", "[vm-pjax] a, a[vm-pjax]", function(event) {
			var container = $("#dashboard-content");
			$.pjax.click(event, { container: container });
		});
		var fq = $.cookie("faxquality");
		if(typeof fq !== "undefined") {
			$("#faxresolution").val(fq);
		}
		$("#faxresolution").change(function() {
			$.cookie("faxquality",$(this).val());
		});
		$('#fax-grid').on("check.bs.table uncheck.bs.table check-all.bs.table uncheck-all.bs.table", function () {
			var sel = $(this).bootstrapTable('getAllSelections'),
					dis = true;
			if(sel.length) {
				dis = false;
			}
			$("#delete-selection").prop("disabled",dis);
			$("#forward-selection").prop("disabled",dis);
		});

		$("#delete-selection").click(function() {
			if (confirm(_("Are you sure you wish to delete these faxes?"))) {
				var sel = $('#fax-grid').bootstrapTable('getAllSelections');
				$.each(sel, function(i, v){
					$this.deleteFax(v.faxid, false, function(data) {
						if(data.status) {
							$('#fax-grid').bootstrapTable('hideRow', {index: v.faxid, isIdField: true});
						}
					});
				});
				$('#fax-grid').bootstrapTable('refresh', {silent: true});
				$("#delete-selection").prop("disabled",true);
			}
		});

		$(".faxsend input[type=\"file\"]").fileupload({
			url: "?quietmode=1&module=faxpro&command=upload",
			dropZone: $(".faxsend .filedrop"),
			dataType: "json",
			add: function(e, data) {
				var badFile = null;
				$.each(data.files, function(i, v) {
					if(v.size > maxFileSize.size) {
						badFile = v;
						return false;
					}
				});
				if(badFile === null) {
					$(".faxsend .filedrop .message").text(_("Uploading..."));
					data.submit();
				} else {
					$(".faxsend .filedrop .message").text(sprintf(_("File was too large. Please reduce the file size or increase %s"), maxFileSize.type));
					data.abort();
				}
			},
			done: function(e, data) {
				if (data.result.status) {
					var html = "<li id=\"attachment-" + data.result.id + "\" class=\"list-group-item attachment\" data-filename=\"" + data.result.localfilename + "\">" +
					"<div>" + data.result.filename + " <div class='icons'>" +
					"<a target='_blank' href='?quietmode=1&module=faxpro&command=viewtemp&faxid=" + data.result.localfilename + "'><i class=\"fa fa-file-pdf-o\"></i></a>" +
					"<a onclick=\"UCP.Modules.Faxpro.deleteAttachment('" + data.result.id + "')\"><i class=\"fa fa-trash-o\"></i><a>" +
					"</div></div></li>";
					$(".files .list-group").append(html);
					$(".files").fadeIn("slow");
					$(".faxsend .filedrop .pbar").css("width", "0%");
					$(".faxsend .filedrop .message").html(initalDropMessage);
					$this.faxData.files.push(data.result.localfilename);
				} else {
					$(".faxsend .filedrop .pbar").css("width", "0%");
					$(".faxsend .filedrop .message").text(data.result.message);
				}
			},
			progressall: function(e, data) {
				var progress = parseInt(data.loaded / data.total * 100, 10);
				$(".faxsend .filedrop .pbar").css("width", progress + "%");
			},
			drop: function(e, data) {
				$(".faxsend .filedrop").removeClass("hover");
			},
			submit: function(e, data) {
				var $this = $(this);
				data.formData = { test: "123" };
				$this.fileupload("send", data);
				return false;
			}
		});

		$(".filedrop").on("dragover", function(event) {
			if (event.preventDefault) {
				event.preventDefault(); // Necessary. Allows us to drop.
			}
			$(this).addClass("hover");
		});
		$(".filedrop").on("dragleave", function(event) {
			$(this).removeClass("hover");
		});
		$("#msg").bind("input propertychange", function() {
			var max = 1340;
			$("#msg-left").text(max - $(this).val().length);
			if ((max - $(this).val().length) < 0) {
				$("#msg-left").addClass("red");
			} else {
				$("#msg-left").removeClass("red");
			}
		});
		$(".faxsend #coversheet").change(function(event) {
			if ($(this).is(":checked") && !$(".faxsend .extras").is(":visible")) {
				$(".faxsend .extras").slideDown("slow");
			} else if ($(".faxsend .extras").is(":visible")) {
				$(".faxsend .extras").slideUp("slow");
			}
		});

		/* Settings changes binds */
		$(".faxsettings input[type!=\"checkbox\"]").change(function() {
			$(this).blur(function() {
				$this.saveSettings();
				$(this).off("blur");
			});
		});
		$(".faxsettings input[type=\"checkbox\"], .faxsettings select").change(function() {
			$this.saveSettings();
		});
		/* end settings changes binds */
	},
	hide: function(event) {
		$(document).off("click", "[vm-pjax] a, a[vm-pjax]");
		$("#faxresolution").off("change");
	},
	deleteAttachment: function(id) {
		var $this = this;
		if ($("#attachment-" + id).length !== 0) {
			if ($(".files .list-group-item").length === 1) {
				$(".files").fadeOut("slow", function(event) {
					$.post( "?quietmode=1&module=faxpro&command=deleteattachment", { name: $("#attachment-" + id).data("filename") }, function( data ) {
						if (data.status) {
							var i = $this.faxData.files.indexOf($("#attachment-" + id).data("filename"));
							if (i != -1) {
								$this.faxData.files.splice(i, 1);
							}
							$("#attachment-" + id).remove();
						}
					});
				});
			} else {
				$("#attachment-" + id).fadeOut("slow", function(event) {
					$.post( "?quietmode=1&module=faxpro&command=deleteattachment", { name: $("#attachment-" + id).data("filename") }, function( data ) {
						if (data.status) {
							var i = $this.faxData.files.indexOf($("#attachment-" + id).data("filename"));
							if (i != -1) {
								$this.faxData.files.splice(i, 1);
							}
							$("#attachment-" + id).remove();
						}
					});
				});
			}
		}
	},
	stopFax: function(id) {
		if (confirm(_("Are you sure you wish to stop this fax?"))) {
			$.post( "?quietmode=1&module=faxpro&command=stopfax", { id: id }, function( data ) {
				$("#fax-" + id).fadeOut("slow");
				var count = $(".folder.active .badge").text();
				$(".folder.active .badge").text(count - 1);
			});
		}
	},
	deleteFax: function(id, confirm2, callback) {
		var conf = (typeof confirm2 !== "undefined") ? confirm2 : true;
		if (conf && !confirm(_("Are you sure you wish to delete this fax?"))) {
			return;
		}
		$.post( "?quietmode=1&module=faxpro&command=deletefax", { id: id }, function( data ) {
			var count = $(".folder.active .badge").text();
			$(".folder.active .badge").text(count - 1);
			if(typeof callback === "function") {
				callback(data);
			} else {
				$('#fax-grid').bootstrapTable('hideRow', {index: id, isIdField: true});
			}
		});
	},
	sendFax: function() {
		var $this = this;
		setTimeout(function() {
			if ($("#destination").val() === null || !$("#destination").val()[0].length) {
				alert(_("Please Enter a valid Destination"));
				$("#destination").focus();
				return false;
			}
			if (!$this.faxData.files.length && !$("#coversheet").is(":checked")) {
				alert(_("Please upload at least one file or enable a coversheet"));
				return false;
			}
			if (!$this.faxData.files.length && !confirm(_("Send this without anything attached? (Coversheet only)"))) {
					return false;
			}
			$this.faxData.destination = $("#destination").val()[0];
			$("input[type!=\"checkbox\"][type!=\"file\"]").each(function( index ) {
				$this.faxData[$(this).prop("name")] = $(this).val();
			});
			$("input[type=\"checkbox\"]").each(function( index ) {
				$this.faxData[$(this).prop("name")] = $(this).is(":checked");
			});
			$("select[name!=\"destination\"]").each(function( index ) {
				$this.faxData[$(this).prop("name")] = $(this).val();
			});
			$("textarea").each(function( index ) {
				$this.faxData[$(this).prop("name")] = $(this).val();
			});
			$("#send-btn").prop("disabled", true);
			$("#destination").prop("disabled", true);
			$(".file-controls").hide();
			$(".filedrop").hide();
			$("#coversheet").prop("disabled", true);
			$(".attachment img").remove();
			$.post( "?quietmode=1&module=faxpro&command=sendfax", $this.faxData, function( data ) {
				if (data.status) {
					$this.presend = true;
					$("#message").addClass("alert-success").html(_("Preparing to send..")).fadeIn("slow");
				} else {
					$("#message").addClass("alert-danger").text(data.message).fadeIn("slow");
					$("#send-btn").prop("disabled", false);
				}
				$("#dashboard-content").animate({ scrollTop: 0 }, "slow");
				//clear files
				$this.faxData = { files: [] };
			});
		}, 50);
	},
	showPDF: function(id) {
		$('#faxpreview object').prop("data","?quietmode=1&module=faxpro&command=view&faxid="+id);
		$('#faxpreview object .link').html("<a href='?quietmode=1&module=faxpro&command=view&faxid="+id+">"+_('Here')+"</a>");
		$('#faxpreview .modal-footer .download').prop("href","?quietmode=1&module=faxpro&command=download&faxid="+id);
		$('#faxpreview').modal('toggle');

		/*
		$("#view-" + id).toggle();
		if ($("#fax-" + id).hasClass("new")) {
			$("#new-img-" + id).hide();
			$("#fax-" + id).removeClass("new");
			var count = $(".mailbox .folder-list .folder.active a .badge").text();
			$(".mailbox .folder-list .folder.active a .badge").text(count - 1);
			count = $("#fs-navside a[data-mod=\"faxpro\"] .badge").text();
			$("#fs-navside a[data-mod=\"faxpro\"] .badge").text(count - 1);
		}
		*/
	},
	/**
	 * Function that saves settings when page is changed
	 */
	saveSettings: function() {
		var data = {};
		$("input[type!=\"checkbox\"]").each(function( index ) {
			data[$(this).prop("name")] = $(this).val();
		});
		$("input[type=\"checkbox\"]").each(function( index ) {
			data[$(this).prop("name")] = $(this).is(":checked");
		});
		$("select").each(function( index ) {
			data[$(this).prop("name")] = $(this).val();
		});
		$.post( "?quietmode=1&module=faxpro&command=save", data, function( data ) {
			$("#message").addClass("alert-success").text("Saved Settings").fadeIn("slow", function(event) {
				setTimeout(function() { $("#message").fadeOut("slow"); }, 2000);
			});
		});
	},
	forward: function(id, dest) {
		this.forwardID = id;
		UCP.showDialog(_("Forward Fax"), "<label>" + _("Please enter a phone number or extension") + ":<br/>" +
			"<input type=\"text\" class=\"form-control\" name=\"dest\" value=\""+dest+"\"></label></br>" +
			"<div class=\"form-group\">" +
			"<label for=\"faxresolution\">"+_('Resolution')+"</label>" +
			"<select id=\"faxresolution\ name=\"resolution\" class=\"form-control\">" +
			"<option value=\"standard\">"+_("Standard")+"</option>" +
			"<option value=\"fine\" selected>"+_("Fine")+"</option>" +
			"<option value=\"superfine\">"+_("Super Fine")+"</option>" +
			"</select>" +
			"</div>" +
			"<button class=\"btn btn-default\" style=\"margin-left: 87px;\" onclick=\"UCP.Modules.Faxpro.forwardSend();return false;\">Send</button>",
		240);
	},
	/**
	 * Forward a Fax to a new destination
	 */
	forwardSend: function() {
		var dest = $(".dialog input[name=\"dest\"]").val(), local, resolution = 'fine';
		if (dest === "") {
			alert(_("Destination Can Not Be Blank"));
		} else {
			local = $(".dialog checkbox[name=\"faxlocal\"]").is(":checked");
			resolution = $(".dialog checkbox[name=\"resolution\"]").val();
			$.post( "?quietmode=1&module=faxpro&command=forward", { dest: dest, resolution: resolution, local: local, id: this.forwardID }, function( data ) {
				if (data.status) {
					UCP.closeDialog();
				} else {
					alert(data.message);
				}
			});

		}
	},
	controlFormatter: function (value, row, index) {
		var folder = $.url().param("folder"),
				controls = '',
				dest = '';

		if(folder == "failed") {
			dest = row.dest;
		}
		controls += '<a onclick="UCP.Modules.Faxpro.showPDF(\''+row.faxid+'\')"><i class="fa fa-file-pdf-o"></i></a><a href="?quietmode=1&amp;module=faxpro&amp;command=download&amp;faxid='+row.faxid+'"><i class="fa fa-cloud-download"></i></a>';
		if(folder !== "out") {
			controls += '<a onclick="UCP.Modules.Faxpro.forward(\''+row.faxid+'\',\''+dest+'\')"><i class="fa fa-share"></i></a>';
			controls += '<a onclick="UCP.Modules.Faxpro.deleteFax(\''+row.faxid+'\')"><i class="fa fa-trash-o"></i></a>';
		} else {
			controls += '<a onclick="UCP.Modules.Faxpro.stopFax(\''+row.faxid+'\')"><i class="fa fa-times"></i></a>';
		}
		return controls;
	},
	dateFormatter: function(value, row, index) {
		return UCP.dateFormatter(value);
	},
});
