<?php

namespace FreePBX\modules\Parkpro\Api\Gql;
use GraphQL\Type\Definition\Type;
use FreePBX\modules\Api\Gql\Base;

class Parkpro extends Base {

	public function postInitReferences() {
		$device = $this->typeContainer->get('device');
		$device->addField('parkpro_parkinglot', [
			'type' => $this->typeContainer->get('parkinglot')->getReference(),
			'resolve' => function($device) {
				$id = $this->freepbx->Parkpro->getDevice($device['id']);
				return $this->freepbx->Parking->getParkingLotByID($id);
			}
		]);

		$parking = $this->typeContainer->get('parkinglot');
		$parking->addField('defaultlot', [
			'type' => Type::boolean(),
			'resolve' => function($row) {
				return ($row['defaultlot'] == 'yes');
			}
		]);
		$parking->addField('type', [
			'type' => Type::string(),
			'resolve' => function($row) {
				return $row['type'];
			}
		]);
	}
}
