<?php
$unavailintrial = '';
if ($account_type == 'TRIAL') {
	$unavailintrial = _("This item is not available in trial mode");
}
$disabled = isset($disabled) ? $disabled : '';
?>
<div class="alert alert-info">
<small> <?php echo sprintf(_("To disable account access, click %s. To update account information, click %s. If port forwarding is configured on your firewall/router, you can test it with the %s button.
		Port forwarding can provide more reliable service and better quality and we recommend setting it up.
		The test sends a packet to an unused Asterisk RTP port at your WAN address and results in a PASS if the packet is properly received."),
		"<i>".$cancelOrRemove."</i>","<i>"._("Update Account Info")."</i>","<i>"._("Run Firewall Test")."</i>") ?></small><br /><br />
		<small><?php echo sprintf(_("Questions or Issues can be directed to our %s at %s"),'<a href="http://support.schmoozecom.com" target="_sipstationsupport" title="Schmoozecom Support">Support Center</a>',
		'<a href="http://support.schmoozecom.com" target="_sipstationsupport" title="Schmoozecom Support">http://support.schmoozecom.com</a>')?></small><br/><br/>
</div>
<?php if (!empty($verify_message)) { ?>
<div class="alert alert-danger unverified">
	<small><?php echo $verify_message; ?></small><br/><br/>
</div>
<?php } ?>

<?php if ($account_type == 'TRIAL') { ?>
<div class="account_access_section convert">
	<a href="/admin/config.php?display=sipstation&action=convert">
	<?php echo $expirynotice; ?>
	<div class="convert-trial"></div>
	</a>
</div>
<?php } ?>
<div class="btn-group" role="group" aria-label="actionbuttons">
<?php if ($account_type != 'TRIAL') { ?>
	<input type="submit" class="btn btn-default" name="remove_key" id="remove_key" value="<?php echo _("Remove Key")?>" tabindex="<?php echo ++$tabindex;?>" />&nbsp;
	<input type="submit" class="btn btn-default" name="remove_key_del_trunks" id="remove_key_del_trunks"  value="<?php echo _("Remove Key & Delete Trunks")?>" tabindex="<?php echo ++$tabindex;?>" />&nbsp;
<?php } else { ?>
	<input type="submit" class="btn btn-default" name="cancel_freetrial" id="cancel_freetrial"  value="<?php echo _("Cancel Free Trial")?>" tabindex="<?php echo ++$tabindex;?>" />&nbsp;
<?php } ?>
<input type="button" class="btn btn-default" id="account-access-button"  value="<?php echo _("Refresh Asterisk Account Info")?>" tabindex="<?php echo ++$tabindex;?>" />&nbsp;
<input type="button" class="btn btn-default" id="firewall-test-button"  value="<?php echo _("Run Firewall Test")?>" tabindex="<?php echo ++$tabindex;?>" />&nbsp;
</div>
<br/>
<br/>
<div class="section-title" data-for="sipstation-system-status"><h3><i class="fa fa-minus"></i> <?php echo _("System Status") ?></h3></div>
<div class="section" data-id="sipstation-system-status">
<!--Trunk Status-->
<div class="element-container">
	<div class="row">
		<div class="col-md-12">
			<div class="row">
				<div class="form-group">
					<div class="col-md-3">
						<label class="control-label" for="tsw"><?php echo _("Trunk Status") ?></label>
					</div>
					<div class="col-md-9">
						<div id="asterisk-registerattempts-msg" style="display:none;">
							<div class="alert alert-warning">
								<?php echo sprintf(_("Warning: The Asterisk configuration: %s, is set wrong. Change this to 0 to continually retry registrations until successful. You can use the Asterisk SIP Settings module to set this."),"registerattempts") ?>
							</div>
						</div>
						<?php if($sip_header == 'warning') {?>
						<div class="gateway-reginfo-msg" id="gateway-private-msg">
							<div class="alert alert-warning">
								<?php echo _("Warning: The SIP Contact header is not set to your WAN IP. It is set to your internal private IP behind NAT. The gateway will attempt to decipher your proper address but your configuration is incorrect. You should review the NAT settings in the Asterisk SIP Settings module, or sip_nat.conf if not using that module.") ?>
							</div>
						</div>
					<?php } elseif($sip_header == 'error') {?>
						<div class="gateway-reginfo-msg" id="gateway-broken-msg">
							<div class="alert alert-warning">
								<?php echo _("ERROR: Your SIP Contact header is a non-private IP address that does not match your network IP. Your system will probably fail typically resulting in one way audio issues. This is usually caused because of an externip setting that is not the same as you WAN IP, or an externhost setting with dynamic DNS information that is not updated. You should check the Asterisk SIP Settings Module or your sip_nat.conf file for the proper settings.") ?>
							</div>
						</div>
					<?php } ?>
					<div class="row">
						<div class="col-md-6">
							<div class="panel panel-default">
								<div class="panel-heading"> <?php echo _("Primary") ?> </div>
								<div class="panel-body">
									<table class='table table-striped'>
										<tr><th><?php echo _("Asterisk Registration Status")?> </th><td><h3><span class="label label-<?php echo $gw1_reg == 'Registered' ? 'success' : 'danger' ?> col-sm-12" id="asterisk_registry_gw1" name="asterisk_registry_gw1"><?php echo $gw1_reg ?> </span></h3></td></tr>
										<tr><th><?php echo _("Your Contact IP")?></th><td><input type="text" style="background-color:<?php echo $ip_color ?>" readonly="readonly" size="24" id="contact_ip_gw1" name="contact_ip_gw1" class="register-fields-gw1 form-control" value="<?php echo !empty($gw1_contactip) ? $gw1_contactip : _('Not Available')?>"></td></tr>
										<tr><th><?php echo _("Your Network IP")?></th><td><input type="text" style="background-color:<?php echo $ip_color ?>" readonly="readonly" size="24" id="network_ip_gw1" name="network_ip_gw1" class="register-fields-gw1 form-control" value="<?php echo !empty($gw1_networkip) ? $gw1_networkip : _('Not Available') ?>"></td></tr>
										<tr><th><?php echo _("SIP Ping")?></th><td><input type="text" class='form-control' readonly="readonly" size="24" id="trunk_qualify_gw1" name="trunk_qualify_gw1" value="<?php echo _("Not Available") ?>"></td></tr>
										<tr><th><?php echo _("Codec Priorities")?></th><td><input type="text" class='form-control' readonly="readonly" size="24" id="trunk_codecs_gw1" name="trunk_codecs_gw1" value="<?php echo _("Not Available") ?>"></td></tr>
									</table>
								</div>
							</div>
						</div>
						<div class="col-md-6">
							<div class="panel panel-default">
								<div class="panel-heading"> <?php echo _("Secondary") ?> </div>
								<div class="panel-body">
									<table class='table table-striped'>
										<tr><th><?php echo _("Asterisk Registration Status")?></th><td><h3><span class="label label-<?php echo $gw2_reg == 'Registered' ? 'success' : 'danger' ?> col-sm-12" id="asterisk_registry_gw2" name="asterisk_registry_gw2"><?php echo $gw2_reg ?> </span></h3></td></tr>
										<tr><th><?php echo _("Your Contact IP")?></th><td><input type="text" style="background-color:<?php echo $ip_color ?>" readonly="readonly" size="24" id="contact_ip_gw2" name="contact_ip_gw2" class="register-fields-gw2 form-control" value="<?php echo !empty($gw2_contactip) ? $gw2_contactip : _('Not Available') ?>"></td></tr>
										<tr><th><?php echo _("Your Network IP")?></th><td><input type="text" style="background-color:<?php echo $ip_color ?>" readonly="readonly" size="24" id="network_ip_gw2" name="network_ip_gw2" class="register-fields-gw2 form-control" value="<?php echo !empty($gw2_networkip) ? $gw2_networkip : _('Not Available') ?>" ></td></tr>
										<tr><th><?php echo _("SIP Ping")?></th><td><input type="text" class='form-control' readonly="readonly" size="24" id="trunk_qualify_gw2" name="trunk_qualify_gw2" value="<?php echo _("Not Available") ?>" ></td></tr>
										<tr><th><?php echo _("Codec Priorities")?></th><td><input type="text" class='form-control' readonly="readonly" size="24" id="trunk_codecs_gw2" name="trunk_codecs_gw2" value="<?php echo _("Not Available") ?>" ></td></tr>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<!--END Trunk Status-->
<!--Firewall Test-->
<div class="element-container">
	<div class="row">
		<div class="col-md-12">
			<div class="row">
				<div class="form-group">
					<div class="col-md-3">
						<label class="control-label" for="firewallw"><?php echo _("Firewall Test") ?></label>
						<i class="fa fa-question-circle fpbx-help-icon" data-for="firewallw"></i>
					</div>
					<div class="col-md-9">
						<table class="table table-striped">
							<tr>
								<th><?php echo _("Status")?></th><th><?php echo _("External IP")?></th>
							</tr>
							<tr>
								<td width="50%" align="center">
									<span  class="label label-default col-sm-12" id="firewall_status">N/A</span></small>
								</td>
								<td width="50%" align="center">
									<span class="label label-default col-sm-12" id="firewall_externip">N/A</span></small>
								</td>
							</tr>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-md-12">
			<span id="firewallw-help" class="help-block fpbx-help-block"><?php echo sprintf(_("Status result of Firewall Test. If %s, it means we successfully received the RTP packet that was sent from the remote server. If %s, it means the packet sent from the remote server was blocked by your firewall or lost in the Internet. You can retry the test."),_("PASS"),_("FAIL"))?></span>
		</div>
	</div>
</div>
<!--END Firewall Test-->
</form>
</div>
<br/><br/>
<div class="section-title" data-for="account_summary_section"><h3><i class="fa fa-minus"></i> <?php echo _("Account Settings") ?></h3></div>
<div class="section" data-id="account_summary_section">
	<form autocomplete="off" id="editaccount" name="editaccount" action="" method="post">
	<input id="global_failover_old" name="global_failover_old" type="hidden" value="<?php echo $global_failover_num ?>">
	<input type="hidden" value="editaccount" name="type">
	<!--SIP Username-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="unw"><?php echo _("SIP Username") ?></label>
							<i class="fa fa-question-circle fpbx-help-icon" data-for="unw"></i>
						</div>
						<div class="col-md-9">
							<span id="sip_username"><?php echo $sip_username ?></span>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<span id="unw-help" class="help-block fpbx-help-block"><?php echo _("Sip Usetname")?></span>
			</div>
		</div>
	</div>
	<!--END SIP Username-->
	<!--Sip Password-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="spw"><?php echo _("Sip Password") ?></label>
							<i class="fa fa-question-circle fpbx-help-icon" data-for="spw"></i>
						</div>
						<div class="col-md-9">
							<span id="sip_password"><?php echo $sip_password ?></span>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<span id="spw-help" class="help-block fpbx-help-block"><?php echo _("Sip Password")?></span>
			</div>
		</div>
	</div>
	<!--END Sip Password-->
	<!--Gateways-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="gww"><?php echo _("Gateways") ?></label>
							<i class="fa fa-question-circle fpbx-help-icon" data-for="gww"></i>
						</div>
						<div class="col-md-9">
							<table class="table table-striped">
								<tr><th><?php echo _("Primary") ?></th><td><span id="gw1"><?php echo $gw1_name ?></span></td></tr>
								<tr><th><?php echo _("Secondary") ?></th><td><span id="gw2"><?php echo $gw2_name ?></span></td></tr>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<span id="gww-help" class="help-block fpbx-help-block"><?php echo _("Sip Gateways")?></span>
			</div>
		</div>
	</div>
	<!--END Gateways-->
	<!--Channels-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="chw"><?php echo _("Channels") ?></label>
							<i class="fa fa-question-circle fpbx-help-icon" data-for="chw"></i>
						</div>
						<div class="col-md-9">
							<span id="num_trunks"><?php echo $num_trunks ?></span>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<span id="chw-help" class="help-block fpbx-help-block"><?php echo _("Number of Channels")?></span>
			</div>
		</div>
	</div>
	<!--END Channels-->
	<!--Services-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="servw"><?php echo _("Services") ?></label>
							<i class="fa fa-question-circle fpbx-help-icon" data-for="servw"></i>
						</div>
						<div class="col-md-9">
							<table class="table table-striped">
								<tr><th><?php echo _("Global Failover IP/FQDN") ?></th><td><div class="label label-default col-sm-12"><?php echo $global_failover_dest ?></div></td></tr>
								<tr><th><?php echo _("International Calling") ?></th><td><div class="label label-<?php echo !empty($server_settings['international'])?'success':'default'?> col-sm-12"><?php echo !empty($server_settings['international']) ? _('Yes') : _('No') ?></div></td></tr>
								<tr><th><?php echo _("Outbound Fax") ?></th><td><div class="label label-<?php echo !empty($server_settings['fax'])?'success':'default'?> col-sm-12"><?php echo !empty($server_settings['fax']) ? _('Yes') : _('No') ?></div></td></tr>
								<tr><th><?php echo _("SMS Support") ?></th><td><div class="label label-<?php echo !empty($server_settings['sms'])?'success':'default'?> col-sm-12"><?php echo !empty($server_settings['sms']) ? _('Yes') : _('No') ?></div></td></tr>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<span id="servw-help" class="help-block fpbx-help-block"><?php echo _("Account Services")?></span>
			</div>
		</div>
	</div>
	<!--END Services-->
</div>
<div class="section-title" data-for="sipstation-e911"><h3><i class="fa fa-minus"></i> <?php echo _("E911 Master Location") ?></h3></div>
<div class="section e911-location e911_default_did" data-id="sipstation-e911">
	<div class="alert alert-info">
		<?php echo _("Your E911 Master Location is your primary E911 address. It must be a valid U.S. or Canadian address.<br/> You must provide an address in order to use the SIPStation service, except in Free Trial mode.<br/> You are responsible for the accuracy of this information and for confirming that E911 service is working.<br/><strong>DO NOT call 911 to test E911 service.</strong> To test the service, please be sure 933 is included in an emergency outbound route, and then dial 933. <br/>This reaches an E911 address verification service that will play back the information being transmitted. <br/> When calling outbound on an emergency route, the SIPStation trunk will send out a Caller ID (CID) matching your Master E911 DID as shown here, unless an extension/device has its own Emergency CID set. There is no fee for E911 service on your Master DID. If you have multiple DIDs, you can designate a different DID as the Master within your SIPStation account. You can also enable E911 service on additional DIDs for a small additional fee. This would allow the E911 operator to see different addresses and CIDs for different numbers.")?>
	</div>
	<!--E911 Caller ID-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="noocidw"><?php echo _("E911 Caller ID") ?></label>
						</div>
						<div class="col-md-9">
							<span id="default_did"><?php echo $e911_master['number']; ?></span>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--END E911 Caller ID-->
	<!--Name-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="name"><?php echo _("Name") ?></label>
						</div>
						<div class="col-md-9">
							<input type="text" class="form-control" id="name" name="name" value="<?php echo $e911_master['name'] ?>" placeholder="<?php echo $unavailintrial?>" <?php echo $disabled; ?>>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--END Name-->
	<!--Address 1-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="address1"><?php echo _("Address 1") ?></label>
						</div>
						<div class="col-md-9">
							<input type="text" class="form-control" id="address1" name="address1" value="<?php echo $e911_master['street1'] ?>" placeholder="<?php echo $unavailintrial?>" <?php echo $disabled; ?>>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--END Address 1-->
	<!--Address 2-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="address2"><?php echo _("Address 2") ?></label>
						</div>
						<div class="col-md-9">
							<input type="text" class="form-control" id="address2" name="address2" value="<?php echo $e911_master['street2'] ?>" placeholder="<?php echo $unavailintrial?>" <?php echo $disabled; ?>>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--END Address 2-->
	<!--City-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="address2"><?php echo _("City") ?></label>
						</div>
						<div class="col-md-9">
							<input type="text" class="form-control" id="city" name="city" value="<?php echo $e911_master['city'] ?>" placeholder="<?php echo $unavailintrial?>" <?php echo $disabled; ?>>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--END City-->
	<!--State-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="address2"><?php echo _("State") ?></label>
						</div>
						<div class="col-md-9">
							<input type="text" class="form-control" id="state" name="state" value="<?php echo $e911_master['state'] ?>" placeholder="<?php echo $unavailintrial?>" <?php echo $disabled; ?>>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--END State-->
	<!--Zip-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="address2"><?php echo _("Zip") ?></label>
						</div>
						<div class="col-md-9">
							<input type="text" class="form-control" id="zip" name="zip" value="<?php echo $e911_master['zip'] ?>" placeholder="<?php echo $unavailintrial?>" <?php echo $disabled; ?>>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--END Zip-->
	<!--Global Failover-->
	<div class="element-container">
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="form-group">
						<div class="col-md-3">
							<label class="control-label" for="global_failover"><?php echo _("Global Failover") ?></label>
							<i class="fa fa-question-circle fpbx-help-icon" data-for="global_failover"></i>
						</div>
						<div class="col-md-9">
							<input type="text" class="form-control" id="global_failover" name="global_failover" value="<?php echo $global_failover_num ?>" placeholder="<?php echo $unavailintrial?>" <?php echo $disabled; ?>>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<span id="global_failover-help" class="help-block fpbx-help-block"><?php echo _("")?></span>
			</div>
		</div>
	</div>
	<!--END Global Failover-->
	<br/>
	<br/>
	<input type="submit" id="account-submit-button"  value="<?php echo _("Update Account Info")?>" tabindex="<?php echo ++$tabindex;?>" />
</div>
</form>
<br/><br/>
<div class="section-title" data-for="trunk_routes_section"><h3><i class="fa fa-minus"></i> <?php echo _("Route and Trunk Configuration") ?></h3></div>
<div class="trunk_routes_section" data-id="sipstation-e911">
<div class="alert alert-info">
	<?php echo _("Select/Unselect the butons and submit to add/remove this service as the primary trunks to any listed route. Both gateways should be configured to allow for redundancy. If gateways are already configured in the route, the box will be checked, even if they are not the primary trunks for that route. Click on the route name to link directly to the Outbound Routes page for any route.") ?>
	<br/>
	<?php echo sprintf(_("Check Primary (%s) and Secondary (%s) Trunk for each route that should be configured with the %s service. The trunks will be inserted into the corresponding routes upon clicking the %s button. You can enable 7 digit dialing with the trunk by entering your area code as well."),"<i>gw1</i>","<i>gw2</i>","SIPStation","<i>"._("Update Route/Trunk Configurations")."</i>") ?>
</div>
<form autocomplete="off" id="editrt" name="editrt" action="" method="post">
<!--Area Code-->
<div class="element-container">
	<div class="row">
		<div class="col-md-12">
			<div class="row">
				<div class="form-group">
					<div class="col-md-3">
						<label class="control-label" for="areacode"><?php echo _("Area Code") ?></label>
						<i class="fa fa-question-circle fpbx-help-icon" data-for="areacode"></i>
					</div>
					<div class="col-md-9">
						<input type="text" maxlength="3" class="form-control" id="areacode" name="areacode" value="<?php echo isset($prepend_digits)?$prepend_digits:''?>">
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-md-12">
			<span id="areacode-help" class="help-block fpbx-help-block"><?php echo _("Provide your 3 digit area code if you would like your trunks to allow 7 digit dialing and automatically prepend your area code. This requires the route to be configured to send a 7 digit number.")?></span>
		</div>
	</div>
</div>
<!--END Area Code-->
<table id="ssroutes" data-maintain-selected="true" data-show-columns="true" data-show-toggle="true" data-toggle="table" data-pagination="true" data-search="true" class="table table-striped">
	<thead>
		<tr class="trunk_routes_section">
			<th data-sortable="true"><?php echo _("Route Name")?></th>
			<th><?php echo _("Gateways")?></th>
		</tr>
	</thead>
	<tbody>
		<?php foreach($routes as $route) { ?>
			<tr class="account-settings trunk-routes trunk_routes_section">
				<td id="<?php echo $route['name'].'-lab'?>"><a href="<?php echo '?display=routing&extdisplay='.$route['id'] ?>" title="<?php echo sprintf(_("Edit: %s"),$route['label']) ?>"><?php echo $route['label'] ?></a></td>
				<td>
					<span class="radioset">
					<input type="checkbox" value="yes" name="<?php echo $route['name'].'_id1' ?>" id="<?php echo $route['name'].'_id1' ?>" class="route-checkbox <?php echo $route['name'].'_id2' ?>" tabindex="<?php echo $tabindex++ ?>" <?php echo !empty($route['gw1_checked']) ? $route['gw1_checked'] : ''?>/>
					<label for="<?php echo $route['name'].'_id1' ?>"> <small>gw1</small> </label>
					<input type="checkbox" value="yes" name="<?php echo $route['name'].'_id2' ?>" id="<?php echo $route['name'].'_id2' ?>" class="route-checkbox <?php echo $route['name'].'_id1' ?>" tabindex="<?php echo $tabindex++ ?>" <?php echo !empty($route['gw2_checked']) ? $route['gw2_checked'] : ''?>/>
					<label for="<?php echo $route['name'].'_id2' ?>"> <small>gw2</small> </label>
				</span>
				</td>
			</tr>
		<?php } ?>
	</tbody>
</table>
<br/>
<input type="hidden" name="type" value="edittrunk">
<input type="submit" id="route-submit-button"  value="<?php echo _("Update Route/Trunk Configurations")?>" tabindex="<?php echo ++$tabindex;?>" />
<?php if($show_reconfig) {?><input type="button" value="<?php echo _("Add Default SIPStation Routes")?>" tabindex="<?php echo ++$tabindex;?>" onclick="addRoutes()"/><?php } ?>
</form>
<br/>
<br/>
<form autocomplete="off" id="editdid" name="editdid" action="" method="post">
<input type="hidden" name="type" value="editdid">
<div class="alert alert-info">
	<?php echo _("Here you can manage your DIDs<br>Specifically you can do the following: ") ?>
		<ul>
			<li><strong><?php echo _("DID"); ?>:</strong> <?php echo _("Your DID, Clicking here will take you to the inbound route setup for this DID")?></li>
			<li><strong><?php echo _("Set E911"); ?>:</strong> <?php echo _("Set and edit the E911 address for a DID. (Fees apply for multiple E911 addresses.)")?></li>
			<li><strong><?php echo _("Failover Number"); ?>:</strong> <?php echo _("Set and edit your per-DID failover numbers.")?></li>
			<li><strong><?php echo _("Description"); ?>:</strong> <?php echo _("Set A Description for the Inbound Routes Page")?></li>
			<li><strong><?php echo _("Route To"); ?>:</strong> <?php echo _("Route Your DID to a specified location")?></li>
			<li><strong><?php echo _("Set CID"); ?>:</strong> <?php echo _("Automatically set the extension's CID to match the DID, if this DID is routed to an extension.")?></li>
			<li><strong><?php echo _("Set ECID"); ?>:</strong> <?php echo _("Set the extension's Emergency CID to match one of your E911-enabled DIDs.")?></li>
		</ul>
</div>
<table id="ssdids" data-maintain-selected="true" data-show-columns="true" data-show-toggle="true" data-toggle="table" data-pagination="true" data-search="true" class="table table-striped">
<thead>
	<tr class="account-settings did_section">
		<th data-sortable="true"><?php echo _("DID") ?></th>
		<th><?php echo _("Set E911") ?></th>
		<th><?php echo _("Failover Num") ?></th>
		<th><?php echo _("Description") ?></th>
		<th><?php echo _("Route To") ?></th>
		<th><?php echo _("Set CID") ?></th>
		<th><?php echo _("Emergency CID") ?></th>
		<th><?php echo _("Last Call") ?></th>
	</tr>
</thead>
<tbody>
	<?php foreach($dids as $did) { ?>
		<tr class="account-settings did_section">
			<td><input type="hidden" name="dids[]" value="<?php echo $did['did']?>"><input type="hidden" name="failover_old_<?php echo $did['did']?>" value="<?php echo $did['failover']['num'] ?>"><a href="config.php?display=did&amp;extdisplay=<?php echo $did['did']; ?>" id="did-color-<?php echo $did['did']?>" style="color:<?php echo !empty($did['e911']['name']) ? ($did['e911']['master'] ? 'green' : 'orange') : 'black' ?>"><?php echo $did['did'] ?></a></td>
			<td><a href="#" id="did-name-<?php echo $did['did']?>" onclick="$( '#dialog-<?php echo $did['did']?>' ).dialog( 'open' );return false;"><?php echo (isset($did['e911']['name']) && !empty($did['e911']['name'])) ? 'Modify' : 'Set'?></a></td>
			<td><input type="text" class="form-control" max="10" name="failover_<?php echo $did['did']?>" maxlength="10" value ="<?php echo $did['failover']['num'] ?>" <?php echo $disabled; ?>></td>
			<td><input type="text" class="form-control" name="description_<?php echo $did['did']?>" value ="<?php echo $did['description'] ?>"></td>
			<td><?php echo drawselects($did['destination'], $did['did'], false, false)?></td>
			<td>
				<select id="setcid-<?php echo $did['did']?>" class="form-control" name="setcid_<?php echo $did['did']?>" style="<?php if(!preg_match('/from-did-direct/',$did['destination'])) {?>display:none;<?php } ?>">
					<option value="unchanged">Unchanged</option>
					<option value="none" <?php echo empty($did['cid']) ? 'selected' : '' ?>>None</option>
					<?php foreach($dids as $subdid) { ?>
						<option value="<?php echo $subdid['did']?>" <?php echo ($subdid['did'] == $did['cid']) ? 'selected' : ''?>><?php echo $subdid['did']?></option>
					<?php } ?>
				</select>
			</td>
			<td>
				<select id="selectecid-<?php echo $did['did']?>" class="form-control" name="selectecid_<?php echo $did['did']?>" style="<?php if(!preg_match('/from-did-direct/',$did['destination'])) {?>display:none;<?php } ?>">
					<option value="unchanged">Unchanged</option>
					<option value="none" <?php echo empty($did['ecid']) ? 'selected' : '' ?>>None</option>
					<?php foreach($e911_list as $list) {?>
						<option value="<?php echo $list['did']?>" <?php echo ($list['did'] == $did['ecid']) ? 'selected' : ''?>><?php echo $list['did']?></option>
					<?php } ?>
					</select>
			</td>
			<td>
				<?php
				$number = $did['lastcall'];
				echo $number;
				?>
			</td>
		</tr>
	<?php } ?>
</tbody>
</table>
<input class="account-settings did_section" type="submit" id="did-submit-button"  value="<?php echo _("Update DID Configurations")?>" tabindex="<?php echo ++$tabindex;?>" />
</form>
</div>
</div>


		<?php foreach($dids as $did) { ?>
			<div id="dialog-<?php echo $did['did']?>" title="<?php echo $did['did']?> Options" style="display: none">
				<h2><?php echo _('Address On Record')?>:</h2>
				<form method="post" id="didform-<?php echo $did['did']?>">
					<div class="form-group">
						<label for="name-<?php echo $did['did']?>"><?php echo _("Caller Name:")?></label>
						<input type="text" class="form-control" name="name-<?php echo $did['did']?>" id="name-<?php echo $did['did']?>" value="<?php echo isset($did['e911']['name']) ? $did['e911']['name'] : '' ?>" <?php echo $disabled; ?>>
					</div>
					<div class="form-group">
						<label for="address1-<?php echo $did['did']?>"><?php echo _("Address1:")?></label>
						<input type="text" class="form-control" name="address1-<?php echo $did['did']?>" id="address1-<?php echo $did['did']?>" value="<?php echo isset($did['e911']['street1']) ? $did['e911']['street1'] : ''?>" <?php echo $disabled; ?>>
					</div>
					<div class="form-group">
						<label for="address2-<?php echo $did['did']?>"><?php echo _("Address2:")?></label>
						<input type="text" class="form-control" name="address2-<?php echo $did['did']?>" id="address2-<?php echo $did['did']?>" value="<?php echo isset($did['e911']['street2']) ? $did['e911']['street2'] : ''?>" <?php echo $disabled; ?>>
					</div>
					<div class="form-group">
						<label for="city-<?php echo $did['did']?>"><?php echo _("City:")?></label>
						<input type="text" class="form-control" name="city-<?php echo $did['did']?>" id="city-<?php echo $did['did']?>" value="<?php echo isset($did['e911']['city']) ? $did['e911']['city'] : ''?>" <?php echo $disabled; ?>>
					</div>
					<div class="form-group">
						<label for="state-<?php echo $did['did']?>"><?php echo _("State:")?></label>
						<input type="text" class="form-control" name="state-<?php echo $did['did']?>" id="state-<?php echo $did['did']?>" value="<?php echo isset($did['e911']['state']) ? $did['e911']['state'] : ''?>" <?php echo $disabled; ?>>
					</div>
					<div class="form-group">
						<label for="zip-<?php echo $did['did']?>"><?php echo _("Zip:")?></label>
						<input type="text" class="form-control" name="zip-<?php echo $did['did']?>" id="zip-<?php echo $did['did']?>" value="<?php echo isset($did['e911']['zip']) ? $did['e911']['zip'] : ''?>" <?php echo $disabled; ?>>
					</div>
					<span id="agreement-span-<?php echo $did['did']?>" style="<?php if(isset($did['e911']['master']) && $did['e911']['master']) {?>display:none<?php } ?>"><label><input type="checkbox" name="agreement-<?php echo $did['did']?>" <?php echo (isset($did['e911']['name']) && !empty($did['e911']['name'])) ? 'checked' : '' ?> <?php echo $disabled; ?>>I agree to additional charges and have read the documentation here: <a style="color:blue" target="_blank" href="http://wiki.freepbx.org/display/ST/Additional+e911+Addresses">Additional E911 Addresses</a></label><br /></span>
					<input type="hidden" name="type" value="updatee911">
					<input type="hidden" id="e911master-<?php echo $did['did']?>" name="e911master" value="<?php if(!isset($did['e911']['master']) || !$did['e911']['master']) {?>no<?php } else { ?>yes<?php } ?>">
					<input type="hidden" name="didmaster" value="<?php echo $did['did']?>">
					<input type="button" id="updatee911-<?php echo $did['did']?>" name="updatee911" value="<?php if(isset($did['e911']['name'])) {?>Update<?php } else { ?>Add<?php } ?>" onclick="update911('update','<?php echo $did['did']?>')">
					<input type="button" id="sete911master-<?php echo $did['did']?>" name="sete911master" value="Set As Master E911" onclick="update911('master','<?php echo $did['did']?>')" style="<?php if(!isset($did['e911']['name']) || $did['e911']['master']) {?>display:none<?php } ?>">
					<input type="button" id="deletee911-<?php echo $did['did']?>" name="deletee911" value="Delete E911 for DID" onclick="update911('delete','<?php echo $did['did']?>')" style="<?php if(!isset($did['e911']['name']) || $did['e911']['master']) {?>display:none<?php } ?>">
			</form>
		</div>
		<?php } ?>
		<script>
		function bind_did_table() {
			<?php foreach($dids as $did) { ?>
				if($('select#goto<?php echo $did['did']?>').val() == 'Extensions') {
					$(document).on('change', 'select#Extensions<?php echo $did['did']?>', function() {
						var select = $(this).val();
						var match = select.match(/from-did-direct,(.*),/)
						getextinfo(match[1],'<?php echo $did['did']?>');
					});
				}
				$(document).on('change', 'select#goto<?php echo $did['did']?>', function() {
					var did = $(this).attr('data-id');
					if($(this).val() == 'Extensions') {
						$('#setcid-'+did).show()
						$('#selectecid-'+did).show();
						$(document).on('change', 'select#Extensions<?php echo $did['did']?>', function() {
							var select = $(this).val();
							var match = select.match(/from-did-direct,(.*),/)
							getextinfo(match[1],did);
						});
						var select = $('select#Extensions<?php echo $did['did']?>').val();
						var match = select.match(/from-did-direct,(.*),/)
						getextinfo(match[1],did);
					} else {
						$('#setcid-'+did).hide()
						$('#selectecid-'+did).hide();
						$(document).off('change', 'select#Extensions<?php echo $did['did']?>');
					}
				});
				$( "#dialog-<?php echo $did['did']?>" ).dialog({
					autoOpen: false,
					height: 620,
					width: 500,
					modal: true
				})
			<?php } ?>
		}
		</script>
