<?php
//	License for all code of this FreePBX module can be found in the license file inside the module directory
//	Copyright 2013 Schmooze Com Inc.
//
out('Creating SMS Message Table');
$table = FreePBX::Database()->migrate("sms_messages");
$cols = array(
	"id" => array(
		"type" => "integer",
		"primaryKey" => true,
		"autoincrement" => true
	),
	"from" => array(
		"type" => "string",
		"length" => 20,
		"notnull" => true,
	),
	"to" => array(
		"type" => "string",
		"length" => 20,
		"notnull" => true,
	),
	"threadid" => array(
		"type" => "string",
		"length" => 50,
		"notnull" => true,
	),
	"cnam" => array(
		"type" => "string",
		"length" => 40,
		"notnull" => false,
	),
	"direction" => array(
		"type" => "string",
		"length" => 3,
		"notnull" => true,
	),
	"tx_rx_datetime" => array(
		"type" => "datetime",
	),
	"body" => array(
		"type" => "string",
		"length" => 1600,
		"notnull" => true,
	),
	"delivered" => array(
		"type" => "boolean",
		"default" => '0'
	),
	"read" => array(
		"type" => "boolean",
		"default" => '0'
	),
	"adaptor" => array(
		"type" => "string",
		"length" => 45,
		"notnull" => false,
	),
	"emid" => array(
		"type" => "string",
		"length" => 255,
		"notnull" => false,
	),
	"didid" => array(
		"type" => "integer"
	),
	"timestamp" => array(
		"type" => "integer"
	)
);
$s = $table->modify($cols);
unset($table);

out('Creating SMS Routing Table');
$table = FreePBX::Database()->migrate("sms_dids");
$cols = array(
	"id" => array(
		"type" => "integer",
		"primaryKey" => true,
		"autoincrement" => true
	),
	"did" => array(
		"type" => "string",
		"length" => 45,
		"notnull" => true,
	)
);

$indexes = array (
	'did' =>
	array (
		'type' => 'unique',
		'cols' =>
		array (
			0 => 'did'
		)
	)
);

$s = $table->modify($cols,$indexes);
unset($table);

out('Creating SMS Routing Table');
$table = FreePBX::Database()->migrate("sms_routing");
$cols = array(
	"id" => array(
		"type" => "integer",
		"primaryKey" => true,
		"autoincrement" => true
	),
	"did" => array(
		"type" => "string",
		"length" => 45,
		"notnull" => true,
	),
	"uid" => array(
		"type" => "integer",
		"notnull" => true,
	),
	"accepter" => array(
		"type" => "string",
		"length" => 45,
		"notnull" => false,
	),
	"adaptor" => array(
		"type" => "string",
		"length" => 45,
		"notnull" => false,
	),
	"didid" => array(
		"type" => "integer"
	)
);
$s = $table->modify($cols);
unset($table);

out('Creating SMS Media Table');
$table = FreePBX::Database()->migrate("sms_media");
$cols = array(
	"id" => array(
		"type" => "integer",
		"primaryKey" => true,
		"autoincrement" => true
	),
	"mid" => array(
		"type" => "integer",
		"notnull" => true,
	),
	"name" => array(
		"type" => "string",
		"length" => 255,
		"notnull" => true,
	),
	"raw" => array(
		"type" => "blob",
		"notnull" => true,
	)
);
$s = $table->modify($cols);
unset($table);

$database = FreePBX::create()->Database;

$sth = $database->prepare("SELECT * FROM sms_messages WHERE threadid = ''");
$sth->execute();
$messages = $sth->fetchAll(PDO::FETCH_ASSOC);
$threads = array();
foreach($messages as $message) {
	if($message['direction'] == 'in') {
		$local = $message['to'];
		$remote = $message['from'];
	} else {
		$local = $message['from'];
		$remote = $message['to'];
	}
	$threadid = sha1($local.$remote);
	$message['threadid'] = $threadid;
	$threads[$threadid][] = $message;
	$sth = $database->prepare("UPDATE sms_messages SET threadid = :threadid WHERE id = :id");
	$sth->execute(array("threadid" => $threadid, "id" => $message['id']));
}

$sth = $database->prepare("SELECT DISTINCT did FROM sms_dids");
$sth->execute();
$dids = $sth->fetchAll();
if(empty($dids)) {
	$sth = $database->prepare("SELECT DISTINCT did FROM sms_routing");
	$sth->execute();
	$dids = $sth->fetchAll(PDO::FETCH_ASSOC);
	$routing = array();
	foreach($dids as $did) {
		$sth = $database->prepare("INSERT INTO sms_dids (`did`) VALUES (:did)");
		$sth->execute(array(
			":did" => $did['did']
		));
		$id = $database->lastInsertId();
		$routing[$did['did']] = $id;
	}

	$sth = $database->prepare("SELECT * FROM sms_messages WHERE didid = ''");
	$sth->execute();
	$messages = $sth->fetchAll(PDO::FETCH_ASSOC);
	foreach($messages as $message) {
		if($message['direction'] == 'in') {
			$local = $message['to'];
			$remote = $message['from'];
		} else {
			$local = $message['from'];
			$remote = $message['to'];
		}
		$sth = $database->prepare("UPDATE sms_messages SET didid = :didid WHERE id = :id");
		$sth->execute(array(
			":didid" => $routing[$local],
			":id" => $message['id']
		));
	}

	$sth = $database->prepare("SELECT * FROM sms_routing WHERE didid = ''");
	$sth->execute();
	$routes = $sth->fetchAll(PDO::FETCH_ASSOC);
	foreach($routes as $route) {
		$sth = $database->prepare("UPDATE sms_routing SET didid = :didid WHERE did = :did");
		$sth->execute(array(
			":didid" => $routing[$route['did']],
			":did" => $route['did']
		));
	}

	$database->query("UPDATE sms_messages SET `timestamp` = UNIX_TIMESTAMP(tx_rx_datetime)");
}

$sth = $database->prepare("SELECT * FROM sms_messages WHERE emid IS NULL");
$sth->execute();
$nullemid = $sth->fetchAll();
foreach($nullemid as $message) {
	$sth = $database->prepare("UPDATE sms_messages SET emid = :emid WHERE id = :id");
	$sth->execute(array(
		":emid" => 'sms-'.uniqid(),
		":id" => $message['id']
	));
}
