
NetworkC = Class.extend({
	init: function(){
		var self = this;

		this.i = false
		this.loadNetworkConfig();

		if (window.cloudpbx) {
			return;
		}

		// Set the 'IP' box to enabled when it's Static
		$("input[name=bootproto]").change(function() {
			if ($(this).attr('id') == "bootproto-static") {
				$(".staticdisabled").prop('disabled', false);
			} else {
				$(".staticdisabled").prop('disabled', true);
			}
		});

		// Same when creating interfaces
		$("input[name=newintbootproto]").change(function() {
			if ($(this).attr('id') == "nibp-static") {
				$(".nibpstaticdisabled").prop('disabled', false);
			} else {
				$(".nibpstaticdisabled").prop('disabled', true);
			}
		});

		// Bind the 'create interface' to open the modal
		$("#add_int").click(function() { $("#addintmodal").modal(); });

		// Save interface pops up the warning.
		$("#save_int").click(function() { $("#savechangesmodal").modal(); });

		// Someone's clicked on Save and Apply
		$("#saveapply").click(function() { self.saveInterface(); });

		// Show or hide vlan/label when adding an int
		$("input[name=inttype]").change(function() {
			if ($(this).attr('id') == "intsecondary") {
				$("#secondaryform").show();
				$("#vlanform").hide();
			} else {
				$("#secondaryform").hide();
				$("#vlanform").show();
			}
		});

		// Someone's clicked on Save and Apply when creating an int
		$("#docreateint").click(function(e) { e.preventDefault(); self.createInterface(); });

		// Woo, we can delete an interface!
		$("#delint").click(function() { 
			// Load the interface name into the modal first
			var intname = self.interfaces[$("#select_network_device").val()].DEVICE;
			$("#intdelname").text(intname);
			$("#delintmodal").modal();
		});
		$("#dodelint").click(function() { self.submitInterfaceDelete(); });

	},

	loadNetworkConfig: function() {
		// For use in ajax
		var self = this;

		// Remove trigger from selects
		$("#select_network_device").off("change");
		$("#newintselect").off("change");

		// Ajax the network config
		var req = { module: 'sysadmin', command: 'getnetworkconfig' };
		$.ajax({
			url: window.ajaxurl,
			data: req,
			success: function(data) { 
				self.netconf = data;
				// Load the select
				self.updateNetworks();
				// Add trigger back to select
				$("#select_network_device").on("change", function() { self.showInterfaceId($(this).val()) });
				$("#newintselect").on("change", function() { self.changeAddInt($(this).val()) });

				// Is this the first time we're called?
				if (self.i === false) {
					self.showInterfaceId(0);
					self.i = true;
				}
			},

		});
	},

	updateNetworks: function() {
		var self = this;

		// Remove all entries from main and addnew select
		$("#select_network_device,#newintselect").find('option').remove();
		$("#select_network_device,#newintselect").attr('disabled', false);

		// Add the new ones 
		// We do HAVE a new one, right?
		if (Object.keys(this.netconf.interfaces).length == 0) {
			// Bad. 
			$("#select_network_device,#newintselect").append('<option>No Interfaces</option>');
			$("#select_network_device,#newintselect").attr('disabled', true);
			return;
		}

		// OK, cool
		this.interfaces = [];
		this.intindex = 0;

		$.each(this.netconf.interfaces, function(k, v) {
			console.log("Looking at interface "+k);
			var myindex = self.intindex++;
			if (v.addresses.length == 0) {
				// Nothing assigned to this interface
				var conf = { DEVICE: k, BOOTPROTO: 'unconf' }
				conf.PARENT = v.config.PARENT;
				self.interfaces[myindex] = conf;
				$("#select_network_device").append($('<option>', { value: myindex, text: k }));
			} else { 
				// Take the first IP address, ignore any others
				self.interfaces[myindex] = v.config;
				self.interfaces[myindex].ipaddr = v.addresses[0][0];
				self.interfaces[myindex].netmask = v.addresses[0][2];
				$("#select_network_device").append($('<option>', { value: myindex, text: k }));
			};
			// Only add to newintselect if it can be used as a parent
			if (v.config.PARENT === true) {
				$("#newintselect").append($('<option>', { value: myindex, text: k }));
			}
		});
	},

	showInterfaceId: function(id) {
		if (typeof(this.interfaces[id]) == "undefined") {
			console.log("Error. Tried to show non-existing int "+id);
			return;
		}

		var i = this.interfaces[id];

		// Is it static or DHCP?
		if (typeof(i.BOOTPROTO) == "undefined" || i.BOOTPROTO == "static") {
			// It's static.
			$("#bootproto-static").click();
		} else if (i.BOOTPROTO == "unconf" || i.BOOTPROTO == "") {
			$("#bootproto-none").click();
		} else { 
			$("#bootproto-dhcp").click();
		}

		// Load the fields
		if (typeof(i.ipaddr) != "undefined") {
			$("#staticip").val(i.ipaddr);
		} else {
			$("#staticip").val("");
		}

		if (typeof(i.netmask) != "undefined") {
			$("#netmask").val(i.netmask);
		} else {
			$("#netmask").val("");
		}

		if (typeof(i.GATEWAY) != "undefined") {
			$("#gateway").val(i.GATEWAY);
		} else {
			// Is this the interface with the default route?
			if (this.netconf.gateway.interface == i.DEVICE) {
				$("#gateway").val(this.netconf.gateway.router);
			} else {
				$("#gateway").val("");
			}
		}

		if (typeof(i.HWADDR) != "undefined") {
			$("#macaddr").val(i.HWADDR);
		} else {
			$("#macaddr").val("");
		}

		if (typeof(i.ONBOOT) != "undefined" && (i.ONBOOT == "yes" || i.ONBOOT == 1)) {
			$("#onboot-yes").click();
		} else {
			$("#onboot-no").click();
		}

		// Is it a VLAN interface?
		if (typeof(i.VLANID) != "undefined") {
			$("#vlanwarning>p").text("Warning: VLAN ID "+i.VLANID+"!");
			$("#vlanwarning").slideDown();
		} else {
			$("#vlanwarning>p").text("");
			$("#vlanwarning").slideUp();
		}

		// Can it be deleted?
		if (typeof(i.CANDELETE) != "undefined" && i.CANDELETE == true) {
			$("#delint").show();
		} else {
			$("#delint").hide();
		}

		// Does it have an override warning?
		if (typeof(i.OVERRIDE) != "undefined") {
			$("#vlanwarning>p").text(i.OVERRIDE);
			$("#vlanwarning").slideDown();
			$(".staticdisabled").prop('disabled', true);
			$("input[name=bootproto]").prop('disabled', true)
			$("input[name=onboot]").prop('disabled', true)
		} else {
			$("#vlanwarning>p").text("");
			$("#vlanwarning").slideUp();
			$("input[name=bootproto]").prop('disabled', false)
			$("input[name=onboot]").prop('disabled', false)
		}



	},

	changeAddInt: function(id) {
		if (typeof(this.interfaces[id]) == "undefined") {
			console.log("Error. Tried to show non-existing int "+id);
			return;
		}

		var i = this.interfaces[id];

		// If we're a VLAN, we can only add a secondary
		if (typeof(i.VLAN) != "undefined") {
			// Disable VLAN, select 'secondary'
			$("#intsecondary").click(); // Trigger the event by clicking on it.
			$("#intvlan").prop('disabled', true);
		} else {
			$("#intvlan").prop('disabled', false);
		}
	},

	saveInterface: function() {
		// They've pushed the save button in the modal.
		var self = this;

		// Interface name
		var intname = this.interfaces[$("#select_network_device").val()].DEVICE;

		// Build the details for ajax
		var req = {
			module: 'sysadmin',
			command: 'savenetwork',
			interface: intname,
			protocol: $("input[name=bootproto]:checked").attr('value'),
			ipaddr: $("#staticip").val(),
			netmask: $("#netmask").val(),
			gateway: $("#gateway").val(),
			onboot: $("input[name=onboot]:checked").attr('value'),
		};

		// Disable the buttons
		$(".btn", "#savechangesmodal").prop('disabled', true)
		$("#savestatus").text("Saving changes to "+intname+"...");

		$.ajax({
			url: window.ajaxurl,
			data: req,
			success: function(data) { 
				if (typeof(data.state) == "unset" || data.state != "success") {
					console.log("error", data);
					$(".btn", "#savechangesmodal").prop('disabled', false)
					$("#savestatus").text("Error: "+data.message);
					return;
				}
				window.location.href = window.location.href;
			},
		});
	},

	createInterface: function() {
		// They've pushed the save button in the modal.
		var self = this;

		// Interface name
		var intname = this.interfaces[$("#newintselect").val()].DEVICE;

		// Build the details for ajax
		var req = {
			module: 'sysadmin',
			command: 'createnetwork',
			parent: intname,
			inttype: $("input[name=inttype]:checked").attr('value'),
			intlabel: $("#intlabel").val(),
			vlanid: $("#vlanvid").val(),
			protocol: $("input[name=newintbootproto]:checked").attr('value'),
			ipaddr: $("#newintipaddr").val(),
			netmask: $("#newintsubnet").val(),
		};

		// Disable the buttons
		$(".btn", "#addintmodal").prop('disabled', true)
		$("#addintstatus").text("Creating Interface...");

		$.ajax({
			url: window.ajaxurl,
			data: req,
			success: function(data) { 
				if (typeof(data.message) != "undefined") {
					$("#addintstatus").text(data.message);
				} else {
					$("#addintstatus").text("");
				}
				if (typeof(data.state) == "undefined") {
					console.log("error", data);
					$(".btn", "#addintmodal").prop('disabled', false)
					return;
				} else if (data.state == "failed") {
					$(".btn", "#addintmodal").prop('disabled', false)
					if (typeof(data.faileditems) != "undefined") {
						$.each(data.faileditems, function(i, v) {
							// Flash the fields that have errors.
							$("#"+v+":visible").addClass("pulsebg").focus();
							window.setTimeout(function() { $("#"+v+":visible").removeClass("pulsebg"); }, 2000);
						});
					}
					return;
				}
				// No errors. Reload
				window.location.href = window.location.href;
			},
		});
	},

	submitInterfaceDelete: function() {
		// They've pushed the save button in the modal.
		var intname = $("#intdelname").text();

		// Build the details for ajax
		var req = {
			module: 'sysadmin',
			command: 'deleteinterface',
			interface: intname,
		};

		$(".btn", "#delintmodal").prop('disabled', true);

		$.ajax({
			url: window.ajaxurl,
			data: req,
			success: function(data) { 
				window.location.href = window.location.href;
			},
		});
	},
});


$(document).ready(function() {
	window.Network = new NetworkC();
});
