DROP TABLE IF EXISTS `weatheroptions`;

CREATE TABLE `weatheroptions` (
  `engine` varchar(40),
  `wgroundkey` varchar(40),
	PRIMARY KEY  (`engine`)  
);

DROP TABLE IF EXISTS `zipcodes`;

CREATE TABLE `zipcodes` (
  `id` mediumint(6) NOT NULL auto_increment,
  `zip` varchar(5) NOT NULL default '',
  `latitude` varchar(11) NOT NULL default '',
  `longitude` varchar(11) NOT NULL default '',
  `city` varchar(40) NOT NULL default '',
  `state` char(2) NOT NULL default '',
  `fullstate` varchar(30) NOT NULL default '',
  `county` varchar(40) NOT NULL default '',
  `zipclass` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `zip` (`zip`),
  KEY `city` (`city`,`state`),
  KEY `state` (`state`,`city`)
) ENGINE=MyISAM DEFAULT CHARSET=ascii AUTO_INCREMENT=42742 ;


INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(1, '00501', '+40.922326', '-072.637078', 'HOLTSVILLE', 'NY', 'NEW YORK', 'SUFFOLK', 'UNIQUE'),
(2, '00544', '+40.922326', '-072.637078', 'HOLTSVILLE', 'NY', 'NEW YORK', 'SUFFOLK', 'UNIQUE'),
(3, '00601', '+18.165273', '-066.722583', 'ADJUNTAS', 'PR', 'PUERTO RICO', 'ADJUNTAS', 'STANDARD'),
(4, '00602', '+18.393103', '-067.180953', 'AGUADA', 'PR', 'PUERTO RICO', 'AGUADA', 'STANDARD'),
(5, '00603', '+18.455913', '-067.145780', 'AGUADILLA', 'PR', 'PUERTO RICO', 'AGUADILLA', 'STANDARD'),
(6, '00604', '+18.493520', '-067.135883', 'AGUADILLA', 'PR', 'PUERTO RICO', 'AGUADILLA', 'STANDARD'),
(7, '00605', '+18.465162', '-067.141486', 'AGUADILLA', 'PR', 'PUERTO RICO', 'AGUADILLA', 'STANDARD'),
(8, '00606', '+18.172947', '-066.944111', 'MARICAO', 'PR', 'PUERTO RICO', 'MARICAO', 'STANDARD'),
(9, '00610', '+18.288685', '-067.139696', 'ANASCO', 'PR', 'PUERTO RICO', 'ANASCO', 'STANDARD'),
(10, '00611', '+18.279531', '-066.802170', 'ANGELES', 'PR', 'PUERTO RICO', 'UTUADO', 'PO BOX ONLY'),
(11, '00612', '+18.450674', '-066.698262', 'ARECIBO', 'PR', 'PUERTO RICO', 'ARECIBO', 'STANDARD'),
(12, '00613', '+18.458093', '-066.732732', 'ARECIBO', 'PR', 'PUERTO RICO', 'ARECIBO', 'STANDARD'),
(13, '00614', '+18.429675', '-066.674506', 'ARECIBO', 'PR', 'PUERTO RICO', 'ARECIBO', 'STANDARD'),
(14, '00616', '+18.444792', '-066.640678', 'BAJADERO', 'PR', 'PUERTO RICO', 'ARECIBO', 'STANDARD'),
(15, '00617', '+18.447092', '-066.544255', 'BARCELONETA', 'PR', 'PUERTO RICO', 'BARCELONETA', 'STANDARD'),
(16, '00622', '+17.998531', '-067.187318', 'BOQUERON', 'PR', 'PUERTO RICO', 'CABO ROJO', 'STANDARD'),
(17, '00623', '+18.062201', '-067.149541', 'CABO ROJO', 'PR', 'PUERTO RICO', 'CABO ROJO', 'STANDARD'),
(18, '00624', '+18.023535', '-066.726156', 'PENUELAS', 'PR', 'PUERTO RICO', 'PENUELAS', 'STANDARD'),
(19, '00627', '+18.477891', '-066.854770', 'CAMUY', 'PR', 'PUERTO RICO', 'CAMUY', 'STANDARD'),
(20, '00631', '+18.269187', '-066.864993', 'CASTANER', 'PR', 'PUERTO RICO', 'LARES', 'STANDARD'),
(21, '00636', '+18.113284', '-067.039706', 'ROSARIO', 'PR', 'PUERTO RICO', 'SAN GERMAN', 'STANDARD'),
(22, '00637', '+18.087322', '-066.934911', 'SABANA GRANDE', 'PR', 'PUERTO RICO', 'SABANA GRANDE', 'STANDARD'),
(23, '00638', '+18.336160', '-066.472087', 'CIALES', 'PR', 'PUERTO RICO', 'CIALES', 'STANDARD'),
(24, '00641', '+18.250027', '-066.698957', 'UTUADO', 'PR', 'PUERTO RICO', 'UTUADO', 'STANDARD'),
(25, '00646', '+18.436060', '-066.281954', 'DORADO', 'PR', 'PUERTO RICO', 'DORADO', 'STANDARD'),
(26, '00647', '+17.969594', '-066.939754', 'ENSENADA', 'PR', 'PUERTO RICO', 'GUANICA', 'STANDARD'),
(27, '00650', '+18.360125', '-066.562311', 'FLORIDA', 'PR', 'PUERTO RICO', 'FLORIDA', 'STANDARD'),
(28, '00652', '+18.457254', '-066.603358', 'GARROCHALES', 'PR', 'PUERTO RICO', 'ARECIBO', 'STANDARD'),
(29, '00653', '+17.972468', '-066.898661', 'GUANICA', 'PR', 'PUERTO RICO', 'GUANICA', 'STANDARD'),
(30, '00656', '+18.023280', '-066.786909', 'GUAYANILLA', 'PR', 'PUERTO RICO', 'GUAYANILLA', 'STANDARD'),
(31, '00659', '+18.481391', '-066.808696', 'HATILLO', 'PR', 'PUERTO RICO', 'HATILLO', 'STANDARD'),
(32, '00660', '+18.145486', '-067.135323', 'HORMIGUEROS', 'PR', 'PUERTO RICO', 'HORMIGUEROS', 'STANDARD'),
(33, '00662', '+18.480285', '-067.028155', 'ISABELA', 'PR', 'PUERTO RICO', 'ISABELA', 'STANDARD'),
(34, '00664', '+18.217606', '-066.598306', 'JAYUYA', 'PR', 'PUERTO RICO', 'JAYUYA', 'STANDARD'),
(35, '00667', '+18.015099', '-067.055973', 'LAJAS', 'PR', 'PUERTO RICO', 'LAJAS', 'STANDARD'),
(36, '00669', '+18.295952', '-066.881925', 'LARES', 'PR', 'PUERTO RICO', 'LARES', 'STANDARD'),
(37, '00670', '+18.252135', '-066.990967', 'LAS MARIAS', 'PR', 'PUERTO RICO', 'LAS MARIAS', 'STANDARD'),
(38, '00674', '+18.445530', '-066.490268', 'MANATI', 'PR', 'PUERTO RICO', 'MANATI', 'STANDARD'),
(39, '00676', '+18.383727', '-067.080799', 'MOCA', 'PR', 'PUERTO RICO', 'MOCA', 'STANDARD'),
(40, '00677', '+18.335781', '-067.252547', 'RINCON', 'PR', 'PUERTO RICO', 'RINCON', 'STANDARD'),
(41, '00678', '+18.453030', '-066.933689', 'QUEBRADILLAS', 'PR', 'PUERTO RICO', 'QUEBRADILLAS', 'STANDARD'),
(42, '00680', '+18.219023', '-067.508068', 'MAYAGUEZ', 'PR', 'PUERTO RICO', 'MAYAGUEZ', 'STANDARD'),
(43, '00681', '+18.219023', '-067.508068', 'MAYAGUEZ', 'PR', 'PUERTO RICO', 'MAYAGUEZ', 'STANDARD'),
(44, '00682', '+18.219023', '-067.508068', 'MAYAGUEZ', 'PR', 'PUERTO RICO', 'MAYAGUEZ', 'STANDARD'),
(45, '00683', '+18.113284', '-067.039706', 'SAN GERMAN', 'PR', 'PUERTO RICO', 'SAN GERMAN', 'STANDARD'),
(46, '00685', '+18.323600', '-066.972227', 'SAN SEBASTIAN', 'PR', 'PUERTO RICO', 'SAN SEBASTIAN', 'STANDARD'),
(47, '00687', '+18.316976', '-066.415207', 'MOROVIS', 'PR', 'PUERTO RICO', 'MOROVIS', 'STANDARD'),
(48, '00688', '+18.429675', '-066.674506', 'SABANA HOYOS', 'PR', 'PUERTO RICO', 'ARECIBO', 'STANDARD'),
(49, '00690', '+18.476196', '-067.139597', 'SAN ANTONIO', 'PR', 'PUERTO RICO', 'AGUADILLA', 'STANDARD'),
(50, '00692', '+18.435818', '-066.338523', 'VEGA ALTA', 'PR', 'PUERTO RICO', 'VEGA ALTA', 'STANDARD'),
(51, '00693', '+18.443109', '-066.398302', 'VEGA BAJA', 'PR', 'PUERTO RICO', 'VEGA BAJA', 'STANDARD'),
(52, '00694', '+18.443109', '-066.398302', 'VEGA BAJA', 'PR', 'PUERTO RICO', 'VEGA BAJA', 'STANDARD'),
(53, '00698', '+18.061040', '-066.861164', 'YAUCO', 'PR', 'PUERTO RICO', 'YAUCO', 'STANDARD'),
(54, '00703', '+18.250398', '-066.128450', 'AGUAS BUENAS', 'PR', 'PUERTO RICO', 'AGUAS BUENAS', 'STANDARD'),
(55, '00704', '+17.992290', '-066.139253', 'AGUIRRE', 'PR', 'PUERTO RICO', 'GUAYAMA', 'STANDARD'),
(56, '00705', '+18.128092', '-066.268717', 'AIBONITO', 'PR', 'PUERTO RICO', 'AIBONITO', 'STANDARD'),
(57, '00707', '+18.007014', '-065.898719', 'MAUNABO', 'PR', 'PUERTO RICO', 'MAUNABO', 'STANDARD'),
(58, '00714', '+17.967510', '-066.041380', 'ARROYO', 'PR', 'PUERTO RICO', 'ARROYO', 'STANDARD'),
(59, '00715', '+18.011854', '-066.563721', 'MERCEDITA', 'PR', 'PUERTO RICO', 'PONCE', 'STANDARD'),
(60, '00716', '+18.001995', '-066.607429', 'PONCE', 'PR', 'PUERTO RICO', 'PONCE', 'STANDARD'),
(61, '00717', '+18.001995', '-066.607429', 'PONCE', 'PR', 'PUERTO RICO', 'PONCE', 'STANDARD'),
(62, '00718', '+18.221390', '-065.778310', 'NAGUABO', 'PR', 'PUERTO RICO', 'NAGUABO', 'STANDARD'),
(63, '00719', '+18.298017', '-066.229751', 'NARANJITO', 'PR', 'PUERTO RICO', 'NARANJITO', 'STANDARD'),
(64, '00720', '+18.226862', '-066.394020', 'OROCOVIS', 'PR', 'PUERTO RICO', 'OROCOVIS', 'STANDARD'),
(65, '00721', '+18.364161', '-065.778288', 'PALMER', 'PR', 'PUERTO RICO', 'RIO GRANDE', 'STANDARD'),
(66, '00723', '+18.009994', '-066.010572', 'PATILLAS', 'PR', 'PUERTO RICO', 'PATILLAS', 'STANDARD'),
(67, '00725', '+18.212965', '-066.058033', 'CAGUAS', 'PR', 'PUERTO RICO', 'CAGUAS', 'STANDARD'),
(68, '00726', '+18.212965', '-066.058033', 'CAGUAS', 'PR', 'PUERTO RICO', 'CAGUAS', 'STANDARD'),
(69, '00727', '+18.212965', '-066.058033', 'CAGUAS', 'PR', 'PUERTO RICO', 'CAGUAS', 'STANDARD'),
(70, '00728', '+18.001995', '-066.607429', 'PONCE', 'PR', 'PUERTO RICO', 'PONCE', 'STANDARD'),
(71, '00729', '+18.333093', '-065.883864', 'CANOVANAS', 'PR', 'PUERTO RICO', 'CANOVANAS', 'STANDARD'),
(72, '00730', '+18.001995', '-066.607429', 'PONCE', 'PR', 'PUERTO RICO', 'PONCE', 'STANDARD'),
(73, '00731', '+18.038310', '-066.626344', 'PONCE', 'PR', 'PUERTO RICO', 'PONCE', 'STANDARD'),
(74, '00732', '+18.021781', '-066.613742', 'PONCE', 'PR', 'PUERTO RICO', 'PONCE', 'STANDARD'),
(75, '00733', '+18.019331', '-066.619165', 'PONCE', 'PR', 'PUERTO RICO', 'PONCE', 'STANDARD'),
(76, '00734', '+17.999499', '-066.643934', 'PONCE', 'PR', 'PUERTO RICO', 'PONCE', 'STANDARD'),
(77, '00735', '+18.264872', '-065.594769', 'CEIBA', 'PR', 'PUERTO RICO', 'CEIBA', 'STANDARD'),
(78, '00736', '+18.102967', '-066.139274', 'CAYEY', 'PR', 'PUERTO RICO', 'CAYEY', 'STANDARD'),
(79, '00737', '+18.102967', '-066.139274', 'CAYEY', 'PR', 'PUERTO RICO', 'CAYEY', 'STANDARD'),
(80, '00738', '+18.359381', '-065.611361', 'FAJARDO', 'PR', 'PUERTO RICO', 'FAJARDO', 'STANDARD'),
(81, '00739', '+18.181469', '-066.169519', 'CIDRA', 'PR', 'PUERTO RICO', 'CIDRA', 'STANDARD'),
(82, '00740', '+18.331958', '-065.638780', 'PUERTO REAL', 'PR', 'PUERTO RICO', 'FAJARDO', 'STANDARD'),
(83, '00741', '+18.162156', '-065.753485', 'PUNTA SANTIAGO', 'PR', 'PUERTO RICO', 'HUMACAO', 'STANDARD'),
(84, '00742', '+18.264872', '-065.594769', 'ROOSEVELT ROADS', 'PR', 'PUERTO RICO', 'CEIBA', 'STANDARD'),
(85, '00744', '+18.206329', '-065.743058', 'RIO BLANCO', 'PR', 'PUERTO RICO', 'NAGUABO', 'PO BOX ONLY'),
(86, '00745', '+18.367347', '-065.816583', 'RIO GRANDE', 'PR', 'PUERTO RICO', 'RIO GRANDE', 'STANDARD'),
(87, '00751', '+17.998520', '-066.264825', 'SALINAS', 'PR', 'PUERTO RICO', 'SALINAS', 'STANDARD'),
(88, '00754', '+18.187584', '-065.962389', 'SAN LORENZO', 'PR', 'PUERTO RICO', 'SAN LORENZO', 'STANDARD'),
(89, '00757', '+17.991233', '-066.395543', 'SANTA ISABEL', 'PR', 'PUERTO RICO', 'SANTA ISABEL', 'STANDARD'),
(90, '00765', '+18.123347', '-065.460356', 'VIEQUES', 'PR', 'PUERTO RICO', 'VIEQUES', 'STANDARD'),
(91, '00766', '+18.120519', '-066.496607', 'VILLALBA', 'PR', 'PUERTO RICO', 'VILLALBA', 'STANDARD'),
(92, '00767', '+18.045522', '-065.886988', 'YABUCOA', 'PR', 'PUERTO RICO', 'YABUCOA', 'STANDARD'),
(93, '00769', '+18.095992', '-066.350810', 'COAMO', 'PR', 'PUERTO RICO', 'COAMO', 'STANDARD'),
(94, '00771', '+18.196576', '-065.871970', 'LAS PIEDRAS', 'PR', 'PUERTO RICO', 'LAS PIEDRAS', 'STANDARD'),
(95, '00772', '+18.447406', '-065.899357', 'LOIZA', 'PR', 'PUERTO RICO', 'LOIZA', 'STANDARD'),
(96, '00773', '+18.366027', '-065.708138', 'LUQUILLO', 'PR', 'PUERTO RICO', 'LUQUILLO', 'STANDARD'),
(97, '00775', '+18.323736', '-065.296467', 'CULEBRA', 'PR', 'PUERTO RICO', 'CULEBRA', 'PO BOX ONLY'),
(98, '00777', '+18.206489', '-065.901774', 'JUNCOS', 'PR', 'PUERTO RICO', 'JUNCOS', 'STANDARD'),
(99, '00778', '+18.259092', '-065.974641', 'GURABO', 'PR', 'PUERTO RICO', 'GURABO', 'STANDARD'),
(100, '00780', '+18.001995', '-066.607429', 'COTO LAUREL', 'PR', 'PUERTO RICO', 'PONCE', 'STANDARD'),
(101, '00782', '+18.224958', '-066.219885', 'COMERIO', 'PR', 'PUERTO RICO', 'COMERIO', 'STANDARD'),
(102, '00783', '+18.304369', '-066.330525', 'COROZAL', 'PR', 'PUERTO RICO', 'COROZAL', 'STANDARD'),
(103, '00784', '+17.992290', '-066.139253', 'GUAYAMA', 'PR', 'PUERTO RICO', 'GUAYAMA', 'STANDARD'),
(104, '00785', '+18.018822', '-066.795603', 'GUAYAMA', 'PR', 'PUERTO RICO', 'GUAYANILLA', 'STANDARD'),
(105, '00786', '+18.128092', '-066.268717', 'LA PLATA', 'PR', 'PUERTO RICO', 'AIBONITO', 'PO BOX ONLY'),
(106, '00791', '+18.138029', '-065.788499', 'HUMACAO', 'PR', 'PUERTO RICO', 'HUMACAO', 'STANDARD'),
(107, '00792', '+18.138029', '-065.788499', 'HUMACAO', 'PR', 'PUERTO RICO', 'HUMACAO', 'STANDARD'),
(108, '00794', '+18.200898', '-066.307236', 'BARRANQUITAS', 'PR', 'PUERTO RICO', 'BARRANQUITAS', 'STANDARD'),
(109, '00795', '+17.997367', '-066.493218', 'JUANA DIAZ', 'PR', 'PUERTO RICO', 'JUANA DIAZ', 'STANDARD'),
(110, '00801', '+18.322285', '-064.963715', 'ST THOMAS', 'VI', 'VIRGIN ISLANDS', 'SAINT THOMAS', 'STANDARD'),
(111, '00802', '+18.322285', '-064.963715', 'ST THOMAS', 'VI', 'VIRGIN ISLANDS', 'SAINT THOMAS', 'STANDARD'),
(112, '00803', '+18.322285', '-064.963715', 'ST THOMAS', 'VI', 'VIRGIN ISLANDS', 'SAINT THOMAS', 'STANDARD'),
(113, '00804', '+18.322285', '-064.963715', 'ST THOMAS', 'VI', 'VIRGIN ISLANDS', 'SAINT THOMAS', 'STANDARD'),
(114, '00805', '+18.322285', '-064.963715', 'ST THOMAS', 'VI', 'VIRGIN ISLANDS', 'SAINT THOMAS', 'STANDARD'),
(115, '00820', '+17.734211', '-064.734694', 'CHRISTIANSTED', 'VI', 'VIRGIN ISLANDS', 'SAINT CROIX', 'STANDARD'),
(116, '00821', '+17.734211', '-064.734694', 'CHRISTIANSTED', 'VI', 'VIRGIN ISLANDS', 'SAINT CROIX', 'STANDARD'),
(117, '00822', '+17.734211', '-064.734694', 'CHRISTIANSTED', 'VI', 'VIRGIN ISLANDS', 'SAINT CROIX', 'STANDARD'),
(118, '00823', '+17.734211', '-064.734694', 'CHRISTIANSTED', 'VI', 'VIRGIN ISLANDS', 'SAINT CROIX', 'STANDARD'),
(119, '00824', '+17.734211', '-064.734694', 'CHRISTIANSTED', 'VI', 'VIRGIN ISLANDS', 'SAINT CROIX', 'STANDARD'),
(120, '00830', '+18.328160', '-064.740737', 'ST JOHN', 'VI', 'VIRGIN ISLANDS', 'SAINT JOHN', 'STANDARD'),
(121, '00831', '+18.328160', '-064.740737', 'ST JOHN', 'VI', 'VIRGIN ISLANDS', 'SAINT JOHN', 'STANDARD'),
(122, '00840', '+17.734211', '-064.734694', 'FREDERIKSTED', 'VI', 'VIRGIN ISLANDS', 'SAINT CROIX', 'STANDARD'),
(123, '00841', '+17.734211', '-064.734694', 'FREDERIKSTED', 'VI', 'VIRGIN ISLANDS', 'SAINT CROIX', 'STANDARD'),
(124, '00850', '+17.734211', '-064.734694', 'KINGSHILL', 'VI', 'VIRGIN ISLANDS', 'SAINT CROIX', 'STANDARD'),
(125, '00851', '+17.734211', '-064.734694', 'KINGSHILL', 'VI', 'VIRGIN ISLANDS', 'SAINT CROIX', 'STANDARD'),
(126, '00901', '+18.465901', '-066.103568', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(127, '00902', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(128, '00906', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(129, '00907', '+18.451647', '-066.077003', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(130, '00908', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(131, '00909', '+18.443384', '-066.068133', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(132, '00910', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(133, '00911', '+18.450828', '-066.057859', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(134, '00912', '+18.444187', '-066.059859', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(135, '00913', '+18.450735', '-066.043352', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(136, '00914', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(137, '00915', '+18.437896', '-066.048087', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(138, '00916', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(139, '00917', '+18.422018', '-066.050602', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(140, '00918', '+18.419069', '-066.062319', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(141, '00919', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(142, '00920', '+18.406808', '-066.091885', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(143, '00921', '+18.390429', '-066.066124', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(144, '00922', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(145, '00923', '+18.410775', '-066.036708', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(146, '00924', '+18.396392', '-066.011460', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(147, '00925', '+18.401055', '-066.049773', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(148, '00926', '+18.369376', '-066.062804', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(149, '00927', '+18.385174', '-066.071959', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(150, '00928', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(151, '00929', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(152, '00930', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(153, '00931', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(154, '00933', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(155, '00934', '+18.344870', '-066.166014', 'FORT BUCHANAN', 'PR', 'PUERTO RICO', 'BAYAMON', 'STANDARD'),
(156, '00935', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'UNIQUE'),
(157, '00936', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(158, '00937', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(159, '00938', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(160, '00939', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(161, '00940', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(162, '00949', '+18.431911', '-066.199692', 'TOA BAJA', 'PR', 'PUERTO RICO', 'TOA BAJA', 'STANDARD'),
(163, '00950', '+18.457761', '-066.196503', 'TOA BAJA', 'PR', 'PUERTO RICO', 'TOA BAJA', 'STANDARD'),
(164, '00951', '+18.457761', '-066.196503', 'TOA BAJA', 'PR', 'PUERTO RICO', 'TOA BAJA', 'STANDARD'),
(165, '00952', '+18.457761', '-066.196503', 'SABANA SECA', 'PR', 'PUERTO RICO', 'TOA BAJA', 'STANDARD'),
(166, '00953', '+18.356795', '-066.257010', 'TOA ALTA', 'PR', 'PUERTO RICO', 'TOA ALTA', 'STANDARD'),
(167, '00954', '+18.358939', '-066.258108', 'TOA ALTA', 'PR', 'PUERTO RICO', 'TOA ALTA', 'STANDARD'),
(168, '00955', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(169, '00956', '+18.326702', '-066.174176', 'BAYAMON', 'PR', 'PUERTO RICO', 'BAYAMON', 'STANDARD'),
(170, '00957', '+18.366645', '-066.183907', 'BAYAMON', 'PR', 'PUERTO RICO', 'BAYAMON', 'STANDARD'),
(171, '00958', '+18.344870', '-066.166014', 'BAYAMON', 'PR', 'PUERTO RICO', 'BAYAMON', 'STANDARD'),
(172, '00959', '+18.387058', '-066.159044', 'BAYAMON', 'PR', 'PUERTO RICO', 'BAYAMON', 'STANDARD'),
(173, '00960', '+18.344870', '-066.166014', 'BAYAMON', 'PR', 'PUERTO RICO', 'BAYAMON', 'STANDARD'),
(174, '00961', '+18.413195', '-066.168651', 'BAYAMON', 'PR', 'PUERTO RICO', 'BAYAMON', 'STANDARD'),
(175, '00962', '+18.437644', '-066.140407', 'CATANO', 'PR', 'PUERTO RICO', 'CATANO', 'STANDARD'),
(176, '00963', '+18.443217', '-066.139293', 'CATANO', 'PR', 'PUERTO RICO', 'CATANO', 'STANDARD'),
(177, '00965', '+18.428784', '-066.115390', 'GUAYNABO', 'PR', 'PUERTO RICO', 'GUAYNABO', 'STANDARD'),
(178, '00966', '+18.396815', '-066.114889', 'GUAYNABO', 'PR', 'PUERTO RICO', 'GUAYNABO', 'STANDARD'),
(179, '00968', '+18.410462', '-066.060533', 'GUAYNABO', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(180, '00969', '+18.362322', '-066.113729', 'GUAYNABO', 'PR', 'PUERTO RICO', 'GUAYNABO', 'STANDARD'),
(181, '00970', '+18.359143', '-066.112295', 'GUAYNABO', 'PR', 'PUERTO RICO', 'GUAYNABO', 'STANDARD'),
(182, '00971', '+18.309420', '-066.113606', 'GUAYNABO', 'PR', 'PUERTO RICO', 'GUAYNABO', 'STANDARD'),
(183, '00975', '+18.410462', '-066.060533', 'SAN JUAN', 'PR', 'PUERTO RICO', 'SAN JUAN', 'UNIQUE'),
(184, '00976', '+18.338133', '-065.989229', 'TRUJILLO ALTO', 'PR', 'PUERTO RICO', 'TRUJILLO ALTO', 'STANDARD'),
(185, '00977', '+18.337004', '-065.990099', 'TRUJILLO ALTO', 'PR', 'PUERTO RICO', 'TRUJILLO ALTO', 'STANDARD'),
(186, '00978', '+18.337004', '-065.990099', 'SAINT JUST CONTRACT', 'PR', 'PUERTO RICO', 'TRUJILLO ALTO', 'STANDARD'),
(187, '00979', '+18.410462', '-066.060533', 'CAROLINA', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(188, '00981', '+18.410462', '-066.060533', 'CAROLINA', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(189, '00982', '+18.410462', '-066.060533', 'CAROLINA', 'PR', 'PUERTO RICO', 'SAN JUAN', 'STANDARD'),
(190, '00983', '+18.413452', '-065.977659', 'CAROLINA', 'PR', 'PUERTO RICO', 'CAROLINA', 'STANDARD'),
(191, '00984', '+18.393355', '-065.972495', 'CAROLINA', 'PR', 'PUERTO RICO', 'CAROLINA', 'STANDARD'),
(192, '00985', '+18.345741', '-065.938880', 'CAROLINA', 'PR', 'PUERTO RICO', 'CAROLINA', 'STANDARD'),
(193, '00986', '+18.393355', '-065.972495', 'CAROLINA', 'PR', 'PUERTO RICO', 'CAROLINA', 'STANDARD'),
(194, '00987', '+18.373466', '-065.959932', 'CAROLINA', 'PR', 'PUERTO RICO', 'CAROLINA', 'STANDARD'),
(195, '00988', '+18.393355', '-065.972495', 'CAROLINA', 'PR', 'PUERTO RICO', 'CAROLINA', 'STANDARD'),
(196, '01001', '+42.140549', '-072.788661', 'AGAWAM', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(197, '01002', '+42.367092', '-072.464571', 'AMHERST', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(198, '01003', '+42.369562', '-072.635990', 'AMHERST', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(199, '01004', '+42.384494', '-072.513183', 'AMHERST', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(200, '01005', '+42.329160', '-072.139465', 'BARRE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(201, '01007', '+42.280267', '-072.402056', 'BELCHERTOWN', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(202, '01008', '+42.177833', '-072.958359', 'BLANDFORD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(203, '01009', '+42.206092', '-072.340486', 'BONDSVILLE', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'PO BOX ONLY'),
(204, '01010', '+42.108585', '-072.204480', 'BRIMFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(205, '01011', '+42.294259', '-072.952776', 'CHESTER', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(206, '01012', '+42.392274', '-072.825607', 'CHESTERFIELD', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(207, '01013', '+42.161492', '-072.667341', 'CHICOPEE', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(208, '01014', '+42.170731', '-072.604842', 'CHICOPEE', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(209, '01020', '+42.177492', '-072.562563', 'CHICOPEE', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(210, '01021', '+42.170731', '-072.604842', 'CHICOPEE', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(211, '01022', '+42.193392', '-072.554360', 'CHICOPEE', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(212, '01026', '+42.428617', '-072.909841', 'CUMMINGTON', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(213, '01027', '+42.368303', '-072.768839', 'EASTHAMPTON', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(214, '01028', '+42.062009', '-072.498740', 'EAST LONGMEADOW', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(215, '01029', '+42.190904', '-073.051661', 'EAST OTIS', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'PO BOX ONLY'),
(216, '01030', '+42.189335', '-072.797740', 'FEEDING HILLS', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(217, '01031', '+42.352554', '-072.205724', 'GILBERTVILLE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(218, '01032', '+42.443837', '-072.819446', 'GOSHEN', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(219, '01033', '+42.262285', '-072.504086', 'GRANBY', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(220, '01034', '+42.112748', '-072.952003', 'GRANVILLE', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(221, '01035', '+42.356804', '-072.576613', 'HADLEY', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(222, '01036', '+42.067614', '-072.417507', 'HAMPDEN', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(223, '01037', '+42.347856', '-072.225251', 'HARDWICK', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(224, '01038', '+42.387269', '-072.643081', 'HATFIELD', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(225, '01039', '+42.356410', '-072.682127', 'HAYDENVILLE', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(226, '01040', '+42.198291', '-072.642070', 'HOLYOKE', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(227, '01041', '+42.170731', '-072.604842', 'HOLYOKE', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(228, '01050', '+42.313427', '-072.903677', 'HUNTINGTON', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(229, '01053', '+42.353838', '-072.704385', 'LEEDS', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(230, '01054', '+42.474681', '-072.467543', 'LEVERETT', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(231, '01056', '+42.173276', '-072.627038', 'LUDLOW', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(232, '01057', '+42.095323', '-072.282063', 'MONSON', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(233, '01059', '+42.369562', '-072.635990', 'NORTH AMHERST', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(234, '01060', '+42.415154', '-072.769270', 'NORTHAMPTON', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(235, '01061', '+42.369562', '-072.635990', 'NORTHAMPTON', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(236, '01062', '+42.328838', '-072.845227', 'FLORENCE', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(237, '01063', '+42.317939', '-072.640234', 'NORTHAMPTON', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'UNIQUE'),
(238, '01066', '+42.406697', '-072.633901', 'NORTH HATFIELD', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'PO BOX ONLY'),
(239, '01068', '+42.346144', '-072.058847', 'OAKHAM', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(240, '01069', '+42.176131', '-072.314570', 'PALMER', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(241, '01070', '+42.448984', '-072.958397', 'PLAINFIELD', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(242, '01071', '+42.177432', '-072.864558', 'RUSSELL', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(243, '01072', '+42.471562', '-072.440170', 'SHUTESBURY', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(244, '01073', '+42.230008', '-072.728463', 'SOUTHAMPTON', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(245, '01074', '+42.375998', '-072.149388', 'SOUTH BARRE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(246, '01075', '+42.249840', '-072.581520', 'SOUTH HADLEY', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(247, '01077', '+42.066644', '-072.541205', 'SOUTHWICK', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(248, '01079', '+42.192892', '-072.329574', 'THORNDIKE', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'PO BOX ONLY'),
(249, '01080', '+42.179805', '-072.517813', 'THREE RIVERS', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(250, '01081', '+42.061948', '-072.213598', 'WALES', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(251, '01082', '+42.377471', '-072.548549', 'WARE', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(252, '01083', '+42.204027', '-072.199439', 'WARREN', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(253, '01084', '+42.390303', '-072.870857', 'WEST CHESTERFIELD', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'PO BOX ONLY'),
(254, '01085', '+42.148690', '-072.501887', 'WESTFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(255, '01086', '+42.173428', '-072.847964', 'WESTFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(256, '01088', '+42.390583', '-072.646894', 'WEST HATFIELD', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(257, '01089', '+42.125793', '-072.645334', 'WEST SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(258, '01090', '+42.170731', '-072.604842', 'WEST SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(259, '01092', '+42.202887', '-072.229025', 'WEST WARREN', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(260, '01093', '+42.442673', '-072.652511', 'WHATELY', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'PO BOX ONLY'),
(261, '01094', '+42.358201', '-072.140846', 'WHEELWRIGHT', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(262, '01095', '+42.125974', '-072.489988', 'WILBRAHAM', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(263, '01096', '+42.413069', '-072.821653', 'WILLIAMSBURG', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(264, '01097', '+42.161743', '-072.845912', 'WORONOCO', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(265, '01098', '+42.404940', '-072.896133', 'WORTHINGTON', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'STANDARD'),
(266, '01101', '+42.170731', '-072.604842', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(267, '01102', '+42.170731', '-072.604842', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(268, '01103', '+42.103044', '-072.590783', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(269, '01104', '+42.128605', '-072.567966', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(270, '01105', '+42.099793', '-072.577732', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(271, '01106', '+42.049194', '-072.567882', 'LONGMEADOW', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(272, '01107', '+42.126237', '-072.586733', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(273, '01108', '+42.080594', '-072.558081', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(274, '01109', '+42.119293', '-072.548981', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(275, '01111', '+42.170731', '-072.604842', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'UNIQUE'),
(276, '01114', '+42.170731', '-072.604842', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'UNIQUE'),
(277, '01115', '+42.102894', '-072.591633', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'UNIQUE'),
(278, '01116', '+42.170731', '-072.604842', 'LONGMEADOW', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(279, '01118', '+42.093894', '-072.523227', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(280, '01119', '+42.124943', '-072.526705', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(281, '01128', '+42.094616', '-072.487229', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(282, '01129', '+42.124485', '-072.489479', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(283, '01133', '+42.170731', '-072.604842', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'UNIQUE'),
(284, '01138', '+42.170731', '-072.604842', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(285, '01139', '+42.170731', '-072.604842', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(286, '01144', '+42.101796', '-072.591510', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(287, '01151', '+42.150593', '-072.512780', 'INDIAN ORCHARD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(288, '01152', '+42.170731', '-072.604842', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(289, '01199', '+42.119943', '-072.604983', 'SPRINGFIELD', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'UNIQUE'),
(290, '01201', '+42.479475', '-073.248070', 'PITTSFIELD', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(291, '01202', '+42.392900', '-073.228483', 'PITTSFIELD', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(292, '01203', '+42.392900', '-073.228483', 'PITTSFIELD', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(293, '01220', '+42.385595', '-073.172166', 'ADAMS', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(294, '01222', '+42.185969', '-073.318695', 'ASHLEY FALLS', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(295, '01223', '+42.341800', '-073.103468', 'BECKET', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(296, '01224', '+42.392900', '-073.228483', 'BERKSHIRE', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(297, '01225', '+42.482125', '-073.127483', 'CHESHIRE', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(298, '01226', '+42.470296', '-073.088950', 'DALTON', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(299, '01227', '+42.516145', '-073.092852', 'DALTON', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(300, '01229', '+42.279292', '-073.343545', 'GLENDALE', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'PO BOX ONLY'),
(301, '01230', '+42.299392', '-073.266650', 'GREAT BARRINGTON', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(302, '01235', '+42.292370', '-073.221640', 'HINSDALE', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(303, '01236', '+42.291299', '-073.358798', 'HOUSATONIC', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(304, '01237', '+42.487569', '-073.235048', 'LANESBORO', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(305, '01238', '+42.369856', '-073.267465', 'LEE', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(306, '01240', '+42.459202', '-073.219858', 'LENOX', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(307, '01242', '+42.338594', '-073.250891', 'LENOX DALE', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'PO BOX ONLY'),
(308, '01243', '+42.356088', '-073.010448', 'MIDDLEFIELD', 'MA', 'MASSACHUSETTS', 'HAMPSHIRE', 'PO BOX ONLY'),
(309, '01244', '+42.122827', '-073.253983', 'MILL RIVER', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'PO BOX ONLY'),
(310, '01245', '+42.186690', '-073.206498', 'MONTEREY', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(311, '01247', '+42.426974', '-073.186320', 'NORTH ADAMS', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(312, '01252', '+42.198648', '-073.446234', 'NORTH EGREMONT', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(313, '01253', '+42.213156', '-073.090434', 'OTIS', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(314, '01254', '+42.233105', '-073.238358', 'RICHMOND', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(315, '01255', '+42.148975', '-073.148610', 'SANDISFIELD', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(316, '01256', '+42.367341', '-073.128528', 'SAVOY', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(317, '01257', '+42.314564', '-073.267694', 'SHEFFIELD', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(318, '01258', '+42.128075', '-073.360890', 'SOUTH EGREMONT', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(319, '01259', '+42.198712', '-073.278543', 'SOUTHFIELD', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(320, '01260', '+42.286586', '-073.313274', 'SOUTH LEE', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'PO BOX ONLY'),
(321, '01262', '+42.304604', '-073.330001', 'STOCKBRIDGE', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'PO BOX ONLY'),
(322, '01263', '+42.392900', '-073.228483', 'STOCKBRIDGE', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'UNIQUE'),
(323, '01264', '+42.220001', '-073.197865', 'TYRINGHAM', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(324, '01266', '+42.360482', '-073.265354', 'WEST STOCKBRIDGE', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(325, '01267', '+42.642075', '-073.257699', 'WILLIAMSTOWN', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(326, '01270', '+42.443726', '-073.116127', 'WINDSOR', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(327, '01301', '+42.601335', '-072.623619', 'GREENFIELD', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(328, '01302', '+42.522178', '-072.624164', 'GREENFIELD', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(329, '01330', '+42.562391', '-072.738152', 'ASHFIELD', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(330, '01331', '+42.547302', '-072.183903', 'ATHOL', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(331, '01337', '+42.627060', '-072.642888', 'BERNARDSTON', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(332, '01338', '+42.573832', '-072.769487', 'BUCKLAND', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(333, '01339', '+42.594252', '-072.665507', 'CHARLEMONT', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(334, '01340', '+42.681539', '-072.822986', 'COLRAIN', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(335, '01341', '+42.590824', '-072.709760', 'CONWAY', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(336, '01342', '+42.547230', '-072.607679', 'DEERFIELD', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(337, '01343', '+42.642666', '-072.986231', 'DRURY', 'MA', 'MASSACHUSETTS', 'BERKSHIRE', 'STANDARD'),
(338, '01344', '+42.627072', '-072.553654', 'ERVING', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(339, '01346', '+42.618011', '-072.788896', 'HEATH', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(340, '01347', '+42.556558', '-072.518104', 'LAKE PLEASANT', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'PO BOX ONLY'),
(341, '01349', '+42.621412', '-072.705633', 'TURNERS FALLS', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(342, '01350', '+42.721456', '-072.976204', 'MONROE BRIDGE', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'PO BOX ONLY'),
(343, '01351', '+42.548107', '-072.486930', 'MONTAGUE', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(344, '01354', '+42.522178', '-072.624164', 'NORTHFIELD', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(345, '01355', '+42.518718', '-072.534371', 'NEW SALEM', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(346, '01360', '+42.614152', '-072.528209', 'NORTHFIELD', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(347, '01364', '+42.578325', '-072.556589', 'ORANGE', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(348, '01366', '+42.459632', '-072.182962', 'PETERSHAM', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(349, '01367', '+42.683065', '-072.715667', 'ROWE', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(350, '01368', '+42.672182', '-072.196376', 'ROYALSTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(351, '01369', '+42.522178', '-072.624164', 'SHATTUCKVILLE', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(352, '01370', '+42.588812', '-072.758781', 'SHELBURNE FALLS', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(353, '01373', '+42.464522', '-072.682346', 'SOUTH DEERFIELD', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(354, '01375', '+42.565346', '-072.700940', 'SUNDERLAND', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(355, '01376', '+42.654878', '-072.718123', 'TURNERS FALLS', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(356, '01378', '+42.667059', '-072.339655', 'WARWICK', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(357, '01379', '+42.581007', '-072.437179', 'WENDELL', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(358, '01380', '+42.553431', '-072.392694', 'WENDELL DEPOT', 'MA', 'MASSACHUSETTS', 'FRANKLIN', 'STANDARD'),
(359, '01420', '+42.583689', '-071.816767', 'FITCHBURG', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(360, '01430', '+42.654906', '-071.920942', 'ASHBURNHAM', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(361, '01431', '+42.446396', '-071.459405', 'ASHBY', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(362, '01432', '+42.446396', '-071.459405', 'AYER', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(363, '01436', '+42.601427', '-072.083838', 'BALDWINVILLE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(364, '01438', '+42.551681', '-072.029434', 'EAST TEMPLETON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(365, '01440', '+42.582529', '-072.025884', 'GARDNER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(366, '01441', '+42.364807', '-071.896868', 'WESTMINSTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'UNIQUE'),
(367, '01450', '+42.446396', '-071.459405', 'GROTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(368, '01451', '+42.500187', '-071.575864', 'HARVARD', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(369, '01452', '+42.483895', '-072.011516', 'HUBBARDSTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(370, '01453', '+42.471316', '-071.837509', 'LEOMINSTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(371, '01460', '+42.446396', '-071.459405', 'LITTLETON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(372, '01462', '+42.583322', '-071.752266', 'LUNENBURG', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(373, '01463', '+42.446396', '-071.459405', 'PEPPERELL', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(374, '01464', '+42.446396', '-071.459405', 'SHIRLEY', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(375, '01467', '+42.487056', '-071.613078', 'STILL RIVER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(376, '01468', '+42.555059', '-072.072285', 'TEMPLETON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(377, '01469', '+42.446396', '-071.459405', 'TOWNSEND', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(378, '01470', '+42.446396', '-071.459405', 'GROTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(379, '01471', '+42.446396', '-071.459405', 'GROTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(380, '01472', '+42.446396', '-071.459405', 'WEST GROTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'PO BOX ONLY'),
(381, '01473', '+42.549489', '-071.913219', 'WESTMINSTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(382, '01474', '+42.446396', '-071.459405', 'WEST TOWNSEND', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(383, '01475', '+42.661612', '-072.047876', 'WINCHENDON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(384, '01477', '+42.364807', '-071.896868', 'WINCHENDON SPRINGS', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(385, '01501', '+42.184835', '-071.947184', 'AUBURN', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(386, '01503', '+42.312900', '-071.841656', 'BERLIN', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(387, '01504', '+42.114078', '-071.799785', 'BLACKSTONE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(388, '01505', '+42.300037', '-071.943458', 'BOYLSTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(389, '01506', '+42.191690', '-072.105011', 'BROOKFIELD', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(390, '01507', '+42.132770', '-071.972627', 'CHARLTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(391, '01508', '+42.109748', '-072.079455', 'CHARLTON CITY', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(392, '01509', '+42.364807', '-071.896868', 'CHARLTON DEPOT', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(393, '01510', '+42.413972', '-071.687523', 'CLINTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(394, '01515', '+42.205311', '-072.049907', 'EAST BROOKFIELD', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(395, '01516', '+42.113076', '-071.891139', 'DOUGLAS', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(396, '01517', '+42.364807', '-071.896868', 'EAST PRINCETON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(397, '01518', '+42.106405', '-072.114045', 'FISKDALE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(398, '01519', '+42.203944', '-071.682862', 'GRAFTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(399, '01520', '+42.336791', '-071.845316', 'HOLDEN', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(400, '01521', '+42.061063', '-072.163991', 'HOLLAND', 'MA', 'MASSACHUSETTS', 'HAMPDEN', 'STANDARD'),
(401, '01522', '+42.264629', '-071.795442', 'JEFFERSON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(402, '01523', '+42.427188', '-071.911770', 'LANCASTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(403, '01524', '+42.238192', '-072.012379', 'LEICESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(404, '01525', '+42.364807', '-071.896868', 'LINWOOD', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(405, '01526', '+42.364807', '-071.896868', 'MANCHAUG', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(406, '01527', '+42.255642', '-071.819961', 'MILLBURY', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(407, '01529', '+42.124662', '-071.846943', 'MILLVILLE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(408, '01531', '+42.320938', '-072.128644', 'NEW BRAINTREE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(409, '01532', '+42.322118', '-071.642820', 'NORTHBOROUGH', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(410, '01534', '+42.207191', '-071.856807', 'NORTHBRIDGE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(411, '01535', '+42.275382', '-072.089338', 'NORTH BROOKFIELD', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(412, '01536', '+42.407556', '-071.860402', 'NORTH GRAFTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(413, '01537', '+42.166241', '-071.891052', 'NORTH OXFORD', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(414, '01538', '+42.364807', '-071.896868', 'NORTH UXBRIDGE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(415, '01540', '+42.109223', '-071.855444', 'OXFORD', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(416, '01541', '+42.451926', '-071.880057', 'PRINCETON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(417, '01542', '+42.220085', '-071.914361', 'ROCHDALE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(418, '01543', '+42.383516', '-071.954630', 'RUTLAND', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(419, '01545', '+42.286992', '-071.715313', 'SHREWSBURY', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(420, '01546', '+42.364807', '-071.896868', 'SHREWSBURY', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'UNIQUE'),
(421, '01550', '+42.129251', '-072.031155', 'SOUTHBRIDGE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(422, '01560', '+42.176544', '-071.681912', 'SOUTH GRAFTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(423, '01561', '+42.443539', '-071.686137', 'SOUTH LANCASTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'PO BOX ONLY'),
(424, '01562', '+42.254837', '-072.065612', 'SPENCER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(425, '01564', '+42.366765', '-071.939375', 'STERLING', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(426, '01566', '+42.102730', '-072.080996', 'STURBRIDGE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(427, '01568', '+42.175591', '-071.603197', 'UPTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(428, '01569', '+42.059736', '-071.638438', 'UXBRIDGE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(429, '01570', '+42.135100', '-071.994169', 'WEBSTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(430, '01571', '+42.059189', '-071.937037', 'DUDLEY', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(431, '01580', '+42.364807', '-071.896868', 'WESTBOROUGH', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'UNIQUE'),
(432, '01581', '+42.255222', '-071.845865', 'WESTBOROUGH', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(433, '01582', '+42.364807', '-071.896868', 'WESTBOROUGH', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'UNIQUE'),
(434, '01583', '+42.362783', '-071.781215', 'WEST BOYLSTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(435, '01585', '+42.235638', '-072.172523', 'WEST BROOKFIELD', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(436, '01586', '+42.364807', '-071.896868', 'WEST MILLBURY', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(437, '01588', '+42.166554', '-071.899484', 'WHITINSVILLE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(438, '01590', '+42.126575', '-071.755193', 'SUTTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(439, '01601', '+42.265275', '-071.879415', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(440, '01602', '+42.274595', '-071.846966', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(441, '01603', '+42.245442', '-071.839257', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(442, '01604', '+42.247955', '-071.766780', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(443, '01605', '+42.288792', '-071.796128', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(444, '01606', '+42.311834', '-071.794465', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(445, '01607', '+42.226452', '-071.792506', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(446, '01608', '+42.293501', '-071.925696', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(447, '01609', '+42.282565', '-071.827685', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(448, '01610', '+42.246483', '-071.808915', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(449, '01611', '+42.239392', '-071.878716', 'CHERRY VALLEY', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(450, '01612', '+42.304675', '-071.892875', 'PAXTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(451, '01613', '+42.293316', '-071.801971', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(452, '01614', '+42.364807', '-071.896868', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(453, '01615', '+42.364807', '-071.896868', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(454, '01653', '+42.364807', '-071.896868', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'UNIQUE'),
(455, '01654', '+42.364807', '-071.896868', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'UNIQUE'),
(456, '01655', '+42.364807', '-071.896868', 'WORCESTER', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(457, '01701', '+42.446396', '-071.459405', 'FRAMINGHAM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(458, '01702', '+42.446396', '-071.459405', 'FRAMINGHAM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(459, '01703', '+42.446396', '-071.459405', 'FRAMINGHAM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(460, '01704', '+42.446396', '-071.459405', 'FRAMINGHAM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(461, '01705', '+42.446396', '-071.459405', 'FRAMINGHAM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(462, '01718', '+42.446396', '-071.459405', 'VILLAGE OF NAGOG WOODS', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(463, '01719', '+42.446396', '-071.459405', 'BOXBOROUGH', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(464, '01720', '+42.446396', '-071.459405', 'ACTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(465, '01721', '+42.446396', '-071.459405', 'ASHLAND', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(466, '01730', '+42.446396', '-071.459405', 'BEDFORD', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(467, '01731', '+42.446396', '-071.459405', 'HANSCOM AFB', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(468, '01740', '+42.436043', '-071.605916', 'BOLTON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(469, '01741', '+42.446396', '-071.459405', 'CARLISLE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(470, '01742', '+42.446396', '-071.459405', 'CONCORD', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(471, '01745', '+42.293442', '-071.502762', 'FAYVILLE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(472, '01746', '+42.446396', '-071.459405', 'HOLLISTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(473, '01747', '+42.127515', '-071.533138', 'HOPEDALE', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(474, '01748', '+42.446396', '-071.459405', 'HOPKINTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(475, '01749', '+42.446396', '-071.459405', 'HUDSON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(476, '01752', '+42.446396', '-071.459405', 'MARLBOROUGH', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(477, '01754', '+42.446396', '-071.459405', 'MAYNARD', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(478, '01756', '+42.100352', '-071.546961', 'MENDON', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(479, '01757', '+42.147087', '-071.528085', 'MILFORD', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(480, '01760', '+42.446396', '-071.459405', 'NATICK', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(481, '01770', '+42.446396', '-071.459405', 'SHERBORN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(482, '01772', '+42.296842', '-071.533229', 'SOUTHBOROUGH', 'MA', 'MASSACHUSETTS', 'WORCESTER', 'STANDARD'),
(483, '01773', '+42.446396', '-071.459405', 'LINCOLN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(484, '01775', '+42.446396', '-071.459405', 'STOW', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(485, '01776', '+42.446396', '-071.459405', 'SUDBURY', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(486, '01778', '+42.446396', '-071.459405', 'WAYLAND', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(487, '01784', '+42.446396', '-071.459405', 'WOODVILLE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'PO BOX ONLY');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(488, '01801', '+42.488595', '-071.157271', 'WOBURN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(489, '01803', '+42.504844', '-071.201539', 'BURLINGTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(490, '01805', '+42.446396', '-071.459405', 'BURLINGTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(491, '01806', '+42.446396', '-071.459405', 'WOBURN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(492, '01807', '+42.446396', '-071.459405', 'WOBURN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(493, '01808', '+42.446396', '-071.459405', 'WOBURN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(494, '01810', '+42.647991', '-071.165685', 'ANDOVER', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(495, '01812', '+42.647191', '-071.184202', 'ANDOVER', 'MA', 'MASSACHUSETTS', 'ESSEX', 'UNIQUE'),
(496, '01813', '+42.446396', '-071.459405', 'WOBURN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(497, '01815', '+42.446396', '-071.459405', 'WOBURN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(498, '01821', '+42.446396', '-071.459405', 'BILLERICA', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(499, '01822', '+42.446396', '-071.459405', 'BILLERICA', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(500, '01824', '+42.446396', '-071.459405', 'CHELMSFORD', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(501, '01826', '+42.446396', '-071.459405', 'DRACUT', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(502, '01827', '+42.446396', '-071.459405', 'DUNSTABLE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(503, '01830', '+42.792639', '-071.072501', 'HAVERHILL', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(504, '01831', '+42.771095', '-071.122054', 'HAVERHILL', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(505, '01832', '+42.789627', '-071.126562', 'HAVERHILL', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(506, '01833', '+42.723770', '-070.981298', 'GEORGETOWN', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(507, '01834', '+42.751074', '-071.021437', 'GROVELAND', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(508, '01835', '+42.752844', '-071.084301', 'HAVERHILL', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(509, '01840', '+42.707340', '-071.161052', 'LAWRENCE', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(510, '01841', '+42.709790', '-071.164402', 'LAWRENCE', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(511, '01842', '+42.635443', '-070.879123', 'LAWRENCE', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(512, '01843', '+42.710370', '-071.088303', 'LAWRENCE', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(513, '01844', '+42.731840', '-071.186915', 'METHUEN', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(514, '01845', '+42.672835', '-071.087689', 'NORTH ANDOVER', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(515, '01850', '+42.446396', '-071.459405', 'LOWELL', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(516, '01851', '+42.446396', '-071.459405', 'LOWELL', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(517, '01852', '+42.446396', '-071.459405', 'LOWELL', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(518, '01853', '+42.446396', '-071.459405', 'LOWELL', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(519, '01854', '+42.446396', '-071.459405', 'LOWELL', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(520, '01860', '+42.802441', '-071.089600', 'MERRIMAC', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(521, '01862', '+42.446396', '-071.459405', 'NORTH BILLERICA', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(522, '01863', '+42.446396', '-071.459405', 'NORTH CHELMSFORD', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(523, '01864', '+42.581332', '-071.083725', 'NORTH READING', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(524, '01865', '+42.446396', '-071.459405', 'NUTTING LAKE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'PO BOX ONLY'),
(525, '01866', '+42.446396', '-071.459405', 'PINEHURST', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'PO BOX ONLY'),
(526, '01867', '+42.537065', '-071.107172', 'READING', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(527, '01876', '+42.446396', '-071.459405', 'TEWKSBURY', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(528, '01879', '+42.446396', '-071.459405', 'TYNGSBORO', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(529, '01880', '+42.499891', '-071.068829', 'WAKEFIELD', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(530, '01885', '+42.635443', '-070.879123', 'WEST BOXFORD', 'MA', 'MASSACHUSETTS', 'ESSEX', 'PO BOX ONLY'),
(531, '01886', '+42.446396', '-071.459405', 'WESTFORD', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(532, '01887', '+42.561782', '-071.173888', 'WILMINGTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(533, '01888', '+42.446396', '-071.459405', 'WOBURN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(534, '01889', '+42.571633', '-071.109646', 'NORTH READING', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(535, '01890', '+42.454545', '-071.148779', 'WINCHESTER', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(536, '01899', '+42.635443', '-070.879123', 'ANDOVER', 'MA', 'MASSACHUSETTS', 'ESSEX', 'UNIQUE'),
(537, '01901', '+42.461246', '-070.946743', 'LYNN', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(538, '01902', '+42.473195', '-070.928593', 'LYNN', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(539, '01903', '+42.635443', '-070.879123', 'LYNN', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(540, '01904', '+42.488896', '-070.964694', 'LYNN', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(541, '01905', '+42.469395', '-070.972844', 'LYNN', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(542, '01906', '+42.472112', '-070.997794', 'SAUGUS', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(543, '01907', '+42.513295', '-070.905893', 'SWAMPSCOTT', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(544, '01908', '+42.427296', '-070.922442', 'NAHANT', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(545, '01910', '+42.454796', '-070.974694', 'LYNN', 'MA', 'MASSACHUSETTS', 'ESSEX', 'UNIQUE'),
(546, '01913', '+42.853539', '-070.948211', 'AMESBURY', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(547, '01915', '+42.565145', '-070.853843', 'BEVERLY', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(548, '01921', '+42.683256', '-071.017403', 'BOXFORD', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(549, '01922', '+42.763216', '-070.928120', 'BYFIELD', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(550, '01923', '+42.577188', '-070.949245', 'DANVERS', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(551, '01929', '+42.627810', '-070.780576', 'ESSEX', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(552, '01930', '+42.630011', '-070.694179', 'GLOUCESTER', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(553, '01931', '+42.635443', '-070.879123', 'GLOUCESTER', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(554, '01936', '+42.635443', '-070.879123', 'HAMILTON', 'MA', 'MASSACHUSETTS', 'ESSEX', 'PO BOX ONLY'),
(555, '01937', '+42.635443', '-070.879123', 'HATHORNE', 'MA', 'MASSACHUSETTS', 'ESSEX', 'PO BOX ONLY'),
(556, '01938', '+42.685710', '-070.864132', 'IPSWICH', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(557, '01940', '+42.533732', '-071.028775', 'LYNNFIELD', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(558, '01944', '+42.579503', '-070.755062', 'MANCHESTER', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(559, '01945', '+42.561420', '-070.770768', 'MARBLEHEAD', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(560, '01949', '+42.644942', '-071.087905', 'MIDDLETON', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(561, '01950', '+42.809650', '-070.873196', 'NEWBURYPORT', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(562, '01951', '+42.777524', '-070.867246', 'NEWBURY', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(563, '01952', '+42.851234', '-070.865667', 'SALISBURY', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(564, '01960', '+42.536996', '-070.973646', 'PEABODY', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(565, '01961', '+42.635443', '-070.879123', 'PEABODY', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(566, '01965', '+42.558113', '-070.825743', 'PRIDES CROSSING', 'MA', 'MASSACHUSETTS', 'ESSEX', 'PO BOX ONLY'),
(567, '01966', '+42.657866', '-070.618057', 'ROCKPORT', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(568, '01969', '+42.716155', '-070.892754', 'ROWLEY', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(569, '01970', '+42.512946', '-070.904237', 'SALEM', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(570, '01971', '+42.635443', '-070.879123', 'SALEM', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(571, '01982', '+42.626664', '-070.851125', 'SOUTH HAMILTON', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(572, '01983', '+42.661793', '-070.954487', 'TOPSFIELD', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(573, '01984', '+42.597691', '-070.873200', 'WENHAM', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(574, '01985', '+42.794140', '-070.971068', 'WEST NEWBURY', 'MA', 'MASSACHUSETTS', 'ESSEX', 'STANDARD'),
(575, '02018', '+41.970474', '-070.701357', 'ACCORD', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(576, '02019', '+42.076501', '-071.470464', 'BELLINGHAM', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(577, '02020', '+42.081825', '-070.643868', 'BRANT ROCK', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(578, '02021', '+42.179146', '-071.121185', 'CANTON', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(579, '02025', '+42.233938', '-070.815826', 'COHASSET', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(580, '02026', '+42.244733', '-071.181141', 'DEDHAM', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(581, '02027', '+42.180048', '-071.089230', 'DEDHAM', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(582, '02030', '+42.236114', '-071.283072', 'DOVER', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(583, '02031', '+41.998799', '-071.200894', 'EAST MANSFIELD', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(584, '02032', '+42.153786', '-071.214550', 'EAST WALPOLE', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(585, '02035', '+42.062204', '-071.235774', 'FOXBORO', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(586, '02038', '+42.088680', '-071.404814', 'FRANKLIN', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(587, '02040', '+41.970474', '-070.701357', 'GREENBUSH', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(588, '02041', '+42.069642', '-070.649075', 'GREEN HARBOR', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(589, '02043', '+42.212105', '-070.884989', 'HINGHAM', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(590, '02044', '+41.970474', '-070.701357', 'HINGHAM', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'UNIQUE'),
(591, '02045', '+42.284413', '-070.873659', 'HULL', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(592, '02047', '+42.142836', '-070.693530', 'HUMAROCK', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(593, '02048', '+42.013182', '-071.218373', 'MANSFIELD', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(594, '02050', '+42.111805', '-070.710744', 'MARSHFIELD', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(595, '02051', '+42.151202', '-070.734146', 'MARSHFIELD HILLS', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(596, '02052', '+42.181265', '-071.309934', 'MEDFIELD', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(597, '02053', '+42.156282', '-071.427663', 'MEDWAY', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(598, '02054', '+42.165249', '-071.361260', 'MILLIS', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(599, '02055', '+41.970474', '-070.701357', 'MINOT', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(600, '02056', '+42.117511', '-071.331793', 'NORFOLK', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(601, '02059', '+41.970474', '-070.701357', 'NORTH MARSHFIELD', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(602, '02060', '+41.970474', '-070.701357', 'NORTH SCITUATE', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(603, '02061', '+42.154145', '-070.823035', 'NORWELL', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(604, '02062', '+42.182798', '-071.196277', 'NORWOOD', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(605, '02065', '+42.097219', '-070.651567', 'OCEAN BLUFF', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(606, '02066', '+42.207254', '-070.770188', 'SCITUATE', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(607, '02067', '+42.105288', '-071.184785', 'SHARON', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(608, '02070', '+42.180048', '-071.089230', 'SHELDONVILLE', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'PO BOX ONLY'),
(609, '02071', '+42.100399', '-071.270933', 'SOUTH WALPOLE', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(610, '02072', '+42.118416', '-071.105733', 'STOUGHTON', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(611, '02081', '+42.148624', '-071.255533', 'WALPOLE', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(612, '02090', '+42.220548', '-071.199238', 'WESTWOOD', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(613, '02093', '+42.054311', '-071.371169', 'WRENTHAM', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(614, '02101', '+42.370567', '-071.026964', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(615, '02102', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(616, '02103', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(617, '02104', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(618, '02105', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(619, '02106', '+42.354318', '-071.073449', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(620, '02107', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(621, '02108', '+42.353806', '-071.102446', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(622, '02109', '+42.360027', '-071.054495', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(623, '02110', '+42.352847', '-071.051466', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(624, '02111', '+42.351047', '-071.059365', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(625, '02112', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(626, '02113', '+42.365398', '-071.055001', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(627, '02114', '+42.362097', '-071.023661', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(628, '02115', '+42.342043', '-071.096848', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(629, '02116', '+42.347207', '-071.086095', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(630, '02117', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(631, '02118', '+42.336162', '-071.072854', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(632, '02119', '+42.323077', '-071.084608', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(633, '02120', '+42.332484', '-071.096416', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(634, '02121', '+42.307098', '-071.081645', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(635, '02122', '+42.296580', '-071.055215', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(636, '02123', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(637, '02124', '+42.286784', '-071.071045', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(638, '02125', '+42.314760', '-071.067244', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(639, '02126', '+42.301247', '-071.105195', 'MATTAPAN', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(640, '02127', '+42.329023', '-071.020343', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(641, '02128', '+42.364197', '-071.025694', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(642, '02129', '+42.382588', '-071.065287', 'CHARLESTOWN', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(643, '02130', '+42.309661', '-071.121097', 'JAMAICA PLAIN', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(644, '02131', '+42.284197', '-071.120896', 'ROSLINDALE', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(645, '02132', '+42.277897', '-071.155833', 'WEST ROXBURY', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(646, '02133', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(647, '02134', '+42.357169', '-071.112646', 'ALLSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(648, '02135', '+42.349768', '-071.104888', 'BRIGHTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(649, '02136', '+42.254248', '-071.129321', 'HYDE PARK', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(650, '02137', '+42.338947', '-070.919635', 'READVILLE', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(651, '02138', '+42.380442', '-071.132947', 'CAMBRIDGE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(652, '02139', '+42.365146', '-071.101842', 'CAMBRIDGE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(653, '02140', '+42.393246', '-071.133833', 'CAMBRIDGE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(654, '02141', '+42.368673', '-071.083596', 'CAMBRIDGE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(655, '02142', '+42.362840', '-071.084814', 'CAMBRIDGE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(656, '02143', '+42.380920', '-071.098896', 'SOMERVILLE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(657, '02144', '+42.402696', '-071.120220', 'SOMERVILLE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(658, '02145', '+42.391046', '-071.095146', 'SOMERVILLE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(659, '02148', '+42.436545', '-071.085396', 'MALDEN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(660, '02149', '+42.407396', '-071.051183', 'EVERETT', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(661, '02150', '+42.378197', '-071.038894', 'CHELSEA', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(662, '02151', '+42.366303', '-071.020494', 'REVERE', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(663, '02152', '+42.378447', '-070.981679', 'WINTHROP', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(664, '02153', '+42.446396', '-071.459405', 'MEDFORD', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(665, '02155', '+42.422095', '-071.109297', 'MEDFORD', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(666, '02156', '+42.446396', '-071.459405', 'WEST MEDFORD', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(667, '02163', '+42.325320', '-071.112159', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(668, '02169', '+42.241799', '-071.006042', 'QUINCY', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(669, '02170', '+42.267248', '-071.016742', 'QUINCY', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(670, '02171', '+42.284898', '-071.014243', 'QUINCY', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(671, '02176', '+42.458995', '-071.053095', 'MELROSE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(672, '02177', '+42.446396', '-071.459405', 'MELROSE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(673, '02180', '+42.474595', '-071.098146', 'STONEHAM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(674, '02184', '+42.202216', '-071.005192', 'BRAINTREE', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(675, '02185', '+42.180048', '-071.089230', 'BRAINTREE', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(676, '02186', '+42.240598', '-071.078494', 'MILTON', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(677, '02187', '+42.180048', '-071.089230', 'MILTON VILLAGE', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(678, '02188', '+42.207940', '-070.955140', 'WEYMOUTH', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(679, '02189', '+42.210649', '-070.932318', 'WEYMOUTH', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(680, '02190', '+42.167841', '-070.950740', 'WEYMOUTH', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(681, '02191', '+42.251499', '-070.944840', 'WEYMOUTH', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(682, '02196', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(683, '02199', '+42.347247', '-071.082395', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(684, '02201', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(685, '02202', '+42.361094', '-071.061814', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(686, '02203', '+42.361485', '-071.060364', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(687, '02204', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(688, '02205', '+42.350334', '-071.053877', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(689, '02206', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(690, '02207', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(691, '02208', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(692, '02209', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(693, '02210', '+42.347547', '-071.040645', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(694, '02211', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(695, '02212', '+42.446396', '-071.459405', 'BOSTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(696, '02215', '+42.345079', '-071.107653', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(697, '02216', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(698, '02217', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(699, '02222', '+42.364381', '-071.063314', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(700, '02228', '', '', 'EAST BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(701, '02238', '+42.446396', '-071.459405', 'CAMBRIDGE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(702, '02239', '+42.446396', '-071.459405', 'CAMBRIDGE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(703, '02241', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(704, '02266', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(705, '02269', '+42.180048', '-071.089230', 'QUINCY', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(706, '02283', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(707, '02284', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'STANDARD'),
(708, '02293', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(709, '02295', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(710, '02297', '+42.338947', '-070.919635', 'BOSTON', 'MA', 'MASSACHUSETTS', 'SUFFOLK', 'UNIQUE'),
(711, '02301', '+42.079399', '-071.039990', 'BROCKTON', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(712, '02302', '+42.084750', '-071.000189', 'BROCKTON', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(713, '02303', '+41.970474', '-070.701357', 'BROCKTON', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(714, '02304', '+41.970474', '-070.701357', 'BROCKTON', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(715, '02305', '+41.970474', '-070.701357', 'BROCKTON', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(716, '02322', '+42.126049', '-071.048216', 'AVON', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(717, '02324', '+41.973741', '-070.976558', 'BRIDGEWATER', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(718, '02325', '+41.987250', '-070.972786', 'BRIDGEWATER', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'UNIQUE'),
(719, '02327', '+42.040708', '-070.827245', 'BRYANTVILLE', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(720, '02330', '+41.896238', '-070.759689', 'CARVER', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(721, '02331', '+41.970474', '-070.701357', 'DUXBURY', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(722, '02332', '+42.052985', '-070.710808', 'DUXBURY', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(723, '02333', '+42.022850', '-070.931056', 'EAST BRIDGEWATER', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(724, '02334', '+42.023528', '-071.132397', 'EASTON', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'PO BOX ONLY'),
(725, '02337', '+42.022225', '-070.931588', 'ELMWOOD', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(726, '02338', '+41.988351', '-070.860578', 'HALIFAX', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(727, '02339', '+42.123534', '-070.851048', 'HANOVER', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(728, '02340', '+42.123534', '-070.851048', 'HANOVER', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'UNIQUE'),
(729, '02341', '+42.055701', '-070.875936', 'HANSON', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(730, '02343', '+42.144424', '-071.002890', 'HOLBROOK', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(731, '02344', '+41.970474', '-070.701357', 'MIDDLEBORO', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'UNIQUE'),
(732, '02345', '+41.888198', '-070.581029', 'MANOMET', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(733, '02346', '+41.915054', '-070.882035', 'MIDDLEBORO', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(734, '02347', '+41.843757', '-070.959981', 'LAKEVILLE', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(735, '02348', '+41.970474', '-070.701357', 'MIDDLEBORO', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'UNIQUE'),
(736, '02349', '+41.970474', '-070.701357', 'MIDDLEBORO', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'UNIQUE'),
(737, '02350', '+42.018525', '-070.847486', 'MONPONSETT', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(738, '02351', '+42.117490', '-070.959888', 'ABINGTON', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(739, '02355', '+41.916918', '-070.801331', 'NORTH CARVER', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(740, '02356', '+42.053408', '-071.120330', 'NORTH EASTON', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(741, '02357', '+42.064499', '-071.087091', 'NORTH EASTON', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'UNIQUE'),
(742, '02358', '+41.953510', '-070.713109', 'NORTH PEMBROKE', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(743, '02359', '+42.065702', '-070.800778', 'PEMBROKE', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(744, '02360', '+41.886207', '-070.638717', 'PLYMOUTH', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(745, '02361', '+41.970474', '-070.701357', 'PLYMOUTH', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(746, '02362', '+41.970474', '-070.701357', 'PLYMOUTH', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(747, '02364', '+41.979405', '-070.744813', 'KINGSTON', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(748, '02366', '+41.850087', '-070.704431', 'SOUTH CARVER', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(749, '02367', '+41.969140', '-070.812299', 'PLYMPTON', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(750, '02368', '+42.171467', '-071.055602', 'RANDOLPH', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(751, '02370', '+41.954199', '-070.885095', 'ROCKLAND', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(752, '02375', '+42.023199', '-071.111091', 'SOUTH EASTON', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(753, '02379', '+42.021650', '-071.023588', 'WEST BRIDGEWATER', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(754, '02381', '+41.931602', '-070.561051', 'WHITE HORSE BEACH', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(755, '02382', '+42.078500', '-070.940837', 'WHITMAN', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(756, '02420', '+42.456310', '-071.216650', 'LEXINGTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(757, '02421', '+42.442567', '-071.226453', 'LEXINGTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(758, '02445', '+42.318097', '-071.143697', 'BROOKLINE', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(759, '02446', '+42.343097', '-071.123046', 'BROOKLINE', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(760, '02447', '+42.180048', '-071.089230', 'BROOKLINE VILLAGE', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(761, '02451', '+42.398588', '-071.245050', 'WALTHAM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(762, '02452', '+42.394319', '-071.218049', 'WALTHAM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(763, '02453', '+42.365396', '-071.231650', 'WALTHAM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(764, '02454', '+42.356719', '-071.250479', 'WALTHAM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(765, '02455', '', '', 'NORTH WALTHAM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(766, '02456', '+42.446396', '-071.459405', 'NEW TOWN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(767, '02457', '+42.180048', '-071.089230', 'BABSON PARK', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(768, '02458', '+42.385096', '-071.208399', 'NEWTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(769, '02459', '+42.334146', '-071.183298', 'NEWTON CENTER', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(770, '02460', '+42.374296', '-071.182371', 'NEWTONVILLE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(771, '02461', '+42.361196', '-071.205349', 'NEWTON HIGHLANDS', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(772, '02462', '+42.349496', '-071.209699', 'NEWTON LOWER FALLS', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(773, '02464', '+42.365990', '-071.221849', 'NEWTON UPPER FALLS', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(774, '02465', '+42.378145', '-071.213199', 'WEST NEWTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(775, '02466', '+42.346696', '-071.224957', 'AUBURNDALE', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(776, '02467', '+42.357564', '-071.211649', 'CHESTNUT HILL', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(777, '02468', '+42.327146', '-071.231534', 'WABAN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(778, '02471', '+42.446396', '-071.459405', 'WATERTOWN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(779, '02472', '+42.363096', '-071.201398', 'WATERTOWN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(780, '02474', '+42.417595', '-071.159696', 'ARLINGTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(781, '02475', '+42.446396', '-071.459405', 'ARLINGTON HEIGHTS', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(782, '02476', '+42.379146', '-071.184299', 'ARLINGTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(783, '02477', '+42.446396', '-071.459405', 'WATERTOWN', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'UNIQUE'),
(784, '02478', '+42.412795', '-071.204399', 'BELMONT', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(785, '02479', '+42.446396', '-071.459405', 'WAVERLEY', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(786, '02481', '+42.310597', '-071.274652', 'WELLESLEY HILLS', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(787, '02482', '+42.294546', '-071.299201', 'WELLESLEY', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(788, '02492', '+42.279797', '-071.250060', 'NEEDHAM', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(789, '02493', '+42.375925', '-071.227208', 'WESTON', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(790, '02494', '+42.300147', '-071.263150', 'NEEDHAM HEIGHTS', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(791, '02495', '+42.446396', '-071.459405', 'NONANTUM', 'MA', 'MASSACHUSETTS', 'MIDDLESEX', 'STANDARD'),
(792, '02532', '+41.745505', '-070.590471', 'BUZZARDS BAY', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(793, '02534', '+41.669373', '-070.623370', 'CATAUMET', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(794, '02535', '+41.379034', '-070.673082', 'CHILMARK', 'MA', 'MASSACHUSETTS', 'DUKES', 'STANDARD'),
(795, '02536', '+41.662506', '-070.562843', 'EAST FALMOUTH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(796, '02537', '+41.728320', '-070.439975', 'EAST SANDWICH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(797, '02538', '+41.775440', '-070.660562', 'EAST WAREHAM', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(798, '02539', '+41.401176', '-070.552054', 'EDGARTOWN', 'MA', 'MASSACHUSETTS', 'DUKES', 'STANDARD'),
(799, '02540', '+41.614199', '-070.493263', 'FALMOUTH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(800, '02541', '+41.799312', '-070.308662', 'FALMOUTH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(801, '02542', '+41.653080', '-070.553727', 'BUZZARDS BAY', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(802, '02543', '+41.593809', '-070.646442', 'WOODS HOLE', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(803, '02552', '+41.379836', '-070.643092', 'MENEMSHA', 'MA', 'MASSACHUSETTS', 'DUKES', 'PO BOX ONLY'),
(804, '02553', '+41.673360', '-070.608047', 'MONUMENT BEACH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(805, '02554', '+41.287647', '-070.086650', 'NANTUCKET', 'MA', 'MASSACHUSETTS', 'NANTUCKET', 'STANDARD'),
(806, '02556', '+41.652967', '-070.375475', 'NORTH FALMOUTH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(807, '02557', '+41.417376', '-070.560032', 'OAK BLUFFS', 'MA', 'MASSACHUSETTS', 'DUKES', 'PO BOX ONLY'),
(808, '02558', '+41.747560', '-070.658164', 'ONSET', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'PO BOX ONLY'),
(809, '02559', '+41.694771', '-070.622769', 'POCASSET', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(810, '02561', '+41.770254', '-070.533664', 'SAGAMORE', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(811, '02562', '+41.793263', '-070.519584', 'SAGAMORE BEACH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(812, '02563', '+41.711291', '-070.477482', 'SANDWICH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(813, '02564', '+41.273949', '-070.015545', 'SIASCONSET', 'MA', 'MASSACHUSETTS', 'NANTUCKET', 'STANDARD'),
(814, '02565', '+41.799312', '-070.308662', 'SILVER BEACH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(815, '02568', '+41.415950', '-070.595235', 'VINEYARD HAVEN', 'MA', 'MASSACHUSETTS', 'DUKES', 'STANDARD'),
(816, '02571', '+41.760216', '-070.694662', 'WAREHAM', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(817, '02573', '+41.379836', '-070.643092', 'WEST CHOP', 'MA', 'MASSACHUSETTS', 'DUKES', 'STANDARD'),
(818, '02574', '+41.603946', '-070.638189', 'WEST FALMOUTH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(819, '02575', '+41.421250', '-070.642806', 'WEST TISBURY', 'MA', 'MASSACHUSETTS', 'DUKES', 'PO BOX ONLY'),
(820, '02576', '+41.769863', '-070.749688', 'WEST WAREHAM', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(821, '02584', '+41.277794', '-070.046019', 'NANTUCKET', 'MA', 'MASSACHUSETTS', 'NANTUCKET', 'STANDARD'),
(822, '02601', '+41.829813', '-070.138834', 'HYANNIS', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(823, '02630', '+41.697313', '-070.301394', 'BARNSTABLE', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(824, '02631', '+41.852997', '-070.044462', 'BREWSTER', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(825, '02632', '+41.796311', '-070.175129', 'CENTERVILLE', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(826, '02633', '+41.859559', '-070.046800', 'CHATHAM', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(827, '02634', '+41.799312', '-070.308662', 'CENTERVILLE', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(828, '02635', '+41.624341', '-070.436380', 'COTUIT', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(829, '02636', '+41.799312', '-070.308662', 'CENTERVILLE', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(830, '02637', '+41.701438', '-070.277212', 'CUMMAQUID', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(831, '02638', '+41.725716', '-070.089142', 'DENNIS', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(832, '02639', '+41.750745', '-070.071836', 'DENNIS PORT', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(833, '02641', '+41.734713', '-070.204670', 'EAST DENNIS', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(834, '02642', '+41.850612', '-070.020648', 'EASTHAM', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(835, '02643', '+41.784308', '-069.962034', 'EAST ORLEANS', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(836, '02644', '+41.790031', '-070.268632', 'FORESTDALE', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(837, '02645', '+41.835582', '-070.043359', 'HARWICH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(838, '02646', '+41.845717', '-070.053544', 'HARWICH PORT', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(839, '02647', '+41.635004', '-070.306336', 'HYANNIS PORT', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(840, '02648', '+41.813034', '-070.246666', 'MARSTONS MILLS', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(841, '02649', '+41.788337', '-070.253543', 'MASHPEE', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(842, '02650', '+41.734970', '-070.029065', 'NORTH CHATHAM', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(843, '02651', '+41.824264', '-069.981760', 'NORTH EASTHAM', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(844, '02652', '+41.931061', '-070.283584', 'NORTH TRURO', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(845, '02653', '+41.852933', '-070.015390', 'ORLEANS', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(846, '02655', '+41.810178', '-070.191269', 'OSTERVILLE', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(847, '02657', '+41.888775', '-070.091057', 'PROVINCETOWN', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(848, '02659', '+41.848932', '-070.030194', 'SOUTH CHATHAM', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(849, '02660', '+41.800380', '-070.089244', 'SOUTH DENNIS', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(850, '02661', '+41.686205', '-070.032858', 'SOUTH HARWICH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(851, '02662', '+41.756694', '-069.984123', 'SOUTH ORLEANS', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(852, '02663', '+41.800531', '-070.076776', 'SOUTH WELLFLEET', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(853, '02664', '+41.824120', '-070.084259', 'SOUTH YARMOUTH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(854, '02666', '+41.987377', '-070.047163', 'TRURO', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(855, '02667', '+41.821307', '-070.022806', 'WELLFLEET', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(856, '02668', '+41.790550', '-070.201719', 'WEST BARNSTABLE', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(857, '02669', '+41.698721', '-070.004937', 'WEST CHATHAM', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(858, '02670', '+41.710855', '-070.072195', 'WEST DENNIS', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(859, '02671', '+41.846719', '-070.038282', 'WEST HARWICH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(860, '02672', '+41.635635', '-070.323307', 'WEST HYANNISPORT', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'PO BOX ONLY'),
(861, '02673', '+41.776105', '-070.150512', 'WEST YARMOUTH', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(862, '02675', '+41.716271', '-070.135884', 'YARMOUTH PORT', 'MA', 'MASSACHUSETTS', 'BARNSTABLE', 'STANDARD'),
(863, '02702', '+41.782993', '-071.017328', 'ASSONET', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(864, '02703', '+41.938976', '-071.302297', 'ATTLEBORO', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(865, '02712', '+41.756214', '-071.067062', 'CHARTLEY', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'PO BOX ONLY'),
(866, '02713', '+41.421780', '-070.931309', 'CUTTYHUNK', 'MA', 'MASSACHUSETTS', 'DUKES', 'PO BOX ONLY'),
(867, '02714', '+41.756214', '-071.067062', 'DARTMOUTH', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(868, '02715', '+41.817659', '-071.151787', 'DIGHTON', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(869, '02717', '+41.747358', '-070.978947', 'EAST FREETOWN', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(870, '02718', '+41.871407', '-071.013148', 'EAST TAUNTON', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(871, '02719', '+41.631672', '-070.870045', 'FAIRHAVEN', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(872, '02720', '+41.819766', '-071.165971', 'FALL RIVER', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(873, '02721', '+41.678895', '-071.153648', 'FALL RIVER', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(874, '02722', '+41.756214', '-071.067062', 'FALL RIVER', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(875, '02723', '+41.693802', '-071.133088', 'FALL RIVER', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(876, '02724', '+41.684202', '-071.175139', 'FALL RIVER', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(877, '02725', '+41.723851', '-071.173989', 'SOMERSET', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(878, '02726', '+41.757951', '-071.153639', 'SOMERSET', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(879, '02738', '+41.736735', '-070.754015', 'MARION', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(880, '02739', '+41.664976', '-070.810856', 'MATTAPOISETT', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(881, '02740', '+41.633416', '-070.951045', 'NEW BEDFORD', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(882, '02741', '+41.756214', '-071.067062', 'NEW BEDFORD', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(883, '02742', '+41.619557', '-070.956346', 'NEW BEDFORD', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(884, '02743', '+41.711894', '-070.908286', 'ACUSHNET', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(885, '02744', '+41.609354', '-070.916181', 'NEW BEDFORD', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(886, '02745', '+41.708700', '-070.946883', 'NEW BEDFORD', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(887, '02746', '+41.665704', '-070.943021', 'NEW BEDFORD', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(888, '02747', '+41.639261', '-071.007578', 'NORTH DARTMOUTH', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(889, '02748', '+41.566464', '-070.984253', 'SOUTH DARTMOUTH', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(890, '02760', '+41.964376', '-071.326448', 'NORTH ATTLEBORO', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(891, '02761', '+41.756214', '-071.067062', 'NORTH ATTLEBORO', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(892, '02762', '+42.013553', '-071.334399', 'PLAINVILLE', 'MA', 'MASSACHUSETTS', 'NORFOLK', 'STANDARD'),
(893, '02763', '+41.972584', '-071.308229', 'ATTLEBORO FALLS', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(894, '02764', '+41.847791', '-071.155797', 'NORTH DIGHTON', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(895, '02766', '+41.959149', '-071.180393', 'NORTON', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(896, '02767', '+41.936700', '-071.048941', 'RAYNHAM', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(897, '02768', '+41.756214', '-071.067062', 'RAYNHAM CENTER', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'PO BOX ONLY'),
(898, '02769', '+41.852989', '-071.243061', 'REHOBOTH', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(899, '02770', '+41.751812', '-070.846041', 'ROCHESTER', 'MA', 'MASSACHUSETTS', 'PLYMOUTH', 'STANDARD'),
(900, '02771', '+41.840103', '-071.318995', 'SEEKONK', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(901, '02777', '+41.766629', '-071.234443', 'SWANSEA', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(902, '02779', '+41.828249', '-071.064135', 'BERKLEY', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(903, '02780', '+41.858851', '-071.092827', 'TAUNTON', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(904, '02783', '+41.756214', '-071.067062', 'TAUNTON', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'UNIQUE'),
(905, '02790', '+41.615470', '-071.079636', 'WESTPORT', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'STANDARD'),
(906, '02791', '+41.519104', '-071.085137', 'WESTPORT POINT', 'MA', 'MASSACHUSETTS', 'BRISTOL', 'PO BOX ONLY'),
(907, '02801', '+41.530131', '-071.284066', 'ADAMSVILLE', 'RI', 'RHODE ISLAND', 'NEWPORT', 'PO BOX ONLY'),
(908, '02802', '+41.954098', '-071.462053', 'ALBION', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'PO BOX ONLY'),
(909, '02804', '+41.322365', '-071.679251', 'ASHAWAY', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(910, '02806', '+41.742501', '-071.320395', 'BARRINGTON', 'RI', 'RHODE ISLAND', 'BRISTOL', 'STANDARD'),
(911, '02807', '+41.188888', '-071.577696', 'BLOCK ISLAND', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'PO BOX ONLY'),
(912, '02808', '+41.403784', '-071.761665', 'BRADFORD', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(913, '02809', '+41.678378', '-071.270400', 'BRISTOL', 'RI', 'RHODE ISLAND', 'BRISTOL', 'STANDARD'),
(914, '02812', '+41.469148', '-071.675092', 'CAROLINA', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(915, '02813', '+41.395079', '-071.665420', 'CHARLESTOWN', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(916, '02814', '+41.888971', '-071.688769', 'CHEPACHET', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(917, '02815', '+41.770525', '-071.655850', 'CLAYVILLE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(918, '02816', '+41.694251', '-071.636786', 'COVENTRY', 'RI', 'RHODE ISLAND', 'KENT', 'STANDARD'),
(919, '02817', '+41.631168', '-071.667165', 'WEST GREENWICH', 'RI', 'RHODE ISLAND', 'KENT', 'STANDARD'),
(920, '02818', '+41.643350', '-071.478002', 'EAST GREENWICH', 'RI', 'RHODE ISLAND', 'KENT', 'STANDARD'),
(921, '02822', '+41.546900', '-071.650262', 'EXETER', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(922, '02823', '+41.731200', '-071.546756', 'FISKEVILLE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'PO BOX ONLY'),
(923, '02824', '+42.000248', '-071.563057', 'FORESTDALE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'PO BOX ONLY'),
(924, '02825', '+41.790569', '-071.706440', 'FOSTER', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(925, '02826', '+41.982417', '-071.600848', 'GLENDALE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'PO BOX ONLY'),
(926, '02827', '+41.691676', '-071.727467', 'GREENE', 'RI', 'RHODE ISLAND', 'KENT', 'STANDARD'),
(927, '02828', '+41.879298', '-071.551682', 'GREENVILLE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(928, '02829', '+41.879298', '-071.589357', 'HARMONY', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'PO BOX ONLY'),
(929, '02830', '+41.972390', '-071.648502', 'HARRISVILLE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(930, '02831', '+41.753594', '-071.577746', 'HOPE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(931, '02832', '+41.509632', '-071.733875', 'HOPE VALLEY', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(932, '02833', '+41.475117', '-071.772617', 'HOPKINTON', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(933, '02835', '+41.514120', '-071.377247', 'JAMESTOWN', 'RI', 'RHODE ISLAND', 'NEWPORT', 'STANDARD'),
(934, '02836', '+41.447427', '-071.620432', 'KENYON', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(935, '02837', '+41.510257', '-071.166340', 'LITTLE COMPTON', 'RI', 'RHODE ISLAND', 'NEWPORT', 'STANDARD'),
(936, '02838', '+41.967848', '-071.475604', 'MANVILLE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(937, '02839', '+41.941715', '-071.637581', 'MAPLEVILLE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(938, '02840', '+41.487552', '-071.327084', 'NEWPORT', 'RI', 'RHODE ISLAND', 'NEWPORT', 'STANDARD'),
(939, '02841', '+41.498977', '-071.299004', 'NEWPORT', 'RI', 'RHODE ISLAND', 'NEWPORT', 'UNIQUE'),
(940, '02842', '+41.519757', '-071.273101', 'MIDDLETOWN', 'RI', 'RHODE ISLAND', 'NEWPORT', 'STANDARD'),
(941, '02852', '+41.586851', '-071.464801', 'NORTH KINGSTOWN', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(942, '02854', '+41.375317', '-071.643930', 'NORTH KINGSTOWN', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(943, '02857', '+41.838827', '-071.655006', 'NORTH SCITUATE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(944, '02858', '+41.962303', '-071.647542', 'OAKLAND', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(945, '02859', '+41.964150', '-071.723316', 'PASCOAG', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(946, '02860', '+41.875149', '-071.392732', 'PAWTUCKET', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(947, '02861', '+41.878249', '-071.369899', 'PAWTUCKET', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(948, '02862', '+41.861250', '-071.369099', 'PAWTUCKET', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(949, '02863', '+41.889849', '-071.394186', 'CENTRAL FALLS', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(950, '02864', '+41.949498', '-071.432690', 'CUMBERLAND', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(951, '02865', '+41.925298', '-071.493355', 'LINCOLN', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(952, '02871', '+41.585230', '-071.264197', 'PORTSMOUTH', 'RI', 'RHODE ISLAND', 'NEWPORT', 'STANDARD'),
(953, '02872', '+41.707119', '-071.286834', 'PRUDENCE ISLAND', 'RI', 'RHODE ISLAND', 'BRISTOL', 'STANDARD'),
(954, '02873', '+41.519922', '-071.774023', 'ROCKVILLE', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'PO BOX ONLY'),
(955, '02874', '+41.478466', '-071.471752', 'SAUNDERSTOWN', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(956, '02875', '+41.456039', '-071.635474', 'SHANNOCK', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(957, '02876', '+41.998398', '-071.576307', 'SLATERSVILLE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(958, '02877', '+41.528900', '-071.529854', 'SLOCUM', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(959, '02878', '+41.610180', '-071.175183', 'TIVERTON', 'RI', 'RHODE ISLAND', 'NEWPORT', 'STANDARD'),
(960, '02879', '+41.443653', '-071.534202', 'WAKEFIELD', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(961, '02880', '+41.375317', '-071.643930', 'WAKEFIELD', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(962, '02881', '+41.482901', '-071.524317', 'KINGSTON', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(963, '02882', '+41.377185', '-071.497793', 'NARRAGANSETT', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(964, '02883', '+41.375317', '-071.643930', 'PEACE DALE', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(965, '02885', '+41.727451', '-071.257492', 'WARREN', 'RI', 'RHODE ISLAND', 'BRISTOL', 'STANDARD'),
(966, '02886', '+41.702470', '-071.479020', 'WARWICK', 'RI', 'RHODE ISLAND', 'KENT', 'STANDARD'),
(967, '02887', '+41.682455', '-071.557732', 'WARWICK', 'RI', 'RHODE ISLAND', 'KENT', 'STANDARD'),
(968, '02888', '+41.747300', '-071.411088', 'WARWICK', 'RI', 'RHODE ISLAND', 'KENT', 'STANDARD'),
(969, '02889', '+41.689182', '-071.496048', 'WARWICK', 'RI', 'RHODE ISLAND', 'KENT', 'STANDARD'),
(970, '02891', '+41.284494', '-071.710708', 'WESTERLY', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(971, '02892', '+41.505764', '-071.621140', 'WEST KINGSTON', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(972, '02893', '+41.696822', '-071.507304', 'WEST WARWICK', 'RI', 'RHODE ISLAND', 'KENT', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(973, '02894', '+41.450050', '-071.707420', 'WOOD RIVER JUNCTION', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(974, '02895', '+41.984598', '-071.519390', 'WOONSOCKET', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(975, '02896', '+41.934348', '-071.540506', 'NORTH SMITHFIELD', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(976, '02898', '+41.504089', '-071.662954', 'WYOMING', 'RI', 'RHODE ISLAND', 'WASHINGTON', 'STANDARD'),
(977, '02901', '+41.822750', '-071.414451', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(978, '02902', '+41.818350', '-071.424851', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'UNIQUE'),
(979, '02903', '+41.819459', '-071.411500', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(980, '02904', '+41.854140', '-071.437752', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(981, '02905', '+41.803799', '-071.422547', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(982, '02906', '+41.837400', '-071.394717', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(983, '02907', '+41.797065', '-071.425501', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(984, '02908', '+41.837399', '-071.439900', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(985, '02909', '+41.820599', '-071.444302', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(986, '02910', '+41.791700', '-071.435251', 'CRANSTON', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(987, '02911', '+41.838749', '-071.449202', 'NORTH PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(988, '02912', '+41.826737', '-071.397699', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'UNIQUE'),
(989, '02914', '+41.813429', '-071.363348', 'EAST PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(990, '02915', '+41.774300', '-071.349697', 'RIVERSIDE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(991, '02916', '+41.842727', '-071.355798', 'RUMFORD', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(992, '02917', '+41.853899', '-071.497804', 'SMITHFIELD', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(993, '02918', '+41.841499', '-071.440352', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'UNIQUE'),
(994, '02919', '+41.870932', '-071.497604', 'JOHNSTON', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(995, '02920', '+41.769300', '-071.471353', 'CRANSTON', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(996, '02921', '+41.766750', '-071.476703', 'CRANSTON', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(997, '02940', '+41.871766', '-071.558518', 'PROVIDENCE', 'RI', 'RHODE ISLAND', 'PROVIDENCE', 'STANDARD'),
(998, '03031', '+42.874740', '-071.629365', 'AMHERST', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(999, '03032', '+42.989151', '-071.343576', 'AUBURN', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1000, '03033', '+42.847268', '-071.767437', 'BROOKLINE', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1001, '03034', '+43.059283', '-071.305437', 'CANDIA', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1002, '03036', '+42.961606', '-071.251021', 'CHESTER', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1003, '03037', '+42.987495', '-071.252719', 'DEERFIELD', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1004, '03038', '+42.950825', '-071.197169', 'DERRY', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1005, '03040', '+43.005895', '-071.013202', 'EAST CANDIA', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1006, '03041', '+43.005895', '-071.013202', 'EAST DERRY', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'PO BOX ONLY'),
(1007, '03042', '+43.047595', '-071.084411', 'EPPING', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1008, '03043', '+42.916233', '-071.816505', 'FRANCESTOWN', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1009, '03044', '+42.992203', '-071.127041', 'FREMONT', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1010, '03045', '+42.946710', '-071.687633', 'GOFFSTOWN', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1011, '03046', '', '', 'DUNBARTON', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1012, '03047', '+42.929346', '-071.859087', 'GREENFIELD', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1013, '03048', '+42.875116', '-071.717548', 'GREENVILLE', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1014, '03049', '+42.859545', '-071.581313', 'HOLLIS', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1015, '03051', '+42.766426', '-071.618870', 'HUDSON', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1016, '03052', '+42.886789', '-071.485331', 'LITCHFIELD', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1017, '03053', '+42.871200', '-071.387776', 'LONDONDERRY', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1018, '03054', '+42.924928', '-071.667508', 'MERRIMACK', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1019, '03055', '+42.848787', '-071.743882', 'MILFORD', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1020, '03057', '+42.850464', '-071.727044', 'MONT VERNON', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1021, '03060', '+42.771537', '-071.626336', 'NASHUA', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1022, '03061', '+42.952124', '-071.653939', 'NASHUA', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1023, '03062', '+42.860117', '-071.499760', 'NASHUA', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1024, '03063', '+42.774427', '-071.511111', 'NASHUA', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1025, '03064', '+42.774237', '-071.628611', 'NASHUA', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1026, '03070', '+42.903497', '-071.775889', 'NEW BOSTON', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1027, '03071', '+42.762946', '-071.845164', 'NEW IPSWICH', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1028, '03073', '+43.005895', '-071.013202', 'NORTH SALEM', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'PO BOX ONLY'),
(1029, '03076', '+42.740651', '-071.318715', 'PELHAM', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1030, '03077', '+43.059320', '-071.204521', 'RAYMOND', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1031, '03079', '+42.872045', '-071.196195', 'SALEM', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1032, '03082', '+42.902031', '-071.773947', 'LYNDEBOROUGH', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1033, '03084', '+42.822275', '-071.860983', 'TEMPLE', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1034, '03086', '+42.894022', '-071.730154', 'WILTON', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1035, '03087', '+42.892211', '-071.234009', 'WINDHAM', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1036, '03101', '+42.988483', '-071.462111', 'MANCHESTER', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1037, '03102', '+43.007883', '-071.494561', 'MANCHESTER', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1038, '03103', '+42.942463', '-071.463761', 'MANCHESTER', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1039, '03104', '+42.897524', '-071.372208', 'MANCHESTER', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1040, '03105', '+42.952124', '-071.653939', 'MANCHESTER', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1041, '03106', '+43.065097', '-071.443616', 'HOOKSETT', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1042, '03107', '+42.952124', '-071.653939', 'MANCHESTER', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'UNIQUE'),
(1043, '03108', '+42.952124', '-071.653939', 'MANCHESTER', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1044, '03109', '+42.970084', '-071.405283', 'MANCHESTER', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1045, '03110', '+42.937430', '-071.535515', 'BEDFORD', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1046, '03111', '+42.952124', '-071.653939', 'MANCHESTER', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'UNIQUE'),
(1047, '03215', '+43.930221', '-071.534068', 'WATERVILLE VALLEY', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1048, '03216', '+43.447006', '-071.684093', 'ANDOVER', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1049, '03217', '+43.715626', '-071.639896', 'ASHLAND', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1050, '03218', '+43.417369', '-071.373189', 'BARNSTEAD', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1051, '03220', '+43.455551', '-071.407090', 'BELMONT', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1052, '03221', '+43.280961', '-071.792489', 'BRADFORD', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1053, '03222', '+43.707810', '-071.721580', 'BRISTOL', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1054, '03223', '+43.841799', '-071.665223', 'CAMPTON', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1055, '03224', '+43.378281', '-071.604226', 'CANTERBURY', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1056, '03225', '+43.386652', '-071.292981', 'CENTER BARNSTEAD', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1057, '03226', '+43.693870', '-071.466212', 'CENTER HARBOR', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1058, '03227', '+43.694809', '-071.323953', 'CENTER SANDWICH', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1059, '03229', '+43.301308', '-071.812943', 'CONTOOCOOK', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1060, '03230', '+43.514791', '-071.882094', 'DANBURY', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1061, '03231', '+43.466172', '-071.736518', 'EAST ANDOVER', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'PO BOX ONLY'),
(1062, '03232', '+43.967542', '-071.840883', 'EAST HEBRON', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1063, '03233', '+43.422706', '-071.944794', 'ELKINS', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1064, '03234', '+43.340736', '-071.669712', 'EPSOM', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1065, '03235', '+43.374297', '-071.680021', 'FRANKLIN', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1066, '03237', '+43.414064', '-071.384213', 'GILMANTON', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1067, '03238', '+43.967542', '-071.840883', 'GLENCLIFF', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'PO BOX ONLY'),
(1068, '03240', '+43.967542', '-071.840883', 'GRAFTON', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1069, '03241', '+43.718268', '-071.889483', 'HEBRON', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1070, '03242', '+43.180148', '-071.819590', 'HENNIKER', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1071, '03243', '+43.443473', '-071.762631', 'HILL', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1072, '03244', '+43.122950', '-071.914287', 'HILLSBORO', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1073, '03245', '+43.737831', '-071.604406', 'HOLDERNESS', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'PO BOX ONLY'),
(1074, '03246', '+43.535461', '-071.426997', 'LACONIA', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1075, '03247', '+43.588972', '-071.445452', 'LACONIA', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1076, '03249', '', '', 'GILFORD', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1077, '03251', '+44.049183', '-071.653505', 'LINCOLN', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1078, '03252', '+43.468562', '-071.537145', 'LOCHMERE', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'PO BOX ONLY'),
(1079, '03253', '+43.592239', '-071.517479', 'MEREDITH', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1080, '03254', '+43.728235', '-071.335248', 'MOULTONBOROUGH', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1081, '03255', '+43.321723', '-072.011840', 'NEWBURY', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1082, '03256', '+43.603288', '-071.634674', 'NEW HAMPTON', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1083, '03257', '+43.301663', '-071.733643', 'NEW LONDON', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1084, '03258', '', '', 'CHICHESTER', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1085, '03259', '+43.859710', '-071.377190', 'NORTH SANDWICH', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1086, '03260', '+43.365345', '-071.934059', 'NORTH SUTTON', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'PO BOX ONLY'),
(1087, '03261', '+43.208676', '-071.202568', 'NORTHWOOD', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1088, '03262', '+44.035391', '-071.686326', 'NORTH WOODSTOCK', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1089, '03263', '+43.297834', '-071.343707', 'PITTSFIELD', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1090, '03264', '+43.710919', '-071.694017', 'PLYMOUTH', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1091, '03266', '+43.752475', '-071.788434', 'RUMNEY', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1092, '03268', '+43.361756', '-071.558817', 'SALISBURY', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1093, '03269', '+43.501780', '-071.514248', 'SANBORNTON', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1094, '03272', '+43.310279', '-071.662928', 'SOUTH NEWBURY', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1095, '03273', '+43.304205', '-071.928867', 'SOUTH SUTTON', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'PO BOX ONLY'),
(1096, '03274', '+43.967542', '-071.840883', 'STINSON LAKE', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1097, '03275', '+43.286382', '-071.599047', 'SUNCOOK', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1098, '03276', '+43.536056', '-071.491660', 'TILTON', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1099, '03278', '+43.310858', '-071.842299', 'WARNER', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1100, '03279', '+43.967542', '-071.840883', 'WARREN', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1101, '03280', '+43.172290', '-072.100689', 'WASHINGTON', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1102, '03281', '+43.084176', '-071.762578', 'WEARE', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1103, '03282', '+43.967542', '-071.840883', 'WENTWORTH', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1104, '03284', '+43.493812', '-072.047018', 'SPRINGFIELD', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1105, '03287', '+43.448530', '-071.915826', 'WILMOT', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1106, '03289', '+43.496372', '-071.519728', 'WINNISQUAM', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'PO BOX ONLY'),
(1107, '03290', '+43.124825', '-071.125879', 'NOTTINGHAM', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1108, '03291', '+43.182251', '-071.139551', 'WEST NOTTINGHAM', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1109, '03293', '+43.967542', '-071.840883', 'WOODSTOCK', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1110, '03298', '+43.524872', '-071.445841', 'TILTON', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'UNIQUE'),
(1111, '03299', '+43.524872', '-071.445841', 'TILTON', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'UNIQUE'),
(1112, '03301', '+43.230314', '-071.536101', 'CONCORD', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1113, '03302', '+43.310279', '-071.662928', 'CONCORD', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1114, '03303', '+43.281654', '-071.659523', 'CONCORD', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1115, '03304', '+43.128256', '-071.544599', 'BOW', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1116, '03305', '+43.213400', '-071.517151', 'CONCORD', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'UNIQUE'),
(1117, '03307', '+43.319339', '-071.467006', 'LOUDON', 'NH', 'NEW HAMPSHIRE', 'MERRIMACK', 'STANDARD'),
(1118, '03431', '+42.903656', '-072.248052', 'KEENE', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1119, '03435', '+42.947098', '-072.243029', 'KEENE', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'UNIQUE'),
(1120, '03440', '+43.044535', '-071.971353', 'ANTRIM', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1121, '03441', '+42.777271', '-072.444106', 'ASHUELOT', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1122, '03442', '+43.002936', '-071.908029', 'BENNINGTON', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1123, '03443', '+42.883948', '-072.454813', 'CHESTERFIELD', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1124, '03444', '+42.889124', '-072.018993', 'DUBLIN', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'PO BOX ONLY'),
(1125, '03445', '+42.998225', '-072.201903', 'SULLIVAN', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1126, '03446', '+42.841079', '-072.330145', 'SWANZEY', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1127, '03447', '+42.881769', '-072.248026', 'FITZWILLIAM', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1128, '03448', '+42.936786', '-072.210953', 'GILSUM', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1129, '03449', '+42.939240', '-071.983797', 'HANCOCK', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1130, '03450', '+42.884548', '-072.102634', 'HARRISVILLE', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1131, '03451', '+42.894151', '-072.280099', 'HINSDALE', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1132, '03452', '+42.821969', '-072.082559', 'JAFFREY', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1133, '03455', '+42.888250', '-072.279638', 'MARLBOROUGH', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1134, '03456', '+43.119294', '-072.202564', 'MARLOW', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1135, '03457', '+42.896623', '-072.091677', 'NELSON', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1136, '03458', '+42.956433', '-071.937200', 'PETERBOROUGH', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'STANDARD'),
(1137, '03461', '+42.765090', '-072.009120', 'RINDGE', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1138, '03462', '+42.870716', '-072.239432', 'SPOFFORD', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1139, '03464', '+42.954780', '-072.102454', 'STODDARD', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1140, '03465', '+42.843617', '-072.279814', 'TROY', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1141, '03466', '+42.858419', '-072.432202', 'WEST CHESTERFIELD', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1142, '03467', '+42.973867', '-072.442560', 'WESTMORELAND', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1143, '03468', '+42.890804', '-071.933396', 'WEST PETERBOROUGH', 'NH', 'NEW HAMPSHIRE', 'HILLSBOROUGH', 'PO BOX ONLY'),
(1144, '03469', '+42.873410', '-072.315090', 'WEST SWANZEY', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'PO BOX ONLY'),
(1145, '03470', '+42.895797', '-072.274928', 'WINCHESTER', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1146, '03561', '+44.335289', '-071.877638', 'LITTLETON', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1147, '03570', '+44.512344', '-071.194226', 'BERLIN', 'NH', 'NEW HAMPSHIRE', 'COOS', 'STANDARD'),
(1148, '03574', '+44.306320', '-071.728049', 'BETHLEHEM', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1149, '03575', '+44.695648', '-071.387387', 'BRETTON WOODS', 'NH', 'NEW HAMPSHIRE', 'COOS', 'PO BOX ONLY'),
(1150, '03576', '+44.902731', '-071.500809', 'COLEBROOK', 'NH', 'NEW HAMPSHIRE', 'COOS', 'STANDARD'),
(1151, '03579', '+44.695648', '-071.387387', 'ERROL', 'NH', 'NEW HAMPSHIRE', 'COOS', 'STANDARD'),
(1152, '03580', '+44.212814', '-071.737162', 'FRANCONIA', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1153, '03581', '+44.404848', '-071.154758', 'GORHAM', 'NH', 'NEW HAMPSHIRE', 'COOS', 'STANDARD'),
(1154, '03582', '+44.750960', '-071.422453', 'GROVETON', 'NH', 'NEW HAMPSHIRE', 'COOS', 'STANDARD'),
(1155, '03583', '+44.695648', '-071.387387', 'JEFFERSON', 'NH', 'NEW HAMPSHIRE', 'COOS', 'STANDARD'),
(1156, '03584', '+44.476575', '-071.561225', 'LANCASTER', 'NH', 'NEW HAMPSHIRE', 'COOS', 'STANDARD'),
(1157, '03585', '+44.245004', '-071.888882', 'LISBON', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1158, '03587', '+44.695648', '-071.387387', 'MEADOWS', 'NH', 'NEW HAMPSHIRE', 'COOS', 'PO BOX ONLY'),
(1159, '03588', '+44.565320', '-071.218672', 'MILAN', 'NH', 'NEW HAMPSHIRE', 'COOS', 'STANDARD'),
(1160, '03589', '+44.695648', '-071.387387', 'MOUNT WASHINGTON', 'NH', 'NEW HAMPSHIRE', 'COOS', 'PO BOX ONLY'),
(1161, '03590', '+44.695648', '-071.387387', 'NORTH STRATFORD', 'NH', 'NEW HAMPSHIRE', 'COOS', 'STANDARD'),
(1162, '03592', '+44.695648', '-071.387387', 'PITTSBURG', 'NH', 'NEW HAMPSHIRE', 'COOS', 'STANDARD'),
(1163, '03595', '+44.268950', '-071.547061', 'TWIN MOUNTAIN', 'NH', 'NEW HAMPSHIRE', 'COOS', 'PO BOX ONLY'),
(1164, '03597', '+44.695648', '-071.387387', 'WEST STEWARTSTOWN', 'NH', 'NEW HAMPSHIRE', 'COOS', 'PO BOX ONLY'),
(1165, '03598', '+44.363681', '-071.610189', 'WHITEFIELD', 'NH', 'NEW HAMPSHIRE', 'COOS', 'STANDARD'),
(1166, '03601', '+43.195982', '-072.300075', 'ACWORTH', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1167, '03602', '+43.134412', '-072.310623', 'ALSTEAD', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1168, '03603', '+43.268117', '-072.370222', 'CHARLESTOWN', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1169, '03604', '+42.947098', '-072.243029', 'DREWSVILLE', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1170, '03605', '+43.213615', '-072.196758', 'LEMPSTER', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1171, '03607', '+43.364504', '-072.193966', 'SOUTH ACWORTH', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1172, '03608', '+43.072239', '-072.390121', 'WALPOLE', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1173, '03609', '+43.138018', '-072.407236', 'NORTH WALPOLE', 'NH', 'NEW HAMPSHIRE', 'CHESHIRE', 'STANDARD'),
(1174, '03740', '+44.114163', '-071.948852', 'BATH', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1175, '03741', '+43.631230', '-072.057312', 'CANAAN', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1176, '03743', '+43.415993', '-072.209819', 'CLAREMONT', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1177, '03745', '+43.462156', '-072.337149', 'CORNISH', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1178, '03746', '+43.364504', '-072.193966', 'CORNISH FLAT', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1179, '03748', '+43.630906', '-072.116603', 'ENFIELD', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1180, '03749', '+43.579573', '-072.085410', 'ENFIELD CENTER', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'PO BOX ONLY'),
(1181, '03750', '+43.697999', '-072.215182', 'ETNA', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1182, '03751', '+43.448720', '-072.063675', 'GEORGES MILLS', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'PO BOX ONLY'),
(1183, '03752', '+43.417705', '-072.196718', 'GOSHEN', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1184, '03753', '+43.463101', '-072.218445', 'GRANTHAM', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1185, '03754', '+43.365618', '-072.125562', 'GUILD', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'PO BOX ONLY'),
(1186, '03755', '+43.861077', '-072.120314', 'HANOVER', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1187, '03756', '+43.967542', '-071.840883', 'LEBANON', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1188, '03765', '+44.037549', '-072.046692', 'HAVERHILL', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1189, '03766', '+43.637148', '-072.235460', 'LEBANON', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1190, '03768', '+43.801656', '-072.130495', 'LYME', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1191, '03769', '+43.786267', '-072.120468', 'LYME CENTER', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'PO BOX ONLY'),
(1192, '03770', '+43.421675', '-072.255638', 'MERIDEN', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1193, '03771', '+44.268612', '-072.015317', 'MONROE', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1194, '03773', '+43.390485', '-072.199659', 'NEWPORT', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1195, '03774', '+44.077803', '-072.014608', 'NORTH HAVERHILL', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1196, '03777', '+43.927348', '-072.109870', 'ORFORD', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1197, '03779', '+43.948343', '-072.062132', 'PIERMONT', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1198, '03780', '+43.967542', '-071.840883', 'PIKE', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1199, '03781', '+43.432999', '-072.282596', 'PLAINFIELD', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1200, '03782', '+43.426838', '-072.154710', 'SUNAPEE', 'NH', 'NEW HAMPSHIRE', 'SULLIVAN', 'STANDARD'),
(1201, '03784', '+43.644367', '-072.234800', 'WEST LEBANON', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1202, '03785', '+43.948644', '-072.080708', 'WOODSVILLE', 'NH', 'NEW HAMPSHIRE', 'GRAFTON', 'STANDARD'),
(1203, '03801', '+43.009222', '-070.950742', 'PORTSMOUTH', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1204, '03802', '+43.005895', '-071.013202', 'PORTSMOUTH', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1205, '03803', '+42.927030', '-071.444752', 'PORTSMOUTH', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'UNIQUE'),
(1206, '03804', '+43.005895', '-071.013202', 'PORTSMOUTH', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1207, '03805', '+43.285282', '-070.930684', 'ROLLINSFORD', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'UNIQUE'),
(1208, '03809', '+43.462586', '-071.222455', 'ALTON', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1209, '03810', '+43.502514', '-071.277387', 'ALTON BAY', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1210, '03811', '+42.878366', '-071.159035', 'ATKINSON', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1211, '03812', '+43.883871', '-071.257726', 'BARTLETT', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1212, '03813', '+43.797391', '-071.145357', 'CENTER CONWAY', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1213, '03814', '+43.762429', '-071.122689', 'CENTER OSSIPEE', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1214, '03815', '+43.253739', '-071.109825', 'CENTER STRAFFORD', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1215, '03816', '+43.660752', '-071.274458', 'CENTER TUFTONBORO', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1216, '03817', '+43.748580', '-071.089796', 'CHOCORUA', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1217, '03818', '+43.788920', '-071.102610', 'CONWAY', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1218, '03819', '+42.926725', '-071.082299', 'DANVILLE', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1219, '03820', '+43.297309', '-070.992042', 'DOVER', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1220, '03821', '+43.326734', '-071.028427', 'DOVER', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1221, '03822', '+43.326734', '-071.028427', 'DOVER', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'UNIQUE'),
(1222, '03824', '+43.165772', '-070.962843', 'DURHAM', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1223, '03825', '+43.297790', '-071.097423', 'BARRINGTON', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1224, '03826', '+42.893629', '-071.142690', 'EAST HAMPSTEAD', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1225, '03827', '+42.912071', '-071.054245', 'EAST KINGSTON', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1226, '03830', '+43.635065', '-071.009368', 'EAST WAKEFIELD', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1227, '03832', '+43.883871', '-071.257726', 'EATON CENTER', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1228, '03833', '+42.951274', '-070.922262', 'EXETER', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1229, '03835', '+43.306172', '-071.003435', 'FARMINGTON', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1230, '03836', '+43.823704', '-071.093154', 'FREEDOM', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1231, '03837', '+43.446567', '-071.299456', 'GILMANTON IRON WORKS', 'NH', 'NEW HAMPSHIRE', 'BELKNAP', 'STANDARD'),
(1232, '03838', '+44.050111', '-071.265371', 'GLEN', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1233, '03839', '+43.309966', '-070.998256', 'ROCHESTER', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1234, '03840', '+43.038634', '-070.809157', 'GREENLAND', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1235, '03841', '+42.877438', '-071.139098', 'HAMPSTEAD', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1236, '03842', '+42.917389', '-070.950950', 'HAMPTON', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1237, '03843', '+43.005895', '-071.013202', 'HAMPTON', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1238, '03844', '+42.891888', '-070.982601', 'HAMPTON FALLS', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1239, '03845', '+44.082716', '-071.134348', 'INTERVALE', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1240, '03846', '+43.883871', '-071.257726', 'JACKSON', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1241, '03847', '+43.883871', '-071.257726', 'KEARSARGE', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'PO BOX ONLY'),
(1242, '03848', '+42.909731', '-071.102933', 'KINGSTON', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1243, '03849', '+43.902311', '-071.124612', 'MADISON', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1244, '03850', '+43.707657', '-071.301681', 'MELVIN VILLAGE', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'PO BOX ONLY'),
(1245, '03851', '+43.422942', '-071.011369', 'MILTON', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'PO BOX ONLY'),
(1246, '03852', '+43.326734', '-071.028427', 'MILTON MILLS', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1247, '03853', '+43.646319', '-071.282068', 'MIRROR LAKE', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1248, '03854', '+43.064938', '-070.721596', 'NEW CASTLE', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'PO BOX ONLY'),
(1249, '03855', '+43.459503', '-071.119055', 'NEW DURHAM', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1250, '03856', '+43.037363', '-070.978211', 'NEWFIELDS', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1251, '03857', '+42.979021', '-070.891642', 'NEWMARKET', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1252, '03858', '+42.937092', '-071.006898', 'NEWTON', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1253, '03859', '+42.861915', '-071.040020', 'NEWTON JUNCTION', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'PO BOX ONLY'),
(1254, '03860', '+43.784643', '-071.102630', 'NORTH CONWAY', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1255, '03862', '+43.000270', '-070.913947', 'NORTH HAMPTON', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1256, '03864', '+43.667352', '-071.153338', 'OSSIPEE', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1257, '03865', '+42.937838', '-070.926206', 'PLAISTOW', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1258, '03866', '+43.411760', '-071.027303', 'ROCHESTER', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1259, '03867', '+43.326831', '-070.993148', 'ROCHESTER', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1260, '03868', '+43.349689', '-070.945161', 'ROCHESTER', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1261, '03869', '+43.161360', '-070.942666', 'ROLLINSFORD', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1262, '03870', '+43.010939', '-070.764813', 'RYE', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1263, '03871', '+42.980639', '-070.771896', 'RYE BEACH', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'PO BOX ONLY'),
(1264, '03872', '+43.570694', '-071.079427', 'SANBORNVILLE', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1265, '03873', '+42.922666', '-071.174262', 'SANDOWN', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1266, '03874', '+42.964415', '-070.819897', 'SEABROOK', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1267, '03875', '+43.855269', '-071.176182', 'SILVER LAKE', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1268, '03878', '+43.229489', '-070.958264', 'SOMERSWORTH', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1269, '03882', '+43.704702', '-070.990155', 'EFFINGHAM', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1270, '03883', '+43.883871', '-071.257726', 'SOUTH TAMWORTH', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1271, '03884', '+43.256871', '-071.171886', 'STRAFFORD', 'NH', 'NEW HAMPSHIRE', 'STRAFFORD', 'STANDARD'),
(1272, '03885', '+43.012950', '-070.882134', 'STRATHAM', 'NH', 'NEW HAMPSHIRE', 'ROCKINGHAM', 'STANDARD'),
(1273, '03886', '+43.647527', '-071.277779', 'TAMWORTH', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1274, '03887', '+43.459999', '-071.040842', 'UNION', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1275, '03890', '+43.811782', '-071.194586', 'WEST OSSIPEE', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1276, '03894', '+43.667102', '-071.183597', 'WOLFEBORO', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1277, '03896', '+43.589157', '-071.218894', 'WOLFEBORO FALLS', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'PO BOX ONLY'),
(1278, '03897', '+43.883871', '-071.257726', 'WONALANCET', 'NH', 'NEW HAMPSHIRE', 'CARROLL', 'STANDARD'),
(1279, '03901', '+43.279539', '-070.740013', 'BERWICK', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1280, '03902', '+43.245785', '-070.664719', 'CAPE NEDDICK', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1281, '03903', '+43.182729', '-070.745759', 'ELIOT', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1282, '03904', '+43.191554', '-070.684607', 'KITTERY', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1283, '03905', '+43.094746', '-070.689280', 'KITTERY POINT', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1284, '03906', '+43.340626', '-070.753996', 'NORTH BERWICK', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1285, '03907', '+43.350806', '-070.731498', 'OGUNQUIT', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1286, '03908', '+43.227549', '-070.711710', 'SOUTH BERWICK', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1287, '03909', '+43.237891', '-070.690990', 'YORK', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1288, '03910', '+43.211674', '-070.732010', 'YORK BEACH', 'ME', 'MAINE', 'YORK', 'PO BOX ONLY'),
(1289, '03911', '+43.155465', '-070.635702', 'YORK HARBOR', 'ME', 'MAINE', 'YORK', 'PO BOX ONLY'),
(1290, '04001', '+43.520752', '-070.804588', 'ACTON', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1291, '04002', '+43.467224', '-070.738992', 'ALFRED', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1292, '04003', '+43.735867', '-069.995456', 'BAILEY ISLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1293, '04004', '+43.365658', '-070.604379', 'BAR MILLS', 'ME', 'MAINE', 'YORK', 'PO BOX ONLY'),
(1294, '04005', '+43.532376', '-070.651859', 'BIDDEFORD', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1295, '04006', '+43.436049', '-070.359800', 'BIDDEFORD POOL', 'ME', 'MAINE', 'YORK', 'PO BOX ONLY'),
(1296, '04007', '+43.458130', '-070.505301', 'BIDDEFORD', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1297, '04008', '+44.023162', '-069.875816', 'BOWDOINHAM', 'ME', 'MAINE', 'SAGADAHOC', 'STANDARD'),
(1298, '04009', '+43.939828', '-070.747431', 'BRIDGTON', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1299, '04010', '+44.163033', '-070.739823', 'BROWNFIELD', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1300, '04011', '+43.935634', '-070.340652', 'BRUNSWICK', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1301, '04013', '+44.408078', '-070.470703', 'BUSTINS ISLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1302, '04014', '+43.365658', '-070.604379', 'CAPE PORPOISE', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1303, '04015', '+43.962115', '-070.524465', 'CASCO', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1304, '04016', '+44.180965', '-070.891727', 'CENTER LOVELL', 'ME', 'MAINE', 'OXFORD', 'PO BOX ONLY'),
(1305, '04017', '+43.727806', '-070.120437', 'CHEBEAGUE ISLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1306, '04019', '+44.408078', '-070.470703', 'CLIFF ISLAND', 'ME', 'MAINE', 'CUMBERLAND', 'PO BOX ONLY'),
(1307, '04020', '+43.773970', '-070.791727', 'CORNISH', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1308, '04021', '+43.812676', '-070.450494', 'CUMBERLAND CENTER', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1309, '04022', '+44.566156', '-070.661557', 'DENMARK', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1310, '04024', '+43.844826', '-070.688656', 'EAST BALDWIN', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1311, '04027', '+43.459708', '-070.915190', 'LEBANON', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1312, '04028', '+43.732391', '-070.845114', 'EAST PARSONFIELD', 'ME', 'MAINE', 'YORK', 'PO BOX ONLY'),
(1313, '04029', '+43.867223', '-070.547159', 'SEBAGO', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1314, '04030', '+43.596921', '-070.689681', 'EAST WATERBORO', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1315, '04032', '+43.864477', '-070.097543', 'FREEPORT', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1316, '04033', '+44.408078', '-070.470703', 'FREEPORT', 'ME', 'MAINE', 'CUMBERLAND', 'UNIQUE'),
(1317, '04034', '+44.408078', '-070.470703', 'FREEPORT', 'ME', 'MAINE', 'CUMBERLAND', 'UNIQUE'),
(1318, '04037', '+44.044292', '-070.964418', 'FRYEBURG', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1319, '04038', '+43.803689', '-070.355188', 'GORHAM', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1320, '04039', '+43.878567', '-070.328889', 'GRAY', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1321, '04040', '+43.992681', '-070.357119', 'HARRISON', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1322, '04041', '+43.879628', '-070.826188', 'HIRAM', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1323, '04042', '+43.584232', '-070.624391', 'HOLLIS CENTER', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1324, '04043', '+43.494679', '-070.549210', 'KENNEBUNK', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1325, '04046', '+43.534125', '-070.607475', 'KENNEBUNKPORT', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1326, '04047', '+43.744987', '-070.909196', 'PARSONSFIELD', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1327, '04048', '+43.661222', '-070.834480', 'LIMERICK', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1328, '04049', '+43.703854', '-070.748668', 'LIMINGTON', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1329, '04050', '+44.408078', '-070.470703', 'LONG ISLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1330, '04051', '+44.139839', '-070.886741', 'LOVELL', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1331, '04053', '+44.408078', '-070.470703', 'MEREPOINT', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1332, '04054', '+43.276341', '-070.597752', 'MOODY', 'ME', 'MAINE', 'YORK', 'PO BOX ONLY'),
(1333, '04055', '+43.957208', '-070.639546', 'NAPLES', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1334, '04056', '+43.658378', '-070.868871', 'NEWFIELD', 'ME', 'MAINE', 'YORK', 'PO BOX ONLY'),
(1335, '04057', '+44.408078', '-070.470703', 'NORTH BRIDGTON', 'ME', 'MAINE', 'CUMBERLAND', 'PO BOX ONLY'),
(1336, '04061', '+43.542090', '-070.710773', 'NORTH WATERBORO', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1337, '04062', '+43.911381', '-070.396652', 'WINDHAM', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1338, '04063', '+43.504889', '-070.385703', 'OCEAN PARK', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1339, '04064', '+43.411837', '-070.469526', 'OLD ORCHARD BEACH', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1340, '04066', '+43.779982', '-069.975477', 'ORRS ISLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1341, '04068', '+43.848322', '-070.935379', 'PORTER', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1342, '04069', '+43.894983', '-070.189159', 'POWNAL', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1343, '04070', '+43.576983', '-070.273642', 'SCARBOROUGH', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1344, '04071', '+43.906227', '-070.465928', 'RAYMOND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1345, '04072', '+43.541241', '-070.666387', 'SACO', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1346, '04073', '+43.576196', '-070.630569', 'SANFORD', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1347, '04074', '+43.724562', '-070.375162', 'SCARBOROUGH', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1348, '04075', '+43.796053', '-070.552183', 'SEBAGO LAKE', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1349, '04076', '+43.510275', '-070.771590', 'SHAPLEIGH', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1350, '04077', '+43.910029', '-070.524524', 'SOUTH CASCO', 'ME', 'MAINE', 'CUMBERLAND', 'PO BOX ONLY'),
(1351, '04078', '+43.820774', '-070.120781', 'SOUTH FREEPORT', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1352, '04079', '+43.781050', '-069.995537', 'HARPSWELL', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1353, '04081', '+44.566156', '-070.661557', 'SOUTH WATERFORD', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1354, '04082', '+44.408078', '-070.470703', 'SOUTH WINDHAM', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1355, '04083', '+43.465941', '-070.748295', 'SPRINGVALE', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1356, '04084', '+43.804454', '-070.554905', 'STANDISH', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1357, '04085', '+43.771934', '-070.639561', 'STEEP FALLS', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1358, '04086', '+43.981404', '-069.937793', 'TOPSHAM', 'ME', 'MAINE', 'SAGADAHOC', 'STANDARD'),
(1359, '04087', '+43.573684', '-070.749181', 'WATERBORO', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1360, '04088', '+44.566156', '-070.661557', 'WATERFORD', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1361, '04090', '+43.429659', '-070.671274', 'WELLS', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1362, '04091', '+44.408078', '-070.470703', 'WEST BALDWIN', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1363, '04092', '+43.855116', '-070.568534', 'WESTBROOK', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1364, '04093', '+43.653805', '-070.622959', 'BUXTON', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1365, '04094', '+43.406101', '-070.573255', 'WEST KENNEBUNK', 'ME', 'MAINE', 'YORK', 'PO BOX ONLY'),
(1366, '04095', '+43.601018', '-070.902676', 'WEST NEWFIELD', 'ME', 'MAINE', 'YORK', 'STANDARD'),
(1367, '04096', '+43.798227', '-070.171979', 'YARMOUTH', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1368, '04097', '+43.837951', '-070.200114', 'NORTH YARMOUTH', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1369, '04098', '+44.408078', '-070.470703', 'WESTBROOK', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1370, '04101', '+43.658784', '-070.262393', 'PORTLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1371, '04102', '+43.742750', '-070.443380', 'PORTLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1372, '04103', '+43.688260', '-070.289844', 'PORTLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1373, '04104', '+43.846490', '-070.464839', 'PORTLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1374, '04105', '+43.739280', '-070.270696', 'FALMOUTH', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1375, '04106', '+43.627364', '-070.289248', 'SOUTH PORTLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1376, '04107', '+43.595512', '-070.239559', 'CAPE ELIZABETH', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1377, '04108', '+43.662809', '-070.188442', 'PEAKS ISLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1378, '04109', '+43.678339', '-070.198742', 'PORTLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1379, '04110', '+43.759021', '-070.199307', 'CUMBERLAND FORESIDE', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1380, '04112', '+44.408078', '-070.470703', 'PORTLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1381, '04116', '+44.408078', '-070.470703', 'SOUTH PORTLAND', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1382, '04122', '+44.408078', '-070.470703', 'PORTLAND', 'ME', 'MAINE', 'CUMBERLAND', 'UNIQUE'),
(1383, '04123', '+44.408078', '-070.470703', 'PORTLAND', 'ME', 'MAINE', 'CUMBERLAND', 'UNIQUE'),
(1384, '04124', '+44.408078', '-070.470703', 'PORTLAND', 'ME', 'MAINE', 'CUMBERLAND', 'UNIQUE'),
(1385, '04210', '+44.087422', '-070.243848', 'AUBURN', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1386, '04211', '+44.197009', '-070.239485', 'AUBURN', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1387, '04212', '+44.197009', '-070.239485', 'AUBURN', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1388, '04216', '+44.568160', '-070.704051', 'ANDOVER', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1389, '04217', '+44.428414', '-070.770035', 'BETHEL', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1390, '04219', '+44.265009', '-070.587095', 'BRYANT POND', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1391, '04220', '+44.326165', '-070.381112', 'BUCKFIELD', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1392, '04221', '+44.385750', '-070.311314', 'CANTON', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1393, '04222', '+43.968378', '-070.184618', 'DURHAM', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1394, '04223', '+44.023873', '-070.285748', 'DANVILLE', 'ME', 'MAINE', 'ANDROSCOGGIN', 'PO BOX ONLY'),
(1395, '04224', '+44.553968', '-070.422541', 'DIXFIELD', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1396, '04225', '+44.602705', '-070.226510', 'DRYDEN', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1397, '04226', '+44.555618', '-070.691857', 'EAST ANDOVER', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1398, '04227', '+44.579135', '-070.326337', 'EAST DIXFIELD', 'ME', 'MAINE', 'FRANKLIN', 'PO BOX ONLY'),
(1399, '04228', '+44.197009', '-070.239485', 'EAST LIVERMORE', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1400, '04230', '+44.062672', '-070.327049', 'EAST POLAND', 'ME', 'MAINE', 'ANDROSCOGGIN', 'PO BOX ONLY'),
(1401, '04231', '+44.313283', '-070.861797', 'STONEHAM', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1402, '04234', '+44.617509', '-070.182012', 'EAST WILTON', 'ME', 'MAINE', 'FRANKLIN', 'PO BOX ONLY'),
(1403, '04236', '+44.189655', '-070.136683', 'GREENE', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1404, '04237', '+44.494347', '-070.735691', 'HANOVER', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1405, '04238', '+44.225640', '-070.372831', 'HEBRON', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1406, '04239', '+44.541508', '-070.208556', 'JAY', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1407, '04240', '+44.086323', '-070.169297', 'LEWISTON', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1408, '04241', '+44.197009', '-070.239485', 'LEWISTON', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1409, '04243', '+44.197009', '-070.239485', 'LEWISTON', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1410, '04250', '+44.033026', '-070.101247', 'LISBON', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1411, '04252', '+44.032476', '-070.068046', 'LISBON FALLS', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1412, '04253', '+44.297416', '-070.189139', 'LIVERMORE', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1413, '04254', '+44.242189', '-070.188508', 'LIVERMORE FALLS', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1414, '04255', '+44.401595', '-070.708774', 'GREENWOOD', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1415, '04256', '+44.079644', '-070.272624', 'MECHANIC FALLS', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1416, '04257', '+44.570265', '-070.516131', 'MEXICO', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1417, '04258', '+44.146121', '-070.339859', 'MINOT', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1418, '04259', '+44.349166', '-069.870181', 'MONMOUTH', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1419, '04260', '+43.967474', '-070.299687', 'NEW GLOUCESTER', 'ME', 'MAINE', 'CUMBERLAND', 'STANDARD'),
(1420, '04261', '+44.689526', '-071.011246', 'NEWRY', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1421, '04262', '+45.063384', '-070.381639', 'NORTH JAY', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1422, '04263', '+44.292089', '-070.135366', 'LEEDS', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1423, '04265', '+44.303359', '-070.037848', 'NORTH MONMOUTH', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1424, '04266', '+44.357987', '-070.255783', 'NORTH TURNER', 'ME', 'MAINE', 'ANDROSCOGGIN', 'PO BOX ONLY'),
(1425, '04267', '+44.566156', '-070.661557', 'NORTH WATERFORD', 'ME', 'MAINE', 'OXFORD', 'PO BOX ONLY'),
(1426, '04268', '+44.280503', '-070.691576', 'NORWAY', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1427, '04270', '+44.284385', '-070.507791', 'OXFORD', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1428, '04271', '+44.264111', '-070.498513', 'PARIS', 'ME', 'MAINE', 'OXFORD', 'PO BOX ONLY'),
(1429, '04274', '+44.047435', '-070.389923', 'POLAND', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1430, '04275', '+44.566156', '-070.661557', 'ROXBURY', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1431, '04276', '+44.523556', '-070.638174', 'RUMFORD', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1432, '04278', '+44.377031', '-070.568041', 'RUMFORD CENTER', 'ME', 'MAINE', 'OXFORD', 'PO BOX ONLY'),
(1433, '04280', '+44.126723', '-070.126922', 'SABATTUS', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1434, '04281', '+44.353052', '-070.607841', 'SOUTH PARIS', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1435, '04282', '+44.265473', '-070.254155', 'TURNER', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1436, '04283', '+44.197009', '-070.239485', 'TURNER CENTER', 'ME', 'MAINE', 'ANDROSCOGGIN', 'STANDARD'),
(1437, '04284', '+44.359835', '-070.074555', 'WAYNE', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1438, '04285', '+45.063384', '-070.381639', 'WELD', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1439, '04286', '+44.402050', '-070.860094', 'WEST BETHEL', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1440, '04287', '+44.057514', '-069.965553', 'BOWDOIN', 'ME', 'MAINE', 'SAGADAHOC', 'STANDARD'),
(1441, '04288', '+44.197009', '-070.239485', 'WEST MINOT', 'ME', 'MAINE', 'ANDROSCOGGIN', 'PO BOX ONLY'),
(1442, '04289', '+44.340438', '-070.543265', 'WEST PARIS', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1443, '04290', '+44.477183', '-070.436722', 'PERU', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1444, '04291', '+44.040857', '-070.453006', 'WEST POLAND', 'ME', 'MAINE', 'ANDROSCOGGIN', 'PO BOX ONLY'),
(1445, '04292', '+44.318900', '-070.477506', 'SUMNER', 'ME', 'MAINE', 'OXFORD', 'STANDARD'),
(1446, '04294', '+44.618873', '-070.245935', 'WILTON', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1447, '04330', '+44.351642', '-069.803773', 'AUGUSTA', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1448, '04332', '+44.414056', '-069.751913', 'AUGUSTA', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1449, '04333', '+44.414056', '-069.751913', 'AUGUSTA', 'ME', 'MAINE', 'KENNEBEC', 'UNIQUE'),
(1450, '04336', '+44.315693', '-069.818009', 'AUGUSTA', 'ME', 'MAINE', 'KENNEBEC', 'UNIQUE'),
(1451, '04338', '+44.414056', '-069.751913', 'AUGUSTA', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1452, '04341', '+44.258771', '-069.551024', 'COOPERS MILLS', 'ME', 'MAINE', 'LINCOLN', 'PO BOX ONLY'),
(1453, '04342', '+44.077448', '-069.738418', 'DRESDEN', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1454, '04343', '+44.414056', '-069.751913', 'EAST WINTHROP', 'ME', 'MAINE', 'KENNEBEC', 'PO BOX ONLY'),
(1455, '04344', '+44.256614', '-069.797105', 'FARMINGDALE', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1456, '04345', '+44.296652', '-069.796909', 'GARDINER', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1457, '04346', '+44.269959', '-069.724135', 'RANDOLPH', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1458, '04347', '+44.249130', '-069.795037', 'HALLOWELL', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1459, '04348', '+44.220432', '-069.513293', 'JEFFERSON', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1460, '04349', '+44.414056', '-069.751913', 'KENTS HILL', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1461, '04350', '+44.158104', '-069.954040', 'LITCHFIELD', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1462, '04351', '+44.358014', '-069.867001', 'MANCHESTER', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1463, '04352', '+44.461522', '-069.986762', 'MOUNT VERNON', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(1464, '04353', '+44.188406', '-069.575119', 'WHITEFIELD', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1465, '04354', '+44.395590', '-069.416800', 'PALERMO', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1466, '04355', '+44.384840', '-069.953716', 'READFIELD', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1467, '04357', '+44.108059', '-069.827489', 'RICHMOND', 'ME', 'MAINE', 'SAGADAHOC', 'STANDARD'),
(1468, '04358', '+44.375578', '-069.586327', 'SOUTH CHINA', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1469, '04359', '+44.183266', '-069.777196', 'SOUTH GARDINER', 'ME', 'MAINE', 'KENNEBEC', 'PO BOX ONLY'),
(1470, '04360', '+44.414056', '-069.751913', 'VIENNA', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1471, '04363', '+44.414056', '-069.751913', 'WINDSOR', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1472, '04364', '+44.322865', '-069.957627', 'WINTHROP', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1473, '04401', '+45.061744', '-068.878893', 'BANGOR', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1474, '04402', '+45.519867', '-068.647416', 'BANGOR', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1475, '04406', '+45.184103', '-069.233382', 'ABBOT', 'ME', 'MAINE', 'PISCATAQUIS', 'STANDARD'),
(1476, '04408', '+44.641873', '-068.391481', 'AURORA', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1477, '04410', '+45.058864', '-068.954320', 'BRADFORD', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1478, '04411', '+44.914946', '-068.625688', 'BRADLEY', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1479, '04412', '+44.835610', '-068.783742', 'BREWER', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1480, '04413', '+45.002969', '-067.495548', 'BROOKTON', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1481, '04414', '+45.310095', '-069.029462', 'BROWNVILLE', 'ME', 'MAINE', 'PISCATAQUIS', 'STANDARD'),
(1482, '04415', '+45.351184', '-069.058062', 'BROWNVILLE JUNCTION', 'ME', 'MAINE', 'PISCATAQUIS', 'PO BOX ONLY'),
(1483, '04416', '+44.600448', '-068.773241', 'BUCKSPORT', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1484, '04417', '+44.817820', '-068.817481', 'BURLINGTON', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1485, '04418', '+45.049429', '-068.581212', 'GREENBUSH', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1486, '04419', '+44.808062', '-068.940624', 'CARMEL', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1487, '04420', '+44.412968', '-068.798047', 'CASTINE', 'ME', 'MAINE', 'HANCOCK', 'UNIQUE'),
(1488, '04421', '+44.415639', '-068.792883', 'CASTINE', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1489, '04422', '+45.066999', '-069.040695', 'CHARLESTON', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1490, '04423', '+45.039478', '-068.529182', 'COSTIGAN', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1491, '04424', '+45.658831', '-067.866054', 'DANFORTH', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1492, '04426', '+45.171605', '-069.207725', 'DOVER FOXCROFT', 'ME', 'MAINE', 'PISCATAQUIS', 'STANDARD'),
(1493, '04427', '+44.989376', '-068.865187', 'CORINTH', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1494, '04428', '+44.791690', '-068.577728', 'EDDINGTON', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1495, '04429', '+44.894294', '-068.818345', 'HOLDEN', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1496, '04430', '+45.233408', '-068.689174', 'EAST MILLINOCKET', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1497, '04431', '+44.561174', '-068.664735', 'EAST ORLAND', 'ME', 'MAINE', 'HANCOCK', 'PO BOX ONLY'),
(1498, '04434', '+45.519867', '-068.647416', 'ETNA', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1499, '04435', '+44.966032', '-069.133080', 'EXETER', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1500, '04438', '+44.632657', '-068.849975', 'FRANKFORT', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1501, '04441', '+45.792364', '-069.304630', 'GREENVILLE', 'ME', 'MAINE', 'PISCATAQUIS', 'STANDARD'),
(1502, '04442', '+45.792364', '-069.304630', 'GREENVILLE JUNCTION', 'ME', 'MAINE', 'PISCATAQUIS', 'STANDARD'),
(1503, '04443', '+45.315976', '-069.457444', 'GUILFORD', 'ME', 'MAINE', 'PISCATAQUIS', 'STANDARD'),
(1504, '04444', '+44.835984', '-068.829046', 'HAMPDEN', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1505, '04448', '+45.245635', '-068.666632', 'HOWLAND', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1506, '04449', '+45.006054', '-068.884621', 'HUDSON', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1507, '04450', '+44.918877', '-068.965803', 'KENDUSKEAG', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1508, '04451', '+45.519867', '-068.647416', 'KINGMAN', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1509, '04453', '+44.787229', '-069.218210', 'LAGRANGE', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1510, '04454', '+45.002969', '-067.495548', 'LAMBERT LAKE', 'ME', 'MAINE', 'WASHINGTON', 'PO BOX ONLY'),
(1511, '04455', '+45.519867', '-068.647416', 'LEE', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1512, '04456', '+44.871231', '-069.011636', 'LEVANT', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1513, '04457', '+45.366794', '-068.492990', 'LINCOLN', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1514, '04459', '+45.519867', '-068.647416', 'MATTAWAMKEAG', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1515, '04460', '+45.618608', '-068.543602', 'MEDWAY', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1516, '04461', '+45.054200', '-068.595946', 'MILFORD', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1517, '04462', '+45.226479', '-068.752091', 'MILLINOCKET', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1518, '04463', '+45.244612', '-068.975988', 'MILO', 'ME', 'MAINE', 'PISCATAQUIS', 'STANDARD'),
(1519, '04464', '+45.792364', '-069.304630', 'MONSON', 'ME', 'MAINE', 'PISCATAQUIS', 'STANDARD'),
(1520, '04467', '+45.519867', '-068.647416', 'OLAMON', 'ME', 'MAINE', 'PENOBSCOT', 'PO BOX ONLY'),
(1521, '04468', '+45.040655', '-068.722962', 'OLD TOWN', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1522, '04469', '+45.002798', '-068.633430', 'ORONO', 'ME', 'MAINE', 'PENOBSCOT', 'UNIQUE'),
(1523, '04471', '+46.516166', '-068.886826', 'ORIENT', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1524, '04472', '+44.409375', '-068.625903', 'ORLAND', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1525, '04473', '+45.068848', '-068.744361', 'ORONO', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1526, '04474', '+44.842939', '-068.782487', 'ORRINGTON', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1527, '04475', '+45.040668', '-068.618775', 'PASSADUMKEAG', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1528, '04476', '+44.433911', '-068.721716', 'PENOBSCOT', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1529, '04478', '+45.286570', '-070.054629', 'ROCKWOOD', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1530, '04479', '+45.792364', '-069.304630', 'SANGERVILLE', 'ME', 'MAINE', 'PISCATAQUIS', 'STANDARD'),
(1531, '04481', '+45.792364', '-069.304630', 'SEBEC', 'ME', 'MAINE', 'PISCATAQUIS', 'STANDARD'),
(1532, '04485', '+45.792364', '-069.304630', 'SHIRLEY MILLS', 'ME', 'MAINE', 'PISCATAQUIS', 'STANDARD'),
(1533, '04487', '+45.519867', '-068.647416', 'SPRINGFIELD', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1534, '04488', '+44.894697', '-069.142341', 'STETSON', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1535, '04489', '+44.922368', '-068.686796', 'STILLWATER', 'ME', 'MAINE', 'PENOBSCOT', 'PO BOX ONLY'),
(1536, '04490', '+45.002969', '-067.495548', 'TOPSFIELD', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1537, '04491', '+45.002969', '-067.495548', 'VANCEBORO', 'ME', 'MAINE', 'WASHINGTON', 'PO BOX ONLY'),
(1538, '04492', '+45.002969', '-067.495548', 'WAITE', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1539, '04493', '+45.519867', '-068.647416', 'WEST ENFIELD', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1540, '04495', '+45.519867', '-068.647416', 'WINN', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1541, '04496', '+44.653370', '-068.917487', 'WINTERPORT', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1542, '04497', '+46.516166', '-068.886826', 'WYTOPITLOCK', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1543, '04530', '+43.867892', '-069.826495', 'BATH', 'ME', 'MAINE', 'SAGADAHOC', 'STANDARD'),
(1544, '04535', '+44.008962', '-069.566684', 'ALNA', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1545, '04536', '+44.021333', '-069.523263', 'BAYVILLE', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1546, '04537', '+43.894903', '-069.627163', 'BOOTHBAY', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1547, '04538', '+43.956167', '-069.517161', 'BOOTHBAY HARBOR', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1548, '04539', '+43.928967', '-069.598725', 'BRISTOL', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1549, '04541', '+43.884294', '-069.479184', 'CHAMBERLAIN', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1550, '04543', '+43.986485', '-069.424228', 'DAMARISCOTTA', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1551, '04544', '+43.826770', '-069.597446', 'EAST BOOTHBAY', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1552, '04547', '+44.010424', '-069.231179', 'FRIENDSHIP', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1553, '04548', '+43.805389', '-069.745295', 'GEORGETOWN', 'ME', 'MAINE', 'SAGADAHOC', 'STANDARD'),
(1554, '04549', '+44.021333', '-069.523263', 'ISLE OF SPRINGS', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1555, '04551', '+44.010411', '-069.440192', 'BREMEN', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1556, '04552', '+44.021333', '-069.523263', 'NEWAGEN', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1557, '04553', '+43.991336', '-069.503427', 'NEWCASTLE', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1558, '04554', '+43.870936', '-069.566313', 'NEW HARBOR', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1559, '04555', '+44.074877', '-069.536374', 'NOBLEBORO', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1560, '04556', '+43.931748', '-069.587334', 'EDGECOMB', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1561, '04558', '+43.896727', '-069.509282', 'PEMAQUID', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1562, '04562', '+43.789616', '-069.810821', 'PHIPPSBURG', 'ME', 'MAINE', 'SAGADAHOC', 'STANDARD'),
(1563, '04563', '+44.023010', '-069.255572', 'CUSHING', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1564, '04564', '+43.932449', '-069.468052', 'ROUND POND', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1565, '04565', '+43.773312', '-069.863461', 'SEBASCO ESTATES', 'ME', 'MAINE', 'SAGADAHOC', 'PO BOX ONLY'),
(1566, '04567', '+43.900856', '-069.859541', 'SMALL POINT', 'ME', 'MAINE', 'SAGADAHOC', 'STANDARD'),
(1567, '04568', '+43.877877', '-069.612725', 'SOUTH BRISTOL', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1568, '04570', '+44.021333', '-069.523263', 'SQUIRREL ISLAND', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1569, '04571', '+43.882610', '-069.680144', 'TREVETT', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1570, '04572', '+44.038581', '-069.415708', 'WALDOBORO', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1571, '04573', '+43.929821', '-069.592127', 'WALPOLE', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1572, '04574', '+44.162384', '-069.387795', 'WASHINGTON', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1573, '04575', '+43.854534', '-069.660795', 'WEST BOOTHBAY HARBOR', 'ME', 'MAINE', 'LINCOLN', 'PO BOX ONLY'),
(1574, '04576', '+43.935605', '-069.529648', 'SOUTHPORT', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1575, '04578', '+43.964901', '-069.597134', 'WISCASSET', 'ME', 'MAINE', 'LINCOLN', 'STANDARD'),
(1576, '04579', '+43.938696', '-069.764378', 'WOOLWICH', 'ME', 'MAINE', 'SAGADAHOC', 'STANDARD'),
(1577, '04605', '+44.477935', '-068.356311', 'ELLSWORTH', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1578, '04606', '+45.002969', '-067.495548', 'ADDISON', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1579, '04607', '+44.483471', '-068.090339', 'GOULDSBORO', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1580, '04609', '+44.362323', '-068.305513', 'BAR HARBOR', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1581, '04611', '+45.002969', '-067.495548', 'BEALS', 'ME', 'MAINE', 'WASHINGTON', 'PO BOX ONLY'),
(1582, '04612', '+44.239876', '-068.354598', 'BERNARD', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1583, '04613', '+44.641873', '-068.391481', 'BIRCH HARBOR', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1584, '04614', '+44.296910', '-068.623927', 'BLUE HILL', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1585, '04615', '+44.641873', '-068.391481', 'BLUE HILL FALLS', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1586, '04616', '+44.258121', '-068.567404', 'BROOKLIN', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1587, '04617', '+44.337581', '-068.765568', 'BROOKSVILLE', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1588, '04619', '+45.188254', '-067.389101', 'CALAIS', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1589, '04622', '+44.603258', '-067.923248', 'CHERRYFIELD', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1590, '04623', '+44.698608', '-067.779881', 'COLUMBIA FALLS', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1591, '04624', '+44.641873', '-068.391481', 'COREA', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1592, '04625', '+44.641873', '-068.391481', 'CRANBERRY ISLES', 'ME', 'MAINE', 'HANCOCK', 'PO BOX ONLY'),
(1593, '04626', '+45.002969', '-067.495548', 'CUTLER', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1594, '04627', '+44.213503', '-068.711691', 'DEER ISLE', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1595, '04628', '+45.002969', '-067.495548', 'DENNYSVILLE', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1596, '04629', '+44.641873', '-068.391481', 'EAST BLUE HILL', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1597, '04630', '+44.707460', '-067.462470', 'EAST MACHIAS', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1598, '04631', '+45.036287', '-067.136853', 'EASTPORT', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1599, '04634', '+44.595131', '-068.233576', 'FRANKLIN', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1600, '04635', '+44.641873', '-068.391481', 'FRENCHBORO', 'ME', 'MAINE', 'HANCOCK', 'PO BOX ONLY'),
(1601, '04637', '+45.185635', '-067.601026', 'GRAND LAKE STREAM', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1602, '04640', '+44.641873', '-068.391481', 'HANCOCK', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1603, '04642', '+44.641873', '-068.391481', 'HARBORSIDE', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1604, '04643', '+45.002969', '-067.495548', 'HARRINGTON', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1605, '04644', '+44.641873', '-068.391481', 'HULLS COVE', 'ME', 'MAINE', 'HANCOCK', 'PO BOX ONLY'),
(1606, '04645', '+44.032196', '-069.148017', 'ISLE AU HAUT', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1607, '04646', '+44.641873', '-068.391481', 'ISLESFORD', 'ME', 'MAINE', 'HANCOCK', 'PO BOX ONLY'),
(1608, '04648', '+45.002969', '-067.495548', 'JONESBORO', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1609, '04649', '+45.002969', '-067.495548', 'JONESPORT', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1610, '04650', '+44.641873', '-068.391481', 'LITTLE DEER ISLE', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1611, '04652', '+44.904288', '-067.040767', 'LUBEC', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1612, '04653', '+44.641873', '-068.391481', 'BASS HARBOR', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1613, '04654', '+44.660627', '-067.469196', 'MACHIAS', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1614, '04655', '+45.002969', '-067.495548', 'MACHIASPORT', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1615, '04656', '+44.641873', '-068.391481', 'MANSET', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1616, '04657', '+45.002969', '-067.495548', 'MEDDYBEMPS', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1617, '04658', '+45.002969', '-067.495548', 'MILBRIDGE', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1618, '04660', '+44.334692', '-068.308737', 'MOUNT DESERT', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1619, '04662', '+44.294073', '-068.284865', 'NORTHEAST HARBOR', 'ME', 'MAINE', 'HANCOCK', 'PO BOX ONLY'),
(1620, '04664', '+44.641873', '-068.391481', 'SULLIVAN', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1621, '04665', '+44.641873', '-068.391481', 'OTTER CREEK', 'ME', 'MAINE', 'HANCOCK', 'PO BOX ONLY'),
(1622, '04666', '+44.930092', '-067.156533', 'PEMBROKE', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1623, '04667', '+45.013348', '-067.097043', 'PERRY', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1624, '04668', '+45.209229', '-067.575432', 'PRINCETON', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1625, '04669', '+44.641873', '-068.391481', 'PROSPECT HARBOR', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1626, '04671', '+45.002969', '-067.495548', 'ROBBINSTON', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1627, '04672', '+44.413523', '-068.251778', 'SALSBURY COVE', 'ME', 'MAINE', 'HANCOCK', 'PO BOX ONLY'),
(1628, '04673', '+44.313629', '-068.686305', 'SARGENTVILLE', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1629, '04674', '+44.641873', '-068.391481', 'SEAL COVE', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1630, '04675', '+44.299037', '-068.246314', 'SEAL HARBOR', 'ME', 'MAINE', 'HANCOCK', 'PO BOX ONLY'),
(1631, '04676', '+44.399111', '-068.701228', 'SEDGWICK', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1632, '04677', '+44.491175', '-068.191370', 'SORRENTO', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1633, '04679', '+44.390897', '-068.261568', 'SOUTHWEST HARBOR', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1634, '04680', '+45.002969', '-067.495548', 'STEUBEN', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1635, '04681', '+44.641873', '-068.391481', 'STONINGTON', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1636, '04683', '+44.641873', '-068.391481', 'SUNSET', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1637, '04684', '+44.641873', '-068.391481', 'SURRY', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1638, '04685', '+44.213118', '-068.396479', 'SWANS ISLAND', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1639, '04686', '+45.002969', '-067.495548', 'WESLEY', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1640, '04690', '+44.641873', '-068.391481', 'WEST TREMONT', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1641, '04691', '+45.002969', '-067.495548', 'WHITING', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1642, '04693', '+44.387188', '-068.074964', 'WINTER HARBOR', 'ME', 'MAINE', 'HANCOCK', 'STANDARD'),
(1643, '04694', '+45.152637', '-067.377410', 'BAILEYVILLE', 'ME', 'MAINE', 'WASHINGTON', 'STANDARD'),
(1644, '04730', '+46.121345', '-067.833009', 'HOULTON', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1645, '04732', '+46.975725', '-068.398160', 'ASHLAND', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1646, '04733', '+46.516166', '-068.886826', 'BENEDICTA', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1647, '04734', '+46.516166', '-068.886826', 'BLAINE', 'ME', 'MAINE', 'AROOSTOOK', 'PO BOX ONLY'),
(1648, '04735', '+46.516166', '-068.886826', 'BRIDGEWATER', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1649, '04736', '+46.871355', '-068.025442', 'CARIBOU', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1650, '04737', '+46.516166', '-068.886826', 'CLAYTON LAKE', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1651, '04738', '+46.516166', '-068.886826', 'CROUSEVILLE', 'ME', 'MAINE', 'AROOSTOOK', 'PO BOX ONLY'),
(1652, '04739', '+46.516166', '-068.886826', 'EAGLE LAKE', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1653, '04740', '+46.611101', '-067.855820', 'EASTON', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1654, '04741', '+46.516166', '-068.886826', 'ESTCOURT STATION', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1655, '04742', '+46.746453', '-067.841507', 'FORT FAIRFIELD', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1656, '04743', '+47.056484', '-068.255868', 'FORT KENT', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1657, '04744', '+46.516166', '-068.886826', 'FORT KENT MILLS', 'ME', 'MAINE', 'AROOSTOOK', 'PO BOX ONLY'),
(1658, '04745', '+47.295289', '-068.391920', 'FRENCHVILLE', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1659, '04746', '+47.004340', '-067.998581', 'GRAND ISLE', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1660, '04747', '+46.011345', '-068.273154', 'ISLAND FALLS', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1661, '04750', '+46.906749', '-067.851979', 'LIMESTONE', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1662, '04751', '+46.892918', '-067.964300', 'LIMESTONE', 'ME', 'MAINE', 'AROOSTOOK', 'UNIQUE'),
(1663, '04756', '+46.934538', '-068.109616', 'MADAWASKA', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1664, '04757', '+47.007842', '-068.182061', 'MAPLETON', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1665, '04758', '+46.551571', '-067.848170', 'MARS HILL', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1666, '04759', '+46.516166', '-068.886826', 'MASARDIS', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1667, '04760', '+46.516166', '-068.886826', 'MONTICELLO', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1668, '04761', '+46.100442', '-068.003376', 'NEW LIMERICK', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1669, '04762', '+46.976619', '-068.205546', 'NEW SWEDEN', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1670, '04763', '+46.099980', '-068.144870', 'OAKFIELD', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1671, '04764', '+46.516166', '-068.886826', 'OXBOW', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1672, '04765', '+45.999084', '-068.443112', 'PATTEN', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1673, '04766', '+46.516166', '-068.886826', 'PERHAM', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1674, '04768', '+46.516166', '-068.886826', 'PORTAGE', 'ME', 'MAINE', 'AROOSTOOK', 'PO BOX ONLY'),
(1675, '04769', '+46.715072', '-068.012557', 'PRESQUE ISLE', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1676, '04770', '+46.516166', '-068.886826', 'QUIMBY', 'ME', 'MAINE', 'AROOSTOOK', 'PO BOX ONLY'),
(1677, '04772', '+47.263956', '-068.335025', 'SAINT AGATHA', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1678, '04773', '+46.516166', '-068.886826', 'SAINT DAVID', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1679, '04774', '+46.516166', '-068.886826', 'SAINT FRANCIS', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1680, '04775', '+46.516166', '-068.886826', 'SHERIDAN', 'ME', 'MAINE', 'AROOSTOOK', 'PO BOX ONLY'),
(1681, '04776', '+46.516166', '-068.886826', 'SHERMAN MILLS', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1682, '04777', '+45.519867', '-068.647416', 'SHERMAN STATION', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1683, '04779', '+46.516166', '-068.886826', 'SINCLAIR', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1684, '04780', '+46.516166', '-068.886826', 'SMYRNA MILLS', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1685, '04781', '+46.516166', '-068.886826', 'WALLAGRASS', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1686, '04782', '+45.519867', '-068.647416', 'STACYVILLE', 'ME', 'MAINE', 'PENOBSCOT', 'PO BOX ONLY'),
(1687, '04783', '+46.787807', '-068.155212', 'STOCKHOLM', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1688, '04785', '+46.986075', '-068.042433', 'VAN BUREN', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1689, '04786', '+46.793032', '-068.105233', 'WASHBURN', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1690, '04787', '+46.594523', '-067.930172', 'WESTFIELD', 'ME', 'MAINE', 'AROOSTOOK', 'STANDARD'),
(1691, '04788', '+46.516166', '-068.886826', 'WINTERVILLE', 'ME', 'MAINE', 'AROOSTOOK', 'PO BOX ONLY'),
(1692, '04841', '+44.128607', '-069.068648', 'ROCKLAND', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1693, '04843', '+44.126130', '-069.029238', 'CAMDEN', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1694, '04846', '+44.131005', '-069.091111', 'GLEN COVE', 'ME', 'MAINE', 'KNOX', 'PO BOX ONLY'),
(1695, '04847', '+44.241072', '-069.203015', 'HOPE', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1696, '04848', '+44.309021', '-068.900772', 'ISLESBORO', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1697, '04849', '+44.324832', '-068.998255', 'LINCOLNVILLE', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1698, '04850', '+44.478694', '-069.149559', 'LINCOLNVILLE CENTER', 'ME', 'MAINE', 'WALDO', 'PO BOX ONLY'),
(1699, '04851', '+44.032196', '-069.148017', 'MATINICUS', 'ME', 'MAINE', 'KNOX', 'PO BOX ONLY'),
(1700, '04852', '+44.021333', '-069.523263', 'MONHEGAN', 'ME', 'MAINE', 'LINCOLN', 'PO BOX ONLY'),
(1701, '04853', '+44.113472', '-068.855722', 'NORTH HAVEN', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1702, '04854', '+44.079510', '-069.085574', 'OWLS HEAD', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1703, '04855', '+44.032196', '-069.148017', 'PORT CLYDE', 'ME', 'MAINE', 'KNOX', 'PO BOX ONLY'),
(1704, '04856', '+44.132144', '-069.034160', 'ROCKPORT', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1705, '04857', '+43.995024', '-069.198524', 'SAINT GEORGE', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1706, '04858', '+44.115186', '-069.132883', 'SOUTH THOMASTON', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1707, '04859', '+44.002248', '-069.119550', 'SPRUCE HEAD', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1708, '04860', '+43.963129', '-069.213329', 'TENANTS HARBOR', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1709, '04861', '+44.108131', '-069.042704', 'THOMASTON', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1710, '04862', '+44.231517', '-069.219722', 'UNION', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1711, '04863', '+44.085110', '-068.841965', 'VINALHAVEN', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1712, '04864', '+44.086333', '-069.188163', 'WARREN', 'ME', 'MAINE', 'KNOX', 'STANDARD'),
(1713, '04865', '+44.192369', '-069.121139', 'WEST ROCKPORT', 'ME', 'MAINE', 'KNOX', 'PO BOX ONLY'),
(1714, '04901', '+44.554321', '-069.617809', 'WATERVILLE', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1715, '04903', '+44.549225', '-069.713178', 'WATERVILLE', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1716, '04910', '+44.530366', '-069.639976', 'ALBION', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1717, '04911', '+44.810620', '-069.912885', 'ANSON', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1718, '04912', '+44.922700', '-069.676680', 'ATHENS', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1719, '04915', '+44.404619', '-069.040297', 'BELFAST', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1720, '04917', '+44.480594', '-069.832530', 'BELGRADE', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1721, '04918', '+44.414056', '-069.751913', 'BELGRADE LAKES', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1722, '04920', '+45.575731', '-069.909773', 'BINGHAM', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1723, '04921', '+44.579387', '-069.175448', 'BROOKS', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1724, '04922', '+44.677388', '-069.378829', 'BURNHAM', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1725, '04923', '+45.036055', '-069.438697', 'CAMBRIDGE', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1726, '04924', '+44.743659', '-069.585151', 'CANAAN', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1727, '04925', '+45.575731', '-069.909773', 'CARATUNK', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1728, '04926', '+44.391167', '-069.538257', 'CHINA VILLAGE', 'ME', 'MAINE', 'KENNEBEC', 'PO BOX ONLY'),
(1729, '04927', '+44.621084', '-069.512609', 'CLINTON', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1730, '04928', '+44.944157', '-069.228736', 'CORINNA', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1731, '04929', '+44.761527', '-069.322662', 'DETROIT', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1732, '04930', '+44.964532', '-069.203773', 'DEXTER', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1733, '04932', '+44.681900', '-069.121648', 'DIXMONT', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1734, '04933', '+45.519867', '-068.647416', 'EAST NEWPORT', 'ME', 'MAINE', 'PENOBSCOT', 'PO BOX ONLY'),
(1735, '04935', '+44.414056', '-069.751913', 'EAST VASSALBORO', 'ME', 'MAINE', 'KENNEBEC', 'PO BOX ONLY'),
(1736, '04936', '+45.063384', '-070.381639', 'EUSTIS', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1737, '04937', '+44.646261', '-069.680158', 'FAIRFIELD', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1738, '04938', '+44.650311', '-070.129267', 'FARMINGTON', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1739, '04939', '+45.014913', '-069.156965', 'GARLAND', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1740, '04940', '+44.622563', '-070.075178', 'FARMINGTON FALLS', 'ME', 'MAINE', 'FRANKLIN', 'PO BOX ONLY'),
(1741, '04941', '+44.488583', '-069.339221', 'FREEDOM', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1742, '04942', '+44.973047', '-069.548148', 'HARMONY', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1743, '04943', '+44.896404', '-069.464092', 'HARTLAND', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1744, '04944', '+44.684737', '-069.642500', 'HINCKLEY', 'ME', 'MAINE', 'SOMERSET', 'PO BOX ONLY'),
(1745, '04945', '+44.883675', '-069.452187', 'JACKMAN', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1746, '04947', '+45.063384', '-070.381639', 'KINGFIELD', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1747, '04949', '+44.371549', '-069.155550', 'LIBERTY', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1748, '04950', '+44.786404', '-069.805662', 'MADISON', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1749, '04951', '+44.478694', '-069.149559', 'MONROE', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1750, '04952', '+44.397850', '-069.142182', 'MORRILL', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1751, '04953', '+44.863406', '-069.266827', 'NEWPORT', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1752, '04954', '+45.575731', '-069.909773', 'NEW PORTLAND', 'ME', 'MAINE', 'SOMERSET', 'PO BOX ONLY'),
(1753, '04955', '+44.603630', '-070.010292', 'NEW SHARON', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1754, '04956', '+44.952578', '-070.183554', 'NEW VINEYARD', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1755, '04957', '+44.707468', '-069.818804', 'NORRIDGEWOCK', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1756, '04958', '+44.801900', '-069.946593', 'NORTH ANSON', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1757, '04961', '+45.575731', '-069.909773', 'NORTH NEW PORTLAND', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1758, '04962', '+44.479288', '-069.622006', 'NORTH VASSALBORO', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1759, '04963', '+44.557111', '-069.826495', 'OAKLAND', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1760, '04964', '+45.063384', '-070.381639', 'OQUOSSOC', 'ME', 'MAINE', 'FRANKLIN', 'PO BOX ONLY'),
(1761, '04965', '+44.802655', '-069.537715', 'PALMYRA', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1762, '04966', '+45.063384', '-070.381639', 'PHILLIPS', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1763, '04967', '+44.760948', '-069.387705', 'PITTSFIELD', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1764, '04969', '+44.772503', '-069.247539', 'PLYMOUTH', 'ME', 'MAINE', 'PENOBSCOT', 'STANDARD'),
(1765, '04970', '+44.985998', '-070.660181', 'RANGELEY', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1766, '04971', '+44.931830', '-069.403011', 'SAINT ALBANS', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1767, '04972', '+44.478694', '-069.149559', 'SANDY POINT', 'ME', 'MAINE', 'WALDO', 'PO BOX ONLY'),
(1768, '04973', '+44.357201', '-069.215906', 'SEARSMONT', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1769, '04974', '+44.489412', '-068.933051', 'SEARSPORT', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1770, '04975', '+44.624515', '-069.586852', 'SHAWMUT', 'ME', 'MAINE', 'SOMERSET', 'PO BOX ONLY'),
(1771, '04976', '+44.769303', '-069.593975', 'SKOWHEGAN', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1772, '04978', '+44.621110', '-069.770923', 'SMITHFIELD', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1773, '04979', '+44.931415', '-069.834764', 'SOLON', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1774, '04981', '+44.501114', '-068.891743', 'STOCKTON SPRINGS', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1775, '04982', '+45.063384', '-070.381639', 'STRATTON', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1776, '04983', '+44.814175', '-070.187221', 'STRONG', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1777, '04984', '+44.670079', '-070.196855', 'TEMPLE', 'ME', 'MAINE', 'FRANKLIN', 'STANDARD'),
(1778, '04985', '+45.575731', '-069.909773', 'WEST FORKS', 'ME', 'MAINE', 'SOMERSET', 'STANDARD'),
(1779, '04986', '+44.513048', '-069.183929', 'THORNDIKE', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1780, '04987', '+44.478694', '-069.149559', 'TROY', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1781, '04988', '+44.601175', '-069.357191', 'UNITY', 'ME', 'MAINE', 'WALDO', 'STANDARD'),
(1782, '04989', '+44.427757', '-069.635908', 'VASSALBORO', 'ME', 'MAINE', 'KENNEBEC', 'STANDARD'),
(1783, '04992', '+44.662822', '-070.153049', 'WEST FARMINGTON', 'ME', 'MAINE', 'FRANKLIN', 'PO BOX ONLY'),
(1784, '05001', '+43.591821', '-072.463589', 'WHITE RIVER JUNCTION', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1785, '05009', '+43.592039', '-072.588407', 'WHITE RIVER JUNCTION', 'VT', 'VERMONT', 'WINDSOR', 'UNIQUE'),
(1786, '05030', '+43.410672', '-072.429777', 'ASCUTNEY', 'VT', 'VERMONT', 'WINDSOR', 'PO BOX ONLY'),
(1787, '05031', '+43.657625', '-072.545860', 'BARNARD', 'VT', 'VERMONT', 'WINDSOR', 'PO BOX ONLY'),
(1788, '05032', '+43.758758', '-072.688169', 'BETHEL', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1789, '05033', '+44.004691', '-072.158450', 'BRADFORD', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1790, '05034', '+43.592527', '-072.621578', 'BRIDGEWATER', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1791, '05035', '+43.599795', '-072.675164', 'BRIDGEWATER CORNERS', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1792, '05036', '+44.017782', '-072.577365', 'BROOKFIELD', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1793, '05037', '+43.467179', '-072.488285', 'BROWNSVILLE', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1794, '05038', '+43.994212', '-072.457153', 'CHELSEA', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1795, '05039', '+44.033236', '-072.293631', 'CORINTH', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1796, '05040', '+44.077918', '-072.210962', 'EAST CORINTH', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1797, '05041', '+43.995961', '-072.411393', 'EAST RANDOLPH', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1798, '05042', '+44.359629', '-072.086586', 'EAST RYEGATE', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(1799, '05043', '+43.807282', '-072.214693', 'EAST THETFORD', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1800, '05045', '+43.928681', '-072.196635', 'FAIRLEE', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1801, '05046', '+44.281506', '-072.207573', 'GROTON', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(1802, '05047', '+43.672103', '-072.355539', 'HARTFORD', 'VT', 'VERMONT', 'WINDSOR', 'PO BOX ONLY'),
(1803, '05048', '+43.573379', '-072.402698', 'HARTLAND', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1804, '05049', '+43.592039', '-072.588407', 'HARTLAND FOUR CORNERS', 'VT', 'VERMONT', 'WINDSOR', 'PO BOX ONLY'),
(1805, '05050', '+44.462390', '-072.135804', 'MC INDOE FALLS', 'VT', 'VERMONT', 'CALEDONIA', 'PO BOX ONLY'),
(1806, '05051', '+44.068284', '-072.118739', 'NEWBURY', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1807, '05052', '+43.591324', '-072.349030', 'NORTH HARTLAND', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1808, '05053', '+43.709919', '-072.511882', 'NORTH POMFRET', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1809, '05054', '+43.995961', '-072.411393', 'NORTH THETFORD', 'VT', 'VERMONT', 'ORANGE', 'PO BOX ONLY'),
(1810, '05055', '+43.717918', '-072.361200', 'NORWICH', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1811, '05056', '+43.526289', '-072.724848', 'PLYMOUTH', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1812, '05058', '+43.995961', '-072.411393', 'POST MILLS', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1813, '05059', '+43.664059', '-072.433116', 'QUECHEE', 'VT', 'VERMONT', 'WINDSOR', 'PO BOX ONLY'),
(1814, '05060', '+43.985803', '-072.694098', 'RANDOLPH', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1815, '05061', '+43.928552', '-072.569113', 'RANDOLPH CENTER', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1816, '05062', '+43.475590', '-072.572818', 'READING', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1817, '05065', '+43.777365', '-072.407132', 'SHARON', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1818, '05067', '+43.697055', '-072.508042', 'SOUTH POMFRET', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1819, '05068', '+43.777096', '-072.528249', 'SOUTH ROYALTON', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1820, '05069', '+44.197790', '-072.110362', 'SOUTH RYEGATE', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(1821, '05070', '+43.844018', '-072.378546', 'SOUTH STRAFFORD', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1822, '05071', '+43.565888', '-072.534106', 'SOUTH WOODSTOCK', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1823, '05072', '+43.892586', '-072.369563', 'STRAFFORD', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1824, '05073', '+43.630897', '-072.489080', 'TAFTSVILLE', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1825, '05074', '+43.995961', '-072.411393', 'THETFORD', 'VT', 'VERMONT', 'ORANGE', 'PO BOX ONLY'),
(1826, '05075', '+43.854018', '-072.254614', 'THETFORD CENTER', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1827, '05076', '+43.995961', '-072.411393', 'EAST CORINTH', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1828, '05077', '+43.895465', '-072.473372', 'TUNBRIDGE', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1829, '05079', '+43.952586', '-072.311252', 'VERSHIRE', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1830, '05081', '+44.119395', '-072.088869', 'WELLS RIVER', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1831, '05083', '+43.995961', '-072.411393', 'WEST FAIRLEE', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1832, '05084', '+43.718535', '-072.443862', 'WEST HARTFORD', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1833, '05085', '+43.995961', '-072.411393', 'WEST NEWBURY', 'VT', 'VERMONT', 'ORANGE', 'PO BOX ONLY'),
(1834, '05086', '+44.115326', '-072.317918', 'WEST TOPSHAM', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1835, '05088', '+43.673484', '-072.311960', 'WILDER', 'VT', 'VERMONT', 'WINDSOR', 'PO BOX ONLY'),
(1836, '05089', '+43.518100', '-072.418059', 'WINDSOR', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1837, '05091', '+43.631348', '-072.512835', 'WOODSTOCK', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1838, '05101', '+43.171185', '-072.623106', 'BELLOWS FALLS', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1839, '05141', '+42.994670', '-072.720362', 'CAMBRIDGEPORT', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1840, '05142', '+43.402135', '-072.583854', 'CAVENDISH', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1841, '05143', '+43.298315', '-072.667167', 'CHESTER', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1842, '05144', '+43.592039', '-072.588407', 'CHESTER DEPOT', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1843, '05146', '+43.179936', '-072.605636', 'GRAFTON', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1844, '05148', '+43.228101', '-072.787995', 'LONDONDERRY', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1845, '05149', '+43.376744', '-072.706913', 'LUDLOW', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1846, '05150', '+43.338030', '-072.527652', 'NORTH SPRINGFIELD', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1847, '05151', '+43.409654', '-072.495851', 'PERKINSVILLE', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1848, '05152', '+43.098930', '-073.034944', 'PERU', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1849, '05153', '+43.439854', '-072.620659', 'PROCTORSVILLE', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1850, '05154', '+43.164738', '-072.531940', 'SAXTONS RIVER', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1851, '05155', '+43.169854', '-072.851525', 'SOUTH LONDONDERRY', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1852, '05156', '+43.409710', '-072.586064', 'SPRINGFIELD', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1853, '05158', '+43.082635', '-072.474882', 'WESTMINSTER', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1854, '05159', '+43.093972', '-072.456492', 'WESTMINSTER STATION', 'VT', 'VERMONT', 'WINDHAM', 'PO BOX ONLY'),
(1855, '05161', '+43.316142', '-072.739715', 'WESTON', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(1856, '05201', '+42.934076', '-073.105382', 'BENNINGTON', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1857, '05250', '+43.065719', '-073.134727', 'ARLINGTON', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1858, '05251', '+43.261817', '-073.139173', 'DORSET', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1859, '05252', '+43.069409', '-073.165898', 'EAST ARLINGTON', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1860, '05253', '+43.182502', '-073.065443', 'EAST DORSET', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1861, '05254', '+43.177204', '-073.045787', 'MANCHESTER', 'VT', 'VERMONT', 'BENNINGTON', 'PO BOX ONLY'),
(1862, '05255', '+43.169289', '-073.047358', 'MANCHESTER CENTER', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1863, '05257', '+42.966471', '-073.250529', 'NORTH BENNINGTON', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1864, '05260', '+42.829469', '-073.262496', 'NORTH POWNAL', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1865, '05261', '+42.790682', '-073.201254', 'POWNAL', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1866, '05262', '+42.979702', '-073.192929', 'SHAFTSBURY', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1867, '05301', '+42.884281', '-072.760753', 'BRATTLEBORO', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1868, '05302', '+42.994670', '-072.720362', 'BRATTLEBORO', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1869, '05303', '+42.994670', '-072.720362', 'BRATTLEBORO', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1870, '05304', '+42.994670', '-072.720362', 'BRATTLEBORO', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1871, '05340', '+43.164090', '-072.915140', 'BONDVILLE', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1872, '05341', '+42.968046', '-072.812012', 'EAST DOVER', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1873, '05342', '+42.795363', '-072.817838', 'JACKSONVILLE', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1874, '05343', '+43.012776', '-072.767275', 'JAMAICA', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1875, '05344', '+42.994670', '-072.720362', 'MARLBORO', 'VT', 'VERMONT', 'WINDHAM', 'PO BOX ONLY'),
(1876, '05345', '+43.013138', '-072.678725', 'NEWFANE', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1877, '05346', '+43.016096', '-072.534025', 'PUTNEY', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1878, '05350', '+42.785591', '-072.971932', 'READSBORO', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1879, '05351', '+42.939071', '-072.729230', 'SOUTH NEWFANE', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1880, '05352', '+42.782616', '-073.067501', 'STAMFORD', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(1881, '05353', '+43.070341', '-072.672991', 'TOWNSHEND', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1882, '05354', '+42.773711', '-072.520166', 'VERNON', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1883, '05355', '+43.004760', '-072.792004', 'WARDSBORO', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1884, '05356', '+43.013041', '-072.793787', 'WEST DOVER', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1885, '05357', '+42.957233', '-072.624080', 'WEST DUMMERSTON', 'VT', 'VERMONT', 'WINDHAM', 'PO BOX ONLY'),
(1886, '05358', '+42.766519', '-072.745723', 'WEST HALIFAX', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1887, '05359', '+43.133864', '-072.714573', 'WEST TOWNSHEND', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1888, '05360', '+43.050937', '-072.825636', 'WEST WARDSBORO', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1889, '05361', '+42.783180', '-072.867891', 'WHITINGHAM', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1890, '05362', '+42.975027', '-072.673566', 'WILLIAMSVILLE', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1891, '05363', '+42.944039', '-072.727518', 'WILMINGTON', 'VT', 'VERMONT', 'WINDHAM', 'STANDARD'),
(1892, '05401', '+44.507404', '-073.151384', 'BURLINGTON', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1893, '05402', '+44.442117', '-073.082525', 'BURLINGTON', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1894, '05403', '+44.448119', '-073.098238', 'SOUTH BURLINGTON', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1895, '05404', '+44.498032', '-073.182158', 'WINOOSKI', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1896, '05405', '+44.442117', '-073.082525', 'BURLINGTON', 'VT', 'VERMONT', 'CHITTENDEN', 'UNIQUE'),
(1897, '05406', '+44.442117', '-073.082525', 'BURLINGTON', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1898, '05407', '+44.442117', '-073.082525', 'SOUTH BURLINGTON', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1899, '05439', '+44.495180', '-073.165092', 'COLCHESTER', 'VT', 'VERMONT', 'CHITTENDEN', 'UNIQUE'),
(1900, '05440', '+44.936060', '-073.289065', 'ALBURG', 'VT', 'VERMONT', 'GRAND ISLE', 'STANDARD'),
(1901, '05441', '+44.836967', '-072.921690', 'BAKERSFIELD', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1902, '05442', '+44.724842', '-072.701554', 'BELVIDERE CENTER', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1903, '05443', '+44.157814', '-073.071813', 'BRISTOL', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(1904, '05444', '+44.622180', '-072.881162', 'CAMBRIDGE', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1905, '05445', '+44.316580', '-073.226034', 'CHARLOTTE', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1906, '05446', '+44.535557', '-073.103897', 'COLCHESTER', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1907, '05447', '+44.824855', '-072.895849', 'EAST BERKSHIRE', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1908, '05448', '+44.741186', '-072.882683', 'EAST FAIRFIELD', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1909, '05449', '+44.442117', '-073.082525', 'COLCHESTER', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1910, '05450', '+44.902044', '-072.782425', 'ENOSBURG FALLS', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1911, '05451', '+44.508350', '-073.050271', 'ESSEX', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1912, '05452', '+44.485558', '-073.025271', 'ESSEX JUNCTION', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1913, '05453', '+44.442117', '-073.082525', 'ESSEX JUNCTION', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1914, '05454', '+44.733486', '-072.953478', 'FAIRFAX', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1915, '05455', '+44.816159', '-072.969743', 'FAIRFIELD', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1916, '05456', '+44.210886', '-073.256629', 'FERRISBURG', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(1917, '05457', '+44.960380', '-072.913261', 'FRANKLIN', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1918, '05458', '+44.723391', '-073.303193', 'GRAND ISLE', 'VT', 'VERMONT', 'GRAND ISLE', 'STANDARD'),
(1919, '05459', '+44.962395', '-073.033062', 'HIGHGATE CENTER', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1920, '05460', '+44.974765', '-073.105205', 'HIGHGATE SPRINGS', 'VT', 'VERMONT', 'FRANKLIN', 'PO BOX ONLY'),
(1921, '05461', '+44.455300', '-073.067858', 'HINESBURG', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1922, '05462', '+44.318091', '-073.006184', 'HUNTINGTON', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1923, '05463', '+44.878094', '-073.338597', 'ISLE LA MOTTE', 'VT', 'VERMONT', 'GRAND ISLE', 'STANDARD'),
(1924, '05464', '+44.638789', '-072.821990', 'JEFFERSONVILLE', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1925, '05465', '+44.458996', '-072.955175', 'JERICHO', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1926, '05466', '+44.362504', '-073.019801', 'JONESVILLE', 'VT', 'VERMONT', 'CHITTENDEN', 'PO BOX ONLY'),
(1927, '05468', '+44.643418', '-073.121685', 'MILTON', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1928, '05469', '+44.240375', '-073.134702', 'MONKTON', 'VT', 'VERMONT', 'ADDISON', 'PO BOX ONLY'),
(1929, '05470', '+44.824855', '-072.895849', 'MONTGOMERY', 'VT', 'VERMONT', 'FRANKLIN', 'PO BOX ONLY'),
(1930, '05471', '+44.848241', '-072.619812', 'MONTGOMERY CENTER', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1931, '05472', '+44.149509', '-073.197156', 'NEW HAVEN', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(1932, '05473', '+44.239233', '-073.205939', 'NORTH FERRISBURG', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(1933, '05474', '+44.835274', '-073.277846', 'NORTH HERO', 'VT', 'VERMONT', 'GRAND ISLE', 'STANDARD'),
(1934, '05476', '+44.952669', '-072.654350', 'RICHFORD', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1935, '05477', '+44.387289', '-072.953283', 'RICHMOND', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1936, '05478', '+44.779982', '-072.908985', 'SAINT ALBANS', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1937, '05479', '+44.824855', '-072.895849', 'SAINT ALBANS', 'VT', 'VERMONT', 'FRANKLIN', 'UNIQUE'),
(1938, '05481', '+44.824855', '-072.895849', 'SAINT ALBANS BAY', 'VT', 'VERMONT', 'FRANKLIN', 'PO BOX ONLY'),
(1939, '05482', '+44.424930', '-073.114047', 'SHELBURNE', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1940, '05483', '+44.897751', '-072.961075', 'SHELDON', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1941, '05485', '+44.905573', '-072.963154', 'SHELDON SPRINGS', 'VT', 'VERMONT', 'FRANKLIN', 'PO BOX ONLY'),
(1942, '05486', '+44.738156', '-073.306352', 'SOUTH HERO', 'VT', 'VERMONT', 'GRAND ISLE', 'STANDARD'),
(1943, '05487', '+44.235203', '-073.020860', 'STARKSBORO', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(1944, '05488', '+44.902128', '-072.948391', 'SWANTON', 'VT', 'VERMONT', 'FRANKLIN', 'STANDARD'),
(1945, '05489', '+44.565148', '-072.907209', 'UNDERHILL', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1946, '05490', '+44.504656', '-072.885253', 'UNDERHILL CENTER', 'VT', 'VERMONT', 'CHITTENDEN', 'PO BOX ONLY'),
(1947, '05491', '+44.145691', '-073.260487', 'VERGENNES', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(1948, '05492', '+44.736083', '-072.703199', 'WATERVILLE', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1949, '05494', '+44.569590', '-073.025541', 'WESTFORD', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1950, '05495', '+44.430096', '-073.026735', 'WILLISTON', 'VT', 'VERMONT', 'CHITTENDEN', 'STANDARD'),
(1951, '05501', '+42.647191', '-071.184202', 'ANDOVER', 'MA', 'MASSACHUSETTS', 'ESSEX', 'UNIQUE'),
(1952, '05544', '+42.647191', '-071.184202', 'ANDOVER', 'MA', 'MASSACHUSETTS', 'ESSEX', 'UNIQUE'),
(1953, '05601', '+44.199060', '-072.559638', 'MONTPELIER', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1954, '05602', '+44.268290', '-072.623619', 'MONTPELIER', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1955, '05603', '+44.156554', '-072.655892', 'MONTPELIER', 'VT', 'VERMONT', 'WASHINGTON', 'UNIQUE'),
(1956, '05604', '+44.259518', '-072.585018', 'MONTPELIER', 'VT', 'VERMONT', 'WASHINGTON', 'UNIQUE'),
(1957, '05609', '+44.259518', '-072.585018', 'MONTPELIER', 'VT', 'VERMONT', 'WASHINGTON', 'UNIQUE'),
(1958, '05620', '+44.259518', '-072.585018', 'MONTPELIER', 'VT', 'VERMONT', 'WASHINGTON', 'UNIQUE'),
(1959, '05633', '+44.259518', '-072.585018', 'MONTPELIER', 'VT', 'VERMONT', 'WASHINGTON', 'UNIQUE'),
(1960, '05640', '+44.174872', '-072.502235', 'ADAMANT', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1961, '05641', '+44.208960', '-072.607693', 'BARRE', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1962, '05647', '+44.266228', '-072.530473', 'CABOT', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1963, '05648', '+44.259518', '-072.585018', 'CALAIS', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1964, '05649', '+44.157636', '-072.453261', 'EAST BARRE', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1965, '05650', '+44.407044', '-072.498572', 'EAST CALAIS', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1966, '05651', '+44.279376', '-072.496570', 'EAST MONTPELIER', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1967, '05652', '+44.718619', '-072.578210', 'EDEN', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1968, '05653', '+44.701158', '-072.479642', 'EDEN MILLS', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1969, '05654', '+44.155438', '-072.484706', 'GRANITEVILLE', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1970, '05655', '+44.560808', '-072.590031', 'HYDE PARK', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1971, '05656', '+44.642603', '-072.735911', 'JOHNSON', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1972, '05657', '+44.599905', '-072.647519', 'LAKE ELMORE', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1973, '05658', '+44.374874', '-072.329902', 'MARSHFIELD', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(1974, '05660', '+44.270817', '-072.786431', 'MORETOWN', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1975, '05661', '+44.560179', '-072.615346', 'MORRISVILLE', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1976, '05662', '+44.442001', '-072.718759', 'MOSCOW', 'VT', 'VERMONT', 'LAMOILLE', 'PO BOX ONLY'),
(1977, '05663', '+44.180906', '-072.678854', 'NORTHFIELD', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1978, '05664', '+44.183536', '-072.646591', 'NORTHFIELD FALLS', 'VT', 'VERMONT', 'WASHINGTON', 'PO BOX ONLY'),
(1979, '05665', '+44.673070', '-072.597057', 'NORTH HYDE PARK', 'VT', 'VERMONT', 'LAMOILLE', 'PO BOX ONLY'),
(1980, '05666', '+44.259518', '-072.585018', 'NORTH MONTPELIER', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1981, '05667', '+44.283708', '-072.552243', 'PLAINFIELD', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1982, '05669', '+44.028005', '-073.089655', 'ROXBURY', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(1983, '05670', '+44.175744', '-072.502470', 'SOUTH BARRE', 'VT', 'VERMONT', 'WASHINGTON', 'PO BOX ONLY'),
(1984, '05671', '+44.259518', '-072.585018', 'WATERBURY', 'VT', 'VERMONT', 'WASHINGTON', 'UNIQUE'),
(1985, '05672', '+44.535179', '-072.660043', 'STOWE', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1986, '05673', '+44.192186', '-072.843868', 'WAITSFIELD', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1987, '05674', '+44.217175', '-072.820401', 'WARREN', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1988, '05675', '+44.078238', '-072.426322', 'WASHINGTON', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1989, '05676', '+44.259608', '-072.781143', 'WATERBURY', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1990, '05677', '+44.389313', '-072.708616', 'WATERBURY CENTER', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1991, '05678', '+44.155782', '-072.465810', 'WEBSTERVILLE', 'VT', 'VERMONT', 'WASHINGTON', 'PO BOX ONLY'),
(1992, '05679', '+44.103841', '-072.526916', 'WILLIAMSTOWN', 'VT', 'VERMONT', 'ORANGE', 'STANDARD'),
(1993, '05680', '+44.539539', '-072.487589', 'WOLCOTT', 'VT', 'VERMONT', 'LAMOILLE', 'STANDARD'),
(1994, '05681', '+44.259518', '-072.585018', 'WOODBURY', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1995, '05682', '+44.343536', '-072.575645', 'WORCESTER', 'VT', 'VERMONT', 'WASHINGTON', 'STANDARD'),
(1996, '05701', '+43.630346', '-072.935860', 'RUTLAND', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(1997, '05702', '+43.412792', '-072.990632', 'RUTLAND', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(1998, '05730', '+43.420978', '-072.828524', 'BELMONT', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(1999, '05731', '+43.687677', '-073.291868', 'BENSON', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2000, '05732', '+43.643723', '-073.209356', 'BOMOSEEN', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2001, '05733', '+43.655139', '-073.121251', 'BRANDON', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2002, '05734', '+43.982512', '-073.331483', 'BRIDPORT', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(2003, '05735', '+43.636856', '-073.126638', 'CASTLETON', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2004, '05736', '+43.594106', '-073.008253', 'CENTER RUTLAND', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2005, '05737', '+43.713218', '-072.925199', 'CHITTENDEN', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2006, '05738', '+43.526706', '-072.869165', 'CUTTINGSVILLE', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2007, '05739', '+43.347920', '-073.027985', 'DANBY', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2008, '05740', '+43.971530', '-073.091416', 'EAST MIDDLEBURY', 'VT', 'VERMONT', 'ADDISON', 'PO BOX ONLY'),
(2009, '05741', '+43.592039', '-072.818121', 'EAST POULTNEY', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2010, '05742', '+43.446092', '-072.920870', 'EAST WALLINGFORD', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2011, '05743', '+43.634258', '-073.182585', 'FAIR HAVEN', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2012, '05744', '+43.576783', '-073.107352', 'FLORENCE', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2013, '05745', '+43.592039', '-072.818121', 'FOREST DALE', 'VT', 'VERMONT', 'RUTLAND', 'PO BOX ONLY'),
(2014, '05746', '+43.592039', '-072.588407', 'GAYSVILLE', 'VT', 'VERMONT', 'WINDSOR', 'PO BOX ONLY'),
(2015, '05747', '+44.003200', '-072.817108', 'GRANVILLE', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(2016, '05748', '+43.907858', '-072.890031', 'HANCOCK', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(2017, '05750', '+43.599381', '-073.251040', 'HYDEVILLE', 'VT', 'VERMONT', 'RUTLAND', 'PO BOX ONLY'),
(2018, '05751', '+43.656951', '-072.782713', 'KILLINGTON', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2019, '05753', '+43.991942', '-073.171578', 'MIDDLEBURY', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(2020, '05757', '+43.478301', '-073.060391', 'MIDDLETOWN SPRINGS', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2021, '05758', '+43.444535', '-072.802413', 'MOUNT HOLLY', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2022, '05759', '+43.535739', '-072.970114', 'NORTH CLARENDON', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2023, '05760', '+43.863158', '-073.242322', 'ORWELL', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(2024, '05761', '+43.361439', '-073.150683', 'PAWLET', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2025, '05762', '+43.592039', '-072.818121', 'PITTSFIELD', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2026, '05763', '+43.721820', '-072.999461', 'PITTSFORD', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2027, '05764', '+43.525395', '-073.112878', 'POULTNEY', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2028, '05765', '+43.601975', '-073.095890', 'PROCTOR', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2029, '05766', '+43.979315', '-073.010663', 'RIPTON', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(2030, '05767', '+43.866832', '-072.851495', 'ROCHESTER', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(2031, '05768', '+43.026984', '-073.055156', 'RUPERT', 'VT', 'VERMONT', 'BENNINGTON', 'PO BOX ONLY'),
(2032, '05769', '+43.920297', '-073.122709', 'SALISBURY', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(2033, '05770', '+43.912406', '-073.279162', 'SHOREHAM', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(2034, '05772', '+43.756978', '-072.730177', 'STOCKBRIDGE', 'VT', 'VERMONT', 'WINDSOR', 'STANDARD'),
(2035, '05773', '+43.477386', '-073.066066', 'WALLINGFORD', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2036, '05774', '+43.429363', '-073.161826', 'WELLS', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2037, '05775', '+43.360006', '-073.224211', 'WEST PAWLET', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2038, '05776', '+43.026984', '-073.055156', 'WEST RUPERT', 'VT', 'VERMONT', 'BENNINGTON', 'STANDARD'),
(2039, '05777', '+43.588163', '-073.065323', 'WEST RUTLAND', 'VT', 'VERMONT', 'RUTLAND', 'STANDARD'),
(2040, '05778', '+43.893982', '-073.203001', 'WHITING', 'VT', 'VERMONT', 'ADDISON', 'STANDARD'),
(2041, '05819', '+44.426455', '-072.114155', 'SAINT JOHNSBURY', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2042, '05820', '+44.741679', '-072.364639', 'ALBANY', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2043, '05821', '+44.313675', '-072.118790', 'BARNET', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2044, '05822', '+44.736630', '-072.199084', 'BARTON', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2045, '05823', '+45.005783', '-072.138347', 'BEEBE PLAIN', 'VT', 'VERMONT', 'ORLEANS', 'PO BOX ONLY'),
(2046, '05824', '+44.581613', '-071.833956', 'CONCORD', 'VT', 'VERMONT', 'ESSEX', 'STANDARD'),
(2047, '05825', '+44.775607', '-072.226410', 'COVENTRY', 'VT', 'VERMONT', 'ORLEANS', 'PO BOX ONLY'),
(2048, '05826', '+44.641663', '-072.388928', 'CRAFTSBURY', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2049, '05827', '+44.678786', '-072.359440', 'CRAFTSBURY COMMON', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2050, '05828', '+44.437306', '-072.123508', 'DANVILLE', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2051, '05829', '+44.952347', '-072.218616', 'DERBY', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2052, '05830', '+44.970350', '-072.036632', 'DERBY LINE', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2053, '05832', '+44.587962', '-071.910223', 'EAST BURKE', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2054, '05833', '+44.775607', '-072.226410', 'EAST CHARLESTON', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2055, '05836', '+44.496356', '-072.173710', 'EAST HARDWICK', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2056, '05837', '+44.667396', '-071.813465', 'EAST HAVEN', 'VT', 'VERMONT', 'ESSEX', 'STANDARD'),
(2057, '05838', '+44.468494', '-071.930077', 'EAST SAINT JOHNSBURY', 'VT', 'VERMONT', 'CALEDONIA', 'PO BOX ONLY'),
(2058, '05839', '+44.679528', '-072.221912', 'GLOVER', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2059, '05840', '+44.680771', '-071.719436', 'GRANBY', 'VT', 'VERMONT', 'ESSEX', 'PO BOX ONLY'),
(2060, '05841', '+44.600325', '-072.286556', 'GREENSBORO', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2061, '05842', '+44.775607', '-072.226410', 'GREENSBORO BEND', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2062, '05843', '+44.516090', '-072.309822', 'HARDWICK', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2063, '05845', '+44.783177', '-072.301139', 'IRASBURG', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2064, '05846', '+44.832535', '-071.841125', 'ISLAND POND', 'VT', 'VERMONT', 'ESSEX', 'STANDARD'),
(2065, '05847', '+44.788925', '-072.439455', 'LOWELL', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2066, '05848', '+44.382103', '-071.919518', 'LOWER WATERFORD', 'VT', 'VERMONT', 'CALEDONIA', 'PO BOX ONLY'),
(2067, '05849', '+44.497557', '-071.950519', 'LYNDON', 'VT', 'VERMONT', 'CALEDONIA', 'PO BOX ONLY'),
(2068, '05850', '+44.481915', '-071.988258', 'LYNDON CENTER', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2069, '05851', '+44.535100', '-072.056557', 'LYNDONVILLE', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2070, '05853', '+44.878704', '-071.971424', 'MORGAN', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2071, '05855', '+44.907921', '-072.203948', 'NEWPORT', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2072, '05857', '+44.927018', '-072.299191', 'NEWPORT CENTER', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2073, '05858', '+44.512087', '-071.795986', 'NORTH CONCORD', 'VT', 'VERMONT', 'ESSEX', 'STANDARD'),
(2074, '05859', '+44.937769', '-072.433354', 'NORTH TROY', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2075, '05860', '+44.823782', '-072.102019', 'ORLEANS', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2076, '05861', '+44.462390', '-072.135804', 'PASSUMPSIC', 'VT', 'VERMONT', 'CALEDONIA', 'PO BOX ONLY'),
(2077, '05862', '+44.462390', '-072.135804', 'PEACHAM', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2078, '05863', '+44.503403', '-071.972088', 'SAINT JOHNSBURY CENTER', 'VT', 'VERMONT', 'CALEDONIA', 'PO BOX ONLY'),
(2079, '05866', '+44.639653', '-072.132255', 'SHEFFIELD', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2080, '05867', '+44.664521', '-072.042415', 'SUTTON', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2081, '05868', '+44.775607', '-072.226410', 'TROY', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2082, '05871', '+44.683041', '-071.936817', 'WEST BURKE', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2083, '05872', '+44.849402', '-072.031210', 'WEST CHARLESTON', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2084, '05873', '+44.393366', '-072.222424', 'WEST DANVILLE', 'VT', 'VERMONT', 'CALEDONIA', 'STANDARD'),
(2085, '05874', '+44.869117', '-072.450485', 'WESTFIELD', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2086, '05875', '+44.710028', '-072.258038', 'WEST GLOVER', 'VT', 'VERMONT', 'ORLEANS', 'STANDARD'),
(2087, '05901', '+44.680771', '-071.719436', 'AVERILL', 'VT', 'VERMONT', 'ESSEX', 'STANDARD'),
(2088, '05902', '+44.680771', '-071.719436', 'BEECHER FALLS', 'VT', 'VERMONT', 'ESSEX', 'STANDARD'),
(2089, '05903', '+44.930787', '-071.597809', 'CANAAN', 'VT', 'VERMONT', 'ESSEX', 'STANDARD'),
(2090, '05904', '+44.680771', '-071.719436', 'GILMAN', 'VT', 'VERMONT', 'ESSEX', 'STANDARD'),
(2091, '05905', '+44.671187', '-071.662213', 'GUILDHALL', 'VT', 'VERMONT', 'ESSEX', 'STANDARD'),
(2092, '05906', '+44.680771', '-071.719436', 'LUNENBURG', 'VT', 'VERMONT', 'ESSEX', 'STANDARD'),
(2093, '05907', '+44.932643', '-071.776359', 'NORTON', 'VT', 'VERMONT', 'ESSEX', 'STANDARD'),
(2094, '06001', '+41.757944', '-072.728272', 'AVON', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2095, '06002', '+41.851961', '-072.738939', 'BLOOMFIELD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2096, '06006', '+41.879637', '-072.734271', 'WINDSOR', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2097, '06010', '+41.681198', '-072.939577', 'BRISTOL', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2098, '06011', '+41.791776', '-072.718832', 'BRISTOL', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2099, '06013', '+41.761773', '-072.958260', 'BURLINGTON', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2100, '06016', '+41.842097', '-072.708388', 'BROAD BROOK', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2101, '06018', '+42.001585', '-073.295891', 'CANAAN', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2102, '06019', '+41.842882', '-072.899645', 'CANTON', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2103, '06020', '+41.853921', '-072.902811', 'CANTON CENTER', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2104, '06021', '+42.005809', '-073.118329', 'COLEBROOK', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2105, '06022', '+41.851597', '-072.918127', 'COLLINSVILLE', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2106, '06023', '+41.613489', '-072.720700', 'EAST BERLIN', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2107, '06024', '+42.015806', '-073.291299', 'EAST CANAAN', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2108, '06025', '+41.688896', '-072.534482', 'EAST GLASTONBURY', 'CT', 'CONNECTICUT', 'HARTFORD', 'PO BOX ONLY'),
(2109, '06026', '+41.939096', '-072.740538', 'EAST GRANBY', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2110, '06027', '+42.004978', '-072.896907', 'EAST HARTLAND', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2111, '06028', '+41.859248', '-072.603033', 'EAST WINDSOR HILL', 'CT', 'CONNECTICUT', 'HARTFORD', 'PO BOX ONLY'),
(2112, '06029', '+41.849319', '-072.411777', 'ELLINGTON', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2113, '06030', '+41.791776', '-072.718832', 'FARMINGTON', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2114, '06031', '+41.949717', '-073.304403', 'FALLS VILLAGE', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2115, '06032', '+41.726769', '-072.829543', 'FARMINGTON', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2116, '06033', '+41.703451', '-072.539332', 'GLASTONBURY', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2117, '06034', '+41.791776', '-072.718832', 'FARMINGTON', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2118, '06035', '+41.966062', '-072.796407', 'GRANBY', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2119, '06037', '+41.602948', '-072.769991', 'BERLIN', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2120, '06039', '+41.951917', '-073.381380', 'LAKEVILLE', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2121, '06040', '+41.776048', '-072.523748', 'MANCHESTER', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2122, '06041', '+41.794681', '-072.564832', 'MANCHESTER', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2123, '06043', '+41.768648', '-072.439278', 'BOLTON', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2124, '06045', '+41.791776', '-072.718832', 'MANCHESTER', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2125, '06049', '+41.791776', '-072.718832', 'MELROSE', 'CT', 'CONNECTICUT', 'HARTFORD', 'PO BOX ONLY'),
(2126, '06050', '+41.666049', '-072.778391', 'NEW BRITAIN', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2127, '06051', '+41.668449', '-072.770441', 'NEW BRITAIN', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2128, '06052', '+41.656748', '-072.801892', 'NEW BRITAIN', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2129, '06053', '+41.690249', '-072.790991', 'NEW BRITAIN', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2130, '06057', '+41.883102', '-073.045918', 'NEW HARTFORD', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2131, '06058', '+41.886811', '-073.184674', 'NORFOLK', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2132, '06059', '+41.899683', '-072.890744', 'NORTH CANTON', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2133, '06060', '+42.004694', '-072.843205', 'NORTH GRANBY', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2134, '06061', '+41.874382', '-072.967958', 'PINE MEADOW', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'PO BOX ONLY'),
(2135, '06062', '+41.672983', '-072.859695', 'PLAINVILLE', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2136, '06063', '+41.939370', '-072.990647', 'BARKHAMSTED', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2137, '06064', '+41.791776', '-072.718832', 'POQUONOCK', 'CT', 'CONNECTICUT', 'HARTFORD', 'PO BOX ONLY'),
(2138, '06065', '+41.968597', '-073.014467', 'RIVERTON', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2139, '06066', '+41.837200', '-072.454917', 'VERNON ROCKVILLE', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2140, '06067', '+41.657249', '-072.670887', 'ROCKY HILL', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2141, '06068', '+42.005790', '-073.399336', 'SALISBURY', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2142, '06069', '+41.874681', '-073.433903', 'SHARON', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2143, '06070', '+41.868647', '-072.819742', 'SIMSBURY', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2144, '06071', '+41.919603', '-072.433046', 'SOMERS', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2145, '06072', '+41.976466', '-072.490593', 'SOMERSVILLE', 'CT', 'CONNECTICUT', 'TOLLAND', 'PO BOX ONLY'),
(2146, '06073', '+41.657099', '-072.572233', 'SOUTH GLASTONBURY', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2147, '06074', '+41.834198', '-072.564632', 'SOUTH WINDSOR', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2148, '06075', '+41.811520', '-072.308779', 'STAFFORD', 'CT', 'CONNECTICUT', 'TOLLAND', 'PO BOX ONLY'),
(2149, '06076', '+41.900495', '-072.276410', 'STAFFORD SPRINGS', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2150, '06077', '+41.991645', '-072.257735', 'STAFFORDVILLE', 'CT', 'CONNECTICUT', 'TOLLAND', 'PO BOX ONLY'),
(2151, '06078', '+41.989646', '-072.658135', 'SUFFIELD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2152, '06079', '+42.032012', '-073.403763', 'TACONIC', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'PO BOX ONLY'),
(2153, '06080', '+41.948597', '-072.628802', 'SUFFIELD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2154, '06081', '+41.905269', '-072.767239', 'TARIFFVILLE', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2155, '06082', '+41.984646', '-072.557731', 'ENFIELD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2156, '06083', '+41.791776', '-072.718832', 'ENFIELD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2157, '06084', '+41.882553', '-072.361039', 'TOLLAND', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2158, '06085', '+41.860009', '-072.933467', 'UNIONVILLE', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2159, '06087', '+41.757616', '-072.884953', 'UNIONVILLE', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2160, '06088', '+41.903347', '-072.592883', 'EAST WINDSOR', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2161, '06089', '+41.889965', '-072.704000', 'WEATOGUE', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2162, '06090', '+41.955645', '-072.861993', 'WEST GRANBY', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2163, '06091', '+42.003447', '-072.992109', 'WEST HARTLAND', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2164, '06092', '+41.865597', '-072.849854', 'WEST SIMSBURY', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2165, '06093', '+42.005795', '-072.727337', 'WEST SUFFIELD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2166, '06094', '+41.896321', '-073.146312', 'WINCHESTER CENTER', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2167, '06095', '+41.909988', '-072.804935', 'WINDSOR', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2168, '06096', '+41.933846', '-072.660245', 'WINDSOR LOCKS', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2169, '06098', '+41.925671', '-073.058157', 'WINSTED', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2170, '06101', '+41.780070', '-072.677099', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2171, '06102', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2172, '06103', '+41.766349', '-072.674636', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2173, '06104', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2174, '06105', '+41.774499', '-072.699537', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2175, '06106', '+41.745049', '-072.687787', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2176, '06107', '+41.753250', '-072.758040', 'W HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2177, '06108', '+41.779799', '-072.621365', 'EAST HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2178, '06109', '+41.698899', '-072.667887', 'WETHERSFIELD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2179, '06110', '+41.734250', '-072.738139', 'W HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2180, '06111', '+41.685985', '-072.729646', 'NEWINGTON', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2181, '06112', '+41.791337', '-072.694337', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2182, '06114', '+41.747399', '-072.672237', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2183, '06115', '+41.758849', '-072.679387', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2184, '06117', '+41.788688', '-072.755739', 'W HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2185, '06118', '+41.748999', '-072.609884', 'EAST HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2186, '06119', '+41.764349', '-072.726388', 'W HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2187, '06120', '+41.785449', '-072.669936', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2188, '06123', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2189, '06126', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2190, '06127', '+41.791776', '-072.718832', 'W HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2191, '06128', '+41.791776', '-072.718832', 'EAST HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2192, '06129', '+41.791776', '-072.718832', 'WETHERSFIELD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2193, '06131', '+41.791776', '-072.718832', 'NEWINGTON', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2194, '06132', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2195, '06133', '+41.791776', '-072.718832', 'W HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2196, '06134', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2197, '06137', '+41.791776', '-072.718832', 'W HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2198, '06138', '+41.791776', '-072.718832', 'EAST HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2199, '06140', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2200, '06141', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2201, '06142', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2202, '06143', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2203, '06144', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2204, '06145', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2205, '06146', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2206, '06147', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2207, '06150', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2208, '06151', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2209, '06152', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2210, '06153', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2211, '06154', '+41.771499', '-072.686687', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2212, '06155', '+41.769280', '-072.686465', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2213, '06156', '+41.767949', '-072.690687', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2214, '06160', '+41.766499', '-072.693337', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2215, '06161', '+41.766049', '-072.671837', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2216, '06167', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2217, '06176', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2218, '06180', '+41.791776', '-072.718832', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2219, '06183', '+41.763849', '-072.673037', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'UNIQUE'),
(2220, '06199', '+41.927447', '-072.680386', 'HARTFORD', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2221, '06226', '+41.845504', '-072.091889', 'WILLIMANTIC', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2222, '06230', '+41.847302', '-072.025280', 'ABINGTON', 'CT', 'CONNECTICUT', 'WINDHAM', 'PO BOX ONLY'),
(2223, '06231', '+41.626377', '-072.372800', 'AMSTON', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2224, '06232', '+41.731847', '-072.374634', 'ANDOVER', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2225, '06233', '+41.831565', '-072.020137', 'BALLOUVILLE', 'CT', 'CONNECTICUT', 'WINDHAM', 'PO BOX ONLY'),
(2226, '06234', '+41.847758', '-071.983412', 'BROOKLYN', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2227, '06235', '+41.802940', '-072.126036', 'CHAPLIN', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2228, '06237', '+41.696124', '-072.300043', 'COLUMBIA', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2229, '06238', '+41.778623', '-072.323642', 'COVENTRY', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2230, '06239', '+41.864901', '-071.874354', 'DANIELSON', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2231, '06241', '+41.854975', '-071.858826', 'DAYVILLE', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2232, '06242', '+41.927524', '-072.041112', 'EASTFORD', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2233, '06243', '+41.844885', '-071.818941', 'EAST KILLINGLY', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2234, '06244', '+41.984327', '-071.981045', 'EAST WOODSTOCK', 'CT', 'CONNECTICUT', 'WINDHAM', 'PO BOX ONLY'),
(2235, '06245', '+42.019776', '-071.941669', 'FABYAN', 'CT', 'CONNECTICUT', 'WINDHAM', 'PO BOX ONLY'),
(2236, '06246', '+41.971116', '-071.891732', 'GROSVENOR DALE', 'CT', 'CONNECTICUT', 'WINDHAM', 'PO BOX ONLY'),
(2237, '06247', '+41.788756', '-071.975819', 'HAMPTON', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2238, '06248', '+41.689249', '-072.398627', 'HEBRON', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2239, '06249', '+41.628008', '-072.245422', 'LEBANON', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2240, '06250', '+41.781550', '-072.225540', 'MANSFIELD CENTER', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2241, '06251', '+41.799326', '-072.306526', 'MANSFIELD DEPOT', 'CT', 'CONNECTICUT', 'TOLLAND', 'PO BOX ONLY'),
(2242, '06254', '+41.609895', '-072.150305', 'NORTH FRANKLIN', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2243, '06255', '+41.978392', '-071.899716', 'NORTH GROSVENORDALE', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2244, '06256', '+41.778469', '-072.040003', 'NORTH WINDHAM', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2245, '06258', '+41.889048', '-071.968232', 'POMFRET', 'CT', 'CONNECTICUT', 'WINDHAM', 'PO BOX ONLY'),
(2246, '06259', '+41.863133', '-072.002590', 'POMFRET CENTER', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2247, '06260', '+41.862904', '-071.887712', 'PUTNAM', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2248, '06262', '+42.021536', '-071.947077', 'QUINEBAUG', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2249, '06263', '+41.839051', '-071.906340', 'ROGERS', 'CT', 'CONNECTICUT', 'WINDHAM', 'PO BOX ONLY'),
(2250, '06264', '+41.695803', '-072.087045', 'SCOTLAND', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2251, '06265', '+41.811520', '-072.308779', 'SOUTH WILLINGTON', 'CT', 'CONNECTICUT', 'TOLLAND', 'PO BOX ONLY'),
(2252, '06266', '+41.674079', '-072.172298', 'SOUTH WINDHAM', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2253, '06267', '+41.943902', '-071.945253', 'SOUTH WOODSTOCK', 'CT', 'CONNECTICUT', 'WINDHAM', 'PO BOX ONLY'),
(2254, '06268', '+41.787937', '-072.252480', 'STORRS MANSFIELD', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2255, '06269', '+41.808007', '-072.250963', 'STORRS MANSFIELD', 'CT', 'CONNECTICUT', 'TOLLAND', 'UNIQUE'),
(2256, '06277', '+41.975796', '-071.862047', 'THOMPSON', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2257, '06278', '+41.889043', '-072.147561', 'ASHFORD', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2258, '06279', '+41.896623', '-072.262236', 'WILLINGTON', 'CT', 'CONNECTICUT', 'TOLLAND', 'STANDARD'),
(2259, '06280', '+41.693914', '-072.137843', 'WINDHAM', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2260, '06281', '+41.961991', '-072.014108', 'WOODSTOCK', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2261, '06282', '+41.952846', '-072.057134', 'WOODSTOCK VALLEY', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2262, '06320', '+41.413998', '-072.109070', 'NEW LONDON', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2263, '06330', '+41.501708', '-072.044306', 'BALTIC', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2264, '06331', '+41.696753', '-071.998277', 'CANTERBURY', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2265, '06332', '+41.725694', '-071.909019', 'CENTRAL VILLAGE', 'CT', 'CONNECTICUT', 'WINDHAM', 'PO BOX ONLY'),
(2266, '06333', '+41.378842', '-072.236794', 'EAST LYME', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2267, '06334', '+41.544598', '-072.177023', 'BOZRAH', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2268, '06335', '+41.523377', '-072.021165', 'GALES FERRY', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2269, '06336', '+41.579548', '-072.196273', 'GILMAN', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2270, '06337', '+41.559873', '-071.889199', 'GLASGO', 'CT', 'CONNECTICUT', 'NEW LONDON', 'PO BOX ONLY'),
(2271, '06339', '+41.492843', '-071.965554', 'LEDYARD', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2272, '06340', '+41.355405', '-072.038268', 'GROTON', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2273, '06349', '+41.399730', '-072.090357', 'GROTON', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2274, '06350', '+41.644546', '-072.067690', 'HANOVER', 'CT', 'CONNECTICUT', 'NEW LONDON', 'PO BOX ONLY'),
(2275, '06351', '+41.599562', '-071.982619', 'JEWETT CITY', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2276, '06353', '+41.452548', '-072.137471', 'MONTVILLE', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2277, '06354', '+41.704931', '-071.849772', 'MOOSUP', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2278, '06355', '+41.485188', '-072.000748', 'MYSTIC', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2279, '06357', '+41.323447', '-072.215623', 'NIANTIC', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2280, '06359', '+41.466851', '-071.880694', 'NORTH STONINGTON', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2281, '06360', '+41.499398', '-071.994757', 'NORWICH', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2282, '06365', '+41.522369', '-071.993427', 'PRESTON', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2283, '06370', '+41.512172', '-072.102302', 'OAKDALE', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2284, '06371', '+41.409397', '-072.147665', 'OLD LYME', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2285, '06372', '+41.388216', '-071.949548', 'OLD MYSTIC', 'CT', 'CONNECTICUT', 'NEW LONDON', 'PO BOX ONLY'),
(2286, '06373', '+41.678546', '-071.817759', 'ONECO', 'CT', 'CONNECTICUT', 'WINDHAM', 'PO BOX ONLY'),
(2287, '06374', '+41.688121', '-071.884113', 'PLAINFIELD', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2288, '06375', '+41.401066', '-072.140022', 'QUAKER HILL', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2289, '06376', '+41.296668', '-072.263296', 'SOUTH LYME', 'CT', 'CONNECTICUT', 'NEW LONDON', 'PO BOX ONLY'),
(2290, '06377', '+41.719948', '-071.823184', 'STERLING', 'CT', 'CONNECTICUT', 'WINDHAM', 'STANDARD'),
(2291, '06378', '+41.378598', '-071.917915', 'STONINGTON', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2292, '06379', '+41.455191', '-071.895547', 'PAWCATUCK', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2293, '06380', '+41.563998', '-072.055220', 'TAFTVILLE', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2294, '06382', '+41.424507', '-072.069578', 'UNCASVILLE', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2295, '06383', '+41.601648', '-072.040370', 'VERSAILLES', 'CT', 'CONNECTICUT', 'NEW LONDON', 'PO BOX ONLY'),
(2296, '06384', '+41.576894', '-071.866587', 'VOLUNTOWN', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2297, '06385', '+41.456698', '-072.126498', 'WATERFORD', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2298, '06386', '+41.464758', '-072.127301', 'WATERFORD', 'CT', 'CONNECTICUT', 'NEW LONDON', 'UNIQUE'),
(2299, '06387', '+41.744527', '-071.913339', 'WAUREGAN', 'CT', 'CONNECTICUT', 'WINDHAM', 'PO BOX ONLY'),
(2300, '06388', '+41.344098', '-071.976467', 'WEST MYSTIC', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2301, '06389', '+41.559648', '-072.122672', 'YANTIC', 'CT', 'CONNECTICUT', 'NEW LONDON', 'PO BOX ONLY'),
(2302, '06390', '+40.992288', '-072.723496', 'FISHERS ISLAND', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(2303, '06401', '+41.342514', '-073.070301', 'ANSONIA', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2304, '06403', '+41.435134', '-073.058835', 'BEACON FALLS', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2305, '06404', '+41.165097', '-073.129186', 'BOTSFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'PO BOX ONLY'),
(2306, '06405', '+41.284746', '-072.796292', 'BRANFORD', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2307, '06408', '+41.365709', '-072.927507', 'CHESHIRE', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'UNIQUE'),
(2308, '06409', '+41.349098', '-072.413380', 'CENTERBROOK', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2309, '06410', '+41.460167', '-072.972220', 'CHESHIRE', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2310, '06411', '+41.550097', '-072.922235', 'CHESHIRE', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'UNIQUE'),
(2311, '06412', '+41.390270', '-072.461805', 'CHESTER', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2312, '06413', '+41.298201', '-072.532934', 'CLINTON', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2313, '06414', '+41.566668', '-072.558055', 'COBALT', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'PO BOX ONLY'),
(2314, '06415', '+41.546443', '-072.338832', 'COLCHESTER', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2315, '06416', '+41.608529', '-072.667807', 'CROMWELL', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2316, '06417', '+41.368124', '-072.452284', 'DEEP RIVER', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2317, '06418', '+41.327246', '-073.084252', 'DERBY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2318, '06419', '+41.417962', '-072.493446', 'KILLINGWORTH', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2319, '06420', '+41.527441', '-072.269141', 'SALEM', 'CT', 'CONNECTICUT', 'NEW LONDON', 'STANDARD'),
(2320, '06422', '+41.462468', '-072.682297', 'DURHAM', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2321, '06423', '+41.475478', '-072.389729', 'EAST HADDAM', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2322, '06424', '+41.559841', '-072.494927', 'EAST HAMPTON', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2323, '06426', '+41.448179', '-072.504260', 'ESSEX', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2324, '06430', '+41.175173', '-073.282408', 'FAIRFIELD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2325, '06431', '+41.219093', '-073.252696', 'FAIRFIELD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2326, '06432', '+41.196046', '-073.252802', 'FAIRFIELD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2327, '06436', '+41.308873', '-073.363661', 'GREENS FARMS', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'PO BOX ONLY'),
(2328, '06437', '+41.338847', '-072.690089', 'GUILFORD', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2329, '06438', '+41.471457', '-072.511376', 'HADDAM', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2330, '06439', '+41.421198', '-072.414095', 'HADLYME', 'CT', 'CONNECTICUT', 'NEW LONDON', 'PO BOX ONLY'),
(2331, '06440', '+41.308873', '-073.363661', 'HAWLEYVILLE', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'PO BOX ONLY'),
(2332, '06441', '+41.462718', '-072.578971', 'HIGGANUM', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2333, '06442', '+41.344076', '-072.444369', 'IVORYTON', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2334, '06443', '+41.350397', '-072.788392', 'MADISON', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2335, '06444', '+41.791776', '-072.718832', 'MARION', 'CT', 'CONNECTICUT', 'HARTFORD', 'PO BOX ONLY'),
(2336, '06447', '+41.636949', '-072.463179', 'MARLBOROUGH', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2337, '06450', '+41.536498', '-072.801901', 'MERIDEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2338, '06451', '+41.540110', '-072.818880', 'MERIDEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2339, '06454', '+41.365709', '-072.927507', 'MERIDEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'UNIQUE'),
(2340, '06455', '+41.515346', '-072.712988', 'MIDDLEFIELD', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2341, '06456', '+41.538017', '-072.525208', 'MIDDLE HADDAM', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'PO BOX ONLY'),
(2342, '06457', '+41.550139', '-072.655357', 'MIDDLETOWN', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2343, '06459', '+41.556463', '-072.658179', 'MIDDLETOWN', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'UNIQUE'),
(2344, '06460', '+41.343773', '-072.951273', 'MILFORD', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2345, '06467', '+41.565697', '-072.903746', 'MILLDALE', 'CT', 'CONNECTICUT', 'HARTFORD', 'PO BOX ONLY'),
(2346, '06468', '+41.341845', '-073.236918', 'MONROE', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2347, '06469', '+41.508904', '-072.440086', 'MOODUS', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2348, '06470', '+41.396295', '-073.310561', 'NEWTOWN', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2349, '06471', '+41.332347', '-072.780892', 'NORTH BRANFORD', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2350, '06472', '+41.379797', '-072.772991', 'NORTHFORD', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2351, '06473', '+41.384381', '-072.862644', 'NORTH HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2352, '06474', '+41.464758', '-072.127301', 'NORTH WESTCHESTER', 'CT', 'CONNECTICUT', 'NEW LONDON', 'PO BOX ONLY'),
(2353, '06475', '+41.300448', '-072.389129', 'OLD SAYBROOK', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2354, '06477', '+41.279896', '-073.031018', 'ORANGE', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2355, '06478', '+41.432583', '-073.138379', 'OXFORD', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2356, '06479', '+41.577845', '-072.902496', 'PLANTSVILLE', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2357, '06480', '+41.598339', '-072.601307', 'PORTLAND', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2358, '06481', '+41.542105', '-072.666583', 'ROCKFALL', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2359, '06482', '+41.408137', '-073.249671', 'SANDY HOOK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2360, '06483', '+41.417646', '-073.102078', 'SEYMOUR', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2361, '06484', '+41.314347', '-073.137143', 'SHELTON', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2362, '06487', '+41.365709', '-072.927507', 'SOUTH BRITAIN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'PO BOX ONLY'),
(2363, '06488', '+41.470921', '-073.240839', 'SOUTHBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2364, '06489', '+41.604786', '-072.871945', 'SOUTHINGTON', 'CT', 'CONNECTICUT', 'HARTFORD', 'STANDARD'),
(2365, '06490', '+41.143396', '-073.289859', 'SOUTHPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2366, '06491', '+41.386646', '-073.187207', 'STEVENSON', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'PO BOX ONLY'),
(2367, '06492', '+41.456205', '-072.811047', 'WALLINGFORD', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2368, '06493', '+41.365709', '-072.927507', 'WALLINGFORD', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'UNIQUE'),
(2369, '06494', '+41.365709', '-072.927507', 'WALLINGFORD', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'UNIQUE'),
(2370, '06495', '+41.365709', '-072.927507', 'WALLINGFORD', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'UNIQUE'),
(2371, '06497', '+41.207146', '-073.130503', 'STRATFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2372, '06498', '+41.307899', '-072.463381', 'WESTBROOK', 'CT', 'CONNECTICUT', 'MIDDLESEX', 'STANDARD'),
(2373, '06501', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2374, '06502', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2375, '06503', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2376, '06504', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2377, '06505', '+41.305721', '-072.779901', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2378, '06506', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2379, '06507', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2380, '06508', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2381, '06509', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2382, '06510', '+41.309797', '-072.922296', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2383, '06511', '+41.310547', '-072.926046', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2384, '06512', '+41.290997', '-072.865894', 'EAST HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2385, '06513', '+41.307197', '-072.865365', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2386, '06514', '+41.372723', '-072.938747', 'HAMDEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2387, '06515', '+41.328697', '-072.964247', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2388, '06516', '+41.272452', '-072.940335', 'WEST HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2389, '06517', '+41.362197', '-072.911396', 'HAMDEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2390, '06518', '+41.416747', '-072.906096', 'HAMDEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2391, '06519', '+41.296897', '-072.938596', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2392, '06520', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2393, '06521', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2394, '06524', '+41.428088', '-072.996191', 'BETHANY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2395, '06525', '+41.353296', '-073.013981', 'WOODBRIDGE', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2396, '06530', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2397, '06531', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2398, '06532', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2399, '06533', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2400, '06534', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2401, '06535', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2402, '06536', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2403, '06537', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'UNIQUE'),
(2404, '06538', '+41.365709', '-072.927507', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'UNIQUE'),
(2405, '06540', '+41.299647', '-072.918846', 'NEW HAVEN', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'UNIQUE'),
(2406, '06601', '+41.308873', '-073.363661', 'BRIDGEPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2407, '06602', '+41.179846', '-073.189006', 'BRIDGEPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2408, '06604', '+41.192746', '-073.213907', 'BRIDGEPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2409, '06605', '+41.162573', '-073.216557', 'BRIDGEPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2410, '06606', '+41.208796', '-073.211807', 'BRIDGEPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2411, '06607', '+41.181596', '-073.165604', 'BRIDGEPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2412, '06608', '+41.188199', '-073.180005', 'BRIDGEPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2413, '06610', '+41.219847', '-073.163955', 'BRIDGEPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2414, '06611', '+41.259996', '-073.206957', 'TRUMBULL', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2415, '06612', '+41.273016', '-073.297721', 'EASTON', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2416, '06614', '+41.216006', '-073.130353', 'STRATFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2417, '06615', '+41.177046', '-073.133574', 'STRATFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2418, '06650', '+41.308873', '-073.363661', 'BRIDGEPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2419, '06673', '+41.308873', '-073.363661', 'BRIDGEPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2420, '06699', '+41.308873', '-073.363661', 'BRIDGEPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2421, '06701', '+41.365709', '-072.927507', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'UNIQUE'),
(2422, '06702', '+41.540696', '-073.071124', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2423, '06703', '+41.365709', '-072.927507', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2424, '06704', '+41.581797', '-073.034451', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2425, '06705', '+41.552893', '-072.992749', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2426, '06706', '+41.535346', '-073.026951', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2427, '06708', '+41.551496', '-073.064152', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2428, '06710', '+41.571496', '-073.044035', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2429, '06712', '+41.499097', '-072.975694', 'PROSPECT', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2430, '06716', '+41.598347', '-072.980578', 'WOLCOTT', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2431, '06720', '+41.365709', '-072.927507', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2432, '06721', '+41.365709', '-072.927507', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2433, '06722', '+41.365709', '-072.927507', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2434, '06723', '+41.365709', '-072.927507', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2435, '06724', '+41.365709', '-072.927507', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2436, '06725', '+41.365709', '-072.927507', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2437, '06726', '+41.365709', '-072.927507', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2438, '06749', '+41.365709', '-072.927507', 'WATERBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'UNIQUE'),
(2439, '06750', '+41.714352', '-073.251598', 'BANTAM', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2440, '06751', '+41.640900', '-073.209685', 'BETHLEHEM', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2441, '06752', '+41.520312', '-073.363875', 'BRIDGEWATER', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2442, '06753', '+41.828067', '-073.332345', 'CORNWALL', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'PO BOX ONLY'),
(2443, '06754', '+41.744373', '-073.301922', 'CORNWALL BRIDGE', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2444, '06755', '+41.634686', '-073.472048', 'GAYLORDSVILLE', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2445, '06756', '+41.794278', '-073.239023', 'GOSHEN', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2446, '06757', '+41.774725', '-073.401908', 'KENT', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2447, '06758', '+41.739889', '-073.222981', 'LAKESIDE', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2448, '06759', '+41.791598', '-073.229787', 'LITCHFIELD', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2449, '06762', '+41.528274', '-073.116458', 'MIDDLEBURY', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2450, '06763', '+41.689616', '-073.212587', 'MORRIS', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2451, '06770', '+41.491016', '-073.052965', 'NAUGATUCK', 'CT', 'CONNECTICUT', 'NEW HAVEN', 'STANDARD'),
(2452, '06776', '+41.658619', '-073.366017', 'NEW MILFORD', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2453, '06777', '+41.690297', '-073.310346', 'NEW PRESTON MARBLE DALE', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2454, '06778', '+41.707722', '-073.108997', 'NORTHFIELD', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2455, '06779', '+41.604052', '-073.216887', 'OAKVILLE', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2456, '06781', '+41.669898', '-072.991450', 'PEQUABUCK', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'PO BOX ONLY'),
(2457, '06782', '+41.658730', '-073.044364', 'PLYMOUTH', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2458, '06783', '+41.578971', '-073.298344', 'ROXBURY', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2459, '06784', '+41.525631', '-073.490891', 'SHERMAN', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2460, '06785', '+41.682439', '-073.305256', 'SOUTH KENT', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2461, '06786', '+41.663530', '-073.022449', 'TERRYVILLE', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(2462, '06787', '+41.658721', '-073.098657', 'THOMASTON', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2463, '06790', '+41.874840', '-073.126763', 'TORRINGTON', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2464, '06791', '+41.649639', '-073.176163', 'HARWINTON', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2465, '06793', '+41.718159', '-073.294187', 'WASHINGTON', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2466, '06794', '+41.646347', '-073.316951', 'WASHINGTON DEPOT', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2467, '06795', '+41.759427', '-073.162003', 'WATERTOWN', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2468, '06796', '+41.821529', '-073.350384', 'WEST CORNWALL', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2469, '06798', '+41.733106', '-073.135499', 'WOODBURY', 'CT', 'CONNECTICUT', 'LITCHFIELD', 'STANDARD'),
(2470, '06801', '+41.381244', '-073.399080', 'BETHEL', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2471, '06804', '+41.404799', '-073.275562', 'BROOKFIELD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2472, '06807', '+41.058646', '-073.587618', 'COS COB', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2473, '06810', '+41.376242', '-073.471416', 'DANBURY', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2474, '06811', '+41.423330', '-073.478717', 'DANBURY', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2475, '06812', '+41.486689', '-073.491042', 'NEW FAIRFIELD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2476, '06813', '+41.308873', '-073.363661', 'DANBURY', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2477, '06814', '+41.308873', '-073.363661', 'DANBURY', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2478, '06816', '+41.308873', '-073.363661', 'DANBURY', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2479, '06817', '+41.308873', '-073.363661', 'DANBURY', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2480, '06820', '+41.075846', '-073.480765', 'DARIEN', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2481, '06829', '+41.255530', '-073.427915', 'GEORGETOWN', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'PO BOX ONLY'),
(2482, '06830', '+41.042746', '-073.626170', 'GREENWICH', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2483, '06831', '+41.079983', '-073.654472', 'GREENWICH', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2484, '06832', '+41.308873', '-073.363661', 'GREENWICH', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2485, '06836', '+41.308873', '-073.363661', 'GREENWICH', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2486, '06840', '+41.162209', '-073.501267', 'NEW CANAAN', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2487, '06842', '+41.147096', '-073.495366', 'NEW CANAAN', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2488, '06850', '+41.126146', '-073.442423', 'NORWALK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2489, '06851', '+41.139796', '-073.404963', 'NORWALK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2490, '06852', '+41.308873', '-073.363661', 'NORWALK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2491, '06853', '+41.070396', '-073.437563', 'NORWALK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2492, '06854', '+41.090946', '-073.432313', 'NORWALK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2493, '06855', '+41.099196', '-073.398362', 'NORWALK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2494, '06856', '+41.111196', '-073.420363', 'NORWALK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2495, '06857', '+41.308873', '-073.363661', 'NORWALK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2496, '06858', '+41.110496', '-073.416213', 'NORWALK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2497, '06859', '+41.308873', '-073.363661', 'NORWALK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2498, '06860', '+41.308873', '-073.363661', 'NORWALK', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2499, '06870', '+41.034946', '-073.566968', 'OLD GREENWICH', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2500, '06875', '+41.308873', '-073.363661', 'REDDING CENTER', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'PO BOX ONLY'),
(2501, '06876', '+41.032647', '-073.583569', 'REDDING RIDGE', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'PO BOX ONLY'),
(2502, '06877', '+41.308201', '-073.494637', 'RIDGEFIELD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2503, '06878', '+41.035596', '-073.580241', 'RIVERSIDE', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2504, '06879', '+41.308873', '-073.363661', 'RIDGEFIELD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2505, '06880', '+41.144496', '-073.343261', 'WESTPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2506, '06881', '+41.308873', '-073.363661', 'WESTPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2507, '06883', '+41.222945', '-073.376263', 'WESTON', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2508, '06888', '+41.308873', '-073.363661', 'WESTPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2509, '06889', '+41.141005', '-073.346890', 'WESTPORT', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2510, '06896', '+41.271095', '-073.386340', 'REDDING', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2511, '06897', '+41.209695', '-073.439165', 'WILTON', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2512, '06901', '+41.054082', '-073.536216', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2513, '06902', '+41.060196', '-073.544477', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2514, '06903', '+41.136773', '-073.565919', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2515, '06904', '+41.308873', '-073.363661', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2516, '06905', '+41.116751', '-073.552752', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2517, '06906', '+41.071246', '-073.521416', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2518, '06907', '+41.088346', '-073.537217', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2519, '06910', '+41.039147', '-073.559118', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2520, '06911', '+41.308873', '-073.363661', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2521, '06912', '+41.308873', '-073.363661', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'STANDARD'),
(2522, '06913', '+41.308873', '-073.363661', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2523, '06914', '+41.308873', '-073.363661', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2524, '06920', '+41.308873', '-073.363661', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2525, '06921', '+41.049866', '-073.537960', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2526, '06922', '+41.051551', '-073.514344', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2527, '06925', '+41.308873', '-073.363661', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2528, '06926', '+41.041197', '-073.538567', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2529, '06927', '+41.308873', '-073.363661', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2530, '06928', '+41.308873', '-073.363661', 'STAMFORD', 'CT', 'CONNECTICUT', 'FAIRFIELD', 'UNIQUE'),
(2531, '07001', '+40.582845', '-074.275240', 'AVENEL', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(2532, '07002', '+40.670858', '-074.109486', 'BAYONNE', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2533, '07003', '+40.808549', '-074.187005', 'BLOOMFIELD', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2534, '07004', '+40.875948', '-074.296810', 'FAIRFIELD', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2535, '07005', '+40.918648', '-074.430696', 'BOONTON', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2536, '07006', '+40.854548', '-074.278892', 'CALDWELL', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2537, '07007', '+40.791850', '-074.245241', 'CALDWELL', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2538, '07008', '+40.583203', '-074.234839', 'CARTERET', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(2539, '07009', '+40.857049', '-074.227109', 'CEDAR GROVE', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2540, '07010', '+40.820541', '-073.987820', 'CLIFFSIDE PARK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2541, '07011', '+40.877949', '-074.141237', 'CLIFTON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2542, '07012', '+40.847699', '-074.160538', 'CLIFTON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2543, '07013', '+40.872898', '-074.170138', 'CLIFTON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2544, '07014', '+40.832449', '-074.136937', 'CLIFTON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2545, '07015', '+41.011428', '-074.304793', 'CLIFTON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2546, '07016', '+40.654802', '-074.304792', 'CRANFORD', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2547, '07017', '+40.771850', '-074.207039', 'EAST ORANGE', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2548, '07018', '+40.756600', '-074.216839', 'EAST ORANGE', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2549, '07019', '+40.791850', '-074.245241', 'EAST ORANGE', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2550, '07020', '+40.826550', '-073.978082', 'EDGEWATER', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2551, '07021', '+40.826158', '-074.276591', 'ESSEX FELLS', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2552, '07022', '+40.817537', '-074.000883', 'FAIRVIEW', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2553, '07023', '+40.641902', '-074.387044', 'FANWOOD', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2554, '07024', '+40.848745', '-073.974032', 'FORT LEE', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2555, '07026', '+40.884648', '-074.110336', 'GARFIELD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2556, '07027', '+40.651242', '-074.322892', 'GARWOOD', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2557, '07028', '+40.807499', '-074.205039', 'GLEN RIDGE', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2558, '07029', '+40.744501', '-074.150787', 'HARRISON', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2559, '07030', '+40.746851', '-074.033934', 'HOBOKEN', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2560, '07031', '+40.787112', '-074.127316', 'NORTH ARLINGTON', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2561, '07032', '+40.751750', '-074.122937', 'KEARNY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2562, '07033', '+40.677601', '-074.291191', 'KENILWORTH', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2563, '07034', '+40.880649', '-074.379745', 'LAKE HIAWATHA', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2564, '07035', '+40.926637', '-074.303093', 'LINCOLN PARK', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2565, '07036', '+40.626953', '-074.250939', 'LINDEN', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2566, '07039', '+40.787006', '-074.325993', 'LIVINGSTON', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2567, '07040', '+40.729100', '-074.266541', 'MAPLEWOOD', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2568, '07041', '+40.733650', '-074.301692', 'MILLBURN', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2569, '07042', '+40.811908', '-074.216389', 'MONTCLAIR', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2570, '07043', '+40.803400', '-074.194480', 'MONTCLAIR', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2571, '07044', '+40.832849', '-074.243895', 'VERONA', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2572, '07045', '+40.906311', '-074.363231', 'MONTVILLE', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2573, '07046', '+40.890502', '-074.440898', 'MOUNTAIN LAKES', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2574, '07047', '+40.789724', '-074.023234', 'NORTH BERGEN', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2575, '07050', '+40.770400', '-074.236740', 'ORANGE', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2576, '07051', '+40.791850', '-074.245241', 'ORANGE', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2577, '07052', '+40.789944', '-074.227190', 'WEST ORANGE', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2578, '07054', '+40.852118', '-074.407706', 'PARSIPPANY', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2579, '07055', '+40.855103', '-074.126916', 'PASSAIC', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2580, '07057', '+40.852799', '-074.107325', 'WALLINGTON', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2581, '07058', '+40.871014', '-074.340144', 'PINE BROOK', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2582, '07059', '+40.629101', '-074.532449', 'WARREN', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(2583, '07060', '+40.615202', '-074.414995', 'PLAINFIELD', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2584, '07061', '+40.665651', '-074.299692', 'PLAINFIELD', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2585, '07062', '+40.632252', '-074.399736', 'PLAINFIELD', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2586, '07063', '+40.604752', '-074.442746', 'PLAINFIELD', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2587, '07064', '+40.570254', '-074.249739', 'PORT READING', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(2588, '07065', '+40.609553', '-074.280641', 'RAHWAY', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2589, '07066', '+40.622502', '-074.311092', 'CLARK', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2590, '07067', '+40.590853', '-074.314688', 'COLONIA', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(2591, '07068', '+40.820499', '-074.306093', 'ROSELAND', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2592, '07069', '', '', 'WATCHUNG', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(2593, '07070', '+40.827449', '-074.109786', 'RUTHERFORD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2594, '07071', '+40.799549', '-074.116517', 'LYNDHURST', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2595, '07072', '+40.828399', '-074.076055', 'CARLSTADT', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2596, '07073', '+40.828399', '-074.093886', 'EAST RUTHERFORD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2597, '07074', '+40.839299', '-074.060184', 'MOONACHIE', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2598, '07075', '+40.848599', '-074.089585', 'WOOD RIDGE', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2599, '07076', '+40.637852', '-074.368244', 'SCOTCH PLAINS', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2600, '07077', '+40.551804', '-074.259139', 'SEWAREN', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(2601, '07078', '+40.740550', '-074.334443', 'SHORT HILLS', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2602, '07079', '+40.745772', '-074.267541', 'SOUTH ORANGE', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2603, '07080', '+40.572065', '-074.413545', 'SOUTH PLAINFIELD', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(2604, '07081', '+40.701101', '-074.316301', 'SPRINGFIELD', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2605, '07082', '+40.927690', '-074.347695', 'TOWACO', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2606, '07083', '+40.692651', '-074.269841', 'UNION', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2607, '07086', '', '', 'WEEHAWKEN', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2608, '07087', '+40.758951', '-074.056335', 'UNION CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2609, '07088', '+40.717890', '-074.284341', 'VAUXHALL', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2610, '07090', '+40.652851', '-074.346764', 'WESTFIELD', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2611, '07091', '+40.665651', '-074.299692', 'WESTFIELD', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2612, '07092', '+40.680701', '-074.358394', 'MOUNTAINSIDE', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2613, '07093', '+40.788800', '-074.011533', 'WEST NEW YORK', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2614, '07094', '+40.788850', '-074.056035', 'SECAUCUS', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2615, '07095', '+40.553254', '-074.288023', 'WOODBRIDGE', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(2616, '07096', '+40.732760', '-074.075485', 'SECAUCUS', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2617, '07097', '+40.732760', '-074.075485', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'UNIQUE'),
(2618, '07099', '+40.732760', '-074.075485', 'KEARNY', 'NJ', 'NEW JERSEY', 'HUDSON', 'UNIQUE'),
(2619, '07101', '+40.736101', '-074.225090', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2620, '07102', '+40.735642', '-074.173988', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2621, '07103', '+40.738901', '-074.194839', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2622, '07104', '+40.764350', '-074.151788', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2623, '07105', '+40.723606', '-074.147337', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2624, '07106', '+40.742450', '-074.231140', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2625, '07107', '+40.764600', '-074.188029', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2626, '07108', '+40.722496', '-074.200649', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2627, '07109', '+40.782100', '-074.167488', 'BELLEVILLE', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2628, '07110', '+40.821299', '-074.159449', 'NUTLEY', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2629, '07111', '+40.726231', '-074.232940', 'IRVINGTON', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2630, '07112', '+40.711151', '-074.211265', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2631, '07114', '+40.705401', '-074.169538', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'STANDARD'),
(2632, '07175', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2633, '07182', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2634, '07184', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2635, '07188', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2636, '07189', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2637, '07191', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2638, '07192', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2639, '07193', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2640, '07194', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2641, '07195', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2642, '07197', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2643, '07198', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2644, '07199', '+40.791850', '-074.245241', 'NEWARK', 'NJ', 'NEW JERSEY', 'ESSEX', 'UNIQUE'),
(2645, '07201', '+40.672052', '-074.183438', 'ELIZABETH', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2646, '07202', '+40.650902', '-074.217189', 'ELIZABETH', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2647, '07203', '+40.650152', '-074.258790', 'ROSELLE', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2648, '07204', '+40.665652', '-074.266740', 'ROSELLE PARK', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2649, '07205', '+40.693823', '-074.229889', 'HILLSIDE', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2650, '07206', '+40.652152', '-074.191814', 'ELIZABETH', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2651, '07207', '+40.665651', '-074.299692', 'ELIZABETH', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2652, '07208', '+40.677102', '-074.229289', 'ELIZABETH', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2653, '07302', '+40.726001', '-074.047304', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2654, '07303', '+40.732760', '-074.075485', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2655, '07304', '+40.716101', '-074.065535', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2656, '07305', '+40.696661', '-074.081135', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2657, '07306', '+40.734951', '-074.068685', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2658, '07307', '+40.749801', '-074.054285', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2659, '07308', '+40.732760', '-074.075485', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2660, '07309', '+40.732760', '-074.075485', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2661, '07310', '+40.732728', '-074.037168', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2662, '07311', '+40.732350', '-074.075391', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'STANDARD'),
(2663, '07399', '+40.732350', '-074.075391', 'JERSEY CITY', 'NJ', 'NEW JERSEY', 'HUDSON', 'UNIQUE'),
(2664, '07401', '+41.017446', '-074.062774', 'ALLENDALE', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2665, '07403', '+41.023414', '-074.334444', 'BLOOMINGDALE', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2666, '07405', '+40.998797', '-074.426148', 'BUTLER', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2667, '07407', '+40.905848', '-074.117736', 'ELMWOOD PARK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2668, '07410', '+40.935348', '-074.119236', 'FAIR LAWN', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2669, '07416', '+41.115723', '-074.593439', 'FRANKLIN', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2670, '07417', '+41.010464', '-074.208310', 'FRANKLIN LAKES', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2671, '07418', '+41.228102', '-074.477351', 'GLENWOOD', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2672, '07419', '+41.159187', '-074.576880', 'HAMBURG', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2673, '07420', '+41.028396', '-074.304516', 'HASKELL', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2674, '07421', '+41.151395', '-074.357893', 'HEWITT', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2675, '07422', '+41.187468', '-074.458935', 'HIGHLAND LAKES', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2676, '07423', '+40.998882', '-074.096848', 'HO HO KUS', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2677, '07424', '+40.883548', '-074.214388', 'LITTLE FALLS', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2678, '07428', '+41.206509', '-074.538144', 'MC AFEE', 'NJ', 'NEW JERSEY', 'SUSSEX', 'PO BOX ONLY'),
(2679, '07430', '+41.053446', '-074.172766', 'MAHWAH', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2680, '07432', '+40.994697', '-074.142287', 'MIDLAND PARK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2681, '07435', '+41.053096', '-074.439356', 'NEWFOUNDLAND', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2682, '07436', '+41.023402', '-074.238623', 'OAKLAND', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2683, '07438', '+41.099796', '-074.443399', 'OAK RIDGE', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2684, '07439', '+41.078346', '-074.594104', 'OGDENSBURG', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2685, '07440', '+40.948208', '-074.295592', 'PEQUANNOCK', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2686, '07442', '+40.999597', '-074.297725', 'POMPTON LAKES', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2687, '07444', '+41.008797', '-074.402663', 'POMPTON PLAINS', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2688, '07446', '+41.059124', '-074.133441', 'RAMSEY', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2689, '07450', '+40.982247', '-074.112070', 'RIDGEWOOD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2690, '07451', '+40.948054', '-074.083231', 'RIDGEWOOD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2691, '07452', '+40.960347', '-074.125036', 'GLEN ROCK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2692, '07456', '+41.110445', '-074.293271', 'RINGWOOD', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2693, '07457', '+40.992647', '-074.312443', 'RIVERDALE', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2694, '07458', '+41.044324', '-074.098093', 'SADDLE RIVER', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2695, '07460', '+41.138101', '-074.561915', 'STOCKHOLM', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2696, '07461', '+41.242702', '-074.596734', 'SUSSEX', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2697, '07462', '+41.189046', '-074.514340', 'VERNON', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2698, '07463', '+41.041225', '-074.128326', 'WALDWICK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2699, '07465', '+41.065596', '-074.297393', 'WANAQUE', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2700, '07470', '+40.948689', '-074.241168', 'WAYNE', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2701, '07474', '+41.011428', '-074.304793', 'WAYNE', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2702, '07477', '+41.011428', '-074.304793', 'WAYNE', 'NJ', 'NEW JERSEY', 'PASSAIC', 'UNIQUE'),
(2703, '07480', '+41.047296', '-074.294243', 'WEST MILFORD', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2704, '07481', '+40.998387', '-074.165733', 'WYCKOFF', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2705, '07495', '+40.948054', '-074.083231', 'MAHWAH', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2706, '07498', '+40.948054', '-074.083231', 'MAHWAH', 'NJ', 'NEW JERSEY', 'BERGEN', 'UNIQUE'),
(2707, '07501', '+40.915045', '-074.174488', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2708, '07502', '+40.918698', '-074.194989', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2709, '07503', '+40.898098', '-074.151837', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2710, '07504', '+40.911248', '-074.144087', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2711, '07505', '+40.916648', '-074.174038', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2712, '07506', '+40.954375', '-074.161788', 'HAWTHORNE', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2713, '07507', '+41.011428', '-074.304793', 'HAWTHORNE', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2714, '07508', '+40.951587', '-074.186269', 'HALEDON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2715, '07509', '+41.011428', '-074.304793', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2716, '07510', '+41.011428', '-074.304793', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2717, '07511', '+41.011428', '-074.304793', 'TOTOWA', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2718, '07512', '+40.901698', '-074.221990', 'TOTOWA', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2719, '07513', '+40.907698', '-074.146515', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2720, '07514', '+40.928748', '-074.143187', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2721, '07522', '+40.923798', '-074.179488', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2722, '07524', '+40.932498', '-074.156971', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2723, '07533', '+41.011428', '-074.304793', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2724, '07538', '+41.011428', '-074.304793', 'HALEDON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2725, '07543', '+41.011428', '-074.304793', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2726, '07544', '+41.011428', '-074.304793', 'PATERSON', 'NJ', 'NEW JERSEY', 'PASSAIC', 'STANDARD'),
(2727, '07601', '+40.913482', '-074.001623', 'HACKENSACK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2728, '07602', '+40.948054', '-074.083231', 'HACKENSACK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2729, '07603', '+40.874773', '-074.030484', 'BOGOTA', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2730, '07604', '+40.862349', '-074.075585', 'HASBROUCK HEIGHTS', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2731, '07605', '+40.863499', '-073.987132', 'LEONIA', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2732, '07606', '+40.857899', '-074.048884', 'SOUTH HACKENSACK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2733, '07607', '+40.901810', '-074.061784', 'MAYWOOD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2734, '07608', '+40.863954', '-074.055584', 'TETERBORO', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2735, '07620', '+40.958975', '-073.927906', 'ALPINE', 'NJ', 'NEW JERSEY', 'BERGEN', 'PO BOX ONLY'),
(2736, '07621', '+40.923498', '-073.998332', 'BERGENFIELD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2737, '07624', '+40.970621', '-073.960164', 'CLOSTER', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2738, '07626', '+40.972898', '-074.098841', 'CRESSKILL', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2739, '07627', '+40.954198', '-073.957623', 'DEMAREST', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2740, '07628', '+40.955018', '-073.989911', 'DUMONT', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2741, '07630', '+40.973199', '-074.021118', 'EMERSON', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2742, '07631', '+40.889498', '-073.971782', 'ENGLEWOOD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2743, '07632', '+40.883949', '-073.952423', 'ENGLEWOOD CLIFFS', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2744, '07640', '+40.991696', '-073.984860', 'HARRINGTON PARK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2745, '07641', '+40.963867', '-073.993580', 'HAWORTH', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2746, '07642', '+41.008367', '-074.048576', 'HILLSDALE', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2747, '07643', '+40.925361', '-074.076029', 'LITTLE FERRY', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2748, '07644', '+40.878349', '-074.081335', 'LODI', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2749, '07645', '+41.054651', '-074.045425', 'MONTVALE', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2750, '07646', '+40.932998', '-074.017633', 'NEW MILFORD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2751, '07647', '+41.008636', '-073.938930', 'NORTHVALE', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2752, '07648', '+40.992921', '-073.949747', 'NORWOOD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2753, '07649', '+40.955347', '-074.026983', 'ORADELL', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2754, '07650', '+40.939673', '-074.010792', 'PALISADES PARK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2755, '07652', '+40.944997', '-074.068964', 'PARAMUS', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2756, '07653', '+40.948054', '-074.083231', 'PARAMUS', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2757, '07656', '+41.032868', '-074.042948', 'PARK RIDGE', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2758, '07657', '+40.833150', '-074.004233', 'RIDGEFIELD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2759, '07660', '+40.853449', '-074.021233', 'RIDGEFIELD PARK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2760, '07661', '+40.926248', '-074.038533', 'RIVER EDGE', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2761, '07662', '+40.905698', '-074.079035', 'ROCHELLE PARK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2762, '07663', '+40.942101', '-074.094685', 'SADDLE BROOK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2763, '07666', '+40.914616', '-073.986334', 'TEANECK', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2764, '07670', '+40.919298', '-073.960481', 'TENAFLY', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2765, '07675', '+41.011453', '-074.021278', 'WESTWOOD', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2766, '07676', '', '', 'TOWNSHIP OF WASHINGTON', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2767, '07677', '', '', 'WOODCLIFF LAKE', 'NJ', 'NEW JERSEY', 'BERGEN', 'STANDARD'),
(2768, '07701', '+40.358409', '-074.068143', 'RED BANK', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2769, '07702', '+40.325361', '-074.107943', 'SHREWSBURY', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2770, '07703', '+40.314531', '-074.041654', 'FORT MONMOUTH', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2771, '07704', '+40.358459', '-074.036433', 'FAIR HAVEN', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2772, '07709', '+40.302718', '-074.249280', 'ALLENHURST', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'UNIQUE'),
(2773, '07710', '+40.302718', '-074.249280', 'ADELPHIA', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'PO BOX ONLY'),
(2774, '07711', '+40.237111', '-074.008581', 'ALLENHURST', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2775, '07712', '+40.250725', '-074.048582', 'ASBURY PARK', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2776, '07715', '+40.302718', '-074.249280', 'BELMAR', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'UNIQUE'),
(2777, '07716', '+40.404762', '-074.056170', 'ATLANTIC HIGHLANDS', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2778, '07717', '+40.191913', '-074.015931', 'AVON BY THE SEA', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2779, '07718', '+40.417707', '-074.088534', 'BELFORD', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2780, '07719', '+40.257461', '-074.112134', 'BELMAR', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2781, '07720', '+40.202113', '-074.012581', 'BRADLEY BEACH', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2782, '07721', '+40.386330', '-074.115229', 'CLIFFWOOD', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2783, '07722', '+40.302848', '-074.160911', 'COLTS NECK', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2784, '07723', '+40.250861', '-074.004581', 'DEAL', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2785, '07724', '+40.304660', '-074.073433', 'EATONTOWN', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2786, '07726', '+40.269700', '-074.265539', 'ENGLISHTOWN', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2787, '07727', '+40.285211', '-074.161571', 'FARMINGDALE', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2788, '07728', '+40.236423', '-074.306284', 'FREEHOLD', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2789, '07730', '+40.423057', '-074.176036', 'HAZLET', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2790, '07731', '+40.258361', '-074.196780', 'HOWELL', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2791, '07732', '+40.401078', '-074.000582', 'HIGHLANDS', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2792, '07733', '+40.376408', '-074.170037', 'HOLMDEL', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2793, '07734', '+40.438145', '-074.127883', 'KEANSBURG', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2794, '07735', '+40.438398', '-074.188087', 'KEYPORT', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2795, '07737', '+40.409391', '-074.059884', 'LEONARDO', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2796, '07738', '+40.346629', '-074.125401', 'LINCROFT', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2797, '07739', '+40.382028', '-074.168941', 'LITTLE SILVER', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2798, '07740', '+40.345361', '-074.110900', 'LONG BRANCH', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2799, '07746', '+40.351277', '-074.141236', 'MARLBORO', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2800, '07747', '+40.407507', '-074.233788', 'MATAWAN', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2801, '07748', '+40.400997', '-074.144636', 'MIDDLETOWN', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2802, '07750', '+40.277757', '-074.194702', 'MONMOUTH BEACH', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2803, '07751', '+40.319979', '-074.214488', 'MORGANVILLE', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2804, '07752', '+40.402277', '-074.027285', 'NAVESINK', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'PO BOX ONLY'),
(2805, '07753', '+40.209551', '-074.071351', 'NEPTUNE', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2806, '07754', '+40.302718', '-074.249280', 'NEPTUNE', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2807, '07755', '+40.261158', '-074.021382', 'OAKHURST', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2808, '07756', '+40.278922', '-074.123285', 'OCEAN GROVE', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2809, '07757', '+40.314960', '-074.019032', 'OCEANPORT', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2810, '07758', '+40.429731', '-074.106535', 'PORT MONMOUTH', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2811, '07760', '+40.370684', '-074.008432', 'RUMSON', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2812, '07762', '+40.176013', '-074.031331', 'SPRING LAKE', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2813, '07763', '+40.302718', '-074.249280', 'TENNENT', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'PO BOX ONLY'),
(2814, '07764', '+40.283511', '-074.018282', 'WEST LONG BRANCH', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2815, '07765', '+40.302718', '-074.249280', 'WICKATUNK', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'PO BOX ONLY'),
(2816, '07777', '+40.302718', '-074.249280', 'HOLMDEL', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'UNIQUE'),
(2817, '07799', '+40.302718', '-074.249280', 'EATONTOWN', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(2818, '07801', '+40.917598', '-074.546651', 'DOVER', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2819, '07802', '+40.867331', '-074.578269', 'DOVER', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2820, '07803', '+40.877099', '-074.584453', 'MINE HILL', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2821, '07806', '+40.867331', '-074.578269', 'PICATINNY ARSENAL', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2822, '07820', '+40.869648', '-074.849661', 'ALLAMUCHY', 'NJ', 'NEW JERSEY', 'WARREN', 'PO BOX ONLY'),
(2823, '07821', '+41.092778', '-074.718969', 'ANDOVER', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2824, '07822', '+41.161241', '-074.617400', 'AUGUSTA', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2825, '07823', '+40.819772', '-075.030961', 'BELVIDERE', 'NJ', 'NEW JERSEY', 'WARREN', 'STANDARD'),
(2826, '07825', '+40.942238', '-074.937487', 'BLAIRSTOWN', 'NJ', 'NEW JERSEY', 'WARREN', 'STANDARD'),
(2827, '07826', '+41.188035', '-074.824675', 'BRANCHVILLE', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2828, '07827', '+41.255279', '-074.644746', 'MONTAGUE', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2829, '07828', '+40.880028', '-074.757560', 'BUDD LAKE', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2830, '07829', '+40.843350', '-074.985914', 'BUTTZVILLE', 'NJ', 'NEW JERSEY', 'WARREN', 'PO BOX ONLY'),
(2831, '07830', '+40.717424', '-074.813951', 'CALIFON', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(2832, '07831', '+40.739382', '-074.944756', 'CHANGEWATER', 'NJ', 'NEW JERSEY', 'WARREN', 'PO BOX ONLY'),
(2833, '07832', '+40.893979', '-075.029163', 'COLUMBIA', 'NJ', 'NEW JERSEY', 'WARREN', 'STANDARD'),
(2834, '07833', '+40.906906', '-075.075377', 'DELAWARE', 'NJ', 'NEW JERSEY', 'WARREN', 'PO BOX ONLY'),
(2835, '07834', '+40.881248', '-074.489349', 'DENVILLE', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2836, '07836', '+40.850884', '-074.701558', 'FLANDERS', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2837, '07837', '+41.128310', '-074.678956', 'GLASSER', 'NJ', 'NEW JERSEY', 'SUSSEX', 'PO BOX ONLY'),
(2838, '07838', '+40.888834', '-074.937714', 'GREAT MEADOWS', 'NJ', 'NEW JERSEY', 'WARREN', 'STANDARD'),
(2839, '07839', '+41.128310', '-074.678956', 'GREENDELL', 'NJ', 'NEW JERSEY', 'SUSSEX', 'PO BOX ONLY'),
(2840, '07840', '+40.868804', '-074.844734', 'HACKETTSTOWN', 'NJ', 'NEW JERSEY', 'WARREN', 'STANDARD'),
(2841, '07842', '+40.867331', '-074.578269', 'HIBERNIA', 'NJ', 'NEW JERSEY', 'MORRIS', 'PO BOX ONLY'),
(2842, '07843', '+40.936753', '-074.659969', 'HOPATCONG', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2843, '07844', '+40.919658', '-074.984628', 'HOPE', 'NJ', 'NEW JERSEY', 'WARREN', 'PO BOX ONLY'),
(2844, '07845', '+40.867331', '-074.578269', 'IRONIA', 'NJ', 'NEW JERSEY', 'MORRIS', 'PO BOX ONLY'),
(2845, '07846', '+40.968998', '-074.873265', 'JOHNSONBURG', 'NJ', 'NEW JERSEY', 'WARREN', 'PO BOX ONLY'),
(2846, '07847', '+40.876098', '-074.695309', 'KENVIL', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2847, '07848', '+41.128183', '-074.731759', 'LAFAYETTE', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2848, '07849', '+40.950597', '-074.612904', 'LAKE HOPATCONG', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2849, '07850', '+40.906298', '-074.664605', 'LANDING', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2850, '07851', '+41.178266', '-074.893060', 'LAYTON', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2851, '07852', '+40.863318', '-074.721224', 'LEDGEWOOD', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2852, '07853', '+40.806849', '-074.794595', 'LONG VALLEY', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2853, '07855', '+41.128310', '-074.678956', 'MIDDLEVILLE', 'NJ', 'NEW JERSEY', 'SUSSEX', 'PO BOX ONLY'),
(2854, '07856', '+40.874049', '-074.734330', 'MOUNT ARLINGTON', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2855, '07857', '+40.897808', '-074.700159', 'NETCONG', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2856, '07860', '+41.069522', '-074.806938', 'NEWTON', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2857, '07863', '+40.820044', '-074.941392', 'OXFORD', 'NJ', 'NEW JERSEY', 'WARREN', 'STANDARD'),
(2858, '07865', '+40.810748', '-074.874270', 'PORT MURRAY', 'NJ', 'NEW JERSEY', 'WARREN', 'STANDARD'),
(2859, '07866', '+40.960111', '-074.501551', 'ROCKAWAY', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2860, '07869', '+40.837399', '-074.586052', 'RANDOLPH', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2861, '07870', '+40.810362', '-074.819318', 'SCHOOLEYS MOUNTAIN', 'NJ', 'NEW JERSEY', 'MORRIS', 'PO BOX ONLY'),
(2862, '07871', '+41.040597', '-074.718191', 'SPARTA', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2863, '07874', '+40.930937', '-074.713557', 'STANHOPE', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2864, '07875', '+41.043858', '-074.871981', 'STILLWATER', 'NJ', 'NEW JERSEY', 'SUSSEX', 'PO BOX ONLY'),
(2865, '07876', '+40.855286', '-074.655255', 'SUCCASUNNA', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2866, '07877', '+41.102890', '-074.850759', 'SWARTSWOOD', 'NJ', 'NEW JERSEY', 'SUSSEX', 'PO BOX ONLY'),
(2867, '07878', '+40.871099', '-074.477699', 'MOUNT TABOR', 'NJ', 'NEW JERSEY', 'MORRIS', 'PO BOX ONLY'),
(2868, '07879', '+40.955934', '-074.788108', 'TRANQUILITY', 'NJ', 'NEW JERSEY', 'SUSSEX', 'PO BOX ONLY'),
(2869, '07880', '+40.864844', '-074.897002', 'VIENNA', 'NJ', 'NEW JERSEY', 'WARREN', 'PO BOX ONLY'),
(2870, '07881', '+41.125646', '-074.917711', 'WALLPACK CENTER', 'NJ', 'NEW JERSEY', 'SUSSEX', 'STANDARD'),
(2871, '07882', '+40.747698', '-075.008713', 'WASHINGTON', 'NJ', 'NEW JERSEY', 'WARREN', 'STANDARD'),
(2872, '07885', '+40.935349', '-074.577102', 'WHARTON', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2873, '07890', '+41.128310', '-074.678956', 'BRANCHVILLE', 'NJ', 'NEW JERSEY', 'SUSSEX', 'UNIQUE'),
(2874, '07901', '+40.712750', '-074.361594', 'SUMMIT', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2875, '07902', '+40.665651', '-074.299692', 'SUMMIT', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2876, '07920', '+40.682651', '-074.573001', 'BASKING RIDGE', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(2877, '07921', '+40.659151', '-074.676788', 'BEDMINSTER', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(2878, '07922', '+40.675451', '-074.422196', 'BERKELEY HEIGHTS', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2879, '07924', '+40.725750', '-074.593552', 'BERNARDSVILLE', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(2880, '07926', '+40.800353', '-074.571785', 'BROOKSIDE', 'NJ', 'NEW JERSEY', 'MORRIS', 'PO BOX ONLY'),
(2881, '07927', '+40.820799', '-074.456198', 'CEDAR KNOLLS', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2882, '07928', '+40.759477', '-074.496806', 'CHATHAM', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2883, '07930', '+40.782111', '-074.683861', 'CHESTER', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2884, '07931', '+40.699572', '-074.653603', 'FAR HILLS', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(2885, '07932', '+40.773500', '-074.397996', 'FLORHAM PARK', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2886, '07933', '+40.689339', '-074.472198', 'GILLETTE', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2887, '07934', '+40.715359', '-074.682767', 'GLADSTONE', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(2888, '07935', '+40.739782', '-074.448747', 'GREEN VILLAGE', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2889, '07936', '+40.816349', '-074.367747', 'EAST HANOVER', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2890, '07938', '+40.655399', '-074.586151', 'LIBERTY CORNER', 'NJ', 'NEW JERSEY', 'SOMERSET', 'PO BOX ONLY'),
(2891, '07939', '+40.566553', '-074.599801', 'LYONS', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(2892, '07940', '+40.758200', '-074.423019', 'MADISON', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2893, '07945', '+40.786699', '-074.593800', 'MENDHAM', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2894, '07946', '+40.678701', '-074.505399', 'MILLINGTON', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2895, '07950', '+40.843399', '-074.540341', 'MORRIS PLAINS', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2896, '07960', '+40.771650', '-074.506256', 'MORRISTOWN', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2897, '07961', '+40.779750', '-074.442797', 'MORRISTOWN', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2898, '07962', '+40.867331', '-074.578269', 'MORRISTOWN', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2899, '07963', '+40.867331', '-074.578269', 'MORRISTOWN', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2900, '07970', '+40.805549', '-074.573832', 'MOUNT FREEDOM', 'NJ', 'NEW JERSEY', 'MORRIS', 'PO BOX ONLY'),
(2901, '07974', '+40.697851', '-074.405595', 'NEW PROVIDENCE', 'NJ', 'NEW JERSEY', 'UNION', 'STANDARD'),
(2902, '07976', '+40.739599', '-074.483413', 'NEW VERNON', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2903, '07977', '+40.707876', '-074.654131', 'PEAPACK', 'NJ', 'NEW JERSEY', 'SOMERSET', 'PO BOX ONLY'),
(2904, '07978', '+40.642491', '-074.639597', 'PLUCKEMIN', 'NJ', 'NEW JERSEY', 'SOMERSET', 'PO BOX ONLY'),
(2905, '07979', '+40.708241', '-074.748389', 'POTTERSVILLE', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'PO BOX ONLY'),
(2906, '07980', '+40.698350', '-074.450197', 'STIRLING', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2907, '07981', '+40.823899', '-074.419097', 'WHIPPANY', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2908, '07983', '+40.867331', '-074.578269', 'WHIPPANY', 'NJ', 'NEW JERSEY', 'MORRIS', 'UNIQUE'),
(2909, '07999', '+40.867331', '-074.578269', 'WHIPPANY', 'NJ', 'NEW JERSEY', 'MORRIS', 'STANDARD'),
(2910, '08001', '+39.559077', '-075.350573', 'ALLOWAY', 'NJ', 'NEW JERSEY', 'SALEM', 'PO BOX ONLY'),
(2911, '08002', '+39.908663', '-075.010307', 'CHERRY HILL', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2912, '08003', '+39.889763', '-074.972761', 'CHERRY HILL', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2913, '08004', '+39.760048', '-074.866534', 'ATCO', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2914, '08005', '+39.753858', '-074.293989', 'BARNEGAT', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(2915, '08006', '+39.751214', '-074.114631', 'BARNEGAT LIGHT', 'NJ', 'NEW JERSEY', 'OCEAN', 'PO BOX ONLY'),
(2916, '08007', '+39.863813', '-075.053765', 'BARRINGTON', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2917, '08008', '+39.641062', '-074.192228', 'BEACH HAVEN', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(2918, '08009', '+39.761231', '-074.927010', 'BERLIN', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2919, '08010', '+40.049948', '-074.917061', 'BEVERLY', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2920, '08011', '+39.976041', '-074.711429', 'BIRMINGHAM', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'PO BOX ONLY'),
(2921, '08012', '+39.790131', '-075.036652', 'BLACKWOOD', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2922, '08014', '+39.802163', '-075.339215', 'BRIDGEPORT', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2923, '08015', '+39.924179', '-074.670408', 'BROWNS MILLS', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2924, '08016', '+40.089874', '-074.751146', 'BURLINGTON', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2925, '08018', '+39.802370', '-074.938259', 'CEDAR BROOK', 'NJ', 'NEW JERSEY', 'CAMDEN', 'PO BOX ONLY'),
(2926, '08019', '+39.749506', '-074.558941', 'CHATSWORTH', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2927, '08020', '+39.796706', '-075.218852', 'CLARKSBORO', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2928, '08021', '+39.803640', '-075.005762', 'CLEMENTON', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2929, '08022', '+40.049355', '-074.702475', 'COLUMBUS', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2930, '08023', '+39.681545', '-075.493433', 'DEEPWATER', 'NJ', 'NEW JERSEY', 'SALEM', 'PO BOX ONLY'),
(2931, '08025', '+39.701526', '-075.162903', 'EWAN', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'PO BOX ONLY'),
(2932, '08026', '+39.833114', '-074.967496', 'GIBBSBORO', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2933, '08027', '+39.771133', '-075.272137', 'GIBBSTOWN', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2934, '08028', '+39.696661', '-075.127183', 'GLASSBORO', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2935, '08029', '+39.837113', '-075.062315', 'GLENDORA', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2936, '08030', '+39.890413', '-075.112619', 'GLOUCESTER CITY', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2937, '08031', '+39.805543', '-075.067729', 'BELLMAWR', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2938, '08032', '+39.778750', '-075.060114', 'GRENLOCH', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2939, '08033', '+39.876313', '-075.033414', 'HADDONFIELD', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2940, '08034', '+39.899962', '-075.035015', 'CHERRY HILL', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2941, '08035', '+39.879163', '-075.065666', 'HADDON HEIGHTS', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2942, '08036', '+39.987212', '-074.829308', 'HAINESPORT', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'PO BOX ONLY'),
(2943, '08037', '+39.563616', '-074.711081', 'HAMMONTON', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(2944, '08038', '+39.569805', '-075.312703', 'HANCOCKS BRIDGE', 'NJ', 'NEW JERSEY', 'SALEM', 'PO BOX ONLY'),
(2945, '08039', '+39.693067', '-075.271114', 'HARRISONVILLE', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'PO BOX ONLY'),
(2946, '08041', '+40.044129', '-074.679579', 'JOBSTOWN', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2947, '08042', '+40.012273', '-074.664640', 'JULIUSTOWN', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'PO BOX ONLY'),
(2948, '08043', '+39.839156', '-074.965057', 'VOORHEES', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2949, '08045', '+39.868113', '-075.032114', 'LAWNSIDE', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2950, '08046', '+40.013737', '-074.805773', 'WILLINGBORO', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2951, '08048', '+39.962299', '-074.800070', 'LUMBERTON', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2952, '08049', '+39.854363', '-075.036214', 'MAGNOLIA', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2953, '08050', '+39.702978', '-074.257677', 'MANAHAWKIN', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(2954, '08051', '+39.751571', '-075.212842', 'MANTUA', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2955, '08052', '+39.951212', '-074.992163', 'MAPLE SHADE', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2956, '08053', '+39.892263', '-074.940750', 'MARLTON', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2957, '08054', '+39.955912', '-074.917310', 'MOUNT LAUREL', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2958, '08055', '+39.874549', '-074.762083', 'MEDFORD', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2959, '08056', '+39.787913', '-075.246687', 'MICKLETON', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2960, '08057', '+40.054255', '-074.840115', 'MOORESTOWN', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(2961, '08059', '+39.886463', '-075.094068', 'MOUNT EPHRAIM', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2962, '08060', '+40.044956', '-074.801869', 'MOUNT HOLLY', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2963, '08061', '+39.808643', '-075.212943', 'MOUNT ROYAL', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2964, '08062', '+39.715857', '-075.235017', 'MULLICA HILL', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2965, '08063', '+39.779654', '-075.218413', 'NATIONAL PARK', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2966, '08064', '+39.862433', '-074.725079', 'NEW LISBON', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'PO BOX ONLY'),
(2967, '08065', '+40.031291', '-074.861971', 'PALMYRA', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2968, '08066', '+39.815690', '-075.238849', 'PAULSBORO', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2969, '08067', '+39.733769', '-075.408412', 'PEDRICKTOWN', 'NJ', 'NEW JERSEY', 'SALEM', 'STANDARD'),
(2970, '08068', '+39.966394', '-074.709185', 'PEMBERTON', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2971, '08069', '+39.619937', '-075.288423', 'PENNS GROVE', 'NJ', 'NEW JERSEY', 'SALEM', 'STANDARD'),
(2972, '08070', '+39.637683', '-075.512699', 'PENNSVILLE', 'NJ', 'NEW JERSEY', 'SALEM', 'STANDARD'),
(2973, '08071', '+39.734928', '-075.136809', 'PITMAN', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2974, '08072', '+39.541055', '-075.383689', 'QUINTON', 'NJ', 'NEW JERSEY', 'SALEM', 'PO BOX ONLY'),
(2975, '08073', '+39.862433', '-074.725079', 'RANCOCAS', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'PO BOX ONLY'),
(2976, '08074', '+39.720622', '-075.168141', 'RICHWOOD', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'PO BOX ONLY'),
(2977, '08075', '+40.063293', '-074.853307', 'RIVERSIDE', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2978, '08076', '+39.862433', '-074.725079', 'RIVERTON', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2979, '08077', '+39.999211', '-074.908710', 'RIVERTON', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2980, '08078', '+39.850163', '-075.070672', 'RUNNEMEDE', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2981, '08079', '+39.587729', '-075.439362', 'SALEM', 'NJ', 'NEW JERSEY', 'SALEM', 'STANDARD'),
(2982, '08080', '+39.755210', '-075.201593', 'SEWELL', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2983, '08081', '+39.747558', '-074.970462', 'SICKLERVILLE', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2984, '08083', '+39.844063', '-075.022163', 'SOMERDALE', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2985, '08084', '+39.829763', '-075.012012', 'STRATFORD', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2986, '08085', '+39.752740', '-075.318049', 'SWEDESBORO', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2987, '08086', '+39.838721', '-075.248610', 'THOROFARE', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2988, '08087', '+39.671687', '-074.288092', 'TUCKERTON', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(2989, '08088', '+39.860351', '-074.669346', 'VINCENTOWN', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(2990, '08089', '+39.723037', '-074.836939', 'WATERFORD WORKS', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2991, '08090', '+39.798313', '-075.148071', 'WENONAH', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2992, '08091', '+39.734923', '-074.950993', 'WEST BERLIN', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(2993, '08092', '+39.656391', '-074.295555', 'WEST CREEK', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(2994, '08093', '+39.857810', '-075.137320', 'WESTVILLE', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2995, '08094', '+39.725538', '-075.058082', 'WILLIAMSTOWN', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2996, '08095', '+39.654885', '-074.868531', 'WINSLOW', 'NJ', 'NEW JERSEY', 'CAMDEN', 'PO BOX ONLY'),
(2997, '08096', '+39.822013', '-075.129669', 'WOODBURY', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2998, '08097', '+39.762971', '-075.197870', 'WOODBURY HEIGHTS', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(2999, '08098', '+39.586000', '-075.379897', 'WOODSTOWN', 'NJ', 'NEW JERSEY', 'SALEM', 'STANDARD'),
(3000, '08099', '+39.779179', '-074.962071', 'BELLMAWR', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(3001, '08101', '+39.802370', '-074.938259', 'CAMDEN', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(3002, '08102', '+39.950912', '-075.118869', 'CAMDEN', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(3003, '08103', '+39.933174', '-075.108519', 'CAMDEN', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(3004, '08104', '+39.916612', '-075.109169', 'CAMDEN', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(3005, '08105', '+39.920162', '-075.084667', 'CAMDEN', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(3006, '08106', '+39.828349', '-074.994647', 'AUDUBON', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(3007, '08107', '+39.872001', '-075.053114', 'OAKLYN', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(3008, '08108', '+39.834003', '-074.991268', 'COLLINGSWOOD', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(3009, '08109', '+39.950312', '-075.059916', 'MERCHANTVILLE', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(3010, '08110', '+39.839405', '-074.945624', 'PENNSAUKEN', 'NJ', 'NEW JERSEY', 'CAMDEN', 'STANDARD'),
(3011, '08201', '+39.489090', '-074.680323', 'ABSECON', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3012, '08202', '+39.112027', '-074.731427', 'AVALON', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3013, '08203', '+39.370172', '-074.494010', 'BRIGANTINE', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3014, '08204', '+39.110337', '-074.767939', 'CAPE MAY', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3015, '08205', '', '', 'ABSECON', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3016, '08210', '+39.137841', '-074.780560', 'CAPE MAY COURT HOUSE', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3017, '08212', '+38.937168', '-074.965385', 'CAPE MAY POINT', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'PO BOX ONLY'),
(3018, '08213', '+39.509208', '-074.608557', 'COLOGNE', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'PO BOX ONLY'),
(3019, '08214', '+39.056521', '-074.816619', 'DENNISVILLE', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'PO BOX ONLY'),
(3020, '08215', '+39.530539', '-074.638341', 'EGG HARBOR CITY', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3021, '08217', '+39.573741', '-074.719989', 'ELWOOD', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'PO BOX ONLY'),
(3022, '08218', '+39.056521', '-074.816619', 'GOSHEN', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'PO BOX ONLY'),
(3023, '08219', '+39.056521', '-074.816619', 'GREEN CREEK', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'PO BOX ONLY'),
(3024, '08220', '+39.509208', '-074.608557', 'LEEDS POINT', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'PO BOX ONLY'),
(3025, '08221', '+39.427786', '-074.622112', 'LINWOOD', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3026, '08223', '+39.139520', '-074.730380', 'MARMORA', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3027, '08224', '+39.595197', '-074.435683', 'NEW GRETNA', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'PO BOX ONLY'),
(3028, '08225', '+39.421922', '-074.572227', 'NORTHFIELD', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3029, '08226', '+39.248530', '-074.604409', 'OCEAN CITY', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3030, '08230', '+39.205183', '-074.778293', 'OCEAN VIEW', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3031, '08231', '+39.509208', '-074.608557', 'OCEANVILLE', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'PO BOX ONLY'),
(3032, '08232', '+39.470869', '-074.686004', 'PLEASANTVILLE', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3033, '08234', '+39.374067', '-074.611764', 'EGG HARBOR TOWNSHIP', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3034, '08240', '+39.487717', '-074.554334', 'POMONA', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'PO BOX ONLY'),
(3035, '08241', '+39.521785', '-074.694414', 'PORT REPUBLIC', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3036, '08242', '+39.017283', '-074.883671', 'RIO GRANDE', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3037, '08243', '+39.154028', '-074.700502', 'SEA ISLE CITY', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3038, '08244', '+39.425655', '-074.664422', 'SOMERS POINT', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3039, '08245', '+39.099980', '-074.848733', 'SOUTH DENNIS', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'PO BOX ONLY'),
(3040, '08246', '+39.056521', '-074.816619', 'SOUTH SEAVILLE', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'PO BOX ONLY'),
(3041, '08247', '+39.047882', '-074.775050', 'STONE HARBOR', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3042, '08248', '+39.192018', '-074.661977', 'STRATHMERE', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'PO BOX ONLY'),
(3043, '08250', '+39.056521', '-074.816619', 'TUCKAHOE', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'PO BOX ONLY'),
(3044, '08251', '+39.140921', '-074.851181', 'VILLAS', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3045, '08252', '+39.042124', '-074.861792', 'WHITESBORO', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'PO BOX ONLY'),
(3046, '08260', '+39.067777', '-074.776740', 'WILDWOOD', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3047, '08270', '+39.158165', '-074.786886', 'WOODBINE', 'NJ', 'NEW JERSEY', 'CAPE MAY', 'STANDARD'),
(3048, '08302', '+39.376200', '-075.161700', 'BRIDGETON', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3049, '08310', '+39.523712', '-074.899762', 'BUENA', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3050, '08311', '+39.330611', '-075.117761', 'CEDARVILLE', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3051, '08312', '+39.653531', '-075.078625', 'CLAYTON', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(3052, '08313', '+39.529261', '-075.224865', 'DEERFIELD STREET', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'PO BOX ONLY'),
(3053, '08314', '+39.358151', '-074.977352', 'DELMONT', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3054, '08315', '+39.273214', '-075.095025', 'DIVIDING CREEK', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'PO BOX ONLY'),
(3055, '08316', '+39.267898', '-074.979118', 'DORCHESTER', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'PO BOX ONLY'),
(3056, '08317', '+39.425858', '-074.826057', 'DOROTHY', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3057, '08318', '+39.548074', '-075.198368', 'ELMER', 'NJ', 'NEW JERSEY', 'SALEM', 'STANDARD'),
(3058, '08319', '+39.376144', '-074.805412', 'ESTELL MANOR', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3059, '08320', '+39.379906', '-075.221681', 'FAIRTON', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'PO BOX ONLY'),
(3060, '08321', '+39.273034', '-075.191370', 'FORTESCUE', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'PO BOX ONLY'),
(3061, '08322', '+39.598230', '-075.035749', 'FRANKLINVILLE', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(3062, '08323', '+39.405498', '-075.320881', 'GREENWICH', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3063, '08324', '+39.224047', '-074.994184', 'HEISLERVILLE', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3064, '08326', '+39.533843', '-074.934493', 'LANDISVILLE', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3065, '08327', '+39.387948', '-075.007418', 'LEESBURG', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3066, '08328', '+39.581010', '-075.055482', 'MALAGA', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(3067, '08329', '+39.285278', '-074.998319', 'MAURICETOWN', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'PO BOX ONLY'),
(3068, '08330', '+39.472040', '-074.715880', 'MAYS LANDING', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3069, '08332', '+39.370401', '-075.042820', 'MILLVILLE', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3070, '08340', '+39.447855', '-074.869885', 'MILMAY', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3071, '08341', '+39.530779', '-074.940036', 'MINOTOLA', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3072, '08342', '+39.502080', '-074.833469', 'MIZPAH', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'PO BOX ONLY'),
(3073, '08343', '+39.641089', '-075.144475', 'MONROEVILLE', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(3074, '08344', '+39.565465', '-075.014084', 'NEWFIELD', 'NJ', 'NEW JERSEY', 'GLOUCESTER', 'STANDARD'),
(3075, '08345', '+39.304244', '-075.109132', 'NEWPORT', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3076, '08346', '+39.557607', '-074.870807', 'NEWTONVILLE', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3077, '08347', '+39.499765', '-075.082022', 'NORMA', 'NJ', 'NEW JERSEY', 'SALEM', 'PO BOX ONLY'),
(3078, '08348', '+39.313114', '-074.980668', 'PORT ELIZABETH', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3079, '08349', '+39.283259', '-075.098448', 'PORT NORRIS', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3080, '08350', '+39.491351', '-074.875543', 'RICHLAND', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3081, '08352', '+39.469515', '-075.146176', 'ROSENHAYN', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'PO BOX ONLY'),
(3082, '08353', '+39.421650', '-075.207667', 'SHILOH', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'PO BOX ONLY'),
(3083, '08360', '+39.392671', '-075.025676', 'VINELAND', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3084, '08361', '+39.465465', '-074.965279', 'VINELAND', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3085, '08362', '+39.271264', '-075.027671', 'VINELAND', 'NJ', 'NEW JERSEY', 'CUMBERLAND', 'STANDARD'),
(3086, '08401', '+39.486848', '-074.643014', 'ATLANTIC CITY', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3087, '08402', '+39.442068', '-074.666123', 'MARGATE CITY', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3088, '08403', '+39.324265', '-074.513497', 'LONGPORT', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3089, '08404', '+39.509208', '-074.608557', 'ATLANTIC CITY', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3090, '08405', '+39.509208', '-074.608557', 'ATLANTIC CITY', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'UNIQUE'),
(3091, '08406', '+39.414646', '-074.664150', 'VENTNOR CITY', 'NJ', 'NEW JERSEY', 'ATLANTIC', 'STANDARD'),
(3092, '08501', '+40.149712', '-074.539598', 'ALLENTOWN', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(3093, '08502', '+40.461504', '-074.648302', 'BELLE MEAD', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3094, '08504', '+40.425369', '-074.668753', 'BLAWENBURG', 'NJ', 'NEW JERSEY', 'SOMERSET', 'PO BOX ONLY'),
(3095, '08505', '+40.101535', '-074.724711', 'BORDENTOWN', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(3096, '08510', '+40.193311', '-074.442803', 'CLARKSBURG', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(3097, '08511', '+40.049551', '-074.557215', 'COOKSTOWN', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(3098, '08512', '+40.323116', '-074.516597', 'CRANBURY', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3099, '08514', '+40.139913', '-074.465018', 'CREAM RIDGE', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(3100, '08515', '+40.147555', '-074.661474', 'CROSSWICKS', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(3101, '08518', '+40.124860', '-074.738863', 'FLORENCE', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(3102, '08520', '+40.281558', '-074.572449', 'HIGHTSTOWN', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3103, '08525', '+40.389675', '-074.783956', 'HOPEWELL', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3104, '08526', '+40.162275', '-074.475936', 'IMLAYSTOWN', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(3105, '08527', '+40.105164', '-074.352814', 'JACKSON', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3106, '08528', '+40.382756', '-074.609551', 'KINGSTON', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3107, '08530', '+40.379360', '-074.901535', 'LAMBERTVILLE', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3108, '08533', '+40.082940', '-074.498741', 'NEW EGYPT', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3109, '08534', '+40.328630', '-074.813557', 'PENNINGTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3110, '08535', '+40.225860', '-074.452293', 'PERRINEVILLE', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(3111, '08536', '+40.342197', '-074.582062', 'PLAINSBORO', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3112, '08540', '+40.343625', '-074.693953', 'PRINCETON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3113, '08541', '+40.280531', '-074.712018', 'PRINCETON', 'NJ', 'NEW JERSEY', 'MERCER', 'UNIQUE'),
(3114, '08542', '+40.350456', '-074.658852', 'PRINCETON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3115, '08543', '+40.280531', '-074.712018', 'PRINCETON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3116, '08544', '+40.349206', '-074.652811', 'PRINCETON', 'NJ', 'NEW JERSEY', 'MERCER', 'UNIQUE'),
(3117, '08550', '+40.266858', '-074.651101', 'PRINCETON JUNCTION', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3118, '08551', '+40.445602', '-074.840322', 'RINGOES', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3119, '08553', '+40.412705', '-074.632256', 'ROCKY HILL', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3120, '08554', '+40.071829', '-074.711814', 'ROEBLING', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(3121, '08555', '+40.221360', '-074.474745', 'ROOSEVELT', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'PO BOX ONLY'),
(3122, '08556', '+40.419965', '-074.988619', 'ROSEMONT', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3123, '08557', '+40.563654', '-074.949409', 'SERGEANTSVILLE', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'PO BOX ONLY'),
(3124, '08558', '+40.434255', '-074.708525', 'SKILLMAN', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3125, '08559', '+40.436413', '-074.970597', 'STOCKTON', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3126, '08560', '+40.311826', '-074.863858', 'TITUSVILLE', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3127, '08561', '+40.242313', '-074.578709', 'WINDSOR', 'NJ', 'NEW JERSEY', 'MERCER', 'PO BOX ONLY'),
(3128, '08562', '+40.075100', '-074.608402', 'WRIGHTSTOWN', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(3129, '08570', '+40.430006', '-074.417344', 'CRANBURY', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'UNIQUE'),
(3130, '08601', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3131, '08602', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3132, '08603', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3133, '08604', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3134, '08605', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3135, '08606', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3136, '08607', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3137, '08608', '+40.220108', '-074.764055', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3138, '08609', '+40.224808', '-074.741004', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3139, '08610', '+40.201609', '-074.704953', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3140, '08611', '+40.196658', '-074.741554', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3141, '08618', '+40.223608', '-074.732504', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3142, '08619', '+40.241808', '-074.696151', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3143, '08620', '+40.194664', '-074.639852', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3144, '08625', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3145, '08628', '+40.265457', '-074.816757', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3146, '08629', '+40.219558', '-074.733404', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3147, '08638', '+40.232908', '-074.716954', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3148, '08640', '+40.009789', '-074.605198', 'TRENTON', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(3149, '08641', '+39.968787', '-074.624050', 'TRENTON', 'NJ', 'NEW JERSEY', 'BURLINGTON', 'STANDARD'),
(3150, '08645', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'UNIQUE'),
(3151, '08646', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'UNIQUE'),
(3152, '08647', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'UNIQUE'),
(3153, '08648', '+40.279457', '-074.691180', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3154, '08650', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3155, '08666', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'UNIQUE'),
(3156, '08677', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'UNIQUE'),
(3157, '08690', '+40.233577', '-074.657602', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3158, '08691', '+40.219738', '-074.593949', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'STANDARD'),
(3159, '08695', '+40.280531', '-074.712018', 'TRENTON', 'NJ', 'NEW JERSEY', 'MERCER', 'UNIQUE'),
(3160, '08701', '+39.945170', '-074.149784', 'LAKEWOOD', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3161, '08720', '+40.138878', '-074.112210', 'ALLENWOOD', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'PO BOX ONLY'),
(3162, '08721', '+39.966604', '-074.300023', 'BAYVILLE', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3163, '08722', '+39.927521', '-074.198585', 'BEACHWOOD', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3164, '08723', '+39.940021', '-074.122989', 'BRICK', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3165, '08724', '+39.938047', '-074.171090', 'BRICK', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3166, '08730', '+40.107614', '-074.065081', 'BRIELLE', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(3167, '08731', '+39.876031', '-074.230522', 'FORKED RIVER', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3168, '08732', '+39.983267', '-074.128482', 'ISLAND HEIGHTS', 'NJ', 'NEW JERSEY', 'OCEAN', 'PO BOX ONLY'),
(3169, '08733', '+39.992317', '-074.282240', 'LAKEHURST', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3170, '08734', '+39.863489', '-074.168217', 'LANOKA HARBOR', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3171, '08735', '+39.980917', '-074.072030', 'LAVALLETTE', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3172, '08736', '+40.121514', '-074.069963', 'MANASQUAN', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(3173, '08738', '+40.029916', '-074.056880', 'MANTOLOKING', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3174, '08739', '+40.000759', '-074.249280', 'NORMANDY BEACH', 'NJ', 'NEW JERSEY', 'OCEAN', 'PO BOX ONLY'),
(3175, '08740', '+39.926628', '-074.133332', 'OCEAN GATE', 'NJ', 'NEW JERSEY', 'OCEAN', 'PO BOX ONLY'),
(3176, '08741', '+40.003246', '-074.109626', 'PINE BEACH', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3177, '08742', '+39.954807', '-074.157056', 'POINT PLEASANT BEACH', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3178, '08750', '+40.161392', '-074.043772', 'SEA GIRT', 'NJ', 'NEW JERSEY', 'MONMOUTH', 'STANDARD'),
(3179, '08751', '+39.945991', '-074.181649', 'SEASIDE HEIGHTS', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3180, '08752', '+39.805832', '-074.145694', 'SEASIDE PARK', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3181, '08753', '+39.958851', '-074.215336', 'TOMS RIVER', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3182, '08754', '+40.000759', '-074.249280', 'TOMS RIVER', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3183, '08755', '+40.000696', '-074.256821', 'TOMS RIVER', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3184, '08756', '+39.787966', '-074.191058', 'TOMS RIVER', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3185, '08757', '+39.943064', '-074.264068', 'TOMS RIVER', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3186, '08758', '+39.787943', '-074.246662', 'WARETOWN', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3187, '08759', '+39.945798', '-074.297820', 'MANCHESTER TOWNSHIP', 'NJ', 'NEW JERSEY', 'OCEAN', 'STANDARD'),
(3188, '08801', '+40.631008', '-074.890685', 'ANNANDALE', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3189, '08802', '+40.695034', '-075.028089', 'ASBURY', 'NJ', 'NEW JERSEY', 'WARREN', 'STANDARD'),
(3190, '08803', '+40.563654', '-074.949409', 'BAPTISTOWN', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'PO BOX ONLY'),
(3191, '08804', '+40.646294', '-075.092934', 'BLOOMSBURY', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3192, '08805', '+40.575402', '-074.538249', 'BOUND BROOK', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3193, '08807', '+40.598702', '-074.607518', 'BRIDGEWATER', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3194, '08808', '+40.737213', '-075.046926', 'BROADWAY', 'NJ', 'NEW JERSEY', 'WARREN', 'PO BOX ONLY'),
(3195, '08809', '+40.530500', '-074.845574', 'CLINTON', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3196, '08810', '+40.372306', '-074.494889', 'DAYTON', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3197, '08812', '+40.589702', '-074.463947', 'DUNELLEN', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3198, '08816', '+40.427697', '-074.421695', 'EAST BRUNSWICK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3199, '08817', '+40.519753', '-074.393444', 'EDISON', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3200, '08818', '+40.430006', '-074.417344', 'EDISON', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3201, '08820', '+40.576611', '-074.362616', 'EDISON', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3202, '08821', '+40.566553', '-074.599801', 'FLAGTOWN', 'NJ', 'NEW JERSEY', 'SOMERSET', 'PO BOX ONLY'),
(3203, '08822', '+40.507860', '-074.863283', 'FLEMINGTON', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3204, '08823', '+40.440604', '-074.560249', 'FRANKLIN PARK', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3205, '08824', '+40.422955', '-074.549761', 'KENDALL PARK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3206, '08825', '+40.581190', '-075.012655', 'FRENCHTOWN', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3207, '08826', '+40.578191', '-074.904575', 'GLEN GARDNER', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3208, '08827', '+40.666700', '-074.964692', 'HAMPTON', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3209, '08828', '+40.375540', '-074.421644', 'HELMETTA', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3210, '08829', '+40.668163', '-074.889823', 'HIGH BRIDGE', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3211, '08830', '+40.569211', '-074.315042', 'ISELIN', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3212, '08831', '+40.343757', '-074.428870', 'MONROE TOWNSHIP', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3213, '08832', '+40.517559', '-074.306961', 'KEASBEY', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3214, '08833', '+40.635369', '-074.829976', 'LEBANON', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3215, '08834', '+40.563654', '-074.949409', 'LITTLE YORK', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'PO BOX ONLY'),
(3216, '08835', '+40.541053', '-074.589225', 'MANVILLE', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3217, '08836', '+40.604352', '-074.553800', 'MARTINSVILLE', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3218, '08837', '+40.527054', '-074.350393', 'EDISON', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3219, '08840', '+40.472224', '-074.451940', 'METUCHEN', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3220, '08844', '', '', 'HILLSBOROUGH', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3221, '08846', '+40.575202', '-074.499398', 'MIDDLESEX', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3222, '08848', '+40.664749', '-074.970542', 'MILFORD', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3223, '08850', '+40.448255', '-074.444395', 'MILLTOWN', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3224, '08852', '+40.386942', '-074.555799', 'MONMOUTH JUNCTION', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3225, '08853', '+40.492604', '-074.726555', 'NESHANIC STATION', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3226, '08854', '+40.552925', '-074.457746', 'PISCATAWAY', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3227, '08855', '+40.430006', '-074.417344', 'PISCATAWAY', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3228, '08857', '+40.407319', '-074.314319', 'OLD BRIDGE', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3229, '08858', '+40.691798', '-074.752537', 'OLDWICK', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'PO BOX ONLY'),
(3230, '08859', '+40.459205', '-074.306956', 'PARLIN', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3231, '08861', '+40.520654', '-074.279144', 'PERTH AMBOY', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3232, '08862', '+40.430006', '-074.417344', 'PERTH AMBOY', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3233, '08863', '+40.531390', '-074.315250', 'FORDS', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3234, '08865', '+40.765309', '-074.987430', 'PHILLIPSBURG', 'NJ', 'NEW JERSEY', 'WARREN', 'STANDARD'),
(3235, '08867', '+40.585926', '-074.976982', 'PITTSTOWN', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3236, '08868', '+40.565493', '-074.938931', 'QUAKERTOWN', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'PO BOX ONLY'),
(3237, '08869', '+40.573802', '-074.642649', 'RARITAN', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3238, '08870', '+40.563654', '-074.949409', 'READINGTON', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'PO BOX ONLY'),
(3239, '08871', '+40.430006', '-074.417344', 'SAYREVILLE', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3240, '08872', '+40.453358', '-074.334192', 'SAYREVILLE', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3241, '08873', '+40.491002', '-074.523648', 'SOMERSET', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3242, '08875', '+40.580918', '-074.711731', 'SOMERSET', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3243, '08876', '+40.560314', '-074.661650', 'SOMERVILLE', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3244, '08877', '+40.430006', '-074.417344', 'SOUTH RIVER', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'UNIQUE'),
(3245, '08878', '+40.436865', '-074.250942', 'SOUTH AMBOY', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'UNIQUE'),
(3246, '08879', '+40.463970', '-074.274168', 'SOUTH AMBOY', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3247, '08880', '+40.552253', '-074.531149', 'SOUTH BOUND BROOK', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3248, '08882', '+40.445905', '-074.381768', 'SOUTH RIVER', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3249, '08884', '+40.385707', '-074.393249', 'SPOTSWOOD', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3250, '08885', '+40.576372', '-074.831105', 'STANTON', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'PO BOX ONLY'),
(3251, '08886', '+40.717349', '-075.072957', 'STEWARTSVILLE', 'NJ', 'NEW JERSEY', 'WARREN', 'STANDARD'),
(3252, '08887', '+40.520570', '-074.794632', 'THREE BRIDGES', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3253, '08888', '+40.619412', '-074.740597', 'WHITEHOUSE', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'PO BOX ONLY'),
(3254, '08889', '+40.615577', '-074.772376', 'WHITEHOUSE STATION', 'NJ', 'NEW JERSEY', 'HUNTERDON', 'STANDARD'),
(3255, '08890', '+40.536069', '-074.578872', 'ZAREPHATH', 'NJ', 'NEW JERSEY', 'SOMERSET', 'STANDARD'),
(3256, '08896', '+40.566553', '-074.599801', 'RARITAN', 'NJ', 'NEW JERSEY', 'SOMERSET', 'UNIQUE'),
(3257, '08899', '+40.520254', '-074.420545', 'EDISON', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3258, '08901', '+40.486754', '-074.444395', 'NEW BRUNSWICK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3259, '08902', '+40.437705', '-074.488547', 'NORTH BRUNSWICK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3260, '08903', '+40.513854', '-074.445098', 'NEW BRUNSWICK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3261, '08904', '+40.499866', '-074.428095', 'HIGHLAND PARK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3262, '08905', '+40.430006', '-074.417344', 'NEW BRUNSWICK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'UNIQUE'),
(3263, '08906', '+40.430006', '-074.417344', 'NEW BRUNSWICK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'STANDARD'),
(3264, '08922', '+40.430006', '-074.417344', 'NEW BRUNSWICK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'UNIQUE'),
(3265, '08933', '+40.430006', '-074.417344', 'NEW BRUNSWICK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'UNIQUE'),
(3266, '08988', '+40.430006', '-074.417344', 'NEW BRUNSWICK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'UNIQUE'),
(3267, '08989', '+40.430006', '-074.417344', 'NEW BRUNSWICK', 'NJ', 'NEW JERSEY', 'MIDDLESEX', 'UNIQUE'),
(3268, '09007', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3269, '09009', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3270, '09012', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3271, '09013', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3272, '09014', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3273, '09021', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3274, '09028', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3275, '09029', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3276, '09031', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3277, '09033', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3278, '09034', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3279, '09036', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3280, '09037', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3281, '09042', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3282, '09045', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3283, '09046', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3284, '09050', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3285, '09053', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3286, '09054', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3287, '09056', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3288, '09058', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3289, '09059', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3290, '09060', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3291, '09063', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3292, '09067', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3293, '09069', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3294, '09072', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3295, '09074', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3296, '09076', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3297, '09080', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3298, '09081', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3299, '09086', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3300, '09089', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3301, '09090', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3302, '09094', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3303, '09095', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3304, '09096', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3305, '09098', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3306, '09099', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3307, '09100', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3308, '09102', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3309, '09103', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3310, '09104', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3311, '09106', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3312, '09107', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3313, '09110', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3314, '09111', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3315, '09112', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3316, '09114', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3317, '09123', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3318, '09126', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3319, '09128', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3320, '09131', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3321, '09136', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3322, '09137', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3323, '09138', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3324, '09139', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3325, '09140', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3326, '09142', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3327, '09143', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3328, '09154', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3329, '09157', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3330, '09164', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3331, '09165', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3332, '09166', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3333, '09169', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3334, '09172', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3335, '09173', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3336, '09175', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3337, '09177', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3338, '09178', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3339, '09180', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3340, '09182', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3341, '09183', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3342, '09185', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3343, '09186', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3344, '09189', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3345, '09211', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3346, '09212', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3347, '09213', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3348, '09214', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3349, '09220', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3350, '09222', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3351, '09225', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3352, '09226', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3353, '09227', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3354, '09229', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3355, '09234', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3356, '09237', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3357, '09239', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3358, '09244', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3359, '09245', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3360, '09250', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3361, '09252', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3362, '09262', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3363, '09263', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3364, '09264', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3365, '09265', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3366, '09266', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3367, '09267', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3368, '09269', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3369, '09275', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3370, '09302', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3371, '09303', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3372, '09304', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3373, '09305', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3374, '09340', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3375, '09391', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3376, '09396', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3377, '09397', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3378, '09398', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3379, '09409', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3380, '09419', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3381, '09420', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3382, '09421', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3383, '09447', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3384, '09448', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3385, '09449', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3386, '09454', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3387, '09456', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3388, '09459', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3389, '09461', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3390, '09463', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3391, '09464', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3392, '09468', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3393, '09469', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3394, '09470', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3395, '09494', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3396, '09496', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3397, '09498', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3398, '09499', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3399, '09501', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3400, '09502', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3401, '09503', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3402, '09504', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3403, '09505', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3404, '09506', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3405, '09507', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3406, '09508', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3407, '09509', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3408, '09510', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3409, '09511', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3410, '09517', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3411, '09521', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3412, '09524', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3413, '09532', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3414, '09534', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3415, '09536', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3416, '09543', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3417, '09544', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3418, '09545', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3419, '09549', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3420, '09550', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3421, '09551', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3422, '09554', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3423, '09556', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3424, '09557', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3425, '09558', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3426, '09563', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3427, '09564', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3428, '09565', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3429, '09566', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3430, '09567', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3431, '09568', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3432, '09569', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3433, '09570', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3434, '09573', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3435, '09574', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3436, '09575', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3437, '09576', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3438, '09577', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3439, '09578', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3440, '09579', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3441, '09581', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3442, '09582', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3443, '09586', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3444, '09587', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3445, '09588', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3446, '09589', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3447, '09590', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3448, '09591', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3449, '09593', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3450, '09594', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3451, '09595', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3452, '09596', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3453, '09599', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3454, '09601', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3455, '09603', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3456, '09604', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3457, '09609', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3458, '09610', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3459, '09612', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3460, '09613', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3461, '09617', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3462, '09618', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3463, '09619', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3464, '09620', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3465, '09621', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3466, '09622', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3467, '09623', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3468, '09624', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3469, '09625', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3470, '09626', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3471, '09627', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3472, '09628', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3473, '09630', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3474, '09631', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3475, '09636', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3476, '09638', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3477, '09642', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3478, '09643', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3479, '09644', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3480, '09645', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3481, '09647', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3482, '09649', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3483, '09703', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3484, '09704', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3485, '09705', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3486, '09706', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3487, '09707', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3488, '09708', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3489, '09709', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3490, '09710', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3491, '09711', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3492, '09713', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3493, '09714', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3494, '09715', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3495, '09716', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3496, '09717', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3497, '09718', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3498, '09720', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3499, '09721', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3500, '09722', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3501, '09723', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3502, '09724', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3503, '09725', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3504, '09726', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3505, '09727', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3506, '09728', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3507, '09729', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3508, '09730', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3509, '09731', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3510, '09732', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3511, '09733', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3512, '09734', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3513, '09735', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3514, '09777', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3515, '09779', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3516, '09780', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3517, '09782', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3518, '09783', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3519, '09784', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3520, '09789', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3521, '09790', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3522, '09791', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3523, '09792', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3524, '09793', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3525, '09795', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3526, '09796', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3527, '09797', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3528, '09802', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3529, '09803', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3530, '09804', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3531, '09805', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3532, '09808', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3533, '09809', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3534, '09810', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3535, '09811', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3536, '09812', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3537, '09813', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3538, '09814', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3539, '09815', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3540, '09816', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3541, '09819', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(3542, '09821', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3543, '09822', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3544, '09823', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3545, '09824', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3546, '09825', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3547, '09826', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3548, '09827', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3549, '09828', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3550, '09829', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3551, '09830', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3552, '09831', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3553, '09832', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3554, '09833', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3555, '09834', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3556, '09835', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3557, '09836', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3558, '09837', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3559, '09838', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3560, '09839', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3561, '09841', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3562, '09842', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3563, '09843', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3564, '09844', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3565, '09852', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3566, '09853', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3567, '09854', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3568, '09855', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3569, '09858', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3570, '09865', '', '', 'FPO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3571, '09866', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3572, '09867', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3573, '09868', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3574, '09871', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3575, '09876', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3576, '09880', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3577, '09882', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3578, '09888', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3579, '09889', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3580, '09890', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3581, '09892', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3582, '09894', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3583, '09898', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3584, '09899', '', '', 'APO', 'AE', 'ARMED FORCES', '', 'MILITARY'),
(3585, '10001', '+40.750422', '-073.996328', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3586, '10002', '+40.718758', '-073.986427', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3587, '10003', '+40.730223', '-073.988564', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3588, '10004', '+40.696355', '-074.025276', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3589, '10005', '+40.706903', '-074.008654', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3590, '10006', '+40.708834', '-074.013168', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3591, '10007', '+40.713941', '-074.007401', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3592, '10008', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3593, '10009', '+40.727750', '-073.980396', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3594, '10010', '+40.739024', '-073.983542', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3595, '10011', '+40.740916', '-073.999769', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3596, '10012', '+40.729124', '-073.991582', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3597, '10013', '+40.722105', '-074.003497', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3598, '10014', '+40.738088', '-074.005095', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3599, '10015', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3600, '10016', '+40.745527', '-073.978449', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3601, '10017', '+40.752955', '-073.973196', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3602, '10018', '+40.755332', '-073.993172', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3603, '10019', '+40.765926', '-073.985443', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3604, '10020', '+40.735449', '-073.996788', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3605, '10021', '+40.768823', '-073.960257', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3606, '10022', '+40.758775', '-073.967842', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3607, '10023', '+40.776765', '-073.982213', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3608, '10024', '+40.808130', '-073.965653', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3609, '10025', '+40.798664', '-073.967778', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3610, '10026', '+40.802918', '-073.953107', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3611, '10027', '+40.812242', '-073.953200', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3612, '10028', '+40.776629', '-073.953914', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3613, '10029', '+40.791884', '-073.943517', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3614, '10030', '+40.818474', '-073.943290', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3615, '10031', '+40.823438', '-073.949039', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3616, '10032', '+40.839137', '-073.942181', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3617, '10033', '+40.851293', '-073.934764', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3618, '10034', '+40.863194', '-073.926959', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3619, '10035', '+40.801913', '-073.934700', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3620, '10036', '+40.759530', '-073.989847', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3621, '10037', '+40.813884', '-073.938498', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3622, '10038', '+40.710223', '-074.003368', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3623, '10039', '+40.826736', '-073.939398', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3624, '10040', '+40.858692', '-073.930999', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3625, '10041', '+40.703801', '-074.009814', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3626, '10043', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3627, '10044', '+40.761812', '-073.950521', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3628, '10045', '+40.708590', '-074.008687', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3629, '10046', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3630, '10047', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3631, '10048', '+40.712540', '-074.013289', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3632, '10055', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3633, '10060', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3634, '10069', '+40.777952', '-073.988381', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3635, '10072', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3636, '10079', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3637, '10080', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3638, '10081', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3639, '10082', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3640, '10087', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3641, '10090', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3642, '10094', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3643, '10095', '+40.748181', '-073.988421', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3644, '10096', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3645, '10098', '+40.748181', '-073.988421', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3646, '10099', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3647, '10101', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3648, '10102', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3649, '10103', '+40.760264', '-073.976240', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3650, '10104', '+40.760943', '-073.979908', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3651, '10105', '+40.762808', '-073.978534', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3652, '10106', '+40.765243', '-073.980438', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3653, '10107', '+40.766429', '-073.982728', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3654, '10108', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3655, '10109', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3656, '10110', '+40.753987', '-073.980811', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3657, '10111', '+40.759224', '-073.977762', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3658, '10112', '+40.759287', '-073.979808', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3659, '10113', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3660, '10114', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3661, '10115', '+40.811115', '-073.964230', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3662, '10116', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3663, '10117', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3664, '10118', '+40.748998', '-073.986467', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3665, '10119', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3666, '10120', '+40.750629', '-073.989426', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3667, '10121', '+40.749640', '-073.991889', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3668, '10122', '+40.751757', '-073.992171', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3669, '10123', '+40.751489', '-073.990537', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3670, '10124', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3671, '10125', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3672, '10126', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3673, '10128', '+40.780989', '-073.951580', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3674, '10129', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3675, '10130', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3676, '10131', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3677, '10132', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3678, '10133', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3679, '10138', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3680, '10149', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3681, '10150', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3682, '10151', '+40.763419', '-073.973971', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3683, '10152', '+40.758937', '-073.973020', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3684, '10153', '+40.764068', '-073.973480', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3685, '10154', '+40.758304', '-073.973468', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3686, '10155', '+40.761104', '-073.968036', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3687, '10156', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3688, '10157', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3689, '10158', '+40.749435', '-073.975800', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3690, '10159', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3691, '10160', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3692, '10161', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3693, '10162', '+40.769945', '-073.951117', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3694, '10163', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3695, '10164', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3696, '10165', '+40.752351', '-073.979132', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3697, '10166', '+40.754591', '-073.976238', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3698, '10167', '+40.754858', '-073.974970', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3699, '10168', '+40.751933', '-073.976794', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3700, '10169', '+40.754740', '-073.976595', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3701, '10170', '+40.752621', '-073.975480', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3702, '10171', '+40.756447', '-073.974821', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3703, '10172', '+40.755839', '-073.975279', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3704, '10173', '+40.754305', '-073.979564', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3705, '10174', '+40.751656', '-073.975160', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3706, '10175', '+40.754305', '-073.979782', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3707, '10176', '+40.755570', '-073.978877', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3708, '10177', '+40.755332', '-073.976082', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3709, '10178', '+40.751378', '-073.978507', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3710, '10179', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3711, '10184', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3712, '10185', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3713, '10196', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3714, '10197', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3715, '10199', '+40.750308', '-074.000580', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3716, '10203', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3717, '10211', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3718, '10212', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3719, '10213', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3720, '10242', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3721, '10249', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3722, '10256', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3723, '10257', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3724, '10258', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3725, '10259', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3726, '10260', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3727, '10261', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3728, '10265', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3729, '10268', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3730, '10269', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3731, '10270', '+40.706925', '-074.008154', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3732, '10271', '+40.708918', '-074.011066', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3733, '10272', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3734, '10273', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3735, '10274', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3736, '10275', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3737, '10276', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3738, '10277', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3739, '10278', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3740, '10279', '+40.712697', '-074.007812', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3741, '10280', '+40.708857', '-074.016217', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3742, '10281', '+40.714643', '-074.014958', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3743, '10282', '+40.716597', '-074.014590', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'STANDARD'),
(3744, '10285', '+40.715330', '-074.016306', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3745, '10286', '+40.714231', '-074.011895', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3746, '10292', '+40.780751', '-073.977182', 'NEW YORK', 'NY', 'NEW YORK', 'NEW YORK', 'UNIQUE'),
(3747, '10301', '+40.623632', '-074.093323', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3748, '10302', '+40.628923', '-074.137947', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3749, '10303', '+40.631697', '-074.165016', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3750, '10304', '+40.608389', '-074.093684', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3751, '10305', '+40.596828', '-074.077837', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3752, '10306', '+40.559668', '-074.122410', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3753, '10307', '+40.510723', '-074.241940', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3754, '10308', '+40.551191', '-074.148893', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3755, '10309', '+40.531767', '-074.218779', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3756, '10310', '+40.632943', '-074.118669', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3757, '10311', '+40.605245', '-074.179485', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3758, '10312', '+40.545163', '-074.174692', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3759, '10313', '+40.564393', '-074.146836', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3760, '10314', '+40.591006', '-074.150741', 'STATEN ISLAND', 'NY', 'NEW YORK', 'RICHMOND', 'STANDARD'),
(3761, '10451', '+40.819329', '-073.920355', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3762, '10452', '+40.838729', '-073.921605', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3763, '10453', '+40.852728', '-073.912455', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3764, '10454', '+40.807129', '-073.918405', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3765, '10455', '+40.815029', '-073.908355', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3766, '10456', '+40.830529', '-073.908655', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3767, '10457', '+40.846129', '-073.898255', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3768, '10458', '+40.864728', '-073.889855', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3769, '10459', '+40.825629', '-073.893605', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3770, '10460', '+40.841829', '-073.879004', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3771, '10461', '+40.845279', '-073.843103', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3772, '10462', '+40.842729', '-073.854703', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3773, '10463', '+40.879528', '-073.904355', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3774, '10464', '+40.863028', '-073.799802', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3775, '10465', '+40.826879', '-073.825153', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3776, '10466', '+40.859878', '-073.841003', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3777, '10467', '+40.876328', '-073.870404', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3778, '10468', '+40.870978', '-073.900505', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3779, '10469', '+40.869978', '-073.844903', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3780, '10470', '+40.871430', '-073.862303', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3781, '10471', '+40.899178', '-073.898677', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3782, '10472', '+40.829529', '-073.865704', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3783, '10473', '+40.816229', '-073.860304', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3784, '10474', '+40.813929', '-073.884104', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3785, '10475', '+40.874878', '-073.827653', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'STANDARD'),
(3786, '10499', '+40.851549', '-073.840908', 'BRONX', 'NY', 'NEW YORK', 'BRONX', 'UNIQUE'),
(3787, '10501', '+41.293169', '-073.759033', 'AMAWALK', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3788, '10502', '+41.015096', '-073.841478', 'ARDSLEY', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3789, '10503', '+41.025947', '-073.871850', 'ARDSLEY ON HUDSON', 'NY', 'NEW YORK', 'WESTCHESTER', 'PO BOX ONLY'),
(3790, '10504', '+41.075185', '-073.761247', 'ARMONK', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3791, '10505', '+41.334310', '-073.749244', 'BALDWIN PLACE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3792, '10506', '+41.123741', '-073.718481', 'BEDFORD', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3793, '10507', '+41.229037', '-073.697998', 'BEDFORD HILLS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3794, '10509', '+41.415979', '-073.725197', 'BREWSTER', 'NY', 'NEW YORK', 'PUTNAM', 'STANDARD'),
(3795, '10510', '+41.059780', '-073.829802', 'BRIARCLIFF MANOR', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3796, '10511', '+41.259961', '-073.943495', 'BUCHANAN', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3797, '10512', '+41.429571', '-073.777626', 'CARMEL', 'NY', 'NEW YORK', 'PUTNAM', 'STANDARD'),
(3798, '10514', '+41.078957', '-073.775547', 'CHAPPAQUA', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3799, '10516', '+41.455213', '-073.812479', 'COLD SPRING', 'NY', 'NEW YORK', 'PUTNAM', 'STANDARD'),
(3800, '10517', '+41.300561', '-073.861217', 'CROMPOND', 'NY', 'NEW YORK', 'WESTCHESTER', 'PO BOX ONLY'),
(3801, '10518', '+41.269896', '-073.612074', 'CROSS RIVER', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3802, '10519', '+41.347727', '-073.661014', 'CROTON FALLS', 'NY', 'NEW YORK', 'WESTCHESTER', 'PO BOX ONLY'),
(3803, '10520', '+41.122622', '-073.867258', 'CROTON ON HUDSON', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3804, '10521', '+41.234256', '-073.926165', 'CROTON ON HUDSON', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3805, '10522', '+41.011147', '-073.865178', 'DOBBS FERRY', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3806, '10523', '+41.058732', '-073.836784', 'ELMSFORD', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3807, '10524', '+41.375016', '-073.931844', 'GARRISON', 'NY', 'NEW YORK', 'PUTNAM', 'STANDARD'),
(3808, '10526', '+41.300361', '-073.647891', 'GOLDENS BRIDGE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3809, '10527', '+41.323246', '-073.757911', 'GRANITE SPRINGS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3810, '10528', '+40.979118', '-073.723036', 'HARRISON', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3811, '10530', '+41.019105', '-073.812077', 'HARTSDALE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3812, '10532', '+41.013742', '-073.835421', 'HAWTHORNE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3813, '10533', '+41.079553', '-073.856051', 'IRVINGTON', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3814, '10535', '+41.338568', '-073.735548', 'JEFFERSON VALLEY', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3815, '10536', '+41.271614', '-073.687334', 'KATONAH', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3816, '10537', '+41.394819', '-073.718016', 'LAKE PEEKSKILL', 'NY', 'NEW YORK', 'PUTNAM', 'STANDARD'),
(3817, '10538', '+41.090197', '-073.755284', 'LARCHMONT', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3818, '10540', '+41.333398', '-073.724257', 'LINCOLNDALE', 'NY', 'NEW YORK', 'WESTCHESTER', 'PO BOX ONLY'),
(3819, '10541', '+41.412395', '-073.752059', 'MAHOPAC', 'NY', 'NEW YORK', 'PUTNAM', 'STANDARD'),
(3820, '10542', '+41.372581', '-073.760132', 'MAHOPAC FALLS', 'NY', 'NEW YORK', 'PUTNAM', 'PO BOX ONLY'),
(3821, '10543', '+40.949199', '-073.738779', 'MAMARONECK', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3822, '10545', '+41.119008', '-073.732996', 'MARYKNOLL', 'NY', 'NEW YORK', 'WESTCHESTER', 'PO BOX ONLY'),
(3823, '10546', '+41.201373', '-073.796456', 'MILLWOOD', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3824, '10547', '+41.281975', '-073.797555', 'MOHEGAN LAKE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3825, '10548', '+41.251260', '-073.942877', 'MONTROSE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3826, '10549', '+41.197329', '-073.722860', 'MOUNT KISCO', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3827, '10550', '+40.909838', '-073.833890', 'MOUNT VERNON', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3828, '10551', '+41.119008', '-073.732996', 'MOUNT VERNON', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3829, '10552', '+41.011586', '-073.798391', 'MOUNT VERNON', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3830, '10553', '+40.909449', '-073.822109', 'MOUNT VERNON', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3831, '10557', '+41.119008', '-073.732996', 'MOUNT VERNON', 'NY', 'NEW YORK', 'WESTCHESTER', 'UNIQUE'),
(3832, '10558', '+41.119008', '-073.732996', 'MOUNT VERNON', 'NY', 'NEW YORK', 'WESTCHESTER', 'UNIQUE'),
(3833, '10559', '+41.119008', '-073.732996', 'MOUNT VERNON', 'NY', 'NEW YORK', 'WESTCHESTER', 'UNIQUE'),
(3834, '10560', '+41.331814', '-073.608451', 'NORTH SALEM', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3835, '10562', '+41.109701', '-073.827995', 'OSSINING', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3836, '10566', '+41.283830', '-073.893116', 'PEEKSKILL', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3837, '10567', '+41.284044', '-073.893116', 'CORTLANDT MANOR', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3838, '10570', '+41.131069', '-073.792214', 'PLEASANTVILLE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3839, '10571', '+41.119008', '-073.732996', 'PLEASANTVILLE', 'NY', 'NEW YORK', 'WESTCHESTER', 'UNIQUE'),
(3840, '10572', '+41.119008', '-073.732996', 'PLEASANTVILLE', 'NY', 'NEW YORK', 'WESTCHESTER', 'UNIQUE'),
(3841, '10573', '+41.022193', '-073.679799', 'PORT CHESTER', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3842, '10576', '+41.208519', '-073.568126', 'POUND RIDGE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3843, '10577', '+41.002757', '-073.751025', 'PURCHASE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3844, '10578', '+41.315779', '-073.645145', 'PURDYS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3845, '10579', '+41.399262', '-073.776871', 'PUTNAM VALLEY', 'NY', 'NEW YORK', 'PUTNAM', 'STANDARD'),
(3846, '10580', '+40.955237', '-073.744725', 'RYE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3847, '10581', '+41.119008', '-073.732996', 'RYE', 'NY', 'NEW YORK', 'WESTCHESTER', 'UNIQUE'),
(3848, '10583', '+40.992686', '-073.799476', 'SCARSDALE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3849, '10587', '+41.328737', '-073.742268', 'SHENOROCK', 'NY', 'NEW YORK', 'WESTCHESTER', 'PO BOX ONLY'),
(3850, '10588', '+41.330892', '-073.823549', 'SHRUB OAK', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3851, '10589', '+41.326544', '-073.693685', 'SOMERS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3852, '10590', '+41.254331', '-073.542714', 'SOUTH SALEM', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3853, '10591', '+41.089703', '-073.844034', 'TARRYTOWN', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3854, '10592', '+41.119008', '-073.732996', 'TARRYTOWN', 'NY', 'NEW YORK', 'WESTCHESTER', 'UNIQUE'),
(3855, '10594', '+41.117214', '-073.771469', 'THORNWOOD', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3856, '10595', '+41.090218', '-073.784768', 'VALHALLA', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3857, '10596', '+41.254823', '-073.958727', 'VERPLANCK', 'NY', 'NEW YORK', 'WESTCHESTER', 'PO BOX ONLY'),
(3858, '10597', '+41.297198', '-073.597979', 'WACCABUC', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3859, '10598', '+41.287329', '-073.790284', 'YORKTOWN HEIGHTS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3860, '10601', '+41.031397', '-073.769626', 'WHITE PLAINS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3861, '10602', '+41.119008', '-073.732996', 'WHITE PLAINS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3862, '10603', '+41.048958', '-073.783036', 'WHITE PLAINS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3863, '10604', '+41.156215', '-073.805176', 'WEST HARRISON', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3864, '10605', '+41.007597', '-073.748575', 'WHITE PLAINS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3865, '10606', '+41.021686', '-073.766044', 'WHITE PLAINS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3866, '10607', '+41.039235', '-073.807293', 'WHITE PLAINS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3867, '10610', '+41.119008', '-073.732996', 'WHITE PLAINS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3868, '10625', '+41.119008', '-073.732996', 'WHITE PLAINS', 'NY', 'NEW YORK', 'WESTCHESTER', 'UNIQUE'),
(3869, '10629', '+41.119008', '-073.732996', 'WHITE PLAINS', 'NY', 'NEW YORK', 'WESTCHESTER', 'UNIQUE'),
(3870, '10633', '+41.119008', '-073.732996', 'WHITE PLAINS', 'NY', 'NEW YORK', 'WESTCHESTER', 'UNIQUE'),
(3871, '10650', '+41.013696', '-073.705975', 'WHITE PLAINS', 'NY', 'NEW YORK', 'WESTCHESTER', 'UNIQUE'),
(3872, '10701', '+40.946107', '-073.866926', 'YONKERS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3873, '10702', '+41.119008', '-073.732996', 'YONKERS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3874, '10703', '+40.959347', '-073.881329', 'YONKERS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3875, '10704', '+40.922938', '-073.861941', 'YONKERS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3876, '10705', '+40.926538', '-073.872529', 'YONKERS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3877, '10706', '+40.987797', '-073.862969', 'HASTINGS ON HUDSON', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3878, '10707', '+40.960498', '-073.816127', 'TUCKAHOE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3879, '10708', '+40.938448', '-073.829978', 'BRONXVILLE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3880, '10709', '+40.956098', '-073.812177', 'EASTCHESTER', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3881, '10710', '+40.967946', '-073.847360', 'YONKERS', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3882, '10801', '+41.035123', '-073.801401', 'NEW ROCHELLE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3883, '10802', '+40.948274', '-073.795361', 'NEW ROCHELLE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3884, '10803', '+40.904538', '-073.806277', 'PELHAM', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3885, '10804', '+40.951498', '-073.786526', 'NEW ROCHELLE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3886, '10805', '+40.899599', '-073.780976', 'NEW ROCHELLE', 'NY', 'NEW YORK', 'WESTCHESTER', 'STANDARD'),
(3887, '10901', '+41.137295', '-074.105737', 'SUFFERN', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3888, '10910', '+41.386195', '-074.125718', 'ARDEN', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3889, '10911', '+41.160945', '-074.060826', 'BEAR MOUNTAIN', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3890, '10912', '+41.387822', '-074.354699', 'BELLVALE', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3891, '10913', '+41.068782', '-073.957282', 'BLAUVELT', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3892, '10914', '+41.464867', '-074.255646', 'BLOOMING GROVE', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3893, '10915', '+41.555634', '-074.328805', 'BULLVILLE', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3894, '10916', '+41.443168', '-074.258172', 'CAMPBELL HALL', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3895, '10917', '+41.329224', '-074.121764', 'CENTRAL VALLEY', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3896, '10918', '+41.414188', '-074.348151', 'CHESTER', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3897, '10919', '+41.531560', '-074.370569', 'CIRCLEVILLE', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3898, '10920', '+41.152545', '-073.936305', 'CONGERS', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3899, '10921', '+41.319956', '-074.366990', 'FLORIDA', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3900, '10922', '+41.334557', '-073.991750', 'FORT MONTGOMERY', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3901, '10923', '+41.203984', '-074.003167', 'GARNERVILLE', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3902, '10924', '+41.357428', '-074.210608', 'GOSHEN', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3903, '10925', '+41.297325', '-074.264840', 'GREENWOOD LAKE', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3904, '10926', '+41.300486', '-074.124934', 'HARRIMAN', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3905, '10927', '+41.191694', '-073.964933', 'HAVERSTRAW', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3906, '10928', '+41.398883', '-074.255846', 'HIGHLAND FALLS', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3907, '10930', '+41.372924', '-074.245108', 'HIGHLAND MILLS', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3908, '10931', '+41.120195', '-074.170639', 'HILLBURN', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3909, '10932', '+41.485227', '-074.484249', 'HOWELLS', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3910, '10933', '+41.365286', '-074.510918', 'JOHNSON', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3911, '10940', '+41.390109', '-074.340401', 'MIDDLETOWN', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3912, '10941', '+41.370586', '-074.354017', 'MIDDLETOWN', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3913, '10943', '+41.387822', '-074.354699', 'MIDDLETOWN', 'NY', 'NEW YORK', 'ORANGE', 'UNIQUE'),
(3914, '10950', '+41.343092', '-074.316824', 'MONROE', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3915, '10952', '+41.118595', '-074.084536', 'MONSEY', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3916, '10953', '+41.409284', '-074.083045', 'MOUNTAINVILLE', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3917, '10954', '+41.097716', '-074.010934', 'NANUET', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3918, '10956', '+41.149494', '-073.988270', 'NEW CITY', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3919, '10958', '+41.375634', '-074.433750', 'NEW HAMPTON', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3920, '10959', '+41.387822', '-074.354699', 'NEW MILFORD', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3921, '10960', '+41.080474', '-073.930179', 'NYACK', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3922, '10962', '+41.057496', '-073.953181', 'ORANGEBURG', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3923, '10963', '+41.401702', '-074.536702', 'OTISVILLE', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3924, '10964', '+41.008947', '-073.920930', 'PALISADES', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3925, '10965', '+41.061476', '-074.018283', 'PEARL RIVER', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3926, '10968', '+41.040946', '-073.918205', 'PIERMONT', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3927, '10969', '+41.325856', '-074.488954', 'PINE ISLAND', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3928, '10970', '+41.184160', '-074.045358', 'POMONA', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3929, '10973', '+41.386099', '-074.480395', 'SLATE HILL', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3930, '10974', '+41.157473', '-074.200784', 'SLOATSBURG', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3931, '10975', '+41.332379', '-074.113857', 'SOUTHFIELDS', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3932, '10976', '+41.083784', '-074.061335', 'SPARKILL', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3933, '10977', '+41.115833', '-074.047384', 'SPRING VALLEY', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3934, '10979', '+41.182344', '-074.318354', 'STERLING FOREST', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3935, '10980', '+41.235675', '-074.028095', 'STONY POINT', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3936, '10981', '+41.323172', '-074.288565', 'SUGAR LOAF', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3937, '10982', '+41.160945', '-074.060826', 'TALLMAN', 'NY', 'NEW YORK', 'ROCKLAND', 'PO BOX ONLY'),
(3938, '10983', '+41.027646', '-073.948404', 'TAPPAN', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3939, '10984', '+41.206898', '-074.015411', 'THIELLS', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3940, '10985', '+41.574986', '-074.322534', 'THOMPSON RIDGE', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3941, '10986', '+41.265953', '-073.982912', 'TOMKINS COVE', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3942, '10987', '+41.281420', '-074.204924', 'TUXEDO PARK', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3943, '10988', '+41.314931', '-074.550346', 'UNIONVILLE', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(3944, '10989', '+41.122868', '-073.934844', 'VALLEY COTTAGE', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3945, '10990', '+41.350681', '-074.321160', 'WARWICK', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3946, '10992', '+41.407974', '-074.345433', 'WASHINGTONVILLE', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3947, '10993', '+41.208044', '-073.975833', 'WEST HAVERSTRAW', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3948, '10994', '+41.100622', '-073.970482', 'WEST NYACK', 'NY', 'NEW YORK', 'ROCKLAND', 'STANDARD'),
(3949, '10995', '+41.160945', '-074.060826', 'WEST NYACK', 'NY', 'NEW YORK', 'ROCKLAND', 'UNIQUE'),
(3950, '10996', '+41.364710', '-073.998375', 'WEST POINT', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3951, '10997', '+41.387822', '-074.354699', 'WEST POINT', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3952, '10998', '+41.331044', '-074.456673', 'WESTTOWN', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(3953, '11001', '+40.720051', '-073.706783', 'FLORAL PARK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3954, '11002', '+40.754757', '-073.601772', 'FLORAL PARK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3955, '11003', '+40.697558', '-073.704946', 'ELMONT', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3956, '11004', '+40.745263', '-073.711159', 'GLEN OAKS', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(3957, '11005', '+40.757057', '-073.718200', 'FLORAL PARK', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(3958, '11010', '+40.700101', '-073.674074', 'FRANKLIN SQUARE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3959, '11020', '+40.754757', '-073.601772', 'GREAT NECK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3960, '11021', '+40.754757', '-073.601772', 'GREAT NECK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3961, '11022', '+40.754757', '-073.601772', 'GREAT NECK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3962, '11023', '+40.754757', '-073.601772', 'GREAT NECK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3963, '11024', '+40.754757', '-073.601772', 'GREAT NECK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3964, '11025', '+40.754757', '-073.601772', 'GREAT NECK', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(3965, '11026', '+40.754757', '-073.601772', 'GREAT NECK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3966, '11027', '+40.754757', '-073.601772', 'GREAT NECK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3967, '11030', '+40.754757', '-073.601772', 'MANHASSET', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3968, '11040', '+40.729351', '-073.682824', 'NEW HYDE PARK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3969, '11041', '+40.754757', '-073.601772', 'NEW HYDE PARK', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(3970, '11042', '+40.754757', '-073.601772', 'NEW HYDE PARK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3971, '11043', '+40.754757', '-073.601772', 'NEW HYDE PARK', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(3972, '11044', '+40.754757', '-073.601772', 'NEW HYDE PARK', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(3973, '11050', '+40.754757', '-073.601772', 'PORT WASHINGTON', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3974, '11051', '+40.754757', '-073.601772', 'PORT WASHINGTON', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(3975, '11052', '+40.754757', '-073.601772', 'PORT WASHINGTON', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(3976, '11053', '+40.754757', '-073.601772', 'PORT WASHINGTON', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(3977, '11054', '+40.754757', '-073.601772', 'PORT WASHINGTON', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(3978, '11055', '+40.754757', '-073.601772', 'PORT WASHINGTON', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(3979, '11096', '+40.620492', '-073.747376', 'INWOOD', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(3980, '11099', '+40.754757', '-073.601772', 'NEW HYDE PARK', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(3981, '11101', '+40.744622', '-073.934502', 'LONG ISLAND CITY', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(3982, '11102', '+40.770808', '-073.925160', 'ASTORIA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(3983, '11103', '+40.761884', '-073.911642', 'ASTORIA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(3984, '11104', '+40.742794', '-073.918216', 'SUNNYSIDE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(3985, '11105', '+40.776468', '-073.908761', 'ASTORIA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(3986, '11106', '+40.760601', '-073.930984', 'ASTORIA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(3987, '11109', '+40.651378', '-073.870779', 'LONG ISLAND CITY', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(3988, '11120', '+40.651378', '-073.870779', 'LONG ISLAND CITY', 'NY', 'NEW YORK', 'QUEENS', 'UNIQUE'),
(3989, '11201', '+40.694481', '-073.989319', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(3990, '11202', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(3991, '11203', '+40.663551', '-073.949389', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(3992, '11204', '+40.603838', '-073.987635', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(3993, '11205', '+40.682507', '-073.936274', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(3994, '11206', '+40.700453', '-073.949255', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(3995, '11207', '+40.670925', '-073.895216', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(3996, '11208', '+40.662195', '-073.912945', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(3997, '11209', '+40.622459', '-074.028749', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(3998, '11210', '+40.625468', '-073.945521', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(3999, '11211', '+40.707789', '-073.945344', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4000, '11212', '+40.663845', '-073.916406', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4001, '11213', '+40.673170', '-073.936055', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4002, '11214', '+40.599523', '-073.998594', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4003, '11215', '+40.664322', '-073.984132', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4004, '11216', '+40.680474', '-073.946829', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4005, '11217', '+40.684948', '-073.980613', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4006, '11218', '+40.644340', '-073.978411', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4007, '11219', '+40.633157', '-073.996953', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4008, '11220', '+40.634873', '-074.016905', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4009, '11221', '+40.700418', '-073.936764', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4010, '11222', '+40.728388', '-073.945754', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4011, '11223', '+40.633801', '-073.954405', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4012, '11224', '+40.635444', '-073.968536', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4013, '11225', '+40.661096', '-073.952295', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4014, '11226', '+40.644962', '-073.956304', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4015, '11228', '+40.624552', '-073.989853', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4016, '11229', '+40.600988', '-073.939998', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4017, '11230', '+40.622510', '-073.966109', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4018, '11231', '+40.676521', '-074.003322', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4019, '11232', '+40.671186', '-073.971708', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4020, '11233', '+40.682088', '-073.920638', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4021, '11234', '+40.610947', '-073.913892', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4022, '11235', '+40.584455', '-073.948402', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4023, '11236', '+40.657010', '-073.915810', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4024, '11237', '+40.702192', '-073.918070', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4025, '11238', '+40.680593', '-073.963928', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4026, '11239', '+40.649207', '-073.876754', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4027, '11240', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4028, '11241', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4029, '11242', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4030, '11243', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4031, '11244', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'UNIQUE'),
(4032, '11245', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'UNIQUE'),
(4033, '11247', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4034, '11248', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'UNIQUE'),
(4035, '11249', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4036, '11251', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'UNIQUE'),
(4037, '11252', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4038, '11254', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'UNIQUE'),
(4039, '11255', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'UNIQUE'),
(4040, '11256', '+40.645099', '-073.945032', 'BROOKLYN', 'NY', 'NEW YORK', 'KINGS', 'STANDARD'),
(4041, '11351', '+40.781703', '-073.831698', 'FLUSHING', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4042, '11352', '+40.651378', '-073.870779', 'FLUSHING', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4043, '11354', '+40.766382', '-073.826190', 'FLUSHING', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4044, '11355', '+40.750317', '-073.813903', 'FLUSHING', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4045, '11356', '+40.784369', '-073.843641', 'COLLEGE POINT', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4046, '11357', '+40.786173', '-073.819069', 'WHITESTONE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4047, '11358', '+40.760426', '-073.795788', 'FLUSHING', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4048, '11359', '+40.792780', '-073.776701', 'BAYSIDE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4049, '11360', '+40.756745', '-073.803301', 'BAYSIDE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4050, '11361', '+40.764438', '-073.773026', 'BAYSIDE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4051, '11362', '+40.758364', '-073.735759', 'LITTLE NECK', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4052, '11363', '+40.771467', '-073.745323', 'LITTLE NECK', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4053, '11364', '+40.742772', '-073.758831', 'OAKLAND GARDENS', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4054, '11365', '+40.738884', '-073.790067', 'FRESH MEADOWS', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4055, '11366', '+40.727277', '-073.790772', 'FRESH MEADOWS', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4056, '11367', '+40.730164', '-073.821997', 'FLUSHING', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4057, '11368', '+40.748751', '-073.854333', 'CORONA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4058, '11369', '+40.762741', '-073.869969', 'EAST ELMHURST', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4059, '11370', '+40.763771', '-073.891451', 'EAST ELMHURST', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4060, '11371', '+40.771200', '-073.867514', 'FLUSHING', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(4061, '11372', '+40.751146', '-073.882508', 'JACKSON HEIGHTS', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4062, '11373', '+40.735090', '-073.877562', 'ELMHURST', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4063, '11374', '+40.722861', '-073.862069', 'REGO PARK', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4064, '11375', '+40.723041', '-073.843688', 'FOREST HILLS', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4065, '11377', '+40.748372', '-073.905445', 'WOODSIDE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4066, '11378', '+40.722848', '-073.908413', 'MASPETH', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4067, '11379', '+40.719240', '-073.892791', 'MIDDLE VILLAGE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4068, '11380', '+40.651378', '-073.870779', 'ELMHURST', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4069, '11381', '+40.651378', '-073.870779', 'FLUSHING', 'NY', 'NEW YORK', 'QUEENS', 'UNIQUE'),
(4070, '11385', '+40.702404', '-073.885979', 'RIDGEWOOD', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4071, '11386', '+40.651378', '-073.870779', 'RIDGEWOOD', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4072, '11390', '+40.651378', '-073.870779', 'FLUSHING', 'NY', 'NEW YORK', 'QUEENS', 'UNIQUE'),
(4073, '11405', '+40.651378', '-073.870779', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'UNIQUE'),
(4074, '11411', '+40.685535', '-073.737064', 'CAMBRIA HEIGHTS', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4075, '11412', '+40.695829', '-073.761747', 'SAINT ALBANS', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4076, '11413', '+40.664542', '-073.755926', 'SPRINGFIELD GARDENS', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4077, '11414', '+40.658825', '-073.843820', 'HOWARD BEACH', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4078, '11415', '+40.707133', '-073.829247', 'KEW GARDENS', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4079, '11416', '+40.684546', '-073.850708', 'OZONE PARK', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4080, '11417', '+40.675056', '-073.844315', 'OZONE PARK', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4081, '11418', '+40.698566', '-073.831270', 'RICHMOND HILL', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4082, '11419', '+40.686769', '-073.822979', 'SOUTH RICHMOND HILL', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4083, '11420', '+40.674432', '-073.819013', 'SOUTH OZONE PARK', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4084, '11421', '+40.691917', '-073.856660', 'WOODHAVEN', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4085, '11422', '+40.659418', '-073.736866', 'ROSEDALE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4086, '11423', '+40.716888', '-073.766897', 'HOLLIS', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4087, '11424', '+40.651378', '-073.870779', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4088, '11425', '+40.651378', '-073.870779', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'UNIQUE'),
(4089, '11426', '+40.736798', '-073.723176', 'BELLEROSE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4090, '11427', '+40.729293', '-073.749811', 'QUEENS VILLAGE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4091, '11428', '+40.720639', '-073.742099', 'QUEENS VILLAGE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4092, '11429', '+40.710076', '-073.740151', 'QUEENS VILLAGE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4093, '11430', '+40.655246', '-073.797769', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4094, '11431', '+40.686903', '-073.850143', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4095, '11432', '+40.714531', '-073.794435', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4096, '11433', '+40.696533', '-073.786776', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4097, '11434', '+40.674583', '-073.781560', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4098, '11435', '+40.700229', '-073.797278', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4099, '11436', '+40.675283', '-073.800696', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4100, '11439', '+40.722008', '-073.790822', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'UNIQUE'),
(4101, '11451', '+40.651378', '-073.870779', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'UNIQUE'),
(4102, '11484', '+40.651378', '-073.870779', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'UNIQUE'),
(4103, '11499', '+40.651378', '-073.870779', 'JAMAICA', 'NY', 'NEW YORK', 'QUEENS', 'UNIQUE'),
(4104, '11501', '+40.735901', '-073.638061', 'MINEOLA', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4105, '11507', '+40.754757', '-073.601772', 'ALBERTSON', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4106, '11509', '+40.588854', '-073.727090', 'ATLANTIC BEACH', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4107, '11510', '+40.654626', '-073.608972', 'BALDWIN', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4108, '11514', '+40.744350', '-073.608422', 'CARLE PLACE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4109, '11516', '+40.626453', '-073.725825', 'CEDARHURST', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4110, '11518', '+40.640387', '-073.668224', 'EAST ROCKAWAY', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4111, '11520', '+40.651251', '-073.585222', 'FREEPORT', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4112, '11530', '+40.726801', '-073.639723', 'GARDEN CITY', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4113, '11531', '+40.754757', '-073.601772', 'GARDEN CITY', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4114, '11535', '+40.754757', '-073.601772', 'GARDEN CITY', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4115, '11536', '+40.754757', '-073.601772', 'GARDEN CITY', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4116, '11542', '+40.754757', '-073.601772', 'GLEN COVE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4117, '11545', '+40.754757', '-073.601772', 'GLEN HEAD', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4118, '11547', '+40.754757', '-073.601772', 'GLENWOOD LANDING', 'NY', 'NEW YORK', 'NASSAU', 'PO BOX ONLY'),
(4119, '11548', '+40.754757', '-073.601772', 'GREENVALE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4120, '11549', '+40.754757', '-073.601772', 'HEMPSTEAD', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4121, '11550', '+40.700201', '-073.620872', 'HEMPSTEAD', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4122, '11551', '+40.754757', '-073.601772', 'HEMPSTEAD', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4123, '11552', '+40.690251', '-073.653023', 'WEST HEMPSTEAD', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4124, '11553', '+40.705868', '-073.591421', 'UNIONDALE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4125, '11554', '+40.721350', '-073.558770', 'EAST MEADOW', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4126, '11555', '+40.754757', '-073.601772', 'UNIONDALE', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4127, '11556', '+40.754757', '-073.601772', 'UNIONDALE', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4128, '11557', '+40.638803', '-073.693274', 'HEWLETT', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4129, '11558', '+40.606953', '-073.654724', 'ISLAND PARK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4130, '11559', '+40.615435', '-073.726420', 'LAWRENCE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4131, '11560', '+40.754757', '-073.601772', 'LOCUST VALLEY', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4132, '11561', '+40.589139', '-073.642323', 'LONG BEACH', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4133, '11563', '+40.657602', '-073.672574', 'LYNBROOK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4134, '11564', '+40.754757', '-073.601772', 'LYNBROOK', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4135, '11565', '+40.674652', '-073.673324', 'MALVERNE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4136, '11566', '+40.668501', '-073.553628', 'MERRICK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4137, '11568', '+40.754757', '-073.601772', 'OLD WESTBURY', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4138, '11569', '+40.590503', '-073.580822', 'POINT LOOKOUT', 'NY', 'NEW YORK', 'NASSAU', 'PO BOX ONLY'),
(4139, '11570', '+40.667352', '-073.638523', 'ROCKVILLE CENTRE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4140, '11571', '+40.754757', '-073.601772', 'ROCKVILLE CENTRE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4141, '11572', '+40.635252', '-073.636923', 'OCEANSIDE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4142, '11575', '+40.680451', '-073.590071', 'ROOSEVELT', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4143, '11576', '+40.656802', '-073.622523', 'ROSLYN', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4144, '11577', '+40.754757', '-073.601772', 'ROSLYN HEIGHTS', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4145, '11579', '+40.754757', '-073.601772', 'SEA CLIFF', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4146, '11580', '+40.676052', '-073.697828', 'VALLEY STREAM', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4147, '11581', '+40.652253', '-073.711775', 'VALLEY STREAM', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4148, '11582', '+40.754757', '-073.601772', 'VALLEY STREAM', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4149, '11583', '+40.754757', '-073.601772', 'VALLEY STREAM', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4150, '11588', '+40.754757', '-073.601772', 'UNIONDALE', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4151, '11590', '+40.745050', '-073.571521', 'WESTBURY', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4152, '11592', '+40.621753', '-073.632673', 'ROCKVILLE CENTRE', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4153, '11593', '+40.754757', '-073.601772', 'WESTBURY', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4154, '11594', '+40.754757', '-073.601772', 'WESTBURY', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4155, '11595', '+40.754757', '-073.601772', 'WESTBURY', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4156, '11596', '+40.754757', '-073.601772', 'WILLISTON PARK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4157, '11597', '+40.754757', '-073.601772', 'WESTBURY', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4158, '11598', '+40.633103', '-073.712025', 'WOODMERE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4159, '11599', '+40.607574', '-073.742691', 'GARDEN CITY', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4160, '11690', '+40.651378', '-073.870779', 'FAR ROCKAWAY', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4161, '11691', '+40.601475', '-073.761910', 'FAR ROCKAWAY', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4162, '11692', '+40.592300', '-073.793273', 'ARVERNE', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4163, '11693', '+40.598460', '-073.814270', 'FAR ROCKAWAY', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4164, '11694', '+40.576610', '-073.842760', 'ROCKAWAY PARK', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4165, '11695', '+40.651378', '-073.870779', 'FAR ROCKAWAY', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4166, '11697', '+40.559365', '-073.906713', 'BREEZY POINT', 'NY', 'NEW YORK', 'QUEENS', 'STANDARD'),
(4167, '11701', '+40.686249', '-073.411866', 'AMITYVILLE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4168, '11702', '+40.664150', '-073.340984', 'BABYLON', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4169, '11703', '+40.732348', '-073.325363', 'NORTH BABYLON', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4170, '11704', '+40.709098', '-073.356164', 'WEST BABYLON', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4171, '11705', '+40.748364', '-073.057026', 'BAYPORT', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4172, '11706', '+40.705138', '-073.243004', 'BAY SHORE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4173, '11707', '+40.922326', '-072.637078', 'WEST BABYLON', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4174, '11708', '+40.922326', '-072.637078', 'AMITYVILLE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4175, '11709', '+40.754757', '-073.601772', 'BAYVILLE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4176, '11710', '+40.672900', '-073.536520', 'BELLMORE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4177, '11713', '+40.922326', '-072.637078', 'BELLPORT', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4178, '11714', '+40.728449', '-073.495369', 'BETHPAGE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4179, '11715', '+40.756730', '-073.043481', 'BLUE POINT', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4180, '11716', '+40.769020', '-073.113366', 'BOHEMIA', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4181, '11717', '+40.780882', '-073.250336', 'BRENTWOOD', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4182, '11718', '+40.715424', '-073.260912', 'BRIGHTWATERS', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4183, '11719', '+40.922326', '-072.637078', 'BROOKHAVEN', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4184, '11720', '+40.922326', '-072.637078', 'CENTEREACH', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4185, '11721', '+40.893197', '-073.370462', 'CENTERPORT', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4186, '11722', '+40.781930', '-073.196148', 'CENTRAL ISLIP', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4187, '11724', '+40.860098', '-073.442315', 'COLD SPRING HARBOR', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4188, '11725', '+40.842247', '-073.280935', 'COMMACK', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4189, '11726', '+40.680220', '-073.394762', 'COPIAGUE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4190, '11727', '+40.922326', '-072.637078', 'CORAM', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4191, '11729', '+40.762574', '-073.323061', 'DEER PARK', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4192, '11730', '+40.724146', '-073.175926', 'EAST ISLIP', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4193, '11731', '+40.856997', '-073.314561', 'EAST NORTHPORT', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4194, '11732', '+40.754757', '-073.601772', 'EAST NORWICH', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4195, '11733', '+40.922326', '-072.637078', 'EAST SETAUKET', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4196, '11735', '+40.754757', '-073.601772', 'FARMINGDALE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4197, '11736', '+40.754757', '-073.601772', 'FARMINGDALE', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4198, '11737', '+40.754757', '-073.601772', 'FARMINGDALE', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4199, '11738', '+40.922326', '-072.637078', 'FARMINGVILLE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4200, '11739', '+40.922326', '-072.637078', 'GREAT RIVER', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4201, '11740', '+40.866948', '-073.362512', 'GREENLAWN', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4202, '11741', '+40.787910', '-073.066689', 'HOLBROOK', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4203, '11742', '+40.798994', '-073.048985', 'HOLTSVILLE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4204, '11743', '+40.867647', '-073.410218', 'HUNTINGTON', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4205, '11745', '+40.922326', '-072.637078', 'SMITHTOWN', 'NY', 'NEW YORK', 'SUFFOLK', 'UNIQUE'),
(4206, '11746', '+40.814348', '-073.363363', 'HUNTINGTON STATION', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4207, '11747', '+40.787248', '-073.405573', 'MELVILLE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4208, '11749', '+40.922326', '-072.637078', 'ISLANDIA', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4209, '11750', '+40.922326', '-072.637078', 'HUNTINGTON STATION', 'NY', 'NEW YORK', 'SUFFOLK', 'UNIQUE'),
(4210, '11751', '+40.728130', '-073.217871', 'ISLIP', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4211, '11752', '+40.757226', '-073.182854', 'ISLIP TERRACE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4212, '11753', '+40.754757', '-073.601772', 'JERICHO', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4213, '11754', '+40.803230', '-073.304850', 'KINGS PARK', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4214, '11755', '+40.851850', '-073.129003', 'LAKE GROVE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4215, '11756', '+40.722800', '-073.515819', 'LEVITTOWN', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4216, '11757', '+40.688799', '-073.376475', 'LINDENHURST', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4217, '11758', '+40.754757', '-073.601772', 'MASSAPEQUA', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4218, '11760', '+40.810246', '-073.191789', 'ISLANDIA', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4219, '11762', '+40.754757', '-073.601772', 'MASSAPEQUA PARK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4220, '11763', '+40.922326', '-072.637078', 'MEDFORD', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4221, '11764', '+40.922326', '-072.637078', 'MILLER PLACE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4222, '11765', '+40.754757', '-073.601772', 'MILL NECK', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4223, '11766', '+40.922326', '-072.637078', 'MOUNT SINAI', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4224, '11767', '+40.846678', '-073.146763', 'NESCONSET', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4225, '11768', '+40.914289', '-073.332680', 'NORTHPORT', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4226, '11769', '+40.738322', '-073.131797', 'OAKDALE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4227, '11770', '+40.644344', '-073.161286', 'OCEAN BEACH', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4228, '11771', '+40.754757', '-073.601772', 'OYSTER BAY', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4229, '11772', '+40.922326', '-072.637078', 'PATCHOGUE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4230, '11773', '+40.754757', '-073.601772', 'SYOSSET', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4231, '11774', '+40.754757', '-073.601772', 'FARMINGDALE', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4232, '11775', '+40.922326', '-072.637078', 'MELVILLE', 'NY', 'NEW YORK', 'SUFFOLK', 'UNIQUE'),
(4233, '11776', '+40.922326', '-072.637078', 'PORT JEFFERSON STATION', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4234, '11777', '+40.922326', '-072.637078', 'PORT JEFFERSON', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4235, '11778', '+40.922326', '-072.637078', 'ROCKY POINT', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4236, '11779', '+40.808322', '-073.130469', 'RONKONKOMA', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4237, '11780', '+40.889314', '-073.174435', 'SAINT JAMES', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4238, '11782', '+40.745866', '-073.085858', 'SAYVILLE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4239, '11783', '+40.683897', '-073.496169', 'SEAFORD', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4240, '11784', '+40.922326', '-072.637078', 'SELDEN', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4241, '11786', '+40.922326', '-072.637078', 'SHOREHAM', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4242, '11787', '+40.856793', '-073.208278', 'SMITHTOWN', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4243, '11788', '+40.819074', '-073.212200', 'HAUPPAUGE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4244, '11789', '+40.922326', '-072.637078', 'SOUND BEACH', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4245, '11790', '+40.901290', '-073.182803', 'STONY BROOK', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4246, '11791', '+40.754757', '-073.601772', 'SYOSSET', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4247, '11792', '+40.922326', '-072.637078', 'WADING RIVER', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4248, '11793', '+40.678150', '-073.509519', 'WANTAGH', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4249, '11794', '+40.922326', '-072.637078', 'STONY BROOK', 'NY', 'NEW YORK', 'SUFFOLK', 'UNIQUE'),
(4250, '11795', '+40.699825', '-073.290905', 'WEST ISLIP', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4251, '11796', '+40.732304', '-073.100020', 'WEST SAYVILLE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4252, '11797', '+40.754757', '-073.601772', 'WOODBURY', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4253, '11798', '+40.734170', '-073.351354', 'WYANDANCH', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4254, '11801', '+40.754757', '-073.601772', 'HICKSVILLE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4255, '11802', '+40.754757', '-073.601772', 'HICKSVILLE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4256, '11803', '+40.754757', '-073.601772', 'PLAINVIEW', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4257, '11804', '+40.754757', '-073.601772', 'OLD BETHPAGE', 'NY', 'NEW YORK', 'NASSAU', 'STANDARD'),
(4258, '11805', '+40.922326', '-072.637078', 'MID ISLAND', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4259, '11815', '+40.754757', '-073.601772', 'HICKSVILLE', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4260, '11819', '+40.754757', '-073.601772', 'HICKSVILLE', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4261, '11853', '+40.754757', '-073.601772', 'JERICHO', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4262, '11854', '+40.754757', '-073.601772', 'HICKSVILLE', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4263, '11855', '+40.754757', '-073.601772', 'HICKSVILLE', 'NY', 'NEW YORK', 'NASSAU', 'UNIQUE'),
(4264, '11901', '+40.922326', '-072.637078', 'RIVERHEAD', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4265, '11930', '+40.922326', '-072.637078', 'AMAGANSETT', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4266, '11931', '+40.922326', '-072.637078', 'AQUEBOGUE', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4267, '11932', '+40.922326', '-072.637078', 'BRIDGEHAMPTON', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4268, '11933', '+40.922326', '-072.637078', 'CALVERTON', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4269, '11934', '+40.922326', '-072.637078', 'CENTER MORICHES', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4270, '11935', '+40.922326', '-072.637078', 'CUTCHOGUE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4271, '11937', '+40.922326', '-072.637078', 'EAST HAMPTON', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4272, '11939', '+40.922326', '-072.637078', 'EAST MARION', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4273, '11940', '+40.922326', '-072.637078', 'EAST MORICHES', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4274, '11941', '+40.922326', '-072.637078', 'EASTPORT', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4275, '11942', '+40.922326', '-072.637078', 'EAST QUOGUE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4276, '11944', '+40.922326', '-072.637078', 'GREENPORT', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4277, '11946', '+40.922326', '-072.637078', 'HAMPTON BAYS', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4278, '11947', '+40.922326', '-072.637078', 'JAMESPORT', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4279, '11948', '+40.922326', '-072.637078', 'LAUREL', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4280, '11949', '+40.922326', '-072.637078', 'MANORVILLE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4281, '11950', '+40.922326', '-072.637078', 'MASTIC', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4282, '11951', '+40.922326', '-072.637078', 'MASTIC BEACH', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4283, '11952', '+40.922326', '-072.637078', 'MATTITUCK', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4284, '11953', '+40.922326', '-072.637078', 'MIDDLE ISLAND', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4285, '11954', '+40.922326', '-072.637078', 'MONTAUK', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4286, '11955', '+40.922326', '-072.637078', 'MORICHES', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4287, '11956', '+40.922326', '-072.637078', 'NEW SUFFOLK', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4288, '11957', '+40.922326', '-072.637078', 'ORIENT', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4289, '11958', '+40.922326', '-072.637078', 'PECONIC', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4290, '11959', '+40.922326', '-072.637078', 'QUOGUE', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4291, '11960', '+40.922326', '-072.637078', 'REMSENBURG', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4292, '11961', '+40.922326', '-072.637078', 'RIDGE', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4293, '11962', '+40.922326', '-072.637078', 'SAGAPONACK', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4294, '11963', '+40.922326', '-072.637078', 'SAG HARBOR', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4295, '11964', '+40.922326', '-072.637078', 'SHELTER ISLAND', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4296, '11965', '+40.922326', '-072.637078', 'SHELTER ISLAND HEIGHTS', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4297, '11967', '+40.922326', '-072.637078', 'SHIRLEY', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4298, '11968', '+40.922326', '-072.637078', 'SOUTHAMPTON', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4299, '11969', '+40.922326', '-072.637078', 'SOUTHAMPTON', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4300, '11970', '+40.922326', '-072.637078', 'SOUTH JAMESPORT', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4301, '11971', '+40.922326', '-072.637078', 'SOUTHOLD', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4302, '11972', '+40.922326', '-072.637078', 'SPEONK', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4303, '11973', '+40.922326', '-072.637078', 'UPTON', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4304, '11975', '+40.922326', '-072.637078', 'WAINSCOTT', 'NY', 'NEW YORK', 'SUFFOLK', 'PO BOX ONLY'),
(4305, '11976', '+40.922326', '-072.637078', 'WATER MILL', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4306, '11977', '+40.922326', '-072.637078', 'WESTHAMPTON', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4307, '11978', '+40.922326', '-072.637078', 'WESTHAMPTON BEACH', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4308, '11980', '+40.922326', '-072.637078', 'YAPHANK', 'NY', 'NEW YORK', 'SUFFOLK', 'STANDARD'),
(4309, '12007', '+42.482455', '-073.936671', 'ALCOVE', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4310, '12008', '+42.859176', '-073.902117', 'ALPLAUS', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4311, '12009', '+42.688731', '-074.030596', 'ALTAMONT', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4312, '12010', '+42.906298', '-074.229042', 'AMSTERDAM', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(4313, '12015', '+42.280040', '-073.837035', 'ATHENS', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4314, '12016', '+42.910206', '-074.423606', 'AURIESVILLE', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(4315, '12017', '+42.309805', '-073.565617', 'AUSTERLITZ', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4316, '12018', '+42.670645', '-073.551420', 'AVERILL PARK', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4317, '12019', '+42.934416', '-073.848971', 'BALLSTON LAKE', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4318, '12020', '+42.983588', '-073.882538', 'BALLSTON SPA', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4319, '12022', '+42.670510', '-073.357825', 'BERLIN', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4320, '12023', '+42.602236', '-074.154615', 'BERNE', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4321, '12024', '+42.494981', '-073.510676', 'BRAINARD', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4322, '12025', '+43.082793', '-074.160753', 'BROADALBIN', 'NY', 'NEW YORK', 'FULTON', 'STANDARD'),
(4323, '12027', '+42.923676', '-073.911768', 'BURNT HILLS', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4324, '12028', '+42.851332', '-073.454055', 'BUSKIRK', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4325, '12029', '+42.357057', '-073.448944', 'CANAAN', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4326, '12031', '+42.592287', '-074.438129', 'CARLISLE', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4327, '12032', '+43.155660', '-074.494888', 'CAROGA LAKE', 'NY', 'NEW YORK', 'FULTON', 'STANDARD'),
(4328, '12033', '+42.589158', '-073.565925', 'CASTLETON ON HUDSON', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4329, '12035', '+42.721081', '-074.382064', 'CENTRAL BRIDGE', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4330, '12036', '+42.541025', '-074.655395', 'CHARLOTTEVILLE', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4331, '12037', '+42.335777', '-073.528651', 'CHATHAM', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4332, '12040', '+42.646742', '-073.371611', 'CHERRY PLAIN', 'NY', 'NEW YORK', 'RENSSELAER', 'PO BOX ONLY'),
(4333, '12041', '+42.561988', '-073.957345', 'CLARKSVILLE', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4334, '12042', '+42.411207', '-073.927573', 'CLIMAX', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4335, '12043', '+42.665376', '-074.518840', 'COBLESKILL', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4336, '12045', '+42.475704', '-073.797722', 'COEYMANS', 'NY', 'NEW YORK', 'ALBANY', 'PO BOX ONLY'),
(4337, '12046', '+42.492791', '-073.928403', 'COEYMANS HOLLOW', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4338, '12047', '+42.647039', '-073.739349', 'COHOES', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4339, '12050', '+42.317154', '-073.748555', 'COLUMBIAVILLE', 'NY', 'NEW YORK', 'COLUMBIA', 'PO BOX ONLY'),
(4340, '12051', '+42.355924', '-073.847967', 'COXSACKIE', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4341, '12052', '+42.670318', '-073.549377', 'CROPSEYVILLE', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4342, '12053', '+42.777880', '-074.197936', 'DELANSON', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4343, '12054', '+42.605467', '-073.875700', 'DELMAR', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4344, '12055', '+42.614852', '-073.970812', 'DORMANSVILLE', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4345, '12056', '+42.770065', '-074.085963', 'DUANESBURG', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4346, '12057', '+42.980783', '-073.352206', 'EAGLE BRIDGE', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4347, '12058', '+42.352969', '-073.905306', 'EARLTON', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4348, '12059', '+42.618248', '-074.028108', 'EAST BERNE', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4349, '12060', '+42.419964', '-073.512815', 'EAST CHATHAM', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4350, '12061', '+42.570352', '-073.655682', 'EAST GREENBUSH', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4351, '12062', '+42.537218', '-073.503877', 'EAST NASSAU', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4352, '12063', '+42.563685', '-073.627428', 'EAST SCHODACK', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4353, '12064', '+42.632058', '-074.667368', 'EAST WORCESTER', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(4354, '12065', '+42.850576', '-073.792524', 'CLIFTON PARK', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4355, '12066', '+42.801547', '-074.342884', 'ESPERANCE', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(4356, '12067', '+42.555446', '-073.913714', 'FEURA BUSH', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4357, '12068', '+42.940975', '-074.391459', 'FONDA', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(4358, '12069', '+42.945701', '-074.263312', 'FORT HUNTER', 'NY', 'NEW YORK', 'MONTGOMERY', 'PO BOX ONLY'),
(4359, '12070', '+42.969738', '-074.292476', 'FORT JOHNSON', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(4360, '12071', '+42.592287', '-074.438129', 'FULTONHAM', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4361, '12072', '+42.877533', '-074.404477', 'FULTONVILLE', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(4362, '12073', '+42.592287', '-074.438129', 'GALLUPVILLE', 'NY', 'NEW YORK', 'SCHOHARIE', 'PO BOX ONLY'),
(4363, '12074', '+43.082925', '-074.043981', 'GALWAY', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4364, '12075', '+42.366064', '-073.589731', 'GHENT', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4365, '12076', '+42.411096', '-074.427506', 'GILBOA', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4366, '12077', '+42.595704', '-073.787766', 'GLENMONT', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4367, '12078', '+43.114958', '-074.344328', 'GLOVERSVILLE', 'NY', 'NEW YORK', 'FULTON', 'STANDARD'),
(4368, '12082', '+42.772624', '-073.446834', 'GRAFTON', 'NY', 'NEW YORK', 'RENSSELAER', 'PO BOX ONLY'),
(4369, '12083', '+42.382594', '-073.951259', 'GREENVILLE', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4370, '12084', '+42.703519', '-073.960324', 'GUILDERLAND', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4371, '12085', '+42.694777', '-073.905271', 'GUILDERLAND CENTER', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4372, '12086', '+42.969505', '-074.155559', 'HAGAMAN', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(4373, '12087', '+42.411114', '-073.881515', 'HANNACROIX', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4374, '12089', '+42.866666', '-073.318113', 'HOOSICK', 'NY', 'NEW YORK', 'RENSSELAER', 'PO BOX ONLY'),
(4375, '12090', '+42.735310', '-073.437943', 'HOOSICK FALLS', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4376, '12092', '+42.712176', '-074.349066', 'HOWES CAVE', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4377, '12093', '+42.458932', '-074.580562', 'JEFFERSON', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4378, '12094', '+42.879946', '-073.486840', 'JOHNSONVILLE', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4379, '12095', '+43.090543', '-074.355438', 'JOHNSTOWN', 'NY', 'NEW YORK', 'FULTON', 'STANDARD'),
(4380, '12106', '+42.385231', '-073.704442', 'KINDERHOOK', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4381, '12107', '+42.660046', '-074.116812', 'KNOX', 'NY', 'NEW YORK', 'ALBANY', 'PO BOX ONLY'),
(4382, '12108', '+43.667618', '-074.456913', 'LAKE PLEASANT', 'NY', 'NEW YORK', 'HAMILTON', 'STANDARD'),
(4383, '12110', '+42.752928', '-073.779714', 'LATHAM', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4384, '12111', '+42.614852', '-073.970812', 'LATHAM', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4385, '12115', '+42.473718', '-073.567330', 'MALDEN BRIDGE', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4386, '12116', '+42.551473', '-074.913829', 'MARYLAND', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(4387, '12117', '+43.132167', '-074.248494', 'MAYFIELD', 'NY', 'NEW YORK', 'FULTON', 'STANDARD'),
(4388, '12118', '+43.033189', '-073.897322', 'MECHANICVILLE', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4389, '12120', '+42.478906', '-074.147178', 'MEDUSA', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4390, '12121', '+42.712948', '-073.601722', 'MELROSE', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4391, '12122', '+42.560533', '-074.295505', 'MIDDLEBURGH', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4392, '12123', '+42.565736', '-073.629023', 'NASSAU', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4393, '12124', '+42.444198', '-073.788241', 'NEW BALTIMORE', 'NY', 'NEW YORK', 'GREENE', 'PO BOX ONLY'),
(4394, '12125', '+42.466748', '-073.567189', 'NEW LEBANON', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4395, '12128', '+42.724978', '-073.764296', 'NEWTONVILLE', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4396, '12130', '+42.439983', '-073.666343', 'NIVERVILLE', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4397, '12131', '+42.592287', '-074.438129', 'NORTH BLENHEIM', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4398, '12132', '+42.466061', '-073.629296', 'NORTH CHATHAM', 'NY', 'NEW YORK', 'COLUMBIA', 'PO BOX ONLY'),
(4399, '12133', '+42.926121', '-073.346409', 'NORTH HOOSICK', 'NY', 'NEW YORK', 'RENSSELAER', 'PO BOX ONLY'),
(4400, '12134', '+43.176121', '-074.248627', 'NORTHVILLE', 'NY', 'NEW YORK', 'FULTON', 'STANDARD'),
(4401, '12136', '+42.434992', '-073.561172', 'OLD CHATHAM', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4402, '12137', '+42.838578', '-074.131734', 'PATTERSONVILLE', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4403, '12138', '+42.685947', '-073.390627', 'PETERSBURG', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4404, '12139', '+43.428386', '-074.526485', 'PISECO', 'NY', 'NEW YORK', 'HAMILTON', 'STANDARD'),
(4405, '12140', '+42.686757', '-073.527434', 'POESTENKILL', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4406, '12141', '+42.731771', '-074.185395', 'QUAKER STREET', 'NY', 'NEW YORK', 'SCHENECTADY', 'PO BOX ONLY'),
(4407, '12143', '+42.493642', '-073.858352', 'RAVENA', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4408, '12144', '+42.621627', '-073.596089', 'RENSSELAER', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4409, '12147', '+42.500258', '-074.160591', 'RENSSELAERVILLE', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4410, '12148', '+42.841619', '-073.847016', 'REXFORD', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4411, '12149', '+42.609418', '-074.594655', 'RICHMONDVILLE', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4412, '12150', '+42.869961', '-074.050083', 'ROTTERDAM JUNCTION', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4413, '12151', '+42.924726', '-073.785914', 'ROUND LAKE', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4414, '12153', '+42.635503', '-073.479705', 'SAND LAKE', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4415, '12154', '+42.904445', '-073.615618', 'SCHAGHTICOKE', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4416, '12155', '+42.605453', '-074.820584', 'SCHENEVUS', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(4417, '12156', '+42.491469', '-073.723935', 'SCHODACK LANDING', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4418, '12157', '+42.655569', '-074.337322', 'SCHOHARIE', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4419, '12158', '+42.529746', '-073.840579', 'SELKIRK', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4420, '12159', '+42.644278', '-073.876338', 'SLINGERLANDS', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4421, '12160', '+42.756876', '-074.317361', 'SLOANSVILLE', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4422, '12161', '+42.521038', '-073.851898', 'SOUTH BETHLEHEM', 'NY', 'NEW YORK', 'ALBANY', 'PO BOX ONLY'),
(4423, '12164', '+43.667618', '-074.456913', 'SPECULATOR', 'NY', 'NEW YORK', 'HAMILTON', 'STANDARD'),
(4424, '12165', '+42.331057', '-073.529774', 'SPENCERTOWN', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4425, '12166', '+42.842006', '-074.446000', 'SPRAKERS', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(4426, '12167', '+42.413508', '-074.619390', 'STAMFORD', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(4427, '12168', '+42.635930', '-073.408789', 'STEPHENTOWN', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4428, '12169', '+42.585511', '-073.415444', 'STEPHENTOWN', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4429, '12170', '+43.001932', '-073.660897', 'STILLWATER', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4430, '12172', '+42.285749', '-073.733532', 'STOTTVILLE', 'NY', 'NEW YORK', 'COLUMBIA', 'PO BOX ONLY'),
(4431, '12173', '+42.399271', '-073.622327', 'STUYVESANT', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4432, '12174', '+42.343986', '-073.734770', 'STUYVESANT FALLS', 'NY', 'NEW YORK', 'COLUMBIA', 'PO BOX ONLY'),
(4433, '12175', '+42.535029', '-074.545250', 'SUMMIT', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4434, '12176', '+42.385117', '-073.958671', 'SURPRISE', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4435, '12177', '+42.950020', '-074.296985', 'TRIBES HILL', 'NY', 'NEW YORK', 'MONTGOMERY', 'PO BOX ONLY'),
(4436, '12179', '+42.711440', '-073.525561', 'TROY', 'NY', 'NEW YORK', 'RENSSELAER', 'UNIQUE'),
(4437, '12180', '+42.673701', '-073.608792', 'TROY', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4438, '12181', '+42.738678', '-073.673862', 'TROY', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4439, '12182', '+42.685792', '-073.652374', 'TROY', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4440, '12183', '+42.745994', '-073.694263', 'TROY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4441, '12184', '+42.398503', '-073.626548', 'VALATIE', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4442, '12185', '+42.856307', '-073.500679', 'VALLEY FALLS', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4443, '12186', '+42.620654', '-073.980441', 'VOORHEESVILLE', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4444, '12187', '+42.592287', '-074.438129', 'WARNERVILLE', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4445, '12188', '+42.845579', '-073.702433', 'WATERFORD', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4446, '12189', '+42.736277', '-073.720318', 'WATERVLIET', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4447, '12190', '+43.667618', '-074.456913', 'WELLS', 'NY', 'NEW YORK', 'HAMILTON', 'STANDARD'),
(4448, '12192', '+42.397703', '-073.834836', 'WEST COXSACKIE', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4449, '12193', '+42.521722', '-074.039610', 'WESTERLO', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4450, '12194', '+42.572934', '-074.514163', 'WEST FULTON', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(4451, '12195', '+42.479384', '-073.474809', 'WEST LEBANON', 'NY', 'NEW YORK', 'COLUMBIA', 'PO BOX ONLY'),
(4452, '12196', '+42.603715', '-073.561566', 'WEST SAND LAKE', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4453, '12197', '+42.606993', '-074.732401', 'WORCESTER', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(4454, '12198', '+42.676167', '-073.606194', 'WYNANTSKILL', 'NY', 'NEW YORK', 'RENSSELAER', 'STANDARD'),
(4455, '12201', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4456, '12202', '+42.636371', '-073.763564', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4457, '12203', '+42.700345', '-073.857496', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4458, '12204', '+42.682978', '-073.770714', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4459, '12205', '+42.719799', '-073.820666', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4460, '12206', '+42.675779', '-073.793065', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4461, '12207', '+42.656029', '-073.750764', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4462, '12208', '+42.654658', '-073.805866', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4463, '12209', '+42.677953', '-073.910190', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4464, '12210', '+42.683079', '-073.758115', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4465, '12211', '+42.712973', '-073.773868', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4466, '12212', '+42.716774', '-073.810373', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4467, '12214', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4468, '12220', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4469, '12222', '+42.692909', '-073.838035', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4470, '12223', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4471, '12224', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4472, '12225', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4473, '12226', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4474, '12227', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4475, '12228', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4476, '12229', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4477, '12230', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4478, '12231', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4479, '12232', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4480, '12233', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4481, '12234', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4482, '12235', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4483, '12236', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4484, '12237', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4485, '12238', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4486, '12239', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4487, '12240', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4488, '12241', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4489, '12242', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4490, '12243', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4491, '12244', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4492, '12245', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4493, '12246', '+42.647079', '-073.750314', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4494, '12247', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4495, '12248', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4496, '12249', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4497, '12250', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4498, '12252', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4499, '12255', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4500, '12256', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4501, '12257', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4502, '12260', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4503, '12261', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4504, '12262', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4505, '12288', '+42.614852', '-073.970812', 'ALBANY', 'NY', 'NEW YORK', 'ALBANY', 'UNIQUE'),
(4506, '12301', '+42.833261', '-074.058015', 'SCHENECTADY', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4507, '12302', '+42.880035', '-073.991321', 'SCHENECTADY', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4508, '12303', '+42.782276', '-073.944818', 'SCHENECTADY', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4509, '12304', '+42.788176', '-073.899917', 'SCHENECTADY', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4510, '12305', '+42.812776', '-073.943368', 'SCHENECTADY', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4511, '12306', '+42.816438', '-074.052713', 'SCHENECTADY', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4512, '12307', '+42.805376', '-073.934868', 'SCHENECTADY', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4513, '12308', '+42.835926', '-073.920467', 'SCHENECTADY', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4514, '12309', '+42.809077', '-073.869316', 'SCHENECTADY', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4515, '12325', '+42.833261', '-074.058015', 'SCHENECTADY', 'NY', 'NEW YORK', 'SCHENECTADY', 'STANDARD'),
(4516, '12345', '+42.833261', '-074.058015', 'SCHENECTADY', 'NY', 'NEW YORK', 'SCHENECTADY', 'UNIQUE'),
(4517, '12401', '+41.969730', '-074.066780', 'KINGSTON', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4518, '12402', '+41.878801', '-074.345684', 'KINGSTON', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4519, '12404', '+41.949147', '-074.130688', 'ACCORD', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4520, '12405', '+42.315975', '-074.065515', 'ACRA', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4521, '12406', '+42.141725', '-074.572054', 'ARKVILLE', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(4522, '12407', '+42.332859', '-074.367866', 'ASHLAND', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4523, '12409', '+42.054666', '-074.192451', 'BEARSVILLE', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4524, '12410', '+42.073965', '-074.453033', 'BIG INDIAN', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4525, '12411', '+41.875232', '-074.043557', 'BLOOMINGTON', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4526, '12412', '+41.998413', '-074.265437', 'BOICEVILLE', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4527, '12413', '+42.301789', '-074.029434', 'CAIRO', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4528, '12414', '+42.258459', '-074.021968', 'CATSKILL', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4529, '12416', '+42.095023', '-074.271661', 'CHICHESTER', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4530, '12417', '+41.907604', '-073.989254', 'CONNELLY', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4531, '12418', '+42.368277', '-074.179384', 'CORNWALLVILLE', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4532, '12419', '+41.856903', '-074.111235', 'COTTEKILL', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4533, '12420', '+41.669831', '-074.380138', 'CRAGSMOOR', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4534, '12421', '+42.235727', '-074.569690', 'DENVER', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(4535, '12422', '+42.307188', '-074.200237', 'DURHAM', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4536, '12423', '+42.377483', '-074.123477', 'EAST DURHAM', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4537, '12424', '+42.280410', '-074.155490', 'EAST JEWETT', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4538, '12427', '+42.169082', '-074.129580', 'ELKA PARK', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4539, '12428', '+41.897181', '-074.253996', 'ELLENVILLE', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4540, '12429', '+41.816228', '-073.992565', 'ESOPUS', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4541, '12430', '+42.177175', '-074.547279', 'FLEISCHMANNS', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(4542, '12431', '+42.336112', '-074.024147', 'FREEHOLD', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4543, '12432', '+41.949795', '-074.003246', 'GLASCO', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4544, '12433', '+42.008413', '-074.147995', 'GLENFORD', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4545, '12434', '+42.320684', '-074.459223', 'GRAND GORGE', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(4546, '12435', '+41.727613', '-074.515647', 'GREENFIELD PARK', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4547, '12436', '+42.195510', '-074.102319', 'HAINES FALLS', 'NY', 'NEW YORK', 'GREENE', 'PO BOX ONLY'),
(4548, '12438', '+42.183045', '-074.925617', 'HALCOTTSVILLE', 'NY', 'NEW YORK', 'DELAWARE', 'PO BOX ONLY'),
(4549, '12439', '+42.293905', '-074.185279', 'HENSONVILLE', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4550, '12440', '+41.872233', '-074.146678', 'HIGH FALLS', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4551, '12441', '+41.878801', '-074.345684', 'HIGHMOUNT', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4552, '12442', '+42.233275', '-074.241582', 'HUNTER', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4553, '12443', '+41.853723', '-074.115476', 'HURLEY', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4554, '12444', '+42.264524', '-074.295888', 'JEWETT', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4555, '12446', '+41.884748', '-074.232063', 'KERHONKSON', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4556, '12448', '+42.083209', '-074.191963', 'LAKE HILL', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4557, '12449', '+41.883711', '-074.182479', 'LAKE KATRINE', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4558, '12450', '+42.208809', '-074.163793', 'LANESVILLE', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4559, '12451', '+42.304064', '-073.930812', 'LEEDS', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4560, '12452', '+42.223407', '-074.386635', 'LEXINGTON', 'NY', 'NEW YORK', 'GREENE', 'PO BOX ONLY'),
(4561, '12453', '+42.098698', '-073.935418', 'MALDEN ON HUDSON', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4562, '12454', '+42.282466', '-074.160193', 'MAPLECREST', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4563, '12455', '+42.185189', '-074.617819', 'MARGARETVILLE', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(4564, '12456', '+42.037136', '-073.992829', 'MOUNT MARION', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4565, '12457', '+41.874300', '-074.168979', 'MOUNT TREMPER', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4566, '12458', '+41.801370', '-074.420108', 'NAPANOCH', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(4567, '12459', '+42.209430', '-074.683726', 'NEW KINGSTON', 'NY', 'NEW YORK', 'DELAWARE', 'PO BOX ONLY'),
(4568, '12460', '+42.409721', '-074.192105', 'OAK HILL', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4569, '12461', '+41.875001', '-074.273362', 'OLIVEBRIDGE', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4570, '12463', '+42.197886', '-074.009950', 'PALENVILLE', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4571, '12464', '+42.019668', '-074.228732', 'PHOENICIA', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4572, '12465', '+42.136293', '-074.473639', 'PINE HILL', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4573, '12466', '+41.894812', '-073.976653', 'PORT EWEN', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4574, '12468', '+42.286917', '-074.385762', 'PRATTSVILLE', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4575, '12469', '+42.464687', '-074.213992', 'PRESTON HOLLOW', 'NY', 'NEW YORK', 'ALBANY', 'STANDARD'),
(4576, '12470', '+42.282915', '-074.018409', 'PURLING', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4577, '12471', '+41.840304', '-074.030611', 'RIFTON', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4578, '12472', '+41.873367', '-074.074621', 'ROSENDALE', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4579, '12473', '+42.276462', '-074.044432', 'ROUND TOP', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4580, '12474', '+42.295703', '-074.563088', 'ROXBURY', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(4581, '12475', '+42.017632', '-074.007868', 'RUBY', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4582, '12477', '+41.996982', '-074.202816', 'SAUGERTIES', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4583, '12480', '+41.911181', '-074.407894', 'SHANDAKEN', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4584, '12481', '+41.970903', '-074.218443', 'SHOKAN', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4585, '12482', '+42.267617', '-073.986354', 'SOUTH CAIRO', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4586, '12483', '+41.663895', '-074.424533', 'SPRING GLEN', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4587, '12484', '+41.846274', '-074.207310', 'STONE RIDGE', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4588, '12485', '+42.195922', '-074.137242', 'TANNERSVILLE', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4589, '12486', '+41.837953', '-074.232241', 'TILLSON', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4590, '12487', '+41.857076', '-074.017907', 'ULSTER PARK', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4591, '12489', '+41.760604', '-074.353531', 'WAWARSING', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4592, '12490', '+42.108689', '-073.934577', 'WEST CAMP', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4593, '12491', '+41.983752', '-074.124371', 'WEST HURLEY', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4594, '12492', '+42.206787', '-074.375508', 'WEST KILL', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4595, '12493', '+41.795276', '-073.980908', 'WEST PARK', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4596, '12494', '+41.972572', '-074.267623', 'WEST SHOKAN', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4597, '12495', '+42.046885', '-074.203575', 'WILLOW', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4598, '12496', '+42.320273', '-074.231589', 'WINDHAM', 'NY', 'NEW YORK', 'GREENE', 'STANDARD'),
(4599, '12498', '+41.883076', '-074.169764', 'WOODSTOCK', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4600, '12501', '+41.826491', '-073.710901', 'AMENIA', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4601, '12502', '+42.067399', '-073.657698', 'ANCRAM', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4602, '12503', '+42.043039', '-073.587575', 'ANCRAMDALE', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4603, '12504', '+42.035434', '-073.909234', 'ANNANDALE ON HUDSON', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4604, '12506', '+41.759905', '-073.743714', 'BANGALL', 'NY', 'NEW YORK', 'DUTCHESS', 'PO BOX ONLY'),
(4605, '12507', '+42.000547', '-073.919899', 'BARRYTOWN', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4606, '12508', '+41.712677', '-073.773082', 'BEACON', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4607, '12510', '+41.759905', '-073.743714', 'BILLINGS', 'NY', 'NEW YORK', 'DUTCHESS', 'PO BOX ONLY'),
(4608, '12511', '+41.759905', '-073.743714', 'CASTLE POINT', 'NY', 'NEW YORK', 'DUTCHESS', 'PO BOX ONLY'),
(4609, '12512', '+41.552793', '-073.968183', 'CHELSEA', 'NY', 'NEW YORK', 'DUTCHESS', 'PO BOX ONLY'),
(4610, '12513', '+42.206862', '-073.694642', 'CLAVERACK', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4611, '12514', '+41.867364', '-073.777256', 'CLINTON CORNERS', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4612, '12515', '+41.682335', '-074.057990', 'CLINTONDALE', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4613, '12516', '+42.099322', '-073.576102', 'COPAKE', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4614, '12517', '+42.130934', '-073.548337', 'COPAKE FALLS', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4615, '12518', '+41.348593', '-074.135167', 'CORNWALL', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4616, '12520', '+41.431474', '-074.132883', 'CORNWALL ON HUDSON', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4617, '12521', '+42.190488', '-073.644650', 'CRARYVILLE', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4618, '12522', '+41.800316', '-073.687324', 'DOVER PLAINS', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4619, '12523', '+42.119528', '-073.697297', 'ELIZAVILLE', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4620, '12524', '+41.618980', '-073.847308', 'FISHKILL', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4621, '12525', '+41.677151', '-074.173870', 'GARDINER', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4622, '12526', '+42.121298', '-073.792924', 'GERMANTOWN', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4623, '12527', '+41.520249', '-073.933259', 'GLENHAM', 'NY', 'NEW YORK', 'DUTCHESS', 'PO BOX ONLY'),
(4624, '12528', '+41.720945', '-074.009481', 'HIGHLAND', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4625, '12529', '+42.193270', '-073.550028', 'HILLSDALE', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4626, '12530', '+42.210991', '-073.687001', 'HOLLOWVILLE', 'NY', 'NEW YORK', 'COLUMBIA', 'PO BOX ONLY'),
(4627, '12531', '+41.549045', '-073.670325', 'HOLMES', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4628, '12533', '+41.748948', '-073.766191', 'HOPEWELL JUNCTION', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4629, '12534', '+42.184313', '-073.742997', 'HUDSON', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4630, '12537', '+41.582437', '-073.936281', 'HUGHSONVILLE', 'NY', 'NEW YORK', 'DUTCHESS', 'PO BOX ONLY'),
(4631, '12538', '+41.813468', '-073.814913', 'HYDE PARK', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4632, '12540', '+41.633029', '-073.743183', 'LAGRANGEVILLE', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4633, '12541', '+42.142068', '-073.757399', 'LIVINGSTON', 'NY', 'NEW YORK', 'COLUMBIA', 'PO BOX ONLY'),
(4634, '12542', '+41.612647', '-074.002802', 'MARLBORO', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4635, '12543', '+41.357625', '-074.230587', 'MAYBROOK', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4636, '12544', '+42.259623', '-073.667962', 'MELLENVILLE', 'NY', 'NEW YORK', 'COLUMBIA', 'PO BOX ONLY'),
(4637, '12545', '+41.832012', '-073.637175', 'MILLBROOK', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4638, '12546', '+41.938460', '-073.546336', 'MILLERTON', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4639, '12547', '+41.644832', '-074.068056', 'MILTON', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4640, '12548', '+41.672278', '-074.103276', 'MODENA', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4641, '12549', '+41.405901', '-074.255717', 'MONTGOMERY', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4642, '12550', '+41.385370', '-074.185363', 'NEWBURGH', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4643, '12551', '+41.387822', '-074.354699', 'NEWBURGH', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4644, '12552', '+41.387822', '-074.354699', 'NEWBURGH', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4645, '12553', '+41.413667', '-074.311974', 'NEW WINDSOR', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4646, '12555', '+41.387822', '-074.354699', 'MID HUDSON', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(4647, '12561', '+41.746380', '-074.109241', 'NEW PALTZ', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4648, '12563', '+41.485285', '-073.595066', 'PATTERSON', 'NY', 'NEW YORK', 'PUTNAM', 'STANDARD'),
(4649, '12564', '+41.663759', '-073.590491', 'PAWLING', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4650, '12565', '+42.250141', '-073.659054', 'PHILMONT', 'NY', 'NEW YORK', 'COLUMBIA', 'PO BOX ONLY'),
(4651, '12566', '+41.405485', '-074.219343', 'PINE BUSH', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4652, '12567', '+41.952681', '-073.636330', 'PINE PLAINS', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4653, '12568', '+41.641207', '-074.078050', 'PLATTEKILL', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4654, '12569', '+41.825708', '-073.783655', 'PLEASANT VALLEY', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4655, '12570', '+41.646389', '-073.650107', 'POUGHQUAG', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4656, '12571', '+41.808427', '-073.786847', 'RED HOOK', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4657, '12572', '+41.836548', '-073.760423', 'RHINEBECK', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4658, '12574', '+41.915068', '-073.951730', 'RHINECLIFF', 'NY', 'NEW YORK', 'DUTCHESS', 'PO BOX ONLY'),
(4659, '12575', '+41.507550', '-074.156394', 'ROCK TAVERN', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4660, '12577', '+41.437176', '-074.121804', 'SALISBURY MILLS', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4661, '12578', '+41.812460', '-073.786647', 'SALT POINT', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4662, '12580', '+41.881636', '-073.724550', 'STAATSBURG', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4663, '12581', '+41.913511', '-073.695442', 'STANFORDVILLE', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4664, '12582', '+41.554509', '-073.726670', 'STORMVILLE', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4665, '12583', '+41.909683', '-073.749214', 'TIVOLI', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4666, '12584', '+41.464073', '-074.059104', 'VAILS GATE', 'NY', 'NEW YORK', 'ORANGE', 'PO BOX ONLY'),
(4667, '12585', '+41.716145', '-073.690109', 'VERBANK', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4668, '12586', '+41.406785', '-074.267310', 'WALDEN', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4669, '12588', '+41.878801', '-074.345684', 'WALKER VALLEY', 'NY', 'NEW YORK', 'ULSTER', 'PO BOX ONLY'),
(4670, '12589', '+41.631653', '-074.154472', 'WALLKILL', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4671, '12590', '+41.736948', '-073.741141', 'WAPPINGERS FALLS', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4672, '12592', '+41.802285', '-073.560425', 'WASSAIC', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4673, '12593', '+42.243991', '-073.641076', 'WEST COPAKE', 'NY', 'NEW YORK', 'COLUMBIA', 'STANDARD'),
(4674, '12594', '+41.672789', '-073.584346', 'WINGDALE', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4675, '12601', '+41.695839', '-073.896164', 'POUGHKEEPSIE', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4676, '12602', '+41.759905', '-073.743714', 'POUGHKEEPSIE', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4677, '12603', '+41.690707', '-073.862074', 'POUGHKEEPSIE', 'NY', 'NEW YORK', 'DUTCHESS', 'STANDARD'),
(4678, '12604', '+41.759905', '-073.743714', 'POUGHKEEPSIE', 'NY', 'NEW YORK', 'DUTCHESS', 'UNIQUE'),
(4679, '12701', '+41.686944', '-074.677156', 'MONTICELLO', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4680, '12719', '+41.486186', '-074.915176', 'BARRYVILLE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4681, '12720', '+41.661466', '-074.911474', 'BETHEL', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4682, '12721', '+41.638680', '-074.721754', 'BLOOMINGBURG', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4683, '12722', '+41.719016', '-074.755373', 'BURLINGHAM', 'NY', 'NEW YORK', 'SULLIVAN', 'PO BOX ONLY'),
(4684, '12723', '+41.775202', '-075.018070', 'CALLICOON', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4685, '12724', '+41.719016', '-074.755373', 'CALLICOON CENTER', 'NY', 'NEW YORK', 'SULLIVAN', 'PO BOX ONLY'),
(4686, '12725', '+41.899285', '-074.588020', 'CLARYVILLE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4687, '12726', '+41.691959', '-074.974074', 'COCHECTON', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4688, '12727', '+41.719016', '-074.755373', 'COCHECTON CENTER', 'NY', 'NEW YORK', 'SULLIVAN', 'PO BOX ONLY'),
(4689, '12729', '+41.403723', '-074.425265', 'CUDDEBACKVILLE', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4690, '12732', '+41.517426', '-074.845788', 'ELDRED', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4691, '12733', '+41.647052', '-074.537252', 'FALLSBURG', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4692, '12734', '+41.734858', '-074.734508', 'FERNDALE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4693, '12736', '+41.878194', '-075.034258', 'FREMONT CENTER', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4694, '12737', '+41.547309', '-074.820881', 'GLEN SPEY', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4695, '12738', '+41.656753', '-074.568565', 'GLEN WILD', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4696, '12739', '+41.450914', '-074.601097', 'GODEFFROY', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4697, '12740', '+41.818383', '-074.748053', 'GRAHAMSVILLE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4698, '12741', '+41.839135', '-075.053420', 'HANKINS', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4699, '12742', '+41.710156', '-074.715360', 'HARRIS', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4700, '12743', '+41.531346', '-074.849136', 'HIGHLAND LAKE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4701, '12745', '+41.762944', '-075.030592', 'HORTONVILLE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4702, '12746', '+41.437689', '-074.640019', 'HUGUENOT', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4703, '12747', '+41.770283', '-074.726066', 'HURLEYVILLE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4704, '12748', '+41.782874', '-074.905417', 'JEFFERSONVILLE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4705, '12749', '+41.687384', '-074.835807', 'KAUNEONGA LAKE', 'NY', 'NEW YORK', 'SULLIVAN', 'PO BOX ONLY'),
(4706, '12750', '+41.729581', '-074.961146', 'KENOZA LAKE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4707, '12751', '+41.694655', '-074.682731', 'KIAMESHA LAKE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4708, '12752', '+41.758563', '-074.946306', 'LAKE HUNTINGTON', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4709, '12754', '+41.719940', '-074.669340', 'LIBERTY', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4710, '12758', '+41.818205', '-074.802549', 'LIVINGSTON MANOR', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4711, '12759', '+41.786516', '-074.658843', 'LOCH SHELDRAKE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4712, '12760', '+41.871276', '-075.076328', 'LONG EDDY', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4713, '12762', '+41.686123', '-074.783554', 'MONGAUP VALLEY', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4714, '12763', '+41.804690', '-074.696318', 'MOUNTAIN DALE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4715, '12764', '+41.595908', '-074.962330', 'NARROWSBURG', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4716, '12765', '+41.865656', '-074.609020', 'NEVERSINK', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4717, '12766', '+41.820897', '-074.995771', 'NORTH BRANCH', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4718, '12767', '+41.719016', '-074.755373', 'OBERNBURG', 'NY', 'NEW YORK', 'SULLIVAN', 'PO BOX ONLY'),
(4719, '12768', '+41.841414', '-074.857261', 'PARKSVILLE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4720, '12769', '+41.651453', '-074.436159', 'PHILLIPSPORT', 'NY', 'NEW YORK', 'SULLIVAN', 'PO BOX ONLY'),
(4721, '12770', '+41.446322', '-074.856932', 'POND EDDY', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4722, '12771', '+41.357119', '-074.498396', 'PORT JERVIS', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4723, '12775', '+41.619506', '-074.575902', 'ROCK HILL', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4724, '12776', '+41.819249', '-074.951782', 'ROSCOE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4725, '12777', '+41.552911', '-074.603366', 'FORESTBURGH', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4726, '12778', '+41.661538', '-074.817751', 'SMALLWOOD', 'NY', 'NEW YORK', 'SULLIVAN', 'PO BOX ONLY'),
(4727, '12779', '+41.770195', '-074.716843', 'SOUTH FALLSBURG', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4728, '12780', '+41.376892', '-074.459687', 'SPARROW BUSH', 'NY', 'NEW YORK', 'ORANGE', 'STANDARD'),
(4729, '12781', '+41.719016', '-074.755373', 'SUMMITVILLE', 'NY', 'NEW YORK', 'SULLIVAN', 'PO BOX ONLY'),
(4730, '12782', '+41.881485', '-074.430063', 'SUNDOWN', 'NY', 'NEW YORK', 'ULSTER', 'STANDARD'),
(4731, '12783', '+41.657319', '-074.840778', 'SWAN LAKE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4732, '12784', '+41.714311', '-074.584061', 'THOMPSONVILLE', 'NY', 'NEW YORK', 'SULLIVAN', 'PO BOX ONLY'),
(4733, '12785', '+41.719016', '-074.755373', 'WESTBROOKVILLE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4734, '12786', '+41.647880', '-074.811773', 'WHITE LAKE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4735, '12787', '+41.800193', '-074.828611', 'WHITE SULPHUR SPRINGS', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4736, '12788', '+41.810974', '-074.729403', 'WOODBOURNE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4737, '12789', '+41.797345', '-074.671013', 'WOODRIDGE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4738, '12790', '+41.592331', '-074.552644', 'WURTSBORO', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4739, '12791', '+41.695449', '-074.746874', 'YOUNGSVILLE', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4740, '12792', '+41.591075', '-074.749722', 'YULAN', 'NY', 'NEW YORK', 'SULLIVAN', 'STANDARD'),
(4741, '12801', '+43.318880', '-073.669061', 'GLENS FALLS', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4742, '12803', '+43.283561', '-073.629401', 'SOUTH GLENS FALLS', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4743, '12804', '+43.489472', '-073.789563', 'QUEENSBURY', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4744, '12808', '+43.708338', '-073.794147', 'ADIRONDACK', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4745, '12809', '+43.280711', '-073.484828', 'ARGYLE', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4746, '12810', '+43.598860', '-073.943693', 'ATHOL', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4747, '12811', '+43.624220', '-074.061201', 'BAKERS MILLS', 'NY', 'NEW YORK', 'WARREN', 'PO BOX ONLY'),
(4748, '12812', '+43.667618', '-074.456913', 'BLUE MOUNTAIN LAKE', 'NY', 'NEW YORK', 'HAMILTON', 'STANDARD'),
(4749, '12814', '+43.574329', '-073.677564', 'BOLTON LANDING', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4750, '12815', '+43.677503', '-073.773434', 'BRANT LAKE', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4751, '12816', '+43.068526', '-073.392229', 'CAMBRIDGE', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4752, '12817', '+43.522364', '-073.794491', 'CHESTERTOWN', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4753, '12819', '+43.614194', '-073.503056', 'CLEMONS', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4754, '12820', '+43.471810', '-073.639291', 'CLEVERDALE', 'NY', 'NEW YORK', 'WARREN', 'PO BOX ONLY'),
(4755, '12821', '+43.461440', '-073.403287', 'COMSTOCK', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4756, '12822', '+43.241967', '-073.890739', 'CORINTH', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4757, '12823', '+43.154262', '-073.458063', 'COSSAYUNA', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4758, '12824', '+43.560729', '-073.755545', 'DIAMOND POINT', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4759, '12827', '+43.443936', '-073.489198', 'FORT ANN', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4760, '12828', '+43.371195', '-073.434566', 'FORT EDWARD', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4761, '12831', '+43.204261', '-073.707415', 'GANSEVOORT', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4762, '12832', '+43.369373', '-073.331692', 'GRANVILLE', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4763, '12833', '+43.181214', '-073.906293', 'GREENFIELD CENTER', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4764, '12834', '+43.212754', '-073.434261', 'GREENWICH', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4765, '12835', '+43.287589', '-073.976958', 'HADLEY', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4766, '12836', '+43.730225', '-073.543498', 'HAGUE', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4767, '12837', '+43.492705', '-073.278904', 'HAMPTON', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4768, '12838', '+43.354304', '-073.404906', 'HARTFORD', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4769, '12839', '+43.203596', '-073.468589', 'HUDSON FALLS', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4770, '12841', '+43.646953', '-073.508308', 'HULETTS LANDING', 'NY', 'NEW YORK', 'WASHINGTON', 'PO BOX ONLY'),
(4771, '12842', '+43.749928', '-074.327593', 'INDIAN LAKE', 'NY', 'NEW YORK', 'HAMILTON', 'STANDARD'),
(4772, '12843', '+43.585960', '-073.916498', 'JOHNSBURG', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4773, '12844', '+43.475353', '-073.627156', 'KATTSKILL BAY', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4774, '12845', '+43.518611', '-073.875462', 'LAKE GEORGE', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4775, '12846', '+43.455598', '-073.771547', 'LAKE LUZERNE', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4776, '12847', '+43.953253', '-074.440029', 'LONG LAKE', 'NY', 'NEW YORK', 'HAMILTON', 'STANDARD'),
(4777, '12848', '+43.100123', '-073.524554', 'MIDDLE FALLS', 'NY', 'NEW YORK', 'WASHINGTON', 'PO BOX ONLY'),
(4778, '12849', '+43.442087', '-073.290902', 'MIDDLE GRANVILLE', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4779, '12850', '+43.185956', '-073.983737', 'MIDDLE GROVE', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4780, '12851', '+44.214452', '-073.787317', 'MINERVA', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4781, '12852', '+44.145678', '-073.815204', 'NEWCOMB', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4782, '12853', '+43.622181', '-073.922201', 'NORTH CREEK', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4783, '12854', '+43.452517', '-073.340950', 'NORTH GRANVILLE', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4784, '12855', '+43.970736', '-073.721139', 'NORTH HUDSON', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4785, '12856', '+43.723665', '-074.087329', 'NORTH RIVER', 'NY', 'NEW YORK', 'WARREN', 'PO BOX ONLY'),
(4786, '12857', '+44.145678', '-073.815204', 'OLMSTEDVILLE', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4787, '12858', '+43.879451', '-073.400254', 'PARADOX', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4788, '12859', '+43.201380', '-073.891854', 'PORTER CORNERS', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4789, '12860', '+43.592829', '-073.784407', 'POTTERSVILLE', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4790, '12861', '+43.743816', '-073.422181', 'PUTNAM STATION', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4791, '12862', '+43.675377', '-073.932509', 'RIPARIUS', 'NY', 'NEW YORK', 'WARREN', 'PO BOX ONLY'),
(4792, '12863', '+43.061305', '-073.923080', 'ROCK CITY FALLS', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4793, '12864', '+43.667618', '-074.456913', 'SABAEL', 'NY', 'NEW YORK', 'HAMILTON', 'PO BOX ONLY'),
(4794, '12865', '+43.225966', '-073.348736', 'SALEM', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4795, '12866', '+43.101145', '-073.850623', 'SARATOGA SPRINGS', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4796, '12870', '+43.841273', '-073.759213', 'SCHROON LAKE', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4797, '12871', '+43.130211', '-073.643205', 'SCHUYLERVILLE', 'NY', 'NEW YORK', 'SARATOGA', 'STANDARD'),
(4798, '12872', '+44.145678', '-073.815204', 'SEVERANCE', 'NY', 'NEW YORK', 'ESSEX', 'PO BOX ONLY'),
(4799, '12873', '+43.104587', '-073.314179', 'SHUSHAN', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4800, '12874', '+43.693173', '-073.505019', 'SILVER BAY', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4801, '12878', '+43.464398', '-073.876364', 'STONY CREEK', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4802, '12879', '+44.145678', '-073.815204', 'NEWCOMB', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4803, '12883', '+43.852071', '-073.478024', 'TICONDEROGA', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4804, '12884', '+43.088397', '-073.591652', 'VICTORY MILLS', 'NY', 'NEW YORK', 'SARATOGA', 'PO BOX ONLY'),
(4805, '12885', '+43.570457', '-073.859928', 'WARRENSBURG', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4806, '12886', '+43.631297', '-073.936399', 'WEVERTOWN', 'NY', 'NEW YORK', 'WARREN', 'STANDARD'),
(4807, '12887', '+43.492815', '-073.421536', 'WHITEHALL', 'NY', 'NEW YORK', 'WASHINGTON', 'STANDARD'),
(4808, '12901', '+44.711870', '-073.637104', 'PLATTSBURGH', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4809, '12903', '+44.685411', '-073.447398', 'PLATTSBURGH', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4810, '12910', '+44.865209', '-073.577683', 'ALTONA', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4811, '12911', '+44.528081', '-073.471946', 'KEESEVILLE', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4812, '12912', '+44.711326', '-073.648386', 'AU SABLE FORKS', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4813, '12913', '+44.401213', '-074.070277', 'BLOOMINGDALE', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4814, '12914', '+44.674942', '-074.444789', 'BOMBAY', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4815, '12915', '+44.552725', '-074.317958', 'BRAINARDSVILLE', 'NY', 'NEW YORK', 'FRANKLIN', 'PO BOX ONLY'),
(4816, '12916', '+44.877630', '-074.489379', 'BRUSHTON', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4817, '12917', '+44.932057', '-074.200948', 'BURKE', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4818, '12918', '+44.686162', '-073.670249', 'CADYVILLE', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4819, '12919', '+44.726056', '-073.578285', 'CHAMPLAIN', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4820, '12920', '+44.932727', '-074.068371', 'CHATEAUGAY', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4821, '12921', '+44.879906', '-073.452578', 'CHAZY', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4822, '12922', '+44.287829', '-074.702338', 'CHILDWOLD', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(4823, '12923', '+44.916842', '-073.932053', 'CHURUBUSCO', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4824, '12924', '+44.706561', '-073.744555', 'KEESEVILLE', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4825, '12926', '+44.944145', '-074.327316', 'CONSTABLE', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4826, '12927', '+44.228969', '-074.858103', 'CRANBERRY LAKE', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'PO BOX ONLY'),
(4827, '12928', '+43.930616', '-073.588540', 'CROWN POINT', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4828, '12929', '+44.847709', '-073.582317', 'DANNEMORA', 'NY', 'NEW YORK', 'CLINTON', 'PO BOX ONLY'),
(4829, '12930', '+44.552725', '-074.317958', 'DICKINSON CENTER', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4830, '12932', '+44.145678', '-073.815204', 'ELIZABETHTOWN', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4831, '12933', '+44.881962', '-073.963279', 'ELLENBURG', 'NY', 'NEW YORK', 'CLINTON', 'PO BOX ONLY'),
(4832, '12934', '+44.892243', '-073.907936', 'ELLENBURG CENTER', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4833, '12935', '+44.801467', '-073.739157', 'ELLENBURG DEPOT', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4834, '12936', '+44.273412', '-073.377434', 'ESSEX', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4835, '12937', '+44.955977', '-074.486740', 'FORT COVINGTON', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4836, '12939', '+44.552725', '-074.317958', 'GABRIELS', 'NY', 'NEW YORK', 'FRANKLIN', 'PO BOX ONLY'),
(4837, '12941', '+44.145678', '-073.815204', 'JAY', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4838, '12942', '+44.145678', '-073.815204', 'KEENE', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4839, '12943', '+44.202397', '-073.773111', 'KEENE VALLEY', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4840, '12944', '+44.343063', '-073.436913', 'KEESEVILLE', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4841, '12945', '+44.552725', '-074.317958', 'LAKE CLEAR', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4842, '12946', '+44.130663', '-073.734652', 'LAKE PLACID', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4843, '12949', '+44.746861', '-074.660413', 'LAWRENCEVILLE', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(4844, '12950', '+44.145678', '-073.815204', 'LEWIS', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4845, '12952', '+44.734587', '-073.900452', 'LYON MOUNTAIN', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4846, '12953', '+44.859117', '-074.288237', 'MALONE', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4847, '12955', '+44.804316', '-073.972990', 'LYON MOUNTAIN', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4848, '12956', '+44.124040', '-073.491335', 'MINEVILLE', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4849, '12957', '+44.856880', '-074.552321', 'MOIRA', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4850, '12958', '+44.792956', '-073.661296', 'MOOERS', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4851, '12959', '+44.762920', '-073.615749', 'MOOERS FORKS', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4852, '12960', '+44.041863', '-073.505265', 'MORIAH', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4853, '12961', '+44.055155', '-073.534677', 'MORIAH CENTER', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4854, '12962', '+44.617784', '-073.605062', 'MORRISONVILLE', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4855, '12964', '+44.145678', '-073.815204', 'NEW RUSSIA', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4856, '12965', '+44.726424', '-074.678121', 'NICHOLVILLE', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(4857, '12966', '+44.853200', '-074.419121', 'NORTH BANGOR', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4858, '12967', '+44.761862', '-074.680488', 'NORTH LAWRENCE', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(4859, '12969', '+44.552725', '-074.317958', 'OWLS HEAD', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4860, '12970', '+44.552725', '-074.317958', 'PAUL SMITHS', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4861, '12972', '+44.666070', '-073.569167', 'PERU', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4862, '12973', '+44.234289', '-074.555957', 'PIERCEFIELD', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'PO BOX ONLY'),
(4863, '12974', '+44.087072', '-073.461308', 'PORT HENRY', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4864, '12975', '+44.526437', '-073.409243', 'PORT KENT', 'NY', 'NEW YORK', 'ESSEX', 'PO BOX ONLY'),
(4865, '12976', '+44.552725', '-074.317958', 'RAINBOW LAKE', 'NY', 'NEW YORK', 'FRANKLIN', 'PO BOX ONLY'),
(4866, '12977', '+44.145678', '-073.815204', 'RAY BROOK', 'NY', 'NEW YORK', 'ESSEX', 'PO BOX ONLY'),
(4867, '12978', '+44.664956', '-073.761204', 'REDFORD', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4868, '12979', '+44.864633', '-073.626615', 'ROUSES POINT', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4869, '12980', '+44.657819', '-074.515511', 'SAINT REGIS FALLS', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4870, '12981', '+44.624413', '-073.809266', 'SARANAC', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4871, '12983', '+44.583429', '-074.272104', 'SARANAC LAKE', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4872, '12985', '+44.570072', '-073.678749', 'SCHUYLER FALLS', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4873, '12986', '+44.599971', '-074.294012', 'TUPPER LAKE', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4874, '12987', '+44.145678', '-073.815204', 'UPPER JAY', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4875, '12989', '+44.552725', '-074.317958', 'VERMONTVILLE', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(4876, '12992', '+44.827274', '-073.513225', 'WEST CHAZY', 'NY', 'NEW YORK', 'CLINTON', 'STANDARD'),
(4877, '12993', '+44.187830', '-073.434541', 'WESTPORT', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4878, '12995', '+44.805681', '-074.252254', 'WHIPPLEVILLE', 'NY', 'NEW YORK', 'FRANKLIN', 'PO BOX ONLY'),
(4879, '12996', '+44.242261', '-073.416202', 'WILLSBORO', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4880, '12997', '+44.145678', '-073.815204', 'WILMINGTON', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4881, '12998', '+44.082670', '-073.530601', 'WITHERBEE', 'NY', 'NEW YORK', 'ESSEX', 'STANDARD'),
(4882, '13020', '+42.823968', '-076.062425', 'APULIA STATION', 'NY', 'NEW YORK', 'ONONDAGA', 'PO BOX ONLY'),
(4883, '13021', '+42.894381', '-076.565683', 'AUBURN', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4884, '13022', '+43.163364', '-076.509567', 'AUBURN', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4885, '13024', '+43.163364', '-076.509567', 'AUBURN', 'NY', 'NEW YORK', 'CAYUGA', 'UNIQUE'),
(4886, '13026', '+42.755979', '-076.646007', 'AURORA', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4887, '13027', '+43.158531', '-076.360147', 'BALDWINSVILLE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4888, '13028', '+43.310494', '-076.135765', 'BERNHARDS BAY', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4889, '13029', '+43.227448', '-076.140648', 'BREWERTON', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4890, '13030', '+43.165372', '-075.993896', 'BRIDGEPORT', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4891, '13031', '+43.049756', '-076.348012', 'CAMILLUS', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4892, '13032', '+43.005767', '-075.798607', 'CANASTOTA', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(4893, '13033', '+43.185529', '-076.579082', 'CATO', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4894, '13034', '+42.924315', '-076.676419', 'CAYUGA', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4895, '13035', '+42.939422', '-075.775568', 'CAZENOVIA', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(4896, '13036', '+43.330332', '-076.170850', 'CENTRAL SQUARE', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4897, '13037', '+43.009985', '-075.806194', 'CHITTENANGO', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(4898, '13039', '+43.125491', '-076.154128', 'CICERO', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4899, '13040', '+42.565932', '-075.955301', 'CINCINNATUS', 'NY', 'NEW YORK', 'CORTLAND', 'STANDARD'),
(4900, '13041', '+43.119217', '-076.131931', 'CLAY', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4901, '13042', '+43.276370', '-076.225752', 'CLEVELAND', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4902, '13043', '+43.042044', '-075.740848', 'CLOCKVILLE', 'NY', 'NEW YORK', 'MADISON', 'PO BOX ONLY'),
(4903, '13044', '+43.301232', '-075.982593', 'CONSTANTIA', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4904, '13045', '+42.614268', '-076.120128', 'CORTLAND', 'NY', 'NEW YORK', 'CORTLAND', 'STANDARD'),
(4905, '13051', '+42.870698', '-075.911280', 'DELPHI FALLS', 'NY', 'NEW YORK', 'ONONDAGA', 'PO BOX ONLY'),
(4906, '13052', '+42.776527', '-075.859458', 'DE RUYTER', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(4907, '13053', '+42.477712', '-076.291224', 'DRYDEN', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(4908, '13054', '+43.145480', '-075.559605', 'DURHAMVILLE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(4909, '13056', '+42.677155', '-076.105201', 'EAST HOMER', 'NY', 'NEW YORK', 'CORTLAND', 'STANDARD'),
(4910, '13057', '+43.096216', '-076.047426', 'EAST SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4911, '13060', '+43.027813', '-076.416612', 'ELBRIDGE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4912, '13061', '+42.841725', '-075.744589', 'ERIEVILLE', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(4913, '13062', '+42.484352', '-076.389023', 'ETNA', 'NY', 'NEW YORK', 'TOMPKINS', 'PO BOX ONLY'),
(4914, '13063', '+42.855631', '-075.976158', 'FABIUS', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4915, '13064', '+43.431311', '-076.200448', 'FAIR HAVEN', 'NY', 'NEW YORK', 'OSWEGO', 'PO BOX ONLY'),
(4916, '13065', '+42.822662', '-076.801970', 'FAYETTE', 'NY', 'NEW YORK', 'SENECA', 'PO BOX ONLY'),
(4917, '13066', '+42.947789', '-075.995518', 'FAYETTEVILLE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4918, '13068', '+42.496530', '-076.372864', 'FREEVILLE', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(4919, '13069', '+43.345255', '-076.227027', 'FULTON', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4920, '13071', '+42.673871', '-076.526226', 'GENOA', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4921, '13072', '+42.768124', '-075.788393', 'GEORGETOWN', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(4922, '13073', '+42.579298', '-076.392709', 'GROTON', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(4923, '13074', '+43.324451', '-076.306549', 'HANNIBAL', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4924, '13076', '+43.338817', '-076.189586', 'HASTINGS', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4925, '13077', '+42.678012', '-076.175275', 'HOMER', 'NY', 'NEW YORK', 'CORTLAND', 'STANDARD'),
(4926, '13078', '+42.966136', '-076.057658', 'JAMESVILLE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4927, '13080', '+43.067413', '-076.439657', 'JORDAN', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4928, '13081', '+42.876886', '-076.631117', 'KING FERRY', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4929, '13082', '+43.103886', '-075.961597', 'KIRKVILLE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4930, '13083', '+43.642147', '-076.029304', 'LACONA', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4931, '13084', '+42.891099', '-076.128862', 'LA FAYETTE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4932, '13087', '+42.706981', '-076.156103', 'LITTLE YORK', 'NY', 'NEW YORK', 'CORTLAND', 'PO BOX ONLY'),
(4933, '13088', '+43.124866', '-076.207867', 'LIVERPOOL', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4934, '13089', '+43.021430', '-076.197701', 'LIVERPOOL', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4935, '13090', '+43.152767', '-076.223459', 'LIVERPOOL', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4936, '13092', '+42.659466', '-076.410528', 'LOCKE', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4937, '13093', '+43.431311', '-076.200448', 'LYCOMING', 'NY', 'NEW YORK', 'OSWEGO', 'PO BOX ONLY'),
(4938, '13101', '+42.597468', '-076.072949', 'MC GRAW', 'NY', 'NEW YORK', 'CORTLAND', 'STANDARD'),
(4939, '13102', '+42.554215', '-076.292723', 'MC LEAN', 'NY', 'NEW YORK', 'TOMPKINS', 'PO BOX ONLY'),
(4940, '13103', '+43.339851', '-076.096357', 'MALLORY', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4941, '13104', '+42.955618', '-075.966540', 'MANLIUS', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4942, '13107', '+43.457798', '-076.153442', 'MAPLE VIEW', 'NY', 'NEW YORK', 'OSWEGO', 'PO BOX ONLY'),
(4943, '13108', '+42.948057', '-076.329799', 'MARCELLUS', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4944, '13110', '+42.880900', '-076.291265', 'MARIETTA', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4945, '13111', '+43.258337', '-076.629200', 'MARTVILLE', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4946, '13112', '+43.098983', '-076.413216', 'MEMPHIS', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4947, '13113', '+43.089111', '-076.621747', 'MERIDIAN', 'NY', 'NEW YORK', 'CAYUGA', 'PO BOX ONLY'),
(4948, '13114', '+43.398473', '-076.204997', 'MEXICO', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4949, '13115', '+43.397671', '-076.482365', 'MINETTO', 'NY', 'NEW YORK', 'OSWEGO', 'PO BOX ONLY'),
(4950, '13116', '+43.076828', '-076.006001', 'MINOA', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4951, '13117', '+43.002267', '-076.704722', 'MONTEZUMA', 'NY', 'NEW YORK', 'CAYUGA', 'PO BOX ONLY'),
(4952, '13118', '+42.737724', '-076.407811', 'MORAVIA', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4953, '13119', '+42.974460', '-076.440833', 'MOTTVILLE', 'NY', 'NEW YORK', 'ONONDAGA', 'PO BOX ONLY'),
(4954, '13120', '+42.951126', '-076.179845', 'NEDROW', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4955, '13121', '+43.483379', '-076.315044', 'NEW HAVEN', 'NY', 'NEW YORK', 'OSWEGO', 'PO BOX ONLY'),
(4956, '13122', '+42.825164', '-075.852660', 'NEW WOODSTOCK', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(4957, '13123', '+43.236407', '-075.776918', 'NORTH BAY', 'NY', 'NEW YORK', 'ONEIDA', 'PO BOX ONLY'),
(4958, '13124', '+42.479801', '-075.622857', 'NORTH PITCHER', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(4959, '13126', '+43.465388', '-076.342172', 'OSWEGO', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4960, '13129', '+42.712735', '-075.731391', 'GEORGETOWN', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(4961, '13131', '+43.433970', '-076.120904', 'PARISH', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4962, '13132', '+43.296808', '-076.229091', 'PENNELLVILLE', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4963, '13134', '+42.968619', '-075.679351', 'PETERBORO', 'NY', 'NEW YORK', 'MADISON', 'PO BOX ONLY'),
(4964, '13135', '+43.330210', '-076.260803', 'PHOENIX', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4965, '13136', '+42.619466', '-075.845544', 'PITCHER', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(4966, '13137', '+43.157653', '-076.446980', 'PLAINVILLE', 'NY', 'NEW YORK', 'ONONDAGA', 'PO BOX ONLY'),
(4967, '13138', '+42.892740', '-076.026459', 'POMPEY', 'NY', 'NEW YORK', 'ONONDAGA', 'PO BOX ONLY'),
(4968, '13139', '+42.742057', '-076.628454', 'POPLAR RIDGE', 'NY', 'NEW YORK', 'CAYUGA', 'PO BOX ONLY'),
(4969, '13140', '+42.886349', '-076.541321', 'PORT BYRON', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4970, '13141', '+42.739682', '-076.157108', 'PREBLE', 'NY', 'NEW YORK', 'CORTLAND', 'STANDARD'),
(4971, '13142', '+43.560497', '-076.155320', 'PULASKI', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4972, '13143', '+43.238248', '-076.752077', 'RED CREEK', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(4973, '13144', '+43.571095', '-075.972208', 'RICHLAND', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4974, '13145', '+43.621562', '-076.110290', 'SANDY CREEK', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4975, '13146', '+43.099386', '-076.762705', 'SAVANNAH', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(4976, '13147', '+42.770829', '-076.586213', 'SCIPIO CENTER', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4977, '13148', '+42.905264', '-076.794921', 'SENECA FALLS', 'NY', 'NEW YORK', 'SENECA', 'STANDARD'),
(4978, '13152', '+42.884394', '-076.285202', 'SKANEATELES', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4979, '13153', '+42.991112', '-076.451147', 'SKANEATELES FALLS', 'NY', 'NEW YORK', 'ONONDAGA', 'PO BOX ONLY'),
(4980, '13154', '+43.134425', '-076.765591', 'SOUTH BUTLER', 'NY', 'NEW YORK', 'WAYNE', 'PO BOX ONLY'),
(4981, '13155', '+42.654768', '-075.769855', 'SOUTH OTSELIC', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(4982, '13156', '+43.341948', '-076.665228', 'STERLING', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4983, '13157', '+43.209147', '-075.723070', 'SYLVAN BEACH', 'NY', 'NEW YORK', 'ONEIDA', 'PO BOX ONLY'),
(4984, '13158', '+42.696543', '-075.984090', 'TRUXTON', 'NY', 'NEW YORK', 'CORTLAND', 'STANDARD'),
(4985, '13159', '+42.830037', '-076.124357', 'TULLY', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4986, '13160', '+42.847447', '-076.649164', 'UNION SPRINGS', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4987, '13162', '+43.188520', '-075.712551', 'VERONA BEACH', 'NY', 'NEW YORK', 'ONEIDA', 'PO BOX ONLY'),
(4988, '13163', '+43.078461', '-075.701639', 'WAMPSVILLE', 'NY', 'NEW YORK', 'MADISON', 'PO BOX ONLY'),
(4989, '13164', '+43.100588', '-076.321678', 'WARNERS', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4990, '13165', '+42.892556', '-076.882263', 'WATERLOO', 'NY', 'NEW YORK', 'SENECA', 'STANDARD'),
(4991, '13166', '+43.046493', '-076.555316', 'WEEDSPORT', 'NY', 'NEW YORK', 'CAYUGA', 'STANDARD'),
(4992, '13167', '+43.346453', '-076.229719', 'WEST MONROE', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(4993, '13201', '+43.021430', '-076.197701', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4994, '13202', '+43.043116', '-076.150796', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4995, '13203', '+43.062016', '-076.134145', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4996, '13204', '+43.055766', '-076.177597', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4997, '13205', '+43.006816', '-076.142495', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4998, '13206', '+43.076416', '-076.109995', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(4999, '13207', '+43.012216', '-076.170596', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5000, '13208', '+43.074466', '-076.145796', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5001, '13209', '+43.084666', '-076.240549', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5002, '13210', '+43.031416', '-076.110995', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5003, '13211', '+43.091916', '-076.124645', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5004, '13212', '+43.122566', '-076.128382', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5005, '13214', '+43.039666', '-076.072153', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5006, '13215', '+42.972161', '-076.227599', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5007, '13217', '+43.021430', '-076.197701', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5008, '13218', '+43.021430', '-076.197701', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5009, '13219', '+43.041703', '-076.222898', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5010, '13220', '+43.123415', '-076.128230', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5011, '13221', '+43.021430', '-076.197701', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5012, '13224', '+43.038366', '-076.099394', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5013, '13225', '+43.021430', '-076.197701', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'UNIQUE'),
(5014, '13235', '', '', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5015, '13244', '+43.037716', '-076.139646', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'UNIQUE'),
(5016, '13250', '+43.021430', '-076.197701', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'UNIQUE'),
(5017, '13251', '+43.021430', '-076.197701', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'UNIQUE'),
(5018, '13252', '+43.050966', '-076.156696', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'UNIQUE'),
(5019, '13260', '+43.021430', '-076.197701', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'UNIQUE'),
(5020, '13261', '+43.021430', '-076.197701', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5021, '13290', '+43.067576', '-076.171351', 'SYRACUSE', 'NY', 'NEW YORK', 'ONONDAGA', 'STANDARD'),
(5022, '13301', '+43.419596', '-075.224784', 'ALDER CREEK', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5023, '13302', '+43.497512', '-075.988154', 'ALTMAR', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(5024, '13303', '+43.364242', '-075.468514', 'AVA', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5025, '13304', '+43.244356', '-075.166319', 'BARNEVELD', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5026, '13305', '+43.818705', '-075.480342', 'BEAVER FALLS', 'NY', 'NEW YORK', 'LEWIS', 'PO BOX ONLY'),
(5027, '13308', '+43.137703', '-075.523266', 'BLOSSVALE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5028, '13309', '+43.233310', '-075.294896', 'BOONVILLE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5029, '13310', '+42.930711', '-075.560937', 'BOUCKVILLE', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(5030, '13312', '+43.818705', '-075.480342', 'BRANTINGHAM', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5031, '13313', '+42.879227', '-075.267172', 'BRIDGEWATER', 'NY', 'NEW YORK', 'ONEIDA', 'PO BOX ONLY'),
(5032, '13314', '+42.954541', '-075.616793', 'BROOKFIELD', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(5033, '13315', '+42.734593', '-075.133065', 'BURLINGTON FLATS', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5034, '13316', '+43.285739', '-075.626755', 'CAMDEN', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5035, '13317', '+42.867146', '-074.595636', 'CANAJOHARIE', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(5036, '13318', '+42.921786', '-075.255163', 'CASSVILLE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5037, '13319', '+43.028469', '-075.264008', 'CHADWICKS', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5038, '13320', '+42.768195', '-074.759734', 'CHERRY VALLEY', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5039, '13321', '+43.090027', '-075.387088', 'CLARK MILLS', 'NY', 'NEW YORK', 'ONEIDA', 'PO BOX ONLY'),
(5040, '13322', '+42.961973', '-075.233003', 'CLAYVILLE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5041, '13323', '+43.036697', '-075.382414', 'CLINTON', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5042, '13324', '+43.271433', '-075.047740', 'COLD BROOK', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5043, '13325', '+43.566470', '-075.425289', 'CONSTABLEVILLE', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5044, '13326', '+42.714065', '-074.890929', 'COOPERSTOWN', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5045, '13327', '+43.909848', '-075.365264', 'CROGHAN', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5046, '13328', '+42.983981', '-075.422034', 'DEANSBORO', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5047, '13329', '+43.184860', '-074.941747', 'DOLGEVILLE', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5048, '13331', '+43.816675', '-074.886163', 'EAGLE BAY', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5049, '13332', '+42.719674', '-075.558861', 'EARLVILLE', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5050, '13333', '+42.793309', '-074.837198', 'EAST SPRINGFIELD', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5051, '13334', '+42.829820', '-075.653640', 'EATON', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(5052, '13335', '+42.711712', '-075.246539', 'EDMESTON', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5053, '13337', '+42.755679', '-074.876761', 'FLY CREEK', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5054, '13338', '+43.500975', '-075.153257', 'FORESTPORT', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5055, '13339', '+42.924806', '-074.616883', 'FORT PLAIN', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(5056, '13340', '+43.039203', '-075.118168', 'FRANKFORT', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5057, '13341', '+43.036069', '-075.396214', 'FRANKLIN SPRINGS', 'NY', 'NEW YORK', 'ONEIDA', 'PO BOX ONLY'),
(5058, '13342', '+42.631530', '-075.186593', 'GARRATTSVILLE', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5059, '13343', '+43.818705', '-075.480342', 'GLENFIELD', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5060, '13345', '+43.818705', '-075.480342', 'GREIG', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5061, '13346', '+42.822667', '-075.553153', 'HAMILTON', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(5062, '13348', '+42.690531', '-075.063513', 'HARTWICK', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5063, '13350', '+43.026867', '-074.933404', 'HERKIMER', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5064, '13352', '+43.328187', '-075.117319', 'HINCKLEY', 'NY', 'NEW YORK', 'ONEIDA', 'PO BOX ONLY'),
(5065, '13353', '+43.667618', '-074.456913', 'HOFFMEISTER', 'NY', 'NEW YORK', 'HAMILTON', 'PO BOX ONLY'),
(5066, '13354', '+43.273266', '-075.301263', 'HOLLAND PATENT', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5067, '13355', '+42.817286', '-075.422764', 'HUBBARDSVILLE', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(5068, '13357', '+43.013625', '-074.958226', 'ILION', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(5069, '13360', '+43.667618', '-074.456913', 'INLET', 'NY', 'NEW YORK', 'HAMILTON', 'STANDARD'),
(5070, '13361', '+42.964369', '-074.881228', 'JORDANVILLE', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5071, '13362', '+42.980334', '-075.518569', 'KNOXBORO', 'NY', 'NEW YORK', 'ONEIDA', 'PO BOX ONLY'),
(5072, '13363', '+43.328374', '-075.520067', 'LEE CENTER', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5073, '13364', '+42.954541', '-075.616793', 'LEONARDSVILLE', 'NY', 'NEW YORK', 'MADISON', 'PO BOX ONLY'),
(5074, '13365', '+43.078904', '-074.864422', 'LITTLE FALLS', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5075, '13367', '+43.789296', '-075.415599', 'LOWVILLE', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5076, '13368', '+43.621838', '-075.365348', 'LYONS FALLS', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5077, '13401', '+43.267243', '-075.688223', 'MC CONNELLSVILLE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5078, '13402', '+42.898322', '-075.549372', 'MADISON', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(5079, '13403', '+43.172019', '-075.273710', 'MARCY', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5080, '13404', '+43.818705', '-075.480342', 'MARTINSBURG', 'NY', 'NEW YORK', 'LEWIS', 'PO BOX ONLY'),
(5081, '13406', '+43.135209', '-074.934473', 'MIDDLEVILLE', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5082, '13407', '+43.029258', '-075.011662', 'MOHAWK', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5083, '13408', '+42.924089', '-075.651484', 'MORRISVILLE', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(5084, '13409', '+42.972773', '-075.600722', 'MUNNSVILLE', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(5085, '13410', '+42.937863', '-074.611711', 'NELLISTON', 'NY', 'NEW YORK', 'MONTGOMERY', 'PO BOX ONLY'),
(5086, '13411', '+42.631807', '-075.385073', 'NEW BERLIN', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5087, '13413', '+43.067369', '-075.290911', 'NEW HARTFORD', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5088, '13415', '+42.590419', '-075.195695', 'NEW LISBON', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5089, '13416', '+43.203313', '-074.971893', 'NEWPORT', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5090, '13417', '+43.100869', '-075.294960', 'NEW YORK MILLS', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5091, '13418', '+42.954541', '-075.616793', 'NORTH BROOKFIELD', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(5092, '13420', '+43.752203', '-074.873176', 'OLD FORGE', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5093, '13421', '+43.047755', '-075.640944', 'ONEIDA', 'NY', 'NEW YORK', 'MADISON', 'STANDARD'),
(5094, '13424', '+43.056581', '-075.382910', 'ORISKANY', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5095, '13425', '+42.969650', '-075.485421', 'ORISKANY FALLS', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5096, '13426', '+43.562757', '-075.996773', 'ORWELL', 'NY', 'NEW YORK', 'OSWEGO', 'PO BOX ONLY'),
(5097, '13428', '+42.926617', '-074.544720', 'PALATINE BRIDGE', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(5098, '13431', '+43.232502', '-075.072880', 'POLAND', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5099, '13433', '+43.576823', '-075.315816', 'PORT LEYDEN', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5100, '13435', '+43.305156', '-075.150183', 'PROSPECT', 'NY', 'NEW YORK', 'ONEIDA', 'PO BOX ONLY'),
(5101, '13436', '+43.667618', '-074.456913', 'RAQUETTE LAKE', 'NY', 'NEW YORK', 'HAMILTON', 'STANDARD'),
(5102, '13437', '+43.577131', '-075.829419', 'REDFIELD', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(5103, '13438', '+43.341666', '-075.221046', 'REMSEN', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5104, '13439', '+42.840180', '-074.971590', 'RICHFIELD SPRINGS', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5105, '13440', '+43.208860', '-075.383365', 'ROME', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5106, '13441', '+43.164312', '-075.511301', 'ROME', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5107, '13442', '+43.239274', '-075.477960', 'ROME', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5108, '13449', '+43.239274', '-075.477960', 'ROME', 'NY', 'NEW YORK', 'ONEIDA', 'UNIQUE'),
(5109, '13450', '+42.708040', '-074.802488', 'ROSEBOOM', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5110, '13452', '+42.975134', '-074.657384', 'SAINT JOHNSVILLE', 'NY', 'NEW YORK', 'MONTGOMERY', 'STANDARD'),
(5111, '13454', '+43.460951', '-074.957099', 'SALISBURY CENTER', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5112, '13455', '+42.916235', '-075.354480', 'SANGERFIELD', 'NY', 'NEW YORK', 'ONEIDA', 'PO BOX ONLY'),
(5113, '13456', '+42.991124', '-075.270758', 'SAUQUOIT', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5114, '13457', '+42.775805', '-075.048502', 'SCHUYLER LAKE', 'NY', 'NEW YORK', 'OTSEGO', 'PO BOX ONLY'),
(5115, '13459', '+42.787077', '-074.584971', 'SHARON SPRINGS', 'NY', 'NEW YORK', 'SCHOHARIE', 'STANDARD'),
(5116, '13460', '+42.648204', '-075.455824', 'SHERBURNE', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5117, '13461', '+43.074349', '-075.580839', 'SHERRILL', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5118, '13464', '+42.672573', '-075.593362', 'SMYRNA', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5119, '13465', '+42.954541', '-075.616793', 'SOLSVILLE', 'NY', 'NEW YORK', 'MADISON', 'PO BOX ONLY'),
(5120, '13468', '+42.838830', '-074.858970', 'SPRINGFIELD CENTER', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5121, '13469', '+43.219369', '-075.299112', 'STITTVILLE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5122, '13470', '+43.190651', '-074.650311', 'STRATFORD', 'NY', 'NEW YORK', 'FULTON', 'STANDARD'),
(5123, '13471', '+43.228682', '-075.591423', 'TABERG', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5124, '13472', '+43.460951', '-074.957099', 'THENDARA', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5125, '13473', '+43.818705', '-075.480342', 'TURIN', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5126, '13475', '+42.893454', '-074.836685', 'VAN HORNESVILLE', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5127, '13476', '+43.092924', '-075.501610', 'VERNON', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5128, '13477', '+43.141536', '-075.530826', 'VERNON CENTER', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5129, '13478', '+43.146502', '-075.586218', 'VERONA', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5130, '13479', '+43.053769', '-075.271559', 'WASHINGTON MILLS', 'NY', 'NEW YORK', 'ONEIDA', 'PO BOX ONLY'),
(5131, '13480', '+42.926167', '-075.360922', 'WATERVILLE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5132, '13482', '+42.704333', '-075.184913', 'WEST BURLINGTON', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5133, '13483', '+43.403751', '-075.825528', 'WESTDALE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5134, '13484', '+42.854631', '-075.660462', 'WEST EATON', 'NY', 'NEW YORK', 'MADISON', 'PO BOX ONLY'),
(5135, '13485', '+42.747058', '-075.160928', 'WEST EDMESTON', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5136, '13486', '+43.339068', '-075.341898', 'WESTERNVILLE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5137, '13488', '+42.680906', '-074.765290', 'WESTFORD', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5138, '13489', '+43.444480', '-075.543231', 'WEST LEYDEN', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5139, '13490', '+43.124769', '-075.432867', 'WESTMORELAND', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5140, '13491', '+42.909122', '-075.128670', 'WEST WINFIELD', 'NY', 'NEW YORK', 'HERKIMER', 'STANDARD'),
(5141, '13492', '+43.197827', '-075.287643', 'WHITESBORO', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5142, '13493', '+43.427301', '-075.880041', 'WILLIAMSTOWN', 'NY', 'NEW YORK', 'OSWEGO', 'STANDARD'),
(5143, '13494', '+43.524904', '-075.142771', 'WOODGATE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5144, '13495', '+43.102744', '-075.321211', 'YORKVILLE', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5145, '13501', '+43.077369', '-075.233208', 'UTICA', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5146, '13502', '+43.150119', '-075.192786', 'UTICA', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5147, '13503', '+43.101869', '-075.231158', 'UTICA', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5148, '13504', '+43.136033', '-075.432486', 'UTICA', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5149, '13505', '+43.087169', '-075.260259', 'UTICA', 'NY', 'NEW YORK', 'ONEIDA', 'STANDARD'),
(5150, '13599', '+43.239274', '-075.477960', 'UTICA', 'NY', 'NEW YORK', 'ONEIDA', 'UNIQUE'),
(5151, '13601', '+44.072542', '-076.016589', 'WATERTOWN', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5152, '13602', '+44.032457', '-075.754468', 'FORT DRUM', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5153, '13603', '+43.908739', '-075.896719', 'WATERTOWN', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5154, '13605', '+43.960222', '-075.905634', 'ADAMS', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5155, '13606', '+43.831853', '-076.007188', 'ADAMS CENTER', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5156, '13607', '+44.074604', '-075.840719', 'ALEXANDRIA BAY', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5157, '13608', '+44.148052', '-075.759103', 'ANTWERP', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5158, '13611', '+43.778046', '-076.125914', 'BELLEVILLE', 'NY', 'NEW YORK', 'JEFFERSON', 'PO BOX ONLY'),
(5159, '13612', '+43.988710', '-075.766746', 'BLACK RIVER', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5160, '13613', '+44.788969', '-074.879786', 'BRASHER FALLS', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5161, '13614', '+44.538648', '-075.686660', 'BRIER HILL', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5162, '13615', '+44.057685', '-076.019634', 'BROWNVILLE', 'NY', 'NEW YORK', 'JEFFERSON', 'PO BOX ONLY'),
(5163, '13616', '+43.951428', '-075.860442', 'CALCIUM', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5164, '13617', '+44.574484', '-075.059713', 'CANTON', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5165, '13618', '+44.126469', '-076.272585', 'CAPE VINCENT', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5166, '13619', '+44.068221', '-075.920097', 'CARTHAGE', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5167, '13620', '+43.818705', '-075.480342', 'CASTORLAND', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5168, '13621', '+44.845315', '-075.047975', 'CHASE MILLS', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5169, '13622', '+44.091892', '-076.108527', 'CHAUMONT', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5170, '13623', '+44.440171', '-075.757938', 'CHIPPEWA BAY', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'PO BOX ONLY'),
(5171, '13624', '+44.144238', '-076.062002', 'CLAYTON', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5172, '13625', '+44.421607', '-075.105077', 'COLTON', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5173, '13626', '+43.892324', '-075.703596', 'COPENHAGEN', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5174, '13627', '+43.818705', '-075.480342', 'DEER RIVER', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5175, '13628', '+43.885519', '-075.798319', 'DEFERIET', 'NY', 'NEW YORK', 'JEFFERSON', 'PO BOX ONLY'),
(5176, '13630', '+44.462555', '-075.300670', 'DE KALB JUNCTION', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5177, '13631', '+43.818705', '-075.480342', 'DENMARK', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5178, '13632', '+44.139501', '-076.061552', 'DEPAUVILLE', 'NY', 'NEW YORK', 'JEFFERSON', 'PO BOX ONLY'),
(5179, '13633', '+44.498910', '-075.477156', 'DE PEYSTER', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5180, '13634', '+44.014261', '-076.080020', 'DEXTER', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5181, '13635', '+44.523528', '-075.160038', 'EDWARDS', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5182, '13636', '+43.759650', '-076.152508', 'ELLISBURG', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5183, '13637', '+44.098100', '-075.817097', 'EVANS MILLS', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5184, '13638', '+44.017510', '-075.755032', 'FELTS MILLS', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5185, '13639', '+44.238960', '-075.122756', 'FINE', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5186, '13640', '+44.321282', '-076.017151', 'WELLESLEY ISLAND', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5187, '13641', '+44.207681', '-075.914556', 'FISHERS LANDING', 'NY', 'NEW YORK', 'JEFFERSON', 'PO BOX ONLY'),
(5188, '13642', '+44.550897', '-075.237516', 'GOUVERNEUR', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5189, '13643', '+44.014698', '-075.728357', 'GREAT BEND', 'NY', 'NEW YORK', 'JEFFERSON', 'PO BOX ONLY'),
(5190, '13645', '+44.533125', '-075.192865', 'HAILESBORO', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'PO BOX ONLY'),
(5191, '13646', '+44.468000', '-075.359907', 'HAMMOND', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5192, '13647', '+44.608735', '-074.973218', 'HANNAWA FALLS', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'PO BOX ONLY'),
(5193, '13648', '+43.818705', '-075.480342', 'HARRISVILLE', 'NY', 'NEW YORK', 'LEWIS', 'STANDARD'),
(5194, '13649', '+44.921678', '-074.706763', 'HELENA', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'PO BOX ONLY'),
(5195, '13650', '+43.812653', '-076.208109', 'HENDERSON', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5196, '13651', '+43.870842', '-076.180886', 'HENDERSON HARBOR', 'NY', 'NEW YORK', 'JEFFERSON', 'PO BOX ONLY'),
(5197, '13652', '+44.549025', '-075.204351', 'HERMON', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5198, '13654', '+44.616648', '-075.185085', 'HEUVELTON', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5199, '13655', '+44.980232', '-074.647334', 'HOGANSBURG', 'NY', 'NEW YORK', 'FRANKLIN', 'STANDARD'),
(5200, '13656', '+44.200392', '-075.984109', 'LA FARGEVILLE', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5201, '13657', '+44.035703', '-076.090424', 'LIMERICK', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5202, '13658', '+44.516168', '-075.216420', 'LISBON', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5203, '13659', '+43.750370', '-075.899974', 'LORRAINE', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5204, '13660', '+44.770682', '-075.019312', 'MADRID', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5205, '13661', '+43.727352', '-076.090851', 'MANNSVILLE', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5206, '13662', '+44.570260', '-075.152249', 'MASSENA', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5207, '13664', '+44.555889', '-075.655877', 'MORRISTOWN', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5208, '13665', '+44.054012', '-075.514487', 'NATURAL BRIDGE', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5209, '13666', '+44.533125', '-075.192865', 'NEWTON FALLS', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'PO BOX ONLY'),
(5210, '13667', '+44.855075', '-074.942946', 'NORFOLK', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5211, '13668', '+44.535170', '-075.099289', 'NORWOOD', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5212, '13669', '+44.509143', '-075.249795', 'OGDENSBURG', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5213, '13670', '+44.216681', '-075.084323', 'OSWEGATCHIE', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5214, '13671', '+44.308475', '-075.668790', 'OXBOW', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5215, '13672', '+44.544283', '-074.780387', 'PARISHVILLE', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5216, '13673', '+44.116323', '-075.719346', 'PHILADELPHIA', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5217, '13674', '+43.733450', '-076.054313', 'PIERREPONT MANOR', 'NY', 'NEW YORK', 'JEFFERSON', 'PO BOX ONLY'),
(5218, '13675', '+44.283403', '-075.857026', 'PLESSIS', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5219, '13676', '+44.539717', '-075.142415', 'POTSDAM', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5220, '13677', '+44.673438', '-075.082041', 'PYRITES', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'PO BOX ONLY'),
(5221, '13678', '+44.828685', '-074.979811', 'RAYMONDVILLE', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'PO BOX ONLY'),
(5222, '13679', '+44.327083', '-075.803540', 'REDWOOD', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5223, '13680', '+44.452668', '-075.342977', 'RENSSELAER FALLS', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5224, '13681', '+44.439964', '-075.377707', 'RICHVILLE', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5225, '13682', '+43.856677', '-075.907485', 'RODMAN', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5226, '13683', '+44.533125', '-075.192865', 'ROOSEVELTOWN', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'PO BOX ONLY'),
(5227, '13684', '+44.382351', '-075.104276', 'RUSSELL', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5228, '13685', '+43.872933', '-076.092563', 'SACKETS HARBOR', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5229, '13687', '+44.644720', '-074.879155', 'SOUTH COLTON', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5230, '13688', '+43.951666', '-075.767772', 'SOUTH RUTLAND', 'NY', 'NEW YORK', 'JEFFERSON', 'PO BOX ONLY'),
(5231, '13690', '+44.174001', '-074.991929', 'STAR LAKE', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5232, '13691', '+44.220448', '-075.767059', 'THERESA', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5233, '13692', '+44.289833', '-076.026210', 'THOUSAND ISLAND PARK', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5234, '13693', '+44.029787', '-076.222374', 'THREE MILE BAY', 'NY', 'NEW YORK', 'JEFFERSON', 'STANDARD'),
(5235, '13694', '+44.550617', '-075.194099', 'WADDINGTON', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5236, '13695', '+44.140791', '-074.912493', 'WANAKENA', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'PO BOX ONLY'),
(5237, '13696', '+44.695630', '-074.899980', 'WEST STOCKHOLM', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5238, '13697', '+44.642889', '-074.840761', 'WINTHROP', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'STANDARD'),
(5239, '13699', '+44.496564', '-075.072951', 'POTSDAM', 'NY', 'NEW YORK', 'SAINT LAWRENCE', 'UNIQUE'),
(5240, '13730', '+42.255147', '-075.533335', 'AFTON', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5241, '13731', '+42.129230', '-074.843187', 'ANDES', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5242, '13732', '+42.049798', '-076.181009', 'APALACHIN', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5243, '13733', '+42.295949', '-075.507589', 'BAINBRIDGE', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5244, '13734', '+42.125180', '-076.405626', 'BARTON', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5245, '13736', '+42.294616', '-076.198223', 'BERKSHIRE', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5246, '13737', '+42.080494', '-076.097288', 'BIBLE SCHOOL PARK', 'NY', 'NEW YORK', 'BROOME', 'PO BOX ONLY'),
(5247, '13738', '+42.567313', '-076.123795', 'BLODGETT MILLS', 'NY', 'NEW YORK', 'CORTLAND', 'PO BOX ONLY'),
(5248, '13739', '+42.340298', '-074.874437', 'BLOOMVILLE', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5249, '13740', '+42.183045', '-074.925617', 'BOVINA CENTER', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5250, '13743', '+42.226448', '-076.309863', 'CANDOR', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5251, '13744', '+42.243783', '-075.906890', 'CASTLE CREEK', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5252, '13745', '+42.173775', '-075.872839', 'CHENANGO BRIDGE', 'NY', 'NEW YORK', 'BROOME', 'PO BOX ONLY'),
(5253, '13746', '+42.277777', '-075.846246', 'CHENANGO FORKS', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5254, '13747', '+42.505122', '-074.982056', 'COLLIERSVILLE', 'NY', 'NEW YORK', 'OTSEGO', 'PO BOX ONLY'),
(5255, '13748', '+42.108659', '-075.809834', 'CONKLIN', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5256, '13749', '+42.206745', '-075.744880', 'CORBETTSVILLE', 'NY', 'NEW YORK', 'BROOME', 'PO BOX ONLY'),
(5257, '13750', '+42.444889', '-074.840217', 'DAVENPORT', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5258, '13751', '+42.424859', '-074.900195', 'DAVENPORT CENTER', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5259, '13752', '+42.220641', '-074.916308', 'DE LANCEY', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5260, '13753', '+42.293718', '-074.920671', 'DELHI', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5261, '13754', '+42.097004', '-075.713691', 'DEPOSIT', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5262, '13755', '+42.035768', '-074.900852', 'DOWNSVILLE', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5263, '13756', '+42.003935', '-075.122615', 'EAST BRANCH', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5264, '13757', '+42.350091', '-074.977712', 'EAST MEREDITH', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5265, '13758', '+42.583518', '-075.721931', 'EAST PHARSALIA', 'NY', 'NEW YORK', 'CHENANGO', 'PO BOX ONLY'),
(5266, '13760', '+42.150588', '-076.055064', 'ENDICOTT', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5267, '13761', '+42.206745', '-075.744880', 'ENDICOTT', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5268, '13762', '+42.206745', '-075.744880', 'ENDWELL', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5269, '13763', '+42.206745', '-075.744880', 'ENDICOTT', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5270, '13774', '+42.183045', '-074.925617', 'FISHS EDDY', 'NY', 'NEW YORK', 'DELAWARE', 'PO BOX ONLY'),
(5271, '13775', '+42.328870', '-075.136628', 'FRANKLIN', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5272, '13776', '+42.458584', '-075.311836', 'GILBERTSVILLE', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5273, '13777', '+42.244157', '-075.989275', 'GLEN AUBREY', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5274, '13778', '+42.340130', '-075.734191', 'GREENE', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5275, '13780', '+42.365134', '-075.611685', 'GUILFORD', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5276, '13782', '+42.192781', '-075.012689', 'HAMDEN', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5277, '13783', '+42.115853', '-075.028814', 'HANCOCK', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5278, '13784', '+42.431068', '-076.159312', 'HARFORD', 'NY', 'NEW YORK', 'CORTLAND', 'PO BOX ONLY'),
(5279, '13786', '+42.183045', '-074.925617', 'HARPERSFIELD', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5280, '13787', '+42.186306', '-075.676180', 'HARPURSVILLE', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5281, '13788', '+42.380427', '-074.711604', 'HOBART', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5282, '13790', '+42.159206', '-075.930931', 'JOHNSON CITY', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5283, '13794', '+42.402816', '-076.036582', 'KILLAWOG', 'NY', 'NEW YORK', 'BROOME', 'PO BOX ONLY'),
(5284, '13795', '+42.056172', '-075.788126', 'KIRKWOOD', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5285, '13796', '+42.555454', '-075.135511', 'LAURENS', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5286, '13797', '+42.339355', '-076.045026', 'LISLE', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5287, '13801', '+42.497120', '-075.731309', 'MC DONOUGH', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5288, '13802', '+42.253754', '-076.046399', 'MAINE', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5289, '13803', '+42.497925', '-076.047429', 'MARATHON', 'NY', 'NEW YORK', 'CORTLAND', 'STANDARD'),
(5290, '13804', '+42.183045', '-074.925617', 'MASONVILLE', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5291, '13806', '+42.183045', '-074.925617', 'MERIDALE', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5292, '13807', '+42.601799', '-074.975717', 'MILFORD', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5293, '13808', '+42.531661', '-075.131023', 'MORRIS', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5294, '13809', '+42.400281', '-075.451576', 'MOUNT UPTON', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5295, '13810', '+42.610748', '-075.102602', 'MOUNT VISION', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5296, '13811', '+42.170428', '-076.213825', 'NEWARK VALLEY', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5297, '13812', '+42.039954', '-076.370793', 'NICHOLS', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5298, '13813', '+42.147454', '-075.556560', 'NINEVEH', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5299, '13814', '+42.603574', '-075.528221', 'NORTH NORWICH', 'NY', 'NEW YORK', 'CHENANGO', 'PO BOX ONLY'),
(5300, '13815', '+42.536226', '-075.601779', 'NORWICH', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5301, '13820', '+42.461688', '-075.096727', 'ONEONTA', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5302, '13825', '+42.441165', '-075.148268', 'OTEGO', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5303, '13826', '+42.112127', '-075.639586', 'OUAQUAGA', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5304, '13827', '+42.176816', '-076.256800', 'OWEGO', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5305, '13830', '+42.437881', '-075.567327', 'OXFORD', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5306, '13832', '+42.568979', '-075.654133', 'PLYMOUTH', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5307, '13833', '+42.195785', '-075.759054', 'PORT CRANE', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5308, '13834', '+42.539439', '-074.966985', 'PORTLANDVILLE', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5309, '13835', '+42.371552', '-076.197488', 'RICHFORD', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5310, '13837', '+42.183045', '-074.925617', 'SHINHOPPLE', 'NY', 'NEW YORK', 'DELAWARE', 'PO BOX ONLY'),
(5311, '13838', '+42.308884', '-075.391644', 'SIDNEY', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5312, '13839', '+42.217118', '-075.232488', 'SIDNEY CENTER', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5313, '13840', '+42.039512', '-076.400376', 'SMITHBORO', 'NY', 'NEW YORK', 'TIOGA', 'PO BOX ONLY'),
(5314, '13841', '+42.461525', '-075.632735', 'SMITHVILLE FLATS', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5315, '13842', '+42.183045', '-074.925617', 'SOUTH KORTRIGHT', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5316, '13843', '+42.542579', '-075.412243', 'SOUTH NEW BERLIN', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5317, '13844', '+42.624833', '-075.652767', 'SOUTH PLYMOUTH', 'NY', 'NEW YORK', 'CHENANGO', 'STANDARD'),
(5318, '13845', '+42.065842', '-076.381946', 'TIOGA CENTER', 'NY', 'NEW YORK', 'TIOGA', 'PO BOX ONLY'),
(5319, '13846', '+42.380509', '-075.059702', 'TREADWELL', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5320, '13847', '+42.183045', '-074.925617', 'TROUT CREEK', 'NY', 'NEW YORK', 'DELAWARE', 'PO BOX ONLY'),
(5321, '13848', '+42.214705', '-075.727699', 'TUNNEL', 'NY', 'NEW YORK', 'BROOME', 'PO BOX ONLY'),
(5322, '13849', '+42.382962', '-075.292321', 'UNADILLA', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5323, '13850', '+42.055476', '-076.027088', 'VESTAL', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5324, '13851', '+42.206745', '-075.744880', 'VESTAL', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5325, '13856', '+42.250118', '-075.125556', 'WALTON', 'NY', 'NEW YORK', 'DELAWARE', 'STANDARD'),
(5326, '13859', '+42.379383', '-075.264556', 'WELLS BRIDGE', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5327, '13860', '+42.183045', '-074.925617', 'WEST DAVENPORT', 'NY', 'NEW YORK', 'DELAWARE', 'PO BOX ONLY'),
(5328, '13861', '+42.501093', '-075.140874', 'WEST ONEONTA', 'NY', 'NEW YORK', 'OTSEGO', 'STANDARD'),
(5329, '13862', '+42.321825', '-075.945183', 'WHITNEY POINT', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5330, '13863', '+42.449946', '-075.924813', 'WILLET', 'NY', 'NEW YORK', 'CORTLAND', 'STANDARD'),
(5331, '13864', '+42.186744', '-076.348074', 'WILLSEYVILLE', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5332, '13865', '+42.069103', '-075.644078', 'WINDSOR', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5333, '13901', '+42.165629', '-075.890685', 'BINGHAMTON', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5334, '13902', '+42.105375', '-075.887600', 'BINGHAMTON', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5335, '13903', '+42.083005', '-075.923248', 'BINGHAMTON', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5336, '13904', '+42.131088', '-075.787801', 'BINGHAMTON', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5337, '13905', '+42.173709', '-075.922159', 'BINGHAMTON', 'NY', 'NEW YORK', 'BROOME', 'STANDARD'),
(5338, '14001', '+43.013808', '-078.525296', 'AKRON', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5339, '14003', '+42.998052', '-078.184813', 'ALABAMA', 'NY', 'NEW YORK', 'GENESEE', 'PO BOX ONLY'),
(5340, '14004', '+42.872937', '-078.528446', 'ALDEN', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5341, '14005', '+42.917622', '-078.264873', 'ALEXANDER', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5342, '14006', '+42.823386', '-078.858355', 'ANGOLA', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5343, '14008', '+43.291696', '-078.626944', 'APPLETON', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5344, '14009', '+42.597171', '-078.374630', 'ARCADE', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5345, '14010', '+42.768413', '-078.887094', 'ATHOL SPRINGS', 'NY', 'NEW YORK', 'ERIE', 'PO BOX ONLY'),
(5346, '14011', '+42.699424', '-078.287793', 'ATTICA', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5347, '14012', '+43.327031', '-078.534963', 'BARKER', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5348, '14013', '+43.077884', '-078.394594', 'BASOM', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5349, '14020', '+42.980544', '-078.231764', 'BATAVIA', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5350, '14021', '+42.998052', '-078.184813', 'BATAVIA', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5351, '14024', '+42.590046', '-078.246616', 'BLISS', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5352, '14025', '+42.625391', '-078.726767', 'BOSTON', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5353, '14026', '+42.941008', '-078.688009', 'BOWMANSVILLE', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5354, '14027', '+42.570750', '-079.030785', 'BRANT', 'NY', 'NEW YORK', 'ERIE', 'PO BOX ONLY'),
(5355, '14028', '+43.313814', '-078.736907', 'BURT', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5356, '14029', '+42.474283', '-078.247413', 'CENTERVILLE', 'NY', 'NEW YORK', 'ALLEGANY', 'PO BOX ONLY'),
(5357, '14030', '+42.560669', '-078.522178', 'CHAFFEE', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5358, '14031', '+42.992968', '-078.601269', 'CLARENCE', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5359, '14032', '+42.937314', '-078.593381', 'CLARENCE CENTER', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5360, '14033', '+42.646441', '-078.666272', 'COLDEN', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5361, '14034', '+42.668773', '-078.816333', 'COLLINS', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5362, '14035', '+42.490640', '-078.849861', 'COLLINS CENTER', 'NY', 'NEW YORK', 'ERIE', 'PO BOX ONLY'),
(5363, '14036', '+42.978522', '-078.372338', 'CORFU', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5364, '14037', '+42.807705', '-078.446855', 'COWLESVILLE', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5365, '14038', '+42.947259', '-078.474444', 'CRITTENDEN', 'NY', 'NEW YORK', 'ERIE', 'PO BOX ONLY'),
(5366, '14039', '+42.837456', '-078.171900', 'DALE', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5367, '14040', '+42.895989', '-078.385667', 'DARIEN CENTER', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5368, '14041', '+42.408583', '-078.984391', 'DAYTON', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5369, '14042', '+42.473934', '-078.494065', 'DELEVAN', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5370, '14043', '+42.898958', '-078.707872', 'DEPEW', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5371, '14047', '+42.683522', '-078.995736', 'DERBY', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5372, '14048', '+42.487716', '-079.328287', 'DUNKIRK', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5373, '14051', '+43.042907', '-078.698796', 'EAST AMHERST', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5374, '14052', '+42.768209', '-078.577136', 'EAST AURORA', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5375, '14054', '+42.917037', '-078.126525', 'EAST BETHANY', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5376, '14055', '+42.559423', '-078.621851', 'EAST CONCORD', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5377, '14056', '+42.991173', '-078.312171', 'EAST PEMBROKE', 'NY', 'NEW YORK', 'GENESEE', 'PO BOX ONLY'),
(5378, '14057', '+42.641429', '-078.875456', 'EDEN', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5379, '14058', '+43.088434', '-078.162610', 'ELBA', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5380, '14059', '+42.828309', '-078.628966', 'ELMA', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5381, '14060', '+42.445698', '-078.341227', 'FARMERSVILLE STATION', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5382, '14061', '+42.594627', '-079.084040', 'FARNHAM', 'NY', 'NEW YORK', 'ERIE', 'PO BOX ONLY'),
(5383, '14062', '+42.441146', '-079.172343', 'FORESTVILLE', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5384, '14063', '+42.412217', '-079.319254', 'FREDONIA', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5385, '14065', '+42.475344', '-078.370334', 'FREEDOM', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5386, '14066', '+42.629014', '-078.194480', 'GAINESVILLE', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5387, '14067', '+43.208166', '-078.566230', 'GASPORT', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5388, '14068', '+43.026737', '-078.762454', 'GETZVILLE', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5389, '14069', '+42.610187', '-078.639976', 'GLENWOOD', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5390, '14070', '+42.419940', '-078.954628', 'GOWANDA', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5391, '14072', '+43.015256', '-078.958945', 'GRAND ISLAND', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5392, '14075', '+42.729083', '-078.837596', 'HAMBURG', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5393, '14080', '+42.640179', '-078.543738', 'HOLLAND', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5394, '14081', '+42.543516', '-079.101301', 'IRVING', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5395, '14082', '+42.651610', '-078.387099', 'JAVA CENTER', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5396, '14083', '+42.675193', '-078.436442', 'JAVA VILLAGE', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5397, '14085', '+42.716055', '-078.929357', 'LAKE VIEW', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5398, '14086', '+42.907658', '-078.632137', 'LANCASTER', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5399, '14091', '+42.543860', '-078.944750', 'LAWTONS', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5400, '14092', '+43.170805', '-078.989515', 'LEWISTON', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5401, '14094', '+43.168463', '-078.706886', 'LOCKPORT', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5402, '14095', '+43.326840', '-078.830681', 'LOCKPORT', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5403, '14098', '+43.324031', '-078.367151', 'LYNDONVILLE', 'NY', 'NEW YORK', 'ORLEANS', 'STANDARD'),
(5404, '14101', '+42.389170', '-078.554217', 'MACHIAS', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5405, '14102', '+42.851099', '-078.547172', 'MARILLA', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5406, '14103', '+43.239442', '-078.359871', 'MEDINA', 'NY', 'NEW YORK', 'ORLEANS', 'STANDARD'),
(5407, '14105', '+43.196947', '-078.502849', 'MIDDLEPORT', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5408, '14107', '+43.326840', '-078.830681', 'MODEL CITY', 'NY', 'NEW YORK', 'NIAGARA', 'PO BOX ONLY'),
(5409, '14108', '+43.271156', '-078.724806', 'NEWFANE', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5410, '14109', '+43.326840', '-078.830681', 'NIAGARA UNIVERSITY', 'NY', 'NEW YORK', 'NIAGARA', 'PO BOX ONLY'),
(5411, '14110', '+42.768413', '-078.887094', 'NORTH BOSTON', 'NY', 'NEW YORK', 'ERIE', 'PO BOX ONLY'),
(5412, '14111', '+42.583165', '-078.918880', 'NORTH COLLINS', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5413, '14112', '+42.691742', '-078.992658', 'NORTH EVANS', 'NY', 'NEW YORK', 'ERIE', 'PO BOX ONLY'),
(5414, '14113', '+42.656199', '-078.340092', 'NORTH JAVA', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5415, '14120', '+43.179206', '-078.808908', 'NORTH TONAWANDA', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5416, '14125', '+43.087438', '-078.269677', 'OAKFIELD', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5417, '14126', '+43.330443', '-078.726661', 'OLCOTT', 'NY', 'NEW YORK', 'NIAGARA', 'PO BOX ONLY'),
(5418, '14127', '+42.742541', '-078.704437', 'ORCHARD PARK', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5419, '14129', '+42.472671', '-079.007621', 'PERRYSBURG', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5420, '14130', '+42.543108', '-078.153849', 'PIKE', 'NY', 'NEW YORK', 'WYOMING', 'PO BOX ONLY'),
(5421, '14131', '+43.233055', '-078.906562', 'RANSOMVILLE', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5422, '14132', '+43.153105', '-078.885611', 'SANBORN', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5423, '14133', '+42.489129', '-078.366991', 'SANDUSKY', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5424, '14134', '+42.532281', '-078.517233', 'SARDINIA', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5425, '14135', '+42.488983', '-079.238997', 'SHERIDAN', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'PO BOX ONLY'),
(5426, '14136', '+42.520038', '-079.207843', 'SILVER CREEK', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5427, '14138', '+42.374077', '-078.946430', 'SOUTH DAYTON', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5428, '14139', '+42.716759', '-078.543478', 'SOUTH WALES', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5429, '14140', '+42.807159', '-078.667599', 'SPRING BROOK', 'NY', 'NEW YORK', 'ERIE', 'PO BOX ONLY'),
(5430, '14141', '+42.538335', '-078.685169', 'SPRINGVILLE', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5431, '14143', '+42.975195', '-078.069868', 'STAFFORD', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5432, '14144', '+43.199494', '-079.042477', 'STELLA NIAGARA', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5433, '14145', '+42.733778', '-078.423303', 'STRYKERSVILLE', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5434, '14150', '+42.997040', '-078.878659', 'TONAWANDA', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5435, '14151', '+42.768413', '-078.887094', 'TONAWANDA', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5436, '14166', '+42.451100', '-079.415421', 'VAN BUREN POINT', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5437, '14167', '+42.738977', '-078.312478', 'VARYSBURG', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5438, '14168', '+42.509271', '-078.999471', 'VERSAILLES', 'NY', 'NEW YORK', 'CATTARAUGUS', 'PO BOX ONLY'),
(5439, '14169', '+42.767333', '-078.585646', 'WALES CENTER', 'NY', 'NEW YORK', 'ERIE', 'PO BOX ONLY'),
(5440, '14170', '+42.702797', '-078.670098', 'WEST FALLS', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5441, '14171', '+42.406409', '-078.639581', 'WEST VALLEY', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5442, '14172', '+43.272729', '-078.831010', 'WILSON', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5443, '14173', '+42.524691', '-078.475474', 'YORKSHIRE', 'NY', 'NEW YORK', 'CATTARAUGUS', 'PO BOX ONLY'),
(5444, '14174', '+43.244454', '-078.988325', 'YOUNGSTOWN', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5445, '14201', '+42.929303', '-078.832706', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5446, '14202', '+42.889662', '-078.884157', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5447, '14203', '+42.868057', '-078.867906', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5448, '14204', '+42.882957', '-078.864898', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5449, '14205', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5450, '14206', '+42.881012', '-078.814555', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5451, '14207', '+42.949557', '-078.897009', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5452, '14208', '+42.916107', '-078.858157', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5453, '14209', '+42.918107', '-078.865857', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5454, '14210', '+42.863608', '-078.825755', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5455, '14211', '+42.912257', '-078.819005', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5456, '14212', '+42.894558', '-078.818805', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5457, '14213', '+42.918057', '-078.891108', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5458, '14214', '+42.940107', '-078.835256', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5459, '14215', '+42.932957', '-078.812252', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5460, '14216', '+42.946407', '-078.860407', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5461, '14217', '+42.900044', '-078.808205', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5462, '14218', '+42.814558', '-078.807754', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5463, '14219', '+42.786308', '-078.826444', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5464, '14220', '+42.845908', '-078.823005', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5465, '14221', '+42.968507', '-078.749153', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5466, '14222', '+42.918207', '-078.875007', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5467, '14223', '+42.974607', '-078.850507', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5468, '14224', '+42.837128', '-078.748352', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5469, '14225', '+42.925458', '-078.748145', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5470, '14226', '+42.974389', '-078.794905', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5471, '14227', '+42.885308', '-078.746202', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5472, '14228', '+43.026016', '-078.766073', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5473, '14231', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5474, '14233', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5475, '14240', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5476, '14241', '+42.938258', '-078.744053', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5477, '14260', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5478, '14261', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5479, '14263', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5480, '14264', '+42.885568', '-078.873479', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5481, '14265', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5482, '14267', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5483, '14269', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5484, '14270', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5485, '14272', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5486, '14273', '+42.754950', '-078.784908', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5487, '14276', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'UNIQUE'),
(5488, '14280', '+42.768413', '-078.887094', 'BUFFALO', 'NY', 'NEW YORK', 'ERIE', 'STANDARD'),
(5489, '14301', '+43.089805', '-079.009414', 'NIAGARA FALLS', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5490, '14302', '+43.326840', '-078.830681', 'NIAGARA FALLS', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5491, '14303', '+43.086455', '-079.037965', 'NIAGARA FALLS', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5492, '14304', '+43.100305', '-078.952112', 'NIAGARA FALLS', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5493, '14305', '+43.117255', '-079.018415', 'NIAGARA FALLS', 'NY', 'NEW YORK', 'NIAGARA', 'STANDARD'),
(5494, '14410', '+43.195261', '-077.855883', 'ADAMS BASIN', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5495, '14411', '+43.235143', '-078.194251', 'ALBION', 'NY', 'NEW YORK', 'ORLEANS', 'STANDARD'),
(5496, '14413', '+43.222735', '-076.982149', 'ALTON', 'NY', 'NEW YORK', 'WAYNE', 'PO BOX ONLY'),
(5497, '14414', '+42.895631', '-077.735104', 'AVON', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5498, '14415', '+42.754115', '-077.026379', 'BELLONA', 'NY', 'NEW YORK', 'YATES', 'STANDARD'),
(5499, '14416', '+43.073792', '-078.019684', 'BERGEN', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5500, '14418', '+42.622634', '-077.227187', 'BRANCHPORT', 'NY', 'NEW YORK', 'YATES', 'STANDARD'),
(5501, '14420', '+43.223303', '-077.917335', 'BROCKPORT', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5502, '14422', '+43.073142', '-078.056938', 'BYRON', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5503, '14423', '+42.935329', '-077.838998', 'CALEDONIA', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5504, '14424', '+42.813576', '-077.289687', 'CANANDAIGUA', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5505, '14425', '+42.958041', '-077.308256', 'FARMINGTON', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5506, '14427', '+42.626740', '-078.059147', 'CASTILE', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5507, '14428', '+43.074911', '-077.835003', 'CHURCHVILLE', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5508, '14429', '+43.381027', '-078.231338', 'CLARENDON', 'NY', 'NEW YORK', 'ORLEANS', 'PO BOX ONLY'),
(5509, '14430', '+43.286024', '-077.684264', 'CLARKSON', 'NY', 'NEW YORK', 'MONROE', 'PO BOX ONLY'),
(5510, '14432', '+42.962932', '-077.150097', 'CLIFTON SPRINGS', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5511, '14433', '+43.097869', '-076.872736', 'CLYDE', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5512, '14435', '+42.723231', '-077.668291', 'CONESUS', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5513, '14437', '+42.618370', '-077.737515', 'DANSVILLE', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5514, '14441', '+42.722446', '-076.963823', 'DRESDEN', 'NY', 'NEW YORK', 'YATES', 'STANDARD'),
(5515, '14443', '+42.900966', '-077.423310', 'EAST BLOOMFIELD', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5516, '14445', '+43.113563', '-077.482538', 'EAST ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5517, '14449', '+43.235369', '-077.137642', 'EAST WILLIAMSON', 'NY', 'NEW YORK', 'WAYNE', 'PO BOX ONLY'),
(5518, '14450', '+43.104287', '-077.428964', 'FAIRPORT', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5519, '14452', '+43.381027', '-078.231338', 'FANCHER', 'NY', 'NEW YORK', 'ORLEANS', 'PO BOX ONLY'),
(5520, '14453', '+43.010908', '-077.470540', 'FISHERS', 'NY', 'NEW YORK', 'ONTARIO', 'PO BOX ONLY'),
(5521, '14454', '+42.783801', '-077.777872', 'GENESEO', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5522, '14456', '+42.857414', '-077.034883', 'GENEVA', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5523, '14461', '+42.808127', '-077.287611', 'GORHAM', 'NY', 'NEW YORK', 'ONTARIO', 'PO BOX ONLY'),
(5524, '14462', '+42.694819', '-077.754628', 'GROVELAND', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5525, '14463', '+42.796578', '-077.063876', 'HALL', 'NY', 'NEW YORK', 'ONTARIO', 'PO BOX ONLY'),
(5526, '14464', '+43.321659', '-077.925097', 'HAMLIN', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5527, '14466', '+42.784810', '-077.618049', 'HEMLOCK', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5528, '14467', '+43.058863', '-077.558902', 'HENRIETTA', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5529, '14468', '+43.285210', '-077.832333', 'HILTON', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5530, '14469', '+42.869556', '-077.465843', 'BLOOMFIELD', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5531, '14470', '+43.215860', '-078.073057', 'HOLLEY', 'NY', 'NEW YORK', 'ORLEANS', 'STANDARD'),
(5532, '14471', '+42.755573', '-077.491905', 'HONEOYE', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5533, '14472', '+42.982513', '-077.606771', 'HONEOYE FALLS', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5534, '14475', '+42.935868', '-077.498231', 'IONIA', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5535, '14476', '+43.324058', '-078.049928', 'KENDALL', 'NY', 'NEW YORK', 'ORLEANS', 'STANDARD'),
(5536, '14477', '+43.330763', '-078.123328', 'KENT', 'NY', 'NEW YORK', 'ORLEANS', 'STANDARD'),
(5537, '14478', '+42.570794', '-077.122590', 'KEUKA PARK', 'NY', 'NEW YORK', 'YATES', 'STANDARD'),
(5538, '14479', '+43.241502', '-078.318828', 'KNOWLESVILLE', 'NY', 'NEW YORK', 'ORLEANS', 'PO BOX ONLY'),
(5539, '14480', '+42.837288', '-077.703091', 'LAKEVILLE', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5540, '14481', '+42.760644', '-077.903550', 'LEICESTER', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5541, '14482', '+42.956190', '-077.989988', 'LE ROY', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5542, '14485', '+42.889864', '-077.608688', 'LIMA', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5543, '14486', '+42.915297', '-077.949818', 'LINWOOD', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5544, '14487', '+42.809457', '-077.650938', 'LIVONIA', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5545, '14488', '+42.729839', '-077.773919', 'LIVONIA CENTER', 'NY', 'NEW YORK', 'LIVINGSTON', 'PO BOX ONLY'),
(5546, '14489', '+43.099263', '-076.970937', 'LYONS', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5547, '14502', '+43.110807', '-077.313450', 'MACEDON', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5548, '14504', '+42.968903', '-077.233194', 'MANCHESTER', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5549, '14505', '+43.155940', '-077.172684', 'MARION', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5550, '14506', '+43.001323', '-077.504268', 'MENDON', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5551, '14507', '+42.686845', '-077.262987', 'MIDDLESEX', 'NY', 'NEW YORK', 'YATES', 'STANDARD'),
(5552, '14508', '+43.381027', '-078.231338', 'MORTON', 'NY', 'NEW YORK', 'ORLEANS', 'PO BOX ONLY'),
(5553, '14510', '+42.683466', '-077.866402', 'MOUNT MORRIS', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5554, '14511', '+43.002612', '-077.864580', 'MUMFORD', 'NY', 'NEW YORK', 'MONROE', 'PO BOX ONLY'),
(5555, '14512', '+42.667802', '-077.413496', 'NAPLES', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5556, '14513', '+43.087067', '-077.097867', 'NEWARK', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5557, '14514', '+43.085778', '-077.805628', 'NORTH CHILI', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5558, '14515', '+43.257819', '-077.735079', 'NORTH GREECE', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5559, '14516', '+43.195842', '-076.908805', 'NORTH ROSE', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5560, '14517', '+42.591883', '-077.894474', 'NUNDA', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5561, '14518', '+42.931873', '-077.011839', 'OAKS CORNERS', 'NY', 'NEW YORK', 'ONTARIO', 'PO BOX ONLY'),
(5562, '14519', '+43.221476', '-077.308614', 'ONTARIO', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5563, '14520', '+43.348369', '-077.045288', 'ONTARIO CENTER', 'NY', 'NEW YORK', 'WAYNE', 'PO BOX ONLY'),
(5564, '14521', '+42.689791', '-076.794102', 'OVID', 'NY', 'NEW YORK', 'SENECA', 'STANDARD'),
(5565, '14522', '+43.081306', '-077.218849', 'PALMYRA', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5566, '14525', '+42.910203', '-078.026899', 'PAVILION', 'NY', 'NEW YORK', 'GENESEE', 'STANDARD'),
(5567, '14526', '+43.145813', '-077.454446', 'PENFIELD', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5568, '14527', '+42.637423', '-077.069925', 'PENN YAN', 'NY', 'NEW YORK', 'YATES', 'STANDARD'),
(5569, '14529', '+42.535363', '-077.628857', 'PERKINSVILLE', 'NY', 'NEW YORK', 'STEUBEN', 'PO BOX ONLY'),
(5570, '14530', '+42.682391', '-078.056235', 'PERRY', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5571, '14532', '+42.963394', '-077.043612', 'PHELPS', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5572, '14533', '+42.843464', '-077.896153', 'PIFFARD', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5573, '14534', '+43.060229', '-077.520692', 'PITTSFORD', 'NY', 'NEW YORK', 'MONROE', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(5574, '14536', '+42.555988', '-078.098906', 'PORTAGEVILLE', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5575, '14537', '+43.033002', '-077.157465', 'PORT GIBSON', 'NY', 'NEW YORK', 'ONTARIO', 'PO BOX ONLY'),
(5576, '14538', '+43.283582', '-077.142027', 'PULTNEYVILLE', 'NY', 'NEW YORK', 'WAYNE', 'PO BOX ONLY'),
(5577, '14539', '+42.834327', '-077.877876', 'RETSOF', 'NY', 'NEW YORK', 'LIVINGSTON', 'PO BOX ONLY'),
(5578, '14541', '+42.749713', '-076.844921', 'ROMULUS', 'NY', 'NEW YORK', 'SENECA', 'STANDARD'),
(5579, '14542', '+43.144795', '-076.860779', 'ROSE', 'NY', 'NEW YORK', 'WAYNE', 'PO BOX ONLY'),
(5580, '14543', '+42.996613', '-077.666524', 'RUSH', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5581, '14544', '+42.734157', '-077.242693', 'RUSHVILLE', 'NY', 'NEW YORK', 'YATES', 'STANDARD'),
(5582, '14545', '+42.652111', '-077.710539', 'SCOTTSBURG', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5583, '14546', '+43.044710', '-077.772652', 'SCOTTSVILLE', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5584, '14547', '+42.808127', '-077.287611', 'SENECA CASTLE', 'NY', 'NEW YORK', 'ONTARIO', 'PO BOX ONLY'),
(5585, '14548', '+42.978834', '-077.252696', 'SHORTSVILLE', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5586, '14549', '+42.692874', '-078.022364', 'SILVER LAKE', 'NY', 'NEW YORK', 'WYOMING', 'PO BOX ONLY'),
(5587, '14550', '+42.674209', '-078.084485', 'SILVER SPRINGS', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5588, '14551', '+43.210384', '-077.053517', 'SODUS', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5589, '14555', '+43.254644', '-076.983518', 'SODUS POINT', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5590, '14556', '+42.729839', '-077.773919', 'SONYEA', 'NY', 'NEW YORK', 'LIVINGSTON', 'PO BOX ONLY'),
(5591, '14557', '+43.041606', '-078.057252', 'SOUTH BYRON', 'NY', 'NEW YORK', 'GENESEE', 'PO BOX ONLY'),
(5592, '14558', '+42.855409', '-077.687643', 'SOUTH LIMA', 'NY', 'NEW YORK', 'LIVINGSTON', 'PO BOX ONLY'),
(5593, '14559', '+43.185709', '-077.830577', 'SPENCERPORT', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5594, '14560', '+42.635525', '-077.594478', 'SPRINGWATER', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5595, '14561', '+42.833360', '-077.129398', 'STANLEY', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5596, '14563', '+43.348369', '-077.045288', 'UNION HILL', 'NY', 'NEW YORK', 'WAYNE', 'PO BOX ONLY'),
(5597, '14564', '+42.973715', '-077.426906', 'VICTOR', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5598, '14568', '+43.142795', '-077.287414', 'WALWORTH', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5599, '14569', '+42.740223', '-078.164804', 'WARSAW', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5600, '14571', '+43.328706', '-078.238501', 'WATERPORT', 'NY', 'NEW YORK', 'ORLEANS', 'STANDARD'),
(5601, '14572', '+42.516793', '-077.564247', 'WAYLAND', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5602, '14580', '+43.218210', '-077.454075', 'WEBSTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5603, '14585', '+42.905459', '-077.548423', 'WEST BLOOMFIELD', 'NY', 'NEW YORK', 'ONTARIO', 'STANDARD'),
(5604, '14586', '+43.041553', '-077.683575', 'WEST HENRIETTA', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5605, '14588', '+42.683451', '-076.872442', 'WILLARD', 'NY', 'NEW YORK', 'SENECA', 'PO BOX ONLY'),
(5606, '14589', '+43.239410', '-077.163811', 'WILLIAMSON', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5607, '14590', '+43.224693', '-076.840547', 'WOLCOTT', 'NY', 'NEW YORK', 'WAYNE', 'STANDARD'),
(5608, '14591', '+42.818578', '-078.102549', 'WYOMING', 'NY', 'NEW YORK', 'WYOMING', 'STANDARD'),
(5609, '14592', '+42.875685', '-077.883511', 'YORK', 'NY', 'NEW YORK', 'LIVINGSTON', 'PO BOX ONLY'),
(5610, '14601', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5611, '14602', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5612, '14603', '+43.161613', '-077.606774', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5613, '14604', '+43.156612', '-077.604023', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5614, '14605', '+43.166313', '-077.602973', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5615, '14606', '+43.173612', '-077.691577', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5616, '14607', '+43.152013', '-077.584888', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5617, '14608', '+43.154611', '-077.624001', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5618, '14609', '+43.198197', '-077.549971', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5619, '14610', '+43.140163', '-077.557871', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5620, '14611', '+43.140163', '-077.650275', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5621, '14612', '+43.257111', '-077.678240', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5622, '14613', '+43.133780', '-077.519325', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5623, '14614', '+43.104463', '-077.512569', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5624, '14615', '+43.222520', '-077.552021', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5625, '14616', '+43.228955', '-077.680927', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5626, '14617', '+43.207062', '-077.609425', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5627, '14618', '+43.112163', '-077.561771', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5628, '14619', '+43.135688', '-077.649126', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5629, '14620', '+43.129862', '-077.618523', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5630, '14621', '+43.149013', '-077.631124', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5631, '14622', '+43.199613', '-077.595823', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5632, '14623', '+43.082184', '-077.649074', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5633, '14624', '+43.121612', '-077.731127', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5634, '14625', '+43.152213', '-077.505705', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5635, '14626', '+43.190312', '-077.720018', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5636, '14627', '+43.127513', '-077.627674', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5637, '14638', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5638, '14639', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5639, '14642', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5640, '14643', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5641, '14644', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5642, '14645', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5643, '14646', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5644, '14647', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5645, '14649', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5646, '14650', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5647, '14651', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5648, '14652', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5649, '14653', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5650, '14660', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5651, '14664', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5652, '14673', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5653, '14683', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5654, '14692', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'STANDARD'),
(5655, '14694', '+43.286024', '-077.684264', 'ROCHESTER', 'NY', 'NEW YORK', 'MONROE', 'UNIQUE'),
(5656, '14701', '+42.196125', '-079.432256', 'JAMESTOWN', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5657, '14702', '+42.081657', '-079.294921', 'JAMESTOWN', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5658, '14703', '+42.342529', '-079.410910', 'JAMESTOWN', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'UNIQUE'),
(5659, '14704', '+42.342529', '-079.410910', 'JAMESTOWN', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'UNIQUE'),
(5660, '14706', '+42.116168', '-078.516218', 'ALLEGANY', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5661, '14707', '+42.073739', '-078.059374', 'ALLENTOWN', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5662, '14708', '+42.025431', '-078.084837', 'ALMA', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5663, '14709', '+42.217609', '-078.090559', 'ANGELICA', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5664, '14710', '+42.084481', '-079.391738', 'ASHVILLE', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5665, '14711', '+42.320366', '-078.129640', 'BELFAST', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5666, '14712', '+42.164572', '-079.445292', 'BEMUS POINT', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5667, '14714', '+42.290569', '-078.237314', 'BLACK CREEK', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5668, '14715', '+42.154417', '-078.139391', 'BOLIVAR', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5669, '14716', '+42.316748', '-079.432622', 'BROCTON', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5670, '14717', '+42.257674', '-078.174601', 'CANEADEA', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5671, '14718', '+42.250021', '-079.296028', 'CASSADAGA', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5672, '14719', '+42.343336', '-078.869752', 'CATTARAUGUS', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5673, '14720', '+42.105907', '-079.279120', 'CELORON', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'PO BOX ONLY'),
(5674, '14721', '+42.013691', '-078.264775', 'CERES', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5675, '14722', '+42.187468', '-079.450523', 'CHAUTAUQUA', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'PO BOX ONLY'),
(5676, '14723', '+42.308946', '-079.387594', 'CHERRY CREEK', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5677, '14724', '+42.072680', '-079.644932', 'CLYMER', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5678, '14726', '+42.252473', '-079.008294', 'CONEWANGO VALLEY', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5679, '14727', '+42.245997', '-078.209403', 'CUBA', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5680, '14728', '+42.282800', '-079.366516', 'DEWITTVILLE', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5681, '14729', '+42.405354', '-078.735158', 'EAST OTTO', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5682, '14730', '+42.174736', '-078.947340', 'EAST RANDOLPH', 'NY', 'NEW YORK', 'CATTARAUGUS', 'PO BOX ONLY'),
(5683, '14731', '+42.297229', '-078.649654', 'ELLICOTTVILLE', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5684, '14732', '+42.229098', '-079.113470', 'ELLINGTON', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'PO BOX ONLY'),
(5685, '14733', '+42.126604', '-079.182837', 'FALCONER', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5686, '14735', '+42.450790', '-078.104285', 'FILLMORE', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5687, '14736', '+42.133206', '-079.737701', 'FINDLEY LAKE', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5688, '14737', '+42.335753', '-078.491244', 'FRANKLINVILLE', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5689, '14738', '+42.053586', '-079.118889', 'FREWSBURG', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5690, '14739', '+42.187901', '-078.157246', 'FRIENDSHIP', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5691, '14740', '+42.211290', '-079.170519', 'GERRY', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5692, '14741', '+42.217040', '-078.584117', 'GREAT VALLEY', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5693, '14742', '+42.120512', '-079.309580', 'GREENHURST', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'PO BOX ONLY'),
(5694, '14743', '+42.197916', '-078.415859', 'HINSDALE', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5695, '14744', '+42.422827', '-078.206289', 'HOUGHTON', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5696, '14745', '+42.477700', '-078.140343', 'HUME', 'NY', 'NEW YORK', 'ALLEGANY', 'PO BOX ONLY'),
(5697, '14747', '+42.152725', '-079.111065', 'KENNEDY', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5698, '14748', '+42.144977', '-078.646626', 'KILL BUCK', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5699, '14750', '+42.124810', '-079.440009', 'LAKEWOOD', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5700, '14751', '+42.298328', '-079.006231', 'LEON', 'NY', 'NEW YORK', 'CATTARAUGUS', 'PO BOX ONLY'),
(5701, '14752', '+42.352416', '-079.323502', 'LILY DALE', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'PO BOX ONLY'),
(5702, '14753', '+42.141266', '-078.607674', 'LIMESTONE', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5703, '14754', '+42.031872', '-078.209708', 'LITTLE GENESEE', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5704, '14755', '+42.254567', '-078.823628', 'LITTLE VALLEY', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5705, '14756', '+42.198150', '-079.417353', 'MAPLE SPRINGS', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5706, '14757', '+42.237160', '-079.370911', 'MAYVILLE', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5707, '14758', '+42.342529', '-079.410910', 'NIOBE', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'PO BOX ONLY'),
(5708, '14760', '+42.082142', '-078.425973', 'OLEAN', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5709, '14766', '+42.357543', '-078.807283', 'OTTO', 'NY', 'NEW YORK', 'CATTARAUGUS', 'PO BOX ONLY'),
(5710, '14767', '+42.191346', '-079.505101', 'PANAMA', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5711, '14769', '+42.371561', '-079.468963', 'PORTLAND', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5712, '14770', '+42.092944', '-078.342341', 'PORTVILLE', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5713, '14772', '+42.156841', '-078.844412', 'RANDOLPH', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5714, '14774', '+42.114385', '-078.168055', 'RICHBURG', 'NY', 'NEW YORK', 'ALLEGANY', 'PO BOX ONLY'),
(5715, '14775', '+42.230461', '-079.426780', 'RIPLEY', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5716, '14777', '+42.397363', '-078.232330', 'RUSHFORD', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5717, '14778', '+42.270112', '-078.684684', 'SAINT BONAVENTURE', 'NY', 'NEW YORK', 'CATTARAUGUS', 'PO BOX ONLY'),
(5718, '14779', '+42.180526', '-078.615625', 'SALAMANCA', 'NY', 'NEW YORK', 'CATTARAUGUS', 'STANDARD'),
(5719, '14781', '+42.172076', '-079.611348', 'SHERMAN', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5720, '14782', '+42.257762', '-079.253829', 'SINCLAIRVILLE', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5721, '14783', '+42.082001', '-078.917738', 'STEAMBURG', 'NY', 'NEW YORK', 'CATTARAUGUS', 'PO BOX ONLY'),
(5722, '14784', '+42.315140', '-079.388330', 'STOCKTON', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5723, '14785', '+42.155693', '-079.412233', 'STOW', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'PO BOX ONLY'),
(5724, '14786', '+42.122670', '-078.221332', 'WEST CLARKSVILLE', 'NY', 'NEW YORK', 'ALLEGANY', 'PO BOX ONLY'),
(5725, '14787', '+42.253734', '-079.484286', 'WESTFIELD', 'NY', 'NEW YORK', 'CHAUTAUQUA', 'STANDARD'),
(5726, '14788', '+42.062125', '-078.377974', 'WESTONS MILLS', 'NY', 'NEW YORK', 'CATTARAUGUS', 'PO BOX ONLY'),
(5727, '14801', '+42.206391', '-077.306185', 'ADDISON', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5728, '14802', '+42.240535', '-077.783192', 'ALFRED', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5729, '14803', '+42.254097', '-077.799317', 'ALFRED STATION', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5730, '14804', '+42.313285', '-077.851286', 'ALMOND', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5731, '14805', '+42.375566', '-076.732706', 'ALPINE', 'NY', 'NEW YORK', 'SCHUYLER', 'STANDARD'),
(5732, '14806', '+42.145794', '-077.811901', 'ANDOVER', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5733, '14807', '+42.465145', '-077.573870', 'ARKPORT', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5734, '14808', '+42.562012', '-077.468518', 'ATLANTA', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5735, '14809', '+42.367861', '-077.464128', 'AVOCA', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5736, '14810', '+42.357464', '-077.302789', 'BATH', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5737, '14812', '+42.322924', '-076.977336', 'BEAVER DAMS', 'NY', 'NEW YORK', 'SCHUYLER', 'STANDARD'),
(5738, '14813', '+42.242168', '-077.963148', 'BELMONT', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5739, '14814', '+42.156516', '-076.931640', 'BIG FLATS', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5740, '14815', '+42.369808', '-077.235796', 'BRADFORD', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5741, '14816', '+42.199631', '-076.731200', 'BREESPORT', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5742, '14817', '+42.359694', '-076.349154', 'BROOKTONDALE', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(5743, '14818', '+42.464152', '-076.798018', 'BURDETT', 'NY', 'NEW YORK', 'SCHUYLER', 'STANDARD'),
(5744, '14819', '+42.211491', '-077.453509', 'CAMERON', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5745, '14820', '+42.180046', '-077.280502', 'CAMERON MILLS', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5746, '14821', '+42.262954', '-077.215478', 'CAMPBELL', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5747, '14822', '+42.422577', '-077.835626', 'CANASERAGA', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5748, '14823', '+42.348146', '-077.427130', 'CANISTEO', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5749, '14824', '+42.272948', '-076.693628', 'CAYUTA', 'NY', 'NEW YORK', 'SCHUYLER', 'STANDARD'),
(5750, '14825', '+42.052426', '-076.607029', 'CHEMUNG', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5751, '14826', '+42.470356', '-077.391286', 'COHOCTON', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5752, '14827', '+42.178527', '-077.141357', 'COOPERS PLAINS', 'NY', 'NEW YORK', 'STEUBEN', 'PO BOX ONLY'),
(5753, '14830', '+42.120541', '-077.048462', 'CORNING', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5754, '14831', '+42.145265', '-077.566830', 'CORNING', 'NY', 'NEW YORK', 'STEUBEN', 'UNIQUE'),
(5755, '14836', '+42.546164', '-077.900210', 'DALTON', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5756, '14837', '+42.555387', '-077.014409', 'DUNDEE', 'NY', 'NEW YORK', 'YATES', 'STANDARD'),
(5757, '14838', '+42.181224', '-076.671949', 'ERIN', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5758, '14839', '+42.143242', '-077.562991', 'GREENWOOD', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5759, '14840', '+42.322455', '-077.198396', 'HAMMONDSPORT', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5760, '14841', '+42.492291', '-076.824556', 'HECTOR', 'NY', 'NEW YORK', 'SCHUYLER', 'STANDARD'),
(5761, '14842', '+42.577714', '-076.964520', 'HIMROD', 'NY', 'NEW YORK', 'YATES', 'STANDARD'),
(5762, '14843', '+42.383978', '-077.479051', 'HORNELL', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5763, '14844', '+42.160717', '-076.878456', 'HORSEHEADS', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5764, '14845', '+42.210030', '-076.836629', 'HORSEHEADS', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5765, '14846', '+42.555834', '-077.999451', 'HUNT', 'NY', 'NEW YORK', 'LIVINGSTON', 'STANDARD'),
(5766, '14847', '+42.608440', '-076.735556', 'INTERLAKEN', 'NY', 'NEW YORK', 'SENECA', 'STANDARD'),
(5767, '14850', '+42.402794', '-076.483999', 'ITHACA', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(5768, '14851', '+42.460721', '-076.505435', 'ITHACA', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(5769, '14852', '+42.445074', '-076.467233', 'ITHACA', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(5770, '14853', '+42.447373', '-076.483703', 'ITHACA', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(5771, '14854', '+42.506320', '-076.608222', 'JACKSONVILLE', 'NY', 'NEW YORK', 'TOMPKINS', 'PO BOX ONLY'),
(5772, '14855', '+42.142197', '-077.497908', 'JASPER', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5773, '14856', '+42.374218', '-077.364812', 'KANONA', 'NY', 'NEW YORK', 'STEUBEN', 'PO BOX ONLY'),
(5774, '14857', '+42.512632', '-076.927019', 'LAKEMONT', 'NY', 'NEW YORK', 'YATES', 'PO BOX ONLY'),
(5775, '14858', '+42.045070', '-077.106679', 'LINDLEY', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5776, '14859', '+42.115457', '-076.507823', 'LOCKWOOD', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5777, '14860', '+42.586029', '-076.801671', 'LODI', 'NY', 'NEW YORK', 'SENECA', 'STANDARD'),
(5778, '14861', '+42.087671', '-076.684615', 'LOWMAN', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5779, '14863', '+42.451569', '-076.706717', 'MECKLENBURG', 'NY', 'NEW YORK', 'SCHUYLER', 'PO BOX ONLY'),
(5780, '14864', '+42.259644', '-076.842298', 'MILLPORT', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5781, '14865', '+42.358866', '-076.841852', 'MONTOUR FALLS', 'NY', 'NEW YORK', 'SCHUYLER', 'STANDARD'),
(5782, '14867', '+42.365688', '-076.610212', 'NEWFIELD', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(5783, '14869', '+42.377454', '-076.776210', 'ODESSA', 'NY', 'NEW YORK', 'SCHUYLER', 'STANDARD'),
(5784, '14870', '+42.159759', '-077.382462', 'PAINTED POST', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5785, '14871', '+42.047024', '-076.882455', 'PINE CITY', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5786, '14872', '+42.240529', '-076.875072', 'PINE VALLEY', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5787, '14873', '+42.380560', '-077.354408', 'PRATTSBURGH', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5788, '14874', '+42.520261', '-077.197141', 'PULTENEY', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5789, '14876', '+42.429721', '-076.925846', 'READING CENTER', 'NY', 'NEW YORK', 'SCHUYLER', 'PO BOX ONLY'),
(5790, '14877', '+42.071887', '-077.677653', 'REXVILLE', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5791, '14878', '+42.480150', '-076.946931', 'ROCK STREAM', 'NY', 'NEW YORK', 'YATES', 'STANDARD'),
(5792, '14879', '+42.327262', '-077.193204', 'SAVONA', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5793, '14880', '+42.166150', '-077.965672', 'SCIO', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5794, '14881', '+42.402463', '-076.360782', 'SLATERVILLE SPRINGS', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(5795, '14882', '+42.573453', '-076.552378', 'LANSING', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(5796, '14883', '+42.203102', '-076.471165', 'SPENCER', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5797, '14884', '+42.455859', '-077.889425', 'SWAIN', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5798, '14885', '+42.060366', '-077.562142', 'TROUPSBURG', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5799, '14886', '+42.480300', '-076.635158', 'TRUMANSBURG', 'NY', 'NEW YORK', 'TOMPKINS', 'STANDARD'),
(5800, '14887', '+42.399371', '-077.026768', 'TYRONE', 'NY', 'NEW YORK', 'SCHUYLER', 'PO BOX ONLY'),
(5801, '14889', '+42.210223', '-076.585084', 'VAN ETTEN', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5802, '14891', '+42.372850', '-076.927135', 'WATKINS GLEN', 'NY', 'NEW YORK', 'SCHUYLER', 'STANDARD'),
(5803, '14892', '+42.107825', '-076.502218', 'WAVERLY', 'NY', 'NEW YORK', 'TIOGA', 'STANDARD'),
(5804, '14893', '+42.474143', '-077.097713', 'WAYNE', 'NY', 'NEW YORK', 'SCHUYLER', 'PO BOX ONLY'),
(5805, '14894', '+42.027102', '-076.764516', 'WELLSBURG', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5806, '14895', '+42.230956', '-077.917245', 'WELLSVILLE', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5807, '14897', '+42.050965', '-077.821349', 'WHITESVILLE', 'NY', 'NEW YORK', 'ALLEGANY', 'STANDARD'),
(5808, '14898', '+42.069469', '-077.438058', 'WOODHULL', 'NY', 'NEW YORK', 'STEUBEN', 'STANDARD'),
(5809, '14901', '+42.082585', '-076.718570', 'ELMIRA', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5810, '14902', '+42.147285', '-076.750888', 'ELMIRA', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5811, '14903', '+42.119824', '-076.887659', 'ELMIRA', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5812, '14904', '+42.061824', '-076.823678', 'ELMIRA', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5813, '14905', '+42.093574', '-076.844329', 'ELMIRA', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5814, '14925', '+42.147285', '-076.750888', 'ELMIRA', 'NY', 'NEW YORK', 'CHEMUNG', 'STANDARD'),
(5815, '15001', '+40.675225', '-080.304178', 'ALIQUIPPA', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5816, '15003', '+40.600494', '-080.210521', 'AMBRIDGE', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5817, '15004', '+40.341349', '-080.382247', 'ATLASBURG', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(5818, '15005', '+40.618418', '-080.204103', 'BADEN', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5819, '15006', '+40.493128', '-079.903121', 'BAIRDFORD', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'PO BOX ONLY'),
(5820, '15007', '+40.434436', '-080.024817', 'BAKERSTOWN', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5821, '15009', '+40.729053', '-080.385191', 'BEAVER', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5822, '15010', '+40.665672', '-080.352049', 'BEAVER FALLS', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5823, '15012', '+40.070268', '-079.603426', 'BELLE VERNON', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(5824, '15014', '+40.272101', '-079.899562', 'BRACKENRIDGE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5825, '15015', '+40.434436', '-080.024817', 'BRADFORDWOODS', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5826, '15017', '+40.354589', '-080.091342', 'BRIDGEVILLE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5827, '15018', '+40.457657', '-080.208374', 'BUENA VISTA', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5828, '15019', '+40.412663', '-080.317007', 'BULGER', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(5829, '15020', '+40.434436', '-080.024817', 'BUNOLA', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'PO BOX ONLY'),
(5830, '15021', '+40.382141', '-080.404366', 'BURGETTSTOWN', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(5831, '15022', '+40.135834', '-079.932907', 'CHARLEROI', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(5832, '15024', '+40.434436', '-080.024817', 'CHESWICK', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5833, '15025', '+40.324279', '-079.931735', 'CLAIRTON', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5834, '15026', '+40.490003', '-080.290333', 'CLINTON', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5835, '15027', '+40.699515', '-080.264683', 'CONWAY', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5836, '15028', '+40.434436', '-080.024817', 'COULTERS', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'PO BOX ONLY'),
(5837, '15030', '+40.434436', '-080.024817', 'CREIGHTON', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5838, '15031', '+40.354712', '-080.166906', 'CUDDY', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5839, '15032', '+40.434436', '-080.024817', 'CURTISVILLE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'PO BOX ONLY'),
(5840, '15033', '+40.179896', '-079.868392', 'DONORA', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(5841, '15034', '+40.315793', '-079.892171', 'DRAVOSBURG', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5842, '15035', '+40.434436', '-080.024817', 'EAST MC KEESPORT', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5843, '15036', '+40.214896', '-080.179139', 'ELDERSVILLE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(5844, '15037', '+40.271965', '-079.896642', 'ELIZABETH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5845, '15038', '+40.252086', '-079.925235', 'ELRAMA', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(5846, '15042', '+40.710283', '-080.240559', 'FREEDOM', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5847, '15043', '+40.639461', '-080.339953', 'GEORGETOWN', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5848, '15044', '+40.434436', '-080.024817', 'GIBSONIA', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5849, '15045', '+40.434436', '-080.024817', 'GLASSPORT', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5850, '15046', '+40.468068', '-080.123459', 'CRESCENT', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5851, '15047', '+40.434436', '-080.024817', 'GREENOCK', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'PO BOX ONLY'),
(5852, '15049', '+40.434436', '-080.024817', 'HARWICK', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5853, '15050', '+40.554305', '-080.428223', 'HOOKSTOWN', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5854, '15051', '+40.434436', '-080.024817', 'INDIANOLA', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5855, '15052', '+40.702397', '-080.388271', 'INDUSTRY', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5856, '15053', '+40.380036', '-080.360544', 'JOFFRE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(5857, '15054', '+40.362515', '-080.408551', 'LANGELOTH', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(5858, '15055', '+40.305838', '-080.121904', 'LAWRENCE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(5859, '15056', '+40.375069', '-080.015425', 'LEETSDALE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5860, '15057', '+40.359139', '-080.267451', 'MC DONALD', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(5861, '15059', '+40.740063', '-080.397486', 'MIDLAND', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5862, '15060', '+40.368121', '-080.289382', 'MIDWAY', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(5863, '15061', '+40.656366', '-080.327814', 'MONACA', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5864, '15062', '+40.361852', '-079.751280', 'MONESSEN', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(5865, '15063', '+40.260001', '-080.124442', 'MONONGAHELA', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(5866, '15064', '+40.355865', '-080.141550', 'MORGAN', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5867, '15065', '+40.434436', '-080.024817', 'NATRONA HEIGHTS', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5868, '15066', '+40.712175', '-080.321773', 'NEW BRIGHTON', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5869, '15067', '+40.282786', '-080.173907', 'NEW EAGLE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(5870, '15068', '+40.478821', '-079.581506', 'NEW KENSINGTON', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(5871, '15069', '+40.360223', '-079.439801', 'NEW KENSINGTON', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'UNIQUE'),
(5872, '15071', '+40.403348', '-080.184169', 'OAKDALE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5873, '15072', '+40.139296', '-079.856168', 'PRICEDALE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(5874, '15074', '+40.686473', '-080.326538', 'ROCHESTER', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(5875, '15075', '+40.434436', '-080.024817', 'RURAL RIDGE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'PO BOX ONLY'),
(5876, '15076', '+40.434436', '-080.024817', 'RUSSELLTON', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5877, '15077', '+40.602535', '-080.386344', 'SHIPPINGPORT', 'PA', 'PENNSYLVANIA', 'BEAVER', 'PO BOX ONLY'),
(5878, '15078', '+40.358435', '-080.387917', 'SLOVAN', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(5879, '15081', '+40.576267', '-080.238332', 'SOUTH HEIGHTS', 'PA', 'PENNSYLVANIA', 'BEAVER', 'PO BOX ONLY'),
(5880, '15082', '+40.386263', '-080.208316', 'STURGEON', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'PO BOX ONLY'),
(5881, '15083', '+40.225590', '-079.751605', 'SUTERSVILLE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(5882, '15084', '+40.434436', '-080.024817', 'TARENTUM', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5883, '15085', '+40.382668', '-079.594643', 'TRAFFORD', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(5884, '15086', '+40.434436', '-080.024817', 'WARRENDALE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5885, '15087', '+40.360223', '-079.439801', 'WEBSTER', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(5886, '15088', '+40.271597', '-079.896610', 'WEST ELIZABETH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'PO BOX ONLY'),
(5887, '15089', '+40.201808', '-079.727237', 'WEST NEWTON', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(5888, '15090', '+40.434436', '-080.024817', 'WEXFORD', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5889, '15091', '+40.434436', '-080.024817', 'WILDWOOD', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'PO BOX ONLY'),
(5890, '15095', '+40.434436', '-080.024817', 'WARRENDALE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5891, '15096', '+40.434436', '-080.024817', 'WARRENDALE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5892, '15101', '+40.434436', '-080.024817', 'ALLISON PARK', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5893, '15102', '+40.371471', '-080.115950', 'BETHEL PARK', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5894, '15104', '+40.366287', '-079.858359', 'BRADDOCK', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5895, '15106', '+40.449080', '-080.103165', 'CARNEGIE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5896, '15108', '+40.469268', '-080.140228', 'CORAOPOLIS', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5897, '15110', '+40.372069', '-079.853820', 'DUQUESNE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5898, '15112', '+40.434436', '-080.024817', 'EAST PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5899, '15116', '+40.357719', '-079.979974', 'GLENSHAW', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5900, '15120', '+40.392619', '-079.905171', 'HOMESTEAD', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5901, '15122', '+40.360575', '-079.908621', 'WEST MIFFLIN', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5902, '15123', '+40.434436', '-080.024817', 'WEST MIFFLIN', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5903, '15126', '+40.452644', '-080.128852', 'IMPERIAL', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5904, '15127', '+40.434436', '-080.024817', 'INGOMAR', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'PO BOX ONLY'),
(5905, '15129', '+40.303119', '-079.997567', 'SOUTH PARK', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5906, '15130', '+40.434436', '-080.024817', 'MC KEESPORT', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5907, '15131', '+40.434436', '-080.024817', 'MC KEESPORT', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5908, '15132', '+40.407269', '-080.048026', 'MC KEESPORT', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5909, '15133', '+40.323419', '-079.940172', 'MC KEESPORT', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5910, '15134', '+40.434436', '-080.024817', 'MC KEESPORT', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5911, '15135', '+40.434436', '-080.024817', 'MC KEESPORT', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5912, '15136', '+40.467006', '-080.103669', 'MC KEES ROCKS', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5913, '15137', '+40.434436', '-080.024817', 'NORTH VERSAILLES', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5914, '15139', '+40.434436', '-080.024817', 'OAKMONT', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5915, '15140', '+40.434436', '-080.024817', 'PITCAIRN', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5916, '15142', '+40.402452', '-080.166896', 'PRESTO', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5917, '15143', '+40.451367', '-080.208280', 'SEWICKLEY', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5918, '15144', '+40.434436', '-080.024817', 'SPRINGDALE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5919, '15145', '+40.434436', '-080.024817', 'TURTLE CREEK', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5920, '15146', '+40.548117', '-080.236882', 'MONROEVILLE', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5921, '15147', '+40.351469', '-080.011574', 'VERONA', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5922, '15148', '+40.434436', '-080.024817', 'WILMERDING', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5923, '15189', '+40.434436', '-080.024817', 'SEWICKLEY', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5924, '15201', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5925, '15202', '+40.328598', '-079.949182', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5926, '15203', '+40.425369', '-079.979914', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5927, '15204', '+40.455368', '-080.064416', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5928, '15205', '+40.432205', '-080.102101', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5929, '15206', '+40.416419', '-080.075427', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5930, '15207', '+40.356169', '-079.982123', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5931, '15208', '+40.519017', '-080.166080', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5932, '15209', '+40.392719', '-080.042375', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5933, '15210', '+40.419662', '-080.027243', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5934, '15211', '+40.429519', '-080.014375', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5935, '15212', '+40.428169', '-080.074977', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5936, '15213', '+40.423069', '-079.980624', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5937, '15214', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5938, '15215', '+40.377569', '-079.994074', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5939, '15216', '+40.400091', '-080.046176', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5940, '15217', '+40.385219', '-080.054876', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5941, '15218', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5942, '15219', '+40.375351', '-080.017075', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5943, '15220', '+40.418119', '-080.052576', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5944, '15221', '+40.414611', '-080.043342', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5945, '15222', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5946, '15223', '+40.457418', '-080.044926', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5947, '15224', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5948, '15225', '+40.505118', '-080.115528', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5949, '15226', '+40.400140', '-080.016074', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5950, '15227', '+40.380519', '-079.966723', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5951, '15228', '+40.369569', '-080.043925', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5952, '15229', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5953, '15230', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5954, '15231', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5955, '15232', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5956, '15233', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5957, '15234', '+40.368819', '-080.022399', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5958, '15235', '+40.398608', '-080.000854', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5959, '15236', '+40.335140', '-079.983243', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5960, '15237', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5961, '15238', '+40.380019', '-080.006474', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5962, '15239', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5963, '15240', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5964, '15241', '+40.332266', '-080.081026', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5965, '15242', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5966, '15243', '+40.384169', '-080.072876', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5967, '15244', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5968, '15250', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5969, '15251', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5970, '15252', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5971, '15253', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5972, '15254', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5973, '15255', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5974, '15257', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5975, '15258', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5976, '15259', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5977, '15260', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5978, '15261', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5979, '15262', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5980, '15263', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5981, '15264', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5982, '15265', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5983, '15266', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5984, '15267', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5985, '15268', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5986, '15270', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5987, '15272', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5988, '15274', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5989, '15275', '+40.449520', '-080.179475', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5990, '15276', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(5991, '15277', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5992, '15278', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5993, '15279', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5994, '15281', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5995, '15282', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5996, '15283', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5997, '15285', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5998, '15286', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'UNIQUE'),
(5999, '15290', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(6000, '15295', '+40.434436', '-080.024817', 'PITTSBURGH', 'PA', 'PENNSYLVANIA', 'ALLEGHENY', 'STANDARD'),
(6001, '15301', '+40.135391', '-080.146709', 'WASHINGTON', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6002, '15310', '+39.870635', '-080.211335', 'ALEPPO', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6003, '15311', '+40.049765', '-080.168133', 'AMITY', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6004, '15312', '+40.200737', '-080.267148', 'AVELLA', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6005, '15313', '+40.065496', '-080.022102', 'BEALLSVILLE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6006, '15314', '+40.153459', '-080.083967', 'BENTLEYVILLE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6007, '15315', '+39.817048', '-079.956728', 'BOBTOWN', 'PA', 'PENNSYLVANIA', 'GREENE', 'PO BOX ONLY'),
(6008, '15316', '+39.870635', '-080.211335', 'BRAVE', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6009, '15317', '+40.155704', '-080.128420', 'CANONSBURG', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6010, '15320', '+39.918913', '-079.985320', 'CARMICHAELS', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6011, '15321', '+40.159268', '-080.104193', 'CECIL', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6012, '15322', '+39.966702', '-080.045233', 'CLARKSVILLE', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6013, '15323', '+40.110160', '-080.251693', 'CLAYSVILLE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6014, '15324', '+40.050163', '-079.983240', 'COKEBURG', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6015, '15325', '+39.950170', '-079.967626', 'CRUCIBLE', 'PA', 'PENNSYLVANIA', 'GREENE', 'PO BOX ONLY'),
(6016, '15327', '+39.764089', '-079.937419', 'DILLINER', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6017, '15329', '+40.049949', '-080.281210', 'PROSPERITY', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6018, '15330', '+40.175570', '-080.099336', 'EIGHTY FOUR', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6019, '15331', '+40.106824', '-080.021614', 'ELLSWORTH', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6020, '15332', '+40.198970', '-080.059974', 'FINLEYVILLE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6021, '15333', '+40.025105', '-080.011741', 'FREDERICKTOWN', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6022, '15334', '+39.870635', '-080.211335', 'GARARDS FORT', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6023, '15336', '+40.260141', '-079.992678', 'GASTONVILLE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6024, '15337', '+39.937962', '-080.001496', 'GRAYSVILLE', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6025, '15338', '+39.820941', '-079.974551', 'GREENSBORO', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6026, '15339', '+40.301838', '-080.154310', 'HENDERSONVILLE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6027, '15340', '+40.226863', '-080.169026', 'HICKORY', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6028, '15341', '+39.870635', '-080.211335', 'HOLBROOK', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6029, '15342', '+40.133091', '-080.133451', 'HOUSTON', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6030, '15344', '+39.870635', '-080.211335', 'JEFFERSON', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6031, '15345', '+40.028432', '-080.104213', 'MARIANNA', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6032, '15346', '+39.934662', '-080.070275', 'MATHER', 'PA', 'PENNSYLVANIA', 'GREENE', 'PO BOX ONLY'),
(6033, '15347', '+40.217358', '-080.226885', 'MEADOW LANDS', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6034, '15348', '+39.987651', '-080.003686', 'MILLSBORO', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6035, '15349', '+39.774031', '-080.024576', 'MOUNT MORRIS', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6036, '15350', '+40.293731', '-080.200484', 'MUSE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6037, '15351', '+39.877901', '-079.925807', 'NEMACOLIN', 'PA', 'PENNSYLVANIA', 'GREENE', 'PO BOX ONLY'),
(6038, '15352', '+39.870635', '-080.211335', 'NEW FREEPORT', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6039, '15353', '+39.870635', '-080.211335', 'NINEVEH', 'PA', 'PENNSYLVANIA', 'GREENE', 'PO BOX ONLY'),
(6040, '15354', '+39.870635', '-080.211335', 'PINE BANK', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6041, '15357', '+39.954370', '-079.990431', 'RICES LANDING', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6042, '15358', '+40.056347', '-079.992554', 'RICHEYVILLE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6043, '15359', '+39.870635', '-080.211335', 'ROGERSVILLE', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6044, '15360', '+40.092344', '-080.099457', 'SCENERY HILL', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6045, '15361', '+40.328190', '-080.256291', 'SOUTHVIEW', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6046, '15362', '+39.744657', '-080.214471', 'SPRAGGS', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6047, '15363', '+40.250454', '-080.198354', 'STRABANE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6048, '15364', '+39.870635', '-080.211335', 'SYCAMORE', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6049, '15365', '+40.161130', '-080.378093', 'TAYLORSTOWN', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6050, '15366', '+40.110068', '-080.031787', 'VAN VOORHIS', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6051, '15367', '+40.244339', '-080.247797', 'VENETIA', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6052, '15368', '+40.023775', '-080.007731', 'VESTABURG', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6053, '15370', '+39.874770', '-080.080570', 'WAYNESBURG', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6054, '15376', '+40.128081', '-080.270231', 'WEST ALEXANDER', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6055, '15377', '+40.024677', '-080.429726', 'WEST FINLEY', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6056, '15378', '+40.277534', '-080.273130', 'WESTLAND', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6057, '15379', '+40.241731', '-080.424154', 'WEST MIDDLETOWN', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6058, '15380', '+39.909365', '-080.430040', 'WIND RIDGE', 'PA', 'PENNSYLVANIA', 'GREENE', 'STANDARD'),
(6059, '15401', '+39.944884', '-079.770063', 'UNIONTOWN', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6060, '15410', '+39.912105', '-079.896360', 'ADAH', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6061, '15411', '+39.752401', '-079.330768', 'ADDISON', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6062, '15412', '+40.095888', '-079.849887', 'ALLENPORT', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6063, '15413', '+39.986828', '-079.863732', 'ALLISON', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(6064, '15415', '+39.980787', '-079.850366', 'BRIER HILL', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6065, '15416', '+39.932084', '-079.652170', 'BROWNFIELD', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6066, '15417', '+39.921613', '-079.690472', 'BROWNSVILLE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6067, '15419', '+40.068921', '-079.873163', 'CALIFORNIA', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6068, '15420', '+39.932084', '-079.652170', 'CARDALE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6069, '15421', '+39.845088', '-079.599126', 'CHALK HILL', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6070, '15422', '+39.992254', '-079.817083', 'CHESTNUT RIDGE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6071, '15423', '+40.082192', '-079.930266', 'COAL CENTER', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6072, '15424', '+39.824325', '-079.306409', 'CONFLUENCE', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6073, '15425', '+40.007430', '-079.700949', 'CONNELLSVILLE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6074, '15427', '+40.065064', '-079.973302', 'DAISYTOWN', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'STANDARD'),
(6075, '15428', '+39.983001', '-079.725516', 'DAWSON', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6076, '15429', '+40.008082', '-079.939234', 'DENBO', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6077, '15430', '+40.041785', '-079.659978', 'DICKERSON RUN', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6078, '15431', '+39.949088', '-079.723151', 'DUNBAR', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6079, '15432', '+40.099693', '-079.859680', 'DUNLEVY', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6080, '15433', '+39.973512', '-079.704535', 'EAST MILLSBORO', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6081, '15434', '+40.080438', '-079.875826', 'ELCO', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6082, '15435', '+39.950123', '-079.858471', 'FAIRBANK', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6083, '15436', '+39.954424', '-079.808073', 'FAIRCHANCE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6084, '15437', '+39.797410', '-079.596769', 'FARMINGTON', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6085, '15438', '+40.066729', '-079.844514', 'FAYETTE CITY', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6086, '15439', '+39.771324', '-079.635842', 'GANS', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6087, '15440', '+39.757751', '-079.628365', 'GIBBON GLADE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6088, '15442', '+40.015516', '-079.843978', 'GRINDSTONE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6089, '15443', '+39.926347', '-079.901324', 'HIBBS', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6090, '15444', '+40.056560', '-079.902101', 'HILLER', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6091, '15445', '+39.876835', '-079.671812', 'HOPWOOD', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6092, '15446', '+40.037453', '-079.377806', 'INDIAN HEAD', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6093, '15447', '+39.945987', '-079.939317', 'ISABELLA', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6094, '15448', '+40.360223', '-079.439801', 'JACOBS CREEK', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6095, '15449', '+39.963622', '-079.785349', 'KEISTERVILLE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6096, '15450', '+39.998279', '-079.975391', 'LA BELLE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6097, '15451', '+39.742861', '-079.854871', 'LAKE LYNN', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6098, '15454', '+39.932084', '-079.652170', 'LECKRONE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6099, '15455', '+39.998536', '-079.643451', 'LEISENRING', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6100, '15456', '+39.877276', '-079.805549', 'LEMONT FURNACE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6101, '15458', '+39.888242', '-079.869352', 'MC CLELLANDTOWN', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6102, '15459', '+39.822431', '-079.529731', 'MARKLEYSBURG', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6103, '15460', '+39.932084', '-079.652170', 'MARTIN', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6104, '15461', '+39.945770', '-079.681838', 'MASONTOWN', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6105, '15462', '+40.059740', '-079.381435', 'MELCROFT', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6106, '15463', '+39.882521', '-079.833585', 'MERRITTSTOWN', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6107, '15464', '+39.933738', '-079.432647', 'MILL RUN', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6108, '15465', '+39.932084', '-079.652170', 'MOUNT BRADDOCK', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6109, '15466', '+40.075064', '-079.894347', 'NEWELL', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6110, '15467', '+39.932084', '-079.652170', 'NEW GENEVA', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6111, '15468', '+39.941838', '-079.841031', 'NEW SALEM', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6112, '15469', '+40.007860', '-079.438215', 'NORMALVILLE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6113, '15470', '+39.850675', '-079.523004', 'OHIOPYLE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6114, '15472', '+39.918319', '-079.715837', 'OLIVER', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6115, '15473', '+40.064564', '-079.775594', 'PERRYOPOLIS', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6116, '15474', '+39.911834', '-079.711740', 'POINT MARION', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6117, '15475', '+39.984667', '-079.881421', 'REPUBLIC', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6118, '15476', '+39.879384', '-079.916806', 'RONCO', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6119, '15477', '+40.080713', '-079.862734', 'ROSCOE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6120, '15478', '+39.929590', '-079.698875', 'SMITHFIELD', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6121, '15479', '+40.155299', '-079.738092', 'SMITHTON', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6122, '15480', '+39.988339', '-079.771265', 'SMOCK', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6123, '15482', '+40.065106', '-079.769027', 'STAR JUNCTION', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6124, '15483', '+40.038498', '-079.920937', 'STOCKDALE', 'PA', 'PENNSYLVANIA', 'WASHINGTON', 'PO BOX ONLY'),
(6125, '15484', '+39.893625', '-079.785642', 'ULEDI', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6126, '15485', '+39.817346', '-079.330642', 'URSINA', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6127, '15486', '+40.010683', '-079.750787', 'VANDERBILT', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6128, '15488', '+39.976316', '-079.768901', 'WALTERSBURG', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6129, '15489', '+39.956056', '-079.700745', 'WEST LEISENRING', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6130, '15490', '+40.075857', '-079.452796', 'WHITE', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'STANDARD'),
(6131, '15492', '+40.117828', '-079.771797', 'WICKHAVEN', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6132, '15501', '+39.990045', '-079.087450', 'SOMERSET', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6133, '15502', '+40.046023', '-079.258458', 'HIDDEN VALLEY', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6134, '15510', '+39.963306', '-079.040890', 'SOMERSET', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'UNIQUE'),
(6135, '15520', '+40.113021', '-079.070218', 'ACOSTA', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6136, '15521', '+40.198627', '-078.622801', 'ALUM BANK', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6137, '15522', '+39.954640', '-078.574759', 'BEDFORD', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6138, '15530', '+39.942768', '-078.981234', 'BERLIN', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6139, '15531', '+40.006392', '-078.989292', 'BOSWELL', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6140, '15532', '+39.767296', '-079.062012', 'BOYNTON', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6141, '15533', '+39.983440', '-078.251177', 'BREEZEWOOD', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6142, '15534', '+39.864251', '-078.674197', 'BUFFALO MILLS', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6143, '15535', '+39.839294', '-078.469881', 'CLEARVILLE', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6144, '15536', '+39.943762', '-078.122265', 'CRYSTAL SPRING', 'PA', 'PENNSYLVANIA', 'FULTON', 'STANDARD'),
(6145, '15537', '+39.966962', '-078.458753', 'EVERETT', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6146, '15538', '+39.945164', '-078.954581', 'FAIRHOPE', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6147, '15539', '+40.130173', '-078.591457', 'FISHERTOWN', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6148, '15540', '+39.796137', '-079.247161', 'FORT HILL', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6149, '15541', '+40.085382', '-078.963508', 'FRIEDENS', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6150, '15542', '+39.865900', '-079.074705', 'GARRETT', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6151, '15544', '+40.137749', '-079.092551', 'GRAY', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6152, '15545', '+39.886506', '-078.712775', 'HYNDMAN', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6153, '15546', '+40.145938', '-079.067583', 'JENNERS', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6154, '15547', '+40.159500', '-079.061629', 'JENNERSTOWN', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6155, '15548', '+40.101106', '-078.938653', 'KANTNER', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6156, '15549', '+40.020764', '-079.012306', 'LISTIE', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6157, '15550', '+39.902488', '-078.658195', 'MANNS CHOICE', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6158, '15551', '+39.887287', '-079.254694', 'MARKLETON', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6159, '15552', '+39.875014', '-079.038599', 'MEYERSDALE', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6160, '15553', '+39.982795', '-078.771929', 'NEW BALTIMORE', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6161, '15554', '+39.981413', '-078.611595', 'NEW PARIS', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6162, '15555', '+40.091429', '-079.087198', 'QUECREEK', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6163, '15557', '+39.955145', '-079.141476', 'ROCKWOOD', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6164, '15558', '+39.941261', '-079.083318', 'SALISBURY', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6165, '15559', '+40.057047', '-078.642513', 'SCHELLSBURG', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6166, '15560', '+40.017059', '-078.907682', 'SHANKSVILLE', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6167, '15561', '+40.096406', '-079.090158', 'SIPESVILLE', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6168, '15562', '+39.748020', '-079.123732', 'SPRINGS', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6169, '15563', '+40.094802', '-078.965817', 'STOYSTOWN', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6170, '15564', '+39.729896', '-078.844105', 'WELLERSBURG', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6171, '15565', '+40.003476', '-079.037983', 'WEST SALISBURY', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6172, '15601', '+40.347017', '-079.500729', 'GREENSBURG', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6173, '15605', '+40.360223', '-079.439801', 'GREENSBURG', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'UNIQUE'),
(6174, '15606', '+40.360223', '-079.439801', 'GREENSBURG', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'UNIQUE'),
(6175, '15610', '+40.120149', '-079.405069', 'ACME', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6176, '15611', '+40.303771', '-079.653058', 'ADAMSBURG', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6177, '15612', '+40.360223', '-079.439801', 'ALVERTON', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6178, '15613', '+40.436827', '-079.617178', 'APOLLO', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6179, '15615', '+40.360619', '-079.743317', 'ARDARA', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6180, '15616', '+40.360223', '-079.439801', 'ARMBRUST', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6181, '15617', '+40.360223', '-079.439801', 'ARONA', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6182, '15618', '+40.497049', '-079.489055', 'AVONMORE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6183, '15619', '+40.360223', '-079.439801', 'BOVARD', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6184, '15620', '+40.323845', '-079.343421', 'BRADENVILLE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6185, '15621', '+40.360223', '-079.439801', 'CALUMET', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6186, '15622', '+40.190193', '-079.301960', 'CHAMPION', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6187, '15623', '+40.369210', '-079.619012', 'CLARIDGE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6188, '15624', '+40.357753', '-079.484028', 'CRABTREE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6189, '15625', '+40.360223', '-079.439801', 'DARRAGH', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6190, '15626', '+40.361310', '-079.571423', 'DELMONT', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6191, '15627', '+40.350227', '-079.402056', 'DERRY', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6192, '15628', '+40.102807', '-079.377008', 'DONEGAL', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6193, '15629', '+40.598047', '-079.562383', 'EAST VANDERGRIFT', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6194, '15630', '+40.847829', '-079.451575', 'EDMON', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6195, '15631', '+40.084517', '-079.590529', 'EVERSON', 'PA', 'PENNSYLVANIA', 'FAYETTE', 'PO BOX ONLY'),
(6196, '15632', '+40.429723', '-079.634789', 'EXPORT', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6197, '15633', '+40.357548', '-079.522546', 'FORBES ROAD', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6198, '15634', '+40.308892', '-079.665420', 'GRAPEVILLE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6199, '15635', '+40.352037', '-079.497890', 'HANNASTOWN', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6200, '15636', '+40.366020', '-079.656525', 'HARRISON CITY', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6201, '15637', '+40.266168', '-079.567790', 'HERMINIE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6202, '15638', '+40.261060', '-079.143130', 'HOSTETTER', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6203, '15639', '+40.328617', '-079.624473', 'HUNKER', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6204, '15640', '+40.225086', '-079.732805', 'HUTCHINSON', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6205, '15641', '+40.628165', '-079.595648', 'HYDE PARK', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6206, '15642', '+40.365020', '-079.584060', 'IRWIN', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6207, '15644', '+40.374572', '-079.407913', 'JEANNETTE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6208, '15646', '+40.360223', '-079.439801', 'JONES MILLS', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6209, '15647', '+40.341519', '-079.727216', 'LARIMER', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6210, '15650', '+40.355770', '-079.421969', 'LATROBE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6211, '15655', '+40.231409', '-079.171459', 'LAUGHLINTOWN', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6212, '15656', '+40.638960', '-079.610962', 'LEECHBURG', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6213, '15658', '+40.271322', '-079.251145', 'LIGONIER', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6214, '15660', '+40.248798', '-079.764638', 'LOWBER', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6215, '15661', '+40.286515', '-079.513433', 'LOYALHANNA', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6216, '15662', '+40.360223', '-079.439801', 'LUXOR', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6217, '15663', '+40.243970', '-079.676516', 'MADISON', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6218, '15664', '+40.310772', '-079.617187', 'MAMMOTH', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6219, '15665', '+40.292194', '-079.664868', 'MANOR', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6220, '15666', '+40.202211', '-079.609982', 'MOUNT PLEASANT', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6221, '15668', '+40.423293', '-079.663288', 'MURRYSVILLE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6222, '15670', '+40.396655', '-079.444008', 'NEW ALEXANDRIA', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6223, '15671', '+40.349446', '-079.322549', 'NEW DERRY', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6224, '15672', '+40.243750', '-079.658436', 'NEW STANTON', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6225, '15673', '+40.593035', '-079.558098', 'NORTH APOLLO', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6226, '15674', '+40.216006', '-079.487239', 'NORVELT', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6227, '15675', '+40.314908', '-079.681435', 'PENN', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6228, '15676', '+40.242429', '-079.454212', 'PLEASANT UNITY', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6229, '15677', '+40.360223', '-079.439801', 'RECTOR', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6230, '15678', '+40.282843', '-079.723278', 'RILLTON', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6231, '15679', '+40.226934', '-079.673364', 'RUFFS DALE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6232, '15680', '+40.518905', '-079.495871', 'SALINA', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6233, '15681', '+40.542875', '-079.397809', 'SALTSBURG', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6234, '15682', '+40.847829', '-079.451575', 'SCHENLEY', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6235, '15683', '+40.355350', '-079.520544', 'SCOTTDALE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6236, '15684', '+40.460370', '-079.515628', 'SLICKVILLE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6237, '15685', '+40.360223', '-079.439801', 'SOUTHWEST', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6238, '15686', '+40.616816', '-079.479833', 'SPRING CHURCH', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6239, '15687', '+40.360223', '-079.439801', 'STAHLSTOWN', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6240, '15688', '+40.360223', '-079.439801', 'TARRS', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6241, '15689', '+40.360223', '-079.439801', 'UNITED', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6242, '15690', '+40.400412', '-079.546855', 'VANDERGRIFT', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6243, '15691', '+40.294021', '-079.686626', 'WENDEL', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6244, '15692', '+40.329386', '-079.680567', 'WESTMORELAND CITY', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6245, '15693', '+40.248274', '-079.408579', 'WHITNEY', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6246, '15695', '+40.196199', '-079.694244', 'WYANO', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6247, '15696', '+40.279337', '-079.366066', 'YOUNGSTOWN', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6248, '15697', '+40.240536', '-079.505889', 'YOUNGWOOD', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6249, '15698', '+40.222685', '-079.691067', 'YUKON', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6250, '15701', '+40.621272', '-079.080422', 'INDIANA', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6251, '15705', '+40.640031', '-079.129445', 'INDIANA', 'PA', 'PENNSYLVANIA', 'INDIANA', 'UNIQUE'),
(6252, '15710', '+40.633313', '-078.872314', 'ALVERDA', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6253, '15711', '+41.171119', '-078.913113', 'ANITA', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6254, '15712', '+40.781719', '-078.853612', 'ARCADIA', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6255, '15713', '+40.619270', '-079.083982', 'AULTMAN', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6256, '15714', '+40.658721', '-078.794582', 'NORTHERN CAMBRIA', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6257, '15715', '+40.970448', '-078.875799', 'BIG RUN', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'PO BOX ONLY'),
(6258, '15716', '+40.483646', '-079.206322', 'BLACK LICK', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6259, '15717', '+40.486445', '-079.195766', 'BLAIRSVILLE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6260, '15720', '+40.529238', '-079.084600', 'BRUSH VALLEY', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6261, '15721', '+41.054375', '-078.410950', 'BURNSIDE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6262, '15722', '+40.583025', '-078.728455', 'CARROLLTOWN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6263, '15723', '+40.705639', '-079.161510', 'CHAMBERSVILLE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6264, '15724', '+40.724976', '-078.860324', 'CHERRY TREE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6265, '15725', '+40.632813', '-079.132551', 'CLARKSBURG', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6266, '15727', '+40.550270', '-079.323745', 'CLUNE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6267, '15728', '+40.748901', '-078.997726', 'CLYMER', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6268, '15729', '+40.706462', '-078.924401', 'COMMODORE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6269, '15730', '+40.967066', '-078.925563', 'COOLSPRING', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6270, '15731', '+40.498602', '-079.173892', 'CORAL', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6271, '15732', '+40.661336', '-079.217127', 'CREEKSIDE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6272, '15733', '+41.141079', '-078.962877', 'DE LANCEY', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'PO BOX ONLY'),
(6273, '15734', '+40.718817', '-078.979489', 'DIXONVILLE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6274, '15736', '+40.692153', '-079.342180', 'ELDERTON', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6275, '15737', '+40.607635', '-078.752415', 'ELMORA', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6276, '15738', '+40.693633', '-078.775076', 'EMEIGH', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6277, '15739', '+40.677971', '-079.165708', 'ERNEST', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6278, '15740', '+41.141079', '-078.962877', 'FROSTBURG', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6279, '15741', '+40.796017', '-078.858614', 'GIPSY', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6280, '15742', '+40.804413', '-078.889036', 'GLEN CAMPBELL', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6281, '15744', '+41.141079', '-078.962877', 'HAMILTON', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6282, '15745', '+40.620736', '-078.918561', 'HEILWOOD', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6283, '15746', '+40.767854', '-078.877331', 'HILLSDALE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6284, '15747', '+40.701519', '-079.182743', 'HOME', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6285, '15748', '+40.627752', '-079.089616', 'HOMER CITY', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6286, '15750', '+40.482783', '-079.185048', 'JOSEPHINE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6287, '15751', '+40.640031', '-079.129445', 'JUNEAU', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6288, '15752', '+40.541200', '-079.282047', 'KENT', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6289, '15753', '+40.989115', '-078.422403', 'LA JOSE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6290, '15754', '+40.500198', '-079.176571', 'LUCERNEMINES', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6291, '15756', '+40.568381', '-079.299931', 'MC INTYRE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6292, '15757', '+40.989115', '-078.422403', 'MAHAFFEY', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6293, '15758', '+40.640031', '-079.129445', 'MARCHAND', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6294, '15759', '+40.685945', '-079.051607', 'MARION CENTER', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6295, '15760', '+40.652187', '-078.805420', 'MARSTELLER', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6296, '15761', '+40.620066', '-078.887009', 'MENTCLE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6297, '15762', '+40.600962', '-078.822090', 'NICKTOWN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6298, '15763', '+40.640031', '-079.129445', 'NORTHPOINT', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6299, '15764', '+41.141079', '-078.962877', 'OLIVEBURG', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6300, '15765', '+40.621281', '-078.994310', 'PENN RUN', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6301, '15767', '+40.944538', '-078.979845', 'PUNXSUTAWNEY', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6302, '15770', '+41.141079', '-078.962877', 'RINGGOLD', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6303, '15771', '+40.721930', '-079.006162', 'ROCHESTER MILLS', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6304, '15772', '+40.869654', '-078.900483', 'ROSSITER', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6305, '15773', '+40.629818', '-078.732947', 'SAINT BENEDICT', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6306, '15774', '+40.847829', '-079.451575', 'SHELOCTA', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6307, '15775', '+40.635130', '-078.769185', 'SPANGLER', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6308, '15776', '+41.141079', '-078.962877', 'SPRANKLE MILLS', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6309, '15777', '+40.702673', '-078.958847', 'STARFORD', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6310, '15778', '+40.967353', '-079.199017', 'TIMBLIN', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6311, '15779', '+40.360223', '-079.439801', 'TORRANCE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'PO BOX ONLY'),
(6312, '15780', '+41.141079', '-078.962877', 'VALIER', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6313, '15781', '+41.141079', '-078.962877', 'WALSTON', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'PO BOX ONLY'),
(6314, '15783', '+40.583778', '-079.342331', 'WEST LEBANON', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6315, '15784', '+41.141079', '-078.962877', 'WORTHVILLE', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6316, '15801', '+41.118045', '-078.720302', 'DU BOIS', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6317, '15821', '+41.415878', '-078.665057', 'BENEZETT', 'PA', 'PENNSYLVANIA', 'ELK', 'STANDARD'),
(6318, '15822', '+41.415878', '-078.665057', 'BRANDY CAMP', 'PA', 'PENNSYLVANIA', 'ELK', 'PO BOX ONLY'),
(6319, '15823', '+41.253932', '-078.699711', 'BROCKPORT', 'PA', 'PENNSYLVANIA', 'ELK', 'STANDARD'),
(6320, '15824', '+41.247202', '-078.798900', 'BROCKWAY', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6321, '15825', '+41.162735', '-079.081609', 'BROOKVILLE', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6322, '15827', '+41.291008', '-078.504350', 'BYRNEDALE', 'PA', 'PENNSYLVANIA', 'ELK', 'STANDARD'),
(6323, '15828', '+41.475887', '-079.239101', 'CLARINGTON', 'PA', 'PENNSYLVANIA', 'FOREST', 'STANDARD'),
(6324, '15829', '+41.141079', '-078.962877', 'CORSICA', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6325, '15831', '+41.304782', '-078.621286', 'DAGUS MINES', 'PA', 'PENNSYLVANIA', 'ELK', 'PO BOX ONLY'),
(6326, '15832', '+41.417566', '-078.204927', 'DRIFTWOOD', 'PA', 'PENNSYLVANIA', 'CAMERON', 'STANDARD'),
(6327, '15834', '+41.510310', '-078.231570', 'EMPORIUM', 'PA', 'PENNSYLVANIA', 'CAMERON', 'STANDARD'),
(6328, '15840', '+41.149752', '-078.820695', 'FALLS CREEK', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6329, '15841', '+41.283709', '-078.551668', 'FORCE', 'PA', 'PENNSYLVANIA', 'ELK', 'PO BOX ONLY'),
(6330, '15845', '+41.504669', '-078.687183', 'JOHNSONBURG', 'PA', 'PENNSYLVANIA', 'ELK', 'STANDARD'),
(6331, '15846', '+41.336887', '-078.605537', 'KERSEY', 'PA', 'PENNSYLVANIA', 'ELK', 'STANDARD'),
(6332, '15847', '+41.141079', '-078.962877', 'KNOX DALE', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'PO BOX ONLY'),
(6333, '15848', '+40.989115', '-078.422403', 'LUTHERSBURG', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6334, '15849', '+41.201560', '-078.583502', 'PENFIELD', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6335, '15851', '+41.095556', '-078.886154', 'REYNOLDSVILLE', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6336, '15853', '+41.362112', '-078.726238', 'RIDGWAY', 'PA', 'PENNSYLVANIA', 'ELK', 'STANDARD'),
(6337, '15856', '+40.989115', '-078.422403', 'ROCKTON', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6338, '15857', '+41.452935', '-078.529829', 'SAINT MARYS', 'PA', 'PENNSYLVANIA', 'ELK', 'STANDARD'),
(6339, '15860', '+41.141079', '-078.962877', 'SIGEL', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6340, '15861', '+41.417566', '-078.204927', 'SINNAMAHONING', 'PA', 'PENNSYLVANIA', 'CAMERON', 'STANDARD'),
(6341, '15863', '+41.141079', '-078.962877', 'STUMP CREEK', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'PO BOX ONLY'),
(6342, '15864', '+41.141079', '-078.962877', 'SUMMERVILLE', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6343, '15865', '+41.047897', '-078.819682', 'SYKESVILLE', 'PA', 'PENNSYLVANIA', 'JEFFERSON', 'STANDARD'),
(6344, '15866', '+41.011686', '-078.785731', 'TROUTVILLE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6345, '15868', '+41.279081', '-078.527949', 'WEEDVILLE', 'PA', 'PENNSYLVANIA', 'ELK', 'STANDARD'),
(6346, '15870', '+41.572956', '-078.665262', 'WILCOX', 'PA', 'PENNSYLVANIA', 'ELK', 'STANDARD'),
(6347, '15901', '+40.412707', '-078.854245', 'JOHNSTOWN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6348, '15902', '+40.417111', '-078.805990', 'JOHNSTOWN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6349, '15904', '+40.319279', '-078.828084', 'JOHNSTOWN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6350, '15905', '+40.314074', '-078.870894', 'JOHNSTOWN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6351, '15906', '+40.494132', '-078.838673', 'JOHNSTOWN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6352, '15907', '+40.325374', '-078.915147', 'JOHNSTOWN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6353, '15909', '+40.440314', '-078.855910', 'JOHNSTOWN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6354, '15915', '+40.484487', '-078.702224', 'JOHNSTOWN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6355, '15920', '+40.460262', '-079.009721', 'ARMAGH', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6356, '15921', '+40.319561', '-078.694043', 'BEAVERDALE', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6357, '15922', '+40.484487', '-078.702224', 'BELSANO', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6358, '15923', '+40.348279', '-079.153210', 'BOLIVAR', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6359, '15924', '+40.114920', '-078.785100', 'CAIRNBROOK', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6360, '15925', '+40.412800', '-078.633698', 'CASSANDRA', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6361, '15926', '+40.074818', '-078.838170', 'CENTRAL CITY', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6362, '15927', '+40.538311', '-078.786549', 'COLVER', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6363, '15928', '+40.235230', '-078.919007', 'DAVIDSVILLE', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6364, '15929', '+40.462521', '-079.012834', 'DILLTOWN', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6365, '15930', '+40.293935', '-078.719217', 'DUNLO', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6366, '15931', '+40.459581', '-078.771875', 'EBENSBURG', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6367, '15934', '+40.279925', '-078.803247', 'ELTON', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6368, '15935', '+40.201370', '-078.958371', 'HOLLSOPPLE', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6369, '15936', '+40.155129', '-078.916785', 'HOOVERSVILLE', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6370, '15937', '+40.208435', '-078.987265', 'JEROME', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6371, '15938', '+40.427588', '-078.639257', 'LILLY', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6372, '15940', '+40.517191', '-078.614870', 'LORETTO', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6373, '15942', '+40.419784', '-078.823794', 'MINERAL POINT', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6374, '15943', '+40.392443', '-078.848566', 'NANTY GLO', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6375, '15944', '+40.326182', '-079.101925', 'NEW FLORENCE', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6376, '15945', '+40.356723', '-078.873296', 'PARKHILL', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6377, '15946', '+40.369239', '-078.752509', 'PORTAGE', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6378, '15948', '+40.464069', '-078.685365', 'REVLOC', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6379, '15949', '+40.403698', '-079.122040', 'ROBINSON', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6380, '15951', '+40.338615', '-078.776137', 'SAINT MICHAEL', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6381, '15952', '+40.298574', '-078.781592', 'SALIX', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6382, '15953', '+40.206435', '-078.900533', 'SEANOR', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6383, '15954', '+40.401071', '-079.029098', 'SEWARD', 'PA', 'PENNSYLVANIA', 'WESTMORELAND', 'STANDARD'),
(6384, '15955', '+40.334129', '-078.715511', 'SIDMAN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6385, '15956', '+40.411640', '-078.778413', 'SOUTH FORK', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6386, '15957', '+40.572746', '-078.900034', 'STRONGSTOWN', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6387, '15958', '+40.391140', '-078.735229', 'SUMMERHILL', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6388, '15959', '+40.267975', '-078.915567', 'TIRE HILL', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'PO BOX ONLY'),
(6389, '15960', '+40.499630', '-078.861308', 'TWIN ROCKS', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6390, '15961', '+40.437721', '-078.924998', 'VINTONDALE', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6391, '15962', '+40.380188', '-078.719019', 'WILMORE', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6392, '15963', '+40.180418', '-078.829021', 'WINDBER', 'PA', 'PENNSYLVANIA', 'SOMERSET', 'STANDARD'),
(6393, '16001', '+40.885861', '-079.934048', 'BUTLER', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6394, '16002', '+40.840900', '-079.859175', 'BUTLER', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6395, '16003', '+40.921145', '-079.927580', 'BUTLER', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6396, '16016', '+40.921145', '-079.927580', 'BOYERS', 'PA', 'PENNSYLVANIA', 'BUTLER', 'UNIQUE'),
(6397, '16017', '+40.921145', '-079.927580', 'BOYERS', 'PA', 'PENNSYLVANIA', 'BUTLER', 'UNIQUE'),
(6398, '16018', '+40.921145', '-079.927580', 'BOYERS', 'PA', 'PENNSYLVANIA', 'BUTLER', 'UNIQUE'),
(6399, '16020', '+41.106846', '-079.900626', 'BOYERS', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6400, '16021', '+40.921145', '-079.927580', 'BRANCHTON', 'PA', 'PENNSYLVANIA', 'BUTLER', 'PO BOX ONLY'),
(6401, '16022', '+41.055515', '-079.731308', 'BRUIN', 'PA', 'PENNSYLVANIA', 'BUTLER', 'PO BOX ONLY'),
(6402, '16023', '+40.792353', '-079.760048', 'CABOT', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6403, '16024', '+40.921867', '-079.994747', 'CALLERY', 'PA', 'PENNSYLVANIA', 'BUTLER', 'PO BOX ONLY'),
(6404, '16025', '+40.940484', '-079.777107', 'CHICORA', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6405, '16027', '+40.826436', '-080.013785', 'CONNOQUENESSING', 'PA', 'PENNSYLVANIA', 'BUTLER', 'PO BOX ONLY'),
(6406, '16028', '+40.983990', '-079.615234', 'EAST BRADY', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6407, '16029', '+40.780174', '-079.780792', 'EAST BUTLER', 'PA', 'PENNSYLVANIA', 'BUTLER', 'PO BOX ONLY'),
(6408, '16030', '+41.136538', '-079.802384', 'EAU CLAIRE', 'PA', 'PENNSYLVANIA', 'BUTLER', 'PO BOX ONLY'),
(6409, '16033', '+40.904798', '-079.936488', 'EVANS CITY', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6410, '16034', '+40.864921', '-079.735066', 'FENELTON', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6411, '16035', '+41.106756', '-080.007017', 'FORESTVILLE', 'PA', 'PENNSYLVANIA', 'BUTLER', 'PO BOX ONLY'),
(6412, '16036', '+41.202325', '-079.453751', 'FOXBURG', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6413, '16037', '+40.828200', '-080.098250', 'HARMONY', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6414, '16038', '+40.935262', '-080.008650', 'HARRISVILLE', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6415, '16039', '+40.921145', '-079.927580', 'HERMAN', 'PA', 'PENNSYLVANIA', 'BUTLER', 'PO BOX ONLY'),
(6416, '16040', '+41.091444', '-079.835723', 'HILLIARDS', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6417, '16041', '+41.005368', '-079.766612', 'KARNS CITY', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6418, '16045', '+40.801238', '-079.963774', 'LYNDORA', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6419, '16046', '+40.866316', '-079.936986', 'MARS', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6420, '16048', '+41.047190', '-079.808899', 'NORTH WASHINGTON', 'PA', 'PENNSYLVANIA', 'BUTLER', 'PO BOX ONLY'),
(6421, '16049', '+41.093079', '-079.682532', 'PARKER', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6422, '16050', '+41.041059', '-079.762814', 'PETROLIA', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6423, '16051', '+41.017820', '-080.072356', 'PORTERSVILLE', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6424, '16052', '+40.956173', '-079.933127', 'PROSPECT', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6425, '16053', '+40.803054', '-079.990821', 'RENFREW', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6426, '16054', '+41.202325', '-079.453751', 'SAINT PETERSBURG', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6427, '16055', '+40.720919', '-079.762620', 'SARVER', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6428, '16056', '+40.861995', '-079.864282', 'SAXONBURG', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6429, '16057', '+41.052427', '-080.043821', 'SLIPPERY ROCK', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6430, '16058', '+41.202325', '-079.453751', 'TURKEY CITY', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6431, '16059', '+40.710689', '-079.937074', 'VALENCIA', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6432, '16061', '+41.021754', '-079.884312', 'WEST SUNBURY', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6433, '16063', '+40.760900', '-080.109390', 'ZELIENOPLE', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6434, '16066', '+40.709713', '-080.104597', 'CRANBERRY TWP', 'PA', 'PENNSYLVANIA', 'BUTLER', 'STANDARD'),
(6435, '16101', '+40.964516', '-080.300736', 'NEW CASTLE', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6436, '16102', '+40.961300', '-080.408502', 'NEW CASTLE', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6437, '16103', '+40.989662', '-080.308376', 'NEW CASTLE', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6438, '16105', '+41.024051', '-080.345444', 'NEW CASTLE', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6439, '16107', '+40.989662', '-080.308376', 'NEW CASTLE', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6440, '16108', '+40.989662', '-080.308376', 'NEW CASTLE', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6441, '16110', '+41.629436', '-080.214024', 'ADAMSVILLE', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6442, '16111', '+41.524812', '-080.320560', 'ATLANTIC', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6443, '16112', '+40.956210', '-080.486131', 'BESSEMER', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6444, '16113', '+41.286567', '-080.423727', 'CLARK', 'PA', 'PENNSYLVANIA', 'MERCER', 'PO BOX ONLY'),
(6445, '16114', '+41.405788', '-080.184099', 'CLARKS MILLS', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6446, '16115', '+40.786244', '-080.391487', 'DARLINGTON', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(6447, '16116', '+41.031749', '-080.457328', 'EDINBURG', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6448, '16117', '+40.917478', '-080.363481', 'ELLWOOD CITY', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6449, '16120', '+40.905222', '-080.468225', 'ENON VALLEY', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6450, '16121', '+41.210606', '-080.487821', 'FARRELL', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6451, '16123', '+40.813208', '-080.199126', 'FOMBELL', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(6452, '16124', '+41.334133', '-080.262473', 'FREDONIA', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6453, '16125', '+41.326606', '-080.288302', 'GREENVILLE', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6454, '16127', '+41.170823', '-080.089581', 'GROVE CITY', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6455, '16130', '+41.328210', '-080.292168', 'HADLEY', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6456, '16131', '+41.534292', '-080.417374', 'HARTSTOWN', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6457, '16132', '+41.011263', '-080.497546', 'HILLSVILLE', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'PO BOX ONLY'),
(6458, '16133', '+41.278208', '-080.113231', 'JACKSON CENTER', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6459, '16134', '+41.456649', '-080.449185', 'JAMESTOWN', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6460, '16136', '+40.834767', '-080.328009', 'KOPPEL', 'PA', 'PENNSYLVANIA', 'BEAVER', 'PO BOX ONLY'),
(6461, '16137', '+41.222885', '-080.250704', 'MERCER', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6462, '16140', '+40.989662', '-080.308376', 'NEW BEDFORD', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'PO BOX ONLY'),
(6463, '16141', '+40.833615', '-080.384434', 'NEW GALILEE', 'PA', 'PENNSYLVANIA', 'BEAVER', 'STANDARD'),
(6464, '16142', '+41.104460', '-080.352749', 'NEW WILMINGTON', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6465, '16143', '+41.087533', '-080.472593', 'PULASKI', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6466, '16145', '+41.380743', '-080.217270', 'SANDY LAKE', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6467, '16146', '+41.234505', '-080.447930', 'SHARON', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6468, '16148', '+41.221984', '-080.438887', 'HERMITAGE', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6469, '16150', '+41.283776', '-080.400053', 'SHARPSVILLE', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6470, '16151', '+41.443460', '-080.205513', 'SHEAKLEYVILLE', 'PA', 'PENNSYLVANIA', 'MERCER', 'PO BOX ONLY'),
(6471, '16153', '+41.335562', '-080.103610', 'STONEBORO', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6472, '16154', '+41.368354', '-080.360703', 'TRANSFER', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6473, '16155', '+40.989662', '-080.308376', 'VILLA MARIA', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'PO BOX ONLY'),
(6474, '16156', '+41.089458', '-080.193460', 'VOLANT', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6475, '16157', '+40.893341', '-080.337740', 'WAMPUM', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'STANDARD'),
(6476, '16159', '+41.238352', '-080.300747', 'WEST MIDDLESEX', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6477, '16160', '+40.930132', '-080.361099', 'WEST PITTSBURG', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'PO BOX ONLY'),
(6478, '16161', '+41.200256', '-080.502702', 'WHEATLAND', 'PA', 'PENNSYLVANIA', 'MERCER', 'PO BOX ONLY'),
(6479, '16172', '+41.119992', '-080.333192', 'NEW WILMINGTON', 'PA', 'PENNSYLVANIA', 'LAWRENCE', 'UNIQUE'),
(6480, '16201', '+40.817197', '-079.419457', 'KITTANNING', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6481, '16210', '+40.855727', '-079.545145', 'ADRIAN', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6482, '16211', '+40.640031', '-079.129445', 'BEYER', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6483, '16212', '+40.754086', '-079.580912', 'CADOGAN', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6484, '16213', '+41.123556', '-079.568457', 'CALLENSBURG', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6485, '16214', '+41.143274', '-079.452051', 'CLARION', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6486, '16215', '+40.847829', '-079.451575', 'KITTANNING', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'UNIQUE'),
(6487, '16216', '+40.847829', '-079.451575', 'CLIMAX', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6488, '16217', '+41.475887', '-079.239101', 'COOKSBURG', 'PA', 'PENNSYLVANIA', 'FOREST', 'STANDARD'),
(6489, '16218', '+40.847829', '-079.451575', 'COWANSVILLE', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6490, '16220', '+41.202325', '-079.453751', 'CROWN', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6491, '16221', '+41.202325', '-079.453751', 'CURLLSVILLE', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6492, '16222', '+40.881227', '-079.240054', 'DAYTON', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6493, '16223', '+40.847829', '-079.451575', 'DISTANT', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6494, '16224', '+41.202325', '-079.453751', 'FAIRMOUNT CITY', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6495, '16225', '+41.202325', '-079.453751', 'FISHER', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6496, '16226', '+40.799650', '-079.420198', 'FORD CITY', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6497, '16228', '+40.756829', '-079.522225', 'FORD CLIFF', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6498, '16229', '+40.743732', '-079.461140', 'FREEPORT', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6499, '16230', '+41.017753', '-079.279932', 'HAWTHORN', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6500, '16232', '+41.190299', '-079.592521', 'KNOX', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6501, '16233', '+41.388826', '-079.273662', 'LEEPER', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6502, '16234', '+41.202325', '-079.453751', 'LIMESTONE', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6503, '16235', '+41.300236', '-079.357790', 'LUCINDA', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6504, '16236', '+40.781788', '-079.521842', 'MC GRANN', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6505, '16238', '+40.787688', '-079.521034', 'MANORVILLE', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6506, '16239', '+41.469973', '-079.125004', 'MARIENVILLE', 'PA', 'PENNSYLVANIA', 'FOREST', 'STANDARD'),
(6507, '16240', '+41.202325', '-079.453751', 'MAYPORT', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6508, '16242', '+41.126980', '-079.407910', 'NEW BETHLEHEM', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6509, '16244', '+40.847829', '-079.451575', 'NU MINE', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6510, '16245', '+40.847829', '-079.451575', 'OAK RIDGE', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6511, '16246', '+40.640031', '-079.129445', 'PLUMVILLE', 'PA', 'PENNSYLVANIA', 'INDIANA', 'PO BOX ONLY'),
(6512, '16248', '+41.041098', '-079.501668', 'RIMERSBURG', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6513, '16249', '+40.746619', '-079.496645', 'RURAL VALLEY', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6514, '16250', '+40.777387', '-079.233585', 'SAGAMORE', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6515, '16253', '+40.847829', '-079.451575', 'SEMINOLE', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6516, '16254', '+41.263674', '-079.434105', 'SHIPPENVILLE', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6517, '16255', '+41.105702', '-079.489973', 'SLIGO', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6518, '16256', '+40.867654', '-079.141344', 'SMICKSBURG', 'PA', 'PENNSYLVANIA', 'INDIANA', 'STANDARD'),
(6519, '16257', '+41.202325', '-079.453751', 'SNYDERSBURG', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6520, '16258', '+41.235244', '-079.281881', 'STRATTANVILLE', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6521, '16259', '+40.915899', '-079.461201', 'TEMPLETON', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6522, '16260', '+41.202325', '-079.453751', 'VOWINCKEL', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6523, '16261', '+40.847829', '-079.451575', 'WIDNOON', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6524, '16262', '+40.837764', '-079.629766', 'WORTHINGTON', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'STANDARD'),
(6525, '16263', '+40.847829', '-079.451575', 'YATESBORO', 'PA', 'PENNSYLVANIA', 'ARMSTRONG', 'PO BOX ONLY'),
(6526, '16301', '+41.330725', '-079.775153', 'OIL CITY', 'PA', 'PENNSYLVANIA', 'VENANGO', 'STANDARD'),
(6527, '16311', '+41.456666', '-080.043012', 'CARLTON', 'PA', 'PENNSYLVANIA', 'MERCER', 'STANDARD'),
(6528, '16312', '+41.935848', '-079.309668', 'CHANDLERS VALLEY', 'PA', 'PENNSYLVANIA', 'WARREN', 'PO BOX ONLY'),
(6529, '16313', '+41.798453', '-079.193751', 'CLARENDON', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6530, '16314', '+41.518380', '-080.047368', 'COCHRANTON', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6531, '16316', '+41.616247', '-080.306783', 'CONNEAUT LAKE', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6532, '16317', '+41.496472', '-079.887384', 'COOPERSTOWN', 'PA', 'PENNSYLVANIA', 'VENANGO', 'STANDARD'),
(6533, '16319', '+41.398105', '-079.738809', 'CRANBERRY', 'PA', 'PENNSYLVANIA', 'VENANGO', 'STANDARD'),
(6534, '16321', '+41.475887', '-079.239101', 'EAST HICKORY', 'PA', 'PENNSYLVANIA', 'FOREST', 'PO BOX ONLY'),
(6535, '16322', '+41.475887', '-079.239101', 'ENDEAVOR', 'PA', 'PENNSYLVANIA', 'FOREST', 'PO BOX ONLY'),
(6536, '16323', '+41.335291', '-079.783172', 'FRANKLIN', 'PA', 'PENNSYLVANIA', 'VENANGO', 'STANDARD'),
(6537, '16326', '+41.202325', '-079.453751', 'FRYBURG', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6538, '16327', '+41.666057', '-080.065793', 'GUYS MILLS', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6539, '16328', '+41.666057', '-080.065793', 'HYDETOWN', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'PO BOX ONLY'),
(6540, '16329', '+41.811682', '-079.264322', 'IRVINE', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6541, '16331', '+41.202325', '-079.453751', 'KOSSUTH', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6542, '16332', '+41.355729', '-079.381225', 'LICKINGVILLE', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6543, '16333', '+41.742791', '-078.787260', 'LUDLOW', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'PO BOX ONLY');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(6544, '16334', '+41.202325', '-079.453751', 'MARBLE', 'PA', 'PENNSYLVANIA', 'CLARION', 'STANDARD'),
(6545, '16335', '+41.611599', '-080.114891', 'MEADVILLE', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6546, '16340', '+41.862381', '-079.432589', 'PITTSFIELD', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6547, '16341', '+41.501311', '-079.633336', 'PLEASANTVILLE', 'PA', 'PENNSYLVANIA', 'VENANGO', 'STANDARD'),
(6548, '16342', '+41.320273', '-079.926847', 'POLK', 'PA', 'PENNSYLVANIA', 'VENANGO', 'STANDARD'),
(6549, '16343', '+41.411018', '-079.749341', 'RENO', 'PA', 'PENNSYLVANIA', 'VENANGO', 'PO BOX ONLY'),
(6550, '16344', '+41.471714', '-079.688057', 'ROUSEVILLE', 'PA', 'PENNSYLVANIA', 'VENANGO', 'PO BOX ONLY'),
(6551, '16345', '+41.926402', '-079.090299', 'RUSSELL', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6552, '16346', '+41.378581', '-079.707212', 'SENECA', 'PA', 'PENNSYLVANIA', 'VENANGO', 'STANDARD'),
(6553, '16347', '+41.683380', '-079.032776', 'SHEFFIELD', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6554, '16350', '+41.890561', '-079.227866', 'SUGAR GROVE', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6555, '16351', '+41.830662', '-079.229452', 'TIDIOUTE', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6556, '16352', '+41.743431', '-079.052756', 'TIONA', 'PA', 'PENNSYLVANIA', 'WARREN', 'PO BOX ONLY'),
(6557, '16353', '+41.500915', '-079.407452', 'TIONESTA', 'PA', 'PENNSYLVANIA', 'FOREST', 'STANDARD'),
(6558, '16354', '+41.661775', '-079.720068', 'TITUSVILLE', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6559, '16360', '+41.689858', '-079.900897', 'TOWNVILLE', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6560, '16361', '+41.202325', '-079.453751', 'TYLERSBURG', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6561, '16362', '+41.398105', '-079.738809', 'UTICA', 'PA', 'PENNSYLVANIA', 'VENANGO', 'STANDARD'),
(6562, '16364', '+41.398105', '-079.738809', 'VENUS', 'PA', 'PENNSYLVANIA', 'VENANGO', 'STANDARD'),
(6563, '16365', '+41.843560', '-079.172619', 'WARREN', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6564, '16366', '+41.811682', '-079.264322', 'WARREN', 'PA', 'PENNSYLVANIA', 'WARREN', 'UNIQUE'),
(6565, '16367', '+41.811682', '-079.264322', 'WARREN', 'PA', 'PENNSYLVANIA', 'WARREN', 'UNIQUE'),
(6566, '16368', '+41.811682', '-079.264322', 'WARREN', 'PA', 'PENNSYLVANIA', 'WARREN', 'UNIQUE'),
(6567, '16369', '+41.811682', '-079.264322', 'WARREN', 'PA', 'PENNSYLVANIA', 'WARREN', 'UNIQUE'),
(6568, '16370', '+41.475887', '-079.239101', 'WEST HICKORY', 'PA', 'PENNSYLVANIA', 'FOREST', 'PO BOX ONLY'),
(6569, '16371', '+41.823681', '-079.201275', 'YOUNGSVILLE', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6570, '16372', '+41.199287', '-079.874548', 'CLINTONVILLE', 'PA', 'PENNSYLVANIA', 'VENANGO', 'PO BOX ONLY'),
(6571, '16373', '+41.273318', '-079.812491', 'EMLENTON', 'PA', 'PENNSYLVANIA', 'VENANGO', 'STANDARD'),
(6572, '16374', '+41.398105', '-079.738809', 'KENNERDELL', 'PA', 'PENNSYLVANIA', 'VENANGO', 'STANDARD'),
(6573, '16375', '+41.202325', '-079.453751', 'LAMARTINE', 'PA', 'PENNSYLVANIA', 'CLARION', 'PO BOX ONLY'),
(6574, '16388', '+41.659552', '-080.157553', 'MEADVILLE', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'UNIQUE'),
(6575, '16401', '+41.894652', '-080.311081', 'ALBION', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6576, '16402', '+41.969142', '-079.477037', 'BEAR LAKE', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6577, '16403', '+41.803393', '-080.059383', 'CAMBRIDGE SPRINGS', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6578, '16404', '+41.666057', '-080.065793', 'CENTERVILLE', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6579, '16405', '+41.943966', '-079.568294', 'COLUMBUS', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6580, '16406', '+41.757871', '-080.370323', 'CONNEAUTVILLE', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6581, '16407', '+41.924886', '-079.696549', 'CORRY', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6582, '16410', '+41.921275', '-080.302761', 'CRANESVILLE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6583, '16411', '+41.982574', '-080.439619', 'EAST SPRINGFIELD', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6584, '16412', '+41.904250', '-080.157715', 'EDINBORO', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6585, '16413', '+42.182748', '-080.064915', 'ELGIN', 'PA', 'PENNSYLVANIA', 'ERIE', 'PO BOX ONLY'),
(6586, '16415', '+42.011544', '-080.335032', 'FAIRVIEW', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6587, '16416', '+41.818831', '-079.446306', 'GARLAND', 'PA', 'PENNSYLVANIA', 'WARREN', 'PO BOX ONLY'),
(6588, '16417', '+41.950719', '-080.295852', 'GIRARD', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6589, '16420', '+41.811682', '-079.264322', 'GRAND VALLEY', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6590, '16421', '+42.172938', '-079.937675', 'HARBORCREEK', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6591, '16422', '+41.643145', '-080.394299', 'HARMONSBURG', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'PO BOX ONLY'),
(6592, '16423', '+42.015789', '-080.346492', 'LAKE CITY', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6593, '16424', '+41.624388', '-080.452295', 'LINESVILLE', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6594, '16426', '+41.985964', '-080.132523', 'MC KEAN', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6595, '16427', '+41.877260', '-079.969168', 'MILL VILLAGE', 'PA', 'PENNSYLVANIA', 'ERIE', 'PO BOX ONLY'),
(6596, '16428', '+42.176845', '-079.841991', 'NORTH EAST', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6597, '16430', '+41.999881', '-080.425850', 'NORTH SPRINGFIELD', 'PA', 'PENNSYLVANIA', 'ERIE', 'PO BOX ONLY'),
(6598, '16432', '+41.666057', '-080.065793', 'RICEVILLE', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'PO BOX ONLY'),
(6599, '16433', '+41.752837', '-080.207488', 'SAEGERTOWN', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6600, '16434', '+41.667286', '-080.097316', 'SPARTANSBURG', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6601, '16435', '+41.800421', '-080.371429', 'SPRINGBORO', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6602, '16436', '+41.920018', '-079.448206', 'SPRING CREEK', 'PA', 'PENNSYLVANIA', 'WARREN', 'STANDARD'),
(6603, '16438', '+41.941617', '-079.845963', 'UNION CITY', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6604, '16440', '+41.763965', '-080.098233', 'VENANGO', 'PA', 'PENNSYLVANIA', 'CRAWFORD', 'STANDARD'),
(6605, '16441', '+41.970601', '-079.997581', 'WATERFORD', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6606, '16442', '+42.030403', '-079.828985', 'WATTSBURG', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6607, '16443', '+41.935633', '-080.471462', 'WEST SPRINGFIELD', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6608, '16444', '+42.182748', '-080.064915', 'EDINBORO', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6609, '16475', '+42.182748', '-080.064915', 'ALBION', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6610, '16501', '+42.087337', '-080.087341', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6611, '16502', '+42.110357', '-080.100931', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6612, '16503', '+42.126757', '-080.061029', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6613, '16504', '+42.109556', '-080.050278', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6614, '16505', '+42.110857', '-080.153383', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6615, '16506', '+42.064456', '-080.165682', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6616, '16507', '+42.134257', '-080.084042', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6617, '16508', '+42.097156', '-080.092830', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6618, '16509', '+42.048568', '-080.027928', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6619, '16510', '+42.108655', '-079.953504', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6620, '16511', '+42.160153', '-079.984376', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6621, '16512', '+42.030201', '-080.257855', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6622, '16514', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6623, '16515', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6624, '16522', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6625, '16530', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6626, '16531', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6627, '16532', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6628, '16533', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6629, '16534', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6630, '16538', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6631, '16541', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6632, '16544', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6633, '16546', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6634, '16550', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6635, '16553', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6636, '16554', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6637, '16558', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'UNIQUE'),
(6638, '16563', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6639, '16565', '+42.182748', '-080.064915', 'ERIE', 'PA', 'PENNSYLVANIA', 'ERIE', 'STANDARD'),
(6640, '16601', '+40.489433', '-078.349874', 'ALTOONA', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6641, '16602', '+40.508219', '-078.382635', 'ALTOONA', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6642, '16603', '+40.501770', '-078.410035', 'ALTOONA', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6643, '16611', '+40.548510', '-078.095064', 'ALEXANDRIA', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6644, '16613', '+40.554875', '-078.544825', 'ASHVILLE', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6645, '16614', '+40.262311', '-078.421434', 'BAKERS SUMMIT', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'PO BOX ONLY'),
(6646, '16616', '+40.989115', '-078.422403', 'BECCARIA', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6647, '16617', '+40.562667', '-078.363835', 'BELLWOOD', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6648, '16619', '+40.684687', '-078.413712', 'BLANDBURG', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6649, '16620', '+40.989115', '-078.422403', 'BRISBIN', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6650, '16621', '+40.199900', '-078.140812', 'BROAD TOP', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6651, '16622', '+40.402523', '-077.966977', 'CALVIN', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6652, '16623', '+40.285076', '-078.022032', 'CASSVILLE', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6653, '16624', '+40.570219', '-078.599119', 'CHEST SPRINGS', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6654, '16625', '+40.354932', '-078.462660', 'CLAYSBURG', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6655, '16627', '+40.749629', '-078.536067', 'COALPORT', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6656, '16629', '+40.521778', '-078.526274', 'COUPON', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6657, '16630', '+40.470718', '-078.589460', 'CRESSON', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6658, '16631', '+40.493522', '-078.368229', 'CURRYVILLE', 'PA', 'PENNSYLVANIA', 'BLAIR', 'PO BOX ONLY'),
(6659, '16633', '+40.160065', '-078.234638', 'DEFIANCE', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'PO BOX ONLY'),
(6660, '16634', '+40.402523', '-077.966977', 'DUDLEY', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'PO BOX ONLY'),
(6661, '16635', '+40.510278', '-078.407982', 'DUNCANSVILLE', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6662, '16636', '+40.607720', '-078.526783', 'DYSART', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6663, '16637', '+40.349335', '-078.442466', 'EAST FREEDOM', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6664, '16638', '+40.402523', '-077.966977', 'ENTRIKEN', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6665, '16639', '+40.671195', '-078.508823', 'FALLENTIMBER', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6666, '16640', '+40.687598', '-078.552346', 'FLINTON', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6667, '16641', '+40.507567', '-078.576208', 'GALLITZIN', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6668, '16644', '+40.717845', '-078.463679', 'GLASGOW', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'PO BOX ONLY'),
(6669, '16645', '+40.989115', '-078.422403', 'GLEN HOPE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6670, '16646', '+40.680896', '-078.599266', 'HASTINGS', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6671, '16647', '+40.402523', '-077.966977', 'HESSTON', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6672, '16648', '+40.432059', '-078.364965', 'HOLLIDAYSBURG', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6673, '16650', '+40.108984', '-078.279287', 'HOPEWELL', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6674, '16651', '+40.789950', '-078.377189', 'HOUTZDALE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6675, '16652', '+40.515371', '-077.975879', 'HUNTINGDON', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6676, '16654', '+40.402523', '-077.966977', 'HUNTINGDON', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'UNIQUE'),
(6677, '16655', '+40.250384', '-078.537796', 'IMLER', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6678, '16656', '+40.989115', '-078.422403', 'IRVONA', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6679, '16657', '+40.385496', '-078.172245', 'JAMES CREEK', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6680, '16659', '+40.170266', '-078.385341', 'LOYSBURG', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6681, '16660', '+40.402523', '-077.966977', 'MC CONNELLSTOWN', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'PO BOX ONLY'),
(6682, '16661', '+40.830471', '-078.435525', 'MADERA', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6683, '16662', '+40.339840', '-078.336709', 'MARTINSBURG', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6684, '16663', '+40.989115', '-078.422403', 'MORANN', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6685, '16664', '+40.193882', '-078.426719', 'NEW ENTERPRISE', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6686, '16665', '+40.385507', '-078.447236', 'NEWRY', 'PA', 'PENNSYLVANIA', 'BLAIR', 'PO BOX ONLY'),
(6687, '16666', '+40.822197', '-078.455355', 'OSCEOLA MILLS', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6688, '16667', '+40.181801', '-078.493371', 'OSTERBURG', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6689, '16668', '+40.633518', '-078.608257', 'PATTON', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6690, '16669', '+40.583226', '-078.073445', 'PETERSBURG', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6691, '16670', '+40.254864', '-078.512462', 'QUEEN', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6692, '16671', '+40.989115', '-078.422403', 'RAMEY', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6693, '16672', '+40.175325', '-078.249266', 'RIDDLESBURG', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'PO BOX ONLY'),
(6694, '16673', '+40.335467', '-078.387541', 'ROARING SPRING', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6695, '16674', '+40.186465', '-078.116188', 'ROBERTSDALE', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6696, '16675', '+40.671181', '-078.675548', 'SAINT BONIFACE', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'STANDARD'),
(6697, '16677', '+40.813628', '-078.238986', 'SANDY RIDGE', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6698, '16678', '+40.201876', '-078.252528', 'SAXTON', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6699, '16679', '+40.169799', '-078.212185', 'SIX MILE RUN', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6700, '16680', '+40.760116', '-078.450043', 'SMITHMILL', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6701, '16681', '+40.989115', '-078.422403', 'SMOKERUN', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6702, '16682', '+40.271126', '-078.458780', 'SPROUL', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6703, '16683', '+40.402523', '-077.966977', 'SPRUCE CREEK', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6704, '16684', '+40.636691', '-078.303614', 'TIPTON', 'PA', 'PENNSYLVANIA', 'BLAIR', 'PO BOX ONLY'),
(6705, '16685', '+40.270965', '-078.077244', 'TODD', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6706, '16686', '+40.522068', '-078.340045', 'TYRONE', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6707, '16689', '+39.943762', '-078.122265', 'WATERFALL', 'PA', 'PENNSYLVANIA', 'FULTON', 'STANDARD'),
(6708, '16691', '+39.943762', '-078.122265', 'WELLS TANNERY', 'PA', 'PENNSYLVANIA', 'FULTON', 'STANDARD'),
(6709, '16692', '+40.745169', '-078.676830', 'WESTOVER', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6710, '16693', '+40.402532', '-078.255764', 'WILLIAMSBURG', 'PA', 'PENNSYLVANIA', 'BLAIR', 'STANDARD'),
(6711, '16694', '+40.165987', '-078.138144', 'WOOD', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'PO BOX ONLY'),
(6712, '16695', '+40.230406', '-078.358877', 'WOODBURY', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6713, '16698', '+40.989115', '-078.422403', 'HOUTZDALE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'UNIQUE'),
(6714, '16699', '+40.484487', '-078.702224', 'CRESSON', 'PA', 'PENNSYLVANIA', 'CAMBRIA', 'UNIQUE'),
(6715, '16701', '+41.862341', '-078.637310', 'BRADFORD', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6716, '16720', '+41.615099', '-077.957975', 'AUSTIN', 'PA', 'PENNSYLVANIA', 'POTTER', 'STANDARD'),
(6717, '16724', '+41.801078', '-078.579739', 'CROSBY', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'PO BOX ONLY'),
(6718, '16725', '+41.885487', '-078.723198', 'CUSTER CITY', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'PO BOX ONLY'),
(6719, '16726', '+41.818645', '-078.595669', 'CYCLONE', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6720, '16727', '+41.982786', '-078.546304', 'DERRICK CITY', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6721, '16728', '+41.415878', '-078.665057', 'DE YOUNG', 'PA', 'PENNSYLVANIA', 'ELK', 'PO BOX ONLY'),
(6722, '16729', '+41.960890', '-078.486099', 'DUKE CENTER', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6723, '16730', '+41.801078', '-078.579739', 'EAST SMETHPORT', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'PO BOX ONLY'),
(6724, '16731', '+41.941328', '-078.361927', 'ELDRED', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6725, '16732', '+41.801078', '-078.579739', 'GIFFORD', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6726, '16733', '+41.801078', '-078.579739', 'HAZEL HURST', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'PO BOX ONLY'),
(6727, '16734', '+41.619213', '-078.839413', 'JAMES CITY', 'PA', 'PENNSYLVANIA', 'ELK', 'PO BOX ONLY'),
(6728, '16735', '+41.795662', '-078.631755', 'KANE', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6729, '16738', '+41.836866', '-078.691582', 'LEWIS RUN', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6730, '16740', '+41.719284', '-078.623042', 'MOUNT JEWETT', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6731, '16743', '+41.881851', '-078.457878', 'PORT ALLEGANY', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6732, '16744', '+41.878330', '-078.557219', 'REW', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6733, '16745', '+41.919565', '-078.485610', 'RIXFORD', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6734, '16746', '+41.737627', '-077.902366', 'ROULETTE', 'PA', 'PENNSYLVANIA', 'POTTER', 'STANDARD'),
(6735, '16748', '+41.963791', '-078.188866', 'SHINGLEHOUSE', 'PA', 'PENNSYLVANIA', 'POTTER', 'STANDARD'),
(6736, '16749', '+41.798748', '-078.539192', 'SMETHPORT', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6737, '16750', '+41.801078', '-078.579739', 'TURTLEPOINT', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6738, '16751', '+41.801078', '-078.579739', 'WESTLINE', 'PA', 'PENNSYLVANIA', 'MCKEAN', 'STANDARD'),
(6739, '16801', '+40.881935', '-077.867822', 'STATE COLLEGE', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6740, '16802', '+40.799672', '-077.862339', 'UNIVERSITY PARK', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6741, '16803', '+40.878721', '-077.757999', 'STATE COLLEGE', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6742, '16804', '+40.972229', '-077.760172', 'STATE COLLEGE', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6743, '16805', '+40.972229', '-077.760172', 'STATE COLLEGE', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6744, '16820', '+40.898690', '-077.456184', 'AARONSBURG', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6745, '16821', '+40.989115', '-078.422403', 'ALLPORT', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6746, '16822', '+41.105476', '-077.505530', 'BEECH CREEK', 'PA', 'PENNSYLVANIA', 'CLINTON', 'STANDARD'),
(6747, '16823', '+40.897823', '-077.773188', 'BELLEFONTE', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6748, '16825', '+40.990006', '-078.360612', 'BIGLER', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6749, '16826', '+40.972229', '-077.760172', 'BLANCHARD', 'PA', 'PENNSYLVANIA', 'CENTRE', 'PO BOX ONLY'),
(6750, '16827', '+40.885162', '-077.644896', 'BOALSBURG', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6751, '16828', '+40.807973', '-077.703942', 'CENTRE HALL', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6752, '16829', '+40.932545', '-077.763472', 'CLARENCE', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6753, '16830', '+41.037563', '-078.435492', 'CLEARFIELD', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6754, '16832', '+40.838329', '-077.450929', 'COBURN', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6755, '16833', '+40.949208', '-078.582309', 'CURWENSVILLE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6756, '16834', '+40.989115', '-078.422403', 'DRIFTING', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6757, '16835', '+40.904645', '-077.875191', 'FLEMING', 'PA', 'PENNSYLVANIA', 'CENTRE', 'PO BOX ONLY'),
(6758, '16836', '+40.989115', '-078.422403', 'FRENCHVILLE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6759, '16837', '+40.989115', '-078.422403', 'GLEN RICHEY', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6760, '16838', '+40.989115', '-078.422403', 'GRAMPIAN', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6761, '16839', '+40.989115', '-078.422403', 'GRASSFLAT', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6762, '16840', '+40.989115', '-078.422403', 'HAWK RUN', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6763, '16841', '+40.918199', '-077.679655', 'HOWARD', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6764, '16843', '+41.003007', '-078.464189', 'HYDE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6765, '16844', '+40.901934', '-077.750812', 'JULIAN', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6766, '16845', '+40.989115', '-078.422403', 'KARTHAUS', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6767, '16847', '+40.989115', '-078.422403', 'KYLERTOWN', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6768, '16848', '+41.220635', '-077.618532', 'LAMAR', 'PA', 'PENNSYLVANIA', 'CLINTON', 'PO BOX ONLY'),
(6769, '16849', '+40.989115', '-078.422403', 'LANSE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6770, '16850', '+40.989115', '-078.422403', 'LECONTES MILLS', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6771, '16851', '+40.808151', '-077.812525', 'LEMONT', 'PA', 'PENNSYLVANIA', 'CENTRE', 'PO BOX ONLY'),
(6772, '16852', '+40.972229', '-077.760172', 'MADISONBURG', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6773, '16853', '+40.954080', '-077.781465', 'MILESBURG', 'PA', 'PENNSYLVANIA', 'CENTRE', 'PO BOX ONLY'),
(6774, '16854', '+40.893455', '-077.473298', 'MILLHEIM', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6775, '16855', '+40.989115', '-078.422403', 'MINERAL SPRINGS', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6776, '16856', '+40.929851', '-077.638892', 'MINGOVILLE', 'PA', 'PENNSYLVANIA', 'CENTRE', 'PO BOX ONLY'),
(6777, '16858', '+40.968910', '-078.191551', 'MORRISDALE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6778, '16859', '+40.900499', '-078.025894', 'MOSHANNON', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6779, '16860', '+40.989115', '-078.422403', 'MUNSON', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6780, '16861', '+40.989115', '-078.422403', 'NEW MILLPORT', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6781, '16863', '+40.989115', '-078.422403', 'OLANTA', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6782, '16864', '+40.972229', '-077.760172', 'ORVISTON', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6783, '16865', '+40.868075', '-077.957409', 'PENNSYLVANIA FURNACE', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6784, '16866', '+40.905166', '-077.844216', 'PHILIPSBURG', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6785, '16868', '+40.726405', '-077.911776', 'PINE GROVE MILLS', 'PA', 'PENNSYLVANIA', 'CENTRE', 'PO BOX ONLY'),
(6786, '16870', '+40.913584', '-077.829726', 'PORT MATILDA', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6787, '16871', '+40.989115', '-078.422403', 'POTTERSDALE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6788, '16872', '+40.939915', '-077.448451', 'REBERSBURG', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6789, '16873', '+40.989115', '-078.422403', 'SHAWVILLE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6790, '16874', '+40.992146', '-078.027865', 'SNOW SHOE', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6791, '16875', '+40.883680', '-077.518716', 'SPRING MILLS', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6792, '16876', '+40.961582', '-078.292599', 'WALLACETON', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'PO BOX ONLY'),
(6793, '16877', '+40.692101', '-078.165044', 'WARRIORS MARK', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6794, '16878', '+40.989115', '-078.422403', 'WEST DECATUR', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6795, '16879', '+40.989115', '-078.422403', 'WINBURNE', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6796, '16881', '+40.989115', '-078.422403', 'WOODLAND', 'PA', 'PENNSYLVANIA', 'CLEARFIELD', 'STANDARD'),
(6797, '16882', '+40.897081', '-077.402419', 'WOODWARD', 'PA', 'PENNSYLVANIA', 'CENTRE', 'STANDARD'),
(6798, '16901', '+41.862339', '-077.258974', 'WELLSBORO', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6799, '16910', '+41.771970', '-076.521266', 'ALBA', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'PO BOX ONLY'),
(6800, '16911', '+41.771970', '-077.242228', 'ARNOT', 'PA', 'PENNSYLVANIA', 'TIOGA', 'PO BOX ONLY'),
(6801, '16912', '+41.822885', '-077.200274', 'BLOSSBURG', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6802, '16914', '+41.771970', '-076.521266', 'COLUMBIA CROSS ROADS', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(6803, '16915', '+41.776165', '-077.956692', 'COUDERSPORT', 'PA', 'PENNSYLVANIA', 'POTTER', 'STANDARD'),
(6804, '16917', '+41.769456', '-077.000451', 'COVINGTON', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6805, '16918', '+41.771970', '-077.242228', 'COWANESQUE', 'PA', 'PENNSYLVANIA', 'TIOGA', 'PO BOX ONLY'),
(6806, '16920', '+41.979118', '-077.370183', 'ELKLAND', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6807, '16921', '+41.771970', '-077.242228', 'GAINES', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6808, '16922', '+41.733379', '-077.644214', 'GALETON', 'PA', 'PENNSYLVANIA', 'POTTER', 'STANDARD'),
(6809, '16923', '+41.737627', '-077.902366', 'GENESEE', 'PA', 'PENNSYLVANIA', 'POTTER', 'STANDARD'),
(6810, '16925', '+41.938208', '-076.800579', 'GILLETT', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(6811, '16926', '+41.771970', '-076.521266', 'GRANVILLE SUMMIT', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(6812, '16927', '+41.737627', '-077.902366', 'HARRISON VALLEY', 'PA', 'PENNSYLVANIA', 'POTTER', 'STANDARD'),
(6813, '16928', '+41.936020', '-077.445729', 'KNOXVILLE', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6814, '16929', '+41.984078', '-077.181189', 'LAWRENCEVILLE', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6815, '16930', '+41.771970', '-077.242228', 'LIBERTY', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6816, '16932', '+41.790065', '-077.035282', 'MAINESBURG', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6817, '16933', '+41.793666', '-077.072151', 'MANSFIELD', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6818, '16935', '+41.771970', '-077.242228', 'MIDDLEBURY CENTER', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6819, '16936', '+41.908430', '-077.011231', 'MILLERTON', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6820, '16937', '+41.737627', '-077.902366', 'MILLS', 'PA', 'PENNSYLVANIA', 'POTTER', 'STANDARD'),
(6821, '16938', '+41.771970', '-077.242228', 'MORRIS', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6822, '16939', '+41.677542', '-077.015194', 'MORRIS RUN', 'PA', 'PENNSYLVANIA', 'TIOGA', 'PO BOX ONLY'),
(6823, '16940', '+41.977039', '-077.245310', 'NELSON', 'PA', 'PENNSYLVANIA', 'TIOGA', 'PO BOX ONLY'),
(6824, '16941', '+41.737627', '-077.902366', 'GENESEE', 'PA', 'PENNSYLVANIA', 'POTTER', 'STANDARD'),
(6825, '16942', '+41.989264', '-077.347725', 'OSCEOLA', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6826, '16943', '+41.771970', '-077.242228', 'SABINSVILLE', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6827, '16945', '+41.771970', '-076.521266', 'SYLVANIA', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'PO BOX ONLY'),
(6828, '16946', '+41.943444', '-077.229200', 'TIOGA', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6829, '16947', '+41.788389', '-076.837246', 'TROY', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(6830, '16948', '+41.843678', '-077.757360', 'ULYSSES', 'PA', 'PENNSYLVANIA', 'POTTER', 'STANDARD'),
(6831, '16950', '+41.919341', '-077.523033', 'WESTFIELD', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(6832, '17001', '+40.216040', '-076.924996', 'CAMP HILL', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6833, '17002', '+40.539667', '-077.790168', 'ALLENSVILLE', 'PA', 'PENNSYLVANIA', 'MIFFLIN', 'STANDARD'),
(6834, '17003', '+40.352637', '-076.435873', 'ANNVILLE', 'PA', 'PENNSYLVANIA', 'LEBANON', 'STANDARD'),
(6835, '17004', '+40.591417', '-077.731030', 'BELLEVILLE', 'PA', 'PENNSYLVANIA', 'MIFFLIN', 'STANDARD'),
(6836, '17005', '+40.600992', '-076.811693', 'BERRYSBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'PO BOX ONLY'),
(6837, '17006', '+40.297360', '-077.564370', 'BLAIN', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6838, '17007', '+40.141205', '-077.242351', 'BOILING SPRINGS', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6839, '17008', '+40.167091', '-076.978448', 'BOWMANSDALE', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'PO BOX ONLY'),
(6840, '17009', '+40.629711', '-077.607196', 'BURNHAM', 'PA', 'PENNSYLVANIA', 'MIFFLIN', 'STANDARD'),
(6841, '17010', '+40.271240', '-076.582049', 'CAMPBELLTOWN', 'PA', 'PENNSYLVANIA', 'LEBANON', 'PO BOX ONLY'),
(6842, '17011', '+40.251914', '-077.079091', 'CAMP HILL', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6843, '17012', '+40.136687', '-077.242805', 'CAMP HILL', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'UNIQUE'),
(6844, '17013', '+40.168495', '-077.228817', 'CARLISLE', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6845, '17014', '+40.478716', '-077.345514', 'COCOLAMUS', 'PA', 'PENNSYLVANIA', 'JUNIATA', 'STANDARD'),
(6846, '17016', '+40.275536', '-076.405309', 'CORNWALL', 'PA', 'PENNSYLVANIA', 'LEBANON', 'PO BOX ONLY'),
(6847, '17017', '+40.894363', '-076.596151', 'DALMATIA', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(6848, '17018', '+40.361876', '-076.895539', 'DAUPHIN', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6849, '17019', '+40.091217', '-076.977835', 'DILLSBURG', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(6850, '17020', '+40.458261', '-077.060745', 'DUNCANNON', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6851, '17021', '+40.478716', '-077.345514', 'EAST WATERFORD', 'PA', 'PENNSYLVANIA', 'JUNIATA', 'STANDARD'),
(6852, '17022', '+40.150963', '-076.610280', 'ELIZABETHTOWN', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(6853, '17023', '+40.584804', '-076.767913', 'ELIZABETHVILLE', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6854, '17024', '+40.442354', '-077.270880', 'ELLIOTTSBURG', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6855, '17025', '+40.235675', '-076.987249', 'ENOLA', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6856, '17026', '+40.456193', '-076.434639', 'FREDERICKSBURG', 'PA', 'PENNSYLVANIA', 'LEBANON', 'STANDARD'),
(6857, '17027', '+40.157981', '-076.996398', 'GRANTHAM', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'PO BOX ONLY'),
(6858, '17028', '+40.373438', '-076.682667', 'GRANTVILLE', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6859, '17029', '+40.550937', '-077.626095', 'GRANVILLE', 'PA', 'PENNSYLVANIA', 'MIFFLIN', 'STANDARD'),
(6860, '17030', '+40.608245', '-076.737545', 'GRATZ', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6861, '17031', '+40.406766', '-077.292578', 'GREEN PARK', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6862, '17032', '+40.507107', '-076.843844', 'HALIFAX', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6863, '17033', '+40.269748', '-076.636357', 'HERSHEY', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6864, '17034', '+40.329577', '-076.834076', 'HIGHSPIRE', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6865, '17035', '+40.478716', '-077.345514', 'HONEY GROVE', 'PA', 'PENNSYLVANIA', 'JUNIATA', 'STANDARD'),
(6866, '17036', '+40.340043', '-076.782764', 'HUMMELSTOWN', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6867, '17037', '+40.436276', '-077.397013', 'ICKESBURG', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6868, '17038', '+40.430902', '-076.480732', 'JONESTOWN', 'PA', 'PENNSYLVANIA', 'LEBANON', 'STANDARD'),
(6869, '17039', '+40.300505', '-076.258399', 'KLEINFELTERSVILLE', 'PA', 'PENNSYLVANIA', 'LEBANON', 'PO BOX ONLY'),
(6870, '17040', '+40.342530', '-077.304476', 'LANDISBURG', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6871, '17041', '+40.223623', '-076.538007', 'LAWN', 'PA', 'PENNSYLVANIA', 'LEBANON', 'PO BOX ONLY'),
(6872, '17042', '+40.331594', '-076.397634', 'LEBANON', 'PA', 'PENNSYLVANIA', 'LEBANON', 'STANDARD'),
(6873, '17043', '+40.244339', '-076.918796', 'LEMOYNE', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6874, '17044', '+40.564909', '-077.630152', 'LEWISTOWN', 'PA', 'PENNSYLVANIA', 'MIFFLIN', 'STANDARD'),
(6875, '17045', '+40.574445', '-076.987538', 'LIVERPOOL', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6876, '17046', '+40.381212', '-076.436791', 'LEBANON', 'PA', 'PENNSYLVANIA', 'LEBANON', 'STANDARD'),
(6877, '17047', '+40.406766', '-077.292578', 'LOYSVILLE', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6878, '17048', '+40.558844', '-076.790132', 'LYKENS', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6879, '17049', '+40.651725', '-077.306056', 'MC ALISTERVILLE', 'PA', 'PENNSYLVANIA', 'JUNIATA', 'STANDARD'),
(6880, '17050', '', '', 'MECHANICSBURG', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6881, '17051', '+40.478095', '-077.734919', 'MC VEYTOWN', 'PA', 'PENNSYLVANIA', 'MIFFLIN', 'STANDARD'),
(6882, '17052', '+40.402523', '-077.966977', 'MAPLETON DEPOT', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6883, '17053', '+40.325105', '-077.025886', 'MARYSVILLE', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6884, '17054', '+40.495979', '-077.723716', 'MATTAWANA', 'PA', 'PENNSYLVANIA', 'MIFFLIN', 'PO BOX ONLY'),
(6885, '17055', '+40.180953', '-077.177086', 'MECHANICSBURG', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6886, '17056', '+40.478716', '-077.345514', 'MEXICO', 'PA', 'PENNSYLVANIA', 'JUNIATA', 'PO BOX ONLY'),
(6887, '17057', '+40.191241', '-076.720142', 'MIDDLETOWN', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6888, '17058', '+40.555304', '-077.400062', 'MIFFLIN', 'PA', 'PENNSYLVANIA', 'JUNIATA', 'STANDARD'),
(6889, '17059', '+40.571404', '-077.317266', 'MIFFLINTOWN', 'PA', 'PENNSYLVANIA', 'JUNIATA', 'STANDARD'),
(6890, '17060', '+40.402523', '-077.966977', 'MILL CREEK', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6891, '17061', '+40.571494', '-076.840528', 'MILLERSBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6892, '17062', '+40.556195', '-077.154223', 'MILLERSTOWN', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6893, '17063', '+40.740026', '-077.493466', 'MILROY', 'PA', 'PENNSYLVANIA', 'MIFFLIN', 'STANDARD'),
(6894, '17064', '+40.254642', '-076.461544', 'MOUNT GRETNA', 'PA', 'PENNSYLVANIA', 'LEBANON', 'PO BOX ONLY'),
(6895, '17065', '+40.202649', '-077.082130', 'MOUNT HOLLY SPRINGS', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6896, '17066', '+40.382302', '-077.882222', 'MOUNT UNION', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6897, '17067', '+40.368282', '-076.359975', 'MYERSTOWN', 'PA', 'PENNSYLVANIA', 'LEBANON', 'STANDARD'),
(6898, '17068', '+40.405796', '-077.134043', 'NEW BLOOMFIELD', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6899, '17069', '+40.455272', '-076.970942', 'NEW BUFFALO', 'PA', 'PENNSYLVANIA', 'PERRY', 'PO BOX ONLY'),
(6900, '17070', '+40.263875', '-076.898096', 'NEW CUMBERLAND', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6901, '17071', '+40.406766', '-077.292578', 'NEW GERMANTOWN', 'PA', 'PENNSYLVANIA', 'PERRY', 'PO BOX ONLY'),
(6902, '17072', '+40.230601', '-077.079425', 'NEW KINGSTOWN', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'PO BOX ONLY'),
(6903, '17073', '+40.314112', '-076.260550', 'NEWMANSTOWN', 'PA', 'PENNSYLVANIA', 'LEBANON', 'STANDARD'),
(6904, '17074', '+40.506053', '-077.129129', 'NEWPORT', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6905, '17075', '+40.393130', '-077.831635', 'NEWTON HAMILTON', 'PA', 'PENNSYLVANIA', 'MIFFLIN', 'PO BOX ONLY'),
(6906, '17076', '+40.478716', '-077.345514', 'OAKLAND MILLS', 'PA', 'PENNSYLVANIA', 'JUNIATA', 'STANDARD'),
(6907, '17077', '+40.375404', '-076.414757', 'ONO', 'PA', 'PENNSYLVANIA', 'LEBANON', 'PO BOX ONLY'),
(6908, '17078', '+40.317606', '-076.416907', 'PALMYRA', 'PA', 'PENNSYLVANIA', 'LEBANON', 'STANDARD'),
(6909, '17080', '+40.639199', '-076.802920', 'PILLOW', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'PO BOX ONLY'),
(6910, '17081', '+40.203019', '-077.284761', 'PLAINFIELD', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'PO BOX ONLY'),
(6911, '17082', '+40.549581', '-077.395272', 'PORT ROYAL', 'PA', 'PENNSYLVANIA', 'JUNIATA', 'STANDARD'),
(6912, '17083', '+40.276390', '-076.411239', 'QUENTIN', 'PA', 'PENNSYLVANIA', 'LEBANON', 'PO BOX ONLY'),
(6913, '17084', '+40.541706', '-077.692538', 'REEDSVILLE', 'PA', 'PENNSYLVANIA', 'MIFFLIN', 'STANDARD'),
(6914, '17085', '+40.277076', '-076.385727', 'REXMONT', 'PA', 'PENNSYLVANIA', 'LEBANON', 'PO BOX ONLY'),
(6915, '17086', '+40.478716', '-077.345514', 'RICHFIELD', 'PA', 'PENNSYLVANIA', 'JUNIATA', 'STANDARD'),
(6916, '17087', '+40.362956', '-076.271943', 'RICHLAND', 'PA', 'PENNSYLVANIA', 'LEBANON', 'STANDARD'),
(6917, '17088', '+40.308696', '-076.296308', 'SCHAEFFERSTOWN', 'PA', 'PENNSYLVANIA', 'LEBANON', 'PO BOX ONLY'),
(6918, '17089', '+40.269738', '-076.936046', 'CAMP HILL', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'UNIQUE'),
(6919, '17090', '+40.342999', '-077.182569', 'SHERMANS DALE', 'PA', 'PENNSYLVANIA', 'PERRY', 'STANDARD'),
(6920, '17091', '+40.136687', '-077.242805', 'CAMP HILL', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'UNIQUE'),
(6921, '17093', '+40.293538', '-076.926346', 'SUMMERDALE', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'PO BOX ONLY'),
(6922, '17094', '+40.565325', '-077.235359', 'THOMPSONTOWN', 'PA', 'PENNSYLVANIA', 'JUNIATA', 'STANDARD'),
(6923, '17097', '+40.573734', '-076.656930', 'WICONISCO', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'PO BOX ONLY'),
(6924, '17098', '+40.588313', '-076.695547', 'WILLIAMSTOWN', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6925, '17099', '+40.644505', '-077.567708', 'YEAGERTOWN', 'PA', 'PENNSYLVANIA', 'MIFFLIN', 'STANDARD'),
(6926, '17101', '+40.264589', '-076.869644', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6927, '17102', '+40.272538', '-076.890695', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6928, '17103', '+40.272389', '-076.860994', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6929, '17104', '+40.253639', '-076.857944', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6930, '17105', '+40.278498', '-076.875207', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6931, '17106', '+40.292664', '-076.850061', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6932, '17107', '+40.297031', '-076.876437', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'UNIQUE'),
(6933, '17108', '+40.308638', '-076.801693', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6934, '17109', '+40.290953', '-076.820294', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6935, '17110', '+40.302238', '-076.866348', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6936, '17111', '+40.272089', '-076.801693', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6937, '17112', '+40.344295', '-076.790248', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6938, '17113', '+40.239040', '-076.841644', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6939, '17120', '+40.265689', '-076.882745', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6940, '17121', '+40.294396', '-076.893751', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6941, '17122', '+40.249845', '-076.871209', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6942, '17123', '+40.267518', '-076.883734', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6943, '17124', '+40.267460', '-076.885967', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6944, '17125', '+40.266221', '-076.882854', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6945, '17126', '+40.261790', '-076.880021', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6946, '17127', '+40.261516', '-076.880884', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6947, '17128', '+40.389865', '-076.782323', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6948, '17129', '+40.261516', '-076.880884', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6949, '17130', '+40.270222', '-076.882889', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'STANDARD'),
(6950, '17140', '+40.308640', '-076.846449', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'UNIQUE'),
(6951, '17177', '+40.298988', '-076.847194', 'HARRISBURG', 'PA', 'PENNSYLVANIA', 'DAUPHIN', 'UNIQUE'),
(6952, '17201', '+39.908055', '-077.666445', 'CHAMBERSBURG', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6953, '17210', '+40.171667', '-077.661354', 'AMBERSON', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(6954, '17211', '+39.755155', '-078.406388', 'ARTEMAS', 'PA', 'PENNSYLVANIA', 'BEDFORD', 'STANDARD'),
(6955, '17212', '+39.943762', '-078.122265', 'BIG COVE TANNERY', 'PA', 'PENNSYLVANIA', 'FULTON', 'STANDARD'),
(6956, '17213', '+40.179730', '-077.865942', 'BLAIRS MILLS', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6957, '17214', '+39.739893', '-077.470729', 'BLUE RIDGE SUMMIT', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6958, '17215', '+39.943762', '-078.122265', 'BURNT CABINS', 'PA', 'PENNSYLVANIA', 'FULTON', 'STANDARD'),
(6959, '17217', '+40.225168', '-077.725013', 'CONCORD', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6960, '17219', '+40.218448', '-077.679713', 'DOYLESBURG', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6961, '17220', '+40.178081', '-077.735336', 'DRY RUN', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6962, '17221', '+40.073155', '-077.832158', 'FANNETTSBURG', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6963, '17222', '+39.900035', '-077.529619', 'FAYETTEVILLE', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6964, '17223', '+39.943762', '-078.122265', 'FORT LITTLETON', 'PA', 'PENNSYLVANIA', 'FULTON', 'STANDARD'),
(6965, '17224', '+40.002593', '-077.809574', 'FORT LOUDON', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6966, '17225', '+39.805922', '-077.726127', 'GREENCASTLE', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6967, '17228', '+39.943762', '-078.122265', 'HARRISONVILLE', 'PA', 'PENNSYLVANIA', 'FULTON', 'STANDARD'),
(6968, '17229', '+39.943762', '-078.122265', 'HUSTONTOWN', 'PA', 'PENNSYLVANIA', 'FULTON', 'STANDARD'),
(6969, '17231', '+39.859432', '-077.857889', 'LEMASTERS', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(6970, '17232', '+40.105495', '-077.640461', 'LURGAN', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6971, '17233', '+39.928812', '-077.981379', 'MC CONNELLSBURG', 'PA', 'PENNSYLVANIA', 'FULTON', 'STANDARD'),
(6972, '17235', '+39.858699', '-077.698150', 'MARION', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(6973, '17236', '+39.819034', '-077.798952', 'MERCERSBURG', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6974, '17237', '+39.835930', '-077.553776', 'MONT ALTO', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6975, '17238', '+39.943762', '-078.122265', 'NEEDMORE', 'PA', 'PENNSYLVANIA', 'FULTON', 'STANDARD'),
(6976, '17239', '+40.402523', '-077.966977', 'NEELYTON', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6977, '17240', '+40.174798', '-077.470285', 'NEWBURG', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6978, '17241', '+40.173093', '-077.421905', 'NEWVILLE', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6979, '17243', '+40.225376', '-077.887496', 'ORBISONIA', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6980, '17244', '+40.079556', '-077.679344', 'ORRSTOWN', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6981, '17246', '+40.049118', '-077.671754', 'PLEASANT HALL', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6982, '17247', '+39.799481', '-077.581092', 'QUINCY', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(6983, '17249', '+40.402523', '-077.966977', 'ROCKHILL FURNACE', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'PO BOX ONLY'),
(6984, '17250', '+39.736395', '-077.524740', 'ROUZERVILLE', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(6985, '17251', '+40.112652', '-077.670626', 'ROXBURY', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(6986, '17252', '+39.916149', '-077.811826', 'SAINT THOMAS', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6987, '17253', '+40.402523', '-077.966977', 'SALTILLO', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'PO BOX ONLY'),
(6988, '17254', '+39.969590', '-077.584841', 'SCOTLAND', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(6989, '17255', '+40.133259', '-077.874750', 'SHADE GAP', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6990, '17256', '+39.783391', '-077.674851', 'SHADY GROVE', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(6991, '17257', '+40.070789', '-077.459830', 'SHIPPENSBURG', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6992, '17260', '+40.402523', '-077.966977', 'SHIRLEYSBURG', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6993, '17261', '+39.833095', '-077.488633', 'SOUTH MOUNTAIN', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(6994, '17262', '+40.173439', '-077.709212', 'SPRING RUN', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6995, '17263', '+39.724825', '-077.718629', 'STATE LINE', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(6996, '17264', '+40.222408', '-077.941975', 'THREE SPRINGS', 'PA', 'PENNSYLVANIA', 'HUNTINGDON', 'STANDARD'),
(6997, '17265', '+40.054782', '-077.775921', 'UPPERSTRASBURG', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(6998, '17266', '+40.104094', '-077.472794', 'WALNUT BOTTOM', 'PA', 'PENNSYLVANIA', 'CUMBERLAND', 'STANDARD'),
(6999, '17267', '+39.943762', '-078.122265', 'WARFORDSBURG', 'PA', 'PENNSYLVANIA', 'FULTON', 'STANDARD'),
(7000, '17268', '+39.793552', '-077.592280', 'WAYNESBORO', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(7001, '17270', '+39.854018', '-077.799733', 'WILLIAMSON', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(7002, '17271', '+40.108243', '-077.807221', 'WILLOW HILL', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'STANDARD'),
(7003, '17272', '+39.771372', '-077.627020', 'ZULLINGER', 'PA', 'PENNSYLVANIA', 'FRANKLIN', 'PO BOX ONLY'),
(7004, '17301', '+39.896923', '-076.994725', 'ABBOTTSTOWN', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7005, '17302', '+39.821313', '-076.405931', 'AIRVILLE', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7006, '17303', '+39.923644', '-077.300085', 'ARENDTSVILLE', 'PA', 'PENNSYLVANIA', 'ADAMS', 'PO BOX ONLY'),
(7007, '17304', '+39.976602', '-077.227126', 'ASPERS', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7008, '17306', '+39.979154', '-077.249592', 'BENDERSVILLE', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7009, '17307', '+39.933286', '-077.287491', 'BIGLERVILLE', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7010, '17309', '+39.860758', '-076.467305', 'BROGUE', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7011, '17310', '+39.890605', '-077.356642', 'CASHTOWN', 'PA', 'PENNSYLVANIA', 'ADAMS', 'PO BOX ONLY'),
(7012, '17311', '+39.871756', '-076.759884', 'CODORUS', 'PA', 'PENNSYLVANIA', 'YORK', 'PO BOX ONLY'),
(7013, '17312', '+39.946739', '-076.506639', 'CRALEY', 'PA', 'PENNSYLVANIA', 'YORK', 'PO BOX ONLY'),
(7014, '17313', '+39.912423', '-076.653530', 'DALLASTOWN', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7015, '17314', '+39.792142', '-076.543840', 'DELTA', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7016, '17315', '+40.004544', '-076.884956', 'DOVER', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7017, '17316', '+39.876563', '-077.027176', 'EAST BERLIN', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7018, '17317', '+39.970140', '-076.521686', 'EAST PROSPECT', 'PA', 'PENNSYLVANIA', 'YORK', 'PO BOX ONLY'),
(7019, '17318', '+40.021496', '-076.726638', 'EMIGSVILLE', 'PA', 'PENNSYLVANIA', 'YORK', 'PO BOX ONLY'),
(7020, '17319', '+40.150726', '-076.798353', 'ETTERS', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7021, '17320', '+39.780789', '-077.361859', 'FAIRFIELD', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7022, '17321', '+39.784476', '-076.518286', 'FAWN GROVE', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7023, '17322', '+39.844726', '-076.576556', 'FELTON', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7024, '17323', '+40.075010', '-077.027926', 'FRANKLINTOWN', 'PA', 'PENNSYLVANIA', 'YORK', 'PO BOX ONLY'),
(7025, '17324', '+40.017772', '-077.193663', 'GARDNERS', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7026, '17325', '+39.840922', '-077.226591', 'GETTYSBURG', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7027, '17326', '+39.894800', '-077.213493', 'GETTYSBURG', 'PA', 'PENNSYLVANIA', 'ADAMS', 'UNIQUE'),
(7028, '17327', '+39.892205', '-076.750637', 'GLEN ROCK', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7029, '17329', '+39.766883', '-076.877706', 'GLENVILLE', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7030, '17331', '+39.935502', '-076.672739', 'HANOVER', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(7031, '17332', '+39.775037', '-076.735116', 'HANOVER', 'PA', 'PENNSYLVANIA', 'YORK', 'UNIQUE'),
(7032, '17333', '+39.972985', '-076.687826', 'HANOVER', 'PA', 'PENNSYLVANIA', 'YORK', 'UNIQUE'),
(7033, '17334', '', '', 'HANOVER', 'PA', 'PENNSYLVANIA', 'YORK', 'UNIQUE'),
(7034, '17337', '+40.015656', '-077.200131', 'IDAVILLE', 'PA', 'PENNSYLVANIA', 'ADAMS', 'PO BOX ONLY'),
(7035, '17339', '+39.995219', '-076.889249', 'LEWISBERRY', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7036, '17340', '+39.829806', '-077.095399', 'LITTLESTOWN', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7037, '17342', '+39.853644', '-076.707997', 'LOGANVILLE', 'PA', 'PENNSYLVANIA', 'YORK', 'PO BOX ONLY'),
(7038, '17343', '+39.869229', '-077.329248', 'MC KNIGHTSTOWN', 'PA', 'PENNSYLVANIA', 'ADAMS', 'PO BOX ONLY'),
(7039, '17344', '+39.801004', '-077.022875', 'MC SHERRYSTOWN', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7040, '17345', '+39.954060', '-076.835812', 'MANCHESTER', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7041, '17347', '+39.942848', '-076.552798', 'MOUNT WOLF', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7042, '17349', '+39.866988', '-076.633324', 'NEW FREEDOM', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7043, '17350', '+39.881881', '-077.077431', 'NEW OXFORD', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7044, '17352', '+39.838639', '-076.449874', 'NEW PARK', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7045, '17353', '+39.882976', '-077.393593', 'ORRTANNA', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7046, '17354', '+39.824570', '-076.899270', 'PORTERS SIDELING', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7047, '17355', '+39.757328', '-076.699442', 'RAILROAD', 'PA', 'PENNSYLVANIA', 'YORK', 'PO BOX ONLY'),
(7048, '17356', '+39.905747', '-076.615805', 'RED LION', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7049, '17358', '+39.972985', '-076.687826', 'ROSSVILLE', 'PA', 'PENNSYLVANIA', 'YORK', 'PO BOX ONLY'),
(7050, '17360', '+39.823461', '-076.700714', 'SEVEN VALLEYS', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7051, '17361', '+39.799799', '-076.687931', 'SHREWSBURY', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7052, '17362', '+39.944531', '-076.775774', 'SPRING GROVE', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7053, '17363', '+39.809151', '-076.606747', 'STEWARTSTOWN', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7054, '17364', '+39.933775', '-076.905317', 'THOMASVILLE', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7055, '17365', '+40.018835', '-076.784811', 'WELLSVILLE', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7056, '17366', '+40.006581', '-076.613232', 'WINDSOR', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7057, '17368', '+39.994482', '-076.677736', 'WRIGHTSVILLE', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7058, '17370', '+40.067766', '-076.720322', 'YORK HAVEN', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7059, '17371', '+39.900579', '-076.789624', 'YORK NEW SALEM', 'PA', 'PENNSYLVANIA', 'YORK', 'PO BOX ONLY'),
(7060, '17372', '+40.007937', '-077.100231', 'YORK SPRINGS', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7061, '17375', '+39.894800', '-077.213493', 'PEACH GLEN', 'PA', 'PENNSYLVANIA', 'ADAMS', 'STANDARD'),
(7062, '17401', '+39.962998', '-076.727139', 'YORK', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7063, '17402', '+40.001615', '-076.689918', 'YORK', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7064, '17403', '+39.939390', '-076.666257', 'YORK', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7065, '17404', '+39.934957', '-076.577982', 'YORK', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7066, '17405', '+40.008647', '-076.597187', 'YORK', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7067, '17406', '+40.004593', '-076.594727', 'YORK', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7068, '17407', '+39.897907', '-076.662569', 'YORK', 'PA', 'PENNSYLVANIA', 'YORK', 'STANDARD'),
(7069, '17415', '+39.972985', '-076.687826', 'YORK', 'PA', 'PENNSYLVANIA', 'YORK', 'UNIQUE'),
(7070, '17501', '+40.129894', '-076.361053', 'AKRON', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7071, '17502', '+40.088469', '-076.462434', 'BAINBRIDGE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7072, '17503', '+40.018500', '-076.297582', 'BART', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7073, '17504', '+40.024047', '-076.328081', 'BAUSMAN', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7074, '17505', '+40.066647', '-076.187926', 'BIRD IN HAND', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7075, '17506', '+40.117326', '-076.052379', 'BLUE BALL', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7076, '17507', '+40.196641', '-076.016047', 'BOWMANSVILLE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7077, '17508', '+40.125896', '-076.213013', 'BROWNSTOWN', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7078, '17509', '+39.903954', '-076.040115', 'CHRISTIANA', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7079, '17512', '+40.116750', '-076.369028', 'COLUMBIA', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7080, '17516', '+40.026391', '-076.262044', 'CONESTOGA', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7081, '17517', '+40.188445', '-076.337734', 'DENVER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7082, '17518', '+39.818309', '-076.249931', 'DRUMORE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7083, '17519', '+40.142759', '-076.019741', 'EAST EARL', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7084, '17520', '+40.097468', '-076.356832', 'EAST PETERSBURG', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7085, '17521', '+40.204393', '-076.346430', 'ELM', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7086, '17522', '+40.169662', '-076.356933', 'EPHRATA', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7087, '17527', '+40.011961', '-076.021595', 'GAP', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7088, '17528', '+40.043523', '-076.238766', 'GOODVILLE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7089, '17529', '+40.043967', '-076.108543', 'GORDONVILLE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7090, '17532', '+39.866320', '-076.280620', 'HOLTWOOD', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7091, '17533', '+40.233892', '-076.260725', 'HOPELAND', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7092, '17534', '+40.036659', '-076.106902', 'INTERCOURSE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7093, '17535', '+40.005276', '-076.042921', 'KINZERS', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7094, '17536', '+39.842724', '-076.080469', 'KIRKWOOD', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7095, '17537', '+39.988548', '-076.238729', 'LAMPETER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7096, '17538', '+40.112477', '-076.360890', 'LANDISVILLE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7097, '17540', '+40.100846', '-076.191873', 'LEOLA', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7098, '17543', '+40.134761', '-076.455212', 'LITITZ', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7099, '17545', '+40.155927', '-076.464018', 'MANHEIM', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7100, '17547', '+40.061596', '-076.485935', 'MARIETTA', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7101, '17549', '+40.154498', '-076.087560', 'MARTINDALE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7102, '17550', '+40.072108', '-076.577790', 'MAYTOWN', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7103, '17551', '+40.031882', '-076.236823', 'MILLERSVILLE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7104, '17552', '+40.113745', '-076.354000', 'MOUNT JOY', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7105, '17554', '+40.038842', '-076.425978', 'MOUNTVILLE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7106, '17555', '+40.120279', '-075.961183', 'NARVON', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7107, '17557', '+40.146070', '-076.073814', 'NEW HOLLAND', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7108, '17560', '+39.912288', '-076.237428', 'NEW PROVIDENCE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7109, '17562', '+39.898072', '-076.091234', 'PARADISE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7110, '17563', '+39.844788', '-076.155069', 'PEACH BOTTOM', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7111, '17564', '+40.018500', '-076.297582', 'PENRYN', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7112, '17565', '+39.904409', '-076.322481', 'PEQUEA', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7113, '17566', '+39.856368', '-076.148506', 'QUARRYVILLE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7114, '17567', '+40.209941', '-076.116445', 'REAMSTOWN', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7115, '17568', '+39.946900', '-076.232229', 'REFTON', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7116, '17569', '+40.152713', '-076.091179', 'REINHOLDS', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7117, '17570', '+40.129645', '-076.571739', 'RHEEMS', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7118, '17572', '+40.015026', '-076.149994', 'RONKS', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7119, '17573', '+40.018500', '-076.297582', 'RONKS', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'UNIQUE'),
(7120, '17575', '+40.064746', '-076.434285', 'SILVER SPRING', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7121, '17576', '+40.036398', '-076.203069', 'SMOKETOWN', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7122, '17577', '+40.018500', '-076.297582', 'SOUDERSBURG', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7123, '17578', '+40.168624', '-076.330001', 'STEVENS', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7124, '17579', '+40.082226', '-076.113772', 'STRASBURG', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7125, '17580', '+40.116846', '-076.213075', 'TALMAGE', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7126, '17581', '+40.157576', '-076.046317', 'TERRE HILL', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7127, '17582', '+39.990664', '-076.434850', 'WASHINGTON BORO', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7128, '17583', '+39.972349', '-076.287330', 'WEST WILLOW', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7129, '17584', '+39.959349', '-076.259779', 'WILLOW STREET', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7130, '17585', '+40.048398', '-076.211427', 'WITMER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7131, '17601', '+40.076553', '-076.310680', 'LANCASTER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7132, '17602', '+40.004048', '-076.249829', 'LANCASTER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7133, '17603', '+40.009147', '-076.367132', 'LANCASTER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7134, '17604', '+40.065096', '-076.335631', 'LANCASTER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7135, '17605', '+40.018500', '-076.297582', 'LANCASTER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7136, '17606', '+40.110201', '-076.305378', 'LANCASTER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7137, '17607', '+40.018500', '-076.297582', 'LANCASTER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7138, '17608', '+40.018500', '-076.297582', 'LANCASTER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'STANDARD'),
(7139, '17699', '+40.018500', '-076.297582', 'LANCASTER', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'UNIQUE'),
(7140, '17701', '+41.266716', '-076.958314', 'WILLIAMSPORT', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7141, '17702', '+41.194306', '-077.054665', 'WILLIAMSPORT', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7142, '17703', '+41.332750', '-077.023601', 'WILLIAMSPORT', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7143, '17705', '+41.332750', '-077.023601', 'WILLIAMSPORT', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'UNIQUE'),
(7144, '17720', '+41.186545', '-077.218368', 'ANTES FORT', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'PO BOX ONLY'),
(7145, '17721', '+41.186028', '-077.316191', 'AVIS', 'PA', 'PENNSYLVANIA', 'CLINTON', 'PO BOX ONLY'),
(7146, '17722', '+41.332750', '-077.023601', 'BODINES', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7147, '17723', '+41.332750', '-077.023601', 'JERSEY SHORE', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7148, '17724', '+41.639449', '-076.841430', 'CANTON', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7149, '17726', '+41.122741', '-077.431745', 'CASTANEA', 'PA', 'PENNSYLVANIA', 'CLINTON', 'PO BOX ONLY'),
(7150, '17727', '+41.332750', '-077.023601', 'CEDAR RUN', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7151, '17728', '+41.255299', '-076.948034', 'COGAN STATION', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7152, '17729', '+41.737627', '-077.902366', 'CROSS FORK', 'PA', 'PENNSYLVANIA', 'POTTER', 'STANDARD'),
(7153, '17730', '+41.108910', '-076.877491', 'DEWART', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'PO BOX ONLY'),
(7154, '17731', '+41.432901', '-076.516887', 'EAGLES MERE', 'PA', 'PENNSYLVANIA', 'SULLIVAN', 'PO BOX ONLY'),
(7155, '17735', '+41.771970', '-076.521266', 'GROVER', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'PO BOX ONLY'),
(7156, '17737', '+41.280128', '-076.675300', 'HUGHESVILLE', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7157, '17738', '+41.220635', '-077.618532', 'HYNER', 'PA', 'PENNSYLVANIA', 'CLINTON', 'STANDARD'),
(7158, '17739', '+41.332750', '-077.023601', 'JERSEY MILLS', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'PO BOX ONLY'),
(7159, '17740', '+41.208518', '-077.025687', 'JERSEY SHORE', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7160, '17742', '+41.229734', '-076.594727', 'LAIRDSVILLE', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7161, '17743', '+41.771970', '-076.521266', 'LEROY', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7162, '17744', '+41.251994', '-077.161674', 'LINDEN', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7163, '17745', '+41.229022', '-077.641745', 'LOCK HAVEN', 'PA', 'PENNSYLVANIA', 'CLINTON', 'STANDARD'),
(7164, '17747', '+41.018519', '-077.341611', 'LOGANTON', 'PA', 'PENNSYLVANIA', 'CLINTON', 'STANDARD'),
(7165, '17748', '+41.135507', '-077.369964', 'MC ELHATTAN', 'PA', 'PENNSYLVANIA', 'CLINTON', 'PO BOX ONLY'),
(7166, '17749', '+41.071982', '-076.818381', 'MC EWENSVILLE', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'PO BOX ONLY'),
(7167, '17750', '+41.032529', '-077.495147', 'MACKEYVILLE', 'PA', 'PENNSYLVANIA', 'CLINTON', 'PO BOX ONLY'),
(7168, '17751', '+41.071123', '-077.476304', 'MILL HALL', 'PA', 'PENNSYLVANIA', 'CLINTON', 'STANDARD'),
(7169, '17752', '+41.214561', '-076.856502', 'MONTGOMERY', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7170, '17754', '+41.307308', '-076.881055', 'MONTOURSVILLE', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7171, '17756', '+41.244348', '-076.740480', 'MUNCY', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7172, '17758', '+41.432901', '-076.516887', 'MUNCY VALLEY', 'PA', 'PENNSYLVANIA', 'SULLIVAN', 'STANDARD'),
(7173, '17759', '+41.218259', '-077.121370', 'NISBET', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'PO BOX ONLY'),
(7174, '17760', '+41.220635', '-077.618532', 'NORTH BEND', 'PA', 'PENNSYLVANIA', 'CLINTON', 'STANDARD'),
(7175, '17762', '+41.221474', '-076.659535', 'PICTURE ROCKS', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'PO BOX ONLY'),
(7176, '17763', '+41.498523', '-076.946724', 'RALSTON', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'PO BOX ONLY'),
(7177, '17764', '+41.306045', '-077.571221', 'RENOVO', 'PA', 'PENNSYLVANIA', 'CLINTON', 'STANDARD'),
(7178, '17765', '+41.771970', '-077.242228', 'ROARING BRANCH', 'PA', 'PENNSYLVANIA', 'TIOGA', 'STANDARD'),
(7179, '17767', '+41.220635', '-077.618532', 'SALONA', 'PA', 'PENNSYLVANIA', 'CLINTON', 'STANDARD'),
(7180, '17768', '+41.432901', '-076.516887', 'SHUNK', 'PA', 'PENNSYLVANIA', 'SULLIVAN', 'STANDARD'),
(7181, '17769', '+41.332750', '-077.023601', 'SLATE RUN', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'PO BOX ONLY'),
(7182, '17771', '+41.438766', '-077.061380', 'TROUT RUN', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7183, '17772', '+41.102850', '-076.823084', 'TURBOTVILLE', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7184, '17773', '+41.220635', '-077.618532', 'TYLERSVILLE', 'PA', 'PENNSYLVANIA', 'CLINTON', 'PO BOX ONLY'),
(7185, '17774', '+41.227207', '-076.646221', 'UNITYVILLE', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7186, '17776', '+41.378570', '-077.331293', 'WATERVILLE', 'PA', 'PENNSYLVANIA', 'LYCOMING', 'STANDARD'),
(7187, '17777', '+41.097981', '-076.850306', 'WATSONTOWN', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7188, '17778', '+41.270789', '-077.969664', 'WESTPORT', 'PA', 'PENNSYLVANIA', 'CLINTON', 'STANDARD'),
(7189, '17779', '+41.187424', '-077.372827', 'WOOLRICH', 'PA', 'PENNSYLVANIA', 'CLINTON', 'PO BOX ONLY'),
(7190, '17801', '+40.869766', '-076.735577', 'SUNBURY', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7191, '17810', '+40.978059', '-077.081840', 'ALLENWOOD', 'PA', 'PENNSYLVANIA', 'UNION', 'STANDARD'),
(7192, '17812', '+40.726469', '-077.272828', 'BEAVER SPRINGS', 'PA', 'PENNSYLVANIA', 'SNYDER', 'STANDARD'),
(7193, '17813', '+40.754705', '-077.169508', 'BEAVERTOWN', 'PA', 'PENNSYLVANIA', 'SNYDER', 'STANDARD'),
(7194, '17814', '+41.218998', '-076.395426', 'BENTON', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'STANDARD'),
(7195, '17815', '+41.005609', '-076.430563', 'BLOOMSBURG', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'STANDARD'),
(7196, '17820', '+41.020674', '-076.436239', 'CATAWISSA', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'STANDARD'),
(7197, '17821', '+40.991968', '-076.647082', 'DANVILLE', 'PA', 'PENNSYLVANIA', 'MONTOUR', 'STANDARD'),
(7198, '17822', '+40.967437', '-076.604896', 'DANVILLE', 'PA', 'PENNSYLVANIA', 'MONTOUR', 'UNIQUE'),
(7199, '17823', '+40.889632', '-076.664574', 'DORNSIFE', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7200, '17824', '+40.859435', '-076.550811', 'ELYSBURG', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7201, '17825', '+40.889632', '-076.664574', 'EXCELSIOR', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7202, '17827', '+40.765049', '-076.939544', 'FREEBURG', 'PA', 'PENNSYLVANIA', 'SNYDER', 'STANDARD'),
(7203, '17828', '+40.889632', '-076.664574', 'GOWEN CITY', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'PO BOX ONLY'),
(7204, '17829', '+40.882861', '-077.189174', 'HARTLETON', 'PA', 'PENNSYLVANIA', 'UNION', 'PO BOX ONLY'),
(7205, '17830', '+40.889632', '-076.664574', 'HERNDON', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7206, '17831', '+40.834408', '-076.835439', 'HUMMELS WHARF', 'PA', 'PENNSYLVANIA', 'SNYDER', 'PO BOX ONLY'),
(7207, '17832', '+40.805096', '-076.464607', 'MARION HEIGHTS', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'PO BOX ONLY'),
(7208, '17833', '+40.762675', '-077.077520', 'KREAMER', 'PA', 'PENNSYLVANIA', 'SNYDER', 'PO BOX ONLY'),
(7209, '17834', '+40.793938', '-076.476946', 'KULPMONT', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7210, '17835', '+40.978059', '-077.081840', 'LAURELTON', 'PA', 'PENNSYLVANIA', 'UNION', 'PO BOX ONLY'),
(7211, '17836', '+40.889632', '-076.664574', 'LECK KILL', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7212, '17837', '+40.969642', '-076.948072', 'LEWISBURG', 'PA', 'PENNSYLVANIA', 'UNION', 'STANDARD'),
(7213, '17839', '+41.020062', '-076.438413', 'LIGHT STREET', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'STANDARD'),
(7214, '17840', '+40.772687', '-076.438311', 'LOCUST GAP', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'PO BOX ONLY'),
(7215, '17841', '+40.766765', '-077.150271', 'MC CLURE', 'PA', 'PENNSYLVANIA', 'SNYDER', 'STANDARD'),
(7216, '17842', '+40.779808', '-077.117558', 'MIDDLEBURG', 'PA', 'PENNSYLVANIA', 'SNYDER', 'STANDARD'),
(7217, '17843', '+40.762675', '-077.077520', 'BEAVER SPRINGS', 'PA', 'PENNSYLVANIA', 'SNYDER', 'STANDARD'),
(7218, '17844', '+40.947833', '-077.011087', 'MIFFLINBURG', 'PA', 'PENNSYLVANIA', 'UNION', 'STANDARD'),
(7219, '17845', '+40.978059', '-077.081840', 'MILLMONT', 'PA', 'PENNSYLVANIA', 'UNION', 'STANDARD'),
(7220, '17846', '+41.143816', '-076.525177', 'MILLVILLE', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'STANDARD'),
(7221, '17847', '+40.993883', '-076.847896', 'MILTON', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7222, '17850', '+40.889632', '-076.664574', 'MONTANDON', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'PO BOX ONLY'),
(7223, '17851', '+40.803636', '-076.428612', 'MOUNT CARMEL', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7224, '17853', '+40.723706', '-077.013547', 'MOUNT PLEASANT MILLS', 'PA', 'PENNSYLVANIA', 'SNYDER', 'STANDARD'),
(7225, '17855', '+40.882689', '-076.984667', 'NEW BERLIN', 'PA', 'PENNSYLVANIA', 'UNION', 'STANDARD'),
(7226, '17856', '+41.048043', '-076.903895', 'NEW COLUMBIA', 'PA', 'PENNSYLVANIA', 'UNION', 'STANDARD'),
(7227, '17857', '+40.908050', '-076.784197', 'NORTHUMBERLAND', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7228, '17858', '+41.042106', '-076.424297', 'NUMIDIA', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'PO BOX ONLY'),
(7229, '17859', '+41.061483', '-076.418093', 'ORANGEVILLE', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'STANDARD'),
(7230, '17860', '+40.889632', '-076.664574', 'PAXINOS', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7231, '17861', '+40.762675', '-077.077520', 'PAXTONVILLE', 'PA', 'PENNSYLVANIA', 'SNYDER', 'PO BOX ONLY'),
(7232, '17862', '+40.857426', '-077.064941', 'PENNS CREEK', 'PA', 'PENNSYLVANIA', 'SNYDER', 'PO BOX ONLY'),
(7233, '17864', '+40.695087', '-076.903957', 'PORT TREVORTON', 'PA', 'PENNSYLVANIA', 'SNYDER', 'STANDARD'),
(7234, '17865', '+40.889632', '-076.664574', 'POTTS GROVE', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'PO BOX ONLY'),
(7235, '17866', '+40.791688', '-076.551871', 'COAL TOWNSHIP', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7236, '17867', '+40.889632', '-076.664574', 'REBUCK', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7237, '17868', '+40.952908', '-076.631118', 'RIVERSIDE', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'PO BOX ONLY'),
(7238, '17870', '+40.825914', '-076.857577', 'SELINSGROVE', 'PA', 'PENNSYLVANIA', 'SNYDER', 'STANDARD'),
(7239, '17872', '+40.791953', '-076.601592', 'SHAMOKIN', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7240, '17876', '+40.845896', '-076.822410', 'SHAMOKIN DAM', 'PA', 'PENNSYLVANIA', 'SNYDER', 'PO BOX ONLY'),
(7241, '17877', '+40.878970', '-076.667267', 'SNYDERTOWN', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7242, '17878', '+41.120644', '-076.412386', 'STILLWATER', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'STANDARD'),
(7243, '17880', '+40.978059', '-077.081840', 'SWENGEL', 'PA', 'PENNSYLVANIA', 'UNION', 'PO BOX ONLY'),
(7244, '17881', '+40.782155', '-076.672737', 'TREVORTON', 'PA', 'PENNSYLVANIA', 'NORTHUMBERLAND', 'STANDARD'),
(7245, '17882', '+40.762675', '-077.077520', 'TROXELVILLE', 'PA', 'PENNSYLVANIA', 'SNYDER', 'PO BOX ONLY'),
(7246, '17883', '+40.978059', '-077.081840', 'VICKSBURG', 'PA', 'PENNSYLVANIA', 'UNION', 'PO BOX ONLY'),
(7247, '17884', '+41.027277', '-076.653633', 'WASHINGTONVILLE', 'PA', 'PENNSYLVANIA', 'MONTOUR', 'PO BOX ONLY'),
(7248, '17885', '+40.978059', '-077.081840', 'WEIKERT', 'PA', 'PENNSYLVANIA', 'UNION', 'PO BOX ONLY'),
(7249, '17886', '+41.017890', '-076.870841', 'WEST MILTON', 'PA', 'PENNSYLVANIA', 'UNION', 'STANDARD'),
(7250, '17887', '+40.978059', '-077.081840', 'WHITE DEER', 'PA', 'PENNSYLVANIA', 'UNION', 'PO BOX ONLY'),
(7251, '17888', '+40.815401', '-076.368632', 'WILBURTON', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'STANDARD'),
(7252, '17889', '+40.905947', '-076.859662', 'WINFIELD', 'PA', 'PENNSYLVANIA', 'UNION', 'STANDARD'),
(7253, '17901', '+40.708751', '-076.282986', 'POTTSVILLE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7254, '17920', '+40.816696', '-076.350279', 'ARISTES', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'PO BOX ONLY'),
(7255, '17921', '+40.692886', '-076.303085', 'ASHLAND', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7256, '17922', '+40.597820', '-076.149320', 'AUBURN', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7257, '17923', '+40.676020', '-076.316013', 'BRANCHDALE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7258, '17925', '+40.750796', '-076.062859', 'BROCKTON', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7259, '17927', '+40.804881', '-076.341156', 'CENTRALIA', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'STANDARD'),
(7260, '17929', '+40.675475', '-076.165297', 'CRESSONA', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7261, '17930', '+40.711356', '-076.139162', 'CUMBOLA', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7262, '17931', '+40.692869', '-076.348699', 'FRACKVILLE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7263, '17932', '+40.649109', '-076.503339', 'FRACKVILLE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'UNIQUE'),
(7264, '17933', '+40.595462', '-076.246441', 'FRIEDENSBURG', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7265, '17934', '+40.798623', '-076.215530', 'GILBERTON', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7266, '17935', '+40.795384', '-076.270574', 'GIRARDVILLE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7267, '17936', '+40.748879', '-076.335499', 'GORDON', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7268, '17938', '+40.688219', '-076.539205', 'HEGINS', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7269, '17941', '+40.687178', '-076.578173', 'KLINGERSTOWN', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7270, '17942', '+40.722587', '-076.229623', 'LANDINGVILLE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7271, '17943', '+40.761438', '-076.387242', 'LAVELLE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7272, '17944', '+40.675780', '-076.281900', 'LLEWELLYN', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7273, '17945', '+40.774531', '-076.370427', 'LOCUSTDALE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7274, '17946', '+40.808081', '-076.240747', 'LOST CREEK', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7275, '17948', '+40.733004', '-076.306129', 'MAHANOY CITY', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7276, '17949', '+40.794007', '-076.243323', 'MAHANOY PLANE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7277, '17951', '+40.682985', '-076.238725', 'MAR LIN', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7278, '17952', '+40.747301', '-076.062825', 'MARY D', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7279, '17953', '+40.733072', '-076.085783', 'MIDDLEPORT', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7280, '17954', '+40.711461', '-076.199621', 'MINERSVILLE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7281, '17957', '+40.592578', '-076.516075', 'MUIR', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7282, '17959', '+40.675413', '-076.155786', 'NEW PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7283, '17960', '+40.703416', '-075.959812', 'NEW RINGGOLD', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7284, '17961', '+40.618065', '-076.206854', 'ORWIGSBURG', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7285, '17963', '+40.577029', '-076.337160', 'PINE GROVE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7286, '17964', '+40.724376', '-076.488833', 'PITMAN', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7287, '17965', '+40.771333', '-076.199259', 'PORT CARBON', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7288, '17966', '+40.722587', '-076.229623', 'RAVINE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7289, '17967', '+40.856227', '-076.234640', 'RINGTOWN', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7290, '17968', '+40.636539', '-076.591109', 'SACRAMENTO', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7291, '17970', '+40.707055', '-076.284374', 'SAINT CLAIR', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7292, '17972', '+40.602048', '-076.154856', 'SCHUYLKILL HAVEN', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7293, '17974', '+40.690632', '-076.227294', 'SELTZER', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7294, '17976', '+40.763239', '-076.148397', 'SHENANDOAH', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7295, '17978', '+40.625754', '-076.621769', 'SPRING GLEN', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7296, '17979', '+40.554516', '-076.203767', 'SUMMIT STATION', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7297, '17980', '+40.590428', '-076.539810', 'TOWER CITY', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7298, '17981', '+40.694624', '-076.306539', 'TREMONT', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7299, '17982', '+40.781484', '-076.013399', 'TUSCARORA', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7300, '17983', '+40.645911', '-076.532384', 'VALLEY VIEW', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7301, '17985', '+40.914137', '-076.193099', 'ZION GROVE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7302, '18001', '+40.693376', '-075.471156', 'LEHIGH VALLEY', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(7303, '18002', '+40.665597', '-075.426247', 'LEHIGH VALLEY', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(7304, '18003', '+40.693376', '-075.471156', 'LEHIGH VALLEY', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'UNIQUE'),
(7305, '18010', '+40.693376', '-075.471156', 'ACKERMANVILLE', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7306, '18011', '+40.514472', '-075.602941', 'ALBURTIS', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7307, '18012', '+40.813281', '-075.592020', 'AQUASHICOLA', 'PA', 'PENNSYLVANIA', 'CARBON', 'PO BOX ONLY'),
(7308, '18013', '+40.766465', '-075.315246', 'BANGOR', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7309, '18014', '+40.733142', '-075.351785', 'BATH', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7310, '18015', '+40.588830', '-075.351958', 'BETHLEHEM', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7311, '18016', '+40.693376', '-075.471156', 'BETHLEHEM', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7312, '18017', '+40.662211', '-075.390270', 'BETHLEHEM', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7313, '18018', '+40.625297', '-075.379174', 'BETHLEHEM', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7314, '18020', '+40.669251', '-075.334887', 'BETHLEHEM', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7315, '18025', '+40.693376', '-075.471156', 'BETHLEHEM', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'UNIQUE'),
(7316, '18030', '+40.801062', '-075.661425', 'BOWMANSTOWN', 'PA', 'PENNSYLVANIA', 'CARBON', 'PO BOX ONLY'),
(7317, '18031', '+40.550733', '-075.540673', 'BREINIGSVILLE', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7318, '18032', '+40.602633', '-075.472276', 'CATASAUQUA', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7319, '18034', '+40.543998', '-075.412420', 'CENTER VALLEY', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7320, '18035', '+40.750996', '-075.539370', 'CHERRYVILLE', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7321, '18036', '+40.502424', '-075.411145', 'COOPERSBURG', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7322, '18037', '+40.616645', '-075.489587', 'COPLAY', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7323, '18038', '+40.790710', '-075.482967', 'DANIELSVILLE', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7324, '18039', '+40.328645', '-075.102780', 'DURHAM', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7325, '18040', '+40.806206', '-075.208870', 'EASTON', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7326, '18041', '+40.382488', '-075.515410', 'EAST GREENVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7327, '18042', '+40.683198', '-075.264861', 'EASTON', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7328, '18043', '+40.792804', '-075.137186', 'EASTON', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7329, '18044', '+40.693376', '-075.471156', 'EASTON', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7330, '18045', '+40.695731', '-075.286528', 'EASTON', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7331, '18046', '+40.538843', '-075.568502', 'EAST TEXAS', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'PO BOX ONLY'),
(7332, '18049', '+40.520705', '-075.496131', 'EMMAUS', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7333, '18050', '+40.693376', '-075.471156', 'FLICKSVILLE', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7334, '18051', '+40.599843', '-075.663187', 'FOGELSVILLE', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7335, '18052', '+40.656746', '-075.504128', 'WHITEHALL', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7336, '18053', '+40.718662', '-075.700739', 'GERMANSVILLE', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7337, '18054', '+40.289663', '-075.450703', 'GREEN LANE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7338, '18055', '+40.588799', '-075.313756', 'HELLERTOWN', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7339, '18056', '+40.454205', '-075.581444', 'HEREFORD', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(7340, '18058', '+40.903599', '-075.476885', 'KUNKLETOWN', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7341, '18059', '+40.717684', '-075.533488', 'LAURYS STATION', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7342, '18060', '+40.534840', '-075.578640', 'LIMEPORT', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'PO BOX ONLY'),
(7343, '18062', '+40.517851', '-075.565028', 'MACUNGIE', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7344, '18063', '+40.782456', '-075.173494', 'MARTINS CREEK', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(7345, '18064', '+40.737648', '-075.272892', 'NAZARETH', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7346, '18065', '+40.696738', '-075.611647', 'NEFFS', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'PO BOX ONLY'),
(7347, '18066', '+40.652611', '-075.759361', 'NEW TRIPOLI', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7348, '18067', '+40.724479', '-075.365412', 'NORTHAMPTON', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7349, '18068', '+40.693376', '-075.471156', 'OLD ZIONSVILLE', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'PO BOX ONLY'),
(7350, '18069', '+40.629605', '-075.621885', 'OREFIELD', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7351, '18070', '+40.430181', '-075.531182', 'PALM', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7352, '18071', '+40.855728', '-075.589180', 'PALMERTON', 'PA', 'PENNSYLVANIA', 'CARBON', 'STANDARD'),
(7353, '18072', '+40.841099', '-075.258376', 'PEN ARGYL', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7354, '18073', '+40.374347', '-075.482175', 'PENNSBURG', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7355, '18074', '+40.320832', '-075.500492', 'PERKIOMENVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7356, '18076', '+40.387419', '-075.505547', 'RED HILL', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7357, '18077', '+40.567316', '-075.236191', 'RIEGELSVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7358, '18078', '+40.669675', '-075.620901', 'SCHNECKSVILLE', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7359, '18079', '+40.745524', '-075.659209', 'SLATEDALE', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'PO BOX ONLY'),
(7360, '18080', '+40.734537', '-075.618611', 'SLATINGTON', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7361, '18081', '+40.328645', '-075.102780', 'SPRINGTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7362, '18083', '+40.772873', '-075.363531', 'STOCKERTOWN', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(7363, '18084', '+40.327782', '-075.454043', 'SUMNEYTOWN', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7364, '18085', '+40.740625', '-075.254854', 'TATAMY', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(7365, '18086', '+40.736119', '-075.544940', 'TREICHLERS', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(7366, '18087', '+40.548196', '-075.596131', 'TREXLERTOWN', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7367, '18088', '+40.759591', '-075.428538', 'WALNUTPORT', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7368, '18091', '+40.801131', '-075.310958', 'WIND GAP', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7369, '18092', '+40.467193', '-075.512091', 'ZIONSVILLE', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7370, '18098', '+40.693376', '-075.471156', 'EMMAUS', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'UNIQUE'),
(7371, '18099', '+40.693376', '-075.471156', 'EMMAUS', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'UNIQUE'),
(7372, '18101', '+40.607497', '-075.470026', 'ALLENTOWN', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7373, '18102', '+40.607006', '-075.480877', 'ALLENTOWN', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7374, '18103', '+40.604372', '-075.473127', 'ALLENTOWN', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7375, '18104', '+40.621048', '-075.545306', 'ALLENTOWN', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7376, '18105', '+40.693376', '-075.471156', 'ALLENTOWN', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7377, '18106', '+40.582381', '-075.591132', 'ALLENTOWN', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7378, '18109', '+40.693376', '-075.471156', 'ALLENTOWN', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7379, '18175', '+40.585561', '-075.621058', 'ALLENTOWN', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'UNIQUE'),
(7380, '18195', '+40.579830', '-075.579884', 'ALLENTOWN', 'PA', 'PENNSYLVANIA', 'LEHIGH', 'STANDARD'),
(7381, '18201', '+40.964584', '-076.008333', 'HAZLETON', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7382, '18202', '', '', 'HAZLETON', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7383, '18210', '+41.012618', '-075.560751', 'ALBRIGHTSVILLE', 'PA', 'PENNSYLVANIA', 'CARBON', 'STANDARD'),
(7384, '18211', '+40.744932', '-075.831550', 'ANDREAS', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7385, '18212', '+40.784095', '-075.708281', 'ASHFIELD', 'PA', 'PENNSYLVANIA', 'CARBON', 'PO BOX ONLY'),
(7386, '18214', '+40.808680', '-076.036009', 'BARNESVILLE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7387, '18216', '+40.932217', '-075.919196', 'BEAVER MEADOWS', 'PA', 'PENNSYLVANIA', 'CARBON', 'STANDARD'),
(7388, '18218', '+40.858951', '-076.013009', 'COALDALE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7389, '18219', '+40.990662', '-076.056358', 'CONYNGHAM', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7390, '18220', '+40.838915', '-076.069416', 'DELANO', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7391, '18221', '+41.001634', '-075.905693', 'DRIFTON', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7392, '18222', '+41.034017', '-076.003059', 'DRUMS', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7393, '18223', '+41.272248', '-075.880146', 'EBERVALE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7394, '18224', '+41.019593', '-075.881697', 'FREELAND', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7395, '18225', '+40.988813', '-075.961651', 'HARLEIGH', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7396, '18229', '+40.896709', '-075.759303', 'JIM THORPE', 'PA', 'PENNSYLVANIA', 'CARBON', 'STANDARD'),
(7397, '18230', '+40.934763', '-075.735770', 'JUNEDALE', 'PA', 'PENNSYLVANIA', 'CARBON', 'PO BOX ONLY'),
(7398, '18231', '+40.900231', '-076.005382', 'KELAYRES', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7399, '18232', '+40.872243', '-075.915416', 'LANSFORD', 'PA', 'PENNSYLVANIA', 'CARBON', 'STANDARD'),
(7400, '18234', '+40.992517', '-075.962585', 'LATTIMER MINES', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7401, '18235', '+40.886664', '-075.736164', 'LEHIGHTON', 'PA', 'PENNSYLVANIA', 'CARBON', 'STANDARD'),
(7402, '18237', '+40.897645', '-075.997791', 'MCADOO', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7403, '18239', '+40.996051', '-075.981475', 'MILNESVILLE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7404, '18240', '+40.933194', '-075.763830', 'NESQUEHONING', 'PA', 'PENNSYLVANIA', 'CARBON', 'STANDARD'),
(7405, '18241', '+40.922289', '-076.148940', 'NUREMBERG', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7406, '18242', '+40.910952', '-076.122324', 'ONEIDA', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7407, '18243', '+41.001683', '-075.966146', 'PARDEESVILLE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7408, '18244', '+40.824546', '-075.665068', 'PARRYVILLE', 'PA', 'PENNSYLVANIA', 'CARBON', 'PO BOX ONLY'),
(7409, '18245', '+40.722587', '-076.229623', 'QUAKAKE', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7410, '18246', '+40.954011', '-076.174707', 'ROCK GLEN', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7411, '18247', '+41.014808', '-076.058391', 'SAINT JOHNS', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7412, '18248', '+40.901977', '-076.118764', 'SHEPPTON', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(7413, '18249', '+40.975202', '-076.084500', 'SUGARLOAF', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7414, '18250', '+40.905370', '-075.741560', 'SUMMIT HILL', 'PA', 'PENNSYLVANIA', 'CARBON', 'STANDARD'),
(7415, '18251', '+41.272248', '-075.880146', 'SYBERTSVILLE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7416, '18252', '+40.798490', '-075.937836', 'TAMAQUA', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'STANDARD'),
(7417, '18254', '+40.924803', '-075.938611', 'TRESCKOW', 'PA', 'PENNSYLVANIA', 'CARBON', 'PO BOX ONLY'),
(7418, '18255', '+40.911443', '-075.779007', 'WEATHERLY', 'PA', 'PENNSYLVANIA', 'CARBON', 'STANDARD'),
(7419, '18256', '+40.944777', '-076.145197', 'WESTON', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7420, '18301', '+41.089642', '-075.199705', 'EAST STROUDSBURG', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7421, '18320', '+41.071213', '-075.236436', 'ANALOMINK', 'PA', 'PENNSYLVANIA', 'MONROE', 'PO BOX ONLY'),
(7422, '18321', '+41.079679', '-075.319542', 'BARTONSVILLE', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7423, '18322', '+41.054711', '-075.331879', 'BRODHEADSVILLE', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7424, '18323', '+41.033755', '-075.307980', 'BUCK HILL FALLS', 'PA', 'PENNSYLVANIA', 'MONROE', 'PO BOX ONLY'),
(7425, '18324', '+41.185011', '-074.978890', 'BUSHKILL', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7426, '18325', '+41.187023', '-075.285930', 'CANADENSIS', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7427, '18326', '+41.152364', '-075.276395', 'CRESCO', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7428, '18327', '+40.988562', '-075.151193', 'DELAWARE WATER GAP', 'PA', 'PENNSYLVANIA', 'MONROE', 'PO BOX ONLY'),
(7429, '18328', '+41.229482', '-074.967407', 'DINGMANS FERRY', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7430, '18330', '+41.033192', '-075.449047', 'EFFORT', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7431, '18331', '+40.947398', '-075.366015', 'GILBERT', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7432, '18332', '+41.025342', '-075.323738', 'HENRYVILLE', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7433, '18333', '+40.951580', '-075.501306', 'KRESGEVILLE', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7434, '18334', '+41.057236', '-075.465137', 'LONG POND', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7435, '18335', '+41.050764', '-075.208269', 'MARSHALLS CREEK', 'PA', 'PENNSYLVANIA', 'MONROE', 'PO BOX ONLY'),
(7436, '18336', '+41.370358', '-074.736057', 'MATAMORAS', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7437, '18337', '+41.320051', '-074.880639', 'MILFORD', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7438, '18340', '+41.413707', '-074.751138', 'MILLRIFT', 'PA', 'PENNSYLVANIA', 'PIKE', 'PO BOX ONLY'),
(7439, '18341', '+40.991053', '-075.299256', 'MINISINK HILLS', 'PA', 'PENNSYLVANIA', 'MONROE', 'PO BOX ONLY'),
(7440, '18342', '+41.145778', '-075.294125', 'MOUNTAINHOME', 'PA', 'PENNSYLVANIA', 'MONROE', 'PO BOX ONLY'),
(7441, '18343', '+40.898617', '-075.104575', 'MOUNT BETHEL', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'STANDARD'),
(7442, '18344', '+41.136268', '-075.370920', 'MOUNT POCONO', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7443, '18346', '+41.094926', '-075.298177', 'POCONO SUMMIT', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7444, '18347', '+41.138560', '-075.562988', 'POCONO LAKE', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7445, '18348', '+41.033755', '-075.307980', 'POCONO LAKE PRESERVE', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7446, '18349', '+41.122633', '-075.458820', 'POCONO MANOR', 'PA', 'PENNSYLVANIA', 'MONROE', 'PO BOX ONLY'),
(7447, '18350', '+41.083557', '-075.515614', 'POCONO PINES', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7448, '18351', '+40.921386', '-075.097007', 'PORTLAND', 'PA', 'PENNSYLVANIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(7449, '18352', '+40.986265', '-075.348026', 'REEDERS', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7450, '18353', '+41.011645', '-075.254722', 'SAYLORSBURG', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7451, '18354', '+40.937939', '-075.292615', 'SCIOTA', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7452, '18355', '+41.090045', '-075.357801', 'SCOTRUN', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7453, '18356', '+41.031177', '-075.097435', 'SHAWNEE ON DELAWARE', 'PA', 'PENNSYLVANIA', 'MONROE', 'PO BOX ONLY'),
(7454, '18357', '+41.233562', '-075.238879', 'SKYTOP', 'PA', 'PENNSYLVANIA', 'MONROE', 'PO BOX ONLY'),
(7455, '18360', '+41.041895', '-075.368964', 'STROUDSBURG', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7456, '18370', '+41.105903', '-075.346913', 'SWIFTWATER', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7457, '18371', '+41.340936', '-075.024055', 'TAMIMENT', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7458, '18372', '+41.095823', '-075.323654', 'TANNERSVILLE', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7459, '18373', '+41.340936', '-075.024055', 'UNITY HOUSE', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7460, '18401', '+41.615989', '-075.274708', 'ALDENVILLE', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7461, '18403', '+41.487598', '-075.533403', 'ARCHBALD', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7462, '18405', '+41.582471', '-075.130121', 'BEACH LAKE', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7463, '18407', '+41.583122', '-075.505612', 'CARBONDALE', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7464, '18410', '+41.486527', '-075.693335', 'CHINCHILLA', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'PO BOX ONLY'),
(7465, '18411', '+41.463694', '-075.681992', 'CLARKS SUMMIT', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7466, '18413', '+41.654319', '-075.614463', 'CLIFFORD', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'PO BOX ONLY'),
(7467, '18414', '+41.539797', '-075.719723', 'DALTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7468, '18415', '+41.701677', '-075.133727', 'DAMASCUS', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7469, '18416', '+41.375602', '-075.547966', 'ELMHURST', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'PO BOX ONLY'),
(7470, '18417', '+41.797309', '-075.206086', 'EQUINUNK', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7471, '18419', '+41.562365', '-075.782573', 'FACTORYVILLE', 'PA', 'PENNSYLVANIA', 'WYOMING', 'STANDARD'),
(7472, '18420', '+41.401881', '-075.637626', 'FLEETVILLE', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'PO BOX ONLY'),
(7473, '18421', '+41.652272', '-075.531325', 'FOREST CITY', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7474, '18424', '+41.346095', '-075.331956', 'GOULDSBORO', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7475, '18425', '+41.415940', '-075.022543', 'GREELEY', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7476, '18426', '+41.320734', '-075.199395', 'GREENTOWN', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7477, '18427', '+41.422497', '-075.335384', 'HAMLIN', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7478, '18428', '+41.482733', '-075.240190', 'HAWLEY', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7479, '18430', '+41.820346', '-075.804630', 'HERRICK CENTER', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7480, '18431', '+41.564258', '-075.265643', 'HONESDALE', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7481, '18433', '+41.561174', '-075.618764', 'JERMYN', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7482, '18434', '+41.504326', '-075.572238', 'JESSUP', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7483, '18435', '+41.475422', '-075.009368', 'LACKAWAXEN', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7484, '18436', '+41.452686', '-075.321884', 'LAKE ARIEL', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7485, '18437', '+41.617378', '-075.282339', 'LAKE COMO', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7486, '18438', '+41.431256', '-075.303874', 'LAKEVILLE', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7487, '18439', '+41.828081', '-075.396741', 'LAKEWOOD', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7488, '18440', '+41.551585', '-075.767583', 'LA PLUME', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'PO BOX ONLY'),
(7489, '18441', '+41.820346', '-075.804630', 'LENOXVILLE', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7490, '18443', '+41.667024', '-075.118513', 'MILANVILLE', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7491, '18444', '+41.321625', '-075.538602', 'MOSCOW', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7492, '18445', '+41.356766', '-075.381762', 'NEWFOUNDLAND', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7493, '18446', '+41.627612', '-075.786129', 'NICHOLSON', 'PA', 'PENNSYLVANIA', 'WYOMING', 'STANDARD'),
(7494, '18447', '+41.494578', '-075.653932', 'OLYPHANT', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7495, '18448', '+41.464880', '-075.596231', 'OLYPHANT', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'UNIQUE'),
(7496, '18449', '+41.615989', '-075.274708', 'ORSON', 'PA', 'PENNSYLVANIA', 'WAYNE', 'PO BOX ONLY'),
(7497, '18451', '+41.340936', '-075.024055', 'PAUPACK', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7498, '18452', '+41.350663', '-075.552502', 'PECKVILLE', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7499, '18453', '+41.615989', '-075.274708', 'PLEASANT MOUNT', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7500, '18454', '+41.615989', '-075.274708', 'POYNTELLE', 'PA', 'PENNSYLVANIA', 'WAYNE', 'PO BOX ONLY'),
(7501, '18455', '+41.615989', '-075.274708', 'PRESTON PARK', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7502, '18456', '+41.615989', '-075.274708', 'PROMPTON', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7503, '18457', '+41.340936', '-075.024055', 'ROWLAND', 'PA', 'PENNSYLVANIA', 'PIKE', 'PO BOX ONLY'),
(7504, '18458', '+41.414928', '-074.934461', 'SHOHOLA', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7505, '18459', '+41.615989', '-075.274708', 'SOUTH CANAAN', 'PA', 'PENNSYLVANIA', 'WAYNE', 'PO BOX ONLY'),
(7506, '18460', '+41.259242', '-075.373122', 'SOUTH STERLING', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7507, '18461', '+41.615989', '-075.274708', 'STARLIGHT', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7508, '18462', '+41.895290', '-075.424280', 'STARRUCCA', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7509, '18463', '+41.376953', '-075.316010', 'STERLING', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(7510, '18464', '+41.396988', '-075.186881', 'TAFTON', 'PA', 'PENNSYLVANIA', 'PIKE', 'STANDARD'),
(7511, '18465', '+41.840150', '-075.531898', 'THOMPSON', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7512, '18466', '+41.175510', '-075.461757', 'TOBYHANNA', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7513, '18469', '+41.615989', '-075.274708', 'TYLER HILL', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7514, '18470', '+41.698964', '-075.529304', 'UNION DALE', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7515, '18471', '+41.523812', '-075.690608', 'WAVERLY', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'PO BOX ONLY'),
(7516, '18472', '+41.613395', '-075.371218', 'WAYMART', 'PA', 'PENNSYLVANIA', 'WAYNE', 'STANDARD'),
(7517, '18473', '+41.540648', '-075.222927', 'WHITE MILLS', 'PA', 'PENNSYLVANIA', 'WAYNE', 'PO BOX ONLY'),
(7518, '18501', '+41.401881', '-075.637626', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7519, '18502', '+41.350303', '-075.689965', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7520, '18503', '+41.410079', '-075.666784', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7521, '18504', '+41.421572', '-075.691955', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7522, '18505', '+41.413137', '-075.651940', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7523, '18507', '+41.361332', '-075.706584', 'MOOSIC', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7524, '18508', '+41.439979', '-075.668430', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7525, '18509', '+41.429080', '-075.647633', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7526, '18510', '+41.396665', '-075.652869', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7527, '18512', '+41.435030', '-075.610332', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7528, '18514', '+41.401881', '-075.637626', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'UNIQUE'),
(7529, '18515', '+41.403529', '-075.706485', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7530, '18517', '+41.382529', '-075.713185', 'TAYLOR', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7531, '18518', '+41.372779', '-075.730836', 'OLD FORGE', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7532, '18519', '+41.463118', '-075.629099', 'DICKSON CITY', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'STANDARD'),
(7533, '18522', '+41.401881', '-075.637626', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'UNIQUE'),
(7534, '18540', '+41.401881', '-075.637626', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'UNIQUE'),
(7535, '18577', '+41.401881', '-075.637626', 'SCRANTON', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'UNIQUE'),
(7536, '18601', '+41.272248', '-075.880146', 'BEACH HAVEN', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7537, '18602', '+41.192177', '-075.716073', 'BEAR CREEK', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7538, '18603', '+41.056142', '-076.299844', 'BERWICK', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'STANDARD'),
(7539, '18610', '+41.085529', '-075.499384', 'BLAKESLEE', 'PA', 'PENNSYLVANIA', 'MONROE', 'STANDARD'),
(7540, '18611', '+41.110259', '-075.775517', 'CAMBRA', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7541, '18612', '+41.271121', '-075.999621', 'DALLAS', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7542, '18614', '+41.524261', '-076.397554', 'DUSHORE', 'PA', 'PENNSYLVANIA', 'SULLIVAN', 'STANDARD'),
(7543, '18615', '+41.447109', '-075.855544', 'FALLS', 'PA', 'PENNSYLVANIA', 'WYOMING', 'STANDARD'),
(7544, '18616', '+41.432901', '-076.516887', 'FORKSVILLE', 'PA', 'PENNSYLVANIA', 'SULLIVAN', 'STANDARD'),
(7545, '18617', '+41.265528', '-076.052153', 'GLEN LYON', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7546, '18618', '+41.373850', '-075.969059', 'HARVEYS LAKE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7547, '18619', '+41.432901', '-076.516887', 'HILLSGROVE', 'PA', 'PENNSYLVANIA', 'SULLIVAN', 'STANDARD'),
(7548, '18621', '+41.283170', '-076.064414', 'HUNLOCK CREEK', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7549, '18622', '+41.272248', '-075.880146', 'HUNTINGTON MILLS', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7550, '18623', '+41.632632', '-076.154464', 'LACEYVILLE', 'PA', 'PENNSYLVANIA', 'WYOMING', 'STANDARD'),
(7551, '18624', '+41.048947', '-075.608580', 'LAKE HARMONY', 'PA', 'PENNSYLVANIA', 'CARBON', 'PO BOX ONLY'),
(7552, '18625', '+41.513852', '-075.841598', 'LAKE WINOLA', 'PA', 'PENNSYLVANIA', 'WYOMING', 'PO BOX ONLY'),
(7553, '18626', '+41.432901', '-076.516887', 'LAPORTE', 'PA', 'PENNSYLVANIA', 'SULLIVAN', 'PO BOX ONLY'),
(7554, '18627', '+41.316584', '-076.021037', 'LEHMAN', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7555, '18628', '+41.432901', '-076.516887', 'LOPEZ', 'PA', 'PENNSYLVANIA', 'SULLIVAN', 'STANDARD'),
(7556, '18629', '+41.277080', '-075.960156', 'MEHOOPANY', 'PA', 'PENNSYLVANIA', 'WYOMING', 'STANDARD'),
(7557, '18630', '+41.277080', '-075.960156', 'MESHOPPEN', 'PA', 'PENNSYLVANIA', 'WYOMING', 'STANDARD'),
(7558, '18631', '+40.987130', '-076.287669', 'MIFFLINVILLE', 'PA', 'PENNSYLVANIA', 'COLUMBIA', 'PO BOX ONLY'),
(7559, '18632', '+41.432901', '-076.516887', 'MILDRED', 'PA', 'PENNSYLVANIA', 'SULLIVAN', 'STANDARD'),
(7560, '18634', '+41.249808', '-076.008195', 'NANTICOKE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7561, '18635', '+41.049051', '-076.189182', 'NESCOPECK', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7562, '18636', '+41.277080', '-075.960156', 'NOXEN', 'PA', 'PENNSYLVANIA', 'WYOMING', 'STANDARD'),
(7563, '18640', '+41.298152', '-075.858560', 'PITTSTON', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7564, '18641', '+41.238649', '-075.868267', 'PITTSTON', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7565, '18642', '+41.217263', '-075.938105', 'DURYEA', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7566, '18643', '+41.262312', '-075.816983', 'PITTSTON', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7567, '18644', '+41.337161', '-075.912401', 'WYOMING', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7568, '18651', '+41.288710', '-075.987640', 'PLYMOUTH', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7569, '18653', '+41.394526', '-075.824239', 'RANSOM', 'PA', 'PENNSYLVANIA', 'LACKAWANNA', 'PO BOX ONLY'),
(7570, '18654', '+41.350053', '-076.031930', 'SHAWANESE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'PO BOX ONLY'),
(7571, '18655', '+41.151321', '-076.108103', 'SHICKSHINNY', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7572, '18656', '+41.288634', '-076.142277', 'SWEET VALLEY', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7573, '18657', '+41.566386', '-075.975715', 'TUNKHANNOCK', 'PA', 'PENNSYLVANIA', 'WYOMING', 'STANDARD'),
(7574, '18660', '+41.142698', '-076.039935', 'WAPWALLOPEN', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7575, '18661', '+41.114503', '-075.909158', 'WHITE HAVEN', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7576, '18690', '+41.272248', '-075.880146', 'DALLAS', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'UNIQUE'),
(7577, '18701', '+41.203631', '-075.884340', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7578, '18702', '+41.211028', '-075.838169', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7579, '18703', '+41.242081', '-075.885690', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7580, '18704', '+41.278430', '-075.905842', 'KINGSTON', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7581, '18705', '+41.261699', '-075.849123', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7582, '18706', '+41.231300', '-075.896241', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7583, '18707', '+41.166401', '-075.961432', 'MOUNTAIN TOP', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7584, '18708', '+41.240830', '-075.947216', 'SHAVERTOWN', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7585, '18709', '+41.286030', '-075.895090', 'LUZERNE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7586, '18710', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7587, '18711', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7588, '18761', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'UNIQUE'),
(7589, '18762', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'UNIQUE'),
(7590, '18763', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'UNIQUE'),
(7591, '18764', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7592, '18765', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7593, '18766', '+41.244781', '-075.889590', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7594, '18767', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'UNIQUE'),
(7595, '18768', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'UNIQUE'),
(7596, '18769', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'UNIQUE'),
(7597, '18773', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'STANDARD'),
(7598, '18774', '+41.272248', '-075.880146', 'WILKES BARRE', 'PA', 'PENNSYLVANIA', 'LUZERNE', 'UNIQUE'),
(7599, '18801', '+41.844140', '-075.831862', 'MONTROSE', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7600, '18810', '+41.861751', '-076.488418', 'ATHENS', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7601, '18812', '+41.820346', '-075.804630', 'BRACKNEY', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7602, '18813', '+41.820346', '-075.804630', 'BROOKLYN', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'PO BOX ONLY'),
(7603, '18814', '+41.771970', '-076.521266', 'BURLINGTON', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'PO BOX ONLY'),
(7604, '18815', '+41.771970', '-076.521266', 'CAMPTOWN', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'PO BOX ONLY'),
(7605, '18816', '+41.820346', '-075.804630', 'DIMOCK', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'PO BOX ONLY'),
(7606, '18817', '+41.771970', '-076.521266', 'EAST SMITHFIELD', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7607, '18818', '+41.820346', '-075.804630', 'FRIENDSVILLE', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7608, '18820', '+41.820346', '-075.804630', 'GIBSON', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'PO BOX ONLY'),
(7609, '18821', '+41.973758', '-075.744802', 'GREAT BEND', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7610, '18822', '+41.960544', '-075.748053', 'HALLSTEAD', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7611, '18823', '+41.820346', '-075.804630', 'HARFORD', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7612, '18824', '+41.702924', '-075.767941', 'HOP BOTTOM', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7613, '18825', '+41.820346', '-075.804630', 'JACKSON', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7614, '18826', '+41.766724', '-075.732669', 'KINGSLEY', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7615, '18827', '+41.957520', '-075.637286', 'LANESBORO', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'PO BOX ONLY'),
(7616, '18828', '+41.820346', '-075.804630', 'LAWTON', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7617, '18829', '+41.771970', '-076.521266', 'LE RAYSVILLE', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7618, '18830', '+41.820346', '-075.804630', 'LITTLE MEADOWS', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7619, '18831', '+41.880928', '-076.585448', 'MILAN', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7620, '18832', '+41.713484', '-076.487176', 'MONROETON', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7621, '18833', '+41.599586', '-076.442518', 'NEW ALBANY', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7622, '18834', '+41.890486', '-075.688114', 'NEW MILFORD', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7623, '18837', '+41.771970', '-076.521266', 'ROME', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7624, '18839', '+41.820346', '-075.804630', 'RUSHVILLE', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7625, '18840', '+41.978190', '-076.599403', 'SAYRE', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7626, '18842', '+41.820346', '-075.804630', 'SOUTH GIBSON', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7627, '18843', '+41.823700', '-075.883140', 'SOUTH MONTROSE', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'PO BOX ONLY'),
(7628, '18844', '+41.820346', '-075.804630', 'SPRINGVILLE', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7629, '18845', '+41.771970', '-076.521266', 'STEVENSVILLE', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7630, '18846', '+41.771970', '-076.521266', 'SUGAR RUN', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7631, '18847', '+41.957087', '-075.664856', 'SUSQUEHANNA', 'PA', 'PENNSYLVANIA', 'SUSQUEHANNA', 'STANDARD'),
(7632, '18848', '+41.773762', '-076.389299', 'TOWANDA', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7633, '18850', '+41.813972', '-076.549572', 'ULSTER', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7634, '18851', '+41.771970', '-076.521266', 'WARREN CENTER', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7635, '18853', '+41.668617', '-076.265169', 'WYALUSING', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7636, '18854', '+41.771970', '-076.521266', 'WYSOX', 'PA', 'PENNSYLVANIA', 'BRADFORD', 'STANDARD'),
(7637, '18901', '+40.334863', '-075.118737', 'DOYLESTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7638, '18910', '+40.328645', '-075.102780', 'BEDMINSTER', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7639, '18911', '+40.328645', '-075.102780', 'BLOOMING GLEN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7640, '18912', '+40.309942', '-075.074252', 'BUCKINGHAM', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7641, '18913', '+40.376499', '-075.041290', 'CARVERSVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7642, '18914', '+40.288277', '-075.201848', 'CHALFONT', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7643, '18915', '+40.272756', '-075.256285', 'COLMAR', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7644, '18916', '+40.328645', '-075.102780', 'DANBORO', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7645, '18917', '+40.375008', '-075.204464', 'DUBLIN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7646, '18918', '+40.320036', '-075.374155', 'EARLINGTON', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7647, '18920', '+40.488543', '-075.095760', 'ERWINNA', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7648, '18921', '+40.328645', '-075.102780', 'FERNDALE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7649, '18922', '+40.328645', '-075.102780', 'FOREST GROVE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7650, '18923', '+40.272313', '-075.117414', 'FOUNTAINVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7651, '18924', '+40.308116', '-075.358575', 'FRANCONIA', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7652, '18925', '+40.283176', '-075.064112', 'FURLONG', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7653, '18926', '+40.394730', '-075.098468', 'GARDENVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7654, '18927', '+40.323533', '-075.254829', 'HILLTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7655, '18928', '+40.335974', '-075.042880', 'HOLICONG', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7656, '18929', '+40.254157', '-075.088540', 'JAMISON', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7657, '18930', '+40.541990', '-075.207252', 'KINTNERSVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7658, '18931', '+40.328645', '-075.102780', 'LAHASKA', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7659, '18932', '+40.299561', '-075.254097', 'LINE LEXINGTON', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7660, '18933', '+40.328645', '-075.102780', 'LUMBERVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7661, '18934', '+40.349443', '-075.067622', 'MECHANICSVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7662, '18935', '+40.328645', '-075.102780', 'MILFORD SQUARE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7663, '18936', '+40.237500', '-075.236560', 'MONTGOMERYVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7664, '18938', '+40.357492', '-074.998605', 'NEW HOPE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7665, '18940', '+40.263042', '-074.955535', 'NEWTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7666, '18942', '+40.463447', '-075.167341', 'OTTSVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7667, '18943', '+40.268981', '-075.009401', 'PENNS PARK', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7668, '18944', '+40.390196', '-075.233253', 'PERKASIE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7669, '18946', '+40.271104', '-075.062204', 'PINEVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7670, '18947', '+40.430140', '-075.117200', 'PIPERSVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7671, '18949', '+40.388050', '-075.142522', 'PLUMSTEADVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7672, '18950', '+40.416516', '-075.074832', 'POINT PLEASANT', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7673, '18951', '+40.452525', '-075.221391', 'QUAKERTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7674, '18953', '+40.328645', '-075.102780', 'REVERE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7675, '18954', '+40.224658', '-075.001662', 'RICHBORO', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7676, '18955', '+40.479630', '-075.314639', 'RICHLANDTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7677, '18956', '+40.262783', '-075.015680', 'RUSHLAND', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7678, '18957', '+40.302945', '-075.448579', 'SALFORD', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7679, '18958', '+40.290357', '-075.435539', 'SALFORDVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7680, '18960', '+40.360473', '-075.317521', 'SELLERSVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7681, '18962', '+40.344529', '-075.268738', 'SILVERDALE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7682, '18963', '+40.328645', '-075.102780', 'SOLEBURY', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7683, '18964', '+40.288379', '-075.341026', 'SOUDERTON', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7684, '18966', '+40.186758', '-075.007099', 'SOUTHAMPTON', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7685, '18968', '+40.328645', '-075.102780', 'SPINNERSTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7686, '18969', '+40.325792', '-075.380495', 'TELFORD', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7687, '18970', '+40.328645', '-075.102780', 'TRUMBAUERSVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7688, '18971', '+40.346980', '-075.376985', 'TYLERSPORT', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7689, '18972', '+40.529063', '-075.124333', 'UPPER BLACK EDDY', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7690, '18974', '+40.208476', '-075.040613', 'WARMINSTER', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7691, '18976', '+40.244807', '-075.142587', 'WARRINGTON', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7692, '18977', '+40.284947', '-074.877828', 'WASHINGTON CROSSING', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7693, '18979', '+40.211896', '-075.355860', 'WOXALL', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7694, '18980', '+40.274185', '-075.020499', 'WYCOMBE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7695, '18981', '+40.328645', '-075.102780', 'ZIONHILL', 'PA', 'PENNSYLVANIA', 'BUCKS', 'PO BOX ONLY'),
(7696, '18991', '+40.328645', '-075.102780', 'WARMINSTER', 'PA', 'PENNSYLVANIA', 'BUCKS', 'UNIQUE'),
(7697, '19001', '+40.123805', '-075.114767', 'ABINGTON', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7698, '19002', '+40.180876', '-075.215621', 'AMBLER', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7699, '19003', '+39.998811', '-075.307930', 'ARDMORE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7700, '19004', '+40.013811', '-075.228224', 'BALA CYNWYD', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7701, '19006', '+40.128400', '-075.060665', 'HUNTINGDON VALLEY', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7702, '19007', '+40.115859', '-074.853608', 'BRISTOL', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7703, '19008', '+39.972965', '-075.365635', 'BROOMALL', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7704, '19009', '+40.135012', '-075.062292', 'BRYN ATHYN', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7705, '19010', '+39.955561', '-075.344833', 'BRYN MAWR', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7706, '19012', '+40.059161', '-075.104468', 'CHELTENHAM', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7707, '19013', '+39.878817', '-075.437102', 'CHESTER', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7708, '19014', '+39.866766', '-075.398537', 'ASTON', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7709, '19015', '+39.909511', '-075.366785', 'BROOKHAVEN', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7710, '19016', '+39.934047', '-075.405987', 'CHESTER', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7711, '19017', '+39.883911', '-075.466949', 'CHESTER HEIGHTS', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'PO BOX ONLY'),
(7712, '19018', '+39.921562', '-075.295030', 'CLIFTON HEIGHTS', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7713, '19019', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7714, '19020', '+40.125609', '-074.994262', 'BENSALEM', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7715, '19021', '+40.090878', '-074.887554', 'CROYDON', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7716, '19022', '+39.898162', '-075.319632', 'CRUM LYNNE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7717, '19023', '+39.917562', '-075.269628', 'DARBY', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7718, '19025', '+40.162403', '-075.409776', 'DRESHER', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7719, '19026', '+39.937562', '-075.307731', 'DREXEL HILL', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7720, '19027', '+40.075010', '-075.131518', 'ELKINS PARK', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7721, '19028', '+39.934047', '-075.405987', 'EDGEMONT', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'PO BOX ONLY'),
(7722, '19029', '+39.867562', '-075.285860', 'ESSINGTON', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7723, '19030', '+40.177087', '-074.829107', 'FAIRLESS HILLS', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7724, '19031', '+40.106805', '-075.215071', 'FLOURTOWN', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7725, '19032', '+39.895162', '-075.278829', 'FOLCROFT', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7726, '19033', '+39.890962', '-075.327282', 'FOLSOM', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7727, '19034', '+40.130959', '-075.207437', 'FORT WASHINGTON', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7728, '19035', '+40.044860', '-075.280686', 'GLADWYNE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7729, '19036', '+39.902512', '-075.292680', 'GLENOLDEN', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7730, '19037', '+39.934047', '-075.405987', 'GLEN RIDDLE LIMA', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7731, '19038', '+40.101109', '-075.178020', 'GLENSIDE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7732, '19039', '+39.882110', '-075.337234', 'GRADYVILLE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'PO BOX ONLY'),
(7733, '19040', '+40.182406', '-075.106265', 'HATBORO', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7734, '19041', '+40.002911', '-075.321632', 'HAVERFORD', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7735, '19043', '+39.899562', '-075.307731', 'HOLMES', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7736, '19044', '+40.191808', '-075.150577', 'HORSHAM', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7737, '19046', '+40.097960', '-075.107767', 'JENKINTOWN', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7738, '19047', '+40.289021', '-075.065486', 'LANGHORNE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7739, '19048', '+40.173509', '-074.924610', 'FORT WASHINGTON', 'PA', 'PENNSYLVANIA', 'BUCKS', 'UNIQUE'),
(7740, '19049', '+40.328645', '-075.102780', 'FORT WASHINGTON', 'PA', 'PENNSYLVANIA', 'BUCKS', 'UNIQUE'),
(7741, '19050', '+39.914562', '-075.294580', 'LANSDOWNE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7742, '19052', '+39.894161', '-075.445589', 'LENNI', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'PO BOX ONLY'),
(7743, '19053', '+40.154680', '-074.990378', 'FEASTERVILLE TREVOSE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7744, '19054', '+40.174246', '-074.821857', 'LEVITTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7745, '19055', '+40.145759', '-074.841107', 'LEVITTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7746, '19056', '+40.147709', '-074.880059', 'LEVITTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7747, '19057', '+40.143309', '-074.846373', 'LEVITTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7748, '19058', '+40.328645', '-075.102780', 'LEVITTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7749, '19059', '+40.328645', '-075.102780', 'LEVITTOWN', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7750, '19061', '+39.850910', '-075.418228', 'MARCUS HOOK', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7751, '19063', '+39.918804', '-075.399118', 'MEDIA', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7752, '19064', '+39.931858', '-075.341583', 'SPRINGFIELD', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7753, '19065', '+39.921061', '-075.386136', 'MEDIA', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7754, '19066', '+40.003412', '-075.249476', 'MERION STATION', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7755, '19067', '+40.208408', '-074.829140', 'MORRISVILLE', 'PA', 'PENNSYLVANIA', 'BUCKS', 'STANDARD'),
(7756, '19070', '+39.907762', '-075.325182', 'MORTON', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7757, '19072', '+40.020911', '-075.259975', 'NARBERTH', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7758, '19073', '+39.955409', '-075.401720', 'NEWTOWN SQUARE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7759, '19074', '+39.888412', '-075.298180', 'NORWOOD', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7760, '19075', '+40.113809', '-075.185219', 'ORELAND', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7761, '19076', '+39.885984', '-075.307231', 'PROSPECT PARK', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7762, '19078', '+39.878212', '-075.323082', 'RIDLEY PARK', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7763, '19079', '+39.901112', '-075.267628', 'SHARON HILL', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7764, '19080', '+40.043201', '-075.357678', 'WAYNE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'UNIQUE'),
(7765, '19081', '+39.897162', '-075.344083', 'SWARTHMORE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7766, '19082', '+39.951662', '-075.285429', 'UPPER DARBY', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7767, '19083', '+39.974861', '-075.312081', 'HAVERTOWN', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7768, '19085', '+40.027909', '-075.369458', 'VILLANOVA', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7769, '19086', '+39.896711', '-075.370385', 'WALLINGFORD', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7770, '19087', '+39.985960', '-075.370934', 'WAYNE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7771, '19088', '+39.934047', '-075.405987', 'WAYNE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'UNIQUE'),
(7772, '19089', '+40.043399', '-075.357308', 'WAYNE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'UNIQUE'),
(7773, '19090', '+40.161856', '-075.108970', 'WILLOW GROVE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7774, '19091', '+39.934047', '-075.405987', 'MEDIA', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'UNIQUE'),
(7775, '19092', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7776, '19093', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7777, '19094', '+39.876862', '-075.346083', 'WOODLYN', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7778, '19095', '+40.085610', '-075.151569', 'WYNCOTE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7779, '19096', '+40.051411', '-075.164822', 'WYNNEWOOD', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7780, '19098', '+39.895362', '-075.310731', 'HOLMES', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'UNIQUE'),
(7781, '19099', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7782, '19101', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7783, '19102', '+39.952562', '-075.166472', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7784, '19103', '+40.003361', '-075.186822', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7785, '19104', '+39.960912', '-075.196680', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7786, '19105', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7787, '19106', '+39.950004', '-075.150071', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7788, '19107', '+39.962612', '-075.162871', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7789, '19108', '+39.959812', '-075.161622', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7790, '19109', '+39.949612', '-075.163722', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7791, '19110', '+39.950212', '-075.163572', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7792, '19111', '+40.063170', '-075.081317', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7793, '19112', '+39.892213', '-075.179623', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7794, '19113', '+39.869958', '-075.277458', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7795, '19114', '+40.019816', '-075.065617', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7796, '19115', '+40.078410', '-075.045065', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7797, '19116', '+40.104709', '-075.006771', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7798, '19118', '+40.072310', '-075.203371', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7799, '19119', '+40.068142', '-075.123024', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7800, '19120', '+40.031611', '-075.119019', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7801, '19121', '+39.983212', '-075.174172', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7802, '19122', '+39.977462', '-075.141271', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7803, '19123', '+39.982380', '-075.115369', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7804, '19124', '+40.021561', '-075.093668', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7805, '19125', '+39.977262', '-075.132920', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7806, '19126', '+40.061411', '-075.131769', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7807, '19127', '+40.024761', '-075.222473', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7808, '19128', '+40.049111', '-075.178489', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7809, '19129', '+40.022911', '-075.167771', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7810, '19130', '+40.001161', '-075.169671', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7811, '19131', '+39.996811', '-075.207774', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7812, '19132', '+40.040111', '-075.117719', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7813, '19133', '+39.992562', '-075.137320', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7814, '19134', '+39.994662', '-075.107969', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7815, '19135', '+40.017061', '-075.098618', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7816, '19136', '+40.044661', '-075.020665', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7817, '19137', '+39.986162', '-075.150671', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7818, '19138', '+40.056261', '-075.161170', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7819, '19139', '+39.996211', '-075.117519', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7820, '19140', '+40.014861', '-075.128302', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7821, '19141', '+40.009611', '-075.150320', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7822, '19142', '+39.963339', '-075.161672', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7823, '19143', '+39.957312', '-075.187023', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7824, '19144', '+40.033111', '-075.179871', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7825, '19145', '+39.917002', '-075.187700', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7826, '19146', '+39.945112', '-075.175822', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7827, '19147', '+39.936212', '-075.155973', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7828, '19148', '+39.950362', '-075.155371', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7829, '19149', '+40.024361', '-075.081668', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7830, '19150', '+40.072310', '-075.171220', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7831, '19151', '+39.986611', '-075.213174', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7832, '19152', '+40.014011', '-075.086818', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7833, '19153', '+39.899412', '-075.226976', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7834, '19154', '+40.084017', '-075.018265', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7835, '19155', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7836, '19160', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'STANDARD'),
(7837, '19161', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7838, '19162', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7839, '19170', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7840, '19171', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7841, '19172', '+39.947321', '-075.150011', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7842, '19173', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7843, '19175', '+39.990562', '-075.129570', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7844, '19177', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7845, '19178', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7846, '19179', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7847, '19181', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7848, '19182', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7849, '19183', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7850, '19184', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7851, '19185', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7852, '19187', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7853, '19188', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7854, '19191', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7855, '19192', '+39.951112', '-075.167622', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7856, '19193', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7857, '19194', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7858, '19196', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7859, '19197', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7860, '19244', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7861, '19255', '+40.001811', '-075.117870', 'PHILADELPHIA', 'PA', 'PENNSYLVANIA', 'PHILADELPHIA', 'UNIQUE'),
(7862, '19301', '+40.040057', '-075.488793', 'PAOLI', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7863, '19310', '+39.941554', '-075.957993', 'ATGLEN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7864, '19311', '+39.866821', '-075.839686', 'AVONDALE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7865, '19312', '+40.030058', '-075.456440', 'BERWYN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7866, '19316', '+40.054976', '-075.837767', 'BRANDAMORE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7867, '19317', '+39.865567', '-075.557698', 'CHADDS FORD', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7868, '19318', '+39.852406', '-075.811789', 'CHATHAM', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7869, '19319', '+39.920918', '-075.522168', 'CHEYNEY', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7870, '19320', '+39.968862', '-075.829163', 'COATESVILLE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7871, '19330', '+39.916517', '-075.925805', 'COCHRANVILLE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7872, '19331', '+39.882274', '-075.516529', 'CONCORDVILLE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'PO BOX ONLY'),
(7873, '19333', '+40.042623', '-075.427460', 'DEVON', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7874, '19335', '+40.031265', '-075.722614', 'DOWNINGTOWN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7875, '19339', '+39.934047', '-075.405987', 'CONCORDVILLE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'UNIQUE'),
(7876, '19340', '+39.934047', '-075.405987', 'CONCORDVILLE', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'UNIQUE'),
(7877, '19341', '+40.049852', '-075.637035', 'EXTON', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7878, '19342', '+39.902633', '-075.483224', 'GLEN MILLS', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7879, '19343', '+40.100892', '-075.753071', 'GLENMOORE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7880, '19344', '+40.089561', '-075.867533', 'HONEY BROOK', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7881, '19345', '+39.847803', '-075.719347', 'IMMACULATA', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7882, '19346', '+39.983153', '-075.748055', 'KELTON', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7883, '19347', '+39.983153', '-075.748055', 'KEMBLESVILLE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7884, '19348', '+39.867864', '-075.716333', 'KENNETT SQUARE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7885, '19350', '+39.771506', '-075.799761', 'LANDENBERG', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7886, '19351', '+39.983153', '-075.748055', 'LEWISVILLE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7887, '19352', '+39.778703', '-075.887580', 'LINCOLN UNIVERSITY', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7888, '19353', '+40.013158', '-075.499046', 'LIONVILLE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7889, '19354', '+40.058173', '-075.743272', 'LYNDELL', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7890, '19355', '+40.029510', '-075.713599', 'MALVERN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7891, '19357', '+39.983153', '-075.748055', 'MENDENHALL', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7892, '19358', '+39.962081', '-075.802502', 'MODENA', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7893, '19360', '+39.726143', '-075.785700', 'NEW LONDON', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7894, '19362', '+39.757361', '-076.037603', 'NOTTINGHAM', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7895, '19363', '+39.849721', '-075.957276', 'OXFORD', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7896, '19365', '+40.001064', '-075.830891', 'PARKESBURG', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7897, '19366', '+39.983153', '-075.748055', 'POCOPSON', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7898, '19367', '+39.970601', '-075.895794', 'POMEROY', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7899, '19369', '+39.990302', '-075.893598', 'SADSBURYVILLE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7900, '19370', '+39.983153', '-075.748055', 'STEELVILLE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7901, '19371', '+39.983153', '-075.748055', 'SUPLEE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7902, '19372', '+39.993929', '-075.818572', 'THORNDALE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7903, '19373', '+39.905987', '-075.535383', 'THORNTON', 'PA', 'PENNSYLVANIA', 'DELAWARE', 'STANDARD'),
(7904, '19374', '+39.872825', '-075.848075', 'TOUGHKENAMON', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7905, '19375', '+39.901177', '-075.750203', 'UNIONVILLE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7906, '19376', '+39.983153', '-075.748055', 'WAGONTOWN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7907, '19380', '+39.980107', '-075.610503', 'WEST CHESTER', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7908, '19381', '+39.983153', '-075.748055', 'WEST CHESTER', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7909, '19382', '+39.912284', '-075.630235', 'WEST CHESTER', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7910, '19383', '+39.945450', '-075.602401', 'WEST CHESTER', 'PA', 'PENNSYLVANIA', 'CHESTER', 'UNIQUE'),
(7911, '19390', '+39.841367', '-075.847944', 'WEST GROVE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7912, '19395', '+39.932821', '-075.544822', 'WESTTOWN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7913, '19397', '+39.983153', '-075.748055', 'SOUTHEASTERN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7914, '19398', '+39.983153', '-075.748055', 'SOUTHEASTERN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7915, '19399', '+39.983153', '-075.748055', 'SOUTHEASTERN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7916, '19401', '+40.149154', '-075.356627', 'NORRISTOWN', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7917, '19403', '+40.124886', '-075.357027', 'NORRISTOWN', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7918, '19404', '+40.211896', '-075.355860', 'NORRISTOWN', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7919, '19405', '+40.120931', '-075.362127', 'BRIDGEPORT', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7920, '19406', '+40.179242', '-075.388022', 'KING OF PRUSSIA', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7921, '19407', '+40.211896', '-075.355860', 'AUDUBON', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7922, '19408', '+40.156555', '-075.413127', 'EAGLEVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7923, '19409', '+40.211896', '-075.355860', 'FAIRVIEW VILLAGE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7924, '19415', '', '', 'EAGLEVILLE', 'PA', 'PENNSYLVANIA', '', 'UNIQUE'),
(7925, '19420', '+40.152871', '-075.456719', 'ARCOLA', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7926, '19421', '+39.983153', '-075.748055', 'BIRCHRUNVILLE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7927, '19422', '+40.157550', '-075.279941', 'BLUE BELL', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7928, '19423', '+40.217350', '-075.364973', 'CEDARS', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7929, '19424', '+40.211896', '-075.355860', 'BLUE BELL', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'UNIQUE'),
(7930, '19425', '+40.103858', '-075.639994', 'CHESTER SPRINGS', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7931, '19426', '+40.236083', '-075.430272', 'COLLEGEVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7932, '19428', '+40.082509', '-075.304377', 'CONSHOHOCKEN', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7933, '19429', '+40.211896', '-075.355860', 'CONSHOHOCKEN', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'UNIQUE'),
(7934, '19430', '+40.185071', '-075.419966', 'CREAMERY', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7935, '19432', '+40.079629', '-075.559975', 'DEVAULT', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7936, '19435', '+40.312552', '-075.551710', 'FREDERICK', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7937, '19436', '+40.200757', '-075.250665', 'GWYNEDD', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7938, '19437', '+40.181054', '-075.257855', 'GWYNEDD VALLEY', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7939, '19438', '+40.274188', '-075.395188', 'HARLEYSVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7940, '19440', '+40.282020', '-075.358491', 'HATFIELD', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7941, '19441', '+40.211896', '-075.355860', 'HARLEYSVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'UNIQUE'),
(7942, '19442', '+40.146549', '-075.617739', 'KIMBERTON', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7943, '19443', '+40.241004', '-075.343920', 'KULPSVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7944, '19444', '+40.085260', '-075.257423', 'LAFAYETTE HILL', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7945, '19446', '+40.224245', '-075.291560', 'LANSDALE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7946, '19450', '+40.211896', '-075.355860', 'LEDERACH', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7947, '19451', '+40.211896', '-075.355860', 'MAINLAND', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7948, '19452', '+40.211896', '-075.355860', 'MIQUON', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7949, '19453', '+40.151918', '-075.504383', 'MONT CLARE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7950, '19454', '+40.220106', '-075.237877', 'NORTH WALES', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7951, '19455', '+40.211896', '-075.355860', 'NORTH WALES', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'UNIQUE'),
(7952, '19456', '+40.133355', '-075.453631', 'OAKS', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7953, '19457', '+40.208976', '-075.598400', 'PARKER FORD', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7954, '19460', '+40.128175', '-075.541769', 'PHOENIXVILLE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7955, '19462', '+40.137759', '-075.352751', 'PLYMOUTH MEETING', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7956, '19464', '+40.263457', '-075.617195', 'POTTSTOWN', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7957, '19465', '+40.191907', '-075.665310', 'POTTSTOWN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7958, '19468', '+40.208940', '-075.490215', 'ROYERSFORD', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7959, '19470', '+40.186707', '-075.728759', 'SAINT PETERS', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7960, '19472', '+40.344773', '-075.577458', 'SASSAMANSVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7961, '19473', '+40.224789', '-075.478534', 'SCHWENKSVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7962, '19474', '+40.225109', '-075.403095', 'SKIPPACK', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7963, '19475', '+40.146989', '-075.605398', 'SPRING CITY', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7964, '19477', '+40.185934', '-075.232407', 'SPRING HOUSE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7965, '19478', '+40.275914', '-075.461756', 'SPRING MOUNT', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7966, '19480', '+40.098032', '-075.688005', 'UWCHLAND', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7967, '19481', '+40.092269', '-075.453735', 'VALLEY FORGE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7968, '19482', '+40.080323', '-075.455408', 'VALLEY FORGE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'PO BOX ONLY'),
(7969, '19483', '+40.211896', '-075.355860', 'VALLEY FORGE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'UNIQUE'),
(7970, '19484', '+40.211896', '-075.355860', 'VALLEY FORGE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7971, '19485', '+40.211896', '-075.355860', 'VALLEY FORGE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7972, '19486', '+40.203291', '-075.301918', 'WEST POINT', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7973, '19487', '+39.983153', '-075.748055', 'KING OF PRUSSIA', 'PA', 'PENNSYLVANIA', 'CHESTER', 'UNIQUE'),
(7974, '19488', '+39.983153', '-075.748055', 'NORRISTOWN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'UNIQUE'),
(7975, '19489', '+39.983153', '-075.748055', 'NORRISTOWN', 'PA', 'PENNSYLVANIA', 'CHESTER', 'UNIQUE'),
(7976, '19490', '+40.192881', '-075.357555', 'WORCESTER', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'PO BOX ONLY'),
(7977, '19492', '+40.290125', '-075.502974', 'ZIEGLERVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7978, '19493', '+39.983153', '-075.748055', 'VALLEY FORGE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'UNIQUE'),
(7979, '19494', '+39.983153', '-075.748055', 'VALLEY FORGE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'UNIQUE'),
(7980, '19495', '+39.983153', '-075.748055', 'VALLEY FORGE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'UNIQUE'),
(7981, '19496', '+39.983153', '-075.748055', 'VALLEY FORGE', 'PA', 'PENNSYLVANIA', 'CHESTER', 'UNIQUE'),
(7982, '19501', '+40.242327', '-076.057696', 'ADAMSTOWN', 'PA', 'PENNSYLVANIA', 'LANCASTER', 'PO BOX ONLY'),
(7983, '19503', '+40.447833', '-075.708672', 'BALLY', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(7984, '19504', '+40.335395', '-075.720131', 'BARTO', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(7985, '19505', '+40.458523', '-075.741863', 'BECHTELSVILLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(7986, '19506', '+40.454997', '-075.906460', 'BERNVILLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(7987, '19507', '+40.491214', '-076.269231', 'BETHEL', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(7988, '19508', '+40.404848', '-075.886642', 'BIRDSBORO', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(7989, '19510', '+40.371492', '-075.887797', 'BLANDON', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(7990, '19511', '+40.482102', '-075.743476', 'BOWERS', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(7991, '19512', '+40.364068', '-075.870971', 'BOYERTOWN', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(7992, '19516', '+40.485843', '-076.005958', 'CENTERPORT', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(7993, '19518', '+40.365322', '-075.848729', 'DOUGLASSVILLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(7994, '19519', '+40.318986', '-075.733368', 'EARLVILLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(7995, '19520', '+40.156293', '-075.786492', 'ELVERSON', 'PA', 'PENNSYLVANIA', 'CHESTER', 'STANDARD'),
(7996, '19522', '+40.326392', '-075.808303', 'FLEETWOOD', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(7997, '19523', '+40.189715', '-075.888112', 'GEIGERTOWN', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(7998, '19525', '+40.309952', '-075.584885', 'GILBERTSVILLE', 'PA', 'PENNSYLVANIA', 'MONTGOMERY', 'STANDARD'),
(7999, '19526', '+40.368035', '-075.861788', 'HAMBURG', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8000, '19529', '+40.627864', '-075.883429', 'KEMPTON', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8001, '19530', '+40.473382', '-075.775241', 'KUTZTOWN', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8002, '19533', '+40.420446', '-075.857150', 'LEESPORT', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8003, '19534', '+40.573618', '-075.864968', 'LENHARTSVILLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8004, '19535', '+40.335593', '-075.801009', 'LIMEKILN', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8005, '19536', '+40.521756', '-075.741859', 'LYON STATION', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8006, '19538', '+40.569818', '-075.740942', 'MAXATAWNY', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8007, '19539', '+40.432311', '-075.796571', 'MERTZTOWN', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8008, '19540', '+40.321665', '-075.804757', 'MOHNTON', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8009, '19541', '+40.400685', '-076.037566', 'MOHRSVILLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8010, '19542', '+40.260992', '-075.768437', 'MONOCACY STATION', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8011, '19543', '+40.367731', '-075.891610', 'MORGANTOWN', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8012, '19544', '+40.418662', '-076.294364', 'MOUNT AETNA', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8013, '19545', '+40.339680', '-075.630160', 'NEW BERLINVILLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8014, '19547', '+40.343449', '-075.897566', 'OLEY', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8015, '19548', '+40.407173', '-075.984901', 'PINE FORGE', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8016, '19549', '+40.722587', '-076.229623', 'PORT CLINTON', 'PA', 'PENNSYLVANIA', 'SCHUYLKILL', 'PO BOX ONLY'),
(8017, '19550', '+40.455305', '-076.245345', 'REHRERSBURG', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8018, '19551', '+40.326171', '-075.888890', 'ROBESONIA', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8019, '19554', '+40.505184', '-076.141334', 'SHARTLESVILLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8020, '19555', '+40.411279', '-075.887016', 'SHOEMAKERSVILLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8021, '19557', '+40.613868', '-075.814984', 'STONY RUN', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8022, '19559', '+40.494368', '-076.186460', 'STRAUSSTOWN', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8023, '19560', '+40.395908', '-075.889849', 'TEMPLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8024, '19562', '+40.476019', '-075.849294', 'TOPTON', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8025, '19564', '+40.526803', '-075.869653', 'VIRGINVILLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'PO BOX ONLY'),
(8026, '19565', '+40.337188', '-075.951748', 'WERNERSVILLE', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8027, '19567', '+40.432759', '-075.925707', 'WOMELSDORF', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8028, '19601', '+40.357242', '-075.940153', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8029, '19602', '+40.326546', '-075.915919', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8030, '19603', '+40.388442', '-075.963055', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8031, '19604', '+40.360942', '-075.927852', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8032, '19605', '+40.404942', '-075.941603', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8033, '19606', '+40.335119', '-075.874976', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8034, '19607', '+40.299463', '-075.987606', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8035, '19608', '+40.316342', '-075.935521', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8036, '19609', '+40.327992', '-075.990807', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8037, '19610', '+40.338017', '-075.978006', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8038, '19611', '+40.303892', '-075.938853', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8039, '19612', '+40.438900', '-075.885303', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'STANDARD'),
(8040, '19640', '+40.407173', '-075.984901', 'READING', 'PA', 'PENNSYLVANIA', 'BERKS', 'UNIQUE'),
(8041, '19701', '+39.594736', '-075.693903', 'BEAR', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8042, '19702', '+39.614737', '-075.701277', 'NEWARK', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8043, '19703', '+39.803790', '-075.458140', 'CLAYMONT', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8044, '19706', '+39.594256', '-075.608081', 'DELAWARE CITY', 'DE', 'DELAWARE', 'NEW CASTLE', 'PO BOX ONLY'),
(8045, '19707', '+39.635202', '-075.680897', 'HOCKESSIN', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8046, '19708', '+39.577567', '-075.690069', 'KIRKWOOD', 'DE', 'DELAWARE', 'NEW CASTLE', 'PO BOX ONLY'),
(8047, '19709', '+39.485721', '-075.677535', 'MIDDLETOWN', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8048, '19710', '+39.757783', '-075.639143', 'MONTCHANIN', 'DE', 'DELAWARE', 'NEW CASTLE', 'PO BOX ONLY'),
(8049, '19711', '+39.668282', '-075.688489', 'NEWARK', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8050, '19712', '+39.564499', '-075.597047', 'NEWARK', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8051, '19713', '+39.665662', '-075.719349', 'NEWARK', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8052, '19714', '+39.564499', '-075.597047', 'NEWARK', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8053, '19715', '+39.564499', '-075.597047', 'NEWARK', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8054, '19716', '+39.564499', '-075.597047', 'NEWARK', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8055, '19717', '+39.564499', '-075.597047', 'NEWARK', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8056, '19718', '+39.564499', '-075.597047', 'NEWARK', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8057, '19720', '+39.592895', '-075.651466', 'NEW CASTLE', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8058, '19721', '+39.564499', '-075.597047', 'NEW CASTLE', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8059, '19725', '+39.564499', '-075.597047', 'NEWARK', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8060, '19726', '+39.564499', '-075.597047', 'NEWARK', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8061, '19730', '+39.512510', '-075.627281', 'ODESSA', 'DE', 'DELAWARE', 'NEW CASTLE', 'PO BOX ONLY'),
(8062, '19731', '+39.512902', '-075.585180', 'PORT PENN', 'DE', 'DELAWARE', 'NEW CASTLE', 'PO BOX ONLY'),
(8063, '19732', '+39.793864', '-075.573750', 'ROCKLAND', 'DE', 'DELAWARE', 'NEW CASTLE', 'PO BOX ONLY'),
(8064, '19733', '+39.555459', '-075.650462', 'SAINT GEORGES', 'DE', 'DELAWARE', 'NEW CASTLE', 'PO BOX ONLY'),
(8065, '19734', '+39.430666', '-075.646408', 'TOWNSEND', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8066, '19735', '+39.794396', '-075.597598', 'WINTERTHUR', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8067, '19736', '+39.797126', '-075.660413', 'YORKLYN', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8068, '19801', '+39.727113', '-075.547844', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8069, '19802', '+39.719870', '-075.593512', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8070, '19803', '+39.799360', '-075.531694', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8071, '19804', '+39.759577', '-075.617198', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8072, '19805', '+39.743107', '-075.593447', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8073, '19806', '+39.758562', '-075.568745', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8074, '19807', '+39.794943', '-075.616134', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8075, '19808', '+39.735912', '-075.664729', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8076, '19809', '+39.764712', '-075.506892', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8077, '19810', '+39.763961', '-075.527812', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8078, '19850', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8079, '19880', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8080, '19884', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8081, '19885', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8082, '19886', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8083, '19887', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8084, '19889', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8085, '19890', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8086, '19891', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8087, '19892', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8088, '19893', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8089, '19894', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8090, '19895', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8091, '19896', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8092, '19897', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8093, '19898', '+39.564499', '-075.597047', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'UNIQUE'),
(8094, '19899', '+39.734792', '-075.624617', 'WILMINGTON', 'DE', 'DELAWARE', 'NEW CASTLE', 'STANDARD'),
(8095, '19901', '+39.156376', '-075.495490', 'DOVER', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8096, '19902', '+39.108680', '-075.448023', 'DOVER AFB', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8097, '19903', '+39.108680', '-075.448023', 'DOVER', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8098, '19904', '+39.160542', '-075.597381', 'DOVER', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8099, '19905', '+39.108680', '-075.448023', 'DOVER', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8100, '19906', '', '', 'DOVER', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8101, '19930', '+38.555533', '-075.186955', 'BETHANY BEACH', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8102, '19931', '+38.569091', '-075.624087', 'BETHEL', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8103, '19933', '+38.660295', '-075.330023', 'BRIDGEVILLE', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8104, '19934', '+39.086921', '-075.612286', 'CAMDEN WYOMING', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8105, '19936', '+39.218448', '-075.584848', 'CHESWOLD', 'DE', 'DELAWARE', 'KENT', 'PO BOX ONLY'),
(8106, '19938', '+39.246071', '-075.688873', 'CLAYTON', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8107, '19939', '+38.621403', '-075.181502', 'DAGSBORO', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8108, '19940', '+38.631744', '-075.324585', 'DELMAR', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8109, '19941', '+38.652805', '-075.275018', 'ELLENDALE', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8110, '19943', '+39.033438', '-075.609891', 'FELTON', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8111, '19944', '+38.486485', '-075.058874', 'FENWICK ISLAND', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8112, '19945', '+38.551440', '-075.157634', 'FRANKFORD', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8113, '19946', '+39.023141', '-075.481910', 'FREDERICA', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8114, '19947', '+38.632891', '-075.334263', 'GEORGETOWN', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8115, '19950', '+38.824580', '-075.588771', 'GREENWOOD', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8116, '19951', '+38.691547', '-075.225025', 'HARBESON', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8117, '19952', '+38.912195', '-075.611322', 'HARRINGTON', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8118, '19953', '+39.163430', '-075.679733', 'HARTLY', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8119, '19954', '+38.894017', '-075.520078', 'HOUSTON', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8120, '19955', '+39.225604', '-075.664153', 'KENTON', 'DE', 'DELAWARE', 'KENT', 'PO BOX ONLY'),
(8121, '19956', '+38.663322', '-075.378729', 'LAUREL', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8122, '19958', '+38.655360', '-075.325612', 'LEWES', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8123, '19960', '+38.848792', '-075.410870', 'LINCOLN', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8124, '19961', '+39.166323', '-075.448289', 'LITTLE CREEK', 'DE', 'DELAWARE', 'KENT', 'PO BOX ONLY'),
(8125, '19962', '+38.971647', '-075.591714', 'MAGNOLIA', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8126, '19963', '+38.727120', '-075.322829', 'MILFORD', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8127, '19964', '+39.140254', '-075.667898', 'MARYDEL', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8128, '19966', '+38.659458', '-075.246410', 'MILLSBORO', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8129, '19967', '+38.700518', '-075.242294', 'MILLVILLE', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8130, '19968', '+38.692714', '-075.322223', 'MILTON', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8131, '19969', '+38.725562', '-075.353387', 'NASSAU', 'DE', 'DELAWARE', 'SUSSEX', 'PO BOX ONLY'),
(8132, '19970', '+38.621587', '-075.104645', 'OCEAN VIEW', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8133, '19971', '+38.629763', '-075.319975', 'REHOBOTH BEACH', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8134, '19973', '+38.659891', '-075.380454', 'SEAFORD', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8135, '19975', '+38.550784', '-075.330307', 'SELBYVILLE', 'DE', 'DELAWARE', 'SUSSEX', 'STANDARD'),
(8136, '19977', '+39.194026', '-075.565131', 'SMYRNA', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8137, '19979', '+38.971038', '-075.577158', 'VIOLA', 'DE', 'DELAWARE', 'KENT', 'STANDARD'),
(8138, '19980', '+39.072390', '-075.571073', 'WOODSIDE', 'DE', 'DELAWARE', 'KENT', 'PO BOX ONLY'),
(8139, '20001', '+38.911936', '-077.016719', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8140, '20002', '+38.908218', '-076.982147', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8141, '20003', '+38.860315', '-076.988897', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8142, '20004', '+38.892247', '-077.019477', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8143, '20005', '+38.904011', '-077.031695', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8144, '20006', '+38.897131', '-077.041248', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8145, '20007', '+38.914561', '-077.075649', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8146, '20008', '+38.935210', '-077.060399', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8147, '20009', '+38.919261', '-077.039798', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8148, '20010', '+38.932711', '-077.030248', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8149, '20011', '+38.952610', '-077.017898', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8150, '20012', '+38.980231', '-077.026298', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8151, '20013', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8152, '20015', '+38.969260', '-077.070949', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8153, '20016', '+38.938260', '-077.091149', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8154, '20017', '+38.938460', '-076.993068', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8155, '20018', '+38.930560', '-076.977953', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8156, '20019', '+38.891561', '-076.939396', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8157, '20020', '+38.857610', '-076.971547', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8158, '20024', '+38.876494', '-077.022948', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8159, '20026', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8160, '20029', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8161, '20030', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8162, '20032', '+38.836800', '-076.997697', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8163, '20033', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8164, '20035', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8165, '20036', '+38.900659', '-077.039914', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8166, '20037', '+38.918903', '-077.061781', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8167, '20038', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8168, '20039', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8169, '20040', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8170, '20041', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8171, '20042', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8172, '20043', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8173, '20044', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8174, '20045', '+38.896599', '-077.031900', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8175, '20046', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8176, '20047', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8177, '20049', '+38.895911', '-077.020998', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8178, '20050', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8179, '20051', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8180, '20052', '+38.900140', '-077.047899', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8181, '20053', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8182, '20055', '+38.901633', '-077.020959', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8183, '20056', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8184, '20057', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8185, '20058', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8186, '20059', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8187, '20060', '+38.918011', '-077.020398', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8188, '20061', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8189, '20062', '+38.900009', '-077.036948', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8190, '20063', '+38.905317', '-077.046645', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8191, '20064', '+38.933161', '-076.996348', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8192, '20065', '+38.883412', '-077.028198', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8193, '20066', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8194, '20067', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8195, '20068', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8196, '20069', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8197, '20070', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8198, '20071', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8199, '20073', '+38.897011', '-077.025098', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8200, '20074', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8201, '20075', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8202, '20076', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8203, '20077', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8204, '20078', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8205, '20080', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8206, '20081', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8207, '20082', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8208, '20088', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8209, '20090', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8210, '20091', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8211, '20097', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8212, '20098', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8213, '20099', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8214, '20101', '+39.002125', '-077.442066', 'DULLES', 'VA', 'VIRGINIA', 'LOUDOUN', 'UNIQUE'),
(8215, '20102', '+39.085309', '-077.645224', 'DULLES', 'VA', 'VIRGINIA', 'LOUDOUN', 'UNIQUE'),
(8216, '20103', '+38.996242', '-077.449952', 'DULLES', 'VA', 'VIRGINIA', 'LOUDOUN', 'UNIQUE'),
(8217, '20104', '+39.085309', '-077.645224', 'DULLES', 'VA', 'VIRGINIA', 'LOUDOUN', 'UNIQUE'),
(8218, '20105', '+38.957718', '-077.603750', 'ALDIE', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8219, '20106', '+38.684200', '-078.016813', 'AMISSVILLE', 'VA', 'VIRGINIA', 'RAPPAHANNOCK', 'STANDARD'),
(8220, '20107', '+38.968321', '-077.533263', 'ARCOLA', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8221, '20108', '+38.744685', '-077.487162', 'MANASSAS', 'VA', 'VIRGINIA', 'MANASSAS CITY', 'STANDARD'),
(8222, '20109', '+38.763215', '-077.493092', 'MANASSAS', 'VA', 'VIRGINIA', 'MANASSAS CITY', 'STANDARD'),
(8223, '20110', '+38.749207', '-077.487762', 'MANASSAS', 'VA', 'VIRGINIA', 'MANASSAS CITY', 'STANDARD'),
(8224, '20111', '+38.770741', '-077.449443', 'MANASSAS', 'VA', 'VIRGINIA', 'MANASSAS PARK CITY', 'STANDARD'),
(8225, '20112', '+38.770864', '-077.449443', 'MANASSAS', 'VA', 'VIRGINIA', 'MANASSAS PARK CITY', 'STANDARD'),
(8226, '20113', '+38.770864', '-077.449443', 'MANASSAS', 'VA', 'VIRGINIA', 'MANASSAS PARK CITY', 'STANDARD'),
(8227, '20115', '+38.840456', '-077.891136', 'MARSHALL', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8228, '20116', '+38.853723', '-077.860127', 'MARSHALL', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8229, '20117', '+39.029599', '-077.693844', 'MIDDLEBURG', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8230, '20118', '+39.007548', '-077.765553', 'MIDDLEBURG', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8231, '20119', '+38.636964', '-077.638287', 'CATLETT', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8232, '20120', '+38.844790', '-077.467010', 'CENTREVILLE', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8233, '20121', '+38.819513', '-077.455760', 'CENTREVILLE', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8234, '20122', '+38.831813', '-077.288755', 'CENTREVILLE', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8235, '20124', '+38.781809', '-077.381808', 'CLIFTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8236, '20128', '+38.741639', '-077.977432', 'ORLEAN', 'VA', 'VIRGINIA', 'FAUQUIER', 'PO BOX ONLY'),
(8237, '20129', '+39.160291', '-077.609670', 'PAEONIAN SPRINGS', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8238, '20130', '+39.004843', '-077.954597', 'PARIS', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8239, '20131', '+39.057952', '-077.743423', 'PHILOMONT', 'VA', 'VIRGINIA', 'LOUDOUN', 'PO BOX ONLY'),
(8240, '20132', '+39.143614', '-077.734232', 'PURCELLVILLE', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8241, '20134', '+39.152187', '-077.702576', 'PURCELLVILLE', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8242, '20135', '+39.082266', '-077.846661', 'BLUEMONT', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8243, '20136', '+38.734255', '-077.547383', 'BRISTOW', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(8244, '20137', '+38.819464', '-077.736814', 'BROAD RUN', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8245, '20138', '+38.633774', '-077.686868', 'CALVERTON', 'VA', 'VIRGINIA', 'FAUQUIER', 'PO BOX ONLY'),
(8246, '20139', '+38.654282', '-077.702542', 'CASANOVA', 'VA', 'VIRGINIA', 'FAUQUIER', 'PO BOX ONLY'),
(8247, '20140', '+38.916291', '-077.864841', 'RECTORTOWN', 'VA', 'VIRGINIA', 'FAUQUIER', 'PO BOX ONLY'),
(8248, '20141', '+39.116425', '-077.780216', 'ROUND HILL', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8249, '20142', '+39.130665', '-077.774665', 'ROUND HILL', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8250, '20143', '+38.845535', '-077.566921', 'CATHARPIN', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(8251, '20144', '+38.911315', '-077.967401', 'DELAPLANE', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8252, '20146', '+39.085309', '-077.645224', 'ASHBURN', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8253, '20147', '+39.037339', '-077.480542', 'ASHBURN', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8254, '20148', '+39.014196', '-077.528452', 'ASHBURN', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8255, '20149', '+39.085309', '-077.645224', 'ASHBURN', 'VA', 'VIRGINIA', 'LOUDOUN', 'UNIQUE'),
(8256, '20151', '+38.886680', '-077.445660', 'CHANTILLY', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8257, '20152', '+38.897591', '-077.509174', 'CHANTILLY', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8258, '20153', '+38.831813', '-077.288755', 'CHANTILLY', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8259, '20155', '+38.815714', '-077.621613', 'GAINESVILLE', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(8260, '20156', '+38.721912', '-077.466897', 'GAINESVILLE', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(8261, '20158', '+39.138314', '-077.657328', 'HAMILTON', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8262, '20159', '+39.133855', '-077.662072', 'HAMILTON', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8263, '20160', '+39.098479', '-077.688338', 'LINCOLN', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8264, '20163', '+39.085309', '-077.645224', 'STERLING', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8265, '20164', '+39.023047', '-077.399367', 'STERLING', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8266, '20165', '+39.047157', '-077.386647', 'STERLING', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8267, '20166', '+38.981387', '-077.472333', 'STERLING', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8268, '20167', '+39.085309', '-077.645224', 'STERLING', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8269, '20168', '+38.721912', '-077.466897', 'HAYMARKET', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(8270, '20169', '+38.867441', '-077.644539', 'HAYMARKET', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(8271, '20170', '+38.983887', '-077.367457', 'HERNDON', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8272, '20171', '+38.925180', '-077.392840', 'HERNDON', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8273, '20172', '+38.831813', '-077.288755', 'HERNDON', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8274, '20175', '+39.041987', '-077.605404', 'LEESBURG', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8275, '20176', '+39.119727', '-077.603458', 'LEESBURG', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8276, '20177', '+39.158095', '-077.666863', 'LEESBURG', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8277, '20178', '+39.072918', '-077.608014', 'LEESBURG', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8278, '20180', '+39.220432', '-077.659636', 'LOVETTSVILLE', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8279, '20181', '+38.700017', '-077.548271', 'NOKESVILLE', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(8280, '20182', '+38.700866', '-077.585708', 'NOKESVILLE', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(8281, '20184', '+38.962661', '-077.884726', 'UPPERVILLE', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8282, '20185', '+38.992978', '-077.879855', 'UPPERVILLE', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8283, '20186', '+38.689832', '-077.836115', 'WARRENTON', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8284, '20187', '+38.715296', '-077.741696', 'WARRENTON', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8285, '20188', '+38.765619', '-077.820293', 'WARRENTON', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8286, '20190', '+38.961460', '-077.341800', 'RESTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8287, '20191', '+38.931810', '-077.352718', 'RESTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8288, '20192', '+38.831813', '-077.288755', 'HERNDON', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(8289, '20193', '+38.831813', '-077.288755', 'RESTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(8290, '20194', '+38.980742', '-077.341878', 'RESTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8291, '20195', '+38.831813', '-077.288755', 'RESTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(8292, '20196', '+38.831813', '-077.288755', 'RESTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(8293, '20197', '+39.188205', '-077.630013', 'WATERFORD', 'VA', 'VIRGINIA', 'LOUDOUN', 'STANDARD'),
(8294, '20198', '+38.870681', '-077.760779', 'THE PLAINS', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(8295, '20199', '+39.085309', '-077.645224', 'DULLES', 'VA', 'VIRGINIA', 'LOUDOUN', 'UNIQUE'),
(8296, '20201', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8297, '20202', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8298, '20203', '+38.905317', '-077.046645', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8299, '20204', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8300, '20206', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8301, '20207', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8302, '20208', '+38.896611', '-077.011748', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8303, '20210', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8304, '20211', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8305, '20212', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8306, '20213', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8307, '20214', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8308, '20215', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8309, '20216', '+38.891911', '-077.014098', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8310, '20217', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8311, '20218', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8312, '20219', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8313, '20220', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8314, '20221', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8315, '20222', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8316, '20223', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8317, '20224', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8318, '20226', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8319, '20227', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8320, '20228', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8321, '20229', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8322, '20230', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8323, '20231', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8324, '20232', '+38.900561', '-077.039099', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8325, '20233', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8326, '20235', '+38.915361', '-077.057199', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8327, '20237', '', '', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8328, '20238', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8329, '20239', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8330, '20240', '+38.897143', '-077.040895', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8331, '20241', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8332, '20242', '+38.867812', '-077.028948', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8333, '20244', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8334, '20245', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8335, '20250', '+38.887323', '-077.032740', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8336, '20251', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8337, '20254', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8338, '20260', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8339, '20261', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8340, '20262', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8341, '20265', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8342, '20266', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8343, '20268', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8344, '20270', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8345, '20277', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8346, '20289', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8347, '20299', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8348, '20301', '+38.889357', '-077.031113', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8349, '20303', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8350, '20306', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8351, '20307', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8352, '20310', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8353, '20314', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8354, '20315', '+38.928861', '-077.017948', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8355, '20317', '+38.931161', '-077.010298', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8356, '20318', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8357, '20319', '+38.866745', '-077.016556', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8358, '20330', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8359, '20332', '+38.834563', '-077.015848', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8360, '20336', '+38.860415', '-077.022545', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8361, '20337', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8362, '20338', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8363, '20340', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8364, '20350', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8365, '20370', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8366, '20372', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8367, '20373', '+38.893311', '-077.014647', 'ANACOSTIA ANNEX', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8368, '20374', '+38.855522', '-077.002197', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8369, '20375', '+38.826163', '-077.017448', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8370, '20376', '', '', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8371, '20380', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8372, '20388', '+38.872553', '-076.996605', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8373, '20389', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8374, '20390', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8375, '20391', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8376, '20392', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8377, '20393', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8378, '20394', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8379, '20395', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8380, '20398', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8381, '20401', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8382, '20402', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8383, '20403', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8384, '20404', '+38.899161', '-077.008948', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8385, '20405', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8386, '20406', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8387, '20407', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8388, '20408', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8389, '20409', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8390, '20410', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8391, '20411', '+38.883962', '-077.022098', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8392, '20412', '+38.895261', '-077.022098', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8393, '20413', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8394, '20414', '+38.883962', '-077.022098', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8395, '20415', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8396, '20416', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8397, '20418', '+38.904253', '-077.057230', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8398, '20419', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8399, '20420', '+38.903461', '-077.027648', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8400, '20421', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8401, '20422', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8402, '20423', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8403, '20424', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8404, '20425', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8405, '20426', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8406, '20427', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8407, '20428', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8408, '20429', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8409, '20431', '+38.898618', '-077.042753', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8410, '20433', '+38.899996', '-077.041976', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8411, '20434', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8412, '20435', '+38.899399', '-077.040319', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8413, '20436', '+38.895927', '-077.021068', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8414, '20437', '+38.902761', '-077.048499', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8415, '20439', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8416, '20440', '+38.913911', '-077.045349', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8417, '20441', '+38.923861', '-077.036349', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8418, '20442', '+38.895977', '-077.017668', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8419, '20444', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8420, '20447', '+38.884712', '-077.025198', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8421, '20451', '+38.897711', '-077.044449', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8422, '20453', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8423, '20456', '+38.898111', '-077.040149', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8424, '20460', '+38.876362', '-077.018798', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8425, '20463', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8426, '20468', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8427, '20469', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8428, '20470', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8429, '20472', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8430, '20500', '', '', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'STANDARD'),
(8431, '20501', '+38.898720', '-077.036198', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8432, '20502', '+38.898720', '-077.036198', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8433, '20503', '+38.900711', '-077.043068', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8434, '20504', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8435, '20505', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8436, '20506', '+38.899364', '-077.037668', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8437, '20507', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8438, '20508', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8439, '20510', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8440, '20515', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8441, '20520', '+38.893217', '-077.048957', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8442, '20521', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8443, '20522', '+38.893217', '-077.048957', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8444, '20523', '+38.894490', '-077.047807', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8445, '20524', '+38.902414', '-077.032601', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8446, '20525', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8447, '20526', '+38.902217', '-077.043738', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8448, '20527', '+38.902933', '-077.036091', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8449, '20530', '+38.897561', '-077.026998', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8450, '20531', '+38.893761', '-077.021848', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8451, '20532', '+38.904486', '-077.017291', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8452, '20533', '+38.901102', '-077.032591', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8453, '20534', '+38.894075', '-077.012540', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8454, '20535', '+38.894097', '-077.025133', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8455, '20536', '+38.901211', '-077.016948', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8456, '20537', '+38.894097', '-077.025133', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8457, '20538', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8458, '20539', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8459, '20540', '+38.887405', '-077.004663', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8460, '20541', '+38.887405', '-077.004663', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8461, '20542', '+38.940761', '-077.028348', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8462, '20543', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8463, '20544', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8464, '20546', '+38.890976', '-077.021092', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8465, '20547', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8466, '20548', '+38.898111', '-077.017698', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8467, '20549', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8468, '20550', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8469, '20551', '+38.891995', '-077.045219', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(8470, '20552', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8471, '20553', '+38.887333', '-077.023118', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8472, '20554', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8473, '20555', '+38.900011', '-077.040149', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8474, '20557', '+38.887405', '-077.004663', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8475, '20558', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8476, '20559', '+38.887405', '-077.004663', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8477, '20560', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8478, '20565', '+38.891941', '-077.018853', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8479, '20566', '+38.897074', '-077.055350', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8480, '20570', '+38.899061', '-077.040149', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8481, '20571', '+38.900559', '-077.034554', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8482, '20572', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8483, '20573', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8484, '20575', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8485, '20576', '+38.893662', '-077.023592', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8486, '20577', '+38.900758', '-077.034455', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8487, '20578', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8488, '20579', '+38.904311', '-077.044649', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8489, '20580', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8490, '20581', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8491, '20585', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8492, '20586', '+38.902211', '-077.047399', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8493, '20590', '+38.883962', '-077.022098', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8494, '20591', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8495, '20593', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8496, '20594', '+38.884940', '-077.018372', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8497, '20597', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8498, '20599', '+38.893311', '-077.014647', 'WASHINGTON', 'DC', 'D.C.', 'DISTRICT OF COLUMBIA', 'UNIQUE'),
(8499, '20601', '+38.603783', '-076.867928', 'WALDORF', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8500, '20602', '+38.518559', '-076.912165', 'WALDORF', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8501, '20603', '+38.521150', '-077.062012', 'WALDORF', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8502, '20604', '+38.509548', '-076.981651', 'WALDORF', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8503, '20606', '+38.247149', '-076.748088', 'ABELL', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8504, '20607', '+38.666071', '-076.998396', 'ACCOKEEK', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8505, '20608', '+38.588843', '-076.712639', 'AQUASCO', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8506, '20609', '+38.300217', '-076.743445', 'AVENUE', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8507, '20610', '+38.444727', '-076.533026', 'BARSTOW', 'MD', 'MARYLAND', 'CALVERT', 'PO BOX ONLY'),
(8508, '20611', '+38.454919', '-076.980364', 'BEL ALTON', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8509, '20612', '+38.508689', '-076.687344', 'BENEDICT', 'MD', 'MARYLAND', 'CHARLES', 'PO BOX ONLY'),
(8510, '20613', '+38.658807', '-076.824293', 'BRANDYWINE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8511, '20615', '+38.493984', '-076.567469', 'BROOMES ISLAND', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8512, '20616', '+38.636227', '-077.084649', 'BRYANS ROAD', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8513, '20617', '+38.536256', '-076.853752', 'BRYANTOWN', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8514, '20618', '+38.309507', '-076.763069', 'BUSHWOOD', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8515, '20619', '+38.324994', '-076.637383', 'CALIFORNIA', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8516, '20620', '+38.347927', '-076.621613', 'CALLAWAY', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8517, '20621', '+38.350987', '-076.783288', 'CHAPTICO', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8518, '20622', '+38.484421', '-076.754943', 'CHARLOTTE HALL', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8519, '20623', '+38.745514', '-076.840572', 'CHELTENHAM', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8520, '20624', '+38.329424', '-076.730799', 'CLEMENTS', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8521, '20625', '+38.262037', '-076.850190', 'COBB ISLAND', 'MD', 'MARYLAND', 'CHARLES', 'PO BOX ONLY'),
(8522, '20626', '+38.236645', '-076.762227', 'COLTONS POINT', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8523, '20627', '+38.276828', '-076.703971', 'COMPTON', 'MD', 'MARYLAND', 'SAINT MARYS', 'PO BOX ONLY'),
(8524, '20628', '+38.148114', '-076.359651', 'DAMERON', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8525, '20629', '+38.376974', '-076.434476', 'DOWELL', 'MD', 'MARYLAND', 'CALVERT', 'PO BOX ONLY'),
(8526, '20630', '+38.178948', '-076.474510', 'DRAYDEN', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8527, '20632', '+38.421762', '-076.948718', 'FAULKNER', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8528, '20634', '+38.242387', '-076.501513', 'GREAT MILLS', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8529, '20635', '+38.312112', '-076.607676', 'HELEN', 'MD', 'MARYLAND', 'SAINT MARYS', 'PO BOX ONLY'),
(8530, '20636', '+38.342437', '-076.569163', 'HOLLYWOOD', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8531, '20637', '+38.520572', '-076.781313', 'HUGHESVILLE', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8532, '20639', '+38.519368', '-076.546326', 'HUNTINGTOWN', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8533, '20640', '+38.453999', '-077.052819', 'INDIAN HEAD', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8534, '20643', '+38.503876', '-077.148283', 'IRONSIDES', 'MD', 'MARYLAND', 'CHARLES', 'PO BOX ONLY'),
(8535, '20645', '+38.298477', '-076.884910', 'ISSUE', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8536, '20646', '+38.513875', '-077.010340', 'LA PLATA', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8537, '20650', '+38.278757', '-076.655917', 'LEONARDTOWN', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8538, '20653', '+38.232909', '-076.430853', 'LEXINGTON PARK', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8539, '20656', '+38.359274', '-076.683325', 'LOVEVILLE', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8540, '20657', '+38.493430', '-076.459768', 'LUSBY', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8541, '20658', '+38.563331', '-077.159621', 'MARBURY', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8542, '20659', '+38.279211', '-076.608406', 'MECHANICSVILLE', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8543, '20660', '+38.363994', '-076.694102', 'MORGANZA', 'MD', 'MARYLAND', 'SAINT MARYS', 'PO BOX ONLY'),
(8544, '20661', '+38.343591', '-076.884559', 'MOUNT VICTORIA', 'MD', 'MARYLAND', 'CHARLES', 'PO BOX ONLY'),
(8545, '20662', '+38.430568', '-077.192545', 'NANJEMOY', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8546, '20664', '+38.364718', '-076.917398', 'NEWBURG', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8547, '20667', '+38.216529', '-076.433445', 'PARK HALL', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8548, '20670', '+38.281094', '-076.420952', 'PATUXENT RIVER', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8549, '20674', '+38.168630', '-076.498367', 'PINEY POINT', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8550, '20675', '+38.576096', '-077.015916', 'POMFRET', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8551, '20676', '+38.560231', '-076.531761', 'PORT REPUBLIC', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8552, '20677', '+38.504699', '-077.037862', 'PORT TOBACCO', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8553, '20678', '+38.511282', '-076.528578', 'PRINCE FREDERICK', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8554, '20680', '+38.122181', '-076.369412', 'RIDGE', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8555, '20682', '+38.283551', '-076.848093', 'ROCK POINT', 'MD', 'MARYLAND', 'CHARLES', 'PO BOX ONLY'),
(8556, '20684', '+38.141377', '-076.385350', 'SAINT INIGOES', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8557, '20685', '+38.440484', '-076.517360', 'SAINT LEONARD', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8558, '20686', '+38.188796', '-076.420738', 'SAINT MARYS CITY', 'MD', 'MARYLAND', 'SAINT MARYS', 'PO BOX ONLY'),
(8559, '20687', '+38.078898', '-076.351659', 'SCOTLAND', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8560, '20688', '+38.377410', '-076.440937', 'SOLOMONS', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8561, '20689', '+38.556448', '-076.541436', 'SUNDERLAND', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8562, '20690', '+38.160744', '-076.525504', 'TALL TIMBERS', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8563, '20692', '+38.192688', '-076.501604', 'VALLEY LEE', 'MD', 'MARYLAND', 'SAINT MARYS', 'STANDARD'),
(8564, '20693', '+38.476246', '-077.084009', 'WELCOME', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8565, '20695', '+38.597440', '-076.990278', 'WHITE PLAINS', 'MD', 'MARYLAND', 'CHARLES', 'STANDARD'),
(8566, '20697', '+38.833563', '-076.877743', 'SOUTHERN MD FACILITY', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'UNIQUE'),
(8567, '20701', '+39.133200', '-076.798843', 'ANNAPOLIS JUNCTION', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8568, '20703', '+38.833563', '-076.877743', 'LANHAM', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8569, '20704', '+38.833563', '-076.877743', 'BELTSVILLE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8570, '20705', '+39.044858', '-076.886795', 'BELTSVILLE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8571, '20706', '+38.960760', '-076.856135', 'LANHAM', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8572, '20707', '+39.093136', '-076.881945', 'LAUREL', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8573, '20708', '+39.049859', '-076.834493', 'LAUREL', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8574, '20709', '+38.833563', '-076.877743', 'LAUREL', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8575, '20710', '+38.901211', '-076.925943', 'BLADENSBURG', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8576, '20711', '+38.802263', '-076.645735', 'LOTHIAN', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8577, '20712', '+38.942660', '-076.967057', 'MOUNT RAINIER', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8578, '20714', '+38.610496', '-076.595901', 'NORTH BEACH', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8579, '20715', '+38.982612', '-076.743790', 'BOWIE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8580, '20716', '+38.926311', '-076.709789', 'BOWIE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8581, '20717', '+38.833563', '-076.877743', 'BOWIE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8582, '20718', '+38.833563', '-076.877743', 'BOWIE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8583, '20719', '+38.833563', '-076.877743', 'BOWIE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8584, '20720', '+38.988510', '-076.790980', 'BOWIE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8585, '20721', '+38.919357', '-076.787141', 'BOWIE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8586, '20722', '+38.886849', '-076.865764', 'BRENTWOOD', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8587, '20723', '+39.136520', '-076.868729', 'LAUREL', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8588, '20724', '+39.098008', '-076.804443', 'LAUREL', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8589, '20725', '+38.833563', '-076.877743', 'LAUREL', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8590, '20726', '+38.833563', '-076.877743', 'LAUREL', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8591, '20731', '+38.833563', '-076.877743', 'CAPITOL HEIGHTS', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8592, '20732', '+38.565841', '-076.526169', 'CHESAPEAKE BEACH', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8593, '20733', '+38.921313', '-076.532569', 'CHURCHTON', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8594, '20735', '+38.739765', '-076.912096', 'CLINTON', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8595, '20736', '+38.548775', '-076.562876', 'OWINGS', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8596, '20737', '+38.963206', '-076.917795', 'RIVERDALE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8597, '20738', '+38.833563', '-076.877743', 'RIVERDALE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8598, '20740', '+38.979495', '-076.895852', 'COLLEGE PARK', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8599, '20741', '+38.833563', '-076.877743', 'COLLEGE PARK', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8600, '20742', '+38.833563', '-076.877743', 'COLLEGE PARK', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'UNIQUE'),
(8601, '20743', '+38.889711', '-076.892544', 'CAPITOL HEIGHTS', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8602, '20744', '+38.757114', '-076.977596', 'FORT WASHINGTON', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8603, '20745', '+38.814362', '-076.957746', 'OXON HILL', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8604, '20746', '+38.834912', '-076.912745', 'SUITLAND', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8605, '20747', '+38.851262', '-076.885744', 'DISTRICT HEIGHTS', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8606, '20748', '+38.817263', '-076.935795', 'TEMPLE HILLS', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8607, '20749', '+38.833563', '-076.877743', 'FORT WASHINGTON', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8608, '20750', '+38.833563', '-076.877743', 'OXON HILL', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8609, '20751', '+38.960712', '-076.621708', 'DEALE', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8610, '20752', '+38.833563', '-076.877743', 'SUITLAND', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8611, '20753', '+38.833563', '-076.877743', 'DISTRICT HEIGHTS', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8612, '20754', '+38.604072', '-076.604364', 'DUNKIRK', 'MD', 'MARYLAND', 'CALVERT', 'STANDARD'),
(8613, '20755', '+39.154307', '-076.691190', 'FORT GEORGE G MEADE', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8614, '20757', '+38.833563', '-076.877743', 'TEMPLE HILLS', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8615, '20758', '+38.736079', '-076.583547', 'FRIENDSHIP', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8616, '20759', '+39.160806', '-076.927881', 'FULTON', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8617, '20762', '+38.806207', '-076.875551', 'ANDREWS AIR FORCE BASE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8618, '20763', '+39.136189', '-076.815044', 'SAVAGE', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8619, '20764', '+38.965727', '-076.589086', 'SHADY SIDE', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8620, '20765', '+38.974512', '-076.545083', 'GALESVILLE', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'PO BOX ONLY'),
(8621, '20768', '+38.833563', '-076.877743', 'GREENBELT', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8622, '20769', '+38.983460', '-076.811392', 'GLENN DALE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8623, '20770', '+38.995909', '-076.880966', 'GREENBELT', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8624, '20771', '+38.833563', '-076.877743', 'GREENBELT', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'UNIQUE'),
(8625, '20772', '+38.816171', '-076.786093', 'UPPER MARLBORO', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8626, '20773', '+38.833563', '-076.877743', 'UPPER MARLBORO', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8627, '20774', '+38.868212', '-076.815591', 'UPPER MARLBORO', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8628, '20775', '+38.833563', '-076.877743', 'UPPER MARLBORO', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8629, '20776', '+38.962992', '-076.564785', 'HARWOOD', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8630, '20777', '+39.173059', '-076.966718', 'HIGHLAND', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8631, '20778', '+39.002411', '-076.563885', 'WEST RIVER', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8632, '20779', '+38.942878', '-076.558783', 'TRACYS LANDING', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8633, '20781', '+38.941610', '-076.937446', 'HYATTSVILLE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8634, '20782', '+38.912211', '-076.967247', 'HYATTSVILLE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8635, '20783', '+39.000509', '-076.972297', 'HYATTSVILLE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8636, '20784', '+38.951310', '-076.895795', 'HYATTSVILLE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8637, '20785', '+38.922261', '-076.875494', 'HYATTSVILLE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8638, '20787', '+38.987070', '-076.982405', 'HYATTSVILLE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8639, '20788', '+38.969434', '-076.950913', 'HYATTSVILLE', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8640, '20790', '+38.833563', '-076.877743', 'CAPITOL HEIGHTS', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'UNIQUE'),
(8641, '20791', '+38.833563', '-076.877743', 'CAPITOL HEIGHTS', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'PO BOX ONLY'),
(8642, '20792', '', '', 'UPPER MARLBORO', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'STANDARD'),
(8643, '20794', '+39.155266', '-076.813394', 'JESSUP', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8644, '20797', '+38.833563', '-076.877743', 'SOUTHERN MD FACILITY', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'UNIQUE'),
(8645, '20799', '+38.833563', '-076.877743', 'CAPITOL HEIGHTS', 'MD', 'MARYLAND', 'PRINCE GEORGES', 'UNIQUE'),
(8646, '20812', '+38.968510', '-077.140801', 'GLEN ECHO', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8647, '20813', '+39.143979', '-077.207617', 'BETHESDA', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8648, '20814', '+39.004520', '-077.104600', 'BETHESDA', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8649, '20815', '+38.983759', '-077.079449', 'CHEVY CHASE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8650, '20816', '+38.955907', '-077.116500', 'BETHESDA', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8651, '20817', '+38.989586', '-077.153801', 'BETHESDA', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8652, '20818', '+39.128407', '-077.180053', 'CABIN JOHN', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8653, '20824', '+39.143979', '-077.207617', 'BETHESDA', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8654, '20825', '+39.143979', '-077.207617', 'CHEVY CHASE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8655, '20827', '+39.143979', '-077.207617', 'BETHESDA', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8656, '20830', '+39.155220', '-077.066745', 'OLNEY', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8657, '20832', '+39.150364', '-077.077651', 'OLNEY', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8658, '20833', '+39.204341', '-077.050550', 'BROOKEVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8659, '20837', '+39.123705', '-077.403211', 'POOLESVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8660, '20838', '+39.228424', '-077.370970', 'BARNESVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8661, '20839', '+39.178770', '-077.419605', 'BEALLSVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8662, '20841', '+39.184675', '-077.328764', 'BOYDS', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8663, '20842', '+39.191093', '-077.421929', 'DICKERSON', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8664, '20847', '+39.143979', '-077.207617', 'ROCKVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8665, '20848', '+39.143979', '-077.207617', 'ROCKVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8666, '20849', '+39.143979', '-077.207617', 'ROCKVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8667, '20850', '+39.089557', '-077.184127', 'ROCKVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8668, '20851', '+39.077858', '-077.125751', 'ROCKVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8669, '20852', '+39.052158', '-077.121096', 'ROCKVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8670, '20853', '+39.107357', '-077.099600', 'ROCKVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8671, '20854', '+39.029839', '-077.234792', 'POTOMAC', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8672, '20855', '+39.142857', '-077.138145', 'DERWOOD', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8673, '20857', '+39.143979', '-077.207617', 'ROCKVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'UNIQUE'),
(8674, '20859', '+39.143979', '-077.207617', 'POTOMAC', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8675, '20860', '+39.142424', '-077.044614', 'SANDY SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8676, '20861', '+39.151468', '-076.994498', 'ASHTON', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8677, '20862', '+39.175506', '-077.020626', 'BRINKLOW', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8678, '20866', '+39.105644', '-076.935861', 'BURTONSVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8679, '20868', '+39.122262', '-076.972157', 'SPENCERVILLE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8680, '20871', '+39.207775', '-077.259816', 'CLARKSBURG', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8681, '20872', '+39.285477', '-077.215203', 'DAMASCUS', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8682, '20874', '+39.135512', '-077.282223', 'GERMANTOWN', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8683, '20875', '+39.143979', '-077.207617', 'GERMANTOWN', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8684, '20876', '+39.210218', '-077.239729', 'GERMANTOWN', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8685, '20877', '+39.139336', '-077.182953', 'GAITHERSBURG', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8686, '20878', '+39.091857', '-077.198452', 'GAITHERSBURG', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8687, '20879', '+39.173000', '-077.185542', 'GAITHERSBURG', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8688, '20880', '+39.138815', '-077.172591', 'WASHINGTON GROVE', 'MD', 'MARYLAND', 'MONTGOMERY', 'PO BOX ONLY'),
(8689, '20882', '+39.233512', '-077.145781', 'GAITHERSBURG', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8690, '20883', '', '', 'GAITHERSBURG', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8691, '20884', '+39.143979', '-077.207617', 'GAITHERSBURG', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8692, '20885', '+39.187421', '-077.202798', 'GAITHERSBURG', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8693, '20886', '+39.175703', '-077.187250', 'MONTGOMERY VILLAGE', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8694, '20889', '+39.143979', '-077.207617', 'BETHESDA', 'MD', 'MARYLAND', 'MONTGOMERY', 'UNIQUE'),
(8695, '20891', '+39.143979', '-077.207617', 'KENSINGTON', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8696, '20892', '+39.002375', '-077.103410', 'BETHESDA', 'MD', 'MARYLAND', 'MONTGOMERY', 'UNIQUE'),
(8697, '20894', '+39.143979', '-077.207617', 'BETHESDA', 'MD', 'MARYLAND', 'MONTGOMERY', 'UNIQUE'),
(8698, '20895', '+39.095380', '-077.111555', 'KENSINGTON', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8699, '20896', '+39.036496', '-077.093100', 'GARRETT PARK', 'MD', 'MARYLAND', 'MONTGOMERY', 'PO BOX ONLY'),
(8700, '20897', '+39.143979', '-077.207617', 'SUBURB MARYLAND FAC', 'MD', 'MARYLAND', 'MONTGOMERY', 'UNIQUE'),
(8701, '20898', '+39.143979', '-077.207617', 'GAITHERSBURG', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8702, '20899', '+39.140324', '-077.221984', 'GAITHERSBURG', 'MD', 'MARYLAND', 'MONTGOMERY', 'UNIQUE'),
(8703, '20901', '+39.036289', '-077.010948', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8704, '20902', '+39.039974', '-077.044449', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8705, '20903', '+39.015209', '-076.980597', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8706, '20904', '+39.066844', '-076.996866', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8707, '20905', '+39.114753', '-077.005870', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8708, '20906', '+39.083978', '-077.061278', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8709, '20907', '+39.143979', '-077.207617', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8710, '20908', '+39.143979', '-077.207617', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8711, '20910', '+39.003109', '-077.029648', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8712, '20911', '+39.143979', '-077.207617', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8713, '20912', '+38.982360', '-077.005798', 'TAKOMA PARK', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8714, '20913', '+38.833563', '-076.877743', 'TAKOMA PARK', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8715, '20914', '+39.143979', '-077.207617', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8716, '20915', '+39.143979', '-077.207617', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8717, '20916', '+39.143979', '-077.207617', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8718, '20918', '+39.143979', '-077.207617', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'STANDARD'),
(8719, '20997', '+39.143979', '-077.207617', 'SILVER SPRING', 'MD', 'MARYLAND', 'MONTGOMERY', 'UNIQUE'),
(8720, '21001', '+39.499909', '-076.231177', 'ABERDEEN', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8721, '21005', '+39.477062', '-076.120824', 'ABERDEEN PROVING GROUND', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8722, '21009', '+39.472579', '-076.277279', 'ABINGDON', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8723, '21010', '+39.380158', '-076.295468', 'GUNPOWDER', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8724, '21012', '+39.031461', '-076.623203', 'ARNOLD', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8725, '21013', '+39.496406', '-076.486624', 'BALDWIN', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8726, '21014', '+39.547557', '-076.321984', 'BEL AIR', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8727, '21015', '+39.551757', '-076.298713', 'BEL AIR', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8728, '21017', '+39.473660', '-076.238835', 'BELCAMP', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8729, '21018', '+39.509276', '-076.385083', 'BENSON', 'MD', 'MARYLAND', 'HARFORD', 'PO BOX ONLY'),
(8730, '21020', '+39.521276', '-076.804699', 'BORING', 'MD', 'MARYLAND', 'BALTIMORE', 'PO BOX ONLY'),
(8731, '21022', '+39.397861', '-076.671742', 'BROOKLANDVILLE', 'MD', 'MARYLAND', 'BALTIMORE', 'PO BOX ONLY'),
(8732, '21023', '+39.532955', '-076.743196', 'BUTLER', 'MD', 'MARYLAND', 'BALTIMORE', 'PO BOX ONLY'),
(8733, '21027', '+39.438964', '-076.592139', 'CHASE', 'MD', 'MARYLAND', 'BALTIMORE', 'PO BOX ONLY'),
(8734, '21028', '+39.563172', '-076.236427', 'CHURCHVILLE', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8735, '21029', '+39.212456', '-076.951498', 'CLARKSVILLE', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8736, '21030', '+39.491227', '-076.664077', 'COCKEYSVILLE', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8737, '21031', '+39.480493', '-076.655257', 'HUNT VALLEY', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8738, '21032', '+39.018110', '-076.588272', 'CROWNSVILLE', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8739, '21034', '+39.646205', '-076.226377', 'DARLINGTON', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8740, '21035', '+39.042960', '-076.628630', 'DAVIDSONVILLE', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8741, '21036', '+39.240155', '-077.003750', 'DAYTON', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8742, '21037', '+38.975128', '-076.623684', 'EDGEWATER', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8743, '21040', '+39.434799', '-076.293579', 'EDGEWOOD', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8744, '21041', '+39.236405', '-076.941902', 'ELLICOTT CITY', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8745, '21042', '+39.261897', '-076.897247', 'ELLICOTT CITY', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8746, '21043', '+39.254833', '-076.800124', 'ELLICOTT CITY', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8747, '21044', '+39.206132', '-076.887905', 'COLUMBIA', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8748, '21045', '+39.207806', '-076.825475', 'COLUMBIA', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8749, '21046', '+39.175406', '-076.834945', 'COLUMBIA', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8750, '21047', '+39.531206', '-076.439035', 'FALLSTON', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8751, '21048', '+39.499102', '-076.910108', 'FINKSBURG', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(8752, '21050', '+39.587155', '-076.392733', 'FOREST HILL', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8753, '21051', '+39.473140', '-076.448385', 'FORK', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8754, '21052', '+39.206998', '-076.445599', 'FORT HOWARD', 'MD', 'MARYLAND', 'BALTIMORE', 'PO BOX ONLY'),
(8755, '21053', '+39.687103', '-076.717644', 'FREELAND', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8756, '21054', '+39.048359', '-076.631238', 'GAMBRILLS', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8757, '21055', '+39.438964', '-076.592139', 'GARRISON', 'MD', 'MARYLAND', 'BALTIMORE', 'PO BOX ONLY'),
(8758, '21056', '+39.086064', '-076.545474', 'GIBSON ISLAND', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'PO BOX ONLY'),
(8759, '21057', '+39.451006', '-076.501186', 'GLEN ARM', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8760, '21060', '+39.170158', '-076.579836', 'GLEN BURNIE', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8761, '21061', '+38.967943', '-076.615637', 'GLEN BURNIE', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8762, '21062', '+38.974203', '-076.594942', 'GLEN BURNIE', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'UNIQUE'),
(8763, '21071', '+39.515748', '-076.766097', 'GLYNDON', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8764, '21074', '+39.614552', '-076.864427', 'HAMPSTEAD', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(8765, '21075', '+39.205756', '-076.753093', 'ELKRIDGE', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(8766, '21076', '+39.057694', '-076.615557', 'HANOVER', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8767, '21077', '+38.947102', '-076.629277', 'HARMANS', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8768, '21078', '+39.560095', '-076.155170', 'HAVRE DE GRACE', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8769, '21080', '+39.534703', '-077.049302', 'HENRYTON', 'MD', 'MARYLAND', 'CARROLL', 'PO BOX ONLY'),
(8770, '21082', '+39.481685', '-076.471736', 'HYDES', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8771, '21084', '+39.552706', '-076.419734', 'JARRETTSVILLE', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8772, '21085', '+39.449157', '-076.351881', 'JOPPA', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8773, '21087', '+39.445257', '-076.421783', 'KINGSVILLE', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8774, '21088', '+39.534703', '-077.049302', 'LINEBORO', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(8775, '21090', '+39.068309', '-076.631743', 'LINTHICUM HEIGHTS', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8776, '21092', '+39.438964', '-076.592139', 'LONG GREEN', 'MD', 'MARYLAND', 'BALTIMORE', 'PO BOX ONLY'),
(8777, '21093', '+39.433206', '-076.654593', 'LUTHERVILLE TIMONIUM', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8778, '21094', '+39.438964', '-076.592139', 'LUTHERVILLE TIMONIUM', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8779, '21098', '+38.974203', '-076.594942', 'HANOVER', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'UNIQUE'),
(8780, '21102', '+39.556164', '-076.870849', 'MANCHESTER', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(8781, '21104', '+39.378104', '-076.916267', 'MARRIOTTSVILLE', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(8782, '21105', '+39.711379', '-076.659492', 'MARYLAND LINE', 'MD', 'MARYLAND', 'BALTIMORE', 'PO BOX ONLY'),
(8783, '21106', '+38.971475', '-076.580934', 'MAYO', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'PO BOX ONLY'),
(8784, '21108', '+38.986961', '-076.582479', 'MILLERSVILLE', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8785, '21111', '+39.566189', '-076.597891', 'MONKTON', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8786, '21113', '+38.975412', '-076.586886', 'ODENTON', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8787, '21114', '+39.064360', '-076.622577', 'CROFTON', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8788, '21117', '+39.429055', '-076.787696', 'OWINGS MILLS', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8789, '21120', '+39.642203', '-076.673693', 'PARKTON', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8790, '21122', '+38.976813', '-076.616185', 'PASADENA', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8791, '21123', '+38.974203', '-076.594942', 'PASADENA', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8792, '21128', '+39.404757', '-076.450084', 'PERRY HALL', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8793, '21130', '+39.471559', '-076.211676', 'PERRYMAN', 'MD', 'MARYLAND', 'HARFORD', 'PO BOX ONLY'),
(8794, '21131', '+39.483255', '-076.577619', 'PHOENIX', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8795, '21132', '+39.692854', '-076.421834', 'PYLESVILLE', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8796, '21133', '+39.377872', '-076.816675', 'RANDALLSTOWN', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8797, '21136', '+39.487615', '-076.796347', 'REISTERSTOWN', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8798, '21139', '+39.438964', '-076.592139', 'RIDERWOOD', 'MD', 'MARYLAND', 'BALTIMORE', 'PO BOX ONLY'),
(8799, '21140', '+39.031943', '-076.625199', 'RIVA', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8800, '21144', '+38.983971', '-076.623121', 'SEVERN', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8801, '21146', '+38.951199', '-076.603722', 'SEVERNA PARK', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8802, '21150', '+39.236405', '-076.941902', 'SIMPSONVILLE', 'MD', 'MARYLAND', 'HOWARD', 'PO BOX ONLY'),
(8803, '21152', '+39.526441', '-076.715587', 'SPARKS GLENCOE', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8804, '21153', '+39.412905', '-076.730345', 'STEVENSON', 'MD', 'MARYLAND', 'BALTIMORE', 'PO BOX ONLY'),
(8805, '21154', '+39.657355', '-076.371332', 'STREET', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8806, '21155', '+39.567574', '-076.797213', 'UPPERCO', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8807, '21156', '+39.461038', '-076.583163', 'UPPER FALLS', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8808, '21157', '+39.564201', '-076.980701', 'WESTMINSTER', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(8809, '21158', '+39.606981', '-077.029403', 'WESTMINSTER', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(8810, '21160', '+39.703155', '-076.330641', 'WHITEFORD', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8811, '21161', '+39.658104', '-076.527937', 'WHITE HALL', 'MD', 'MARYLAND', 'HARFORD', 'STANDARD'),
(8812, '21162', '+39.389457', '-076.411976', 'WHITE MARSH', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8813, '21163', '+39.349834', '-076.845587', 'WOODSTOCK', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8814, '21201', '+39.296536', '-076.623489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8815, '21202', '+39.295907', '-076.608438', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8816, '21203', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8817, '21204', '+39.407156', '-076.603790', 'TOWSON', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8818, '21205', '+39.302757', '-076.567987', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8819, '21206', '+39.336857', '-076.553237', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8820, '21207', '+39.325605', '-076.736594', 'GWYNN OAK', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8821, '21208', '+39.385156', '-076.727036', 'PIKESVILLE', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8822, '21209', '+39.354256', '-076.667892', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8823, '21210', '+39.352356', '-076.633290', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8824, '21211', '+39.327889', '-076.638990', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8825, '21212', '+39.356206', '-076.610989', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8826, '21213', '+39.306606', '-076.603338', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8827, '21214', '+39.350006', '-076.562187', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8828, '21215', '+39.343306', '-076.681192', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8829, '21216', '+39.310756', '-076.674792', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8830, '21217', '+39.308606', '-076.637490', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8831, '21218', '+39.328456', '-076.599139', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8832, '21219', '+39.229611', '-076.445532', 'SPARROWS POINT', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8833, '21220', '+39.344057', '-076.505086', 'MIDDLE RIVER', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8834, '21221', '+39.296007', '-076.559787', 'ESSEX', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8835, '21222', '+39.325991', '-076.451733', 'DUNDALK', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8836, '21223', '+39.279506', '-076.650140', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8837, '21224', '+39.279207', '-076.557237', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8838, '21225', '+39.018973', '-076.616437', 'BROOKLYN', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8839, '21226', '+39.068710', '-076.584137', 'CURTIS BAY', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8840, '21227', '+39.241606', '-076.677291', 'HALETHORPE', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8841, '21228', '+39.274156', '-076.631074', 'CATONSVILLE', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8842, '21229', '+39.286613', '-076.652840', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8843, '21230', '+39.264548', '-076.622439', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8844, '21231', '+39.288757', '-076.592238', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8845, '21233', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8846, '21234', '+39.413106', '-076.530044', 'PARKVILLE', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8847, '21235', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8848, '21236', '+39.392107', '-076.489277', 'NOTTINGHAM', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8849, '21237', '+39.339957', '-076.488035', 'ROSEDALE', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8850, '21239', '+39.356356', '-076.587588', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8851, '21240', '+39.142793', '-076.651589', 'BALTIMORE', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8852, '21241', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8853, '21244', '+39.333105', '-076.784896', 'WINDSOR MILL', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8854, '21250', '+39.258226', '-076.713149', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE', 'UNIQUE'),
(8855, '21251', '+39.438964', '-076.592139', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE', 'UNIQUE'),
(8856, '21252', '+39.388799', '-076.613325', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE', 'UNIQUE'),
(8857, '21263', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8858, '21264', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8859, '21265', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8860, '21268', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8861, '21270', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8862, '21273', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8863, '21274', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8864, '21275', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8865, '21278', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8866, '21279', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8867, '21280', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8868, '21281', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8869, '21282', '+39.438964', '-076.592139', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8870, '21283', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8871, '21284', '+39.438964', '-076.592139', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8872, '21285', '+39.438964', '-076.592139', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8873, '21286', '+39.414306', '-076.576089', 'TOWSON', 'MD', 'MARYLAND', 'BALTIMORE', 'STANDARD'),
(8874, '21287', '+39.297457', '-076.592738', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8875, '21288', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8876, '21289', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8877, '21290', '+39.293256', '-076.623839', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8878, '21297', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'STANDARD'),
(8879, '21298', '+39.284707', '-076.620489', 'BALTIMORE', 'MD', 'MARYLAND', 'BALTIMORE CITY', 'UNIQUE'),
(8880, '21401', '+38.967311', '-076.610143', 'ANNAPOLIS', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8881, '21402', '+39.048110', '-076.452032', 'ANNAPOLIS', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8882, '21403', '+39.007361', '-076.584637', 'ANNAPOLIS', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8883, '21404', '+38.974203', '-076.594942', 'ANNAPOLIS', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8884, '21405', '+38.992124', '-076.506883', 'ANNAPOLIS', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'STANDARD'),
(8885, '21411', '+38.974203', '-076.594942', 'ANNAPOLIS', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'UNIQUE'),
(8886, '21412', '+38.974203', '-076.594942', 'ANNAPOLIS', 'MD', 'MARYLAND', 'ANNE ARUNDEL', 'UNIQUE'),
(8887, '21501', '+39.580691', '-078.690593', 'CUMBERLAND', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8888, '21502', '+39.599150', '-078.844425', 'CUMBERLAND', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8889, '21503', '+39.580691', '-078.690593', 'CUMBERLAND', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8890, '21504', '+39.580691', '-078.690593', 'CUMBERLAND', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8891, '21505', '+39.594043', '-078.843432', 'CUMBERLAND', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8892, '21520', '+39.589350', '-079.230969', 'ACCIDENT', 'MD', 'MARYLAND', 'GARRETT', 'STANDARD'),
(8893, '21521', '+39.536798', '-079.009008', 'BARTON', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8894, '21522', '+39.601664', '-079.233691', 'BITTINGER', 'MD', 'MARYLAND', 'GARRETT', 'STANDARD'),
(8895, '21523', '+39.486109', '-079.082970', 'BLOOMINGTON', 'MD', 'MARYLAND', 'GARRETT', 'STANDARD'),
(8896, '21524', '+39.696680', '-078.803067', 'CORRIGANVILLE', 'MD', 'MARYLAND', 'ALLEGANY', 'PO BOX ONLY'),
(8897, '21528', '+39.652837', '-078.901395', 'ECKHART MINES', 'MD', 'MARYLAND', 'ALLEGANY', 'PO BOX ONLY'),
(8898, '21529', '+39.708261', '-078.777446', 'ELLERSLIE', 'MD', 'MARYLAND', 'ALLEGANY', 'PO BOX ONLY'),
(8899, '21530', '+39.679418', '-078.524164', 'FLINTSTONE', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8900, '21531', '+39.637098', '-079.257117', 'FRIENDSVILLE', 'MD', 'MARYLAND', 'GARRETT', 'STANDARD'),
(8901, '21532', '+39.642060', '-078.912502', 'FROSTBURG', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8902, '21536', '+39.655141', '-079.124143', 'GRANTSVILLE', 'MD', 'MARYLAND', 'GARRETT', 'STANDARD'),
(8903, '21538', '+39.416917', '-079.222202', 'KITZMILLER', 'MD', 'MARYLAND', 'GARRETT', 'STANDARD'),
(8904, '21539', '+39.571706', '-078.934521', 'LONACONING', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8905, '21540', '+39.475381', '-079.058451', 'LUKE', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8906, '21541', '+39.565589', '-079.382332', 'MC HENRY', 'MD', 'MARYLAND', 'GARRETT', 'STANDARD'),
(8907, '21542', '+39.595113', '-078.943082', 'MIDLAND', 'MD', 'MARYLAND', 'ALLEGANY', 'PO BOX ONLY'),
(8908, '21543', '+39.633866', '-078.960403', 'MIDLOTHIAN', 'MD', 'MARYLAND', 'ALLEGANY', 'PO BOX ONLY'),
(8909, '21545', '+39.695649', '-078.872465', 'MOUNT SAVAGE', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8910, '21550', '+39.433920', '-079.316683', 'OAKLAND', 'MD', 'MARYLAND', 'GARRETT', 'STANDARD'),
(8911, '21555', '+39.596645', '-078.572564', 'OLDTOWN', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8912, '21556', '+39.572452', '-078.843962', 'PINTO', 'MD', 'MARYLAND', 'ALLEGANY', 'PO BOX ONLY'),
(8913, '21557', '+39.505820', '-078.921162', 'RAWLINGS', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8914, '21560', '+39.601008', '-078.687137', 'SPRING GAP', 'MD', 'MARYLAND', 'ALLEGANY', 'PO BOX ONLY'),
(8915, '21561', '+39.538568', '-079.190791', 'SWANTON', 'MD', 'MARYLAND', 'GARRETT', 'STANDARD'),
(8916, '21562', '+39.490547', '-079.013989', 'WESTERNPORT', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(8917, '21601', '+38.800714', '-076.051486', 'EASTON', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8918, '21606', '+38.758525', '-076.180166', 'EASTON', 'MD', 'MARYLAND', 'TALBOT', 'UNIQUE'),
(8919, '21607', '+39.073391', '-076.060665', 'BARCLAY', 'MD', 'MARYLAND', 'QUEEN ANNES', 'STANDARD'),
(8920, '21609', '+38.740562', '-075.958683', 'BETHLEHEM', 'MD', 'MARYLAND', 'CAROLINE', 'PO BOX ONLY'),
(8921, '21610', '+39.366812', '-076.067079', 'BETTERTON', 'MD', 'MARYLAND', 'KENT', 'STANDARD'),
(8922, '21612', '+38.749550', '-076.273704', 'BOZMAN', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8923, '21613', '+38.479813', '-076.079864', 'CAMBRIDGE', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8924, '21617', '+39.084003', '-076.091375', 'CENTREVILLE', 'MD', 'MARYLAND', 'QUEEN ANNES', 'STANDARD'),
(8925, '21619', '+38.946034', '-076.279172', 'CHESTER', 'MD', 'MARYLAND', 'QUEEN ANNES', 'STANDARD'),
(8926, '21620', '+39.235988', '-076.059316', 'CHESTERTOWN', 'MD', 'MARYLAND', 'KENT', 'STANDARD'),
(8927, '21622', '+38.415211', '-076.191021', 'CHURCH CREEK', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8928, '21623', '+39.130500', '-075.961404', 'CHURCH HILL', 'MD', 'MARYLAND', 'QUEEN ANNES', 'STANDARD'),
(8929, '21624', '+38.836766', '-076.271370', 'CLAIBORNE', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8930, '21625', '+38.869275', '-076.000119', 'CORDOVA', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8931, '21626', '+38.323604', '-076.097337', 'CRAPO', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8932, '21627', '+38.242608', '-076.053064', 'CROCHERON', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8933, '21628', '+39.231771', '-075.929797', 'CRUMPTON', 'MD', 'MARYLAND', 'QUEEN ANNES', 'PO BOX ONLY'),
(8934, '21629', '+38.859523', '-075.835702', 'DENTON', 'MD', 'MARYLAND', 'CAROLINE', 'STANDARD'),
(8935, '21631', '+38.579447', '-075.939691', 'EAST NEW MARKET', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8936, '21632', '+38.823318', '-075.825197', 'FEDERALSBURG', 'MD', 'MARYLAND', 'CAROLINE', 'STANDARD'),
(8937, '21634', '+38.298680', '-076.203532', 'FISHING CREEK', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8938, '21635', '+39.320381', '-075.836031', 'GALENA', 'MD', 'MARYLAND', 'KENT', 'STANDARD'),
(8939, '21636', '+39.022245', '-075.809462', 'GOLDSBORO', 'MD', 'MARYLAND', 'CAROLINE', 'STANDARD'),
(8940, '21638', '+39.019049', '-076.115897', 'GRASONVILLE', 'MD', 'MARYLAND', 'QUEEN ANNES', 'STANDARD'),
(8941, '21639', '+38.968592', '-075.790732', 'GREENSBORO', 'MD', 'MARYLAND', 'CAROLINE', 'STANDARD'),
(8942, '21640', '+39.081351', '-075.811781', 'HENDERSON', 'MD', 'MARYLAND', 'CAROLINE', 'STANDARD'),
(8943, '21641', '+38.920588', '-075.938770', 'HILLSBORO', 'MD', 'MARYLAND', 'CAROLINE', 'PO BOX ONLY'),
(8944, '21643', '+38.643824', '-075.863003', 'HURLOCK', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8945, '21644', '+39.118226', '-075.876881', 'INGLESIDE', 'MD', 'MARYLAND', 'QUEEN ANNES', 'STANDARD'),
(8946, '21645', '+39.313679', '-075.961520', 'KENNEDYVILLE', 'MD', 'MARYLAND', 'KENT', 'STANDARD'),
(8947, '21647', '+38.808497', '-076.287709', 'MCDANIEL', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8948, '21648', '+38.478205', '-076.241202', 'MADISON', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8949, '21649', '+39.106088', '-075.790870', 'MARYDEL', 'MD', 'MARYLAND', 'CAROLINE', 'STANDARD'),
(8950, '21650', '+39.308228', '-075.812769', 'MASSEY', 'MD', 'MARYLAND', 'KENT', 'STANDARD'),
(8951, '21651', '+39.274314', '-075.895115', 'MILLINGTON', 'MD', 'MARYLAND', 'KENT', 'STANDARD'),
(8952, '21652', '+38.795102', '-076.152762', 'NEAVITT', 'MD', 'MARYLAND', 'TALBOT', 'PO BOX ONLY'),
(8953, '21653', '+38.751834', '-076.178041', 'NEWCOMB', 'MD', 'MARYLAND', 'TALBOT', 'PO BOX ONLY'),
(8954, '21654', '+38.710783', '-076.125184', 'OXFORD', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8955, '21655', '+38.752146', '-075.907650', 'PRESTON', 'MD', 'MARYLAND', 'CAROLINE', 'STANDARD'),
(8956, '21656', '+39.034637', '-076.092127', 'PRICE', 'MD', 'MARYLAND', 'QUEEN ANNES', 'STANDARD'),
(8957, '21657', '+38.975882', '-075.975322', 'QUEEN ANNE', 'MD', 'MARYLAND', 'QUEEN ANNES', 'STANDARD');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(8958, '21658', '+39.002550', '-076.142374', 'QUEENSTOWN', 'MD', 'MARYLAND', 'QUEEN ANNES', 'STANDARD'),
(8959, '21659', '+38.561727', '-075.804650', 'RHODESDALE', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8960, '21660', '+38.874255', '-075.866707', 'RIDGELY', 'MD', 'MARYLAND', 'CAROLINE', 'STANDARD'),
(8961, '21661', '+39.117823', '-076.223193', 'ROCK HALL', 'MD', 'MARYLAND', 'KENT', 'STANDARD'),
(8962, '21662', '+38.713532', '-076.196838', 'ROYAL OAK', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8963, '21663', '+38.748765', '-076.167765', 'SAINT MICHAELS', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8964, '21664', '+38.600971', '-075.947375', 'SECRETARY', 'MD', 'MARYLAND', 'DORCHESTER', 'PO BOX ONLY'),
(8965, '21665', '+38.745387', '-076.326606', 'SHERWOOD', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8966, '21666', '+39.012075', '-076.115680', 'STEVENSVILLE', 'MD', 'MARYLAND', 'QUEEN ANNES', 'STANDARD'),
(8967, '21667', '+39.339906', '-076.047396', 'STILL POND', 'MD', 'MARYLAND', 'KENT', 'STANDARD'),
(8968, '21668', '+39.119123', '-076.031257', 'SUDLERSVILLE', 'MD', 'MARYLAND', 'QUEEN ANNES', 'STANDARD'),
(8969, '21669', '+38.453204', '-076.264100', 'TAYLORS ISLAND', 'MD', 'MARYLAND', 'DORCHESTER', 'PO BOX ONLY'),
(8970, '21670', '+38.889270', '-075.861191', 'TEMPLEVILLE', 'MD', 'MARYLAND', 'CAROLINE', 'PO BOX ONLY'),
(8971, '21671', '+38.704729', '-076.332647', 'TILGHMAN', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8972, '21672', '+38.274149', '-076.072171', 'TODDVILLE', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8973, '21673', '+38.664452', '-076.058006', 'TRAPPE', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8974, '21675', '+38.307394', '-076.106344', 'WINGATE', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8975, '21676', '+38.784568', '-076.300134', 'WITTMAN', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8976, '21677', '+38.499650', '-076.202456', 'WOOLFORD', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(8977, '21678', '+39.308842', '-076.081650', 'WORTON', 'MD', 'MARYLAND', 'KENT', 'STANDARD'),
(8978, '21679', '+38.915060', '-076.073905', 'WYE MILLS', 'MD', 'MARYLAND', 'TALBOT', 'STANDARD'),
(8979, '21681', '+38.889270', '-075.861191', 'RIDGELY', 'MD', 'MARYLAND', 'CAROLINE', 'UNIQUE'),
(8980, '21682', '+38.889270', '-075.861191', 'RIDGELY', 'MD', 'MARYLAND', 'CAROLINE', 'UNIQUE'),
(8981, '21683', '+38.889270', '-075.861191', 'RIDGELY', 'MD', 'MARYLAND', 'CAROLINE', 'UNIQUE'),
(8982, '21684', '+38.889270', '-075.861191', 'RIDGELY', 'MD', 'MARYLAND', 'CAROLINE', 'UNIQUE'),
(8983, '21685', '+38.889270', '-075.861191', 'RIDGELY', 'MD', 'MARYLAND', 'CAROLINE', 'UNIQUE'),
(8984, '21686', '+38.889270', '-075.861191', 'RIDGELY', 'MD', 'MARYLAND', 'CAROLINE', 'UNIQUE'),
(8985, '21687', '+38.889270', '-075.861191', 'RIDGELY', 'MD', 'MARYLAND', 'CAROLINE', 'UNIQUE'),
(8986, '21688', '+38.889270', '-075.861191', 'RIDGELY', 'MD', 'MARYLAND', 'CAROLINE', 'UNIQUE'),
(8987, '21690', '+39.034637', '-076.092127', 'CHESTERTOWN', 'MD', 'MARYLAND', 'QUEEN ANNES', 'UNIQUE'),
(8988, '21701', '+39.512748', '-077.369299', 'FREDERICK', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(8989, '21702', '+39.492596', '-077.461211', 'FREDERICK', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(8990, '21703', '+39.364713', '-077.463561', 'FREDERICK', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(8991, '21704', '+39.345477', '-077.383229', 'FREDERICK', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(8992, '21705', '+39.469961', '-077.392139', 'FREDERICK', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(8993, '21709', '+39.469961', '-077.392139', 'FREDERICK', 'MD', 'MARYLAND', 'FREDERICK', 'UNIQUE'),
(8994, '21710', '+39.291049', '-077.455243', 'ADAMSTOWN', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(8995, '21711', '+39.666266', '-077.954912', 'BIG POOL', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(8996, '21713', '+39.551986', '-077.695721', 'BOONSBORO', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(8997, '21714', '+39.420300', '-077.505098', 'BRADDOCK HEIGHTS', 'MD', 'MARYLAND', 'FREDERICK', 'PO BOX ONLY'),
(8998, '21715', '+39.386893', '-077.658015', 'BROWNSVILLE', 'MD', 'MARYLAND', 'WASHINGTON', 'PO BOX ONLY'),
(8999, '21716', '+39.317945', '-077.624701', 'BRUNSWICK', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9000, '21717', '+39.330887', '-077.427405', 'BUCKEYSTOWN', 'MD', 'MARYLAND', 'FREDERICK', 'PO BOX ONLY'),
(9001, '21718', '+39.400868', '-077.627954', 'BURKITTSVILLE', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9002, '21719', '+39.695751', '-077.495542', 'CASCADE', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9003, '21720', '+39.647296', '-077.584162', 'CAVETOWN', 'MD', 'MARYLAND', 'WASHINGTON', 'PO BOX ONLY'),
(9004, '21721', '+39.642537', '-077.637152', 'CHEWSVILLE', 'MD', 'MARYLAND', 'WASHINGTON', 'PO BOX ONLY'),
(9005, '21722', '+39.665751', '-077.906389', 'CLEAR SPRING', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9006, '21723', '+39.328104', '-077.014200', 'COOKSVILLE', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(9007, '21727', '+39.675397', '-077.336732', 'EMMITSBURG', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9008, '21733', '+39.559419', '-077.760390', 'FAIRPLAY', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9009, '21734', '+39.605960', '-077.707207', 'FUNKSTOWN', 'MD', 'MARYLAND', 'WASHINGTON', 'PO BOX ONLY'),
(9010, '21736', '+39.520696', '-077.916196', 'GAPLAND', 'MD', 'MARYLAND', 'WASHINGTON', 'PO BOX ONLY'),
(9011, '21737', '+39.259656', '-077.012699', 'GLENELG', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(9012, '21738', '+39.281504', '-077.025362', 'GLENWOOD', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(9013, '21740', '+39.588870', '-077.700213', 'HAGERSTOWN', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9014, '21741', '+39.693944', '-077.742116', 'HAGERSTOWN', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9015, '21742', '+39.642995', '-077.652779', 'HAGERSTOWN', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9016, '21746', '+39.563787', '-077.720642', 'HAGERSTOWN', 'MD', 'MARYLAND', 'WASHINGTON', 'UNIQUE'),
(9017, '21747', '+39.520696', '-077.916196', 'HAGERSTOWN', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9018, '21748', '+39.520696', '-077.916196', 'HAGERSTOWN', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9019, '21749', '+39.520696', '-077.916196', 'HAGERSTOWN', 'MD', 'MARYLAND', 'WASHINGTON', 'UNIQUE'),
(9020, '21750', '+39.588950', '-078.050204', 'HANCOCK', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9021, '21754', '+39.339477', '-077.310622', 'IJAMSVILLE', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9022, '21755', '+39.353688', '-077.567142', 'JEFFERSON', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9023, '21756', '+39.458488', '-077.693341', 'KEEDYSVILLE', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9024, '21757', '+39.619399', '-077.252657', 'KEYMAR', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(9025, '21758', '+39.349240', '-077.620514', 'KNOXVILLE', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9026, '21759', '+39.569426', '-077.290519', 'LADIESBURG', 'MD', 'MARYLAND', 'FREDERICK', 'PO BOX ONLY'),
(9027, '21762', '+39.482208', '-077.246761', 'LIBERTYTOWN', 'MD', 'MARYLAND', 'FREDERICK', 'PO BOX ONLY'),
(9028, '21764', '+39.534703', '-077.049302', 'LINWOOD', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(9029, '21765', '+39.337804', '-077.071952', 'LISBON', 'MD', 'MARYLAND', 'HOWARD', 'PO BOX ONLY'),
(9030, '21766', '+39.641946', '-078.408891', 'LITTLE ORLEANS', 'MD', 'MARYLAND', 'ALLEGANY', 'STANDARD'),
(9031, '21767', '+39.696761', '-077.746766', 'MAUGANSVILLE', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9032, '21769', '+39.535030', '-077.485034', 'MIDDLETOWN', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9033, '21770', '+39.351552', '-077.265818', 'MONROVIA', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9034, '21771', '+39.407252', '-077.214087', 'MOUNT AIRY', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9035, '21773', '+39.550036', '-077.556275', 'MYERSVILLE', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9036, '21774', '+39.432571', '-077.220932', 'NEW MARKET', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9037, '21775', '+39.564472', '-077.294680', 'NEW MIDWAY', 'MD', 'MARYLAND', 'FREDERICK', 'PO BOX ONLY'),
(9038, '21776', '+39.521886', '-077.093303', 'NEW WINDSOR', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(9039, '21777', '+39.277770', '-077.532068', 'POINT OF ROCKS', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9040, '21778', '+39.618999', '-077.335442', 'ROCKY RIDGE', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9041, '21779', '+39.430227', '-077.660130', 'ROHRERSVILLE', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9042, '21780', '+39.667035', '-077.481888', 'SABILLASVILLE', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9043, '21781', '+39.569910', '-077.760697', 'SAINT JAMES', 'MD', 'MARYLAND', 'WASHINGTON', 'PO BOX ONLY'),
(9044, '21782', '+39.438718', '-077.771667', 'SHARPSBURG', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9045, '21783', '+39.591355', '-077.614762', 'SMITHSBURG', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9046, '21784', '+39.456720', '-076.969601', 'SYKESVILLE', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(9047, '21787', '+39.657449', '-077.169055', 'TANEYTOWN', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(9048, '21788', '+39.610876', '-077.398931', 'THURMONT', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9049, '21790', '+39.265086', '-077.496646', 'TUSCARORA', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9050, '21791', '+39.579850', '-077.131896', 'UNION BRIDGE', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(9051, '21792', '+39.469961', '-077.392139', 'UNIONVILLE', 'MD', 'MARYLAND', 'FREDERICK', 'PO BOX ONLY'),
(9052, '21793', '+39.491247', '-077.343542', 'WALKERSVILLE', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9053, '21794', '+39.296204', '-076.981150', 'WEST FRIENDSHIP', 'MD', 'MARYLAND', 'HOWARD', 'STANDARD'),
(9054, '21795', '+39.589123', '-077.826258', 'WILLIAMSPORT', 'MD', 'MARYLAND', 'WASHINGTON', 'STANDARD'),
(9055, '21797', '+39.402352', '-077.081821', 'WOODBINE', 'MD', 'MARYLAND', 'CARROLL', 'STANDARD'),
(9056, '21798', '+39.542724', '-077.292314', 'WOODSBORO', 'MD', 'MARYLAND', 'FREDERICK', 'STANDARD'),
(9057, '21801', '+38.382445', '-075.633621', 'SALISBURY', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9058, '21802', '+38.388434', '-075.627600', 'SALISBURY', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9059, '21803', '+38.388434', '-075.627600', 'SALISBURY', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9060, '21804', '+38.350793', '-075.533782', 'SALISBURY', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9061, '21810', '+38.388434', '-075.627600', 'ALLEN', 'MD', 'MARYLAND', 'WICOMICO', 'PO BOX ONLY'),
(9062, '21811', '+38.310447', '-075.320901', 'BERLIN', 'MD', 'MARYLAND', 'WORCESTER', 'STANDARD'),
(9063, '21813', '+38.421121', '-075.195960', 'BISHOPVILLE', 'MD', 'MARYLAND', 'WORCESTER', 'STANDARD'),
(9064, '21814', '+38.388434', '-075.627600', 'BIVALVE', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9065, '21817', '+37.998308', '-075.818797', 'CRISFIELD', 'MD', 'MARYLAND', 'SOMERSET', 'STANDARD'),
(9066, '21821', '+38.166101', '-075.923290', 'DEAL ISLAND', 'MD', 'MARYLAND', 'SOMERSET', 'STANDARD'),
(9067, '21822', '+38.216972', '-075.550530', 'EDEN', 'MD', 'MARYLAND', 'WORCESTER', 'STANDARD'),
(9068, '21824', '+37.983912', '-076.035623', 'EWELL', 'MD', 'MARYLAND', 'SOMERSET', 'STANDARD'),
(9069, '21826', '+38.320318', '-075.620806', 'FRUITLAND', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9070, '21829', '+38.102963', '-075.381853', 'GIRDLETREE', 'MD', 'MARYLAND', 'WORCESTER', 'STANDARD'),
(9071, '21830', '+38.409235', '-075.724848', 'HEBRON', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9072, '21835', '+38.532301', '-075.949958', 'LINKWOOD', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(9073, '21836', '+38.073294', '-075.734412', 'MANOKIN', 'MD', 'MARYLAND', 'SOMERSET', 'PO BOX ONLY'),
(9074, '21837', '+38.458249', '-075.754804', 'MARDELA SPRINGS', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9075, '21838', '+38.018983', '-075.728768', 'MARION STATION', 'MD', 'MARYLAND', 'SOMERSET', 'STANDARD'),
(9076, '21840', '+38.388434', '-075.627600', 'NANTICOKE', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9077, '21841', '+38.246348', '-075.301838', 'NEWARK', 'MD', 'MARYLAND', 'WORCESTER', 'STANDARD'),
(9078, '21842', '+38.381107', '-075.113816', 'OCEAN CITY', 'MD', 'MARYLAND', 'WORCESTER', 'STANDARD'),
(9079, '21843', '+38.223090', '-075.324057', 'OCEAN CITY', 'MD', 'MARYLAND', 'WORCESTER', 'STANDARD'),
(9080, '21849', '+38.376894', '-075.462009', 'PARSONSBURG', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9081, '21850', '+38.394572', '-075.410499', 'PITTSVILLE', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9082, '21851', '+38.089201', '-075.537185', 'POCOMOKE CITY', 'MD', 'MARYLAND', 'WORCESTER', 'STANDARD'),
(9083, '21852', '+38.388434', '-075.627600', 'POWELLVILLE', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9084, '21853', '+38.200553', '-075.752920', 'PRINCESS ANNE', 'MD', 'MARYLAND', 'SOMERSET', 'STANDARD'),
(9085, '21856', '+38.305282', '-075.763118', 'QUANTICO', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9086, '21857', '+38.092718', '-075.888207', 'REHOBETH', 'MD', 'MARYLAND', 'SOMERSET', 'PO BOX ONLY'),
(9087, '21861', '+38.538904', '-075.719182', 'SHARPTOWN', 'MD', 'MARYLAND', 'WICOMICO', 'PO BOX ONLY'),
(9088, '21862', '+38.400306', '-075.216551', 'SHOWELL', 'MD', 'MARYLAND', 'WORCESTER', 'PO BOX ONLY'),
(9089, '21863', '+38.217824', '-075.326618', 'SNOW HILL', 'MD', 'MARYLAND', 'WORCESTER', 'STANDARD'),
(9090, '21864', '+38.042932', '-075.411789', 'STOCKTON', 'MD', 'MARYLAND', 'WORCESTER', 'STANDARD'),
(9091, '21865', '+38.268914', '-075.790882', 'TYASKIN', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9092, '21866', '+37.966573', '-076.023482', 'TYLERTON', 'MD', 'MARYLAND', 'SOMERSET', 'PO BOX ONLY'),
(9093, '21867', '+38.100490', '-075.822318', 'UPPER FAIRMOUNT', 'MD', 'MARYLAND', 'SOMERSET', 'PO BOX ONLY'),
(9094, '21869', '+38.430928', '-075.897058', 'VIENNA', 'MD', 'MARYLAND', 'DORCHESTER', 'STANDARD'),
(9095, '21870', '+38.092718', '-075.888207', 'WENONA', 'MD', 'MARYLAND', 'SOMERSET', 'STANDARD'),
(9096, '21871', '+38.094181', '-075.717406', 'WESTOVER', 'MD', 'MARYLAND', 'SOMERSET', 'STANDARD'),
(9097, '21872', '+38.412085', '-075.281074', 'WHALEYVILLE', 'MD', 'MARYLAND', 'WORCESTER', 'STANDARD'),
(9098, '21874', '+38.404060', '-075.351349', 'WILLARDS', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9099, '21875', '+38.452527', '-075.574165', 'DELMAR', 'MD', 'MARYLAND', 'WICOMICO', 'STANDARD'),
(9100, '21890', '+38.092718', '-075.888207', 'WESTOVER', 'MD', 'MARYLAND', 'SOMERSET', 'UNIQUE'),
(9101, '21901', '+39.535078', '-075.894051', 'NORTH EAST', 'MD', 'MARYLAND', 'CECIL', 'STANDARD'),
(9102, '21902', '+39.552962', '-076.072471', 'PERRY POINT', 'MD', 'MARYLAND', 'CECIL', 'PO BOX ONLY'),
(9103, '21903', '+39.571449', '-076.033281', 'PERRYVILLE', 'MD', 'MARYLAND', 'CECIL', 'STANDARD'),
(9104, '21904', '+39.615086', '-076.063342', 'PORT DEPOSIT', 'MD', 'MARYLAND', 'CECIL', 'STANDARD'),
(9105, '21911', '+39.671572', '-076.056651', 'RISING SUN', 'MD', 'MARYLAND', 'CECIL', 'STANDARD'),
(9106, '21912', '+39.533058', '-075.915203', 'WARWICK', 'MD', 'MARYLAND', 'CECIL', 'STANDARD'),
(9107, '21913', '+39.410355', '-075.863287', 'CECILTON', 'MD', 'MARYLAND', 'CECIL', 'PO BOX ONLY'),
(9108, '21914', '+39.574387', '-075.978564', 'CHARLESTOWN', 'MD', 'MARYLAND', 'CECIL', 'PO BOX ONLY'),
(9109, '21915', '+39.469098', '-075.849327', 'CHESAPEAKE CITY', 'MD', 'MARYLAND', 'CECIL', 'STANDARD'),
(9110, '21916', '+39.541512', '-075.999972', 'CHILDS', 'MD', 'MARYLAND', 'CECIL', 'PO BOX ONLY'),
(9111, '21917', '+39.537261', '-076.003452', 'COLORA', 'MD', 'MARYLAND', 'CECIL', 'STANDARD'),
(9112, '21918', '+39.543894', '-076.049157', 'CONOWINGO', 'MD', 'MARYLAND', 'CECIL', 'STANDARD'),
(9113, '21919', '+39.470309', '-075.927952', 'EARLEVILLE', 'MD', 'MARYLAND', 'CECIL', 'STANDARD'),
(9114, '21920', '+39.658031', '-075.828196', 'ELK MILLS', 'MD', 'MARYLAND', 'CECIL', 'PO BOX ONLY'),
(9115, '21921', '+39.561860', '-075.875740', 'ELKTON', 'MD', 'MARYLAND', 'CECIL', 'STANDARD'),
(9116, '21922', '+39.593612', '-075.947332', 'ELKTON', 'MD', 'MARYLAND', 'CECIL', 'STANDARD'),
(9117, '21930', '+39.366183', '-075.884544', 'GEORGETOWN', 'MD', 'MARYLAND', 'CECIL', 'PO BOX ONLY'),
(9118, '22002', '+38.691448', '-078.137019', 'AMISSVILLE', 'VA', 'VIRGINIA', 'RAPPAHANNOCK', 'STANDARD'),
(9119, '22003', '+38.835762', '-077.212794', 'ANNANDALE', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9120, '22009', '+38.831813', '-077.288755', 'BURKE', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9121, '22015', '+38.785864', '-077.286156', 'BURKE', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9122, '22026', '+38.584734', '-077.349935', 'DUMFRIES', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(9123, '22027', '+38.895078', '-077.221453', 'DUNN LORING', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9124, '22030', '+38.853231', '-077.305097', 'FAIRFAX', 'VA', 'VIRGINIA', 'FAIRFAX CITY', 'STANDARD'),
(9125, '22031', '+38.853962', '-077.284195', 'FAIRFAX', 'VA', 'VIRGINIA', 'FAIRFAX CITY', 'STANDARD'),
(9126, '22032', '+38.819712', '-077.287105', 'FAIRFAX', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9127, '22033', '+38.879466', '-077.378858', 'FAIRFAX', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9128, '22034', '+38.831813', '-077.288755', 'FAIRFAX', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9129, '22035', '+38.855715', '-077.361633', 'FAIRFAX', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9130, '22036', '+38.735114', '-077.079650', 'FAIRFAX', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9131, '22037', '+38.831813', '-077.288755', 'FAIRFAX', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9132, '22038', '+38.852849', '-077.301990', 'FAIRFAX', 'VA', 'VIRGINIA', 'FAIRFAX CITY', 'STANDARD'),
(9133, '22039', '+38.759329', '-077.311588', 'FAIRFAX STATION', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9134, '22040', '+38.884177', '-077.171752', 'FALLS CHURCH', 'VA', 'VIRGINIA', 'FALLS CHURCH CITY', 'STANDARD'),
(9135, '22041', '+38.850212', '-077.144801', 'FALLS CHURCH', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9136, '22042', '+38.863452', '-077.193915', 'FALLS CHURCH', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9137, '22043', '+38.899361', '-077.189502', 'FALLS CHURCH', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9138, '22044', '+38.858853', '-077.154761', 'FALLS CHURCH', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9139, '22046', '+38.884936', '-077.174052', 'FALLS CHURCH', 'VA', 'VIRGINIA', 'FALLS CHURCH CITY', 'STANDARD'),
(9140, '22047', '+38.831813', '-077.288755', 'FALLS CHURCH', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9141, '22060', '+38.714562', '-077.167886', 'FORT BELVOIR', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9142, '22066', '+39.001609', '-077.306416', 'GREAT FALLS', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9143, '22067', '+38.964510', '-077.233103', 'GREENWAY', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9144, '22079', '+38.692865', '-077.204031', 'LORTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9145, '22081', '+38.873861', '-077.234454', 'MERRIFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9146, '22082', '+38.831813', '-077.288755', 'MERRIFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9147, '22092', '+38.831813', '-077.288755', 'HERNDON', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9148, '22093', '+39.085309', '-077.645224', 'ASHBURN', 'VA', 'VIRGINIA', 'LOUDOUN', 'UNIQUE'),
(9149, '22095', '+38.831813', '-077.288755', 'HERNDON', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9150, '22096', '+38.831813', '-077.288755', 'RESTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9151, '22101', '+38.935202', '-077.186720', 'MC LEAN', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9152, '22102', '+38.953033', '-077.229496', 'MC LEAN', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9153, '22103', '+38.831813', '-077.288755', 'WEST MCLEAN', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9154, '22106', '+38.831813', '-077.288755', 'MC LEAN', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9155, '22107', '', '', 'MC LEAN', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9156, '22108', '', '', 'MC LEAN', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9157, '22109', '+38.920165', '-077.229043', 'MC LEAN', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9158, '22116', '+38.871469', '-077.234428', 'MERRIFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9159, '22118', '+38.831813', '-077.288755', 'MERRIFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9160, '22119', '+38.831813', '-077.288755', 'MERRIFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9161, '22120', '+38.831813', '-077.288755', 'MERRIFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9162, '22121', '+38.830912', '-077.432252', 'MOUNT VERNON', 'VA', 'VIRGINIA', 'FAIRFAX', 'PO BOX ONLY'),
(9163, '22122', '+38.831813', '-077.288755', 'NEWINGTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'PO BOX ONLY'),
(9164, '22124', '+38.892796', '-077.329906', 'OAKTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9165, '22125', '+38.681615', '-077.260520', 'OCCOQUAN', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'PO BOX ONLY'),
(9166, '22134', '+38.526020', '-077.322803', 'QUANTICO', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(9167, '22135', '+38.721912', '-077.466897', 'QUANTICO', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'UNIQUE'),
(9168, '22150', '+38.763463', '-077.186063', 'SPRINGFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9169, '22151', '+38.802858', '-077.211556', 'SPRINGFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9170, '22152', '+38.775687', '-077.233746', 'SPRINGFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9171, '22153', '+38.757015', '-077.181612', 'SPRINGFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9172, '22156', '+38.831813', '-077.288755', 'SPRINGFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9173, '22158', '+38.831813', '-077.288755', 'SPRINGFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9174, '22159', '+38.831813', '-077.288755', 'SPRINGFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9175, '22160', '+38.831813', '-077.288755', 'SPRINGFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9176, '22161', '+38.807462', '-077.219354', 'SPRINGFIELD', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9177, '22172', '+38.581369', '-077.367205', 'TRIANGLE', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(9178, '22180', '+38.897361', '-077.253749', 'VIENNA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9179, '22181', '+38.905210', '-077.295256', 'VIENNA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9180, '22182', '+38.935292', '-077.268022', 'VIENNA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9181, '22183', '+38.831813', '-077.288755', 'VIENNA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9182, '22184', '+38.831813', '-077.288755', 'VIENNA', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9183, '22185', '+38.831813', '-077.288755', 'VIENNA', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9184, '22191', '+38.625541', '-077.271644', 'WOODBRIDGE', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(9185, '22192', '+38.675952', '-077.316344', 'WOODBRIDGE', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(9186, '22193', '+38.643765', '-077.345106', 'WOODBRIDGE', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(9187, '22194', '+38.721912', '-077.466897', 'WOODBRIDGE', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(9188, '22195', '+38.721912', '-077.466897', 'WOODBRIDGE', 'VA', 'VIRGINIA', 'PRINCE WILLIAM', 'STANDARD'),
(9189, '22199', '+38.831813', '-077.288755', 'LORTON', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9190, '22201', '+38.885484', '-077.099113', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9191, '22202', '+38.854462', '-077.059721', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9192, '22203', '+38.874775', '-077.119515', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9193, '22204', '+38.860335', '-077.100868', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9194, '22205', '+38.875811', '-077.140021', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9195, '22206', '+38.840403', '-077.088800', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9196, '22207', '+38.907416', '-077.122344', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9197, '22209', '+38.893596', '-077.110376', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9198, '22210', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9199, '22211', '+38.878674', '-077.077426', 'FT MYER', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9200, '22212', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9201, '22213', '+38.894898', '-077.162829', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9202, '22214', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9203, '22215', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9204, '22216', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9205, '22217', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9206, '22218', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9207, '22219', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'STANDARD'),
(9208, '22222', '+38.861462', '-077.053599', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9209, '22223', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9210, '22225', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9211, '22226', '+38.883358', '-077.102810', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9212, '22227', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9213, '22229', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9214, '22230', '+38.879720', '-077.110817', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9215, '22234', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9216, '22240', '+38.856623', '-077.051788', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9217, '22241', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9218, '22242', '+38.850879', '-077.052336', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9219, '22243', '+38.860450', '-077.051569', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9220, '22244', '+38.854522', '-077.052035', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9221, '22245', '+38.851773', '-077.052296', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9222, '22246', '+38.880811', '-077.112950', 'ARLINGTON', 'VA', 'VIRGINIA', 'ARLINGTON', 'UNIQUE'),
(9223, '22301', '+38.823062', '-077.079622', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'STANDARD'),
(9224, '22302', '+38.827627', '-077.089566', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'STANDARD'),
(9225, '22303', '+38.791231', '-077.081350', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9226, '22304', '+38.815220', '-077.109930', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'STANDARD'),
(9227, '22305', '+38.835412', '-077.063959', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'STANDARD'),
(9228, '22306', '+38.758914', '-077.087344', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9229, '22307', '+38.771363', '-077.065699', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9230, '22308', '+38.731564', '-077.060399', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9231, '22309', '+38.722264', '-077.171945', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9232, '22310', '+38.779391', '-077.119401', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9233, '22311', '+38.832762', '-077.119627', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'STANDARD'),
(9234, '22312', '+38.799956', '-077.150177', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9235, '22313', '+38.815762', '-077.090050', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'STANDARD'),
(9236, '22314', '+38.811436', '-077.063587', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'STANDARD'),
(9237, '22315', '+38.759553', '-077.148518', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'FAIRFAX', 'STANDARD'),
(9238, '22320', '+38.804413', '-077.046699', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'STANDARD'),
(9239, '22321', '+38.831813', '-077.288755', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'FAIRFAX', 'UNIQUE'),
(9240, '22331', '+38.801342', '-077.070733', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'STANDARD'),
(9241, '22332', '+38.803142', '-077.072679', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'STANDARD'),
(9242, '22333', '+38.815762', '-077.090050', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'UNIQUE'),
(9243, '22334', '+38.815762', '-077.090050', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'UNIQUE'),
(9244, '22336', '+38.815762', '-077.090050', 'ALEXANDRIA', 'VA', 'VIRGINIA', 'ALEXANDRIA CITY', 'UNIQUE'),
(9245, '22401', '+38.295135', '-077.483689', 'FREDERICKSBURG', 'VA', 'VIRGINIA', 'FREDERICKSBURG CITY', 'STANDARD'),
(9246, '22402', '+38.299613', '-077.489666', 'FREDERICKSBURG', 'VA', 'VIRGINIA', 'FREDERICKSBURG CITY', 'STANDARD'),
(9247, '22403', '+38.417273', '-077.460814', 'FREDERICKSBURG', 'VA', 'VIRGINIA', 'STAFFORD', 'STANDARD'),
(9248, '22404', '+38.298305', '-077.489913', 'FREDERICKSBURG', 'VA', 'VIRGINIA', 'FREDERICKSBURG CITY', 'STANDARD'),
(9249, '22405', '+38.336458', '-077.436618', 'FREDERICKSBURG', 'VA', 'VIRGINIA', 'STAFFORD', 'STANDARD'),
(9250, '22406', '+38.414357', '-077.534708', 'FREDERICKSBURG', 'VA', 'VIRGINIA', 'STAFFORD', 'STANDARD'),
(9251, '22407', '+38.271969', '-077.606772', 'FREDERICKSBURG', 'VA', 'VIRGINIA', 'SPOTSYLVANIA', 'STANDARD'),
(9252, '22408', '+38.233933', '-077.562773', 'FREDERICKSBURG', 'VA', 'VIRGINIA', 'SPOTSYLVANIA', 'STANDARD'),
(9253, '22412', '+38.184716', '-077.662559', 'FREDERICKSBURG', 'VA', 'VIRGINIA', 'SPOTSYLVANIA', 'UNIQUE'),
(9254, '22427', '+38.008401', '-077.260353', 'BOWLING GREEN', 'VA', 'VIRGINIA', 'CAROLINE', 'STANDARD'),
(9255, '22428', '+38.014536', '-077.355902', 'BOWLING GREEN', 'VA', 'VIRGINIA', 'CAROLINE', 'UNIQUE'),
(9256, '22430', '+38.385704', '-077.374292', 'BROOKE', 'VA', 'VIRGINIA', 'STAFFORD', 'PO BOX ONLY'),
(9257, '22432', '+37.837435', '-076.345493', 'BURGESS', 'VA', 'VIRGINIA', 'NORTHUMBERLAND', 'STANDARD'),
(9258, '22433', '+38.344608', '-077.871855', 'BURR HILL', 'VA', 'VIRGINIA', 'ORANGE', 'STANDARD'),
(9259, '22435', '+37.961716', '-076.577422', 'CALLAO', 'VA', 'VIRGINIA', 'NORTHUMBERLAND', 'STANDARD'),
(9260, '22436', '+38.024704', '-077.037147', 'CARET', 'VA', 'VIRGINIA', 'ESSEX', 'STANDARD'),
(9261, '22437', '+37.818619', '-076.786335', 'CENTER CROSS', 'VA', 'VIRGINIA', 'ESSEX', 'STANDARD'),
(9262, '22438', '+38.056246', '-077.018147', 'CHAMPLAIN', 'VA', 'VIRGINIA', 'ESSEX', 'STANDARD'),
(9263, '22442', '+38.121793', '-076.790250', 'COLES POINT', 'VA', 'VIRGINIA', 'WESTMORELAND', 'PO BOX ONLY'),
(9264, '22443', '+38.184926', '-076.823742', 'COLONIAL BEACH', 'VA', 'VIRGINIA', 'WESTMORELAND', 'STANDARD'),
(9265, '22446', '+38.171755', '-077.408163', 'CORBIN', 'VA', 'VIRGINIA', 'CAROLINE', 'PO BOX ONLY'),
(9266, '22448', '+38.326218', '-077.039825', 'DAHLGREN', 'VA', 'VIRGINIA', 'KING GEORGE', 'STANDARD'),
(9267, '22451', '+38.271077', '-077.172610', 'DOGUE', 'VA', 'VIRGINIA', 'KING GEORGE', 'PO BOX ONLY'),
(9268, '22454', '+37.852669', '-076.847543', 'DUNNSVILLE', 'VA', 'VIRGINIA', 'ESSEX', 'STANDARD'),
(9269, '22456', '+37.852316', '-076.405110', 'EDWARDSVILLE', 'VA', 'VIRGINIA', 'NORTHUMBERLAND', 'PO BOX ONLY'),
(9270, '22460', '+37.879797', '-076.598782', 'FARNHAM', 'VA', 'VIRGINIA', 'RICHMOND', 'STANDARD'),
(9271, '22463', '+38.468432', '-077.461213', 'GARRISONVILLE', 'VA', 'VIRGINIA', 'STAFFORD', 'PO BOX ONLY'),
(9272, '22469', '+38.059488', '-076.676452', 'HAGUE', 'VA', 'VIRGINIA', 'WESTMORELAND', 'STANDARD'),
(9273, '22471', '+38.399330', '-077.581351', 'HARTWOOD', 'VA', 'VIRGINIA', 'STAFFORD', 'PO BOX ONLY'),
(9274, '22472', '+37.950511', '-076.636722', 'HAYNESVILLE', 'VA', 'VIRGINIA', 'RICHMOND', 'PO BOX ONLY'),
(9275, '22473', '+37.876733', '-076.427334', 'HEATHSVILLE', 'VA', 'VIRGINIA', 'NORTHUMBERLAND', 'STANDARD'),
(9276, '22476', '+38.032905', '-077.063280', 'HUSTLE', 'VA', 'VIRGINIA', 'ESSEX', 'STANDARD'),
(9277, '22480', '+37.667319', '-076.404996', 'IRVINGTON', 'VA', 'VIRGINIA', 'LANCASTER', 'STANDARD'),
(9278, '22481', '+38.271077', '-077.172610', 'JERSEY', 'VA', 'VIRGINIA', 'KING GEORGE', 'PO BOX ONLY'),
(9279, '22482', '+37.715738', '-076.450212', 'KILMARNOCK', 'VA', 'VIRGINIA', 'LANCASTER', 'STANDARD'),
(9280, '22485', '+38.277209', '-077.172250', 'KING GEORGE', 'VA', 'VIRGINIA', 'KING GEORGE', 'STANDARD'),
(9281, '22488', '+38.102075', '-076.743458', 'KINSALE', 'VA', 'VIRGINIA', 'WESTMORELAND', 'STANDARD'),
(9282, '22501', '+38.015899', '-077.559298', 'LADYSMITH', 'VA', 'VIRGINIA', 'CAROLINE', 'PO BOX ONLY'),
(9283, '22503', '+37.739451', '-076.500210', 'LANCASTER', 'VA', 'VIRGINIA', 'LANCASTER', 'STANDARD'),
(9284, '22504', '+37.769140', '-076.712135', 'LANEVIEW', 'VA', 'VIRGINIA', 'ESSEX', 'STANDARD'),
(9285, '22507', '+37.757226', '-076.511804', 'LIVELY', 'VA', 'VIRGINIA', 'LANCASTER', 'PO BOX ONLY'),
(9286, '22508', '+38.308398', '-077.796156', 'LOCUST GROVE', 'VA', 'VIRGINIA', 'ORANGE', 'STANDARD'),
(9287, '22509', '+38.078932', '-077.048510', 'LORETTO', 'VA', 'VIRGINIA', 'ESSEX', 'STANDARD'),
(9288, '22511', '+37.985615', '-076.499878', 'LOTTSBURG', 'VA', 'VIRGINIA', 'NORTHUMBERLAND', 'STANDARD'),
(9289, '22513', '+37.750261', '-076.509615', 'MERRY POINT', 'VA', 'VIRGINIA', 'LANCASTER', 'PO BOX ONLY'),
(9290, '22514', '+37.980787', '-077.242558', 'MILFORD', 'VA', 'VIRGINIA', 'CAROLINE', 'STANDARD'),
(9291, '22517', '+37.750280', '-076.578109', 'MOLLUSK', 'VA', 'VIRGINIA', 'LANCASTER', 'PO BOX ONLY'),
(9292, '22520', '+38.111955', '-076.824340', 'MONTROSS', 'VA', 'VIRGINIA', 'WESTMORELAND', 'STANDARD'),
(9293, '22523', '+37.792761', '-076.609330', 'MORATTICO', 'VA', 'VIRGINIA', 'LANCASTER', 'PO BOX ONLY'),
(9294, '22524', '+38.118186', '-076.680504', 'MOUNT HOLLY', 'VA', 'VIRGINIA', 'WESTMORELAND', 'PO BOX ONLY'),
(9295, '22526', '+38.271077', '-077.172610', 'NINDE', 'VA', 'VIRGINIA', 'KING GEORGE', 'PO BOX ONLY'),
(9296, '22528', '+37.713175', '-076.409946', 'NUTTSVILLE', 'VA', 'VIRGINIA', 'LANCASTER', 'PO BOX ONLY'),
(9297, '22529', '+38.018054', '-076.686110', 'OLDHAMS', 'VA', 'VIRGINIA', 'WESTMORELAND', 'PO BOX ONLY'),
(9298, '22530', '+37.909380', '-076.293436', 'OPHELIA', 'VA', 'VIRGINIA', 'NORTHUMBERLAND', 'PO BOX ONLY'),
(9299, '22534', '+38.084620', '-077.666948', 'PARTLOW', 'VA', 'VIRGINIA', 'SPOTSYLVANIA', 'STANDARD'),
(9300, '22535', '+38.157349', '-077.180478', 'PORT ROYAL', 'VA', 'VIRGINIA', 'CAROLINE', 'STANDARD'),
(9301, '22538', '+38.207873', '-077.250200', 'RAPPAHANNOCK ACADEMY', 'VA', 'VIRGINIA', 'CAROLINE', 'STANDARD'),
(9302, '22539', '+37.855567', '-076.312376', 'REEDVILLE', 'VA', 'VIRGINIA', 'NORTHUMBERLAND', 'STANDARD'),
(9303, '22542', '+38.292189', '-077.897386', 'RHOADESVILLE', 'VA', 'VIRGINIA', 'ORANGE', 'STANDARD'),
(9304, '22544', '+38.271077', '-077.172610', 'ROLLINS FORK', 'VA', 'VIRGINIA', 'KING GEORGE', 'PO BOX ONLY'),
(9305, '22545', '+38.508611', '-077.542957', 'RUBY', 'VA', 'VIRGINIA', 'STAFFORD', 'PO BOX ONLY'),
(9306, '22546', '+37.948572', '-077.437767', 'RUTHER GLEN', 'VA', 'VIRGINIA', 'CAROLINE', 'STANDARD'),
(9307, '22547', '+38.271077', '-077.172610', 'SEALSTON', 'VA', 'VIRGINIA', 'KING GEORGE', 'PO BOX ONLY'),
(9308, '22548', '+37.837583', '-076.694775', 'SHARPS', 'VA', 'VIRGINIA', 'RICHMOND', 'PO BOX ONLY'),
(9309, '22552', '+38.009438', '-077.225139', 'SPARTA', 'VA', 'VIRGINIA', 'CAROLINE', 'PO BOX ONLY'),
(9310, '22553', '+38.182869', '-077.699320', 'SPOTSYLVANIA', 'VA', 'VIRGINIA', 'SPOTSYLVANIA', 'STANDARD'),
(9311, '22554', '+38.438958', '-077.435400', 'STAFFORD', 'VA', 'VIRGINIA', 'STAFFORD', 'STANDARD'),
(9312, '22555', '+38.417273', '-077.460814', 'STAFFORD', 'VA', 'VIRGINIA', 'STAFFORD', 'STANDARD'),
(9313, '22558', '+38.121793', '-076.790250', 'STRATFORD', 'VA', 'VIRGINIA', 'WESTMORELAND', 'STANDARD'),
(9314, '22560', '+37.916613', '-076.947547', 'TAPPAHANNOCK', 'VA', 'VIRGINIA', 'ESSEX', 'STANDARD'),
(9315, '22565', '+38.137216', '-077.518865', 'THORNBURG', 'VA', 'VIRGINIA', 'SPOTSYLVANIA', 'PO BOX ONLY'),
(9316, '22567', '+38.242901', '-077.917753', 'UNIONVILLE', 'VA', 'VIRGINIA', 'ORANGE', 'STANDARD'),
(9317, '22570', '+37.947224', '-076.615358', 'VILLAGE', 'VA', 'VIRGINIA', 'RICHMOND', 'PO BOX ONLY'),
(9318, '22572', '+37.969540', '-076.766517', 'WARSAW', 'VA', 'VIRGINIA', 'RICHMOND', 'STANDARD'),
(9319, '22576', '+37.688877', '-076.431553', 'WEEMS', 'VA', 'VIRGINIA', 'LANCASTER', 'STANDARD'),
(9320, '22577', '+38.067325', '-076.550274', 'SANDY POINT', 'VA', 'VIRGINIA', 'WESTMORELAND', 'PO BOX ONLY'),
(9321, '22578', '+37.688601', '-076.361585', 'WHITE STONE', 'VA', 'VIRGINIA', 'LANCASTER', 'STANDARD'),
(9322, '22579', '+37.802527', '-076.363603', 'WICOMICO CHURCH', 'VA', 'VIRGINIA', 'NORTHUMBERLAND', 'PO BOX ONLY'),
(9323, '22580', '+38.130103', '-077.417234', 'WOODFORD', 'VA', 'VIRGINIA', 'CAROLINE', 'STANDARD'),
(9324, '22581', '+38.121793', '-076.790250', 'ZACATA', 'VA', 'VIRGINIA', 'WESTMORELAND', 'PO BOX ONLY'),
(9325, '22601', '+39.169668', '-078.168560', 'WINCHESTER', 'VA', 'VIRGINIA', 'WINCHESTER CITY', 'STANDARD'),
(9326, '22602', '+39.150074', '-078.268988', 'WINCHESTER', 'VA', 'VIRGINIA', 'FREDERICK', 'STANDARD'),
(9327, '22603', '+39.263975', '-078.198932', 'WINCHESTER', 'VA', 'VIRGINIA', 'FREDERICK', 'STANDARD'),
(9328, '22604', '+39.167603', '-078.168643', 'WINCHESTER', 'VA', 'VIRGINIA', 'WINCHESTER CITY', 'STANDARD'),
(9329, '22610', '+38.818692', '-078.275719', 'BENTONVILLE', 'VA', 'VIRGINIA', 'WARREN', 'STANDARD'),
(9330, '22611', '+39.135711', '-077.991926', 'BERRYVILLE', 'VA', 'VIRGINIA', 'CLARKE', 'STANDARD'),
(9331, '22620', '+39.048614', '-078.060132', 'BOYCE', 'VA', 'VIRGINIA', 'CLARKE', 'STANDARD'),
(9332, '22622', '+39.254300', '-078.066373', 'BRUCETOWN', 'VA', 'VIRGINIA', 'FREDERICK', 'PO BOX ONLY'),
(9333, '22623', '+38.853733', '-078.141239', 'CHESTER GAP', 'VA', 'VIRGINIA', 'RAPPAHANNOCK', 'PO BOX ONLY'),
(9334, '22624', '+39.271865', '-078.099763', 'CLEAR BROOK', 'VA', 'VIRGINIA', 'FREDERICK', 'STANDARD'),
(9335, '22625', '+39.296066', '-078.310539', 'CROSS JUNCTION', 'VA', 'VIRGINIA', 'FREDERICK', 'STANDARD'),
(9336, '22626', '+38.983383', '-078.403766', 'FISHERS HILL', 'VA', 'VIRGINIA', 'SHENANDOAH', 'PO BOX ONLY'),
(9337, '22627', '+38.787434', '-078.083739', 'FLINT HILL', 'VA', 'VIRGINIA', 'RAPPAHANNOCK', 'STANDARD'),
(9338, '22630', '+38.928308', '-078.174537', 'FRONT ROYAL', 'VA', 'VIRGINIA', 'WARREN', 'STANDARD'),
(9339, '22637', '+39.253982', '-078.352754', 'GORE', 'VA', 'VIRGINIA', 'FREDERICK', 'STANDARD'),
(9340, '22638', '+39.236944', '-078.288465', 'WINCHESTER', 'VA', 'VIRGINIA', 'FREDERICK', 'STANDARD'),
(9341, '22639', '+38.830067', '-078.022322', 'HUME', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(9342, '22640', '+38.812892', '-078.116528', 'HUNTLY', 'VA', 'VIRGINIA', 'RAPPAHANNOCK', 'STANDARD'),
(9343, '22641', '+39.056218', '-078.374770', 'STRASBURG', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9344, '22642', '+38.932418', '-078.065023', 'LINDEN', 'VA', 'VIRGINIA', 'WARREN', 'STANDARD'),
(9345, '22643', '+38.895454', '-078.004435', 'MARKHAM', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(9346, '22644', '+38.963523', '-078.548229', 'MAURERTOWN', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9347, '22645', '+39.048863', '-078.285171', 'MIDDLETOWN', 'VA', 'VIRGINIA', 'FREDERICK', 'STANDARD'),
(9348, '22646', '+39.121941', '-077.990069', 'MILLWOOD', 'VA', 'VIRGINIA', 'CLARKE', 'PO BOX ONLY'),
(9349, '22649', '+39.004774', '-078.247806', 'MIDDLETOWN', 'VA', 'VIRGINIA', 'WARREN', 'STANDARD'),
(9350, '22650', '+38.763022', '-078.387191', 'RILEYVILLE', 'VA', 'VIRGINIA', 'PAGE', 'STANDARD'),
(9351, '22652', '+38.840715', '-078.427584', 'FORT VALLEY', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9352, '22654', '+39.078491', '-078.443076', 'STAR TANNERY', 'VA', 'VIRGINIA', 'FREDERICK', 'STANDARD'),
(9353, '22655', '+39.163418', '-078.246159', 'STEPHENS CITY', 'VA', 'VIRGINIA', 'FREDERICK', 'STANDARD'),
(9354, '22656', '+39.213701', '-078.090144', 'STEPHENSON', 'VA', 'VIRGINIA', 'FREDERICK', 'STANDARD'),
(9355, '22657', '+39.020716', '-078.417330', 'STRASBURG', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9356, '22660', '+38.947610', '-078.433111', 'TOMS BROOK', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9357, '22663', '+39.121941', '-077.990069', 'WHITE POST', 'VA', 'VIRGINIA', 'CLARKE', 'STANDARD'),
(9358, '22664', '+38.918791', '-078.512429', 'WOODSTOCK', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9359, '22701', '+38.511694', '-077.992800', 'CULPEPER', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9360, '22709', '+38.428509', '-078.267848', 'ARODA', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9361, '22711', '+38.428509', '-078.267848', 'BANCO', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9362, '22712', '+38.545289', '-077.756064', 'BEALETON', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(9363, '22713', '+38.537138', '-078.132778', 'BOSTON', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9364, '22714', '+38.511323', '-077.901265', 'BRANDY STATION', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9365, '22715', '+38.418207', '-078.189878', 'BRIGHTWOOD', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9366, '22716', '+38.624123', '-078.102389', 'CASTLETON', 'VA', 'VIRGINIA', 'RAPPAHANNOCK', 'STANDARD'),
(9367, '22718', '+38.457473', '-077.804343', 'ELKWOOD', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9368, '22719', '+38.428509', '-078.267848', 'ETLAN', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9369, '22720', '+38.472457', '-077.642308', 'GOLDVEIN', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(9370, '22721', '+38.428509', '-078.267848', 'GRAVES MILL', 'VA', 'VIRGINIA', 'MADISON', 'PO BOX ONLY'),
(9371, '22722', '+38.428509', '-078.267848', 'HAYWOOD', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9372, '22723', '+38.396709', '-078.432237', 'HOOD', 'VA', 'VIRGINIA', 'MADISON', 'PO BOX ONLY'),
(9373, '22724', '+38.622436', '-077.907403', 'JEFFERSONTON', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9374, '22725', '+38.428509', '-078.267848', 'LEON', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9375, '22726', '+38.404605', '-077.770885', 'LIGNUM', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9376, '22727', '+38.369952', '-078.297605', 'MADISON', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9377, '22728', '+38.602592', '-077.681065', 'MIDLAND', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(9378, '22729', '+38.368552', '-078.011837', 'MITCHELLS', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9379, '22730', '+38.428509', '-078.267848', 'OAKPARK', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9380, '22731', '+38.428509', '-078.267848', 'PRATTS', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9381, '22732', '+38.428509', '-078.267848', 'RADIANT', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9382, '22733', '+38.359195', '-078.060292', 'RAPIDAN', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9383, '22734', '+38.530877', '-077.803719', 'REMINGTON', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(9384, '22735', '+38.486703', '-078.150059', 'REVA', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9385, '22736', '+38.389874', '-077.711884', 'RICHARDSVILLE', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9386, '22737', '+38.588388', '-078.002489', 'RIXEYVILLE', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9387, '22738', '+38.321500', '-078.304169', 'ROCHELLE', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9388, '22739', '+38.505945', '-077.595570', 'SOMERVILLE', 'VA', 'VIRGINIA', 'FAUQUIER', 'PO BOX ONLY'),
(9389, '22740', '+38.612785', '-078.227578', 'SPERRYVILLE', 'VA', 'VIRGINIA', 'RAPPAHANNOCK', 'STANDARD'),
(9390, '22741', '+38.434991', '-077.860642', 'STEVENSBURG', 'VA', 'VIRGINIA', 'CULPEPER', 'STANDARD'),
(9391, '22742', '+38.462651', '-077.706223', 'SUMERDUCK', 'VA', 'VIRGINIA', 'FAUQUIER', 'STANDARD'),
(9392, '22743', '+38.495692', '-078.331826', 'SYRIA', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9393, '22746', '+38.647841', '-078.029974', 'VIEWTOWN', 'VA', 'VIRGINIA', 'RAPPAHANNOCK', 'STANDARD'),
(9394, '22747', '+38.705616', '-078.174894', 'WASHINGTON', 'VA', 'VIRGINIA', 'RAPPAHANNOCK', 'STANDARD'),
(9395, '22748', '+38.372652', '-078.380509', 'WOLFTOWN', 'VA', 'VIRGINIA', 'MADISON', 'PO BOX ONLY'),
(9396, '22749', '+38.620549', '-078.191528', 'WOODVILLE', 'VA', 'VIRGINIA', 'RAPPAHANNOCK', 'STANDARD'),
(9397, '22801', '+38.422777', '-078.877137', 'HARRISONBURG', 'VA', 'VIRGINIA', 'HARRISONBURG CITY', 'STANDARD'),
(9398, '22802', '+38.490526', '-078.817876', 'HARRISONBURG', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9399, '22803', '', '', 'HARRISONBURG', 'VA', 'VIRGINIA', 'HARRISONBURG CITY', 'STANDARD'),
(9400, '22807', '+38.440898', '-078.874173', 'HARRISONBURG', 'VA', 'VIRGINIA', 'HARRISONBURG CITY', 'UNIQUE'),
(9401, '22810', '+38.808869', '-078.777598', 'BASYE', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9402, '22811', '+38.781688', '-078.948643', 'BERGTON', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9403, '22812', '+38.345632', '-078.854597', 'BRIDGEWATER', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9404, '22815', '+38.619698', '-078.815219', 'BROADWAY', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9405, '22820', '+38.749089', '-079.000426', 'CRIDERS', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9406, '22821', '+38.417919', '-079.044186', 'DAYTON', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9407, '22824', '+38.818191', '-078.637768', 'EDINBURG', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9408, '22827', '+38.400900', '-078.729679', 'ELKTON', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9409, '22830', '+38.640083', '-078.940553', 'FULKS RUN', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9410, '22831', '+38.534126', '-078.999618', 'HINTON', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9411, '22832', '+38.465855', '-078.749875', 'KEEZLETOWN', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9412, '22833', '+38.528361', '-078.855172', 'LACEY SPRING', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'PO BOX ONLY'),
(9413, '22834', '+38.550848', '-078.876177', 'LINVILLE', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9414, '22835', '+38.645981', '-078.481288', 'LURAY', 'VA', 'VIRGINIA', 'PAGE', 'STANDARD'),
(9415, '22840', '+38.400968', '-078.734456', 'MC GAHEYSVILLE', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9416, '22841', '+38.347167', '-078.838654', 'MOUNT CRAWFORD', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9417, '22842', '+38.785693', '-078.680304', 'MOUNT JACKSON', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9418, '22843', '+38.325455', '-079.094228', 'MOUNT SOLON', 'VA', 'VIRGINIA', 'AUGUSTA', 'STANDARD'),
(9419, '22844', '+38.673777', '-078.677685', 'NEW MARKET', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9420, '22845', '+38.799978', '-078.810290', 'ORKNEY SPRINGS', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9421, '22846', '+38.375012', '-078.779540', 'PENN LAIRD', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9422, '22847', '+38.761208', '-078.712058', 'QUICKSBURG', 'VA', 'VIRGINIA', 'SHENANDOAH', 'STANDARD'),
(9423, '22848', '+38.384681', '-078.891422', 'PLEASANT VALLEY', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'PO BOX ONLY'),
(9424, '22849', '+38.525239', '-078.607184', 'SHENANDOAH', 'VA', 'VIRGINIA', 'PAGE', 'STANDARD'),
(9425, '22850', '+38.557430', '-078.922657', 'SINGERS GLEN', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9426, '22851', '+38.559864', '-078.512018', 'STANLEY', 'VA', 'VIRGINIA', 'PAGE', 'STANDARD'),
(9427, '22853', '+38.639760', '-078.781566', 'TIMBERVILLE', 'VA', 'VIRGINIA', 'ROCKINGHAM', 'STANDARD'),
(9428, '22901', '+38.093604', '-078.561139', 'CHARLOTTESVILLE', 'VA', 'VIRGINIA', 'ALBEMARLE', 'STANDARD'),
(9429, '22902', '+38.026588', '-078.480450', 'CHARLOTTESVILLE', 'VA', 'VIRGINIA', 'CHARLOTTESVILLE CITY', 'STANDARD'),
(9430, '22903', '+38.033938', '-078.492384', 'CHARLOTTESVILLE', 'VA', 'VIRGINIA', 'CHARLOTTESVILLE CITY', 'STANDARD'),
(9431, '22904', '+38.040101', '-078.485066', 'CHARLOTTESVILLE', 'VA', 'VIRGINIA', 'CHARLOTTESVILLE CITY', 'STANDARD'),
(9432, '22905', '+38.040101', '-078.485066', 'CHARLOTTESVILLE', 'VA', 'VIRGINIA', 'CHARLOTTESVILLE CITY', 'STANDARD'),
(9433, '22906', '+38.040101', '-078.485066', 'CHARLOTTESVILLE', 'VA', 'VIRGINIA', 'CHARLOTTESVILLE CITY', 'STANDARD'),
(9434, '22907', '+38.040101', '-078.485066', 'CHARLOTTESVILLE', 'VA', 'VIRGINIA', 'CHARLOTTESVILLE CITY', 'UNIQUE'),
(9435, '22908', '+38.040101', '-078.485066', 'CHARLOTTESVILLE', 'VA', 'VIRGINIA', 'CHARLOTTESVILLE CITY', 'UNIQUE'),
(9436, '22909', '+38.024474', '-078.448214', 'CHARLOTTESVILLE', 'VA', 'VIRGINIA', 'ALBEMARLE', 'UNIQUE'),
(9437, '22910', '+38.040101', '-078.485066', 'CHARLOTTESVILLE', 'VA', 'VIRGINIA', 'CHARLOTTESVILLE CITY', 'UNIQUE'),
(9438, '22911', '+38.099507', '-078.408498', 'CHARLOTTESVILLE', 'VA', 'VIRGINIA', 'ALBEMARLE', 'STANDARD'),
(9439, '22920', '+37.972758', '-078.822310', 'AFTON', 'VA', 'VIRGINIA', 'NELSON', 'STANDARD'),
(9440, '22922', '+37.690183', '-078.947944', 'ARRINGTON', 'VA', 'VIRGINIA', 'NELSON', 'STANDARD'),
(9441, '22923', '+38.209534', '-078.309759', 'BARBOURSVILLE', 'VA', 'VIRGINIA', 'ORANGE', 'STANDARD'),
(9442, '22924', '+38.001317', '-078.727146', 'BATESVILLE', 'VA', 'VIRGINIA', 'ALBEMARLE', 'PO BOX ONLY'),
(9443, '22931', '+37.893092', '-078.709897', 'COVESVILLE', 'VA', 'VIRGINIA', 'ALBEMARLE', 'STANDARD'),
(9444, '22932', '+38.129592', '-078.710635', 'CROZET', 'VA', 'VIRGINIA', 'ALBEMARLE', 'STANDARD'),
(9445, '22935', '+38.270529', '-078.557765', 'DYKE', 'VA', 'VIRGINIA', 'GREENE', 'STANDARD'),
(9446, '22936', '+38.166565', '-078.506832', 'EARLYSVILLE', 'VA', 'VIRGINIA', 'ALBEMARLE', 'STANDARD'),
(9447, '22937', '+37.820190', '-078.609661', 'ESMONT', 'VA', 'VIRGINIA', 'ALBEMARLE', 'STANDARD'),
(9448, '22938', '+37.859373', '-078.816071', 'FABER', 'VA', 'VIRGINIA', 'NELSON', 'STANDARD'),
(9449, '22939', '+38.096364', '-078.992950', 'FISHERSVILLE', 'VA', 'VIRGINIA', 'AUGUSTA', 'STANDARD'),
(9450, '22940', '+38.194421', '-078.584936', 'FREE UNION', 'VA', 'VIRGINIA', 'ALBEMARLE', 'STANDARD'),
(9451, '22942', '+38.175906', '-078.181467', 'GORDONSVILLE', 'VA', 'VIRGINIA', 'ORANGE', 'STANDARD'),
(9452, '22943', '+38.078772', '-078.521957', 'GREENWOOD', 'VA', 'VIRGINIA', 'ALBEMARLE', 'STANDARD'),
(9453, '22945', '+38.065383', '-078.595831', 'IVY', 'VA', 'VIRGINIA', 'ALBEMARLE', 'PO BOX ONLY');
INSERT INTO `zipcodes` (`id`, `zip`, `latitude`, `longitude`, `city`, `state`, `fullstate`, `county`, `zipclass`) VALUES
(9454, '22946', '+37.850141', '-078.541911', 'KEENE', 'VA', 'VIRGINIA', 'ALBEMARLE', 'STANDARD'),
(9455, '22947', '+38.053137', '-078.339571', 'KESWICK', 'VA', 'VIRGINIA', 'ALBEMARLE', 'STANDARD'),
(9456, '22948', '+38.428509', '-078.267848', 'LOCUST DALE', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9457, '22949', '+37.753000', '-078.859153', 'LOVINGSTON', 'VA', 'VIRGINIA', 'NELSON', 'STANDARD'),
(9458, '22952', '+37.974432', '-078.936098', 'LYNDHURST', 'VA', 'VIRGINIA', 'AUGUSTA', 'STANDARD'),
(9459, '22953', '+38.428509', '-078.267848', 'MADISON MILLS', 'VA', 'VIRGINIA', 'MADISON', 'PO BOX ONLY'),
(9460, '22954', '+37.789070', '-079.012459', 'MASSIES MILL', 'VA', 'VIRGINIA', 'NELSON', 'STANDARD'),
(9461, '22957', '+38.227020', '-078.176806', 'MONTPELIER STATION', 'VA', 'VIRGINIA', 'ORANGE', 'PO BOX ONLY'),
(9462, '22958', '+37.818439', '-078.893139', 'NELLYSFORD', 'VA', 'VIRGINIA', 'NELSON', 'STANDARD'),
(9463, '22959', '+37.933631', '-078.635110', 'NORTH GARDEN', 'VA', 'VIRGINIA', 'ALBEMARLE', 'STANDARD'),
(9464, '22960', '+38.219183', '-078.046093', 'ORANGE', 'VA', 'VIRGINIA', 'ORANGE', 'STANDARD'),
(9465, '22963', '+37.893119', '-078.338579', 'PALMYRA', 'VA', 'VIRGINIA', 'FLUVANNA', 'STANDARD'),
(9466, '22964', '+37.803604', '-078.959134', 'PINEY RIVER', 'VA', 'VIRGINIA', 'NELSON', 'STANDARD'),
(9467, '22965', '+38.330132', '-078.475018', 'QUINQUE', 'VA', 'VIRGINIA', 'GREENE', 'PO BOX ONLY'),
(9468, '22967', '+37.824173', '-078.962522', 'ROSELAND', 'VA', 'VIRGINIA', 'NELSON', 'STANDARD'),
(9469, '22968', '+38.258615', '-078.407377', 'RUCKERSVILLE', 'VA', 'VIRGINIA', 'GREENE', 'STANDARD'),
(9470, '22969', '+37.818031', '-078.819906', 'SCHUYLER', 'VA', 'VIRGINIA', 'NELSON', 'STANDARD'),
(9471, '22971', '+37.759956', '-078.810459', 'SHIPMAN', 'VA', 'VIRGINIA', 'NELSON', 'STANDARD'),
(9472, '22972', '+38.199692', '-078.239378', 'SOMERSET', 'VA', 'VIRGINIA', 'ORANGE', 'STANDARD'),
(9473, '22973', '+38.312057', '-078.482014', 'STANARDSVILLE', 'VA', 'VIRGINIA', 'GREENE', 'STANDARD'),
(9474, '22974', '+37.955910', '-078.276599', 'TROY', 'VA', 'VIRGINIA', 'FLUVANNA', 'STANDARD'),
(9475, '22976', '+37.839132', '-079.069321', 'TYRO', 'VA', 'VIRGINIA', 'NELSON', 'STANDARD'),
(9476, '22980', '+38.065794', '-078.903445', 'WAYNESBORO', 'VA', 'VIRGINIA', 'WAYNESBORO CITY', 'STANDARD'),
(9477, '22987', '+38.179859', '-078.618912', 'WHITE HALL', 'VA', 'VIRGINIA', 'ALBEMARLE', 'PO BOX ONLY'),
(9478, '22989', '+38.428509', '-078.267848', 'WOODBERRY FOREST', 'VA', 'VIRGINIA', 'MADISON', 'STANDARD'),
(9479, '23001', '+37.288220', '-076.426013', 'ACHILLES', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9480, '23002', '+37.342768', '-077.984092', 'AMELIA COURT HOUSE', 'VA', 'VIRGINIA', 'AMELIA', 'STANDARD'),
(9481, '23003', '+37.432335', '-076.601616', 'ARK', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9482, '23004', '+37.563225', '-078.536430', 'ARVONIA', 'VA', 'VIRGINIA', 'BUCKINGHAM', 'STANDARD'),
(9483, '23005', '+37.754912', '-077.480128', 'ASHLAND', 'VA', 'VIRGINIA', 'HANOVER', 'STANDARD'),
(9484, '23009', '+37.798833', '-077.180912', 'AYLETT', 'VA', 'VIRGINIA', 'KING WILLIAM', 'STANDARD'),
(9485, '23011', '+37.479524', '-076.949981', 'BARHAMSVILLE', 'VA', 'VIRGINIA', 'NEW KENT', 'STANDARD'),
(9486, '23014', '+37.733844', '-077.888082', 'BEAUMONT', 'VA', 'VIRGINIA', 'GOOCHLAND', 'STANDARD'),
(9487, '23015', '+37.914736', '-077.623410', 'BEAVERDAM', 'VA', 'VIRGINIA', 'HANOVER', 'STANDARD'),
(9488, '23017', '+37.418242', '-076.508402', 'BELLAMY', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9489, '23018', '+37.418242', '-076.508402', 'BENA', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9490, '23021', '+37.410286', '-076.294103', 'BOHANNON', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9491, '23022', '+37.848408', '-078.277393', 'BREMO BLUFF', 'VA', 'VIRGINIA', 'FLUVANNA', 'STANDARD'),
(9492, '23023', '+37.701823', '-076.916248', 'BRUINGTON', 'VA', 'VIRGINIA', 'KING AND QUEEN', 'STANDARD'),
(9493, '23024', '+37.907540', '-077.798047', 'BUMPASS', 'VA', 'VIRGINIA', 'LOUISA', 'STANDARD'),
(9494, '23025', '+37.410286', '-076.294103', 'CARDINAL', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9495, '23027', '+37.647940', '-078.138859', 'CARTERSVILLE', 'VA', 'VIRGINIA', 'CUMBERLAND', 'STANDARD'),
(9496, '23030', '+37.354115', '-077.073103', 'CHARLES CITY', 'VA', 'VIRGINIA', 'CHARLES CITY', 'STANDARD'),
(9497, '23031', '+37.598391', '-076.447551', 'CHRISTCHURCH', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9498, '23032', '+37.644319', '-076.446001', 'CHURCH VIEW', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9499, '23035', '+37.410286', '-076.294103', 'COBBS CREEK', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9500, '23038', '+37.807863', '-078.093506', 'COLUMBIA', 'VA', 'VIRGINIA', 'GOOCHLAND', 'STANDARD'),
(9501, '23039', '+37.657031', '-077.794731', 'CROZIER', 'VA', 'VIRGINIA', 'GOOCHLAND', 'STANDARD'),
(9502, '23040', '+37.518167', '-078.214232', 'CUMBERLAND', 'VA', 'VIRGINIA', 'CUMBERLAND', 'STANDARD'),
(9503, '23043', '+37.551856', '-076.366544', 'DELTAVILLE', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9504, '23045', '+37.410286', '-076.294103', 'DIGGS', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9505, '23047', '+37.846874', '-077.513156', 'DOSWELL', 'VA', 'VIRGINIA', 'HANOVER', 'STANDARD'),
(9506, '23050', '+37.500094', '-076.454046', 'DUTTON', 'VA', 'VIRGINIA', 'GLOUCESTER', 'STANDARD'),
(9507, '23054', '+37.733844', '-077.888082', 'FIFE', 'VA', 'VIRGINIA', 'GOOCHLAND', 'PO BOX ONLY'),
(9508, '23055', '+37.848408', '-078.277393', 'FORK UNION', 'VA', 'VIRGINIA', 'FLUVANNA', 'STANDARD'),
(9509, '23056', '+37.410286', '-076.294103', 'FOSTER', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9510, '23058', '+37.531296', '-077.416103', 'GLEN ALLEN', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9511, '23059', '+37.728404', '-077.554393', 'GLEN ALLEN', 'VA', 'VIRGINIA', 'HANOVER', 'STANDARD'),
(9512, '23060', '+37.595064', '-077.508719', 'GLEN ALLEN', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9513, '23061', '+37.412590', '-076.546416', 'GLOUCESTER', 'VA', 'VIRGINIA', 'GLOUCESTER', 'STANDARD'),
(9514, '23062', '+37.277726', '-076.499880', 'GLOUCESTER POINT', 'VA', 'VIRGINIA', 'GLOUCESTER', 'STANDARD'),
(9515, '23063', '+37.725416', '-077.995000', 'GOOCHLAND', 'VA', 'VIRGINIA', 'GOOCHLAND', 'STANDARD'),
(9516, '23064', '+37.410286', '-076.294103', 'GRIMSTEAD', 'VA', 'VIRGINIA', 'MATHEWS', 'PO BOX ONLY'),
(9517, '23065', '+37.798243', '-077.937457', 'GUM SPRING', 'VA', 'VIRGINIA', 'GOOCHLAND', 'STANDARD'),
(9518, '23066', '+37.410286', '-076.294103', 'GWYNN', 'VA', 'VIRGINIA', 'MATHEWS', 'PO BOX ONLY'),
(9519, '23067', '+37.825208', '-077.989878', 'HADENSVILLE', 'VA', 'VIRGINIA', 'GOOCHLAND', 'PO BOX ONLY'),
(9520, '23068', '+37.410286', '-076.294103', 'HALLIEFORD', 'VA', 'VIRGINIA', 'MATHEWS', 'PO BOX ONLY'),
(9521, '23069', '+37.735448', '-077.337944', 'HANOVER', 'VA', 'VIRGINIA', 'HANOVER', 'STANDARD'),
(9522, '23070', '+37.551180', '-076.384428', 'HARDYVILLE', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9523, '23071', '+37.541289', '-076.415200', 'HARTFIELD', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9524, '23072', '+37.391501', '-076.514807', 'HAYES', 'VA', 'VIRGINIA', 'GLOUCESTER', 'STANDARD'),
(9525, '23075', '+37.545511', '-077.317838', 'HIGHLAND SPRINGS', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9526, '23076', '+37.410286', '-076.294103', 'HUDGINS', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9527, '23079', '+37.644319', '-076.446001', 'JAMAICA', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9528, '23081', '+37.223482', '-076.783317', 'JAMESTOWN', 'VA', 'VIRGINIA', 'JAMES CITY', 'STANDARD'),
(9529, '23083', '+37.322156', '-078.121631', 'JETERSVILLE', 'VA', 'VIRGINIA', 'AMELIA', 'STANDARD'),
(9530, '23084', '+37.848408', '-078.277393', 'KENTS STORE', 'VA', 'VIRGINIA', 'FLUVANNA', 'STANDARD'),
(9531, '23085', '+37.701823', '-076.916248', 'KING AND QUEEN COURT HOUS', 'VA', 'VIRGINIA', 'KING AND QUEEN', 'STANDARD'),
(9532, '23086', '+37.677991', '-077.028495', 'KING WILLIAM', 'VA', 'VIRGINIA', 'KING WILLIAM', 'STANDARD'),
(9533, '23089', '+37.465312', '-076.909711', 'LANEXA', 'VA', 'VIRGINIA', 'NEW KENT', 'STANDARD'),
(9534, '23090', '+37.235892', '-076.445567', 'LIGHTFOOT', 'VA', 'VIRGINIA', 'YORK', 'PO BOX ONLY'),
(9535, '23091', '+37.617747', '-076.771273', 'LITTLE PLYMOUTH', 'VA', 'VIRGINIA', 'KING AND QUEEN', 'STANDARD'),
(9536, '23092', '+37.582554', '-076.498426', 'LOCUST HILL', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9537, '23093', '+37.998422', '-077.967416', 'LOUISA', 'VA', 'VIRGINIA', 'LOUISA', 'STANDARD'),
(9538, '23101', '+37.553314', '-077.892964', 'MACON', 'VA', 'VIRGINIA', 'POWHATAN', 'PO BOX ONLY'),
(9539, '23102', '+37.694226', '-077.796603', 'MAIDENS', 'VA', 'VIRGINIA', 'GOOCHLAND', 'STANDARD'),
(9540, '23103', '+37.663224', '-077.791971', 'MANAKIN SABOT', 'VA', 'VIRGINIA', 'GOOCHLAND', 'STANDARD'),
(9541, '23105', '+37.345032', '-077.944868', 'MANNBORO', 'VA', 'VIRGINIA', 'AMELIA', 'PO BOX ONLY'),
(9542, '23106', '+37.733093', '-077.206868', 'MANQUIN', 'VA', 'VIRGINIA', 'KING WILLIAM', 'STANDARD'),
(9543, '23107', '+37.286410', '-076.404783', 'MARYUS', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9544, '23108', '+37.701823', '-076.916248', 'MASCOT', 'VA', 'VIRGINIA', 'KING AND QUEEN', 'STANDARD'),
(9545, '23109', '+37.410286', '-076.294103', 'MATHEWS', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9546, '23110', '+37.613475', '-076.810087', 'MATTAPONI', 'VA', 'VIRGINIA', 'KING AND QUEEN', 'STANDARD'),
(9547, '23111', '+37.628179', '-077.281955', 'MECHANICSVILLE', 'VA', 'VIRGINIA', 'HANOVER', 'STANDARD'),
(9548, '23112', '+37.454138', '-077.662580', 'MIDLOTHIAN', 'VA', 'VIRGINIA', 'CHESTERFIELD', 'STANDARD'),
(9549, '23113', '+37.494897', '-077.663061', 'MIDLOTHIAN', 'VA', 'VIRGINIA', 'CHESTERFIELD', 'STANDARD'),
(9550, '23114', '', '', 'MIDLOTHIAN', 'VA', 'VIRGINIA', 'CHESTERFIELD', 'STANDARD'),
(9551, '23115', '+37.836374', '-076.913844', 'MILLERS TAVERN', 'VA', 'VIRGINIA', 'ESSEX', 'PO BOX ONLY'),
(9552, '23116', '+37.669086', '-077.329421', 'MECHANICSVILLE', 'VA', 'VIRGINIA', 'HANOVER', 'STANDARD'),
(9553, '23117', '+37.937619', '-077.868959', 'MINERAL', 'VA', 'VIRGINIA', 'LOUISA', 'STANDARD'),
(9554, '23119', '+37.410286', '-076.294103', 'MOON', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9555, '23120', '+37.416066', '-077.779015', 'MOSELEY', 'VA', 'VIRGINIA', 'CHESTERFIELD', 'STANDARD'),
(9556, '23123', '+37.563225', '-078.536430', 'NEW CANTON', 'VA', 'VIRGINIA', 'BUCKINGHAM', 'STANDARD'),
(9557, '23124', '+37.535579', '-077.005863', 'NEW KENT', 'VA', 'VIRGINIA', 'NEW KENT', 'STANDARD'),
(9558, '23125', '+37.343785', '-076.287792', 'NEW POINT', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9559, '23126', '+37.701823', '-076.916248', 'NEWTOWN', 'VA', 'VIRGINIA', 'KING AND QUEEN', 'STANDARD'),
(9560, '23127', '+37.310451', '-076.746769', 'NORGE', 'VA', 'VIRGINIA', 'JAMES CITY', 'PO BOX ONLY'),
(9561, '23128', '+37.410286', '-076.294103', 'NORTH', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9562, '23129', '+37.701136', '-077.790584', 'OILVILLE', 'VA', 'VIRGINIA', 'GOOCHLAND', 'STANDARD'),
(9563, '23130', '+37.410286', '-076.294103', 'ONEMO', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9564, '23131', '+37.312159', '-076.518831', 'ORDINARY', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9565, '23138', '+37.355641', '-076.292253', 'PORT HAYWOOD', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9566, '23139', '+37.541609', '-077.928759', 'POWHATAN', 'VA', 'VIRGINIA', 'POWHATAN', 'STANDARD'),
(9567, '23140', '+37.453467', '-077.033714', 'PROVIDENCE FORGE', 'VA', 'VIRGINIA', 'NEW KENT', 'STANDARD'),
(9568, '23141', '+37.518432', '-077.134289', 'QUINTON', 'VA', 'VIRGINIA', 'NEW KENT', 'STANDARD'),
(9569, '23146', '+37.739029', '-077.708072', 'ROCKVILLE', 'VA', 'VIRGINIA', 'HANOVER', 'STANDARD'),
(9570, '23147', '+37.379560', '-077.034752', 'RUTHVILLE', 'VA', 'VIRGINIA', 'CHARLES CITY', 'PO BOX ONLY'),
(9571, '23148', '+37.753427', '-077.047727', 'SAINT STEPHENS CHURCH', 'VA', 'VIRGINIA', 'KING AND QUEEN', 'STANDARD'),
(9572, '23149', '+37.644319', '-076.446001', 'SALUDA', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9573, '23150', '+37.501495', '-077.271789', 'SANDSTON', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9574, '23153', '+37.779913', '-077.940549', 'SANDY HOOK', 'VA', 'VIRGINIA', 'GOOCHLAND', 'STANDARD'),
(9575, '23154', '+37.418242', '-076.508402', 'SCHLEY', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9576, '23155', '+37.418242', '-076.508402', 'SEVERN', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9577, '23156', '+37.544151', '-076.684306', 'SHACKLEFORDS', 'VA', 'VIRGINIA', 'KING AND QUEEN', 'STANDARD'),
(9578, '23160', '+37.733844', '-077.888082', 'STATE FARM', 'VA', 'VIRGINIA', 'GOOCHLAND', 'STANDARD'),
(9579, '23161', '+37.701823', '-076.916248', 'STEVENSVILLE', 'VA', 'VIRGINIA', 'KING AND QUEEN', 'STANDARD'),
(9580, '23162', '+37.772187', '-077.452640', 'STUDLEY', 'VA', 'VIRGINIA', 'HANOVER', 'PO BOX ONLY'),
(9581, '23163', '+37.350792', '-076.316136', 'SUSAN', 'VA', 'VIRGINIA', 'MATHEWS', 'STANDARD'),
(9582, '23168', '+37.394138', '-076.835415', 'TOANO', 'VA', 'VIRGINIA', 'JAMES CITY', 'STANDARD'),
(9583, '23169', '+37.644319', '-076.446001', 'TOPPING', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9584, '23170', '+37.940788', '-077.996956', 'TREVILIANS', 'VA', 'VIRGINIA', 'LOUISA', 'STANDARD'),
(9585, '23173', '+37.524246', '-077.493157', 'UNIVERSITY OF RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9586, '23175', '+37.635564', '-076.591805', 'URBANNA', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9587, '23176', '+37.644319', '-076.446001', 'WAKE', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9588, '23177', '+37.701823', '-076.916248', 'WALKERTON', 'VA', 'VIRGINIA', 'KING AND QUEEN', 'STANDARD'),
(9589, '23178', '+37.400387', '-076.452896', 'WARE NECK', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9590, '23180', '+37.725161', '-076.613446', 'WATER VIEW', 'VA', 'VIRGINIA', 'MIDDLESEX', 'STANDARD'),
(9591, '23181', '+37.607215', '-076.891642', 'WEST POINT', 'VA', 'VIRGINIA', 'KING WILLIAM', 'STANDARD'),
(9592, '23183', '+37.363201', '-076.532492', 'WHITE MARSH', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9593, '23184', '+37.322121', '-076.531850', 'WICOMICO', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9594, '23185', '+37.273209', '-076.732423', 'WILLIAMSBURG', 'VA', 'VIRGINIA', 'JAMES CITY', 'STANDARD'),
(9595, '23186', '+37.310451', '-076.746769', 'WILLIAMSBURG', 'VA', 'VIRGINIA', 'WILLIAMSBURG CITY', 'UNIQUE'),
(9596, '23187', '+37.310451', '-076.746769', 'WILLIAMSBURG', 'VA', 'VIRGINIA', 'WILLIAMSBURG CITY', 'STANDARD'),
(9597, '23188', '+37.348220', '-076.773832', 'WILLIAMSBURG', 'VA', 'VIRGINIA', 'JAMES CITY', 'STANDARD'),
(9598, '23190', '+37.482039', '-076.636154', 'WOODS CROSS ROADS', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9599, '23191', '+37.418242', '-076.508402', 'ZANONI', 'VA', 'VIRGINIA', 'GLOUCESTER', 'PO BOX ONLY'),
(9600, '23192', '+37.820707', '-077.651831', 'MONTPELIER', 'VA', 'VIRGINIA', 'HANOVER', 'STANDARD'),
(9601, '23218', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9602, '23219', '+37.541696', '-077.439204', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9603, '23220', '+37.552746', '-077.456602', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9604, '23221', '+37.553196', '-077.489706', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9605, '23222', '+37.568861', '-077.428004', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9606, '23223', '+37.533246', '-077.431054', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9607, '23224', '+37.497796', '-077.467260', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9608, '23225', '+37.519396', '-077.500757', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9609, '23226', '+37.587223', '-077.518407', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9610, '23227', '+37.624700', '-077.435149', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9611, '23228', '+37.624988', '-077.495920', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9612, '23229', '+37.595695', '-077.570359', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9613, '23230', '+37.592095', '-077.495206', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9614, '23231', '+37.457072', '-077.307326', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9615, '23232', '+37.520187', '-077.408359', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9616, '23233', '+37.615276', '-077.576641', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9617, '23234', '+37.437320', '-077.478825', 'RICHMOND', 'VA', 'VIRGINIA', 'CHESTERFIELD', 'STANDARD'),
(9618, '23235', '+37.494147', '-077.556501', 'RICHMOND', 'VA', 'VIRGINIA', 'CHESTERFIELD', 'STANDARD'),
(9619, '23236', '+37.466359', '-077.590818', 'RICHMOND', 'VA', 'VIRGINIA', 'CHESTERFIELD', 'STANDARD'),
(9620, '23237', '+37.400822', '-077.471206', 'RICHMOND', 'VA', 'VIRGINIA', 'CHESTERFIELD', 'STANDARD'),
(9621, '23238', '+37.733844', '-077.888082', 'RICHMOND', 'VA', 'VIRGINIA', 'GOOCHLAND', 'STANDARD'),
(9622, '23240', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9623, '23241', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9624, '23242', '+37.531296', '-077.416103', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9625, '23249', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9626, '23250', '+37.507498', '-077.332916', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9627, '23255', '+37.531296', '-077.416103', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9628, '23260', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9629, '23261', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9630, '23266', '+37.567896', '-077.528308', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9631, '23269', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9632, '23270', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9633, '23272', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9634, '23273', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9635, '23274', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9636, '23275', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9637, '23276', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9638, '23278', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9639, '23279', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9640, '23280', '+37.637622', '-077.468360', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'UNIQUE'),
(9641, '23282', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9642, '23284', '+37.549446', '-077.451155', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9643, '23285', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9644, '23286', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9645, '23288', '+37.531296', '-077.416103', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'UNIQUE'),
(9646, '23289', '+37.531296', '-077.416103', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'UNIQUE'),
(9647, '23290', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9648, '23291', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9649, '23292', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9650, '23293', '+37.524246', '-077.493157', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9651, '23294', '+37.628657', '-077.542871', 'RICHMOND', 'VA', 'VIRGINIA', 'HENRICO', 'STANDARD'),
(9652, '23295', '', '', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'UNIQUE'),
(9653, '23297', '+37.389721', '-077.561266', 'RICHMOND', 'VA', 'VIRGINIA', 'CHESTERFIELD', 'UNIQUE'),
(9654, '23298', '+37.540646', '-077.431555', 'RICHMOND', 'VA', 'VIRGINIA', 'RICHMOND CITY', 'STANDARD'),
(9655, '23301', '+37.712919', '-075.661132', 'ACCOMAC', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9656, '23302', '+37.865814', '-075.527697', 'ASSAWOMAN', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9657, '23303', '+37.896797', '-075.520581', 'ATLANTIC', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9658, '23304', '+36.989766', '-076.572291', 'BATTERY PARK', 'VA', 'VIRGINIA', 'ISLE OF WIGHT', 'PO BOX ONLY'),
(9659, '23306', '+37.567852', '-075.858617', 'BELLE HAVEN', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9660, '23307', '+37.432247', '-075.880425', 'BIRDSNEST', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'STANDARD'),
(9661, '23308', '+37.823569', '-075.615138', 'BLOXOM', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9662, '23310', '+37.259125', '-075.961975', 'CAPE CHARLES', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'STANDARD'),
(9663, '23313', '+37.201937', '-075.952409', 'CAPEVILLE', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(9664, '23314', '+36.956505', '-076.542783', 'CARROLLTON', 'VA', 'VIRGINIA', 'ISLE OF WIGHT', 'STANDARD'),
(9665, '23315', '+36.732820', '-076.830545', 'CARRSVILLE', 'VA', 'VIRGINIA', 'ISLE OF WIGHT', 'STANDARD'),
(9666, '23316', '+37.294283', '-075.961858', 'CHERITON', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(9667, '23320', '+36.749991', '-076.218759', 'CHESAPEAKE', 'VA', 'VIRGINIA', 'CHESAPEAKE CITY', 'STANDARD'),
(9668, '23321', '+36.781942', '-076.325762', 'CHESAPEAKE', 'VA', 'VIRGINIA', 'CHESAPEAKE CITY', 'STANDARD'),
(9669, '23322', '+36.643400', '-076.242010', 'CHESAPEAKE', 'VA', 'VIRGINIA', 'CHESAPEAKE CITY', 'STANDARD'),
(9670, '23323', '+36.710949', '-076.339913', 'CHESAPEAKE', 'VA', 'VIRGINIA', 'CHESAPEAKE CITY', 'STANDARD'),
(9671, '23324', '+36.802097', '-076.273934', 'CHESAPEAKE', 'VA', 'VIRGINIA', 'CHESAPEAKE CITY', 'STANDARD'),
(9672, '23325', '+36.792020', '-076.238560', 'CHESAPEAKE', 'VA', 'VIRGINIA', 'CHESAPEAKE CITY', 'STANDARD'),
(9673, '23326', '+36.777015', '-076.239417', 'CHESAPEAKE', 'VA', 'VIRGINIA', 'CHESAPEAKE CITY', 'UNIQUE'),
(9674, '23327', '+36.708500', '-076.278531', 'CHESAPEAKE', 'VA', 'VIRGINIA', 'CHESAPEAKE CITY', 'STANDARD'),
(9675, '23328', '+36.708500', '-076.278531', 'CHESAPEAKE', 'VA', 'VIRGINIA', 'CHESAPEAKE CITY', 'STANDARD'),
(9676, '23336', '+37.948723', '-075.436285', 'CHINCOTEAGUE ISLAND', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9677, '23337', '+37.918556', '-075.490518', 'WALLOPS ISLAND', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9678, '23341', '+37.577292', '-075.864607', 'CRADDOCKVILLE', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9679, '23345', '+37.738248', '-075.701449', 'DAVIS WHARF', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9680, '23347', '+37.356057', '-075.964939', 'EASTVILLE', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(9681, '23350', '+37.376126', '-075.882344', 'EXMORE', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'STANDARD'),
(9682, '23354', '+37.458837', '-075.900724', 'FRANKTOWN', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'STANDARD'),
(9683, '23356', '+37.999789', '-075.413184', 'GREENBACKVILLE', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9684, '23357', '+37.750487', '-075.667040', 'GREENBUSH', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9685, '23358', '+37.639252', '-075.865009', 'HACKSNECK', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9686, '23359', '+37.883709', '-075.604063', 'HALLWOOD', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9687, '23389', '+37.656158', '-075.848807', 'HARBORTON', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9688, '23395', '+37.975567', '-075.479748', 'HORNTOWN', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9689, '23396', '+37.923682', '-075.555142', 'OAK HALL', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9690, '23397', '+36.898915', '-076.687745', 'ISLE OF WIGHT', 'VA', 'VIRGINIA', 'ISLE OF WIGHT', 'PO BOX ONLY'),
(9691, '23398', '+37.534336', '-075.877052', 'JAMESVILLE', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(9692, '23399', '+37.916218', '-075.616754', 'JENKINS BRIDGE', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9693, '23401', '+37.596576', '-075.789256', 'KELLER', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9694, '23404', '+37.677193', '-075.672604', 'LOCUSTVILLE', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9695, '23405', '+37.413281', '-075.921330', 'MACHIPONGO', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'STANDARD'),
(9696, '23407', '+37.838898', '-075.563439', 'MAPPSVILLE', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9697, '23408', '+37.424497', '-075.877143', 'MARIONVILLE', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(9698, '23409', '+37.844421', '-075.611577', 'MEARS', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9699, '23410', '+37.603823', '-075.757820', 'MELFA', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9700, '23412', '+37.790415', '-075.603470', 'MODEST TOWN', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9701, '23413', '+37.469454', '-075.879019', 'NASSAWADOX', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(9702, '23414', '+37.816896', '-075.583227', 'NELSONIA', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9703, '23415', '+37.928070', '-075.526526', 'NEW CHURCH', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9704, '23416', '+37.922866', '-075.538591', 'OAK HALL', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9705, '23417', '+37.693197', '-075.746000', 'ONANCOCK', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9706, '23418', '+37.796421', '-075.650275', 'ONLEY', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9707, '23419', '+37.307411', '-075.926877', 'OYSTER', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(9708, '23420', '+37.590810', '-075.832274', 'PAINTER', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9709, '23421', '+37.840771', '-075.633717', 'PARKSLEY', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9710, '23422', '+37.616183', '-075.791519', 'PUNGOTEAGUE', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9711, '23423', '+37.542324', '-075.741220', 'QUINBY', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9712, '23424', '+36.996881', '-076.564516', 'RESCUE', 'VA', 'VIRGINIA', 'ISLE OF WIGHT', 'PO BOX ONLY'),
(9713, '23426', '+37.922894', '-075.678111', 'SANFORD', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9714, '23427', '+37.926441', '-075.721978', 'SAXIS', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9715, '23429', '+37.271104', '-075.953608', 'SEAVIEW', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(9716, '23430', '+36.990826', '-076.661123', 'SMITHFIELD', 'VA', 'VIRGINIA', 'ISLE OF WIGHT', 'STANDARD'),
(9717, '23431', '+36.898915', '-076.687745', 'SMITHFIELD', 'VA', 'VIRGINIA', 'ISLE OF WIGHT', 'STANDARD'),
(9718, '23432', '+36.874916', '-076.553061', 'SUFFOLK', 'VA', 'VIRGINIA', 'SUFFOLK CITY', 'STANDARD'),
(9719, '23433', '+36.906100', '-076.493175', 'SUFFOLK', 'VA', 'VIRGINIA', 'SUFFOLK CITY', 'STANDARD'),
(9720, '23434', '+36.704592', '-076.636158', 'SUFFOLK', 'VA', 'VIRGINIA', 'SUFFOLK CITY', 'STANDARD'),
(9721, '23435', '+36.837412', '-076.477756', 'SUFFOLK', 'VA', 'VIRGINIA', 'SUFFOLK CITY', 'STANDARD'),
(9722, '23436', '+36.886856', '-076.523388', 'SUFFOLK', 'VA', 'VIRGINIA', 'SUFFOLK CITY', 'STANDARD'),
(9723, '23437', '+36.646717', '-076.796225', 'SUFFOLK', 'VA', 'VIRGINIA', 'SUFFOLK CITY', 'STANDARD'),
(9724, '23438', '+36.598524', '-076.710143', 'SUFFOLK', 'VA', 'VIRGINIA', 'SUFFOLK CITY', 'STANDARD'),
(9725, '23439', '+36.746101', '-076.665251', 'SUFFOLK', 'VA', 'VIRGINIA', 'SUFFOLK CITY', 'STANDARD'),
(9726, '23440', '+37.823118', '-075.994287', 'TANGIER', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9727, '23441', '+37.732288', '-075.677292', 'TASLEY', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9728, '23442', '+37.899545', '-075.580102', 'TEMPERANCEVILLE', 'VA', 'VIRGINIA', 'ACCOMACK', 'STANDARD'),
(9729, '23443', '+37.188217', '-075.969003', 'TOWNSEND', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(9730, '23450', '+36.844004', '-076.120360', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9731, '23451', '+36.856348', '-076.053568', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9732, '23452', '+36.846147', '-076.097355', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9733, '23454', '+36.828586', '-076.070772', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9734, '23455', '+36.888865', '-076.146757', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9735, '23456', '+36.746599', '-076.039092', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9736, '23457', '+36.622351', '-076.024850', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9737, '23458', '+36.847388', '-076.155810', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9738, '23459', '+36.924496', '-076.018703', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9739, '23460', '+36.837598', '-076.026053', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9740, '23461', '+36.790249', '-076.002552', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9741, '23462', '+36.837052', '-076.146692', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9742, '23463', '+36.795669', '-076.012628', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9743, '23464', '+36.799473', '-076.178375', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9744, '23465', '+36.851243', '-076.169215', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'UNIQUE'),
(9745, '23466', '+36.795669', '-076.012628', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9746, '23467', '+36.795669', '-076.012628', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9747, '23468', '+36.843948', '-076.142407', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'UNIQUE'),
(9748, '23471', '+36.795669', '-076.012628', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'STANDARD'),
(9749, '23479', '+36.795669', '-076.012628', 'VIRGINIA BEACH', 'VA', 'VIRGINIA', 'VIRGINIA BEACH CITY', 'UNIQUE'),
(9750, '23480', '+37.604378', '-075.692465', 'WACHAPREAGUE', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9751, '23482', '+37.273986', '-075.869130', 'WARDTOWN', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(9752, '23483', '+37.943726', '-075.502306', 'WATTSVILLE', 'VA', 'VIRGINIA', 'ACCOMACK', 'PO BOX ONLY'),
(9753, '23486', '+37.518917', '-075.810482', 'WILLIS WHARF', 'VA', 'VIRGINIA', 'NORTHAMPTON', 'PO BOX ONLY'),
(9754, '23487', '+36.845054', '-076.713731', 'WINDSOR